var infobarwp;

( function ( $ ) {
	infobarwp = {
		init: function(){
			this.plugins.init();
			this.addons.init();

		},
		plugins : {
			init : function(){
				this.selects();
				this.datepickers();
				this.presetsPicker();
				this.colorpickers('.saved-variant');
			},

			presetsPicker : function(){
				var _presets;
				$(document).on('click', '.presets-picker', function(e){
					e.preventDefault();
				    $.fancybox({
				    	href : '#pressets-container',
				    	maxWidth : 800,
				    	maxHeight : 800,
				    	minHeight : 600,

				    	beforeLoad : function(){
				    		_presetsList = $('#presets-list');
				    		if( !_presetsList.hasClass('loaded') ){
					    		$.ajax({
					    			url: '//infobarwp.com/?presets=upgrade',
					    			//url: 'http://diascodes.labs/presets.php',
					    			type: 'GET',
					    			dataType: 'json',
					    			cache : false
					    		})
					    		.done(function(data) {
					    			_presets = data;
					    			for (var i = 0; i < data.presets.length; i++) {
					    				_item = data.presets[i];
					    				_preset = '<li class="preset-wrap bar-demo" data-gradient="'+_item.configuration.gradient+'" data-textcolor="'+_item.configuration.textcolor+'" data-linkscolor="'+_item.configuration.linkscolor+'" data-bordercolor="'+_item.configuration.bordercolor+'" data-borderwidth="'+_item.configuration.borderwidth+'" id="preset-'+ _item.id +'"><div class="content">';
					    				_preset += _item.configuration.content;
					    				_preset += '</div><span class="close">'+_item.configuration.closebtn+'</span></li>';
					    				$(_preset).appendTo(_presetsList);
					    				$('<span id="preset-gradient-'+ _item.id+'" class="hidden" />').appendTo('body');
										$('#preset-gradient-'+ _item.id).ClassyGradient({
											gradient: _item.configuration.gradient,
											target: '#preset-'+ _item.id
										});

										_currPreset = $('#preset-'+ _item.id);

										//_currPreset.append( _item.configuration.closebtn );

										_currPreset.css({
											'border-bottom-color' : _currPreset.attr('data-bordercolor'),
											'border-bottom-width' : _currPreset.attr('data-borderwidth'),
										});

										$('#preset-'+ _item.id+' p').css('color' , _currPreset.attr('data-textcolor'));
										$('#preset-'+ _item.id+' .normal-link').css('color' , _currPreset.attr('data-linkscolor'));


					    			};
					    			_presetsList.addClass('loaded');
					    		}); 	
				    		}
				    	}
				    });
				});

				$(document).on('click', '.preset-wrap', function(e){
					_textcolor = $(this).attr('data-textcolor'),
					_linkscolor = $(this).attr('data-linkscolor'),
					_bordercolor = $(this).attr('data-bordercolor'),
					_borderwidth = $(this).attr('data-borderwidth'),
					_gradient = $(this).attr('data-gradient'),
					_currVariant = $('.variant-wrap.current'),
					_closebtn = _currVariant.find('span.close');

					//var r = confirm("Are you sure? this will erase your current work!");

					//if (r == true) {
						_index = _currVariant.attr('data-index');
						_gradientsWrap = _currVariant.find('.gradients');

						$('input[name="variants['+_index+'][gradient]"]').val(_gradient);
						$('input[name="variants['+_index+'][text-color]"]').val(_textcolor);
						$('input[name="variants['+_index+'][link-color]"]').val(_linkscolor);
						$('input[name="variants['+_index+'][border-color]"]').val(_bordercolor);
						$('input[name="variants['+_index+'][border-width]"]').val(_borderwidth);
						$('select[name="variants['+_index+'][skins]"]').val('26').trigger('change');
						$('textarea[name="variants['+_index+'][closebtn]"]').val( $(this).children('.close').html() ).trigger('change');

						_gradientsWrap.data('ClassyGradient').settings.gradient = _gradient;
						_gradientsWrap.data('ClassyGradient').update();

						_currVariant.find('.bar-demo').css({
							'border-bottom-color' : _bordercolor,
							'border-bottom-width' : _borderwidth,
						});

						_closebtn.html( $(this).children('.close').html() );
						

						_currVariant.find('.message-editable').html( $(this).find('.content').html() ).trigger('change');

						$.fancybox.close();
					//}

					e.preventDefault();
				});
			},

			colorpickers : function(_domStart){
				$(_domStart + ' .pick-color').ColorPicker({
					color: '#0000ff',
					onShow: function (colpkr) {
						$(colpkr).fadeIn(500).css('z-index', 100);
						return false;
					},
					onChange: function(a, color) {
						_el = $(this).data('colorpicker').el,
						_targetName = $(_el).attr('name'),
						_target = $('input[name="'+_targetName+'"]');

						_target.css('background-color', '#'+color).val('#'+color);
						

						_variantWrap = _target.parents('.variant-wrap'),
						_editor = _variantWrap.find('.message-editable');

						if( _target.hasClass('style-text-color') ){
							_paragraphs = _editor.find('p'),
							_paragraphs.css( 'color', _target.val() );
							infobarwp.addons.livePreview.messageUpdater( _editor );
						}
						if( _target.hasClass('style-link-color') ){
							_links = _editor.find('.normal-link'),
							_links.css( 'color', _target.val() );
							infobarwp.addons.livePreview.messageUpdater( _editor );
						}
						if( _target.hasClass('style-border-color') ){
							_barDemo = _variantWrap.find('.bar-demo');
							_barDemo.attr('data-style-border-bottom-color', _target.val()).css('border-bottom-color', _target.val());
						}

					// $(document).on('change', '.style-link-color', function(){
					// 	_self = $(this),
					// 	_variantWrap = _self.parents('.variant-wrap'),
					// 	_barDemoLinks = _variantWrap.find('.bar-demo .content a');

					// 	_barDemoLinks.attr( 'data-style-color', _self.val() );
					// 	_this.setStyles(_barDemoLinks)
					// });

					// $(document).on('change', '.style-border-color', function(){
					// 	_self = $(this),
					// 	_variantWrap = _self.parents('.variant-wrap'),
					// 	_barDemo = _variantWrap.find('.bar-demo');

					// 	_barDemo.attr( 'data-style-border-bottom-color', _self.val() );
					// 	_this.setStyles(_barDemo)
					// });
					},
					onSubmit: function(hsb, hex, rgb, el) {
						$(el).css('background-color', '#'+hex).val('#'+hex).trigger('change');
						$(el).ColorPickerHide();
					},
					onBeforeShow: function () {
						$(this).ColorPickerSetColor(this.value);
					}
				}).bind('keyup', function(){
		          $(this).ColorPickerSetColor(this.value);
		      });
			},

			selects : function(_selector){
				_selector = ( typeof _selector == 'undefined' )? '.basic-select' : _selector;
				_selects = $(_selector);
				if( _selects.length > 0 ){
					_selects.sSelect({
						ddMaxHeight : 220
					});
				}
			},

			cssgradients : function(_el, index){
				_el = $(_el),
				_gradientsWrap = _el.find('.gradients'),
				_btngradientsWrap = _el.find('.btn-gradient'),
				_barDemo = _el.find('.bar-demo')

				_gradientsWrap.ClassyGradient({ // dria 1
					gradient: $('#gradient-values-'+index).val(),
					target: '#infobar-demo-'+index,
					onChange: function(stringGradient,cssGradient,gradientArray) {
						$('#gradient-values-'+index).val(stringGradient);
						$('#infobar-demo-'+index).attr('data-style-background', cssGradient);
						infobarwp.addons.livePreview.setStyles( $('#infobar-demo-'+index) );
					},
					onInit: function(stringGradient,cssGradient,gradientArray) {
						_infoB = $('#infobar-demo-'+index);
						if( _infoB.parents('.saved-variant').length > 0 ){
							_infoB.attr('style', _infoB.attr('data-oldstyle'));
						}
					}
				}); 

				_btngradientsWrap.ClassyGradient({ // dria 1
					gradient: $('#btn-gradient-values-'+index).val(),
					target: '#btn-preview-'+index+' .ibw-primary-btn',
					onChange: function(stringGradient,cssGradient,gradientArray) {
						$('#btn-gradient-values-'+index).val(stringGradient);
						$('#btn-preview-'+index+' .ibw-primary-btn').attr('data-style-background', cssGradient);
						infobarwp.addons.livePreview.setStyles( $('#btn-preview-'+index+' .ibw-primary-btn') );
					},
					onInit: function(stringGradient,cssGradient,gradientArray) {
					//$('#infobar_'+id).css($('#bgColor_'+id).val());
					}
				}); 

			},

			rangeSliders : function(_id){
				_sliders = $('.ranged-slider');
				_sliders.each(function(){
					_currParent = $(this).parents('.variant-wrap');
					$(this).slider({
						values: [10],
						min: 4,
						max: 40,
						slide: function(event, ui) {
						    // cssStuff['buttonPadding'] = ui.value/2 + "px " + ui.value + "px";
						    // reCenterButton();
						    // createCSS();
						}
					});
				})
			},

			datepickers : function(){
				var _calendars = $('.datepicker');
				if( _calendars.length > 0 ){
					_today = new Date();
					var _calendar = _calendars.datepicker({
										defaultDate: _today,
										changeMonth: true,
										numberOfMonths: 3,
										dateFormat: 'yy-mm-dd',
										minDate: _today,
										onSelect: function( selectedDate ) {
											var option = this.name == "start-date" ? "minDate" : "maxDate",
												instance = $( this ).data( "datepicker" ),
												date = $.datepicker.parseDate(
													instance.settings.dateFormat ||
													$.datepicker._defaults.dateFormat,
													selectedDate, instance.settings );
											_calendar.not( this ).datepicker( "option", option, date );
										}

									});
				}
			}			
		},
		addons : {
			init : function(){
				this.tabs();
				this.tooltips();
				this.changeStatus();
				this.multiSelects();
				this.variantsManager.init();
				this.livePreview.init();
				this.listingActions();
			},

			listingActions : function(){
				_trash = $('.trash-bar'), 
				_clone = $('.clone-bar'), 
				_clear = $('.clear-data'), 
				_inlineEditing = $('.quick-edit-bar'), 
				_cancelEditing = $('.inlineedit-wrap .cancel'),
				_saveEditing = $('.inlineedit-wrap .save');

				_trash.off('click').on('click', function(e){
					_self = $(this),
					_currItem = _self.parents('tr'),
					_dataID = _self.attr('data-id');
					e.preventDefault();
					var r = confirm("Are you sure?");

					if (r == true) {
						_currItem.fadeOut(400, function(){
							_currItem.remove();
							if( $('#the-list').find("tr").length === 0 ){
								$('#the-list').html('<tr class="no-items"><td class="colspanchange" colspan="6">No campaigns found.</td></tr>');
							}else{
							}
						});
						$.post(ajaxurl, { 'action' : 'ibwajax', 'ibw-action': 'remove-campaign', 'campaignid' : _dataID });

					}
				})

				_clone.off('click').on('click', function(e){
					_self = $(this),
					_dataID = _self.attr('data-id');
					e.preventDefault();
					var r = confirm("This action will create a copy of this campaign with all of it variants, do you really want to clone this campaign?");
					if (r == true) {
						
						$.post(ajaxurl, { 'action' : 'ibwajax', 'ibw-action': 'clone-campaign', 'campaignid' : _dataID }, function(data){
							if( data == 'ok' ){
								location.reload();
							}
						});

					}
				});

				_clear.off('click').on('click', function(e){
					_self = $(this),
					_dataID = _self.attr('data-id');
					e.preventDefault();
					var r = confirm("This action will clear all of the analytics data that is related to this campaign and it variants, do you really want to complete take this action ?");
					e.preventDefault();
					if (r == true) {
						$.post(ajaxurl, { 'action' : 'ibwajax', 'ibw-action': 'clear-analytics', 'campaignid' : _dataID }, function(data){
							if( data == 'ok' ){
								location.reload();
							}
						});	
					}
				})

				_inlineEditing.off('click').on('click', function(e){
					_self = $(this),
					_dataID = _self.attr('data-id'),
					_itemWrap = _self.parents('.item-wrap'),
					_inlineEditor = $('#inlineedit-'+_dataID);
					$('.inlineedit-wrap').hide();
					$('.item-wrap').show();
					e.preventDefault();
					_itemWrap.hide();
					_inlineEditor.fadeIn();
				});

				_cancelEditing.off('click').on('click', function(e){
					_self = $(this),
					_inlineEditWrap = _self.parents('.inlineedit-wrap'),
					_itemWrap = _inlineEditWrap.prev('.item-wrap');
					e.preventDefault();
					_itemWrap.fadeIn();
					_inlineEditWrap.hide();
				})

				_saveEditing.off('click').on('click', function(e){
					_self = $(this),
					_inlineEditWrap = _self.parents('.inlineedit-wrap'),
					_dataID = _inlineEditWrap.attr('data-id'),
					_itemWrap = _inlineEditWrap.prev('.item-wrap');
					_spinner = _inlineEditWrap.find('.spinner'),
					_cname = _inlineEditWrap.find('input[name="campaign-name-'+_dataID+'"]').val(),
					_cOnChange = _inlineEditWrap.find('.show-on-change-'+_dataID+':checked').val(),
					_cpos = _inlineEditWrap.find('input[name="campaign-position-'+_dataID+'"]').val(),
					_duration = _inlineEditWrap.find('input[name="campaign-show-before-'+_dataID+'"]').val(),
					_startdate = _inlineEditWrap.find('input[name="start-date-'+_dataID+'"]').val(),
					_enddate = _inlineEditWrap.find('input[name="end-date-'+_dataID+'"]').val(),
					_showafterhits = _inlineEditWrap.find('input[name="campaign-showafter-views-'+_dataID+'"]').val(),
					_spinner.addClass('is-active');
					_data = { 
							'action' : 'ibwajax',
							'ibw-action': 'inlineedit-campaign',
							'campaignid' : _dataID,
							'cname' : _cname,
							'conchange' : _cOnChange,
							'cpos' : _cpos,
							'duration' : _duration,
							'startdate' : _startdate,
							'enddate' : _enddate,
							'showafterhits' : _showafterhits
					}
					$.post(ajaxurl, _data, function(data){
						if( data == 'ok' ){
							_spinner.removeClass('is-active');
							_itemWrap.fadeIn();
							_inlineEditWrap.hide();
							location.reload();
						}
					});

					e.preventDefault();
				});

			},
			changeStatus : function(){
				_switcher = $('.switch-status input');
				if( _switcher.length > 0 ){
					_switcher.on('change', function(){
						_self = $(this),
						_id = _self.attr('data-id'),
						_loader = _self.siblings('.loader'),
						_status = _self.is(':checked')? 1 : 0;

						_loader.show();

						$.post(ajaxurl, { 'action' : 'ibwajax', 'ibw-action': 'campaign-status', 'status' : _status, 'id' : _id }, function(data, textStatus, xhr) {
							if( data == 'ok' ){
								_loader.hide();								
							}
						});
					})
				}
			},
			multiSelects : function(){
				_checkAll = $('check-all-siblings');

				$(document).on('click', '.check-all-siblings', function(e){
					_self = $(this),
					_checkbox = _self.find('input[type="checkbox"]').eq(0),
					_siblings = _self.siblings('.checkbox'),
					_val = _checkbox.is(':checked') ? true : false;
					
					_siblings.each(function(){
						_this = $(this),
						_check = _this.find('input[type="checkbox"]').eq(0);

						_check.prop('checked', _val).triggerHandler('click');
					})
				});

				$(document).on('click', '.ibw-collapse', function(e){
					_self = $(this),
					_dataStatus = _self.attr('data-status'),
					_entries = _self.next().find('.checkbox:not(.check-all-siblings)');

					if( _dataStatus == '0' ){
						_self.attr('class', 'ibw-collapse fa fa-angle-up');
						_self.attr('data-status', '1');
						_entries.css('display', 'block');
					}else{
						_self.attr('class', 'ibw-collapse fa fa-angle-down')
						_self.attr('data-status', '0');
						_entries.css('display', 'none');
					}
					e.preventDefault();
				});

				$('#campaign-location').on('change', function(e){
					_val = $(this).val(),
					_picked = $('#selected-'+_val);
					$('.campaign-location-picker').hide();
					if( _picked.length > 0 ){
						_picked.show();
					}
				});
			},

			tooltips : function(){
				_tooltip = $( '.tooltip-contain' );
				if( _tooltip.length > 0 ){
					$(document).on('click', '.tooltip-trigger', function(e){
						_self = $(this),
						_content = _self.siblings('.tooltip-wrap')
						e.preventDefault();
						if( _content.is(':hidden') ){
							$('.tooltip-wrap').removeClass('active');
							_content.addClass('active');
						}else{
							_content.removeClass('active');							
						}
					});


					$( 'html, body' ).click( function ( e ) {
						_target = $( e.target );
						if ( _target.parents( '.tooltip-contain' ).length < 1 && _target.parents('.colorpicker').length < 1 && _target.parents('.media-modal').length < 1 ) {
							$('.tooltip-wrap').removeClass('active');
						}
					} )
				}
			},

			tabs: function () {
				var _tabscontainer = $( '.tabs-container' );

				if ( _tabscontainer.length > 0 ) {
					$( document ).on('click', '.tab-trigger', function ( e ) {
						var _self = $( this );
						var _parentContainer = _self.parents( '.tabs-container' ),
							_tabsContents = _parentContainer.find('.tab-content');
						var _targetID = _self.attr( 'href' ),
							_targetEl = $( _self.attr( 'href' ) );

						_parentContainer.addClass( 'what' );

						e.preventDefault();

						if ( _targetEl.length && _targetEl.is( ':hidden' ) ) {

							_targetElID = _targetEl.attr( 'id' );
							_tabsContents.removeClass( 'current' );

							_parentContainer.find( '.tabs-nav a.current' ).removeClass( 'current' );
							_self.addClass( 'current' );
							_targetEl.addClass( 'current' );

						}
					} )
				}
			},

			variantsManager : {
				init: function(){
					this.showOnChecked();
					this.addVariant();
					this.savedVariant();
					this.rangedInputs();
					this.uploadsHandler();
				},

				showOnChecked : function(){
					_triggers = $('.show-on-change');
					if( _triggers.length > 0  ){
						$(document).on('change', '.show-on-change', function(e){
							_self = $(this),
							_target = _self.attr('data-target'),
							_requestedValue = _self.attr('data-value');
							if( _self.is(':checked') && parseInt(_self.val()) == parseInt(_requestedValue) ){
								$(_target).show().addClass('op-shows');
							}else if( this.nodeName == 'SELECT' && parseInt(_self.val()) == parseInt(_requestedValue) ){
								$(_target).show();
							}else{
								$(_target).hide().removeClass('op-shows');
							}
						})
					}

					$('input[name="campaign-onclose"]').on('change', function(e){
						_daysoff = $('#daysoff-container'),
						_pageview = $('#pageviews-container');

						if( $(this).val() == '0' ){
							$('.preview-contain span.close').html('<a style="background: #df3f2e;" href="#" class="btn btn-hide fa fa-times"></a>');
							$('.bar-options .minimize-icons').hide();
							$('.bar-options .close-icons').show();
							_daysoff.show();
							_pageview.hide();
						}else{
							$('.preview-contain span.close').html('<a style="background: #df3f2e;" href="#" class="btn btn-minimize fa fa-chevron-up"></a>');
							$('.bar-options .close-icons').hide();
							$('.bar-options .minimize-icons').show();
							_daysoff.hide();
							_pageview.show();
						}
					})
				},

				rangedInputs : function(){
					$(document).on('click', 'input[type="range"]', function(){
						_visualValue = $(this).siblings('.value');
						_visualValue.find('em').text( this.value );
					});
				},

				uploadsHandler : function( _update ){
					_update = typeof _update !== 'undefined' ? _update : false;
					var file_frame;
					$(document).on('click','.add_media',function(e){
						_self = $(this),
						_preview = _self.siblings('.image-preview'),
						_id = $(this).attr('data-index');

						e.preventDefault();

						if ( file_frame ) {
							file_frame.open();
							return;
						}

						file_frame = wp.media.frames.file_frame = wp.media({
										title: 'InfobarWP Media',
										multiple: false  
									});

						file_frame.on( 'select', function() {
							attachment = file_frame.state().get('selection').first().toJSON();
							_preview.html( '<a href="'+attachment.link+'" title="'+attachment.title+'"><img src="'+attachment.url+'" alt="'+attachment.alt+'" /></a>' );
						});

						file_frame.open();

					});
				},

				// uploadsHandler: function ( _update ) {
				// 	var _uploader = $('#media-uploader'),
				// 		_form = $('#ibw-uploads-form'),
				// 		_indexInput = $('#ibw-uploading-index');

				// 	_update = typeof _update !== 'undefined' ? _update : false;

				// 	if ( _update != false ) {
				// 		if ( _update.msg == 'ok' ) {
				// 			_form.siblings('.image-preview').html(_update.img);
				// 		}
				// 		return;
				// 	}

				// 	_form.attr('action', ajaxurl);

				// 	$(document).on('click', '.upload-media', function(e){
				// 		_self = $('this'),
				// 		_index = _self.attr('data-index');	

				// 		_form.insertBefore($(this).parent());

				// 		e.preventDefault();
				// 		_indexInput.attr('value', _index);
				// 		_uploader.trigger('click');
				// 	});

				// 	_uploader.on( 'change', function () {
				// 		var _self = $( this );
				// 		_form.trigger( 'submit' );
				// 	} );


				// 	$(document).on('change','custom-img .image-link', function(e){
				// 		_self = $(this),
				// 		_imgPreview = _self.parent().siblings('.image-preview');

				// 		_imgPreview.html( '<img class="image-el" src="'+_self.val()+'" alt="" />' );
				// 	})
				// },

				addVariant : function(){
					var _globals = $('#tabs-list').find('a[href="#global-settings"]'),
					_add = $('.add-variant'), _formTpl = $('#infobar-variants-tpl');
					if( _add.length > 0 ){
						_add.off('click').on('click', function(e){
							var _self = $(this),
								_parentLi = _self.parents('li'),
								_index = _parentLi.index();
							var _btn = $( '<li><a class="tab-trigger" href="#infobar-variant-'+_index+'" href="#">Infobar Variant '+_index+'</a></li>' ).insertBefore(_parentLi);
							$('<div />', {
								html : _formTpl.clone().html().replace(/{{index}}/g, _index),
								'class' : 'variant-wrap example tab-content',
								'id' : 'infobar-variant-'+_index,
								'data-text' : 'Infobar Variant '+_index,
								'data-index' : _index,
							}).appendTo('.tabs-container');
							if( $('input[name="campaign-onclose"]:checked').val() == '0' ){
								$('#infobar-variant-'+_index + 'span.close').html('<a style="background: #df3f2e;" href="#" class="btn btn-hide fa fa-times"></a>');
							}else{
								$('#infobar-variant-'+_index + 'span.close').html('<a style="background: #df3f2e;" href="#" class="btn btn-minimize fa fa-chevron-up"></a>');
							}
							$('.tab-trigger[href="#infobar-variant-'+_index+'"]').trigger('click');
							$('#infobar-variant-'+_index+' input[name="variants['+_index+'][variant-name]"]').trigger('focus');
							infobarwp.plugins.selects('.dom-select');
							infobarwp.plugins.colorpickers('#infobar-variant-'+_index);
							infobarwp.plugins.cssgradients('#infobar-variant-'+_index, _index);
							if( _index == 5 ){ 
								_self.hide();
							}
							e.preventDefault();
						})
					}

					$(document).on('click', 'input[name="remove-variant"]', function(e){
						_self = $(this);
						_currVariant = _self.parents('.variant-wrap'),
						_currTab = $('#tabs-list').find('a[href="#'+_currVariant.attr('id')+'"]').parent();
						e.preventDefault();

						var r = confirm("Are you sure?");

						if (r == true) {
							_globals.trigger('click');
							_currTab.remove();
							_currVariant.remove();

							if( _self.attr('data-id') ){
								$.post(ajaxurl, { 'action' : 'ibwajax', 'ibw-action': 'remove-variant', 'id' : _self.attr('data-id') });
							}
						}

					})
				},

				savedVariant : function(){
					_saved = $('.saved-variant');
					if( _saved.length > 0 ){
						_saved.each(function(){
							_index = $(this).attr('data-index');
							infobarwp.plugins.cssgradients('#infobar-variant-'+_index, _index);
						})
					}
				}
			},

			livePreview : {
				defaults : {
					backgrounds : [
						['Apple','0% #df3f2e,100% #b62618','#ffffff','#ffffff','#fff046'],
						['Coffee','0% #b04f00 ,100% #8f2200','#ffffff','#ffbb17','#ff8f17'],
						['Carnation','0% #f55696 ,100% #db1c6d','#610028','#ffffff','#ff90be'],
						['Dusk','0% #7191e1, 100% #b35ac3','#1a2836','#ffffff','#1a2836'],
						['Flare','0% #ffa800, 100% #ff4800','#FFFFFF','#ffe11a','#ffffff'],
						['Gold','0% #e9c500,100% #e28307','#512600','#ffffff','#ffffff'],
						['Green apple','0% #adff37 , 100% #5caa00','#004110','#ecff13','#004110'],
						['Green sea','0% #2ecc71 , 100% #27ae60','#00431c','#68fff6','#ffffff'],
						['Iceberg','0% #a5d6ff,100% #47b0e6','#005a8e','#ffffff','#ffffff'],
						['Midnight sky','0% #34495e, 100%  #2c3e50','#ffffff','#1abc9c','#1abc9c'],
						['Mint','0% #57bc50,100% #2eccb4 ','#004110','#ffffff','#004110'],
						['Lavender field','0% #9b59b6,100% #8e44ad','#ffffff','#feef4c','#ffffff'],
						['Paper','0% #ecf0f1, 100% #d2d2d2','#232323','#3498db','#34495e'],
						['Pavement','0% #95a5a6,100% #7f8c8d','#ffffff','#34495e','#ffffff'],
						['Pumpkin','0% #e67e22,100% #d35400','#ffffff','#fff046','#8a2700'],
						['Rosy','0% #bf0d0d, 100% #870000','#ffffff','#ff5959','#ff5959'],
						['Tropic Blue','0% #2980b9, 100% #3498db','#ffffff','#38dbf3','#38dbf3'],
						['Turquoise','0% #1abc9c,100% #16a085','#004538','#ffffff','#34495e'],
						['Twilight','0% #33485a,100% #122028','#FFFFFF','#6ebcee','#6ebcee'],
						['Yellow wood','0% #f1c40f,100% #f39c12','#232323','#ffffff','#c6440b'],
						['Green Charles','0% #43C81F,100% #97F73B','#004110','#E8E482','#ffffff'],
						['Hawai Earth','0% #42392A, 100% #C3A38C','#FFFFFF','#F9703F','#ffffff'],
						['Blueberry Yoghurt','0% #4F448B,100% #6D5FC0','#DECFB7','#FCF5C3','#ffffff'],
						['Pink Lady','0% #FF75A9, 100% #FEBFD0','#451f01','#FFFFFF','#ffffff'],
						['White Peace','0% #FFFFFF','#6B6B6B','#0099CC','#ffffff'],
						['Yellow Impact','0% #FFF500,100% #FFFF67','#363636','#192394','#ffffff']
					],

					buttons : [
						['Raspberry','0% #F1F1F1,100% #e6e6e6' ,'#000000','#F1F1F1'],
						['Primary','0% #08c,100% #04c','#FFFFFF','#4B546A'],
						['Carrot Shake','0% #5bc0de,100% #2f96b4','#FFFFFF','#359CBA'],
						['Mango Fun','0% #62c462,100% #51a351','#FFFFFF','#3BBB4A'],
						['Pasture','0% #fbb450,100% #f89406 ','#FFFFFF','#CE9A01 '],
						['Ripple','0% #ee5f5b,100% #bd362f','#FFFFFF','#D94545'],
						['Violet Haze','0% #444,100% #222','#FFFFFF','#222'],
						['Nebula','0% #ea4c89,100% #c93764','#FFFFFF','#D13C6D'],
						['Turquoise','0% #627EC7,100% #313C7A','#FFFFFF','#3C599B'],
						['Silver','0% #e64522,100% #c33219','#FFFFFF','#AC2D1E'],
						['Midnight blue','0% #009cda,100% #0073b2','#FFFFFF','#007BB6'],
						['Facebook ','0% #cb2027,100% #a0171c','#FFFFFF','#CA0705'],
						['Goolgeplus','0% #e88845,100% #e2733d','#FFFFFF','#D84524'],
						['Twitter','0% #3a5876,100% #2c4762','#FFFFFF','#2D4964'],
						['Linkedin','0% #00aced,100% #0081ce','#FFFFFF','#217DAE'],
					]
				},

				init : function(){
					this.generateSkin();
					this.generateButtons();
					this.messageEditor();
					this.changeHidingButtons();
					this.insertEmoticons();
					this.insertAnimatedIcons();
					this.insertForms();
					this.fontsChanger();
				},
				generateSkin : function(){
					_this = this,
					_backgrounds = _this.defaults.backgrounds;

				    $(document).on('change', '.skins-picker', function(e){
				    	_self = $(this),
				    	_val = _self.val();
						_varsWrap = _self.parents('.variant-wrap');
						_gradientsWrap = _varsWrap.find('.gradients');
						if( _varsWrap.hasClass('saved-variant') ){
							_index = _varsWrap.attr('data-index');
							infobarwp.plugins.cssgradients('#infobar-variant-'+_index, _index);
						}
				    	if( _val != 26 ){
				    		//for (var i = _backgrounds.length - 1; i >= 0; i--) {
				    		for (var i = 0; i < _backgrounds.length; i++) {
				    			if( i == _val ){
				    				_title = _backgrounds[i][0];
				    				_gradient = _backgrounds[i][1];
				    				_txtColor = _backgrounds[i][2];
				    				_linkColor = _backgrounds[i][3];
				    				_borderColor = _backgrounds[i][4];

									_gradientsWrap.data('ClassyGradient').settings.gradient = _gradient;
									_gradientsWrap.data('ClassyGradient').update();
				    			}
				    		};
				    	}
				    });

					$(document).on('change', '.border-width', function(){
						_self = $(this),
						_variantWrap = _self.parents('.variant-wrap'),
						_barDemo = _variantWrap.find('.bar-demo');

						_barDemo.attr( 'data-style-border-bottom-width', _self.val()+'px' );
						_this.setStyles(_barDemo)
					});

				},

				generateButtons : function(){
					//link-label
					_this = this,
					_buttons = _this.defaults.buttons;

				    $(document).on('change', '.buttons-styles', function(e){
				    	_self = $(this),
				    	_val = _self.val(),
				    	_gradientsWrap = _self.parents('.variant-wrap').find('.btn-gradient'),
						_btnPreview = _self.siblings('.btn-preview .ibw-primary-btn');
						
	    				_title = _backgrounds[_val][0];
	    				_gradient = _backgrounds[_val][1];
	    				_txtColor = _backgrounds[_val][2];
	    				_borderColor = _backgrounds[_val][3];

						_btnPreview.attr('data-style-color', _txtColor);
						_btnPreview.attr('data-style-border-color', _borderColor);
						_gradientsWrap.data('ClassyGradient').settings.gradient = _gradient;
						_gradientsWrap.data('ClassyGradient').update();
				    });

				    $(document).on('keyup, change', '.link-label', function(){
				    	_self = $(this),
				    	_btnPreview = _self.parents('.tooltip-wrap').find('.ibw-primary-btn'),
				    	_val = _self.val();

				    	_btnPreview.text(_val);
				    });

				    $(document).on('change', '.link-url', function(){
				    	_self = $(this),
				    	_btnPreview = _self.parents('.tooltip-wrap').find('.ibw-primary-btn'),
				    	_val = _self.val();

				    	_btnPreview.attr('href', _val);

				    });

				    $(document).on('change', '.link-target', function(){
				    	_self = $(this),
				    	_btnPreview = _self.parents('.tooltip-wrap').find('.ibw-primary-btn'),
				    	_val = _self.val();

				    	if( _val == '_blank' ){
				    		_btnPreview.attr('target', _val);
				    	}else{
				    		_btnPreview.removeAttr('target');
				    	}
				    });
				},

				insertForms : function(){
					_this = this;
					$(document).on('click', '.insert', function(e){
						_self = $(this),
						_type = _self.attr('data-type'),
						_wrap = _wrap = _self.parents('.tooltip-wrap'),
						_variantWrap = _self.parents('.variant-wrap'),
						_editor = _variantWrap.find('.message-editable'),
						_editorID = document.getElementById(_editor.attr('id')),
						_barDemo = _variantWrap.find('.bar-demo .content'), _html = '';
						e.preventDefault();
						switch( _type ){
							case 'buttons' :
								_btn = _self.parents('.tooltip-contain').find('.btn-preview')
								_html = _btn.html();
								break;
							case 'link' :
								_customStyle = '',
								_label = _wrap.find('.link-label').val(),
								_link = _wrap.find('.link-url').val(),
								_target = (_wrap.find('.link-target').is(':checked'))? ' target="_blank"' : '';
								if( _variantWrap.find('.skins-picker').eq(0).val() == '26' ){
									_customStyle = 'style="color:'+_variantWrap.find('.style-link-color').eq(0).val()+'" ';
								}
								_html = '<a '+_customStyle+'class="normal-link" href="'+_link+'"'+_target+'>'+_label+'</a>';
								break;
							case 'image' :
								_html = _wrap.find('.image-preview').html();
								// _link = _wrap.find('.image-link').val();
								// _html = '<a href="'+_link+'" target="_blank" class="custom-img-wrap">'+_imagePreview.html()+'</a>';
								break;
						}
						//_editor.trigger('focus')
						_this.pasteHtmlAtCaret(_html, _editorID);
						_barDemo.html(_editor.html());
						_self.die('click');
					})
				},

				changeHidingButtons : function(){
					$(document).on('click', '.close-icons .btn', function(e){
						_self = $(this),
						_variantWrap = _self.parents('.variant-wrap'),
						_index = _variantWrap.attr('data-index'),
						_hidingBtn = _variantWrap.find('.close .btn');

						e.preventDefault();
						_hidingBtn.replaceWith( this.outerHTML );
						$('#variant-closebtn-'+_index).val(this.outerHTML);
					});

					$(document).on('click', '.minimize-icons .btn', function(e){
						_self = $(this),
						_variantWrap = _self.parents('.variant-wrap'),
						_index = _variantWrap.attr('data-index'),
						_hidingBtn = _variantWrap.find('.close .btn');

						e.preventDefault();
						_hidingBtn.replaceWith( this.outerHTML );
						$('#variant-closebtn-'+_index).val(this.outerHTML);
					});

					$(document).on('click', '.live-preview .btn-minimize', function(e){
						_btnParent = $(this).parent(),
						_infobar = $(this).parents('.bar-demo'),
						_status = ( _infobar.hasClass('minimized') )? 1 : 0;
						_infobar.css({
							height: _status == 1 ? 'auto' : 0,
							padding : _status == 1 ? '25px 75px 25px 15px' : 0
						})
						if( _infobar.hasClass('minimized') ){
							_infobar.removeClass('minimized');
						}else{
							_infobar.addClass('minimized');
						}
						_btnParent.css({
							top: _status == 1 ? '50%' : '50%'
						}, 1000);	
					});

				},

				elementContainsSelection : function(el) {
				    var sel, _this = this;
				    if (window.getSelection) {
				        sel = window.getSelection();
				        if (sel.rangeCount > 0) {
				            for (var i = 0; i < sel.rangeCount; ++i) {
				                if (!_this.isOrContains(sel.getRangeAt(i).commonAncestorContainer, el)) {
				                    return false;
				                }
				            }
				            return true;
				        }
				    } else if ((sel = document.selection) && sel.type != "Control") {
				        return _this.isOrContains(sel.createRange().parentElement(), el);
				    }
				    return false;
				},

				isOrContains : function(node, container) {
				    while (node) {
				        if (node === container) {
				            return true;
				        }
				        node = node.parentNode;
				    }
				    return false;
				},
				setEndOfContenteditable : function(contentEditableElement) {
				    var range, selection;
				    if (document.createRange) //Firefox, Chrome, Opera, Safari, IE 9+
				    {
				        range = document.createRange(); //Create a range (a range is a like the selection but invisible)
				        range.selectNodeContents(contentEditableElement); //Select the entire contents of the element with the range
				        range.collapse(false); //collapse the range to the end point. false means collapse to end rather than the start
				        selection = window.getSelection(); //get the selection object (allows you to change selection)
				        selection.removeAllRanges(); //remove any selections already made
				        selection.addRange(range); //make the range you have just created the visible selection
				    } else if (document.selection) //IE 8 and lower
				    {
				        range = document.body.createTextRange(); //Create a range (a range is a like the selection but invisible)
				        range.moveToElementText(contentEditableElement); //Select the entire contents of the element with the range
				        range.collapse(false); //collapse the range to the end point. false means collapse to end rather than the start
				        range.select(); //Select the range (make it the visible selection
				    }
				},
				pasteHtmlAtCaret : function(html, el){
				    var sel, range, _this = this;
				    if (window.getSelection) {
				        // IE9 and non-IE
				        sel = window.getSelection();
				        if (_this.elementContainsSelection(el)) {
				            if (sel.getRangeAt && sel.rangeCount) {
				                range = sel.getRangeAt(0);
				                range.deleteContents();

				                // Range.createContextualFragment() would be useful here but is
				                // non-standard and not supported in all browsers (IE9, for one)
				                var el = document.createElement("div");
				                el.innerHTML = html;
				                var frag = document.createDocumentFragment(),
				                    node, lastNode;
				                while ((node = el.firstChild)) {
				                    lastNode = frag.appendChild(node);
				                }
				                range.insertNode(frag);

				                // Preserve the selection
				                if (lastNode) {
				                    range = range.cloneRange();
				                    range.setStartAfter(lastNode);
				                    range.collapse(true);
				                    sel.removeAllRanges();
				                    sel.addRange(range);
				                }
				            } else if (document.selection && document.selection.type != "Control") {
				                // IE < 9
				                document.selection.createRange().pasteHTML(html);
				            }
				            $('.variant-wrap.current .message-editable').keyup();
				        } else {
				            _this.setEndOfContenteditable(el);
				            _this.pasteHtmlAtCaret(html, el);
				        }
				    }

				},

				setStyles : function (node) {
				    var d = '', 
				    	_index = node.attr('data-index'),
				        re_dataAttr = /^data\-style\-(.+)$/;

				    $.each(node.get(0).attributes, function(index, attr) {
				        if (re_dataAttr.test(attr.nodeName)) {
				            var key = attr.nodeName.match(re_dataAttr)[1];
				            if( key == 'background' ){
				            	d += attr.nodeValue;
				            }else{
				            	d += key + ':' + attr.nodeValue + ';';
				            }
				        }
				    });

				    node.attr('style', d);
				    if( typeof _index !== 'undefined' ){
				    	$('#variant-wrap-styles-'+_index).val(node.attr('style'));
				    }
				},
				insertEmoticons : function(){
					_this = this;
					$(document).on('click', '.emoticons .btn-img', function(e){
						_self = $(this),
						_variantWrap = _self.parents('.variant-wrap'),
						_editor = _variantWrap.find('.message-editable'),
						_editorID = document.getElementById(_editor.attr('id')),
						_barDemo = _variantWrap.find('.bar-demo .content');

						e.preventDefault();
						//_editor.trigger('focus')
						_this.pasteHtmlAtCaret(this.innerHTML, _editorID);
						_barDemo.html(_editor.html());
						_self.die('click');
						//}
					});
				},

				insertAnimatedIcons : function(){
					_this = this;
					$(document).on('click', '.animated-icons-list a', function(e){
						_self = $(this),
						_variantWrap = _self.parents('.variant-wrap'),
						_editor = _variantWrap.find('.message-editable'),
						_editorID = document.getElementById(_editor.attr('id')),
						_barDemo = _variantWrap.find('.bar-demo .content');

						e.preventDefault();
						//_editor.trigger('focus')
						_this.pasteHtmlAtCaret(this.innerHTML, _editorID);
						_barDemo.html(_editor.html());
						_self.die('click');
						//}
					});
				},

				fontsChanger : function(){
					_this = this;
					$(document).on('change', '.font-family', function(){
						_self = $(this),
						_variantWrap = _self.parents('.variant-wrap'),
						_editor = _variantWrap.find('.message-editable'),
						_barDemo = _variantWrap.find('.bar-demo');

						_barDemo.attr( 'data-style-font-family', _self.val() + ', sans-serif' );
						_this.setStyles(_barDemo)
					});

					$(document).on('change', '.font-size', function(){
						_self = $(this),
						_variantWrap = _self.parents('.variant-wrap'),
						_editor = _variantWrap.find('.message-editable'),
						_barDemo = _variantWrap.find('.bar-demo');

						_barDemo.attr( 'data-style-font-size', _self.val() + 'px' );
						_this.setStyles(_barDemo)
					});


				},
				
				messageUpdater : function(el){
					_self = el,
					_variantWrap = _self.parents('.variant-wrap'),
					_textarea = _self.siblings('.message'),
					_barDemo = _variantWrap.find('.bar-demo .content');
					_textarea.text(_self.html());
					_barDemo.html(_self.html());

				},
				messageEditor : function(){
					$(document).on('keyup', '.message-editable', function(){
						infobarwp.addons.livePreview.messageUpdater($(this));
					});
					$(document).on('change', '.message-editable', function(){
						infobarwp.addons.livePreview.messageUpdater($(this));
					});

					$(document).on('keydown', '.message-editable', function(e){
						if (e.which == 13) {
							document.execCommand('formatBlock', false, 'p');
						}
					});
				}
			}
		}
	}
	$( document ).ready( function () {
		infobarwp.init();
	});

} )( jQuery );