var ibwpfront;

( function ( $ ) {
	ibwpfront = {
		cookies: {
			imp : 1,
			ref : document.referrer.replace('http://', '').replace('https://', '')
		},
		
		init: function(){
			this.load();
		},

		getHtml : function(encodedString){
			var textArea = document.createElement('textarea');
			textArea.innerHTML = encodedString;
			_val = textArea.value
			textArea.remove();
			return _val;
		},
		getBrowser : function(){
			var browser = '';
			if (/SeaMonkey[\/\s](\d+\.\d+)/.test(navigator.userAgent)){
				browser = 'SeaMonkey';
			} else {
				if (/Firefox[\/\s](\d+\.\d+)/.test(navigator.userAgent)){
					browser = 'Firefox';
				} else {
					if (/MSIE (\d+\.\d+);/.test(navigator.userAgent)){
						browser = 'IE';
					} else {

						if (/Opera/.test(navigator.userAgent)){
							browser = 'Opera';
						} else {
							if (/Maxthon[\/\s](\d+\.\d+)/.test(navigator.userAgent)){
								browser = 'Maxthon';
							} else {
								if (/Chrome[\/\s](\d+\.\d+)/.test(navigator.userAgent)){
									browser = 'Chrome';
								} else {
									if (/Safari/.test(navigator.userAgent)){
										browser = 'Safari';
									} else {
										browser = 'Unknown';
									}
								}
							}
						}
					}
				}
			}
			(function(a){if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0,4)))browser = 'Mobile'})(navigator.userAgent||navigator.vendor||window.opera);
			return browser;
		},
		treatCampaign : function( data ) {
			if ( !data[0] )
				return;

			name = data[0].campaign_name,
			pos = data[0].campaign_position,
			settingsOb = JSON.parse( data[0].campaign_settings ),
			settings = settingsOb.campaign_settings,
			position = ( pos == 'Footer' )? 'bottom': 'top',
			variants = data[0].campaign_variants,
			heightVar = 0,
			_this = this;
			pageviews = ( _this.readCookie('ibwp-pageviews') > 0 )? parseInt(_this.readCookie('ibwp-pageviews')) : 0,
			pageviews++;

			_this.createCookie('ibwp-pageviews', pageviews, 1000);

			if ( data[0].haspreview == 1 ) {
				for (var i = 0; i < variants.length; i++) {
					var id = variants[i].ID, 
					styles = variants[i].styles, 
					content = variants[i].content;

					$('<div />', {
						class : 'infobarwp-wrap demo-preview position-'+pos.toLowerCase(),
						id : 'variant-'+id,
						style : styles,
						html : _this.getHtml(content)
					}).appendTo('body').css(position, heightVar + 'px');
				}

				_this.treatDemoCampaign();
			}else{
				for (var i = 0; i < variants.length; i++) {
					var id = variants[i].ID, 
					styles = variants[i].styles, 
					content = variants[i].content,
					hits = ( _this.readCookie('variant-'+id+'-hits') > 0 )? parseInt(_this.readCookie('variant-'+id+'-hits')) : 0,
					isHidden = _this.readCookie('variant-'+id+'-daysoff') == 'hide' ? true : false,
					addonClasses = '';

					if( isHidden )
						continue;

					hits++;
					_this.createCookie('variant-'+id+'-hits', hits, 1000);

					if ( settings.duration > 0 || settings.showafterhits > 0 ) {
						addonClasses = ' hide-for-now';
					}

					$('<div />', {
						class : 'infobarwp-wrap position-'+pos.toLowerCase()+addonClasses,
						id : 'variant-'+id,
						style : styles,
						html : _this.getHtml(content),
						'data-campaign': data[0].campaign_id,
						'data-onclose' : settings.onclose,
						'data-duration' : settings.duration,
						'data-daysoff' : settings.daysoff,
						'data-views' : settings.showafterhits
					}).appendTo('body').css(position, heightVar + 'px');

					heightVar = $('#variant-'+id).outerHeight() + heightVar;

					if ( settings.duration > 0 ) {
						setTimeout(function(){
							$('#variant-'+id).fadeIn(600).removeClass('hide-for-now');
						}, parseInt(settings.duration*1000));
					}

					if ( settings.showafterhits > 0 ) {
						if ( pageviews >= settings.showafterhits ) {
							$('#variant-'+id).fadeIn(600).removeClass('hide-for-now');
						}
					}
					_this.trackVariant(id, 'clicks');
					_this.trackVariant(id, 'impressions');
					_this.hideAndShow(id);
				};
			}
		},

		treatDemoCampaign : function(){
			_demo = $('.demo-preview');

			if( _demo.length > 0 ){
				_demo.find('.close a').off('click').on('click', function(e){
					_closingMethod = (  $(this).hasClass('btn-hide') )? 'hide' : 'minimize',
					_btnParent = $(this).parent();
					//_htmlPadds = $('html').css('padding-top'),
					//_newPadds = ( parseInt(_htmlPadds)-parseInt(_variant.outerHeight()) > 0 ) ? parseInt(_htmlPadds)-parseInt(_variant.outerHeight()) : 0;
					e.preventDefault();

					switch( _closingMethod ){
						case 'hide' : 
							_demo.fadeOut();
							break;
						case 'minimize' :
								_status = ( _demo.hasClass('minimized') )? 1 : 0;
								_classes = $(this).attr('class');
								_contents = _demo.find('.content');
								_demo.css({
									height: _status == 1 ? 'auto' : 0,
									padding : _status == 1 ? '25px 75px 25px 15px' : '0 75px 0 15px'
								})
								if( _demo.hasClass('minimized') ){
									_demo.removeClass('minimized');
								}else{
									_demo.addClass('minimized');
								}
								if( _demo.hasClass('position-footer') ){
									_btnParent.css({
										bottom: _status == 1 ? '50%' : '50%'
									}, 1000);	
								}else{								
									_btnParent.css({
										top: _status == 1 ? '50%' : '50%'
									}, 1000);	
								}
								if( _status == 1 ){
									$(this).attr('class', _classes.replace('-up', '-down'));
									_contents.show();

								}else{
									$(this).attr('class', _classes.replace('-down', '-up'));
									_contents.hide();
								}
							break;
					}
				})
			}
		},

		trackVariant : function(_variantID, _action){
			_variant = $('#variant-'+_variantID),
			_variantLinks = _variant.find('a');
			if( _action == 'clicks' ){
				_variantLinks.on('click.trackclicks', function(e){
					_self = $(this),
					_href = _self.attr('href'),
					_target = ( _self.attr('target') == '_blank' )? true : false;
					e.preventDefault();
					$.post(ajaxparams.ajaxutrackings, { 'action' : 'infobarwptrackings', 'ibw-action': 'track-clicks', 'variantid' : _variantID }, function(){
						if( _target == true ){
							window.open(_href);
						}else{
							window.location = _href;
						}
					});
				});
			}else if( _action == 'impressions' ){
				$.post(ajaxparams.ajaxutrackings, { 'action' : 'infobarwptrackings', 'ibw-action': 'track-impressions', 'variantid' : _variantID });
			}
		},
		
		hideAndShow : function(_id){
			_variant = $('#variant-'+_id),_infobarHeight = [],_infobarOffsetTop = [], _btnOffsetTop = [],
			_this = this;

			_infobarHeight[_id] = _variant.outerHeight(),
			_infobarOffsetTop[_id] = _variant.offset().top,
			_btnOffsetTop[_id] = _variant.find('.close').position().top;

			_variant.find('.close a').off('click').on('click', function(e){
				_btnParent = $(this).parent(),
				_infobar = $(this).parents('.infobarwp-wrap'),
				_closingMethod = (  $(this).hasClass('btn-hide') )? 'hide' : 'minimize',
				_daysoff = parseInt( _infobar.data( 'daysoff' ) );
				//_htmlPadds = $('html').css('padding-top'),
				//_newPadds = ( parseInt(_htmlPadds)-parseInt(_variant.outerHeight()) > 0 ) ? parseInt(_htmlPadds)-parseInt(_variant.outerHeight()) : 0;
				e.preventDefault();

				switch( _closingMethod ){
					case 'hide' : 
						_infobar.fadeOut();

						if	( _daysoff > 0 )
							_this.createCookie('variant-'+_id+'-daysoff', 'hide', _daysoff);

						break;
					case 'minimize' :
							_status = ( _infobar.hasClass('minimized') )? 1 : 0;
							_classes = $(this).attr('class');
							if( _status == 0 ){
								$(this).attr('class', _classes.replace('-up', '-down'));
							}else{
								$(this).attr('class', _classes.replace('-down', '-up'));
							}
							_infobar.css({
								height: _status == 1 ? 'auto' : 0,
								padding : _status == 1 ? '25px 75px 25px 15px' : '0 75px 0 15px'
							})
							if( _infobar.hasClass('minimized') ){
								_infobar.removeClass('minimized');
							}else{
								_infobar.addClass('minimized');
							}

							if( _infobar.hasClass('position-footer') ){
								_btnParent.css({
									bottom: _status == 1 ? '50%' : '50%'
								}, 1000);	
							}else{								
								_btnParent.css({
									top: _status == 1 ? '50%' : '50%'
								}, 1000);	
							}

						break;
				}
			})
		},

		createCookie: function( name, value, days ) {
			var date = new Date();

			date.setDate( date.getDate() + days );

			var c_value = escape( value ) + ( ( days == null || days === 0 ) ? "" : "; expires=" + date.toUTCString() ) + "; path=/";

			document.cookie = name + "=" + c_value;
		},

		readCookie: function(name){
			var i,x,y,ARRcookies=document.cookie.split(";");
			for (i=0;i<ARRcookies.length;i++)
			  {
			  x=ARRcookies[i].substr(0,ARRcookies[i].indexOf("="));
			  y=ARRcookies[i].substr(ARRcookies[i].indexOf("=")+1);
			  x=x.replace(/^\s+|\s+$/g,"");
			  if (x==name)
				{
				 return unescape(y);
				}
			  }
		},
		urlParam : function(name){
			var results = new RegExp('[\?&amp;]' + name + '=([^&amp;#]*)').exec(window.location.href);
			return ( results != null )? results[1] : 0;
		},
		load: function(){
			if ( this.urlParam( 'preview-campaign' ) != 0 ) {
				var url = ajaxparams.ajaxurl+'&preview-campaign='+this.urlParam('preview-campaign');
			} else {
				var href = document.referrer ? document.referrer : window.location.href,
					id = ( ajaxparams.id != false ) ? '&id='+ajaxparams.id : '',
					category = ( ajaxparams.category != false ) ? '&category='+ajaxparams.category : '',
					url = ajaxparams.ajaxurl + '&browser=' + this.getBrowser() + '&type=' + ajaxparams.type + '&href=' + href + id + category;
			}

			var s = document.createElement('script');

			s.id = 'infobarwp-load';
			s.src = url;
			s.type = 'text/javascript';

			document.getElementsByTagName('head')[0].appendChild(s);
		}
	}
	$( document ).ready( function () {
		ibwpfront.init();
	});

} )( jQuery );