<?php 

if( !class_exists( 'WP_List_Table' ) )
	require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );

class InfobarWPListTable extends WP_List_Table {

	 function __construct() {
		parent::__construct(
			array(
				'singular' => 'wp_list_infobar',
				'plural' => 'wp_list_infobars',
				'ajax'  => false
			)
		);
	}

	function extra_tablenav( $which ) {
			if ( $which == "top" ){
				//include_once IBWP_PLUGIN_DIR . 'src/views/common/header.php';
			}
			if ( $which == "bottom" ){
				//include_once IBWP_PLUGIN_DIR . 'src/views/common/footer.php';
			}
	}

	function get_table_classes(){
		return array( 'widefat', $this->_args['plural'] );
	}

	function get_columns() {
		return array(
			'cb' => '<input type="checkbox" />',
			'col_ibw_name' => __( 'Campaign Name', IBWP_PLUGIN_TEXTDOMAIN ),
			'col_ibw_startdate' => __( 'Start Date', IBWP_PLUGIN_TEXTDOMAIN ),
			'col_ibw_expirationdate' => __( 'Expiration Date', IBWP_PLUGIN_TEXTDOMAIN ),
			'col_ibw_place' => __( 'Location', IBWP_PLUGIN_TEXTDOMAIN ),
			'col_ibw_status' => __( 'Status', IBWP_PLUGIN_TEXTDOMAIN )
		);
	}

	function column_default( $item, $column_name ) {
		$url  = admin_url( 'admin.php?page=infobar-campaign&id=' . $item->id );
		$settingsOb = json_decode( $item->campaign_settings );
		$settings = $settingsOb->campaign_settings;
		switch ( $column_name ) {
				// case "col_ibw_name":
				//     return '<strong><a href="'.$url.'" title="Edit">'.stripslashes($item->campaign_name).'</a></strong>';
				//     break;
				case "col_ibw_startdate":
					return (strtotime($settings->startdate) != '')?stripslashes($settings->startdate) : 'Not set';
					break;
				case "col_ibw_expirationdate": 
					return (strtotime($settings->enddate) != '')?stripslashes($settings->enddate) : 'Not set';
					break;
				case "col_ibw_place": 
					switch ($item->campaign_location) {
						case 'home':
							$location = '<b>'. __( 'Home page', IBWP_PLUGIN_TEXTDOMAIN ) .'</b>';
							break;
						case 'inner':
							$location = '<b>'. __( 'Inner pages', IBWP_PLUGIN_TEXTDOMAIN ) .'</b>';
							break;
						case 'all':
							$location = '<b>'. __( 'All Pages/Posts/Categories', IBWP_PLUGIN_TEXTDOMAIN ) .'</b>';
							break;
						case 'category':
							$location = '<b>'. __( 'Category', IBWP_PLUGIN_TEXTDOMAIN ) .'</b>';
							break;
						case 'page':
							$location = '<b>'. __( 'Page', IBWP_PLUGIN_TEXTDOMAIN ) .'</b>';
							break;
						case 'post':
							$location = '<b>'. __( 'Post', IBWP_PLUGIN_TEXTDOMAIN ) .'</b>';
							break;
						case '-1':
							$location = '<b>'. __( 'Everywhere ( Front )', IBWP_PLUGIN_TEXTDOMAIN ) .'</b>';
							break;
					}
					return 'Shows up on '.$location;
					break;
				case "col_ibw_status": 
					$status = ( $item->campaign_status == 1 )? 'checked="checked"' : '';
					$return = '<label class="ibw-checkbox switch-status">';
					$return .= '<input data-id="'. $item->id .'" id="change-status-'. $item->id .'" type="checkbox" '.$status.'/>';
					$return .= '<img class="loader hidden" src="'. IBWP_PLUGIN_URL . 'src/assets/images/ajax.gif' .'" alt="" />';
					$return .= '</label>';
					return $return;
					break;

		}
	}

	function column_cb( $item ) {
		return sprintf( '<input type="checkbox" name="%1$s[]" value="%2$s" />', $this->_args['singular'], $item->id );
	}

	function column_col_ibw_name( $item ) {
		$url  = admin_url( 'admin.php?page=infobar-campaign&id=' . $item->id );
		$edit_link = add_query_arg( array( 'action' => 'edit' ), $url );
		$actions = array(
			'edit' => sprintf( '<a href="%1$s">%2$s</a>',
				esc_url( $edit_link ),
				esc_html( __( 'Edit', IBWP_PLUGIN_TEXTDOMAIN ) ) ) ,
			'inline' => sprintf( '<a class="quick-edit-bar" data-id="%1$s" href="#">%2$s</a>',
				$item->id,
				esc_html( __( 'Quick Edit', IBWP_PLUGIN_TEXTDOMAIN ) ) ) ,
			'trash' => sprintf( '<a class="trash-bar" data-id="%1$s" href="#">%2$s</a>',
				$item->id,
				esc_html( __( 'Trash', IBWP_PLUGIN_TEXTDOMAIN ) ) ) ,

			'view' => sprintf( '<a target="_blank" href="%1$s">%2$s</a>',
				esc_url( home_url( '/?preview-campaign=' . $item->id ) ),
				esc_html( __( 'Preview', IBWP_PLUGIN_TEXTDOMAIN ) ) ) ,
				);

		if ( current_user_can( 'manage_options' ) ) {
			$copy_link = wp_nonce_url(
				add_query_arg( array( 'action' => 'copy' ), $url ),
				'infobar_' . absint( $item->id ) );

			$actions = array_merge( $actions, array(
				'copy' => sprintf( '<a data-id="%1$s" class="clone-bar" href="%2$s">%3$s</a>',
					$item->id,
					esc_url( $copy_link ),
					esc_html( __( 'Duplicate', IBWP_PLUGIN_TEXTDOMAIN ) ) ) ) );

			$actions = array_merge( $actions, array(
				'clear' => sprintf( '<a data-id="%1$s" class="clear-data" href="%2$s">%3$s</a>',
					$item->id,
					'#',
					esc_html( __( 'Clear data', IBWP_PLUGIN_TEXTDOMAIN ) ) ) ) );

		}

		$name = ( empty( $item->campaign_name ) )? '(no title)' : $item->campaign_name;
		$a = sprintf( '<a class="row-title" href="%1$s" title="%2$s">%3$s</a>',
			esc_url( $edit_link ),
			esc_attr( sprintf( __( 'Edit &#8220;%s&#8221;', IBWP_PLUGIN_TEXTDOMAIN ),
				$name   ) ),
			esc_html( $name )
		);

		return '<strong>' . $a . '</strong> ' . $this->row_actions( $actions );
	}

	public function get_sortable_columns() {
		return array(
			'col_ibw_name' => array( 'campaign_name', false ),
			'col_ibw_startdate' => array( 'start_date', false ),
			'col_ibw_status' => array( 'status', false )
		);
	}

	function prepare_items() {
		global $wpdb, $_wp_column_headers;
		$screen = get_current_screen();

		$this->process_bulk_action();

		/* -- Preparing your query -- */
		$query = "SELECT * FROM " . $wpdb->prefix . "ibwp_campaigns";

		/* -- Ordering parameters -- */
		//Parameters that are going to be used to order the result
		$orderby = !empty($_GET["orderby"]) ? mysql_real_escape_string($_GET["orderby"]) : 'DESC';
		$order = !empty($_GET["order"]) ? mysql_real_escape_string($_GET["order"]) : '';
		if(!empty($orderby) & !empty($order)){ $query.=' ORDER BY '.$orderby.' '.$order; }

		/* -- Pagination parameters -- */
		//Number of elements in your table?
		$totalitems = $wpdb->query($query); //return the total number of affected rows
		//How many to display per page?
		$perpage = 20;
		//Which page is this?
		$paged = !empty($_GET["paged"]) ? mysql_real_escape_string($_GET["paged"]) : '';
		//Page Number
		if(empty($paged) || !is_numeric($paged) || $paged<=0 ){ $paged=1; }
		//How many pages do we have in total?
		$totalpages = ceil($totalitems/$perpage);
		//adjust the query to take pagination into account
		if(!empty($paged) && !empty($perpage)){
			$offset=($paged-1)*$perpage;
			$query.=' LIMIT '.(int)$offset.','.(int)$perpage;
		}

		/* -- Register the pagination -- */
		$this->set_pagination_args( array(
			"total_items" => $totalitems,
			"total_pages" => $totalpages,
			"per_page" => $perpage,
		) );
		//The pagination links are automatically built according to those parameters

		/* — Register the Columns — */
		$columns = $this->get_columns();
		$hidden = array();
		$sortable = $this->get_sortable_columns();
		$this->_column_headers = array($columns, $hidden, $sortable);

		/* -- Fetch the items -- */
		$this->items = $wpdb->get_results($query);
	}

	function get_bulk_actions() {
		$actions = array(
			'delete' => __( 'Delete', IBWP_PLUGIN_TEXTDOMAIN ),
			'activate' => __( 'Activate', IBWP_PLUGIN_TEXTDOMAIN ),
			'deactivate' => __( 'Deactivate', IBWP_PLUGIN_TEXTDOMAIN ),
			'clear' => __( 'Clear', IBWP_PLUGIN_TEXTDOMAIN )
		);

		return $actions;
	}

	public static function delete_campaigns( $id ) {
	  global $wpdb;

	  $wpdb->delete( "{$wpdb->prefix}ibwp_campaigns", array( 'id' => $id ) );
	  $wpdb->delete( "{$wpdb->prefix}ibwp_variants", array( 'variant_campaign_id' => $id ) );
	  $wpdb->delete( "{$wpdb->prefix}ibwp_tracking_visitors", array( 'campaign_id' => $id ) );
	 
	}

	public static function clear_campaigns( $id ) {
	  global $wpdb;
	  if( $wpdb->delete( "{$wpdb->prefix}ibwp_tracking_visitors", array( 'campaign_id' => $id ) ) ){
		$wpdb->update( 
			$wpdb->prefix . 'ibwp_variants', 
			array( 
				'variant_impressions' => 0,
				'variant_clicks' => 0
			), 
			array( 'variant_campaign_id' => $id )
		);
	  }
	}

	public static function activate_campaigns( $id ) {
		global $wpdb;

		$wpdb->update( 
			$wpdb->prefix . 'ibwp_campaigns', 
			array( 
				'campaign_status' => 1,
			), 
			array( 'id' => $id )
		);
	 
	}

	public function single_row($item){
		$settingsOb = json_decode( $item->campaign_settings );
		$settings = $settingsOb->campaign_settings;
		echo '<tr class="item-wrap">';
		$this->single_row_columns( $item );
		echo '</tr>';
		echo '<tr id="inlineedit-'. $item->id .'" data-id="'. $item->id .'" class="inlineedit-wrap alternate inline-edit-row hidden">';
		echo '<td colspan="7" class="colspanchange">';
		echo '<fieldset style="width:10%"><div class="inline-edit-col"><h4>Quick Edit</h4></div></fieldset>';
		echo '<fieldset style="width:30%">';
			echo '<div class="inline-edit-col">';
				echo '<label>';
					echo '<span>Campaign name</span>';
					echo '<span class="input-text-wrap" style="margin:0;">';
						echo '<input type="text" name="campaign-name-'.$item->id.'" class="campaign-name" value="'. $item->campaign_name .'">';
					echo '</span>';
				echo '</label>';
				echo '<div class="inline-edit-group">';
				foreach( array( 'Header', 'Footer' ) as $pos ) :
					$ischecked = ( $item->campaign_position == $pos )? ' checked="checked"' : '';
					echo '<label>';
						echo '<input type="radio" name="campaign-position-'.$item->id.'" '. $ischecked .'value="'.$pos.'">';
						echo '<span class="radio-title">Show on '.$pos.'</span>';
					echo '</label>';
				endforeach;
				echo '<div>';
			echo '</div>';
		echo '</fieldset>';
		echo '<fieldset style="width:30%">';
			echo '<div class="inline-edit-col">';
				echo '<div class="inline-edit-group">';
				foreach( array( 'Everyday' => 0, 'On specific dates' => 1 ) as $time => $val ) :
					$ischecked = ( $settings->timing == $val )? ' checked="checked"' : '';
					echo '<label>';
						echo '<input class="show-on-change" data-target="#campaign-dates-container-'.$item->id.'" data-value="1"  type="radio" name="campaign-showing-times-'.$item->id.'" '. $ischecked .'value="'.$val.'">';
						echo '<span class="radio-title">Show on '.$time.'</span>';
					echo '</label>';
				endforeach;
				$hasdates = ($settings->timing == 0)? 'hidden' : '';
				echo '<div id="campaign-dates-container-'.$item->id.'" class="'. $hasdates .'">';
					echo '<div>';
						echo '<span class="title">Start date</span><br />';
						echo '<span class="input-text-wrap">';
							echo '<input type="text" name="start-date-'.$item->id.'" class="datepicker" value="'. $settings->startdate .'">';
						echo '</span>';
					echo '</div>';
					echo '<div>';
						echo '<span class="title">End date</span><br />';
						echo '<span class="input-text-wrap">';
							echo '<input type="text" name="end-date-'.$item->id.'" class="datepicker" value="'. $settings->enddate .'">';
						echo '</span>';
					echo '</div>';
			echo '</div>';
		echo '</fieldset>';
		echo '<fieldset style="width:30%">';
			echo '<div class="inline-edit-col">';
				echo '<div>';
					echo '<span class="title">Time delay</span><br />';
					echo '<span class="input-text-wrap">';
						echo '<input type="number" name="campaign-show-before-'.$item->id.'" class="campaign-show-before" value="'. $settings->duration .'">';
					echo '</span>';
				echo '</div>';
				echo '<div>';
					echo '<span class="title">Pageviews</span><br />';
					echo '<span class="input-text-wrap">';
						echo '<input type="number" name="campaign-showafter-views-'.$item->id.'" class="campaign-showafter-views" value="'. $settings->showafterhits .'">';
					echo '</span>';
				echo '</div>';
			echo '</div>';
		echo '</fieldset>';
		echo '<p class="submit inline-edit-save">';
			echo '<a href="#" class="button-secondary cancel alignleft">Cancel</a>';
			echo '<a href="#" class="button-primary save alignright">Update</a>';
			echo '<span class="spinner"></span>';
			echo '<span class="error" style="display:none"></span>';
			echo '<br class="clear">';
		echo '</p>';

		echo '</td>';
		echo '</tr>';
	}

	public static function deactivate_campaigns( $id ) {
	  global $wpdb;

		$wpdb->update( 
			$wpdb->prefix . 'ibwp_campaigns', 
			array( 
				'campaign_status' => 0,
			), 
			array( 'id' => $id )
		);     
	}

	public function no_items() {
	  _e( 'No campaigns found, get started and <a href="'. admin_url( '/admin.php?page=infobar-campaign' ) .'">Add a new</a> one.', IBWP_PLUGIN_TEXTDOMAIN );
	}

	public function process_bulk_action() {
		// Detect when a bulk action is being triggered...
		if ( 'delete' === $this->current_action() ) {
			$delete_ids = esc_sql( $_POST['wp_list_infobar'] );

			// loop over the array of record IDs and delete them
			foreach ( $delete_ids as $id ) {
				self::delete_campaigns( $id );
			}

			wp_redirect( esc_url( add_query_arg() ) );
			exit;
		}

		if ( 'activate' === $this->current_action() ) {
			$activate_ids = esc_sql( $_POST['wp_list_infobar'] );

			// loop over the array of record IDs and delete them
			foreach ( $activate_ids as $id ) {
				self::activate_campaigns( $id );
			}

			wp_redirect( esc_url( add_query_arg() ) );
			exit;
		}

		if ( 'deactivate' === $this->current_action() ) {
			$deactivate_ids = esc_sql( $_POST['wp_list_infobar'] );

			// loop over the array of record IDs and delete them
			foreach ( $deactivate_ids as $id ) {
				self::deactivate_campaigns( $id );
			}

			wp_redirect( esc_url( add_query_arg() ) );
			exit;
		}

		if ( 'clear' === $this->current_action() ) {
			$clear_ids = esc_sql( $_POST['wp_list_infobar'] );

			// loop over the array of record IDs and delete them
			foreach ( $clear_ids as $id ) {
				self::clear_campaigns( $id );
			}

			wp_redirect( esc_url( add_query_arg() ) );
			exit;
		}
	}
}