<?php
class InfobarWPAnalytics
{
	public $variants, $tracking, $campaigns;

	function __construct(){
		global $wpdb;
		$this->campaigns =$wpdb->prefix . "ibwp_campaigns";
		$this->variants = $wpdb->prefix . "ibwp_variants";
		$this->tracking = $wpdb->prefix . "ibwp_tracking_visitors";
	}

	function getCampaignsList( $campaignID = false ){
		global $wpdb;

		if ( $campaignID == false ) {
			$query = "
				SELECT campaignTB.id AS campaignID, campaignTB.campaign_name AS campaignName,
				SUM(variantsTB.variant_impressions) AS impressions,
				SUM(variantsTB.variant_clicks) AS clicks,
				DATE(variantsTB.variant_first_visit) AS createdAT FROM {$this->campaigns} AS campaignTB
				INNER JOIN {$this->variants} AS variantsTB ON variantsTB.variant_campaign_id = campaignTB.id
				GROUP BY campaignTB.id ORDER BY impressions DESC";
		} else {
			$query = "
				SELECT variantsTB.id AS campaignID, variantsTB.variant_name AS campaignName,
				variantsTB.variant_impressions AS impressions,
				variantsTB.variant_clicks AS clicks,
				DATE(variantsTB.variant_first_visit) AS createdAT FROM {$this->variants} AS variantsTB
				WHERE variantsTB.variant_campaign_id = {$campaignID}
				GROUP BY variantsTB.id ORDER BY impressions DESC";
		}

		$campaigns = $wpdb->get_results( $query );

		return $campaigns;
	}

	function getFlag( $ipaddr ) {
		$countryCode = file_get_contents("http://geoip.wtanaka.com/cc/$ipaddr");
		return "http://geoip.wtanaka.com/flag/" . $countryCode . ".gif";
	}

	function getCampaignsTrackings( $campaignID = false ) {
		global $wpdb;

		if ( $campaignID == false )
			$query = "SELECT campaign_visitor_browser AS browser, COUNT(*) AS impressions FROM {$this->tracking} GROUP BY campaign_visitor_browser";
		else
			$query = "SELECT campaign_visitor_browser AS browser, COUNT(*) AS impressions FROM {$this->tracking} WHERE campaign_id = {$campaignID} GROUP BY campaign_visitor_browser";

		$statistics = $wpdb->get_results( $query );

		return $statistics;
	}

	function getVisitorsPerCampaign( $campaignID = false ){
		global $wpdb;
		
		if ( $campaignID == false )
			$query = "SELECT DISTINCT * FROM {$this->tracking} GROUP BY campaign_visitor_browser";
		else
			$query = "SELECT DISTINCT * FROM {$this->tracking} WHERE campaign_id = {$campaignID} GROUP BY campaign_visitor_browser";

		$visitors = $wpdb->get_results( $query );

		return $visitors;
	}
}
?>