<?php
if( !class_exists( 'InfobarWPListTable' ) ) {
	require_once IBWP_PLUGIN_DIR . 'src/classes/wp-list-table.class.php';
}

class InfobarWP {
	private static $instance = null;
	private $plugin_pages = array(
		'toplevel_page_infobar-managements',
		'infobars_page_infobar-analytics',
		'infobars_page_infobar-campaign'
	);

	public static function GetInstance() {
		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	private function __construct() {
		register_activation_hook( IBWP_PLUGIN_FILE, array( $this, 'activation' ) );

		add_action( 'init', array( $this, 'InitCalls' ) );
		add_action( 'admin_init', array( $this, 'manage_campaigns' ) );
		add_action( 'admin_menu', array( $this, 'RegisterMenus' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'RegisterAdminScripts' ) );
		add_action( 'plugins_loaded', array( $this, 'load_text_domain' ) );
		add_action( 'wp_ajax_ibwajax', array( $this, 'ajaxHandler' ) );
		add_action( 'wp_ajax_infobarwpfront', array( $this, 'infobarsGetter' ) );
		add_action( 'wp_ajax_nopriv_infobarwpfront', array( $this, 'infobarsGetter' ) );
		add_action( 'wp_ajax_infobarwptrackings', array( $this, 'infobarTrackingsAjax' ) );
		add_action( 'wp_ajax_nopriv_infobarwptrackings', array( $this, 'infobarTrackingsAjax' ) );
		add_action( 'template_redirect', array( $this, 'showBarInFront' ) );
	}

	public function load_text_domain() {
		load_plugin_textdomain( IBWP_PLUGIN_TEXTDOMAIN, false, IBWP_PLUGIN_DIR . '\lang' );
	}

	public function GetUrl( $file = '' ) {
		return IBWP_PLUGIN_URL . $file;
	}

	public function InitCalls(){
		if( isset($_GET['preview-campaign']) ) {
			show_admin_bar( false );
		}
	}

	public function IsPluginPage($hook_suffix){
		if( in_array( $hook_suffix, $this->plugin_pages ) )
			return true;
		else
			return false;
	}

	public function activation() {
		global $wpdb, $charset_collate;

		// required for dbdelta
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

		// Creating the campaigns table
		dbDelta(
			"CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "ibwp_campaigns` (
				id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
				campaign_name TEXT,
				campaign_variants TEXT,
				campaign_status VARCHAR(50),
				campaign_position TEXT,
				campaign_location TEXT,
				campaign_categories TEXT,
				campaign_pages TEXT,
				campaign_posts TEXT,
				campaign_browsers TEXT,
				campaign_settings longtext,
				campaign_date timestamp DEFAULT CURRENT_TIMESTAMP NOT NULL,
				PRIMARY KEY  (id)
			) " . $charset_collate . ";"
		);

		// Creating the variants table
		dbDelta(
			"CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "ibwp_variants` (
				id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
				variant_name TEXT,
				variant_status VARCHAR(50),
				variant_inner longtext,
				variant_wrap_styles longtext,
				variant_closebtn longtext,
				variant_settings longtext,
				variant_campaign_id TEXT,
				variant_impressions INT DEFAULT 0,
				variant_clicks INT DEFAULT 0,
				variant_first_visit timestamp,
				variant_last_visit timestamp,
				variant_date timestamp,
				PRIMARY KEY  (id)
			) " . $charset_collate . ";"
		);

		// Creating the tracking table
		dbDelta(
			"CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "ibwp_tracking_visitors` (
				id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
				campaign_id VARCHAR(50),
				campaign_visitor_browser TEXT,
				campaign_visitor_referer longtext,
				campaign_visitor_ip longtext,
				PRIMARY KEY  (id)
			) " . $charset_collate . ";"
		);
	}

	public function RegisterAdminScripts( $hook_suffix ) {
		if( !$this->IsPluginPage($hook_suffix) ) return false;

		wp_enqueue_script( 'infobarwp-classygradient', $this->GetUrl('src/assets/js/vendor/jquery.classygradient.min.js'), array('jquery'), '2.2' );
		wp_enqueue_script( 'infobarwp-colorpicker', $this->GetUrl('src/assets/js/vendor/jquery.colorpicker.js'), array('jquery'), '2.2' );
		wp_enqueue_script( 'infobarwp-sSelect', $this->GetUrl('src/assets/js/vendor/stylish-select.js'), array('jquery'), '2.2' );
		wp_enqueue_script( 'infobarwp-fancybox', 'https://cdnjs.cloudflare.com/ajax/libs/fancybox/2.1.5/jquery.fancybox.min.js', array('jquery'), '2.2' );
		wp_enqueue_script( 'infobarwp-css-gradient-generator', $this->GetUrl('src/assets/js/vendor/jquery.classygradient.min.js'), array('jquery', 'jquery-ui-draggable'), '2.2' );
		wp_enqueue_script( 'infobarwp-backend', $this->GetUrl('src/assets/js/backend.js'), array('jquery', 'jquery-ui-datepicker', 'jquery-ui-slider'), '2.2' );

		wp_register_style( 'infobarwp-metro', $this->GetUrl('src/assets/css/metro.min.css'), array(), '2.2' );
		wp_register_style( 'infobarwp-css-gradient-generator', $this->GetUrl('src/assets/css/classgradients.css'), array(), '2.2' );
		wp_register_style( 'infobarwp-colorpicker', $this->GetUrl('src/assets/css/colorpicker.css'), array(), '2.2' );
		wp_register_style( 'infobarwp-metro-icons', $this->GetUrl('src/assets/css/metro-icons.min.css'), array(), '2.2' );
		wp_register_style( 'infobarwp-bootstrap', 'https://maxcdn.bootstrapcdn.com/bootstrap/2.1.1/css/bootstrap.min.css', array(), '3.3.5' );
		wp_register_style( 'infobarwp-fancybox', 'https://cdnjs.cloudflare.com/ajax/libs/fancybox/2.1.5/jquery.fancybox.min.css', array(), '3.3.5' );
		wp_register_style( 'infobarwp-main', $this->GetUrl('src/assets/css/main.css'), array(), '2.2' );
		wp_register_style( 'infobarwp-analytics', $this->GetUrl('src/assets/css/analytics.css'), array(), '2.2' );

		wp_enqueue_style('jquery-style', 'http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.2/themes/smoothness/jquery-ui.css');
		wp_enqueue_style('fontawesome', 'http://maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css');
		wp_enqueue_style('font-awesome-animations', $this->GetUrl('src/assets/css/font-awesome-animations.min.css'));

		if ( $hook_suffix != 'toplevel_page_infobar-managements' && $hook_suffix != 'infobars_page_infobar-analytics' ) {
			wp_enqueue_style( 'infobarwp-metro' );
			wp_enqueue_style( 'infobarwp-metro-icons' );
			wp_enqueue_style( 'infobarwp-css-gradient-generator' );
			wp_enqueue_style( 'infobarwp-colorpicker' );
			wp_enqueue_style( 'infobarwp-fancybox' );
			wp_enqueue_style( 'editor-buttons' );
			wp_enqueue_media();
		}

		if ( $hook_suffix == 'infobars_page_infobar-analytics' ) {
			wp_enqueue_style( 'infobarwp-bootstrap' );
			wp_enqueue_style( 'infobarwp-analytics' );
		} else {
			wp_enqueue_style( 'infobarwp-main' );
		}
	}

	public function RegisterMenus() {
		add_menu_page( __( 'Campaign Management Page', IBWP_PLUGIN_TEXTDOMAIN ), __('Infobars', IBWP_PLUGIN_TEXTDOMAIN), 'administrator', 'infobar-managements', '', $this->GetUrl('src/assets/images/icon.png') );
		add_submenu_page( 'infobar-managements', __( 'Campaign Management Page', IBWP_PLUGIN_TEXTDOMAIN ), __( 'All Infobars', IBWP_PLUGIN_TEXTDOMAIN ), 'administrator', 'infobar-managements',array($this,'ManagementPage'));
		add_submenu_page( 'infobar-managements', __( 'Add/Edit Campaign', IBWP_PLUGIN_TEXTDOMAIN ), __( 'Add New', IBWP_PLUGIN_TEXTDOMAIN ), 'administrator', 'infobar-campaign',array($this,'CampaignPage'));
		add_submenu_page( 'infobar-managements', __( 'Infobar Analytics', IBWP_PLUGIN_TEXTDOMAIN ), __( 'Analytics', IBWP_PLUGIN_TEXTDOMAIN), 'administrator', 'infobar-analytics', array($this,'AnalyticsPage'));
	}

	public function ManagementPage(){
		$data = new InfobarWPListTable();
		$data->prepare_items();

		include_once IBWP_PLUGIN_DIR . 'src/views/common/header.php';

		$data->display();

		include_once IBWP_PLUGIN_DIR . 'src/views/common/footer.php';
	}

	public function manage_campaigns() {
		if ( isset( $_GET['page'], $_POST['ibw_save_campaign'] ) && $_GET['page'] === 'infobar-campaign' && ! empty( $_POST['_wpnonce'] ) ) {
			global $wpdb;

			// add new campaign
			if ( wp_verify_nonce( $_POST['_wpnonce'], 'ibw-add-campaign' ) ) {
				unset( $_POST['variants']['{{index}}'] );

				$campaignName = isset( $_POST['campaign-name'] ) ? $_POST['campaign-name'] : '';
				$campaignStatus = ( isset( $_POST['campaign-status'] ) && $_POST['campaign-status'] == 1 ) ? 1 : 0;
				$campaignVariantsArr = array();

				$campaignCategories = ! empty( $_POST['campaign-location-categories'] ) ? $_POST['campaign-location-categories'] : array();
				$campaignPages = ! empty( $_POST['campaign-location-pages'] ) ? $_POST['campaign-location-pages'] : array();
				$campaignPosts = ! empty( $_POST['campaign-location-posts'] ) ? $_POST['campaign-location-posts'] : array();

				$settingsArr = array(
					'campaign_settings' => array(
						'activity' => '',
						'timing' => isset( $_POST['campaign-showing-times'] ) ? (int)$_POST['campaign-showing-times'] : 0,
						'startdate' => isset( $_POST['start-date'] ) ? $_POST['start-date'] : '',
						'enddate' => isset( $_POST['end-date'] ) ? $_POST['end-date'] : '',
						'duration' => isset( $_POST['campaign-show-before'] ) ? (int)$_POST['campaign-show-before'] : 0,
						'showafterhits' => isset( $_POST['campaign-showafter-views'] ) ? (int)$_POST['campaign-showafter-views'] : 0,
						'onclose' => isset( $_POST['campaign-onclose'] ) ? (int)$_POST['campaign-onclose'] : 0,
						'daysoff' => isset( $_POST['campaign-daysoff'] ) ? (int)$_POST['campaign-daysoff'] : 0,
						'winninginfobar' => isset( $_POST['campaign-winning-ib'] ) ? (int)$_POST['campaign-winning-ib'] : 0,
						'bestconverting' => isset( $_POST['campaign-best-converting'] ) ? (int)$_POST['campaign-best-converting'] : 0,
						'campaign_referrer_option' => isset( $_POST['referrer-option'] ) ? $_POST['referrer-option'] : '',
						'campaign_referrer' => isset( $_POST['campaign-referrer'] ) ? $_POST['campaign-referrer'] : ''
					)
				);

				$settings = json_encode($settingsArr);

				$insert = array(
					'campaign_name' => stripslashes( $campaignName ),
					'campaign_status' => $campaignStatus,
					'campaign_position' => $_POST['campaign-position'],
					'campaign_location' => $_POST['campaign-location'],
					'campaign_categories' => implode(',', $campaignCategories),
					'campaign_pages' => implode(',', $campaignPages),
					'campaign_posts' => implode(',', $campaignPosts),
					'campaign_browsers' => $_POST['campaign-browsers'],
					'campaign_settings' => $settings
				);

				$wpdb->insert( $wpdb->prefix . 'ibwp_campaigns', $insert );
				$infobarID = (int) $wpdb->insert_id;

				foreach( $_POST['variants'] as $variant ) {
					$name = $variant['variant-name'];
					$content = $variant['content'];
					$wrap = $variant['wrap-styles'];
					$close = $variant['closebtn'];
					$status = $variant['status'];

					// settings
					$skins = $variant['skins'];
					$gradient = $variant['gradient'];
					$borderWidth = $variant['border-width'];
					$textColor = $variant['text-color'];
					$linkColor = $variant['link-color'];
					$borderColor = $variant['border-color'];

					$variantSettings = array( 
						'skin' => $skins,
						'gradient' => $gradient,
						'borderwidth' => $borderWidth,
						'textcolor' => $textColor,
						'linkcolor' => $linkColor,
						'bordercolor' => $borderColor
					);

					$insert = array(
						'variant_name' => stripslashes($name),
						'variant_status' => $status,
						'variant_inner' => stripslashes($content),
						'variant_wrap_styles' => stripslashes($wrap),
						'variant_closebtn' => stripslashes($close),
						'variant_settings' => json_encode( $variantSettings ),
						'variant_campaign_id' => $infobarID,
						'variant_date' => current_time( 'mysql', false )
					);

					$wpdb->insert( $wpdb->prefix . 'ibwp_variants', $insert );
					$lastID = $wpdb->insert_id;

					if ( $lastID )
						$campaignVariantsArr[] = $wpdb->insert_id;
				}

				$campaignVariants = implode(',', $campaignVariantsArr);

				$wpdb->update(
					$wpdb->prefix . 'ibwp_campaigns', 
					array(
						'campaign_variants' => $campaignVariants,
					), 
					array( 'id' => $infobarID )
				);

				if ( $infobarID ) {
					wp_redirect( admin_url( '/admin.php?page=infobar-campaign&id=' . $infobarID . '&action=edit&message=added' ) );
					exit;
				}
			// edit campaign
			} elseif ( wp_verify_nonce( $_POST['_wpnonce'], 'ibw-edit-campaign' ) ) {
				$infobarID = $_GET['id'];

				unset( $_POST['variants']['{{index}}'] );

				$campaignName = isset( $_POST['campaign-name'] ) ? $_POST['campaign-name'] : '';
				$campaignStatus = ( isset( $_POST['campaign-status'] ) && $_POST['campaign-status'] == 1 ) ? 1 : 0;
				$campaignVariantsArr = array();

				if ( count( $_POST['variants'] ) > 0 ) {
					foreach( $_POST['variants'] as $variant ) {
						$name = $variant['variant-name'];
						$content = $variant['content'];
						$wrap = $variant['wrap-styles'];
						$close = $variant['closebtn'];
						$status = $variant['status'];
						$skins = $variant['skins'];
						$gradient = $variant['gradient'];
						$borderWidth = $variant['border-width'];
						$textColor = $variant['text-color'];
						$linkColor = $variant['link-color'];
						$borderColor = $variant['border-color'];

						$variantSettings = array( 
							'skin' => $skins,
							'gradient' => $gradient,
							'borderwidth' => $borderWidth,
							'textcolor' => $textColor,
							'linkcolor' => $linkColor,
							'bordercolor' => $borderColor
						);

						if( isset($variant['id']) ) {
							$wpdb->update( 
								$wpdb->prefix . 'ibwp_variants', 
								array( 
									'variant_name' => stripslashes($name),
									'variant_status' => $status,
									'variant_inner' => stripslashes($content),
									'variant_wrap_styles' => stripslashes($wrap),
									'variant_closebtn' => stripslashes($close),
									'variant_settings' => json_encode( $variantSettings ),
								), 
								array( 'id' => $variant['id'] )
							);
							$campaignVariantsArr[] = $variant['id'];
						} else {
							$insert = array(
								'variant_name' => $name,
								'variant_status' => $status,
								'variant_inner' => stripslashes($content),
								'variant_wrap_styles' => stripslashes($wrap),
								'variant_closebtn' => stripslashes($close),
								'variant_settings' => json_encode( $variantSettings ),
								'variant_campaign_id' => $infobarID,
								'variant_date' => current_time( 'mysql', false )
							);

							$wpdb->insert( $wpdb->prefix . 'ibwp_variants', $insert );
							$lastID = $wpdb->insert_id;
							if( $lastID ) $campaignVariantsArr[] = $wpdb->insert_id;
						}
					}
				}

				$campaignVariants = implode(',', $campaignVariantsArr);

				$campaignCategories = ! empty( $_POST['campaign-location-categories'] )? $_POST['campaign-location-categories'] : array();
				$campaignPages = ! empty( $_POST['campaign-location-pages'] )? $_POST['campaign-location-pages'] : array();
				$campaignPosts = ! empty( $_POST['campaign-location-posts'] )? $_POST['campaign-location-posts'] : array();

				$settingsArr = array(
					'campaign_settings' => array(
						'activity' => '',
						'timing' => isset( $_POST['campaign-showing-times'] ) ? (int)$_POST['campaign-showing-times'] : 0,
						'startdate' => isset( $_POST['start-date'] ) ? $_POST['start-date'] : '',
						'enddate' => isset( $_POST['end-date'] ) ? $_POST['end-date'] : '',
						'duration' => isset( $_POST['campaign-show-before'] ) ? (int)$_POST['campaign-show-before'] : 0,
						'showafterhits' => isset( $_POST['campaign-showafter-views'] ) ? (int)$_POST['campaign-showafter-views'] : 0,
						'onclose' => isset( $_POST['campaign-onclose'] ) ? (int)$_POST['campaign-onclose'] : 0,
						'daysoff' => isset( $_POST['campaign-daysoff'] ) ? (int)$_POST['campaign-daysoff'] : 0,
						'winninginfobar' => isset( $_POST['campaign-winning-ib'] ) ? (int)$_POST['campaign-winning-ib'] : 0,
						'bestconverting' => isset( $_POST['campaign-best-converting'] ) ? (int)$_POST['campaign-best-converting'] : 0,
						'campaign_referrer_option' => isset( $_POST['referrer-option'] ) ? $_POST['referrer-option'] : '',
						'campaign_referrer' => isset( $_POST['campaign-referrer'] ) ? $_POST['campaign-referrer'] : ''
					)
				);

				$settings = json_encode($settingsArr);

				$wpdb->update( 
					$wpdb->prefix . 'ibwp_campaigns', 
					array( 
						'campaign_name' => stripslashes($campaignName),
						'campaign_variants' => $campaignVariants,
						'campaign_status' => $campaignStatus,
						'campaign_position' => $_POST['campaign-position'],
						'campaign_location' => $_POST['campaign-location'],
						'campaign_categories' => implode(',', $campaignCategories),
						'campaign_browsers' => $_POST['campaign-browsers'],
						'campaign_pages' => implode(',', $campaignPages),
						'campaign_posts' => implode(',', $campaignPosts),
						'campaign_settings' => $settings
					), 
					array( 'id' => $infobarID )
				);

				wp_redirect( admin_url( '/admin.php?page=infobar-campaign&id=' . $infobarID . '&action=edit&message=edited' ) );
				exit;
			}	
		}
	}

	public function CampaignPage() {
		global $wpdb;

		$editing = false;

		if( isset( $_GET['action'] ) && $_GET['action'] == 'edit' ) {
			$campaign_id = isset( $_GET['id'] ) ? $_GET['id'] : false;
			$count = $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM {$wpdb->prefix}ibwp_campaigns WHERE id = '%d'", $campaign_id ) );

			if ( $campaign_id != false && $count == 1 )
				$editing = true;
			else {
				wp_redirect( admin_url( '/admin.php?page=infobar-managements' ) );
				exit;
			}
		}

		include_once IBWP_PLUGIN_DIR . 'src/views/common/header.php';
		include_once IBWP_PLUGIN_DIR . 'src/views/sections/infobar-campaign.php';
		include_once IBWP_PLUGIN_DIR . 'src/views/common/footer.php';
	}

	public function AnalyticsPage(){
		include_once IBWP_PLUGIN_DIR . 'src/views/common/header.php';
		include_once IBWP_PLUGIN_DIR . 'src/views/sections/infobar-analytics.php';
		include_once IBWP_PLUGIN_DIR . 'src/views/common/footer.php';
	}

	public function showBarInFront() {
		if( is_admin() )
			return;

		global $post;

		wp_register_script( 'infobarwp-front', $this->GetUrl( 'src/assets/js/front.js' ), array( 'jquery' ) );
		wp_enqueue_script( 'infobarwp-front' );

		$jsdata = array(
			'ajaxurl' => wp_nonce_url( add_query_arg( array( 'action' => 'infobarwpfront' ), admin_url( 'admin-ajax.php' ) ), 'infobarwpfront', 'nonce' ), 
			'ajaxutrackings' => wp_nonce_url( add_query_arg( array( 'action' => 'infobarwptrackings' ), admin_url( 'admin-ajax.php' ) ), 'infobarwptrackings', 'nonce' ), 
			'id' => ( is_single() || is_page() ) ? $post->ID : false, 
			'category' => is_category() ? get_queried_object_id() : false
		);

		if ( is_home() || is_front_page() ) {
			$jsdata['type'] = 'home';
			$jsdata['home'] = 1;
		} else {
			$jsdata['home'] = 0;

			if( is_page() )
				$jsdata['type'] = 'page';
			elseif( is_single() )
				$jsdata['type'] = 'post';
			elseif( is_category() )
				$jsdata['type'] = 'category';
			else
				$jsdata['type'] = 'error';
		}

		wp_localize_script( 'infobarwp-front', 'ajaxparams', $jsdata );
		wp_register_style( 'infobarwp-front', $this->GetUrl('src/assets/css/front.css'), array(), '2.2' );
		wp_enqueue_style( 'fontawesome', 'http://maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css');
		wp_enqueue_style( 'font-awesome-animations', $this->GetUrl( 'src/assets/css/font-awesome-animations.min.css' ) );
		wp_enqueue_style( 'infobarwp-front' );
	}

	public function UploadProcessor( $file ) {
		$attachment = $this->UploadHandler( $file );

		if ( is_array( $attachment ) )
			return $attachment['id'];
	}

	public function UploadHandler($upload_data) {
		include_once(ABSPATH.'wp-admin/includes/media.php');
		include_once(ABSPATH.'wp-admin/includes/file.php');
		include_once(ABSPATH.'wp-admin/includes/image.php');

		$return = false;
		$uploaded_file = wp_handle_upload($upload_data, array('test_form' => false));
		$file_name = basename($upload_data['name']);
		$file_type = wp_check_filetype($file_name);
		$allowedExts = array( 'jpg', 'jpeg', 'png', 'gif', 'bmp' );

		if ( in_array($file_type['ext'], $allowedExts) && isset($uploaded_file['file']) ) {

			$file_loc = $uploaded_file['file'];

			$attachment = array(
				'post_mime_type' => $file_type['type'],
				'post_title' => preg_replace('/\.[^.]+$/', '', basename($file_name)),
				'post_content' => '',
				'post_status' => 'inherit'
			);

			$attach_id = wp_insert_attachment($attachment, $file_loc);
			$attach_data = wp_generate_attachment_metadata($attach_id, $file_loc);
			wp_update_attachment_metadata($attach_id, $attach_data);

			$return = array('data' => $attach_data, 'id' => $attach_id);

			return $return;
		}

		return $return;
	}

	public function clearAnalytics( $id ) {
		global $wpdb;

		if( $wpdb->delete( "{$wpdb->prefix}ibwp_tracking_visitors", array( 'campaign_id' => $id ) ) ) {
			$wpdb->update( 
				$wpdb->prefix . 'ibwp_variants', 
				array( 
					'variant_impressions' => 0,
					'variant_clicks' => 0
				), 
				array( 'variant_campaign_id' => $id )
			);
		}

		return true;
	}

	public function ajaxHandler() {
		global $wpdb;
		$self = $this;
		$ibwAction = $_POST['ibw-action'];

		switch( $ibwAction ) {
			case 'upload-image':
				$media = $_FILES['media'];
				$mediaID = $this->UploadProcessor($media);

				$fullimage = wp_get_attachment_image( $mediaID, 'full', '', array( 'class' => 'image-el' ) );

				echo '<script language="javascript" type="text/javascript">window.top.window.infobarwp.addons.variantsManager.uploadsHandler('. json_encode( array( 'msg' => 'ok', 'img' => $fullimage ) ).');</script>  ';
				break;

			case 'remove-variant':
					$id = $_POST['id'];
					if( $wpdb->delete( "{$wpdb->prefix}ibwp_variants", array( 'id' => $id ) ) ){
						echo 'ok';
					}
				break;
			case 'clone-campaign':
					$id = $_POST['campaignid'];
					if( $self->cloneCampaign($id) ){
						echo 'ok';
					}
				break;
			case 'clear-analytics':
					$id = $_POST['campaignid'];
					if( $self->clearAnalytics($id) ){
						echo 'ok';
					}
				break;

			case 'inlineedit-campaign':
					$id = (int) $_POST['campaignid'];
					$name = $_POST['cname'] ;
					$timing = $_POST['conchange'] ;
					$pos = $_POST['cpos'] ;
					$duration = $_POST['duration'] ;
					$startdate = $_POST['startdate'] ;
					$enddate = $_POST['enddate'] ;
					$showafterhits = $_POST['showafterhits'] ;

					$settingsJSON = $wpdb->get_var($wpdb->prepare("SELECT campaign_settings FROM {$wpdb->prefix}ibwp_campaigns WHERE id = '%d'", $id));

					$settings = json_decode( $settingsJSON, ARRAY_A );

					$settings['campaign_settings']['duration'] = $duration;
					$settings['campaign_settings']['showafterhits'] = $showafterhits;
					$settings['campaign_settings']['timing'] = $timing;
					$settings['campaign_settings']['startdate'] = $startdate;
					$settings['campaign_settings']['enddate'] = $enddate;

					$wpdb->update( 
						$wpdb->prefix . 'ibwp_campaigns', 
						array( 
							'campaign_name' => stripslashes($name),
							'campaign_position' => $pos,
							'campaign_settings' => json_encode($settings)
						), 
						array( 'id' => $id )
					);
					echo 'ok';
				break;

			case 'remove-campaign':
					$id = $_POST['campaignid'];
					if( $wpdb->delete( "{$wpdb->prefix}ibwp_campaigns", array( 'id' => $id ) ) ){
						$wpdb->delete( "{$wpdb->prefix}ibwp_variants", array( 'variant_campaign_id' => $id ) );
						$wpdb->delete( "{$wpdb->prefix}ibwp_tracking_visitors", array( 'campaign_id' => $id ) );
					}
				break;
			case 'campaign-status':
					$id = $_POST['id'];
					$status = $_POST['status'];
					$wpdb->update( 
						$wpdb->prefix . 'ibwp_campaigns', 
						array( 
							'campaign_status' => $status,
						), 
						array( 'id' => $id )
					);
					echo 'ok';
				break;
			
		}

		wp_die();
	}

	public function infobarsGetter() {
		global $wpdb;

		header( "Content-type: text/javascript" );

		if ( isset($_GET['preview-campaign']) ) {
			$previewID = $_GET['preview-campaign'];
			$campaign = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}ibwp_campaigns WHERE id = {$previewID}");

			$data[0]['haspreview'] = 1;
			$data[0]['campaign_name'] = $campaign->campaign_name;
			$data[0]['campaign_position'] = $campaign->campaign_position;
			$data[0]['campaign_settings'] = $campaign->campaign_settings;
			$data[0]['campaign_variants'] = array();
			$variants = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}ibwp_variants WHERE variant_campaign_id = {$campaign->id} AND variant_status = 'on' ORDER BY variant_last_visit ASC LIMIT 1");
			$k = 0;
			foreach( $variants as $variantRow ) :
				$id = $variantRow->id;
				$vname = $variantRow->variant_name;
				$vcontent = $variantRow->variant_inner;
				$vstyles = $variantRow->variant_wrap_styles;
				$vclosebtn = $variantRow->variant_closebtn;
				$vsettings = json_decode( $variantRow->variant_settings, true );
				if( $vsettings['skin'] == '26' ){
					$borderwidth = $vsettings['borderwidth'];
					$bordercolor = $vsettings['bordercolor'];

					$posV = ( $data[0]['campaign_position'] == 'Footer' )? 'top' : 'bottom';

					$vstyles .= 'border-'.$posV.'-width:'.$borderwidth.'px; border-'.$posV.'-color:'.$bordercolor.';';

					//$vstyles .= 'border-bottom-width:'.$borderwidth.'px; border-bottom-color:'.$bordercolor.';';
				}

				$data[0]['campaign_variants'][$k]['ID'] = $id;
				$data[0]['campaign_variants'][$k]['name'] = $vname;
				$data[0]['campaign_variants'][$k]['content'] = '<div class="content">' . $vcontent . '</div><span class="close">'. $vclosebtn .'</span>';
				$data[0]['campaign_variants'][$k]['styles'] = $vstyles;
				$data[0]['campaign_variants'][$k]['closebtn'] = $vclosebtn;
				$k++;
				$lastvisitsql = "UPDATE {$wpdb->prefix}ibwp_variants SET variant_last_visit = CURRENT_TIMESTAMP WHERE id={$id}";
				$wpdb->query($lastvisitsql);
			endforeach;
		} else {
			$location = isset( $_GET['type'] ) ? $_GET['type'] : 'home';
			$id = isset($_GET['id'])? $_GET['id'] : false;
			$category = isset($_GET['category'])? $_GET['category'] : false;
			$browser = isset($_GET['browser'])? $_GET['browser'] : 'All';
			$href = isset($_GET['href'])? $_GET['href'] : home_url( '/' );

			$data = $this->getInfobarData( $location, $id, $category, $browser, $href );
		}

		echo "var _jsondata = " . json_encode($data) . ";";
		echo "ibwpfront.treatCampaign(_jsondata);";
		die();
	}

	public function infobarTrackingsAjax(){
		global $wpdb;
		$ibwAction = $_POST['ibw-action'];
		$variantid = (int) $_POST['variantid'];
		switch ($ibwAction) {
			case 'track-clicks':
				$sql = "UPDATE {$wpdb->prefix}ibwp_variants SET variant_clicks = variant_clicks + 1 WHERE id={$variantid}";
				$wpdb->query($sql);
				break;
			case 'track-impressions':
				$firstvisit = $wpdb->get_var( "SELECT variant_first_visit FROM {$wpdb->prefix}ibwp_variants WHERE id={$variantid}" );
				if( $firstvisit == NULL ){
					$sql = "UPDATE {$wpdb->prefix}ibwp_variants SET variant_first_visit = CURRENT_TIMESTAMP WHERE id={$variantid}";
					$wpdb->query($sql);
				}
				$sql = "UPDATE {$wpdb->prefix}ibwp_variants SET variant_impressions = variant_impressions + 1 WHERE id={$variantid}";
				$wpdb->query($sql);

				$lastvisitsql = "UPDATE {$wpdb->prefix}ibwp_variants SET variant_last_visit = CURRENT_TIMESTAMP WHERE id={$variantid}";
				$wpdb->query($lastvisitsql);
				break;
		}
		die();
	}

	public function checkDate($start, $end){
		$currentDate = date('Y-m-d');
		$start_ts = strtotime($start);
		$end_ts = strtotime($end);
		$user_ts = strtotime($currentDate);
		$return = (($user_ts >= $start_ts) && ($user_ts <= $end_ts))? true : false;
		return $return;
	}

	public function campaignsTracking( $data = array(), $get = false ){
		global $wpdb;
		if( $get == true ){
			$trafficCount = $wpdb->get_var( "SELECT COUNT(*) FROM {$wpdb->prefix}ibwp_tracking_visitors WHERE campaign_id = ".$data['id'] );
			return $trafficCount;
		}else{
			$insert = array(
				'campaign_id' => $data['id'],
				'campaign_visitor_browser' => $data['browser'],
				'campaign_visitor_referer' => $data['referer'],
				'campaign_visitor_ip' => $data['ip'],
			);

			$wpdb->insert( $wpdb->prefix . 'ibwp_tracking_visitors', $insert );
		}
	}

	public function getBrowserTraffic($browser){
		global $wpdb;
		$total = $wpdb->get_var( "SELECT COUNT(*) FROM {$wpdb->prefix}ibwp_tracking_visitors WHERE campaign_visitor_browser = '{$browser}'" );
		echo $total;
	}

	public function cloneCampaign($id) {
		global $wpdb;
		$campaign = $wpdb->get_results($wpdb->prepare(
			"SELECT * FROM {$wpdb->prefix}ibwp_campaigns WHERE id = %d",
			$id
		), ARRAY_A);

		if (count($campaign) > 0) {
			foreach ($campaign as $campaignData) {
				unset($campaignData['id']);
				unset($campaignData['campaign_date']);
				$campaignData['campaign_name'] = $campaignData['campaign_name'] . ' - Duplicate';
				$wpdb->insert( $wpdb->prefix . 'ibwp_campaigns', $campaignData);
				$newCampaignID = $wpdb->insert_id;

				$variants = $wpdb->get_results($wpdb->prepare(
					"SELECT * FROM {$wpdb->prefix}ibwp_variants WHERE variant_campaign_id = %d",
					$id
				), ARRAY_A);
				if (count($variants) > 0) {
					foreach ($variants as $variantData) {
						unset($variantData['id']);
						unset($variantData['variant_date']);
						$variantData['variant_campaign_id'] = $newCampaignID;
						$wpdb->insert( $wpdb->prefix . 'ibwp_variants', $variantData);
					}
				}		
			}
		}
		return true;
	}
	
	public function getInfobarData( $location, $id, $category, $browser, $href ) {
		global $wpdb;

		$data = array();
		$additionalStatement = '';

		if ( $location === 'inner' )
			$location = 'page';

		switch ( $location ) {
			case 'page':
				$additionalStatement = " OR (campaign_location = 'page' AND FIND_IN_SET('{$id}', `campaign_pages`)) OR campaign_location = 'inner' OR campaign_location = 'all'";
				break;

			case 'post':
				$additionalStatement = " OR (campaign_location = 'post' AND FIND_IN_SET('{$id}', `campaign_posts`)) OR campaign_location = 'all'";
				break;

			case 'category':
				$additionalStatement = " OR (campaign_location = 'category' AND FIND_IN_SET('{$category}', `campaign_categories`)) OR campaign_location = 'all'";
				break;

			case 'home':
				$additionalStatement = " OR campaign_location = 'home'";
				break;
		}

		$campaigns = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . "ibwp_campaigns WHERE ( campaign_browsers = 'All' OR campaign_browsers = '" . $browser . "' ) AND ( campaign_location = '-1'" . $additionalStatement . " ) AND campaign_status = 1" );
		$i = 0;

		foreach( $campaigns as $campaign ) {
			$data[$i]['haspreview'] = 0;
			$data[$i]['campaign_id'] = $campaign->id;
			$data[$i]['campaign_name'] = $campaign->campaign_name;
			$data[$i]['campaign_position'] = $campaign->campaign_position;
			$data[$i]['campaign_settings'] = $campaign->campaign_settings;
			$data[$i]['campaign_variants'] = array();

			$settings = json_decode($campaign->campaign_settings);

			if( $settings->campaign_settings->campaign_referrer_option == '1' ) {
				$refData = parse_url($href);

				if ( strpos( $refData['host'], $settings->campaign_settings->campaign_referrer ) === false ) {
					unset( $data[$i] );
					continue;
				}
			}

			if ( $settings->campaign_settings->timing == 1 && ! $this->checkDate( $settings->campaign_settings->startdate, $settings->campaign_settings->enddate ) ) {
				unset($data[$i]);
				continue;
			}

			if ( $settings->campaign_settings->bestconverting == 1 ) {
				$winninginfobar = $settings->campaign_settings->winninginfobar;
				$sqlquery = "SELECT *, ( variant_clicks / variant_impressions ) AS bestconverting FROM {$wpdb->prefix}ibwp_variants WHERE variant_campaign_id = {$campaign->id} AND variant_status = 'on' AND variant_impressions >= {$winninginfobar} ORDER BY bestconverting DESC LIMIT 1";
			} else
				$sqlquery = "SELECT * FROM {$wpdb->prefix}ibwp_variants WHERE variant_campaign_id = {$campaign->id} AND variant_status = 'on' ORDER BY variant_last_visit ASC LIMIT 1";

			$variants = $wpdb->get_results( $sqlquery );

			if ( count($variants) < 1 ) {
				$variants = $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}ibwp_variants WHERE variant_campaign_id = {$campaign->id} AND variant_status = 'on' ORDER BY variant_impressions DESC LIMIT 1" );
			}

			$k = 0;

			foreach( $variants as $variantRow ) {
				$id = $variantRow->id;
				$vname = $variantRow->variant_name;
				$vcontent = $variantRow->variant_inner;
				$vstyles = $variantRow->variant_wrap_styles;
				$vclosebtn = $variantRow->variant_closebtn;
				$vsettings = json_decode( $variantRow->variant_settings, true );
				if( $vsettings['skin'] == '26' ){
					$borderwidth = $vsettings['borderwidth'];
					$bordercolor = $vsettings['bordercolor'];

					$posV = ( $data[$i]['campaign_position'] == 'Footer' )? 'top' : 'bottom';

					$vstyles .= 'border-'.$posV.'-width:'.$borderwidth.'px; border-'.$posV.'-color:'.$bordercolor.';';
				}

				$data[$i]['campaign_variants'][$k]['ID'] = $id;
				$data[$i]['campaign_variants'][$k]['name'] = $vname;
				$data[$i]['campaign_variants'][$k]['content'] = '<div class="content">' . $vcontent . '</div><span class="close">'. $vclosebtn .'</span>';
				$data[$i]['campaign_variants'][$k]['styles'] = $vstyles;
				$data[$i]['campaign_variants'][$k]['closebtn'] = $vclosebtn;
				$k++;
			}

			// Track campaign's data
			$trackingData = array(
				'id' => $campaign->id,
				'browser' => $browser,
				'referer' => $href,
				'ip' => $_SERVER['REMOTE_ADDR']
			);

			$this->campaignsTracking($trackingData);
			$i++;
		}

		return $data;
	}
}

InfobarWP::GetInstance();