<?php 
  require_once IBWP_PLUGIN_DIR . 'src/classes/wpinfobar-analytics.class.php';
  $analytics = new InfobarWPAnalytics;

  if( !isset( $_GET['overview'] ) ) :
?>
<script type="text/javascript" src="https://www.google.com/jsapi"></script>

<script type="text/javascript">
    var statisticContext = {};
    (function($) {
        statisticContext = {
            // default data that is used when data for the method drawChart is not specified
            defaultData: null,
            // default chart options that will be changed when the chart is drawing
            defaultOptions: {
                isStacked: true,
                legend: {
                    position: 'in',
                    format: 'dd MMM'
                },
                pointSize: 7,
                lineWidth: 3,
                //curveType: 'function',
                tooltip: {
                    showColorCode: true,
                    textStyle: {
                        fontSize: '11',
                        color: '#333'
                    }
                },
                hAxis: {
                    baselineColor: '#fff',
                    gridlines: {
                        color: '#fff'
                    },
                    textStyle: {
                        fontSize: '11',
                        color: '#333'
                    },
                    format: 'dd MMM'
                },
                vAxis: {
                    baselineColor: '#000',
                    gridlines: {
                        color: '#f6f6f6'
                    },
                    textPosition: 'in',
                    textStyle: {
                        fontSize: '11',
                        color: '#333'
                    }
                },
                chartArea: {
                    height: '300',
                    width: '95%',
                    top: 5
                }
            },

            init: function() {
                var self = this;
                this.defaultData = defaultChartData;
                this.resetToDefault();
                $("#chart-type-group").find("button").click(function() {
                    var type = $(this).data('value');
                    if (window.localStorage) window.localStorage.setItem('infobar-chart-type', type);
                    self.drawChart(null, type);
                });
                if (window.localStorage) {
                    var type = localStorage.getItem('infobar-chart-type');
                    var btnType = '.type-' + type;
                    $("#chart-type-group").find("button.active").removeClass('active');
                    $("#chart-type-group").find(btnType).click();
                }
                $('#date-start')
                    .datepicker()
                    .bind('changeDate', function(ev) {
                        $('#date-start').datepicker('hide');
                    });

                $('#date-end')
                    .datepicker()
                    .bind('changeDate', function(ev) {
                        $('#date-end').datepicker('hide');
                    });

                $(window).resize(function() {
                    self.drawChart();
                });
            },

            resetToDefault: function() {
                this.currentType = null;
                this.currentData = null;
            },

            drawChart: function(data, type) {

                type = type || this.currentType || 'stats';
                data = data || this.currentData || this.defaultData;
                this.currentType = type;
                this.currentData = data;
                data = data[type];

                if (!type) type = 'stats';
                if (!data) data = this.defaultData[type];
                var options = $.extend({}, this.defaultOptions);
                var chartFunction = 'LineChart';
                // Create the data table.
                var dataTable = new google.visualization.DataTable();

                if (type == 'stats') {

                    //chartFunction = 'AreaChart';
                    chartFunction = 'LineChart';
                    options.areaOpacity = 0.1;
                    options.colors = ["#7089be", "#CE1E26"];
                    dataTable.addColumn('date', 'Date');
                    dataTable.addColumn('number', 'Impressions');
                    dataTable.addColumn('number', 'Clicks');
                    dataTable.addColumn({
                        type: 'string',
                        role: 'tooltip'
                    });
                } else if (type == 'browsers') {

                    chartFunction = 'PieChart';
                    options.areaOpacity = 0.1;
                    options.is3D = true;
                    options.tooltip.text = 'value';
                    //options.pieSliceText="none";
                    options.legend.position = 'right';
                    //options.chartArea={left:6,top:6,width:"300px",height:"300px"}
                    //options.colors = ["#7089be","#3ab9e9","#e26f61","#51A3C9","#CE1E26","#A8A8A8"];
                    dataTable.addColumn('string', 'browsers');
                    dataTable.addColumn('number', 'clicks');
                    //dataTable.addColumn({type:'string',role:'tooltip'});
                }
                dataTable.addRows(data);
                // Instantiate and draw our chart, passing in some options.
                var chart = new google.visualization[chartFunction](document.getElementById('chart'));
                chart.draw(dataTable, options);
            }
        };

        $(function() {
            statisticContext.init();
        });
    })(jQuery)

    google.load("visualization", "1", {
        packages: ["corechart"]
    });
    google.setOnLoadCallback(function() {
        statisticContext.drawChart();
    });

    <?php 
      $campaigns = isset( $_GET['cid'] )? $analytics->getCampaignsList( intval($_GET['cid']) ) : $analytics->getCampaignsList();
      $trackingBrowserData = isset( $_GET['cid'] )? $analytics->getCampaignsTrackings( intval($_GET['cid']) ) : $analytics->getCampaignsTrackings();
    ?>
    var defaultChartData = {

        stats: [
            <?php 
              $i = 1;
              $count = count($campaigns);
              foreach( $campaigns as $campaign ) :
                $filteredDate = explode( '-', $campaign->createdAT );
                $filteredDate[1] = $filteredDate[1] - 1;
                $filteredDate = implode(',',$filteredDate);
            ?>
            [new Date(<?php echo $filteredDate;?>), <?php echo $campaign->impressions;?>, <?php echo $campaign->clicks;?>, "<?php echo $campaign->clicks; ?> clicks on <?php echo date( 'jS F Y, l', strtotime( $campaign->createdAT ) );?>"]<?php echo ($i < $count) ? ',' : ''; ?>

            <?php 
              $i++;
              endforeach;
            ?>
        ],
        browsers: [
            <?php
              $i = 1;
              $count = count($trackingBrowserData);
              foreach( $trackingBrowserData as $data ) :
            ?>
            ["<?php echo $data->browser; ?>: <?php echo $data->impressions; ?> impressions and clicks", <?php echo $data->impressions; ?>]<?php echo ($i < $count) ? ',' : ''; ?>
            <?php 
              $i++;
              endforeach;
            ?>
        ]
    };
</script>
<?php 
  endif;
?>
<div class="wpbootstrap">
    <p><?php _e('Visualize your campaigns and infobar variants analytics.', IBWP_PLUGIN_TEXTDOMAIN); ?></p>
    <?php if( !isset( $_GET['overview'] ) ) : ?>
    <form method="post"> 
        <div id="chart-settings-bar">
            <div id="chart-type-select">
                <div class="btn-group" id="chart-type-group" data-toggle="buttons-radio">
                    <button type="button" class="btn btn-small active type-stats" data-value="stats"><i class="icon-signal"></i> <? echo _e('Stats', IBWP_PLUGIN_TEXTDOMAIN); ?></button>
                    <button type="button" class="btn btn-small type-browsers" data-value="browsers"><i class="icon-globe"></i> <?php _e('Browsers', IBWP_PLUGIN_TEXTDOMAIN); ?></button> 
                </div>
            </div>
            <?php
                if(isset($_POST['sDateStart'])){$dateStart=$_POST['sDateStart'];}else{$dateStart='';}
                if(isset($_POST['sDateEnd'])){$dateEnd=$_POST['sDateEnd'];}else{$dateEnd='';}
            ?>
            <div id="chart-date-select">
                <!--<input type="hidden" name="sPost" value="<?php //echo $postId ?>" />-->
                <span class="date-range-label"><?php _e('Date range:', IBWP_PLUGIN_TEXTDOMAIN); ?></span>
                <input type="text" id="date-start" name="sDateStart" value="<?php echo $dateStart  ?>" />
                <input type="text" id="date-end" name="sDateEnd" value="<?php echo $dateEnd ?>" />
                <input type="submit" id="date-range-apply" name="date-range-apply" class="btn btn-small" value="Apply" />
            </div>
        </div>
    </form>

    <div class="chart-wrap">
        <div id="chart" style="width: 100%; height: 300px;"></div>
    </div>
    <?php
      $msg = isset( $_GET['cid'] )? 'This page displays data for one single campaign.' : 'This page displays data for all your campaigns.';
    ?>
    <p><?php echo $msg; ?></p>
    <table class="ibwp-posts-table">
        <thead>
            <th class="col-number"></th>
            <th class="col-title"><?php _e('Page URL', IBWP_PLUGIN_TEXTDOMAIN); ?></th>
            <th class="col-total"><?php _e('Impressions', IBWP_PLUGIN_TEXTDOMAIN); ?></th>
            <th class="col-total"><?php _e('Clicks', IBWP_PLUGIN_TEXTDOMAIN); ?></th>
            <th class="col-total"><?php _e('Conversion Rates', IBWP_PLUGIN_TEXTDOMAIN); ?></th>
        </thead>
        <tbody>
          <?php
              $i = 1;
              foreach( $campaigns as $campaign ) :
          ?>
          <tr>
              <td class="col-number"><?php echo $i; ?>.</td>
              <?php if( isset( $_GET['cid'] ) ) : ?>
              <td class="col-title"><?php echo stripcslashes( $campaign->campaignName ); ?></td>
              <?php else : ?>
              <td class="col-title"><?php printf( '<a href="%s">%s</a>', admin_url( '/admin.php?page=infobar-analytics&cid=' . $campaign->campaignID ), stripcslashes( $campaign->campaignName ) ) ?></td>
              <?php endif; ?>
              <td class="col-total"><?php echo $campaign->impressions ?></td>
              <td class="col-total"><?php echo $campaign->clicks ?></td>
              <?php 
                  if( $campaign->impressions == 0 || $campaign->clicks == 0 ){
                    $conversion = 0;
                  } else { 
                    $conversion = ( $campaign->clicks *100) / ( $campaign->impressions );
                  }
              ?>
              <td class="col-total"><?php echo round( $conversion, 2 ) . "%"; ?></td>
          </tr>
          <?php
            $i++;
            endforeach;
          ?>
        </tbody>
    </table>
    <h5>Latest active visitors :</h5>
    <table class="ibwp-posts-table">
        <thead>
            <th class="col-number"></th>
            <th class="col-title"><?php _e('IP', IBWP_PLUGIN_TEXTDOMAIN); ?></th>
            <th class="col-total"><?php _e('Browser', IBWP_PLUGIN_TEXTDOMAIN); ?></th>
            <th class="col-total"><?php _e('Referer', IBWP_PLUGIN_TEXTDOMAIN); ?></th>
        </thead>
        <tbody>
          <?php
              $i = 1;
              $visitors = isset( $_GET['cid'] )? $analytics->getVisitorsPerCampaign( intval($_GET['cid']) ) : $analytics->getVisitorsPerCampaign();
              foreach( $visitors as $visitor ) :
          ?>
          <tr>
              <td class="col-number">
                <img src="<?php echo $analytics->getFlag($visitor->campaign_visitor_ip) ?>" alt=""/>
              </td>
              <td class="col-title"><?php echo $visitor->campaign_visitor_ip; ?></td>
              <td class="col-total"><?php echo $visitor->campaign_visitor_browser; ?></td>
              <td class="col-total"><?php echo $visitor->campaign_visitor_referer; ?></td>
          </tr>

          <?php
            $i++;
            endforeach;
          ?>
        </tbody>
    </table>
    <?php endif; ?>
   </div>