<?php 
	//global $editing, $wpdb;
	$nonceAction = $editing === true ? 'edit' : 'add';

	if ( $editing ) {
		$campaignRow = $wpdb->get_row( "SELECT * FROM " . $wpdb->prefix . "ibwp_campaigns WHERE id = " . $campaign_id );
		$cname = $campaignRow->campaign_name;
		$csettingsOb = json_decode( $campaignRow->campaign_settings );
		$csettings = $csettingsOb->campaign_settings;
		$cstatus = $campaignRow->campaign_status;
		$relatedVariants = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . "ibwp_variants WHERE variant_campaign_id = " . $campaignRow->id );
	} else {
		$csettings = new stdClass();
		$csettings->timing = 0;
		$csettings->startdate = '';
		$csettings->enddate = '';
		$csettings->duration = 0;
		$csettings->showafterhits = 0;
		$csettings->onclose = 0;
		$csettings->daysoff = 0;
		$csettings->winninginfobar = 0;
		$csettings->bestconverting = 0;
		$csettings->campaign_referrer_option = 0;
		$csettings->campaign_referrer = '';

		$cname = '';
		$campaignRow = new stdClass();
		$campaignRow->campaign_status = 0;
		$campaignRow->campaign_position = 'Header';
		$campaignRow->campaign_location = -1;
		$campaignRow->campaign_categories = array();
		$campaignRow->campaign_pages = array();
		$campaignRow->campaign_posts = array();
		$campaignRow->campaign_browsers = 'All';
	}
?>
<form action="#" method="post" name="adminForm" id="adminForm">
	<?php wp_nonce_field('ibw-'.$nonceAction.'-campaign');  ?>
	<div id="poststuff">
		<?php 
			if( isset( $_GET['message'] ) ) :
		?>
		<div id="message" class="updated notice notice-success is-dismissible below-h2">
			<p><?php if( $_GET['message'] == 'added' ) : _e( 'Campaign published', IBWP_PLUGIN_TEXTDOMAIN ); elseif( $_GET['message'] == 'edited' ) : _e( 'Campaign modified', IBWP_PLUGIN_TEXTDOMAIN ); endif; ?>. <a target="_blank" href="<?php echo home_url( '/?preview-campaign='.$campaign_id ); ?>"><?php _e( 'Preview', IBWP_PLUGIN_TEXTDOMAIN ); ?></a></p>
			<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>
		</div>
		<?php endif; ?>
		<div id="post-body" class="metabox-holder columns-2">
			<div id="post-body-content" class="tabs-container">
				<ul id="tabs-list" class="tabs-nav">
					<li>
						<a class="tab-trigger current" href="#global-settings"><?php _e( 'Global settings', IBWP_PLUGIN_TEXTDOMAIN ); ?></a>
					</li>
					<?php 
						if( $editing  && is_array( $relatedVariants ) ) : 
							$i = 1;
							foreach( $relatedVariants as $variant ) : 
					?>
					<li>
						<a class="tab-trigger" href="#infobar-variant-<?php echo $i; ?>"><?php echo __( 'Infobar Variant ', IBWP_PLUGIN_TEXTDOMAIN ) . $i; ?></a>
					</li>
					<?php 
						$i++;
						endforeach;
						endif;
					?>
					<li class="add-new">
						<a class="add-variant" href="#"><?php _e( '+ Add variant', IBWP_PLUGIN_TEXTDOMAIN ); ?></a>
					</li>
				</ul>
				<div id="global-settings" class="tab-content current example" data-text="<?php _e( 'Global settings', IBWP_PLUGIN_TEXTDOMAIN ); ?>">
					<div class="grid">
						<div class="row">
							<label><?php _e( 'Choose your campaign name', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
							<div class="input-control text full-size">
								<input type="text" name="campaign-name" value="<?php echo $cname; ?>">
							</div>
						</div>
						<div class="row">
							<label><?php _e( 'Referrer Options', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
							<label class="input-control radio small-check">
								<input type="radio" name="referrer-option" class="show-on-change" data-target="#referrer-opts-container" data-value="1" <?php echo ( $editing != true || $csettings->campaign_referrer_option == '0' )? 'checked="checked"' : '' ?> value="0" />
								<span class="check"></span>
								<span class="caption"><?php _e( 'All', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
							</label>
							<label class="input-control radio small-check">
								<input type="radio" name="referrer-option" class="show-on-change" data-target="#referrer-opts-container" data-value="1" <?php echo $csettings->campaign_referrer_option == '1' ? 'checked="checked"' : ''; ?> value="1" />
								<span class="check"></span>
								<span class="caption"><?php _e( 'From a specific domain', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
							</label>
						</div>
						<div id="referrer-opts-container" class="row hidden" <?php echo $csettings->campaign_referrer_option == '1' ? 'style="display:block;"' : ''; ?>>
							<label><?php _e( 'Referrer', IBWP_PLUGIN_TEXTDOMAIN ); ?> <b><em>( <?php _e( 'Infobars shows only for users that comes from this domain name', IBWP_PLUGIN_TEXTDOMAIN ); ?> )</em></b></label>
							<div class="input-control text">
								<input type="text" name="campaign-referrer" value="<?php echo $csettings->campaign_referrer; ?>" placeholder="example.com" />
							</div>
						</div>
						<div class="row">
							<label><?php _e( 'Display position', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
							<label class="input-control radio small-check">
								<input type="radio" name="campaign-position" <?php echo ( $editing != true || $campaignRow->campaign_position == 'Header' )? 'checked="checked"' : '' ?> value="Header" />
								<span class="check"></span>
								<span class="caption"><?php _e( 'Header', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
							</label>
							<label class="input-control radio small-check">
								<input type="radio" name="campaign-position" <?php echo ( $campaignRow->campaign_position == 'Footer' )? 'checked="checked"' : '' ?> value="Footer" />
								<span class="check"></span>
								<span class="caption"><?php _e( 'Footer', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
							</label>
						</div>
						<div class="row">
							<label><?php _e( 'Show infobar', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
							<label class="input-control radio small-check">
								<input value="0" class="show-on-change" data-target="#dates-container" data-value="1" type="radio" name="campaign-showing-times"  <?php echo ( !is_object( $csettings ) || $csettings->timing == '0' )? 'checked="checked"' : '' ?>>
								<span class="check"></span>
								<span class="caption"><?php _e( 'Everyday', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
							</label>
							<label class="input-control radio small-check">
								<input value="1" class="show-on-change" data-target="#dates-container" data-value="1" type="radio" name="campaign-showing-times"  <?php echo ( $csettings->timing == '1' )? 'checked="checked"' : '' ?>>
								<span class="check"></span>
								<span class="caption"><?php _e( 'On specific dates', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
							</label>
						</div>
						<div id="dates-container" class="row cells2 hidden" <?php echo ( $csettings->timing == '1' )? 'style="display:block;"' : ''; ?>>
							<div class="cell">
								<label><?php _e( 'Start date', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
								<div class="input-control text full-size">
									<input id="start-date" class="datepicker" readonly="readonly" type="text" name="start-date" value="<?php echo $csettings->startdate; ?>">
								</div>	
							</div>
							<div class="cell">
								<label><?php _e( 'End date', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
								<div class="input-control text full-size">
									<input id="end-date" class="datepicker" readonly="readonly" type="text" name="end-date" value="<?php echo $csettings->enddate; ?>">
								</div>	
							</div>
						</div>
						<div class="row">
							<label><?php _e( 'Select browsers', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
							<div class="input-control" data-role="select">
								<select class="basic-select" name="campaign-browsers">
									<option <?php echo ( $campaignRow->campaign_browsers == 'All' )? 'selected="selected"' : '' ?> value="All"><?php _e( 'All', IBWP_PLUGIN_TEXTDOMAIN ); ?></option>
									<option <?php echo ( $campaignRow->campaign_browsers == 'Chrome' )? 'selected="selected"' : '' ?> value="Chrome"><?php _e( 'Chrome', IBWP_PLUGIN_TEXTDOMAIN ); ?></option>
									<option <?php echo ( $campaignRow->campaign_browsers == 'Firefox' )? 'selected="selected"' : '' ?> value="Firefox"><?php _e( 'Firefox', IBWP_PLUGIN_TEXTDOMAIN ); ?></option>
									<option <?php echo ( $campaignRow->campaign_browsers == 'IE' )? 'selected="selected"' : '' ?> value="IE"><?php _e( 'IE', IBWP_PLUGIN_TEXTDOMAIN ); ?></option>
									<option <?php echo ( $campaignRow->campaign_browsers == 'Safari' )? 'selected="selected"' : '' ?> value="Safari"><?php _e( 'Safari', IBWP_PLUGIN_TEXTDOMAIN ); ?></option>
									<option <?php echo ( $campaignRow->campaign_browsers == 'Opera' )? 'selected="selected"' : '' ?> value="Opera"><?php _e( 'Opera', IBWP_PLUGIN_TEXTDOMAIN ); ?></option>
									<option <?php echo ( $campaignRow->campaign_browsers == 'Mobile' )? 'selected="selected"' : '' ?> value="Mobile"><?php _e( 'Mobile', IBWP_PLUGIN_TEXTDOMAIN ); ?></option>
								</select>
							</div>							
						</div>
						<div class="row">
							<label><?php _e( 'Select pages', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
							<div class="input-control" data-role="select">
								<select class="basic-select" name="campaign-location" id="campaign-location">
									<option <?php echo ( $campaignRow->campaign_location == '-1' ) ? 'selected="selected"' : '' ?> value="-1"><?php _e( 'Everywhere ( Front )', IBWP_PLUGIN_TEXTDOMAIN ); ?></option>
									<option <?php echo ( $campaignRow->campaign_location == 'home' ) ? 'selected="selected"' : '' ?> value="home"><?php _e( 'HomePage', IBWP_PLUGIN_TEXTDOMAIN ); ?></option>
									<option <?php echo ( $campaignRow->campaign_location == 'inner' ) ? 'selected="selected"' : '' ?> value="inner"><?php _e( 'Inner Pages', IBWP_PLUGIN_TEXTDOMAIN ); ?></option>
									<option <?php echo ( $campaignRow->campaign_location == 'all' ) ? 'selected="selected"' : '' ?> value="all"><?php _e( 'All Pages/Posts/Categories', IBWP_PLUGIN_TEXTDOMAIN ); ?></option>
									<option <?php echo ( $campaignRow->campaign_location == 'category' ) ? 'selected="selected"' : '' ?> value="category"><?php _e( 'Category', IBWP_PLUGIN_TEXTDOMAIN ); ?></option>
									<option <?php echo ( $campaignRow->campaign_location == 'page' ) ? 'selected="selected"' : '' ?> value="page"><?php _e( 'Page', IBWP_PLUGIN_TEXTDOMAIN ); ?></option>
									<option <?php echo ( $campaignRow->campaign_location == 'post' ) ? 'selected="selected"' : '' ?> value="post"><?php _e( 'Post', IBWP_PLUGIN_TEXTDOMAIN ); ?></option>
								</select>
							</div>
						</div>
						<div id="selected-page" class="campaign-location-picker hidden row" <?php echo ( $campaignRow->campaign_location == 'page' ) ? 'style="display:block;"' : '' ?>>
							<label><?php _e( 'Pick the pages you want to show the infobar in it', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
							<div class="ibw-items-list">
								<a href="#" data-status="0" class="ibw-collapse fa fa-angle-down"></a>
								<div id="pages-list">
									<label class="input-control checkbox small-check check-all-siblings">
										<input type="checkbox">
										<span class="check"></span>
										<span class="caption"><?php _e( 'Select all pages', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
									</label>
									<?php
										$pickedPages = ( $editing ) ? explode( ',', $campaignRow->campaign_pages ) : '';
										$pages = get_pages( array() );
										foreach( $pages as $page ) :
									?>
									<label class="input-control checkbox small-check">
										<input type="checkbox" <?php echo ( $editing && in_array( $page->ID, $pickedPages ) ) ? 'checked="checked"' : ''; ?> name="campaign-location-pages[]" class="ibw-item" value="<?php echo $page->ID ?>">
										<span class="check"></span>
										<span class="caption"><?php echo $page->post_title ?></span>
									</label>
									<?php 
										endforeach;
									?>
								</div>
							</div>
						</div>
						<div id="selected-post" class="campaign-location-picker hidden row" <?php echo ( $campaignRow->campaign_location == 'post' ) ? 'style="display:block;"' : '' ?>>
							<label><?php _e( 'Pick the posts you want to show the infobar in it', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
							<div class="ibw-items-list">
								<a href="#" data-status="0" class="ibw-collapse fa fa-angle-down"></a>
								<div id="posts-list">
									<label class="input-control checkbox small-check check-all-siblings">
										<input type="checkbox">
										<span class="check"></span>
										<span class="caption"><?php _e( 'Select all posts', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
									</label>
									<?php
										$pickedPosts = ( $editing ) ? explode( ',', $campaignRow->campaign_posts ) : '';
										$posts = get_posts( array() );
										foreach( $posts as $post ) :
									?>
									<label class="input-control checkbox small-check">
										<input type="checkbox" <?php echo ( $editing && in_array($post->ID, $pickedPosts) )? 'checked="checked"' : ''; ?> name="campaign-location-posts[]" class="ibw-item" value="<?php echo $post->ID ?>">
										<span class="check"></span>
										<span class="caption"><?php echo $post->post_title ?></span>
									</label>
									<?php 
										endforeach;
									?>
								</div>
							</div>
						</div>
						<div id="selected-category" class="campaign-location-picker hidden row" <?php echo ( $campaignRow->campaign_location == 'category' ) ? 'style="display:block;"' : '' ?>>
							<label><?php _e( 'Pick the categories you want to show the infobar in it', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
							<div class="ibw-items-list">
								<a href="#" data-status="0" class="ibw-collapse fa fa-angle-down"></a>
								<div id="categories-list">
									<label class="input-control checkbox small-check check-all-siblings">
										<input type="checkbox">
										<span class="check"></span>
										<span class="caption"><?php _e( 'Select all categories', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
									</label>
									<?php
										$pickedCategory = ( $editing ) ? explode( ',', $campaignRow->campaign_categories ) : '';
										$categories = get_categories( array() );

										foreach( $categories as $category ) :
									?>
									<label class="input-control checkbox small-check">
										<input type="checkbox" <?php echo ( $editing && in_array($category->term_id, $pickedCategory) )? 'checked="checked"' : ''; ?> name="campaign-location-categories[]" class="ibw-item" value="<?php echo $category->term_id ?>">
										<span class="check"></span>
										<span class="caption"><?php echo $category->name ?></span>
									</label>
									<?php 
										endforeach;
									?>
								</div>
							</div>
						</div>
						<div class="row cells3">
							<div class="cell">
								<label><?php _e( 'Show after a while <b><em>( Seconds )</em></b>', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
								<div class="input-control text full-size">
									<input type="number" name="campaign-show-before" value="<?php echo $csettings->duration; ?>">
								</div>
							</div>
							<div class="cell">
								<label><?php _e( 'Show after certain Pageviews <b><em>( Views )</em></b>', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
								<div class="input-control text full-size">
									<input type="number" name="campaign-showafter-views" value="<?php echo $csettings->showafterhits; ?>">
								</div>
							</div>
							<div class="cell">
								<label><?php _e( 'On close', IBWP_PLUGIN_TEXTDOMAIN ); ?></label><br />
								<label class="input-control radio small-check">
									<input value="0" data-target="#daysoff-container" data-value="0" type="radio" name="campaign-onclose" <?php echo ( !is_object( $csettings ) || $csettings->onclose == '0' ) ? 'checked="checked"' : ''; ?> >
									<span class="check"></span>
									<span class="caption"><?php _e( 'Hide bar', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
								</label>
								<label class="input-control radio small-check">
									<input value="1" data-target="#pageviews-container" data-value="1" type="radio" <?php echo $csettings->onclose == '1' ? 'checked="checked"' : ''; ?>   name="campaign-onclose">
									<span class="check"></span>
									<span class="caption"><?php _e( 'Minimize bar', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
								</label>
							</div>
						</div>
						<div id="daysoff-container" class="row cells2 <?php echo $csettings->onclose == '1' ? ' hidden' : ''; ?>">
							<div class="cell">
								<label for=""><?php _e( 'Don\'t reshow infobar for <b><em>( Days )</em></b>', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
								<div class="input-control text full-size">
									<input type="number" name="campaign-daysoff" value="<?php echo $csettings->daysoff; ?>">
								</div>
							</div>
						</div>
						<div class="row cells2">
							<div class="cell">
								<h6><?php _e( 'Pick best converting automatically', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
								<label class="switch">
									<input value="1" <?php echo $csettings->bestconverting == '1' ? 'checked="checked"' : ''; ?> type="checkbox" name="campaign-best-converting">
									<span class="check"></span>
								</label>
							</div>
							<div class="cell">
								<label for=""><?php _e( 'Select winning infobar after <b><em>( Views )</em></b>', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
								<div class="input-control text full-size">
									<input type="number" name="campaign-winning-ib" value="<?php echo $csettings->winninginfobar; ?>">
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php 
					if( $editing && is_array( $relatedVariants ) ) : 
					$i = 1; 
					foreach( $relatedVariants as $variantRow ) :
						//$variantRow = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}ibwp_variants WHERE id = {$variant->id}");

						$vname = $variantRow->variant_name;
						$vstatus = $variantRow->variant_status;
						$vcontent = $variantRow->variant_inner;
						$vstyles = $variantRow->variant_wrap_styles;
						$vclosebtn = $variantRow->variant_closebtn;
						$vsettings = json_decode( $variantRow->variant_settings, true );
						if( $vsettings['skin'] == '26' ){
							$borderwidth = $vsettings['borderwidth'];
							$bordercolor = $vsettings['bordercolor'];
							$vstyles .= 'border-bottom-width:'.$borderwidth.'px; border-bottom-color:'.$bordercolor.';';
						}


				?>
				<div id="infobar-variant-<?php echo $i; ?>" data-index="<?php echo $i; ?>" class="variant-wrap example saved-variant tab-content" data-text="<?php echo __( 'Infobar Variant ', IBWP_PLUGIN_TEXTDOMAIN ) . $i; ?>">
					<input type="hidden" name="variants[<?php echo $i; ?>][id]" value="<?php echo $variantRow->id; ?>">
					<div class="grid">
						<div class="row preview-contain">
							<h4><?php _e( 'Live Preview', IBWP_PLUGIN_TEXTDOMAIN ); ?></h4>
							<div class="live-preview">
								<div id="infobar-demo-<?php echo $i; ?>" data-index="<?php echo $i; ?>" class="bar-demo" data-oldstyle="<?php echo htmlspecialchars_decode(stripslashes($vstyles)); ?>">
									<div class="content">
										<?php echo htmlspecialchars_decode(stripslashes($vcontent)); ?>
									</div>
									<!-- <span class="close"><img onmouseover="this.src='<?php echo $this->GetUrl('src/assets/icons/close/1_hover.png') ?>';" onmouseout="this.src='<?php echo $this->GetUrl('src/assets/icons/close/1.png') ?>';" src="<?php echo $this->GetUrl('src/assets/icons/close/1.png') ?>" alt="Hide bar" /></span> -->
									<span class="close">
										<!-- <a href="#" class="btn"></a> -->
										<?php echo htmlspecialchars_decode(stripslashes($vclosebtn)); ?>
									</span>
								</div>
							</div>
						</div>
						<div class="row">
							<label><?php _e( 'Variant name', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
							<div class="input-control text full-size">
								<input type="text" name="variants[<?php echo $i; ?>][variant-name]" value="<?php echo $vname; ?>">
							</div>
						</div>
						<div class="row">
							<div class="bar-options">
								<div class="tooltip-contain close-icons<?php echo ( !is_object( $csettings ) || $csettings->onclose == '1' )? ' hidden' : ''; ?>">
									<a href="#" class="tooltip-trigger fa fa-times"><span><?php _e( 'Hide buttons', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap">
										<div class="items-to-editor">
											<a style="background: #df3f2e;" href="#" class="btn btn-hide fa fa-times"></a>
											<a style="background: #b04f00;border-bottom-color:#DC8843;" href="#" class="btn btn-hide fa fa-times"></a>
											<a style="background: #f55696;border-bottom-color:#B92A63;" href="#" class="btn btn-hide fa fa-times"></a>
											<a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-hide fa fa-times"></a>
											<a style="background: #ffa800;border-bottom-color:#E09910" href="#" class="btn btn-hide fa fa-times"></a>
											<br />
											<a style="background: #df3f2e;" href="#" class="btn btn-hide fa fa-times-circle"></a>
											<a style="background: #b04f00;border-bottom-color:#DC8843;" href="#" class="btn btn-hide fa fa-times-circle"></a>
											<a style="background: #f55696;border-bottom-color:#B92A63;" href="#" class="btn btn-hide fa fa-times-circle"></a>
											<a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-hide fa fa-times-circle"></a>
											<a style="background: #ffa800;border-bottom-color:#E09910" href="#" class="btn btn-hide fa fa-times-circle"></a>
											<br />
											<a style="background: #df3f2e;" href="#" class="btn btn-hide fa fa-times-circle-o"></a>
											<a style="background: #b04f00;border-bottom-color:#DC8843;" href="#" class="btn btn-hide fa fa-times-circle-o"></a>
											<a style="background: #f55696;border-bottom-color:#B92A63;" href="#" class="btn btn-hide fa fa-times-circle-o"></a>
											<a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-hide fa fa-times-circle-o"></a>
											<a style="background: #ffa800;border-bottom-color:#E09910" href="#" class="btn btn-hide fa fa-times-circle-o"></a>
										</div>
									</div>
								</div>
								<div class="tooltip-contain minimize-icons<?php echo ( !is_object( $csettings ) || $csettings->onclose == '0' )? ' hidden' : ''; ?>">
									<a href="#" class="tooltip-trigger fa fa-times"><span><?php _e( 'Minimize buttons', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap">
										<div class="items-to-editor">
											<a style="background: #df3f2e;" href="#" class="btn btn-minimize fa fa-angle-up"></a>
											<a style="background: #b04f00;border-bottom-color:#DC8843;" href="#" class="btn btn-minimize fa fa-angle-up"></a>
											<a style="background: #f55696;border-bottom-color:#B92A63;" href="#" class="btn btn-minimize fa fa-angle-up"></a>
											<a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-minimize fa fa-angle-up"></a>
											<a style="background: #ffa800;border-bottom-color:#E09910" href="#" class="btn btn-minimize fa fa-angle-up"></a>
											<br />
											<a style="background: #df3f2e;" href="#" class="btn btn-minimize fa fa-chevron-up"></a>
											<a style="background: #b04f00;border-bottom-color:#DC8843;" href="#" class="btn btn-minimize fa fa-chevron-up"></a>
											<a style="background: #f55696;border-bottom-color:#B92A63;" href="#" class="btn btn-minimize fa fa-chevron-up"></a>
											<a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-minimize fa fa-chevron-up"></a>
											<a style="background: #ffa800;border-bottom-color:#E09910" href="#" class="btn btn-minimize fa fa-chevron-up"></a>
											<br />
											<a style="background: #df3f2e;" href="#" class="btn btn-minimize fa fa-chevron-circle-up"></a>
											<a style="background: #b04f00;border-bottom-color:#DC8843;" href="#" class="btn btn-minimize fa fa-chevron-circle-up"></a>
											<a style="background: #f55696;border-bottom-color:#B92A63;" href="#" class="btn btn-minimize fa fa-chevron-circle-up"></a>
											<a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-minimize fa fa-chevron-circle-up"></a>
											<a style="background: #ffa800;border-bottom-color:#E09910" href="#" class="btn btn-minimize fa fa-chevron-circle-up"></a>
											<br />
											<a style="background: #df3f2e;" href="#" class="btn btn-minimize fa fa-arrow-up"></a>
											<a style="background: #b04f00;border-bottom-color:#DC8843;" href="#" class="btn btn-minimize fa fa-arrow-up"></a>
											<a style="background: #f55696;border-bottom-color:#B92A63;" href="#" class="btn btn-minimize fa fa-arrow-up"></a>
											<a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-minimize fa fa-arrow-up"></a>
											<a style="background: #ffa800;border-bottom-color:#E09910" href="#" class="btn btn-minimize fa fa-arrow-up"></a>
										</div>
									</div>
								</div>
								<div class="tooltip-contain backgrounds">
									<a href="#" class="tooltip-trigger fa fa-tasks"><span><?php _e( 'Backgrounds', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap">
										<h5><?php _e( 'Skins ( Color schema )', IBWP_PLUGIN_TEXTDOMAIN ); ?></h5>
										<div class="items-to-editor texts">
											<h6><?php _e( 'Choose a skin', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
											<select class="skins-picker show-on-change" data-target="#skins-container-<?php echo $i; ?>" data-value="26" name="variants[<?php echo $i; ?>][skins]">
												<option value="0" <?php echo ( $vsettings['skin'] == '0' )? 'selected="selected"' : ''; ?>>Apple</option>
												<option value="1" <?php echo ( $vsettings['skin'] == '1' )? 'selected="selected"' : ''; ?>>Coffee</option>
												<option value="2" <?php echo ( $vsettings['skin'] == '2' )? 'selected="selected"' : ''; ?>>Carnation</option>
												<option value="3" <?php echo ( $vsettings['skin'] == '3' )? 'selected="selected"' : ''; ?>>Dusk</option>
												<option value="4" <?php echo ( $vsettings['skin'] == '4' )? 'selected="selected"' : ''; ?>>Flare</option>
												<option value="5" <?php echo ( $vsettings['skin'] == '5' )? 'selected="selected"' : ''; ?>>Gold</option>
												<option value="6" <?php echo ( $vsettings['skin'] == '6' )? 'selected="selected"' : ''; ?>>Green apple</option>
												<option value="7" <?php echo ( $vsettings['skin'] == '7' )? 'selected="selected"' : ''; ?>>Green sea</option>
												<option value="8" <?php echo ( $vsettings['skin'] == '8' )? 'selected="selected"' : ''; ?>>Iceberg</option>
												<option value="9" <?php echo ( $vsettings['skin'] == '9' )? 'selected="selected"' : ''; ?>>Midnight sky</option>
												<option value="10" <?php echo ( $vsettings['skin'] == '10' )? 'selected="selected"' : ''; ?>>Mint</option>
												<option value="11" <?php echo ( $vsettings['skin'] == '11' )? 'selected="selected"' : ''; ?>>Lavender field</option>
												<option value="12" <?php echo ( $vsettings['skin'] == '12' )? 'selected="selected"' : ''; ?>>Paper</option>
												<option value="13" <?php echo ( $vsettings['skin'] == '13' )? 'selected="selected"' : ''; ?>>Pavement</option>
												<option value="14" <?php echo ( $vsettings['skin'] == '14' )? 'selected="selected"' : ''; ?>>Pumpkin</option>
												<option value="15" <?php echo ( $vsettings['skin'] == '15' )? 'selected="selected"' : ''; ?>>Rosy</option>
												<option value="16" <?php echo ( $vsettings['skin'] == '16' )? 'selected="selected"' : ''; ?>>Tropic Blue</option>
												<option value="17" <?php echo ( $vsettings['skin'] == '17' )? 'selected="selected"' : ''; ?>>Turquoise</option>
												<option value="18" <?php echo ( $vsettings['skin'] == '18' )? 'selected="selected"' : ''; ?>>Twilight</option>
												<option value="19" <?php echo ( $vsettings['skin'] == '19' )? 'selected="selected"' : ''; ?>>Yellow wood</option>
												<option value="20" <?php echo ( $vsettings['skin'] == '20' )? 'selected="selected"' : ''; ?>>Green Charles</option>
												<option value="21" <?php echo ( $vsettings['skin'] == '21' )? 'selected="selected"' : ''; ?>>Hawai Earth</option>
												<option value="22" <?php echo ( $vsettings['skin'] == '22' )? 'selected="selected"' : ''; ?>>Blueberry Yoghurt</option>
												<option value="23" <?php echo ( $vsettings['skin'] == '23' )? 'selected="selected"' : ''; ?>>Pink Lady</option>
												<option value="24" <?php echo ( $vsettings['skin'] == '24' )? 'selected="selected"' : ''; ?>>White Peace</option>
												<option value="25" <?php echo ( $vsettings['skin'] == '25' )? 'selected="selected"' : ''; ?>>Yellow Impact</option>
												<option value="26" <?php echo ( $vsettings['skin'] == '26' )? 'selected="selected"' : ''; ?>>Custom Scheme</option>
											</select>
											<div id="skins-container-<?php echo $i; ?>" class="hidden" <?php echo ( $vsettings['skin'] == '26' )? 'style="display:block;"' : ''; ?>>
												<h6><?php _e( 'Customize your bar\'s skin', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
												<div class="input-control range">
													<div class="gradients"></div>
													<input type="text" class="hidden" name="variants[<?php echo $i; ?>][gradient]" id="gradient-values-<?php echo $i; ?>" value="<?php echo $vsettings['gradient']; ?>">
												</div>
												<div class="row cells2 border-options">
													<div class="cell">
														<h6><?php _e( 'Border size', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
														<div class="input-control range">
															<input class="border-width" type="range" name="variants[<?php echo $i; ?>][border-width]" min="0" max="15" value="<?php echo $vsettings['borderwidth'] ?>" />
															<span class="value"><em><?php echo ( $vsettings['borderwidth'] )? $vsettings['borderwidth'] : '2'; ?></em>px</span>
														</div>
													</div>
													<div class="cell">
														<div class="input-control color">
															<h6><?php _e( 'Border color', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
															<input class="style-border-color pick-color" type="text" name="variants[<?php echo $i; ?>][border-color]" value="<?php echo $vsettings['bordercolor'] ?>" style="background-color:<?php echo $vsettings['bordercolor'] ?>" />
														</div>
													</div>
												</div>
												<div class="input-control color">
													<h6><?php _e( 'Text color', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
													<input class="style-text-color pick-color" type="text" name="variants[<?php echo $i; ?>][text-color]" value="<?php echo $vsettings['textcolor'] ?>" style="background-color:<?php echo $vsettings['textcolor'] ?>" />
												</div>
												<div class="input-control color">
													<h6><?php _e( 'Link color', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
													<input class="style-link-color pick-color" type="text" name="variants[<?php echo $i; ?>][link-color]" value="<?php echo $vsettings['linkcolor'] ?>" style="background-color:<?php echo $vsettings['linkcolor'] ?>" />
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="tooltip-contain emoticons">
									<a href="#" class="tooltip-trigger fa fa-smile-o"><span><?php _e( 'Emoticons', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap">
										<div class="items-to-editor">
											<?php for ($k=1; $k < 61; $k++) { ?>
											<a href="#" class="btn-img">
												<img src="<?php echo $this->GetUrl('src/assets/icons/'.$k.'.png') ?>" alt="">
											</a>
											<?php } ?>
										</div>
									</div>
								</div>
								<div class="tooltip-contain fonts">
									<a href="#" class="tooltip-trigger fa fa-font"><span><?php _e( 'Fonts', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap">
										<h5><?php _e( 'Fonts', IBWP_PLUGIN_TEXTDOMAIN ); ?></h5>
										<div class="items-to-editor texts">
											<h6><?php _e( 'Choose font', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
											<select class="font-family" name="variants[<?php echo $i; ?>][font-family]">
												<option value="Arial">Arial</option>
												<option value="Century Gothic">Century Gothic</option>
												<option value="Comic Sans">Comic Sans</option>
												<option value="Georgia">Georgia</option>
												<option value="Lato">Lato</option>
												<option value="Lucida Handwriting">Lucida Handwriting</option>
												<option value="Myriad Pro">Myriad Pro</option>
												<option value="Open Sans">Open Sans</option>
												<option value="Times New Roman">Times New Roman</option>
												<option value="Vivaldi">Vivaldi</option>
											</select>
											<h6><?php _e( 'Font size', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
											<div class="input-control range">
												<input class="font-size" type="range" name="variants[<?php echo $i; ?>][font-size]" min="8" max="30" value="22">
												<span class="value"><em>22</em>px</span>
											</div>
										</div>
									</div>
								</div>
								<div class="tooltip-contain buttons">
									<a href="#" class="tooltip-trigger fa fa-square"><span><?php _e( 'Buttons', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap">
										<h5><?php _e( 'Styles', IBWP_PLUGIN_TEXTDOMAIN ); ?></h5>
										<div id="btn-preview-<?php echo $i; ?>" class="btn-preview">
											<a href="#" class="ibw-primary-btn"><?php _e( 'Click here', IBWP_PLUGIN_TEXTDOMAIN ); ?></a>
										</div>
										<select class="buttons-styles" id="buttons-styles-<?php echo $i; ?>">
											<option value="1">Style1</option>
											<option value="2">Style2</option>
											<option value="3">Style3</option>
											<option value="4">Style4</option>
											<option value="5">Style5</option>
											<option value="6">Style6</option>
											<option value="7">Style7</option>
											<option value="8">Style8</option>
											<option value="9">Style9</option>
											<option value="10">Style10</option>
										</select>
										<div id="button-config-<?php echo $i; ?>">
											<div class="input-control text full-size">
												<input placeholder="Link label" type="text" class="link-label" value="<?php _e( 'Click here', IBWP_PLUGIN_TEXTDOMAIN ); ?>">
											</div>
											<div class="input-control text full-size">
												<input placeholder="Link URL" type="text" class="link-url" value="#">
											</div>
											<label class="input-control checkbox small-check">
												<input type="checkbox" class="link-target" value="_blank" checked="checked">
												<span class="check"></span>
												<span class="caption"><?php _e( 'Open in new window', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
											</label>
											<div class="btn-wrap">
												<a href="#" class="button button-primary button-large insert" data-type="buttons"><?php _e( 'Insert', IBWP_PLUGIN_TEXTDOMAIN ); ?></a>
											</div>
										</div>
										<div class="hidden">
											<div class="btn-gradient"></div>
											<input type="text" class="hidden" id="btn-gradient-values-<?php echo $i; ?>" value="0% #df3f2e,100% #b62618">
										</div>
									</div>
								</div>
								<div class="tooltip-contain custom-image">
									<a href="#" class="tooltip-trigger fa fa-picture-o"><span><?php _e( 'Image', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap wp-media-buttons">
										<h5><?php _e( 'Upload', IBWP_PLUGIN_TEXTDOMAIN ); ?></h5>
										<!-- <p><a data-index="<?php echo $i; ?>" class="upload-media fa fa-upload" href="#"><?php _e( 'Pick a custom image', IBWP_PLUGIN_TEXTDOMAIN ); ?></a> <?php _e( 'from your computer, or insert an URL of your image in the field bellow', IBWP_PLUGIN_TEXTDOMAIN ); ?></p> -->
										<a href="#" data-index="<?php echo $i; ?>" id="insert-media-button-<?php echo $i; ?>" class="button add_media" data-editor="content" title="Add Media"><span class="wp-media-buttons-icon"></span> Add Media</a>
										<div id="image-preview-<?php echo $i; ?>" class="image-preview"></div>
										<div class="btn-wrap">
											<a href="#" class="button button-primary button-large insert" data-type="image"><?php _e( 'Insert', IBWP_PLUGIN_TEXTDOMAIN ); ?></a>
										</div>
									</div>
								</div>
								<div class="tooltip-contain custom-link">
									<a href="#" class="tooltip-trigger fa fa-external-link-square"><span><?php _e( 'Link', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap">
										<h5><?php _e( 'Normal links', IBWP_PLUGIN_TEXTDOMAIN ); ?></h5>
										<p><?php _e( 'Insert simple links within your infobar by chosing the text, plus it anchor link.', IBWP_PLUGIN_TEXTDOMAIN ); ?></p>
										<div class="input-control text full-size">
											<input placeholder="Link label" type="text" class="link-label">
										</div>
										<div class="input-control text full-size">
											<input placeholder="Link URL" type="text" class="link-url">
										</div>
										<label class="input-control checkbox small-check">
											<input type="checkbox" class="link-target" value="_blank" checked="checked">
											<span class="check"></span>
											<span class="caption"><?php _e( 'Open in new window', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
										</label>
										<div class="btn-wrap">
											<a href="#" class="button button-primary button-large insert" data-type="link"><?php _e( 'Insert', IBWP_PLUGIN_TEXTDOMAIN ); ?></a>
										</div>
									</div>
								</div>
								<div class="tooltip-contain animated-icons">
									<a href="#" class="tooltip-trigger"><i class="fa fa-spinner fa-spin"></i><span><?php _e( 'Animations', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap grid">
										<div class="animated-icons-list">
											<a href="#"><i class="fa fa-wrench faa-wrench animated"></i></a>
											<a href="#"><i class="fa fa-bell faa-ring animated"></i></a>
											<a href="#"><i class="fa fa-envelope faa-horizontal animated"></i></a>
											<a href="#"><i class="fa fa-thumbs-o-up faa-vertical animated"></i></a>
											<a href="#"><i class="fa fa-warning faa-flash animated"></i></a>
											<a href="#"><i class="fa fa-thumbs-o-up faa-bounce animated"></i></a>
											<a href="#"><i class="fa fa-spinner faa-spin animated"></i></a>
											<a href="#"><i class="fa fa-plane faa-float animated"></i></a>
											<a href="#"><i class="fa fa-heart faa-pulse animated"></i></a>
											<a href="#"><i class="fa fa-envelope faa-shake animated"></i></a>
											<a href="#"><i class="fa fa-trophy faa-tada animated"></i></a>
											<a href="#"><i class="fa fa-space-shuttle faa-passing animated"></i></a>
											<a href="#"><i class="fa fa-circle-o faa-burst animated"></i></a>
										</div>
									</div>
								</div>
								<span class="presets-picker fa fa-list-alt"><span><?php _e('Presets', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></span>
							</div>
							<!-- /. -->
							<div class="input-control textarea full-size">
								<div id="msg-editor-<?php echo $i; ?>" class="message-editable" contenteditable="true" placeholder="<?php _e( 'Your infobar\'s text goes here', IBWP_PLUGIN_TEXTDOMAIN ); ?>"><?php echo htmlspecialchars_decode(stripslashes($vcontent)); ?></div>
								<textarea class="message" name="variants[<?php echo $i; ?>][content]"><?php echo htmlspecialchars_decode(stripslashes($vcontent)); ?></textarea>
								<textarea name="variants[<?php echo $i; ?>][wrap-styles]" id="variant-wrap-styles-<?php echo $i; ?>" class="hidden"><?php echo htmlspecialchars_decode(stripslashes($vstyles)); ?></textarea>
								<textarea name="variants[<?php echo $i; ?>][closebtn]" id="variant-closebtn-<?php echo $i; ?>" class="hidden"><?php echo htmlspecialchars_decode(stripslashes($vclosebtn)); ?></textarea>
							</div>
						</div>
						<div class="row cells2 status-contain">
							<div class="cell">
								<label for="remove-variant"><?php _e( 'Remove this variant', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
								<input data-id="<?php echo $variantRow->id ?>" type="button" name="remove-variant" class="button button-remove button-large" value="Remove">
							</div>
							<div class="cell">
								<label><?php _e( 'Status', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
								<label class="switch">
									<input type="checkbox" name="variants[<?php echo $i; ?>][status]" <?php echo ( $vstatus == 'on' )? 'checked="checked"' : ''?>>
									<span class="check"></span>
								</label>
							</div>
						</div>
					</div>
				</div>
				<?php
					$i++;
					endforeach;
					endif; 
				?>
				<div id="infobar-variants-tpl">
					<div class="grid">
						<div class="row preview-contain">
							<h4><?php _e( 'Live Preview', IBWP_PLUGIN_TEXTDOMAIN ); ?></h4>
							<div class="live-preview">
								<div id="infobar-demo-{{index}}" data-index="{{index}}" class="bar-demo">
									<div class="content">
										<p><?php _e( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit.', IBWP_PLUGIN_TEXTDOMAIN ); ?></p>
									</div>
									<!-- <span class="close"><img onmouseover="this.src='<?php echo $this->GetUrl('src/assets/icons/close/1_hover.png') ?>';" onmouseout="this.src='<?php echo $this->GetUrl('src/assets/icons/close/1.png') ?>';" src="<?php echo $this->GetUrl('src/assets/icons/close/1.png') ?>" alt="Hide bar" /></span> -->
									<span class="close"><a style="background: #df3f2e;" href="#" class="btn btn-hide fa fa-times"></a></span>
								</div>
							</div>
						</div>
						<div class="row">
							<label><?php _e( 'Variant name', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
							<div class="input-control text full-size">
								<input type="text" name="variants[{{index}}][variant-name]">
							</div>
						</div>
						<div class="row">
							<div class="bar-options">
								<div class="tooltip-contain close-icons<?php echo $csettings->onclose == '1' ? ' hidden' : ''; ?>">
									<a href="#" class="tooltip-trigger fa fa-times"><span><?php _e( 'Hide buttons', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap">
										<div class="items-to-editor">
											<a style="background: #df3f2e;" href="#" class="btn btn-hide fa fa-times"></a>
											<a style="background: #b04f00;border-bottom-color:#DC8843;" href="#" class="btn btn-hide fa fa-times"></a>
											<a style="background: #f55696;border-bottom-color:#B92A63;" href="#" class="btn btn-hide fa fa-times"></a>
											<a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-hide fa fa-times"></a>
											<a style="background: #ffa800;border-bottom-color:#E09910" href="#" class="btn btn-hide fa fa-times"></a>
											<br />
											<a style="background: #df3f2e;" href="#" class="btn btn-hide fa fa-times-circle"></a>
											<a style="background: #b04f00;border-bottom-color:#DC8843;" href="#" class="btn btn-hide fa fa-times-circle"></a>
											<a style="background: #f55696;border-bottom-color:#B92A63;" href="#" class="btn btn-hide fa fa-times-circle"></a>
											<a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-hide fa fa-times-circle"></a>
											<a style="background: #ffa800;border-bottom-color:#E09910" href="#" class="btn btn-hide fa fa-times-circle"></a>
											<br />
											<a style="background: #df3f2e;" href="#" class="btn btn-hide fa fa-times-circle-o"></a>
											<a style="background: #b04f00;border-bottom-color:#DC8843;" href="#" class="btn btn-hide fa fa-times-circle-o"></a>
											<a style="background: #f55696;border-bottom-color:#B92A63;" href="#" class="btn btn-hide fa fa-times-circle-o"></a>
											<a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-hide fa fa-times-circle-o"></a>
											<a style="background: #ffa800;border-bottom-color:#E09910" href="#" class="btn btn-hide fa fa-times-circle-o"></a>
										</div>
									</div>
								</div>
								<div class="tooltip-contain minimize-icons<?php echo ( !is_object( $csettings ) || $csettings->onclose == '0' )? ' hidden' : ''; ?>">
									<a href="#" class="tooltip-trigger fa fa-times"><span><?php _e( 'Minimize buttons', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap">
										<div class="items-to-editor">
											<a style="background: #df3f2e;" href="#" class="btn btn-minimize fa fa-angle-up"></a>
											<a style="background: #b04f00;border-bottom-color:#DC8843;" href="#" class="btn btn-minimize fa fa-angle-up"></a>
											<a style="background: #f55696;border-bottom-color:#B92A63;" href="#" class="btn btn-minimize fa fa-angle-up"></a>
											<a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-minimize fa fa-angle-up"></a>
											<a style="background: #ffa800;border-bottom-color:#E09910" href="#" class="btn btn-minimize fa fa-angle-up"></a>
											<br />
											<a style="background: #df3f2e;" href="#" class="btn btn-minimize fa fa-chevron-up"></a>
											<a style="background: #b04f00;border-bottom-color:#DC8843;" href="#" class="btn btn-minimize fa fa-chevron-up"></a>
											<a style="background: #f55696;border-bottom-color:#B92A63;" href="#" class="btn btn-minimize fa fa-chevron-up"></a>
											<a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-minimize fa fa-chevron-up"></a>
											<a style="background: #ffa800;border-bottom-color:#E09910" href="#" class="btn btn-minimize fa fa-chevron-up"></a>
											<br />
											<a style="background: #df3f2e;" href="#" class="btn btn-minimize fa fa-chevron-circle-up"></a>
											<a style="background: #b04f00;border-bottom-color:#DC8843;" href="#" class="btn btn-minimize fa fa-chevron-circle-up"></a>
											<a style="background: #f55696;border-bottom-color:#B92A63;" href="#" class="btn btn-minimize fa fa-chevron-circle-up"></a>
											<a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-minimize fa fa-chevron-circle-up"></a>
											<a style="background: #ffa800;border-bottom-color:#E09910" href="#" class="btn btn-minimize fa fa-chevron-circle-up"></a>
											<br />
											<a style="background: #df3f2e;" href="#" class="btn btn-minimize fa fa-arrow-up"></a>
											<a style="background: #b04f00;border-bottom-color:#DC8843;" href="#" class="btn btn-minimize fa fa-arrow-up"></a>
											<a style="background: #f55696;border-bottom-color:#B92A63;" href="#" class="btn btn-minimize fa fa-arrow-up"></a>
											<a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-minimize fa fa-arrow-up"></a>
											<a style="background: #ffa800;border-bottom-color:#E09910" href="#" class="btn btn-minimize fa fa-arrow-up"></a>
										</div>
									</div>
								</div>
								<div class="tooltip-contain backgrounds">
									<a href="#" class="tooltip-trigger fa fa-tasks"><span><?php _e( 'Backgrounds', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap">
										<h5><?php _e( 'Skins ( Color schema )', IBWP_PLUGIN_TEXTDOMAIN ); ?></h5>
										<div class="items-to-editor texts">
											<h6><?php _e( 'Choose a skin', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
											<select class="skins-picker show-on-change" data-target="#skins-container-{{index}}" data-value="26" name="variants[{{index}}][skins]">
												<option value="0">Apple</option>
												<option value="1">Coffee</option>
												<option value="2">Carnation</option>
												<option value="3">Dusk</option>
												<option value="4">Flare</option>
												<option value="5">Gold</option>
												<option value="6">Green apple</option>
												<option value="7">Green sea</option>
												<option value="8">Iceberg</option>
												<option value="9">Midnight sky</option>
												<option value="10">Mint</option>
												<option value="11">Lavender field</option>
												<option value="12">Paper</option>
												<option value="13">Pavement</option>
												<option value="14">Pumpkin</option>
												<option value="15">Rosy</option>
												<option value="16">Tropic Blue</option>
												<option value="17">Turquoise</option>
												<option value="18">Twilight</option>
												<option value="19">Yellow wood</option>
												<option value="20">Green Charles</option>
												<option value="21">Hawai Earth</option>
												<option value="22">Blueberry Yoghurt</option>
												<option value="23">Pink Lady</option>
												<option value="24">White Peace</option>
												<option value="25">Yellow Impact</option>
												<option value="26">Custom Scheme</option>
											</select>
											<div id="skins-container-{{index}}" class="hidden">
												<h6><?php _e( 'Customize your bar\'s skin', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
												<div class="input-control range">
													<div class="gradients"></div>
													<input type="text" class="hidden" name="variants[{{index}}][gradient]" id="gradient-values-{{index}}" value="0% #df3f2e,100% #b62618">
												</div>
												<div class="row cells2 border-options">
													<div class="cell">
														<h6><?php _e( 'Border size', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
														<div class="input-control range">
															<input class="border-width" type="range" name="variants[{{index}}][border-width]" min="0" max="15" value="2" />
															<span class="value"><em>2</em>px</span>
														</div>
													</div>
													<div class="cell">
														<div class="input-control color">
															<h6><?php _e( 'Border color', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
															<input class="style-border-color pick-color" type="text" name="variants[{{index}}][border-color]" />
														</div>
													</div>
												</div>
												<div class="input-control color">
													<h6><?php _e( 'Text color', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
													<input class="style-text-color pick-color" type="text" name="variants[{{index}}][text-color]" />
												</div>
												<div class="input-control color">
													<h6><?php _e( 'Link color', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
													<input class="style-link-color pick-color" type="text" name="variants[{{index}}][link-color]" />
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="tooltip-contain emoticons">
									<a href="#" class="tooltip-trigger fa fa-smile-o"><span><?php _e( 'Emoticons', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap">
										<div class="items-to-editor">
											<?php for ($i=1; $i < 61; $i++) { ?>
											<a href="#" class="btn-img">
												<img src="<?php echo $this->GetUrl('src/assets/icons/'.$i.'.png') ?>" alt="">
											</a>
											<?php } ?>
										</div>
									</div>
								</div>
								<div class="tooltip-contain fonts">
									<a href="#" class="tooltip-trigger fa fa-font"><span><?php _e( 'Fonts', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap">
										<h5><?php _e( 'Fonts', IBWP_PLUGIN_TEXTDOMAIN ); ?></h5>
										<div class="items-to-editor texts">
											<h6><?php _e( 'Choose font', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
											<select class="font-family" name="variants[{{index}}][font-family]">
												<option value="Arial">Arial</option>
												<option value="Century Gothic">Century Gothic</option>
												<option value="Comic Sans">Comic Sans</option>
												<option value="Georgia">Georgia</option>
												<option value="Lato">Lato</option>
												<option value="Lucida Handwriting">Lucida Handwriting</option>
												<option value="Myriad Pro">Myriad Pro</option>
												<option value="Open Sans">Open Sans</option>
												<option value="Times New Roman">Times New Roman</option>
												<option value="Vivaldi">Vivaldi</option>
											</select>
											<h6><?php _e( 'Font size', IBWP_PLUGIN_TEXTDOMAIN ); ?></h6>
											<div class="input-control range">
												<input class="font-size" type="range" min="8" max="30" value="22">
												<span class="value"><em>22</em>px</span>
											</div>
										</div>
									</div>
								</div>
								<div class="tooltip-contain buttons">
									<a href="#" class="tooltip-trigger fa fa-square"><span><?php _e( 'Buttons', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap">
										<h5><?php _e( 'Styles', IBWP_PLUGIN_TEXTDOMAIN ); ?></h5>
										<div id="btn-preview-{{index}}" class="btn-preview">
											<a href="#" class="ibw-primary-btn"><?php _e( 'Click here', IBWP_PLUGIN_TEXTDOMAIN ); ?></a>
										</div>
										<select class="buttons-styles" id="buttons-styles-{{index}}">
											<option value="1">Style1</option>
											<option value="2">Style2</option>
											<option value="3">Style3</option>
											<option value="4">Style4</option>
											<option value="5">Style5</option>
											<option value="6">Style6</option>
											<option value="7">Style7</option>
											<option value="8">Style8</option>
											<option value="9">Style9</option>
											<option value="10">Style10</option>
										</select>
										<div id="button-config-{{index}}">
											<div class="input-control text full-size">
												<input placeholder="Link label" type="text" class="link-label" value="<?php _e( 'Click here', IBWP_PLUGIN_TEXTDOMAIN ); ?>">
											</div>
											<div class="input-control text full-size">
												<input placeholder="Link URL" type="text" class="link-url" value="#">
											</div>
											<label class="input-control checkbox small-check">
												<input type="checkbox" class="link-target" value="_blank" checked="checked">
												<span class="check"></span>
												<span class="caption"><?php _e( 'Open in new window', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
											</label>
											<div class="btn-wrap">
												<a href="#" class="button button-primary button-large insert" data-type="buttons"><?php _e( 'Insert', IBWP_PLUGIN_TEXTDOMAIN ); ?></a>
											</div>
										</div>
										<div class="hidden">
											<div class="btn-gradient"></div>
											<input type="text" class="hidden" id="btn-gradient-values-{{index}}" value="0% #df3f2e,100% #b62618">
										</div>
									</div>
								</div>
								<div class="tooltip-contain custom-image">
									<a href="#" class="tooltip-trigger fa fa-picture-o"><span><?php _e( 'Image', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap wp-media-buttons">
										<h5><?php _e( 'Upload', IBWP_PLUGIN_TEXTDOMAIN ); ?></h5>
										<!-- <p><a data-index="{{index}}" class="upload-media fa fa-upload" href="#"><?php _e( 'Pick a custom image', IBWP_PLUGIN_TEXTDOMAIN ); ?></a> <?php _e( 'from your computer, or insert an URL of your image in the field bellow', IBWP_PLUGIN_TEXTDOMAIN ); ?></p> -->
										<a href="#" data-index="{{index}}" id="insert-media-button-{{index}}" class="button add_media" data-editor="content" title="Add Media"><span class="wp-media-buttons-icon"></span> Add Media</a>
										<div id="image-preview-{{index}}" class="image-preview"></div>
										<div class="btn-wrap">
											<a href="#" class="button button-primary button-large insert" data-type="image"><?php _e( 'Insert', IBWP_PLUGIN_TEXTDOMAIN ); ?></a>
										</div>
									</div>
								</div>
								<div class="tooltip-contain custom-link">
									<a href="#" class="tooltip-trigger fa fa-external-link-square"><span><?php _e( 'Link', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap">
										<h5><?php _e( 'Normal links', IBWP_PLUGIN_TEXTDOMAIN ); ?></h5>
										<p><?php _e( 'Insert simple links within your infobar by chosing the text, plus it anchor link.', IBWP_PLUGIN_TEXTDOMAIN ); ?></p>
										<div class="input-control text full-size">
											<input placeholder="Link label" type="text" class="link-label">
										</div>
										<div class="input-control text full-size">
											<input placeholder="Link URL" type="text" class="link-url">
										</div>
										<label class="input-control checkbox small-check">
											<input type="checkbox" class="link-target" value="_blank" checked="checked">
											<span class="check"></span>
											<span class="caption"><?php _e( 'Open in new window', IBWP_PLUGIN_TEXTDOMAIN ); ?></span>
										</label>
										<div class="btn-wrap">
											<a href="#" class="button button-primary button-large insert" data-type="link"><?php _e( 'Insert', IBWP_PLUGIN_TEXTDOMAIN ); ?></a>
										</div>
									</div>
								</div>
								<div class="tooltip-contain animated-icons">
									<a href="#" class="tooltip-trigger"><i class="fa fa-spinner fa-spin"></i><span><?php _e( 'Animations', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></a>
									<div class="tooltip-wrap grid">
										<div class="animated-icons-list">
											<a href="#"><i class="fa fa-wrench faa-wrench animated"></i></a>
											<a href="#"><i class="fa fa-bell faa-ring animated"></i></a>
											<a href="#"><i class="fa fa-envelope faa-horizontal animated"></i></a>
											<a href="#"><i class="fa fa-thumbs-o-up faa-vertical animated"></i></a>
											<a href="#"><i class="fa fa-warning faa-flash animated"></i></a>
											<a href="#"><i class="fa fa-thumbs-o-up faa-bounce animated"></i></a>
											<a href="#"><i class="fa fa-spinner faa-spin animated"></i></a>
											<a href="#"><i class="fa fa-plane faa-float animated"></i></a>
											<a href="#"><i class="fa fa-heart faa-pulse animated"></i></a>
											<a href="#"><i class="fa fa-envelope faa-shake animated"></i></a>
											<a href="#"><i class="fa fa-trophy faa-tada animated"></i></a>
											<a href="#"><i class="fa fa-space-shuttle faa-passing animated"></i></a>
											<a href="#"><i class="fa fa-circle-o faa-burst animated"></i></a>
										</div>
									</div>
								</div>
								<span class="presets-picker fa fa-list-alt"><span><?php _e('Presets', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></span>
							</div>
							<!-- /. -->
							<div class="input-control textarea full-size">
								<div id="msg-editor-{{index}}" class="message-editable" contenteditable="true" placeholder="<?php _e( 'Your infobar\'s text goes here', IBWP_PLUGIN_TEXTDOMAIN ); ?>"><p><?php _e( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit.', IBWP_PLUGIN_TEXTDOMAIN ); ?></p></div>
								<textarea class="message" name="variants[{{index}}][content]"><p><?php _e( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit.', IBWP_PLUGIN_TEXTDOMAIN ); ?></p></textarea>
								<textarea name="variants[{{index}}][wrap-styles]" id="variant-wrap-styles-{{index}}" class="hidden"></textarea>
								<textarea name="variants[{{index}}][closebtn]" id="variant-closebtn-{{index}}" class="hidden"><a style="background: #7191e1;border-bottom-color:#2C4C9A;" href="#" class="btn btn-hide fa fa-times-circle"></a></textarea>
							</div>
						</div>
						<div class="row cells2 status-contain">
							<div class="cell">
								<label for="remove-variant"><?php _e( 'Remove this variant', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
								<input type="button" name="remove-variant" class="button button-remove button-large" value="Remove">
							</div>
							<div class="cell">
								<label><?php _e( 'Status', IBWP_PLUGIN_TEXTDOMAIN ); ?></label>
								<label class="switch">
									<input type="checkbox" name="variants[{{index}}][status]" checked="checked">
									<span class="check"></span>
								</label>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div id="postbox-container-1" class="postbox-container">
				<div id="side-sortables" class="save-wrap">
					<div id="submitdiv" class="postbox">
						<h3 class="hndle"><span><?php echo ( $editing )? __( 'Save Modifications', IBWP_PLUGIN_TEXTDOMAIN ) :  __( 'Publish', IBWP_PLUGIN_TEXTDOMAIN ); ?></span></h3>
						<div class="inside">
							<div class="submitbox" id="submitpost">
								<div id="major-publishing-actions">
									<div class="campaign-status">
										<label class="switch <?php echo ($editing)? 'switch-status' : '' ?>">
											<input <?php echo ($editing)? 'data-id="'.$campaign_id.'"' : '' ?> type="checkbox" name="campaign-status" value="1" <?php echo ($editing && $campaignRow->campaign_status == 0)? '' : 'checked="checked"' ?>>
											<span class="check"></span>
											<img class="loader hidden" src="<?php  echo IBWP_PLUGIN_URL . 'src/assets/images/ajax.gif'; ?>" alt="" />
										</label>
									</div>
									<div id="publishing-action">
										<span class="spinner"></span>
										<input type="hidden" name="ibw_save_campaign" value="true" />
										<input type="submit" name="publish" id="publish" class="button button-primary button-large" value="<?php echo ( $editing )? __( 'Save', IBWP_PLUGIN_TEXTDOMAIN ) :  __( 'Publish', IBWP_PLUGIN_TEXTDOMAIN ); ?>">
									</div>
									<div class="clear"></div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div> 
	</div>
</form>
<form id="ibw-uploads-form" class="hidden" action="?" method="POST" enctype="multipart/form-data" target="ibw-uploads">
	<input type="file" id="media-uploader" name="media">
	<input type="hidden" name="action" value="ibwajax">
	<input type="hidden" name="ibw-action" value="upload-image">
	<input type="hidden" name="index" id="ibw-uploading-index">
	<?php 
		wp_nonce_field( 'ibw-verifier' );
	?>
	<iframe id="ibw-uploads" name="ibw-uploads" src="#"></iframe>
</form>
<div id="pressets-container" class="hidden">
	<h2><?php _e('Additional Components', IBWP_PLUGIN_TEXTDOMAIN ); ?></h2>
	<p><?php _e('We’ve included our 1 click presets which we have used and developed over different colours. These Presets will get you to a finished infobar in 1 click!, you\'ll only need to edit the texts with in, and add additional components.', IBWP_PLUGIN_TEXTDOMAIN ); ?></p>
	<ul id="presets-list"></ul>
</div>