<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;


/**
 * Admin Class
 * 
 * Handles generic Admin functionality and AJAX requests.
 * 
 * @package Social Auto Poster
 * @since 1.0.0
 */
class Wpw_Auto_Posting_AdminPages {

	public $scripts, $model, $render, $message, $logs,
			$fbposting, $twposting, $liposting, $admin;
	
	public function __construct() {		
	
		global $wpw_auto_poster_scripts, $wpw_auto_poster_model, $wpw_auto_poster_render, $wpw_auto_poster_message_stack,
				$wpw_auto_poster_fb_posting, $wpw_auto_poster_tw_posting, $wpw_auto_poster_li_posting, 
				$wpw_auto_poster_dc_posting, $wpw_auto_poster_ba_posting, 
				$wpw_auto_poster_tb_posting, $wpw_auto_poster_logs,$wpw_auto_poster_admin;
		
		$this->scripts 	= $wpw_auto_poster_scripts;
		$this->model 	= $wpw_auto_poster_model;
		$this->render 	= $wpw_auto_poster_render;
		$this->message 	= $wpw_auto_poster_message_stack;
		$this->logs		= $wpw_auto_poster_logs;
		$this->admin	= $wpw_auto_poster_admin;
		
		//social posting class objects
		$this->fbposting = $wpw_auto_poster_fb_posting;
		$this->twposting = $wpw_auto_poster_tw_posting;
		$this->liposting = $wpw_auto_poster_li_posting;
		$this->tbposting = $wpw_auto_poster_tb_posting;
		$this->dcposting = $wpw_auto_poster_dc_posting;
		$this->baposting = $wpw_auto_poster_ba_posting;
	}

	/**
	 * Register Settings
	 *
	 * Runs when the admin_init hook fires and registers 
	 * the plugin settings with the WordPress settings API.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_init() {
	
		register_setting( 'wpw_auto_poster_plugin_options', 'wpw_auto_poster_options', array( $this, 'validate_options' ) );
	}

	/**
	 * Validation/Sanitization
	 *
	 * Sanitize and validate input fields.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function validate_options( $input ) {	
		
		global $wpw_auto_poster_options;
		
		//Facebook Settings Options
		$input['fb_bitly_username']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['fb_bitly_username'] );
		$input['fb_bitly_api_key']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['fb_bitly_api_key'] );
		$input['fb_app_id']					=	$this->model->wpw_auto_poster_stripslashes_deep( $input['fb_app_id'] );
		$input['fb_app_secret']				=	$this->model->wpw_auto_poster_stripslashes_deep( $input['fb_app_secret'] );
		$input['custom_status_msg']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['custom_status_msg'] );
		$input['fb_custom_img']				=	$this->model->wpw_auto_poster_stripslashes_deep( $input['fb_custom_img'] );
		
		//facebook application id or secret blank or change then reset session
		if( ( empty( $input['fb_app_id'] ) || empty( $input['fb_app_secret'] ) ) 
				|| ( $wpw_auto_poster_options['fb_app_id'] != $input['fb_app_id'] ) 
				|| ( $wpw_auto_poster_options['fb_app_secret'] != $input['fb_app_secret'] ) ) {
			//reset facebook session data
			$this->fbposting->wpw_auto_poster_fb_reset_session();
		}
		
		//Twitter Settings Options
		$input['tw_bitly_username']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['tw_bitly_username'] );
		$input['tw_bitly_api_key']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['tw_bitly_api_key'] );
		$input['twitter_keys']				=	isset( $input['twitter_keys'] ) ? $this->model->wpw_auto_poster_stripslashes_deep( $input['twitter_keys'] ) : '';
		
		//Get twitter account details
		if( !empty( $input['twitter_keys'] ) ) {

			//Get twitter account details
			$tw_account_details = array();
			
			$twitter_keys = $input['twitter_keys'];
			
			//Check difference of arrays
			$twitter_keys_old_data = $this->model->wpw_auto_poster_get_one_dim_array( $wpw_auto_poster_options['twitter_keys'] );
			$twitter_keys_new_data = $this->model->wpw_auto_poster_get_one_dim_array( $twitter_keys );
			
			$twitter_keys_result = array_diff( $twitter_keys_new_data, $twitter_keys_old_data );
			$twitter_keys_result_vise = array_diff( $twitter_keys_old_data, $twitter_keys_new_data );
			
			// Check any one array is different 
			if( !empty( $twitter_keys_result ) || !empty( $twitter_keys_result_vise ) ) {
				
				$tw_count_key = 0;
				$wpw_auto_poster_twitter_keys = array();
				foreach ( $twitter_keys as $tw_key => $tw_value ) {
					
					$tw_consumer_key 		= $tw_value['consumer_key'];
					$tw_consumer_secret 	= $tw_value['consumer_secret'];
					$tw_auth_token 			= $tw_value['oauth_token'];
					$tw_auth_token_secret 	= $tw_value['oauth_secret'];
					
					if( !empty( $tw_consumer_key ) || !empty( $tw_consumer_secret )
						|| !empty( $tw_auth_token ) || !empty( $tw_auth_token_secret ) ) { // Check any one key is set as not empty
						
						$wpw_auto_poster_twitter_keys[$tw_count_key]['consumer_key'] 	= $tw_consumer_key;
						$wpw_auto_poster_twitter_keys[$tw_count_key]['consumer_secret'] = $tw_consumer_secret;
						$wpw_auto_poster_twitter_keys[$tw_count_key]['oauth_token'] 	= $tw_auth_token;
						$wpw_auto_poster_twitter_keys[$tw_count_key]['oauth_secret'] 	= $tw_auth_token_secret;
							
						$tw_count_key = $tw_count_key + 1;
						$user_profile_data = $this->twposting->wpw_auto_poster_get_user_data( $tw_consumer_key, $tw_consumer_secret, $tw_auth_token, $tw_auth_token_secret );
						if( !empty( $user_profile_data ) ) { // Check user data are not empty
							
							if( isset( $user_profile_data->name ) && !empty( $user_profile_data->name ) ) { // Check user name is not empty
								
								$tw_account_details[$tw_count_key] = $user_profile_data->name;	
							}
						}
					}
				}
				
				$input['twitter_keys'] = $wpw_auto_poster_twitter_keys;
				
				//Update twitter acoount details
				update_option( 'wpw_auto_poster_tw_account_details', $tw_account_details );
			}
		}	
		
		//LinkedIn Settings Options
		$input['li_bitly_username']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['li_bitly_username'] );
		$input['li_bitly_api_key']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['li_bitly_api_key'] );
		$input['linkedin_app_id']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['linkedin_app_id'] );
		$input['linkedin_app_secret']		=	$this->model->wpw_auto_poster_stripslashes_deep( $input['linkedin_app_secret'] );
		$input['li_post_image']				=	$this->model->wpw_auto_poster_stripslashes_deep( $input['li_post_image'] );
		
		//linkedin application id or secret blank or change then reset session
		if( ( empty( $input['linkedin_app_id'] ) || empty( $input['linkedin_app_secret'] ) ) 
				|| ( $wpw_auto_poster_options['linkedin_app_id'] != $input['linkedin_app_id'] )
				|| ( $wpw_auto_poster_options['linkedin_app_secret'] != $input['linkedin_app_secret'] ) ) {
			//reset linkedin session data		
			$this->liposting->wpw_auto_poster_li_reset_session();
		}
		
		//Tumblr Settings Options
		$input['tb_bitly_username']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['tb_bitly_username'] );
		$input['tb_bitly_api_key']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['tb_bitly_api_key'] );
		$input['tumblr_consumer_key']		=	$this->model->wpw_auto_poster_stripslashes_deep( $input['tumblr_consumer_key'] );
		$input['tumblr_consumer_secret']	=	$this->model->wpw_auto_poster_stripslashes_deep( $input['tumblr_consumer_secret'] );
		
		//tumblr consumer key or secret balnk or change then reset session 
		if( ( empty( $input['tumblr_consumer_key'] ) || empty( $input['tumblr_consumer_secret'] ) ) 
				|| ( $wpw_auto_poster_options['tumblr_consumer_key'] != $input['tumblr_consumer_key'] ) 
				|| ( $wpw_auto_poster_options['tumblr_consumer_secret'] != $input['tumblr_consumer_secret'] ) ) {
			//reset tumblr session data
			$this->tbposting->wpw_auto_poster_tb_reset_session();
		}
		
		// Delicious Settings Option
		$input['dc_bitly_username']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['dc_bitly_username'] );
		$input['dc_bitly_api_key']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['dc_bitly_api_key'] );
		$input['delicious_username']		=	$this->model->wpw_auto_poster_stripslashes_deep( $input['delicious_username'] );
		$input['delicious_password']		=	$this->model->wpw_auto_poster_stripslashes_deep( base64_encode( $input['delicious_password'] ) );
		
		// BufferApp Settings Option
		$input['ba_bitly_username']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['ba_bitly_username'] );
		$input['ba_bitly_api_key']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['ba_bitly_api_key'] );
		$input['bufferapp_client_id']		=	$this->model->wpw_auto_poster_stripslashes_deep( $input['bufferapp_client_id'] );
		$input['bufferapp_client_secret']	=	$this->model->wpw_auto_poster_stripslashes_deep( $input['bufferapp_client_secret'] );
		$input['ba_post_img']				=	$this->model->wpw_auto_poster_stripslashes_deep( $input['ba_post_img'] );
		
		//BufferApp client id or secret blank or change then reset session
		if( ( empty( $input['bufferapp_client_id'] ) || empty( $input['bufferapp_client_secret'] ) ) 
				|| ( $wpw_auto_poster_options['bufferapp_client_id'] != $input['bufferapp_client_id'] )
				|| ( $wpw_auto_poster_options['bufferapp_client_secret'] != $input['bufferapp_client_secret'] ) ) {
			//reset bufferapp session data
			$this->baposting->wpw_auto_poster_ba_reset_session();
		}
		
		//set session to set tab selected in settings page
		$selectedtab = isset( $input['selected_tab'] ) ? $input['selected_tab'] : '';
		$this->message->add_session( 'poster-selected-tab', strtolower( $selectedtab ) );
		
		// apply filters for validate settings
		$input = apply_filters( 'wpw_auto_poster_validate_settings', $input, $wpw_auto_poster_options );
		
		return $input;
	}
	
	/**
	 * Add Top Level Menu Page
	 *
	 * Runs when the admin_menu hook fires and adds a new
	 * top level admin page and menu item.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_add_settings_page() {
	
		global $post;
		
		// plugin settings page
		$wpw_auto_poster_admin = add_menu_page( __( 'Social Auto Poster', 'wpwautoposter' ), __( 'Social Auto Poster', 'wpwautoposter' ), wpwautoposterlevel, 'wpw-auto-poster-settings', '', WPW_AUTO_POSTER_IMG_URL . '/wpw-auto-poster-icon.png'); 
		
		$wpw_auto_poster_admin = add_submenu_page( 'wpw-auto-poster-settings', __( 'Social Auto Poster Settings', 'wpwautoposter' ), __( 'Settings', 'wpwautoposter' ), wpwautoposterlevel, 'wpw-auto-poster-settings', array( $this, 'wpw_auto_poster_settings_page' ) );
	    $wpw_auto_poster_posted_logs = add_submenu_page( 'wpw-auto-poster-settings',  __( 'Social Auto Poster Posting Logs', 'wpwautoposter' ), __( 'Social Posting Logs', 'wpwautoposter' ), wpwautoposterlevel, 'wpw-auto-poster-posted-logs', array( $this, 'wpw_auto_poster_posted_logs_page' ) );
	    
		add_action( "admin_head-$wpw_auto_poster_admin", array( $this->scripts, 'wpw_auto_poster_settings_page_load_scripts' ) );

	}

	/**
	 * Settings Page
	 *
	 * Renders the plugin settings page.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_settings_page() {		
	 
		include_once( WPW_AUTO_POSTER_ADMIN . '/forms/wpw-auto-poster-settings-hooks.php' );
		include_once( WPW_AUTO_POSTER_ADMIN . '/forms/wpw-auto-poster-plugin-settings.php' );
	}
	
	/**
	 * Posted Logs List
	 *
	 * Renders the posted logs list page.
	 *
	 * @package Social Auto Poster
	 * @since 1.4.0
	 */
	function wpw_auto_poster_posted_logs_page() {
		
		include( WPW_AUTO_POSTER_ADMIN . '/forms/wpw-auto-poster-posted-logs-list.php' );
	}
	
	/**
	 * Post to Social Medias
	 * 
	 * Handles to post to social media
	 *
	 * @package Social Auto Poster
	 * @since 1.5.0
	 */
	public function wpw_auto_poster_social_posting( $post ) {
		
		global $wpw_auto_poster_options, $postedstr, $schedulepoststr;
		
		$prefix = WPW_AUTO_POSTER_META_PREFIX;
		
		$postedstr = $schedulepoststr = array();
		
		$postid = $post->ID;
		
		//Facebook Posting
		$facebookarr = !empty($wpw_auto_poster_options['enable_facebook_for']) ? $wpw_auto_poster_options['enable_facebook_for'] : array();
		
		//get post published on facebook
		$fb_published = get_post_meta( $postid, $prefix . 'fb_published_on_fb', true );
		
		//record logs for facebook posting
		$this->logs->wpw_auto_poster_add( 'Facebook Posting | ' . $post->post_type . ' | ' . $postid, true );
		
		$schedule_post_to = get_post_meta( $postid, $prefix . 'schedule_wallpost', true );
		$schedule_post_to = !empty( $schedule_post_to ) ? $schedule_post_to : array();
		
			//Check If post is already published and there is disable from metabox but it has checked in backend
			//then it will post to social site when the post is going to published first time when created new
			if( ( !empty( $wpw_auto_poster_options['enable_facebook'] ) && ( !isset( $fb_published ) || $fb_published == false ) && in_array( $post->post_type, $facebookarr ) ) 
					|| ( isset( $_POST[$prefix.'post_to_facebook'] ) && $_POST[$prefix.'post_to_facebook'] == 'on' ) ) { 
				
				if( empty( $wpw_auto_poster_options['schedule_wallpost_option'] ) ) { // Check schedule option is "Instantly"
					
					//post to user wall on facebook
					$fb_result = $this->fbposting->wpw_auto_poster_fb_posting( $post );
					if( $fb_result ) {
						$postedstr[] = 'fb';
					}
					
				} else {
					
					if( !in_array( 'facebook', $schedule_post_to ) ) {
						$schedule_post_to[] = 'facebook';
					}
					$schedulepoststr[] = 'fb';
				}
			}
		
		//record logs for twitter posting
		$this->logs->wpw_auto_poster_add( 'Twitter Posting | ' . $post->post_type . ' | ' . $postid, true );
			
		//Twitter Posting
		$twitterarr = !empty($wpw_auto_poster_options['enable_twitter_for']) ? $wpw_auto_poster_options['enable_twitter_for'] : array();
			
		$tw_published = get_post_meta( $postid, $prefix . 'tw_status', true );
		
			//Check If post is already published and there is disable from metabox but it has checked in backend
			//then it will post to social site when the post is going to published first time when created new
			if( ( !empty( $wpw_auto_poster_options['enable_twitter'] ) && ( !isset( $tw_published ) || $tw_published == false ) && in_array( $post->post_type,$twitterarr ) ) 
			 	|| ( isset( $_POST[$prefix.'post_to_twitter'] ) && $_POST[$prefix.'post_to_twitter'] == 'on' ) )  { 
				
			 	if( empty( $wpw_auto_poster_options['schedule_wallpost_option'] ) ) { // Check schedule option is "Instantly"
			 		
					//post to twitter
					$tw_result = $this->twposting->wpw_auto_poster_tw_posting( $post );
					if( $tw_result ) {
						$postedstr[] = 'tw';
					}
					
			 	} else {
			 		
			 		if( !in_array( 'twitter', $schedule_post_to ) ) {
						$schedule_post_to[] = 'twitter';
					}
					$schedulepoststr[] = 'tw';
			 	}
			}
		
		//record logs for linkedin posting
		$this->logs->wpw_auto_poster_add( 'LinkedIn Posting | ' . $post->post_type . ' | ' . $postid, true );
			
		//LinkedIn Posting
		$linkedinarr = !empty($wpw_auto_poster_options['enable_linkedin_for']) ? $wpw_auto_poster_options['enable_linkedin_for'] : array();
		
		$li_published = get_post_meta( $postid, $prefix . 'li_status', true );
		
			
			//Check If post is already published and there is disable from metabox but it has checked in backend
			//then it will post to social site when the post is going to published first time when created new
			if( ( !empty( $wpw_auto_poster_options['enable_linkedin'] ) && ( !isset( $li_published ) || $li_published == false ) && in_array( $post->post_type,$linkedinarr ) ) 
					|| ( isset( $_POST[$prefix.'post_to_linkedin'] ) && $_POST[$prefix.'post_to_linkedin'] == 'on' ) ) { 
				
				if( empty( $wpw_auto_poster_options['schedule_wallpost_option'] ) ) { // Check schedule option is "Instantly"	
				
					//post to linkedin
					$li_result = $this->liposting->wpw_auto_poster_li_posting( $post );
					if( $li_result ) {
						$postedstr[] = 'li';
					}
					
				} else {
					
					if( !in_array( 'linkedin', $schedule_post_to ) ) {
						$schedule_post_to[] = 'linkedin';
					}
					$schedulepoststr[] = 'li';
				}
			}
		
		//record logs for Tumblr posting
		$this->logs->wpw_auto_poster_add( 'Tumblr Posting | ' . $post->post_type . ' | ' . $postid, true );
			
		//Tumblr Posting
		$tumblrarr = !empty($wpw_auto_poster_options['enable_tumblr_for']) ? $wpw_auto_poster_options['enable_tumblr_for'] : array();
		
		$tb_published = get_post_meta( $postid, $prefix . 'tb_status', true );
		
			//Check If post is already published and there is disable from metabox but it has checked in backend
			//then it will post to social site when the post is going to published first time when created new
			if( ( !empty( $wpw_auto_poster_options['enable_tumblr'] ) && ( !isset( $tb_published ) || $tb_published == false ) && in_array( $post->post_type, $tumblrarr ) ) 
						|| ( isset( $_POST[$prefix.'post_to_tumblr'] ) && !empty( $_POST[$prefix.'post_to_tumblr'] ) ) ) { 
				
				if( empty( $wpw_auto_poster_options['schedule_wallpost_option'] ) ) { // Check schedule option is "Instantly"
					
					//post to tumblr
					$tb_result = $this->tbposting->wpw_auto_poster_tb_posting( $post );
					if( $tb_result ) {
						$postedstr[] = 'tb';
					}
					
				} else {
					
					if( !in_array( 'tumblr', $schedule_post_to ) ) {
						$schedule_post_to[] = 'tumblr';
					}
					$schedulepoststr[] = 'tb';
				}
			}
			
		//record logs for Delicious posting
		$this->logs->wpw_auto_poster_add( 'Delicious Posting | ' . $post->post_type . ' | ' . $postid, true );
		
		//delicious Posting
		$deliciousarr = !empty($wpw_auto_poster_options['enable_delicious_for']) ? $wpw_auto_poster_options['enable_delicious_for'] : array();
		
		$dc_published = get_post_meta( $postid, $prefix . 'dc_status', true );
		
			//Check If post is already published and there is disable from metabox but it has checked in backend
			//then it will post to social site when the post is going to published first time when created new
			if( ( !empty( $wpw_auto_poster_options['enable_delicious'] ) && ( !isset( $dc_published ) || $dc_published == false ) && in_array( $post->post_type, $deliciousarr ) ) 
						|| ( isset( $_POST[$prefix.'post_to_delicious'] ) && !empty( $_POST[$prefix.'post_to_delicious'] ) ) ) { 
				
				if( empty( $wpw_auto_poster_options['schedule_wallpost_option'] ) ) { // Check schedule option is "Instantly"
					
					//post to delicious
					$dc_result = $this->dcposting->wpw_auto_poster_dc_posting( $post );
					if( $dc_result ) {
						$postedstr[] = 'dc';
					}
					
				} else {
					
					if( !in_array( 'delicious', $schedule_post_to ) ) {
						$schedule_post_to[] = 'delicious';
					}
					$schedulepoststr[] = 'dc';
				}
			}
			
		//record logs for BufferApp posting
		$this->logs->wpw_auto_poster_add( 'BufferApp Posting | ' . $post->post_type . ' | ' . $postid, true );
		
		//bufferapp Posting
		$bufferapparr = !empty($wpw_auto_poster_options['enable_bufferapp_for']) ? $wpw_auto_poster_options['enable_bufferapp_for'] : array();
		
		$ba_published = get_post_meta( $postid, $prefix.'ba_status', true );
		
			if( ( !empty( $wpw_auto_poster_options['enable_bufferapp'] ) && ( !isset( $ba_published ) || $ba_published == false ) && in_array( $post->post_type,$bufferapparr ) ) 
					|| ( isset( $_POST[$prefix.'post_to_bufferapp'] ) && !empty( $_POST[$prefix.'post_to_bufferapp'] ) ) ) { //if tumblr is seleectd then post to bufferapp account
				
				if( empty( $wpw_auto_poster_options['schedule_wallpost_option'] ) ) { // Check schedule option is "Instantly"
				
					//post to bufferapp
					$ba_result = $this->baposting->wpw_auto_poster_ba_posting( $post );
					if( $ba_result ) {
						$postedstr[] = 'ba';
					}
					
				} else {
					
					if( !empty( $_SESSION['wpw_auto_poster_ba_user_id'] ) ) {
						
						if( !in_array( 'bufferapp', $schedule_post_to ) ) {
							$schedule_post_to[] = 'bufferapp';
						}
						$schedulepoststr[] = 'ba';
					}
				}
			}
		
		//update schedule wallpost
		update_post_meta( $postid, $prefix . 'schedule_wallpost', $schedule_post_to );
	}
	
	/**
	 * Post to Social Medias
	 * 
	 * Handles to post to social media
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_post_to_social_media( $postid, $post ) {
		
		global $wpw_auto_poster_options;
		
		$post_type_object = get_post_type_object( $post->post_type );
		
		if ( ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )	// Check Autosave
			|| ( ! isset( $_POST['post_ID'] ) || $postid != $_POST['post_ID'] )
			|| ( ! current_user_can( $post_type_object->cap->edit_post, $postid ) )
			|| ( $post->post_status != 'publish' ) )  {
			return $postid;
		}
		
		$prefix = WPW_AUTO_POSTER_META_PREFIX;
		
		// apply filters for verify send wall posr after post create/update
		$has_send_wall_post = apply_filters( 'wpw_auto_poster_verify_send_wall_post', true, $post, $wpw_auto_poster_options );
			
		if( $has_send_wall_post ) { // Verified for send wall post
			
			//posting to all social medias
			$this->wpw_auto_poster_social_posting( $post );
		}
				
		//redirect to custom url after saving post
		add_filter('redirect_post_location', array( $this, 'wpw_auto_poster_redirect_save_post') );
	}
	
	/**
	 * Add Schedule posting with social media
	 * 
	 * Handles to work posting on social media when 
	 * someone set schedule for particular post
	 * at that time it will automatic posted on social medias
	 * whichever is selected in settings page
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_schedule_posting( $postid ) {
		
		global $wpw_auto_poster_options;
		
		$post = get_post( $postid );
		
		if ( $post->post_type == 'revision' ) return; // Imp Line //  if revision dont do anything.
		if ( $post->post_status != 'publish' ) return;
			
		$prefix = WPW_AUTO_POSTER_META_PREFIX;
			
		// apply filters for verify send wall posr after post create/update
		$has_send_wall_post = apply_filters( 'wpw_auto_poster_verify_send_wall_post', true, $post, $wpw_auto_poster_options );
			
		if( $has_send_wall_post ) { // Verified for send wall post
			
			//posting to all social medias
			$this->wpw_auto_poster_social_posting( $post );
		}
	}
	
	/**
	 * Redirect After Save Post
	 * 
	 * Handles to redirect after saving post
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_redirect_save_post( $loc ) {
		
		global $postedstr, $schedulepoststr;
		
		if( !empty( $postedstr ) ) {
			
			return add_query_arg( 'wpwautoposteron', $postedstr, $loc);
			
		} else if( !empty( $schedulepoststr ) ) {
			
			return add_query_arg( 'wpwautoposterscheduleon', $schedulepoststr, $loc);
			
		} else {
			
			return $loc;
		}
	}
	
	/**
	 * Admin Notices
	 * 
	 * Handles to show admin notices after successfully
	 * posted to social networks
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_admin_notices() {
		
		if ( isset( $_GET['wpwautoposteron'] ) || isset( $_GET['wpwautoposterscheduleon'] ) ) {
		
			$postedon 	= isset( $_GET['wpwautoposteron'] ) ? $_GET['wpwautoposteron'] : '';
			$scheduledon= isset( $_GET['wpwautoposterscheduleon'] ) ? $_GET['wpwautoposterscheduleon'] : '';
			
			$reparr = array( 'fb', 'tw', 'li', 'tb','dc','ba' );
			$replcarr = array( 
								__( 'Facebook', 'wpwautoposter' ),
								__( 'Twitter', 'wpwautoposter' ),
								__( 'LinkedIn', 'wpwautoposter' ),
								__( 'Tumblr', 'wpwautoposter' ),
								__( 'Delicious', 'wpwautoposter' ),
								__( 'BufferApp', 'wpwautoposter' ),
							);
			
			if( !empty( $scheduledon ) ) {
				
				$scheduledon = str_replace( $reparr, $replcarr, $scheduledon );
				$scheduledon = implode( $scheduledon, ',' );
				$msg =  sprintf( __( 'Post scheduled with %1$s', 'wpwautoposter' ), $scheduledon);
				
			} else {
				
				$postedon = str_replace( $reparr, $replcarr, $postedon );
				$postedon = implode( $postedon, ',' );
				$msg =  sprintf( __( 'Post published on %1$s', 'wpwautoposter' ), $postedon);
			}
			
			echo "<div class='updated'><p>{$msg}.</p></div>";
		}
	}
	
	/**
	 * Bulk Delete
	 * 
	 * Handles bulk delete functinalities of posted logs
	 * 
	 * @package Social Auto Poster
	 * @since 1.4.0
	 */
	function wpw_auto_poster_posted_logs_bulk_delete() {
		
		if( ( ( isset( $_GET['action'] ) && $_GET['action'] == 'delete') || ( isset( $_GET['action2'] ) && $_GET['action2'] == 'delete' ) )
			  && isset( $_GET['page'] ) && $_GET['page'] == 'wpw-auto-poster-posted-logs'
			  && isset( $_GET['logid'] ) && !empty( $_GET['logid'] ) ) { //check action and page and also logid
		
			// get redirect url
			$redirect_url = add_query_arg( array( 'page' => 'wpw-auto-poster-posted-logs' ), admin_url( 'admin.php' ) );	
			
			//get bulk product array from $_GET
			$action_on_id = $_GET['logid'];
			
			if( count( $action_on_id ) > 0 ) { //check there is some checkboxes are checked or not 
				
				//if there is multiple checkboxes are checked then call delete in loop
				foreach ( $action_on_id as $posted_log_id ) {
					
					//parameters for delete function
					$args = array (
									'log_id' => $posted_log_id
								);
								
					//call delete function from model class to delete records
					$this->model->wpw_auto_poster_bulk_delete( $args );
				}
				$redirect_url = add_query_arg( array( 'message' => '3' ), $redirect_url );
				
				//if bulk delete is performed successfully then redirect 
				wp_redirect( $redirect_url ); 
				exit;
			} else {
				//if there is no checboxes are checked then redirect to listing page
				wp_redirect( $redirect_url ); 
				exit;
			}
		}
	}
	
	/**
	 * Validate Setting
	 *
	 * Handles to add validate schedule settings
	 * 
	 * @package Social Auto Poster
	 * @since 1.5.0
	 */
	public function wpw_auto_poster_validate_setting( $new_data, $old_data ) {
		
		if( !empty( $new_data['schedule_wallpost_option'] ) 
			&& $new_data['schedule_wallpost_option'] != $old_data['schedule_wallpost_option'] ) { // Check Schedule WallPost is not "Instance"
		
			// first clear the schedule	
			wp_clear_scheduled_hook( 'wpw_auto_poster_scheduled_cron' );
			
			if ( ! wp_next_scheduled( 'wpw_auto_poster_scheduled_cron' ) ) {
				
				$utc_timestamp = time(); //
				$local_time = current_time( 'timestamp' ); // to get current local time
				if( $new_data['schedule_wallpost_option'] == 'daily' && isset( $new_data['schedule_wallpost_time'] )
					&& isset( $new_data['schedule_wallpost_minute'] ) ) {
						
					// Schedule other CRON events starting at user defined hour and periodically thereafter
					$schedule_time 	= mktime( $new_data['schedule_wallpost_time'], $new_data['schedule_wallpost_minute'], 0, date('m', $local_time), date('d', $local_time), date('Y', $local_time) );
					// get difference 
					$diff 		= ( $schedule_time - $local_time );
					$utc_timestamp 	= $utc_timestamp + $diff;
					
					wp_schedule_event( $utc_timestamp, 'daily', 'wpw_auto_poster_scheduled_cron' );
					
				} else {
					
					$scheds = (array)wp_get_schedules();
					$current_schedule = $new_data['schedule_wallpost_option'];
					$interval = ( isset($scheds[$current_schedule]['interval']) ) ? (int) $scheds[$current_schedule]['interval'] : 0;
					
					$utc_timestamp = $utc_timestamp + $interval;
					
					wp_schedule_event( $utc_timestamp, $new_data['schedule_wallpost_option'], 'wpw_auto_poster_scheduled_cron' );
				}
			}
		}
		return $new_data;
	}
	
	/**
	 * Add Custom Schedule
	 * 
	 * Handle to add custom schedule
	 *
	 * @package Social Auto Poster
	 * @since 1.5.0
	 */
	public function wpw_auto_poster_add_custom_scheduled( $schedules ) {
		
		// Adds once weekly to the existing schedules.
		$schedules['weekly'] = array(
										'interval'	=> 604800,
										'display'	=> __( 'Once Weekly', 'wpwautoposter' )
									);
		return $schedules;
	}
	
	/**
	 * Cron Job For Send WallPost to Followers
	 * 
	 * Handle to call schedule cron for
	 * send wallpost to followers
	 *
	 * @package Social Auto Poster
	 * @since 1.5.0
	 */
	public function wpw_auto_poster_scheduled_cron() {
		
		$prefix = WPW_AUTO_POSTER_META_PREFIX;
		
		// Get all post data which have send wall post
		$posts_data = $this->model->wpw_auto_poster_get_schedule_post_data();
		
		if( !empty( $posts_data ) ) { // Check post data are not empty
			
			foreach ( $posts_data as $post_data ) {
				
				$postid = $post_data->ID;
				
				//get schedule wallpost
				$get_schedule = get_post_meta( $postid, $prefix . 'schedule_wallpost', true );
				
				if( in_array( 'facebook', $get_schedule ) ) { // Check facebook
					
					//post to user wall on facebook
					$this->fbposting->wpw_auto_poster_fb_posting( $post_data );
					
				}
				if ( in_array( 'twitter', $get_schedule ) ) { // Check twitter
					
					//post to twitter
					$this->twposting->wpw_auto_poster_tw_posting( $post_data );
					
				}
				if ( in_array( 'linkedin', $get_schedule ) ) { // Check linkedin
					
					//post to linkedin
					$this->liposting->wpw_auto_poster_li_posting( $post_data );
					
				}
				if ( in_array( 'tumblr', $get_schedule ) ) { // Check tumblr
					
					//post to tumblr
					$this->tbposting->wpw_auto_poster_tb_posting( $post_data );
					
				}
				if ( in_array( 'delicious', $get_schedule ) ) { // Check delicious
					
					//post to delicious
					$this->dcposting->wpw_auto_poster_dc_posting( $post_data );
					
				}
				if ( in_array( 'bufferapp', $get_schedule ) ) { // Check bufferapp
					
					//post to bufferapp
					$this->baposting->wpw_auto_poster_ba_posting( $post_data );
					
				}
				//delete schedule wallpost
				delete_post_meta( $postid, $prefix . 'schedule_wallpost' );
			}
		}
	}
	
	/**
	 * Adding Hooks
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function add_hooks() {
		
		// if the user can edit plugin options, let the fun begin!
		add_action( 'admin_menu', array( $this, 'wpw_auto_poster_add_settings_page' ) );
		add_action( 'admin_init', array( $this, 'wpw_auto_poster_init' ));
		
		//post to social media when post or page or custom post type will be published
		add_action( 'save_post', array( $this, 'wpw_auto_poster_post_to_social_media' ), 15, 2 );
		
		//add for schedule posting
		add_action( 'publish_future_post', array( $this, 'wpw_auto_poster_schedule_posting' ) );
		
		//show admin notices
		add_action( 'admin_notices', array( $this, 'wpw_auto_poster_admin_notices' ) );
		
		//add admin init for bult delete functionality
		add_action( 'admin_init' , array( $this, 'wpw_auto_poster_posted_logs_bulk_delete' ) );
		
		// add filter to add validate settings
		add_filter( 'wpw_auto_poster_validate_settings', array( $this, 'wpw_auto_poster_validate_setting' ), 10, 2 );
		
		//add filter to add custom schedule
		add_filter( 'cron_schedules', array( $this, 'wpw_auto_poster_add_custom_scheduled' ) );
		
		//add action to call schedule cron for send wall post
		add_action( 'wpw_auto_poster_scheduled_cron', array( $this, 'wpw_auto_poster_scheduled_cron' ) );
	}
}