<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Delicious Settings
 *
 * The html markup for the Delicious settings tab.
 *
 * @package Social Auto Poster
 * @since 1.3.0
 */

global $wpw_auto_poster_options, $wpw_auto_poster_model;

//model class
$model = $wpw_auto_poster_model;


?>

<!-- beginning of the delicious general settings meta box -->
<div id="wpw-auto-poster-delicious-general" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="delicious_general" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
								
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'Delicious General Settings', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[enable_delicious]"><?php _e( 'Enable Autoposting to Delicious:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input name="wpw_auto_poster_options[enable_delicious]" id="wpw_auto_poster_options[enable_delicious]" type="checkbox" value="1" <?php if( isset( $wpw_auto_poster_options['enable_delicious'] ) ) { checked( '1', $wpw_auto_poster_options['enable_delicious'] ); } ?> />
										<p><small><?php _e( 'Check this box, if you want to autopost your content to Delicious.', 'wpwautoposter' ); ?></small></p>
									</td>
								</tr>	

								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[enable_delicious_for]"><?php _e( 'Enable Delicious Autoposting for:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<ul>
										<?php 
											$all_types = get_post_types( array( 'public' => true ), 'objects');
											$all_types = is_array( $all_types ) ? $all_types : array();
											
											if( !empty( $wpw_auto_poster_options['enable_delicious_for'] ) ) {
												$prevent_meta = $wpw_auto_poster_options['enable_delicious_for'];
											} else {
												$prevent_meta = '';
											}
															
											$prevent_meta = is_array( $prevent_meta ) ? $prevent_meta : array();
														
											foreach ( $all_types as $type ) {	
														
												if ( !is_object( $type ) ) continue;															
													$label = @$type->labels->name ? $type->labels->name : $type->name;
													if( $label == 'Media' || $label == 'media' ) continue; // skip media
													$selected = ( in_array( $type->name, $prevent_meta ) ) ? 'checked="checked"' : '';
										?>
															
											<li class="wpw-auto-poster-prevent-types">
												<input type="checkbox" id="wpw_auto_posting_dc_prevent_<?php echo $type->name; ?>" name="wpw_auto_poster_options[enable_delicious_for][]" value="<?php echo $type->name; ?>" <?php echo $selected; ?>/>
																						
												<label for="wpw_auto_posting_dc_prevent_<?php echo $type->name; ?>"><?php echo $label; ?></label>
											</li>
											
											<?php	} ?>
										</ul>
										<p><small><?php _e( 'Check each of the post types you want to automatically post to Delicious when they get published.', 'wpwautoposter' ); ?></small></p>  
									</td>
								</tr> 
										
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[dc_url_shortener]"><?php _e( 'URL Shortener:', 'wpwautoposter' ); ?></label> 
									</th>
									<td>
										<select name="wpw_auto_poster_options[dc_url_shortener]" id="wpw_auto_poster_options[dc_url_shortener]" class="dc_url_shortener" data-content='dc'>
											<?php
												$dc_url_shortener = array( 'wordpress' => __( 'WordPress', 'wpwautoposter' ), 'tinyurl' => __( 'TinyURL', 'wpwautoposter' ), 'bitly' => __( 'bit.ly', 'wpwautoposter' ) );
																
												foreach ( $dc_url_shortener as $key => $option ) {											
													?>
													<option value="<?php echo $model->wpw_auto_poster_escape_attr( $key ); ?>" <?php selected( $wpw_auto_poster_options['dc_url_shortener'], $key ); ?>>
														<?php esc_html_e( $option ); ?>
													</option>
													<?php
												}															
											?> 														
										</select>
										<p><small><?php _e( 'Long URLs will automatically be shortened using the specified URL shortener.', 'wpwautoposter' ); ?></small></p>
									</td>
								</tr>
								
								<?php	        
									if( $wpw_auto_poster_options['dc_url_shortener'] == 'bitly' ) {	        		
										$class = '';	        		
									} else {	        		
										$class = ' style="display:none;"';
									}
								?>
								
								<tr valign="top" class="dc_setting_input_bitly"<?php echo $class; ?>>
									<th scope="row">
										<label for="wpw_auto_poster_options[dc_bitly_username]"><?php _e( 'Bit.ly username', 'wpwautoposter' ); ?> </label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[dc_bitly_username]" id="wpw_auto_poster_options[dc_bitly_username]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['dc_bitly_username'] ); ?>" class="large-text">
									</td>
								</tr>
										
								<tr valign="top" class="dc_setting_input_bitly"<?php echo $class; ?>>
									<th scope="row">
										<label for="wpw_auto_poster_options[dc_bitly_api_key]"><?php _e( 'Bit.ly API key', 'wpwautoposter' ); ?> </label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[dc_bitly_api_key]" id="wpw_auto_poster_options[dc_bitly_api_key]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['dc_bitly_api_key'] ); ?>" class="large-text">
									</td>
								</tr>
									
								<?php
									echo apply_filters ( 
													 'wpweb_fb_settings_submit_button', 
													 '<tr valign="top">
															<td colspan="2">
																<input type="submit" value="' . __( 'Save Changes', 'wpwautoposter' ) . '" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
															</td>
														</tr>'
													);
								?> 													
							</tbody>
						</table>
										
					</div><!-- .inside -->
									
			</div><!-- #delicious_general -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-delicious-general -->
<!-- end of the delicious general settings meta box -->

<!-- beginning of the delicious api settings meta box -->
<div id="wpw-auto-poster-delicious-api" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="delicious_api" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
								
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'Delicious API Settings', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>
							
								<tr valign="top">
									<th scope="row">
										<label><?php _e( 'Delicious Account:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<p><?php _e( 'Before you can start publishing your content to Delicious you need to create a Delicious Account.', 'wpwautoposter' ); ?></p>
										<ol>
											<li><?php _e( 'Create an account for this site on the <a href="https://delicious.com/join" target="_blank">Create Delicious Account</a>', 'wpwautoposter' ); ?></li>
											<li><?php _e( 'After this, get your Delicious username and password and enter them here.', 'wpwautoposter' ); ?></li>
										</ol>
									</td>
								</tr>	
							
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[delicious_username]"><?php _e( 'Your Delicious Username:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[delicious_username]" id="wpw_auto_poster_options[delicious_username]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['delicious_username'] ); ?>" class="large-text">
										<!--<p><small><?php _e( 'Enter your delicious account username.', 'wpwautoposter' ); ?></small></p>-->
									</td>
								</tr>
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[delicious_password]"><?php _e( 'Your Delicious Password:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="password" name="wpw_auto_poster_options[delicious_password]" id="wpw_auto_poster_options[delicious_password]" value="<?php echo $model->wpw_auto_poster_escape_attr( base64_decode( $wpw_auto_poster_options['delicious_password'] ) ); ?>" class="large-text">
										<!--<p><small><?php _e( 'Enter your delicious account password.', 'wpwautoposter' ); ?></small></p>-->
									</td>
								</tr>
								
								<?php
								echo apply_filters ( 
													 'wpweb_fb_settings_submit_button', 
													 '<tr valign="top">
															<td colspan="2">
																<input type="submit" value="' . __( 'Save Changes', 'wpwautoposter' ) . '" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
															</td>
														</tr>'
													);
							?>
								
							</tbody>
						</table>
										
					</div><!-- .inside -->
									
			</div><!-- #delicious_api -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-delicious-api -->
<!-- end of the delicious api settings meta box -->

<!-- beginning of the autopost meta box -->
<div id="wpw-auto-poster-autopost" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="autopost" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
									
				<h3 class="hndle">
					<span style='vertical-align: top;'><?php _e( 'Autopost to Delicious', 'wpwautoposter' ); ?></span>
				</h3>
								
				<div class="inside">
					<table class="form-table">
						<tbody>
						
							<tr valign="top"> 
								<th scope="row">
									<label for="wpw_auto_poster_options[prevent_post_dc_metabox]"><?php _e( 'Do not allow individual posts to Delicious:', 'wpwautoposter' ); ?></label>
								</th>									
								<td>
									<input name="wpw_auto_poster_options[prevent_post_dc_metabox]" id="wpw_auto_poster_options[prevent_post_dc_metabox]" type="checkbox" value="1" <?php if( isset( $wpw_auto_poster_options['prevent_post_dc_metabox'] ) ) { checked( '1', $wpw_auto_poster_options['prevent_post_dc_metabox'] ); } ?> />
									<p><small><?php _e( 'If you check this box, then it will hide meta settings for delicious from individual posts.', 'wpwautoposter' ); ?></small></p>
								</td>	
							</tr>
							
							<?php
								echo apply_filters ( 
													 'wpweb_fb_settings_submit_button', 
													 '<tr valign="top">
															<td colspan="2">
																<input type="submit" value="' . __( 'Save Changes', 'wpwautoposter' ) . '" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
															</td>
														</tr>'
													);
							?>	 
						</tbody>
					</table>
				</div><!-- .inside -->
			</div><!-- #autopost -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-autopost -->
<!-- end of the autopost meta box -->