<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * General Settings
 *
 * The html markup for the general settings box.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
global $wpw_auto_poster_options, $wpw_auto_poster_logs, $wpw_auto_poster_model;

//logs class
$logs 	= $wpw_auto_poster_logs;
$model	= $wpw_auto_poster_model;

$custom_schedule_css	= !empty( $wpw_auto_poster_options['schedule_wallpost_option'] ) && $wpw_auto_poster_options['schedule_wallpost_option'] == 'daily' ? '' : ' wpw-auto-poster-display-none ';
?>

<!-- beginning of the general settings meta box -->
<div id="wpw-auto-poster-general" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="general" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
								
					<!-- general settings box title -->
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'General Settings', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>				
							
								<?php
									
									// do action for add setting before general settings
									do_action( 'wpw_auto_poster_before_general_setting', $wpw_auto_poster_options );
									
								?>								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[delete_options]"><?php _e( 'Delete Options:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input id="wpw_auto_poster_options[delete_options]" name="wpw_auto_poster_options[delete_options]" type="checkbox" value="1" <?php if ( isset( $wpw_auto_poster_options['delete_options'] ) ) { checked( '1', $wpw_auto_poster_options['delete_options'] ); } ?> />
										<p><small><?php _e( 'If you don\'t want to use the Social Auto Poster Plugin on your site anymore, you can check that box. This makes sure, that all the settings and tables are being deleted from the database when you deactivate the plugin.', 'wpwautoposter' ); ?></small></p>
									</td>
								</tr>
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[enable_logs]"><?php _e( 'Enable Debug:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input id="wpw_auto_poster_options[enable_logs]" name="wpw_auto_poster_options[enable_logs]" type="checkbox" value="1" <?php if ( isset( $wpw_auto_poster_options['enable_logs'] ) ) { checked( '1', $wpw_auto_poster_options['enable_logs'] ); } ?> />
										<p><small>
											<?php _e( 'If you have trouble with a social posting, then you can activate this option. If checked, debug output will be written to log file.', 'wpwautoposter' ); 
													echo '<br />';
													_e( 'Logs will be written in', 'wpwautoposter' );
													echo ' <code>'.WPW_AUTO_POSTER_LOG_DIR.$logs->wpw_auto_poster_file_name( 'logs' ).'</code>';
											?>
										</small></p>
									</td>
								</tr>
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[enable_posting_logs]"><?php _e( 'Enable Social Posting Logs:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input id="wpw_auto_poster_options[enable_posting_logs]" name="wpw_auto_poster_options[enable_posting_logs]" type="checkbox" value="1" <?php if ( isset( $wpw_auto_poster_options['enable_posting_logs'] ) ) { checked( '1', $wpw_auto_poster_options['enable_posting_logs'] ); } ?> />
										<p><small>
											<?php _e( 'If you want to log all your social posting activities into the database, then you can activate this option. If checked, social posting data  will be stored in database and you can view it from "Social posting Logs" section.', 'wpwautoposter' ); ?>
										</small></p>
									</td>
								</tr>
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[schedule_wallpost_option]"><?php _e( 'Schedule Wall Posts:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<select name="wpw_auto_poster_options[schedule_wallpost_option]" id="wpw_auto_poster_options[schedule_wallpost_option]" class="wpw-auto-poster-schedule-option">
											<?php   												
												$schedule_wallpost_options = $model->wpw_auto_poster_get_all_schedules();
																
												foreach ( $schedule_wallpost_options as $key => $option ) {											
													?>
													<option value="<?php echo $key; ?>" <?php selected( $wpw_auto_poster_options['schedule_wallpost_option'], $key ); ?>>
														<?php esc_html_e( $option ); ?>
													</option>
													<?php
												}														
											?> 														
										</select>
										<p><small>
											<?php _e( 'Select the schedule wallpost option.', 'wpwautoposter' ); ?>
										</small></p>
									</td>
								</tr>
								
								<tr valign="top" class="wpw-auto-poster-custom-schedule-wrap <?php echo $custom_schedule_css ?>">
									<th scope="row">
										<label for="wpw_auto_poster_options[schedule_wallpost_time]"><?php _e( 'Schedule Time:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<select name="wpw_auto_poster_options[schedule_wallpost_time]" id="wpw_auto_poster_options[schedule_wallpost_time]" class="wpw-auto-poster-hours">
											<?php		
												//Get all schedule time					
												$schedule_time_options = $model->wpw_auto_poster_get_all_schedule_time();
													
												foreach ( $schedule_time_options as $key => $value ) {
													
													?>
													<option value="<?php echo $key; ?>" <?php selected( $wpw_auto_poster_options['schedule_wallpost_time'], $key ); ?>>
														<?php esc_html_e( $value ); ?>
													</option>
													<?php
												}															
											?> 														
										</select>
										<select name="wpw_auto_poster_options[schedule_wallpost_minute]" id="wpw_auto_poster_options[schedule_wallpost_minute]" class="wpw-auto-poster-minutes">
											<?php
												//Get all schedule minutes					
												$schedule_minute_options = $model->wpw_auto_poster_get_all_schedule_minutes();
													
												foreach ( $schedule_minute_options as $key => $value ) {
													
													?>
													<option value="<?php echo $key; ?>" <?php selected( $wpw_auto_poster_options['schedule_wallpost_minute'], $key ); ?>>
														<?php esc_html_e( $value ); ?>
													</option>
													<?php
												}														
											?> 														
										</select>
										<p><small>
											<?php _e( 'Select the schedule time.', 'wpwautoposter' ); ?>
										</small></p>
									</td>
								</tr>
								
								<?php
									
									// do action for add setting after general settings
									do_action( 'wpw_auto_poster_after_general_setting', $wpw_auto_poster_options );
									
								?>
								
								<?php
									echo apply_filters ( 
														 'wpweb_fb_settings_submit_button', 
														 '<tr valign="top">
																<td colspan="2">
																	<input type="submit" value="' . __( 'Save Changes', 'wpwautoposter' ) . '" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
																</td>
															</tr>'
														);
								?>
							</tbody>
						</table>
										
					</div><!-- .inside -->
									
			</div><!-- #general -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-general -->
<!-- end of the general settings meta box -->