<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Tubmlr Settings
 *
 * The html markup for the Tubmlr settings tab.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */

global $wpw_auto_poster_options, $wpw_auto_poster_model, $wpw_auto_poster_tb_posting;

//model class
$model = $wpw_auto_poster_model;

//tumblr posting class
$tbposting = $wpw_auto_poster_tb_posting;

?>

<!-- beginning of the tumblr general settings meta box -->
<div id="wpw-auto-poster-tumblr-general" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="tumblr_general" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
								
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'Tumblr General Settings', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[enable_tumblr]"><?php _e( 'Enable Autoposting to Tubmlr:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input name="wpw_auto_poster_options[enable_tumblr]" id="wpw_auto_poster_options[enable_tumblr]" type="checkbox" value="1" <?php if( isset( $wpw_auto_poster_options['enable_tumblr'] ) ) { checked( '1', $wpw_auto_poster_options['enable_tumblr'] ); } ?> />
										<p><small><?php _e( 'Check this box, if you want to autopost your content to Tubmlr.', 'wpwautoposter' ); ?></small></p>
									</td>
								</tr>	

								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[enable_tumblr_for]"><?php _e( 'Enable Tubmlr Autoposting for:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<ul>
										<?php
										
											$all_types = get_post_types( array( 'public' => true ), 'objects');
											$all_types = is_array( $all_types ) ? $all_types : array();

											if( !empty( $wpw_auto_poster_options['enable_tumblr_for'] ) ) {
												$prevent_meta = $wpw_auto_poster_options['enable_tumblr_for'];
											} else {
												$prevent_meta = '';
											}
															
											$prevent_meta = is_array( $prevent_meta ) ? $prevent_meta : array();
														
											foreach ( $all_types as $type ) {	
															
												if ( !is_object( $type ) ) continue;															
													$label = @$type->labels->name ? $type->labels->name : $type->name;
													if( $label == 'Media' || $label == 'media' ) continue; // skip media
													$selected = ( in_array( $type->name, $prevent_meta ) ) ? 'checked="checked"' : '';
										?>
															
											<li class="wpw-auto-poster-prevent-types">
												<input type="checkbox" id="wpw_auto_posting_tumblr_prevent_<?php echo $type->name; ?>" name="wpw_auto_poster_options[enable_tumblr_for][]" value="<?php echo $type->name; ?>" <?php echo $selected; ?>/>
																						
												<label for="wpw_auto_posting_tumblr_prevent_<?php echo $type->name; ?>"><?php echo $label; ?></label>
											</li>
											
											<?php	} ?>
										</ul>
										<p><small><?php _e( 'Check each of the post types you want to automatically post to Tubmlr when they get published.', 'wpwautoposter' ); ?></small></p>  
									</td>
								</tr>
								
								<?php 
										$tumblrcontent = isset( $wpw_auto_poster_options['tumblr_content_type'] ) && !empty( $wpw_auto_poster_options['tumblr_content_type'] ) 
															? $wpw_auto_poster_options['tumblr_content_type'] : '';
										
								?>
								<tr>
									<th scope="row">
										<label for="wpw_auto_poster_options[tumblr_content_type]"><?php _e( 'Post Content:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="radio" id="tumblr_content_type_full" name="wpw_auto_poster_options[tumblr_content_type]" <?php if( empty( $tumblrcontent ) )  { checked ( '', $tumblrcontent, true ); }//echo ' checked="checked"';  ?> value=""/>
										<label for="tumblr_content_type_full" class="wpw-auto-poster-label"><?php _e( 'Full', 'wpwautoposter' );?></label>
										
										<input type="radio" id="tumblr_content_type_snippets" name="wpw_auto_poster_options[tumblr_content_type]" <?php checked ( '1', $tumblrcontent, true );?> value="1"/>
										<label for="tumblr_content_type_snippets" class="wpw-auto-poster-label"><?php _e( 'Snippets', 'wpwautoposter' );?></label>
										<p><small><?php _e( 'Choose wheter you want to post the full content or just a snippet to your Tumblr page. if you choose snippets, the plugin will post the first 200 characters from your post. You always have the ability to customize that within the meta box.', 'wpwautoposter' ); ?></small></p>
									</td>
								</tr>
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[tb_url_shortener]"><?php _e( 'URL Shortener:', 'wpwautoposter' ); ?></label> 
									</th>
									<td>
										<select name="wpw_auto_poster_options[tb_url_shortener]" id="wpw_auto_poster_options[tb_url_shortener]" class="tb_url_shortener" data-content='tb'>
											<?php
												$tb_url_shortener = array( 'wordpress' => __( 'WordPress', 'wpwautoposter' ), 'tinyurl' => __( 'TinyURL', 'wpwautoposter' ), 'bitly' => __( 'bit.ly', 'wpwautoposter' ) );
																
												foreach ( $tb_url_shortener as $key => $option ) {											
													?>
													<option value="<?php echo $model->wpw_auto_poster_escape_attr( $key ); ?>" <?php selected( $wpw_auto_poster_options['tb_url_shortener'], $key ); ?>>
														<?php esc_html_e( $option ); ?>
													</option>
													<?php
												}
											?>
										</select>
										<p><small><?php _e( 'Long URLs will automatically be shortened using the specified URL shortener.', 'wpwautoposter' ); ?></small></p>
									</td>
								</tr>
								
								<?php	        
									if( $wpw_auto_poster_options['tb_url_shortener'] == 'bitly' ) {	        		
										$class = '';	        		
									} else {	        		
										$class = ' style="display:none;"';
									}
								?>
								
								<tr valign="top" class="tb_setting_input_bitly"<?php echo $class; ?>>
									<th scope="row">
										<label for="wpw_auto_poster_options[tb_bitly_username]"><?php _e( 'Bit.ly username', 'wpwautoposter' ); ?> </label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[tb_bitly_username]" id="wpw_auto_poster_options[tb_bitly_username]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['tb_bitly_username'] ); ?>" class="large-text">
									</td>
								</tr>
										
								<tr valign="top" class="tb_setting_input_bitly"<?php echo $class; ?>>
									<th scope="row">
										<label for="wpw_auto_poster_options[tb_bitly_api_key]"><?php _e( 'Bit.ly API key', 'wpwautoposter' ); ?> </label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[tb_bitly_api_key]" id="wpw_auto_poster_options[tb_bitly_api_key]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['tb_bitly_api_key'] ); ?>" class="large-text">
									</td>
								</tr>
													
								<tr valign="top">
									<td colspan="2">
										<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
									</td>
								</tr> 													
							</tbody>
						</table>
										
					</div><!-- .inside -->
									
			</div><!-- #tumblr_general -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-tumblr-general -->
<!-- end of the tumblr general settings meta box -->

<!-- beginning of the tumblr api settings meta box -->
<div id="wpw-auto-poster-tumblr-api" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="twitter_api" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
								
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'Tumblr API Settings', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>
							
								<tr valign="top">
									<th scope="row">
										<label><?php _e( 'Tumblr Application:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<p><?php _e( 'Before you can start publishing your content to Tumblr you need to create a Tumblr Application.', 'wpwautoposter' ); ?></p>
										<p><?php printf( __('You can get a step by step tutorial on how to create a Tumblr Application on our %sDocumentation%s.', 'wpwautoposter' ), '<a href="http://wpweb.co.in/documents/social-network-integration/tumblr/" target="_blank">', '</a>' ); ?></p> 
									</td>
								</tr>	
							
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[tumblr_consumer_key]"><?php _e( 'Tumblr OAuth Consumer Key:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[tumblr_consumer_key]" id="wpw_auto_poster_options[tumblr_consumer_key]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['tumblr_consumer_key'] ); ?>" class="large-text">
									</td>
								</tr>
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[tumblr_consumer_secret]"><?php _e( 'Tumblr Secret Key:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[tumblr_consumer_secret]" id="wpw_auto_poster_options[tumblr_consumer_secret]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['tumblr_consumer_secret'] ); ?>" class="large-text">
									</td>
								</tr>
								
								<tr valign="top">
									<td colspan="2">
										<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
									</td>
								</tr> 
								
							</tbody>
						</table>
										
					</div><!-- .inside -->
									
			</div><!-- #tumblr_api -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-tumblr-api -->
<!-- end of the tumblr api settings meta box -->

<?php if( isset( $wpw_auto_poster_options['tumblr_consumer_key'] ) && !empty( $wpw_auto_poster_options['tumblr_consumer_key'] ) 
		&& isset( $wpw_auto_poster_options['tumblr_consumer_secret'] ) && !empty( $wpw_auto_poster_options['tumblr_consumer_secret'] )  ) { ?>

<!-- beginning of the grant extended permission meta box -->
<div id="wpw-auto-poster-tumblr-grant-permission" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="grant_permission" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
									
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'Grant Extended Permissions', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
					<table class="form-table">											
						<tbody>				
							<tr valign="top">
								<th scope="row">
									<label><?php _e( 'Allowing permissions:', 'wpwautoposter' ); ?></label>
								</th>
								<td>
									<p><?php _e( 'Posting content to your chosen Tumblr personal account requires you to grant extended permissions. If you want to use this feature you should grant the extended permissions now.', 'wpwautoposter' ); ?></p>
									<?php										
										$returnurl = admin_url().'edit.php?post_type=wpw_auto_poster&page=wpw-auto-poster-settings';
										
										if( isset( $_SESSION['wpw_auto_poster_tb_user_id'] ) && !empty( $_SESSION['wpw_auto_poster_tb_user_id'] ) )  {
											
											echo '<p>' . __( 'You already granted extended permissions', 'wpwautoposter' ) . '</p>';	
									?>
									
											<a href="<?php echo $returnurl.'&tb_reset_user=1'; ?>"><?php _e( 'Reset User Session', 'wpwautoposter' ); ?></a>
											
									
									<?php
										} else {
										
											echo '<p><a href="' . $tbposting->wpw_auto_poster_get_tb_login_url() . '">' . __( 'Grant extended permissions', 'wpwautoposter' ) . '</a></p>';
										}
									?>
								</td>
							</tr> 
																				
							<tr valign="top">
								<td colspan="2">
									<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
								</td>
							</tr>  													
						</tbody>
					</table>
				</div><!-- .inside -->
			</div><!-- #grant_permissions -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-tumblr-grant-permission -->
<!-- end of the grant extended permissions meta box -->

<?php } ?>

<!-- beginning of the autopost meta box -->
<div id="wpw-auto-poster-autopost" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="autopost" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
									
				<h3 class="hndle">
					<span style='vertical-align: top;'><?php _e( 'Autopost to Tumblr', 'wpwautoposter' ); ?></span>
				</h3>
								
				<div class="inside">
					<table class="form-table">
						<tbody>
						
							<tr valign="top"> 
								<th scope="row">
									<label for="wpw_auto_poster_options[prevent_post_tb_metabox]"><?php _e( 'Do not allow individual posts to Tumblr:', 'wpwautoposter' ); ?></label>
								</th>									
								<td>
									<input name="wpw_auto_poster_options[prevent_post_tb_metabox]" id="wpw_auto_poster_options[prevent_post_tb_metabox]" type="checkbox" value="1" <?php if( isset( $wpw_auto_poster_options['prevent_post_tb_metabox'] ) ) { checked( '1', $wpw_auto_poster_options['prevent_post_tb_metabox'] ); } ?> />
									<p><small><?php _e( 'If you check this box, then it will hide meta settings for tumblr from individual posts.', 'wpwautoposter' ); ?></small></p>
								</td>	
							</tr>
							
							<?php
								echo apply_filters ( 
													 'wpweb_fb_settings_submit_button', 
													 '<tr valign="top">
															<td colspan="2">
																<input type="submit" value="' . __( 'Save Changes', 'wpwautoposter' ) . '" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
															</td>
														</tr>'
													);
							?>	 
						</tbody>
					</table>
				</div><!-- .inside -->
			</div><!-- #autopost -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-autopost -->
<!-- end of the autopost meta box -->