<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Plugin Loaded
 * 
 * Add metabox fields in plugin loaded action.
 * 
 * @package Social Auto Poster
 * @since 1.6.2
 */
function wpw_auto_poster_add_meta_boxes() { 

	//include the main class file for metabox

	//require_once( WPW_AUTO_POSTER_META_DIR . '/meta-box-class.php' );

	//include extended metabox class to user in poster plugin

	require_once( WPW_AUTO_POSTER_META_DIR . '/class-wpw-auto-poster-meta.php' );
	

	global $wpw_auto_poster_model, $wpw_auto_poster_options,
			$wpw_auto_poster_fb_posting, $wpw_auto_poster_tw_posting, $wpw_auto_poster_li_posting,$wpw_auto_poster_tb_posting,
			$wpw_auto_poster_dc_posting,$wpw_auto_poster_ba_posting;
	
	//model class
	$model = $wpw_auto_poster_model;
	
	//posting class
	$fbposting = $wpw_auto_poster_fb_posting;
	$twposting = $wpw_auto_poster_tw_posting;
	$liposting = $wpw_auto_poster_li_posting;
	$tbposting = $wpw_auto_poster_tb_posting;
	$dcposting = $wpw_auto_poster_dc_posting;
	$baposting = $wpw_auto_poster_ba_posting;
	
	/* 
	 * prefix of meta keys, optional
	 * use underscore (_) at the beginning to make keys hidden, for example $prefix = '_ba_';
	 *  you also can make prefix empty to disable it
	 */
	$prefix = WPW_AUTO_POSTER_META_PREFIX;
	
	/* 
	 * configure your meta box
	 */
	$config1 = array(

		'id'			=> 'wpw_auto_poster_meta',					// meta box id, unique per meta box
		'title'			=> __( 'Social Auto Poster Settings', 'wpwautoposter'),		// meta box title
		'pages'			=> 'all',					//insert meta in custom post type
		'context'		=> 'normal',							// where the meta box appear: normal (default), advanced, side; optional
		'priority'		=> 'high',							// order of meta box: high (default), low; optional
		'fields'		=> array(),							// list of meta fields (can be added by field arrays)
		'local_images'	=> false,						// Use local or hosted images (meta box images for add/remove)
	);
	
	$poster_meta =  new Wpw_Auto_Poster_Social_Meta_Box( $config1 );
	
	/************************************* Facebook Tab Starts ******************************************************/
	$defaulttabon = true; //Active first tab by default
	
	if( !isset( $wpw_auto_poster_options['prevent_post_metabox'] ) || empty( $wpw_auto_poster_options['prevent_post_metabox'] )) { //check if not allowed for individual post in settings page
		$fbmetatab = array(
							'class'		=>	'facebook',				//unique class name of each tabs
							'title' 	=>	__('Facebook','wpwautoposter'), //  title of tab
							'active' 	=>	$defaulttabon	//it will by default make tab active on page load
					  );
		
		$defaulttabon = false; //when facebook is on then inactive other tab by default
		
		//initiate tabs in metabox
		$poster_meta->addTabs($fbmetatab);
		
		//get all facebook account authenticated
		$fb_users = $fb_accounts = array();
		
		//$fb_users['']	= __( 'Default', 'wpwautoposter' ); //default value
		
		if( isset( $_SESSION['wpweb_fb_user_accounts'] ) && !empty( $_SESSION['wpweb_fb_user_accounts'] ) ) {
			
			$fb_accounts = $_SESSION['wpweb_fb_user_accounts'];
			$fb_accounts = isset( $fb_accounts['auth_accounts'] ) ? $fb_accounts['auth_accounts'] : array();
		}
		
		foreach ($fb_accounts as $key => $value) {
			
			$fb_users[$key] = $value;
		}
		
		//check facebook application id and secret must entered in settings page or not
		if( WPW_AUTO_POSTER_FB_APP_ID == '' || WPW_AUTO_POSTER_FB_APP_SECRET == '' ) { 
			
			$poster_meta->addGrantPermission( $prefix . 'fb_warning', array( 'desc' => __( 'Enter your Facebook APP ID / Secret within the Settings Page, otherwise the Facebook posting won\'t work.', 'wpwautoposter'), 'url' => add_query_arg( array( 'page'=> 'wpw-auto-poster-settings' ), admin_url( 'admin.php' ) ), 'urltext' => __( 'Go to the Settings Page', 'wpwautoposter' ),'tab' => 'facebook' ) );

		} else {
			
			//check facebook user id is set or not
			if( !isset( $_SESSION['wpweb_fb_user_id'] ) || empty( $_SESSION['wpweb_fb_user_id'] ) )  {
				
				$poster_meta->addGrantPermission( $prefix . 'fb_grant', array( 'desc' => __( 'Your App doesn\'t have enough permissions to publish on Facebook.', 'wpwautoposter'), 'url' => $fbposting->wpw_auto_poster_get_fb_login_url(), 'urltext' => __( 'Grant extended permissions now.', 'wpwautoposter' ),'tab' => 'facebook' ) );
			}
		}
		
		//add label to show status
		$poster_meta->addTweetStatus( $prefix . 'fb_published_on_fb',  array( 'name'=> __( 'Status:', 'wpwautoposter' ), 'desc' => __( 'Status of Facebook wall post like published/unpublished.', 'wpwautoposter' ),'tab' => 'facebook' ) );
		
		//post to facebook
		$poster_meta->addPublishBox( $prefix . 'post_to_facebook', array( 'name'=> __( 'Publish Post On Facebook:', 'wpwautoposter' ), 'desc' => __( 'Publish this Post to Facebook Userwall.', 'wpwautoposter' ) ,'tab' => 'facebook' ) );
		
		//publish with diffrent post title
		$poster_meta->addText( $prefix . 'fb_custom_title', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Title:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom title which will be used for the wall post. Leave it empty to use the post title.', 'wpwautoposter' ), 'tab' => 'facebook' ));
		
		//post to this account
		$poster_meta->addSelect( $prefix . 'fb_user_id', $fb_users, array( 'name'	=> __( 'Post To This Facebook Account', 'wpwautoposter' ).'('. __( 's', 'wpwautoposter' ).'):', 'std'=> array( '' ), 'desc' => __( 'Select an account to which you want to post. Leave it empty to use the default one from the settings page.', 'wpwautoposter' ),  'multiple' => true, 'placeholder' => __( 'Default', 'wpwautoposter' ), 'tab' => 'facebook' ) );
		
		$wall_post_methods = array(
										'' 	=> __( 'Default', 'wpwautoposter' )
									);
		$wall_post_methods = array_merge( $wall_post_methods, $model->wpw_auto_poster_get_fb_posting_method() );

		//post on wall as a type
		$poster_meta->addSelect( $prefix . 'fb_posting_method', $wall_post_methods ,array( 'name'	=> __( 'Post As:', 'wpwautoposter' ), 'std'=> array( '' ), 'desc' => __( 'Select a Facebook post type. Leave it empty to use the default one from the settings page.', 'wpwautoposter' ),'tab' => 'facebook') );
		
		//post image url
		$poster_meta->addImage( $prefix . 'fb_post_image', array( 'name'=> __( 'Post Image:', 'wpwautoposter' ), 'desc' => __( 'Here you can upload a default image which will be used for the Facebook wall post. Leave it empty to use the featured image. if featured image is also blank, then it will take default image from the settings page.', 'wpwautoposter' ), 'tab' => 'facebook' ) );
		
		//publish with diffrent post title
		$poster_meta->addText( $prefix . 'fb_custom_status_msg', array( 'default' => __( 'New blog post :', 'wpwautoposter' ).' {title} - {link}', 'validate_func' => 'escape_html', 'name'=> __( 'Facebook Status Update Text:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom  status update text. Leave it empty to  use the default one from the settings page. You can use following template tags within the status text:', 'wpwautoposter').
											 '<br /><code>{last_name}</code> - '.__('displays the last name,', 'wpwautoposter').
											 '<br /><code>{title}</code> - '.__('displays the post title,', 'wpwautoposter').
											 '<br /><code>{link}</code> - '.__('displays the post title with link,', 'wpwautoposter').
											 '<br /><code>{site_name}</code> - '.__('displays the name of your site.', 'wpwautoposter' ), 'tab' => 'facebook' ));
											 
		//custom link to post to facebook
		$poster_meta->addText( $prefix . 'fb_custom_post_link', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Link:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom link which will be used for  the wall post. Leave it empty to use the link of the current post. The link must start with', 'wpwautoposter' ).' http://', 'tab' => 'facebook' ));
		
		//custom caption to post on facebook
		$poster_meta->addText( $prefix . 'fb_custom_caption', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Caption:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom caption of the link (appears beneath the link name). If you leave it empty, Facebook will use the  post URL as caption.', 'wpwautoposter' ), 'tab' => 'facebook' ) );
		
		//publish status descriptin to facebook
		$poster_meta->addTextarea( $prefix . 'fb_custom_post_desc', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Description:', 'wpwautoposter' ), 'desc' => __( 'Here you can customize the content which will be used by Facebook for the link description on the wall post. Leave it empty to use description of the current post.', 'wpwautoposter' ), 'tab' => 'facebook' ) );	
		
	}
	/************************************* Facebook Tab Ends ******************************************************/
	
	/************************************* Twitter Tab Starts ******************************************************/
	if( !isset( $wpw_auto_poster_options['prevent_post_tw_metabox'] ) || empty( $wpw_auto_poster_options['prevent_post_tw_metabox'] )) { //check if not allowed for individual post in settings page
		
		$opttemplate = isset( $wpw_auto_poster_options['tw_tweet_template'] ) ? $wpw_auto_poster_options['tw_tweet_template'] : 'title_link';
		
		//tweet default tempalte 
		$defaulttemplate = $model->wpw_auto_poster_get_tweet_template($opttemplate);
		
		$twmetatab = array(
								'class'		=>	'twitter',				//unique class name of each tabs
								'title' 	=>	__('Twitter','wpwautoposter'), //  title of tab
								'active' 	=>	$defaulttabon	//it will by default make tab active on page load
						  );

		$defaulttabon = false; //when twitter is on then inactive other tab by default
		
		//initiate tabs in metabox
		$poster_meta->addTabs($twmetatab);
		
		if( WPW_AUTO_POSTER_TW_CONS_KEY == '' || WPW_AUTO_POSTER_TW_CONS_SECRET == '' || WPW_AUTO_POSTER_TW_AUTH_TOKEN == '' || WPW_AUTO_POSTER_TW_AUTH_SECRET == '' ) { 
			
			$poster_meta->addGrantPermission( $prefix . 'tw_warning', array( 'desc' => __( 'Enter your Twitter Application Details within the Settings Page, otherwise posting to Twitter won\'t work.', 'wpwautoposter'), 'url' => add_query_arg( array( 'page'=> 'wpw-auto-poster-settings' ), admin_url( 'admin.php' ) ), 'urltext' => __( 'Go to the Settings Page', 'wpwautoposter' ),'tab' => 'twitter' ) );
		}
		
		//Get twitter account details
		$tw_users = get_option( 'wpw_auto_poster_tw_account_details', array() );
		
		//add label to show status
		$poster_meta->addTweetStatus( $prefix . 'tw_status',  array( 'name'=> __( 'Status:', 'wpwautoposter' ), 'desc' => __( 'Status of Twitter wall post like published/unpublished.', 'wpwautoposter' ),'tab' => 'twitter' ) );
		
		//post to twitter
		$poster_meta->addPublishBox( $prefix . 'post_to_twitter', array( 'name'=> __( 'Publish Post On Twitter:', 'wpwautoposter' ), 'desc' => __( 'Publish this Post to Twitter.', 'wpwautoposter' ) , 'tab' => 'twitter' ) );
		
		//post to this account 
		$poster_meta->addSelect( $prefix . 'tw_user_id', $tw_users, array( 'name'	=> __( 'Post To This Twitter Account', 'wpwautoposter' ).'('. __( 's', 'wpwautoposter' ).'):', 'std'=> array( '' ), 'desc' => __( 'Select an account to which you want to post. Leave it empty to use the default one from the settings page.', 'wpwautoposter' ),  'multiple' => true, 'placeholder' => __( 'Default', 'wpwautoposter' ), 'tab' => 'twitter' ) );
		
		//tweet mode
		$poster_meta->addTweetMode( $prefix . 'tw_tweet_mode', array( 'name'=> __( 'Mode:', 'wpwautoposter' ), 'desc' => __( 'Tweet Template Mode.', 'wpwautoposter' ),'tab' => 'twitter' ) );
		
		//tweet template, do not change the order for tweet template and tweet preview field
		$poster_meta->addTweetTemplate( $prefix . 'tw_template', array( 'default' => $defaulttemplate, 'validate_func' => 'escape_html', 'name'=> __( 'Tweet Template:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom Tweeter template. Leave it empty to use the default one from the settings page. You can use following template tags within the status text:', 'wpwautoposter' ).
												 '<br /><code>{title}</code> - '.__('displays the post title,', 'wpwautoposter' ).
												 '<br /><code>{link}</code> - '.__('displays the post link,', 'wpwautoposter' ).
												 '<br /><code>{full_author}</code> - '.__('displays the full author name,', 'wpwautoposter' ).
												 '<br /><code>{nickname_author}</code> - '.__('displays the nickname of author,', 'wpwautoposter' ).
												 '<br /><code>{post_type}</code> - '.__('displays the post type.', 'wpwautoposter' ),'tab' => 'twitter' ) );
		
		//add label to show preview, do not change the order for tweet template and tweet preview field
		$poster_meta->addTweetPreview( $prefix . 'tw_template',  array( 'default' => $defaulttemplate, 'validate_func' => 'escape_html', 'name'=> __( 'Preview:', 'wpwautoposter' ), 'tab' => 'twitter' ) );
	}
	/************************************* Twitter Tab Ends ******************************************************/
	
	/************************************* LinkedIn Tab Starts ******************************************************/
	if( !isset( $wpw_auto_poster_options['prevent_post_li_metabox'] ) || empty( $wpw_auto_poster_options['prevent_post_li_metabox'] )) { //check if not allowed for individual post in settings page

		$limetatab = array(
								'class'		=>	'linkedin',				//unique class name of each tabs
								'title' 	=>	__('LinkedIn','wpwautoposter'), //  title of tab
								'active' 	=>	$defaulttabon	//it will by default make tab active on page load
						  );
		
		$defaulttabon = false; //when linkedin is on then inactive other tab by default
		
		//initiate tabs in metabox
		$poster_meta->addTabs($limetatab);
		
		if( WPW_AUTO_POSTER_LI_APP_ID == '' || WPW_AUTO_POSTER_LI_APP_SECRET == '' ) { 
			
			$poster_meta->addGrantPermission( $prefix . 'li_warning', array( 'desc' => __( 'Enter your LinkedIn Application Details within the Settings Page, otherwise posting to LinkedIn won\'t work.', 'wpwautoposter'), 'url' => add_query_arg( array( 'page'=> 'wpw-auto-poster-settings' ), admin_url( 'admin.php' ) ), 'urltext' => __( 'Go to the Settings Page', 'wpwautoposter' ),'tab' => 'linkedin' ) );
		} else {
			
			if( !isset( $_SESSION['wpw_auto_poster_li_user_id'] ) || empty( $_SESSION['wpw_auto_poster_li_user_id'] ) )  {
				
				$poster_meta->addGrantPermission( $prefix . 'li_grant', array( 'desc' => __( 'Your App doesn\'t have enough permissions to publish on Linkedin.', 'wpwautoposter'), 'url' => add_query_arg( array( 'page'=> 'wpw-auto-poster-settings' ), admin_url( 'admin.php' ) ), 'urltext' => __( 'Grant extended permissions now', 'wpwautoposter' ),'tab' => 'linkedin' ) );
			}
		}
		
		//add label to show status
		$poster_meta->addTweetStatus( $prefix . 'li_status',  array( 'name'=> __( 'Status:', 'wpwautoposter' ), 'desc' => __( 'Status of LinkedIn wall post like published/unpublished.', 'wpwautoposter' ),'tab' => 'linkedin' ) );
		
		//post to linkedin
		$poster_meta->addPublishBox( $prefix . 'post_to_linkedin', array( 'name'=> __( 'Publish Post On LinkedIn:', 'wpwautoposter' ), 'desc' => __( 'Publish this post to your LinkedIn.', 'wpwautoposter' ) ,'tab' => 'linkedin' ) );
		
		//publish status to linkedin
		$poster_meta->addText( $prefix . 'li_post_title', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Title:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom title which will be used for the wall post. Leave it empty to use the post title.', 'wpwautoposter' ), 'tab' => 'linkedin' ));
		
		$li_profiles	= $liposting->wpw_auto_poster_get_profiles_data();
		
		//post to this account
		$poster_meta->addSelect( $prefix . 'li_post_profile', $li_profiles, array( 'name'	=> __( 'Post To This Linkedin Account', 'wpwautoposter' ).'('. __( 's', 'wpwautoposter' ).'):', 'std'=> array( '' ), 'desc' => __( 'Select an account to which you want to post. Leave it empty to use the default one from the settings page.', 'wpwautoposter' ),  'multiple' => true, 'placeholder' => __( 'Default', 'wpwautoposter' ), 'tab' => 'linkedin' ) );
		
		//publish status to linkedin image
		$poster_meta->addImage( $prefix . 'li_post_image', array( 'name'=> __( 'Post Image:', 'wpwautoposter' ), 'desc' => __( 'Here you can upload a default image which will be used for the LinkedIn wall post. Leave it empty to use the featured image. if featured image is also blank, then it will take default image from the settings page.', 'wpwautoposter' ), 'tab' => 'linkedin' ) );
		
		//custom link to post to facebook
		$poster_meta->addText( $prefix . 'li_post_link', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Link:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom link which will be used for the wall post. Leave it empty to use the link of the current post. The link must start with', 'wpwautoposter' ).' http://', 'tab' => 'linkedin' ));
		
		//comment to linkedin
		$poster_meta->addText( $prefix . 'li_post_comment', array( 'validate_func' => 'escape_html', 'name'=> __( 'Comments:', 'wpwautoposter' ), 'desc' => __( 'Here you can customize the content which will be used by LinkedIn for the wall post. Leave it empty to  use the default one from the settings page. You can use following template tags within the status text:', 'wpwautoposter' ).
												 '<br /><code>{first_name}</code> - '.__('displays the first name,', 'wpwautoposter' ).
												 '<br /><code>{last_name}</code> - '.__('displays the last name,', 'wpwautoposter' ).
												 '<br /><code>{title}</code> - '.__('displays the post title,', 'wpwautoposter' ).
												 '<br /><code>{link}</code> - '.__('displays the post link,', 'wpwautoposter' ).
												 '<br /><code>{site_name}</code> - '.__('displays the name of your site.', 'wpwautoposter' ), 'tab' => 'linkedin' ));
												 
		//publish status descriptin to linkedin
		$poster_meta->addTextarea( $prefix . 'li_post_desc', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Description:', 'wpwautoposter' ), 'desc' => __( 'Here you can customize the content which will be used by LinkedIn for the link description on the wall post. Leave it empty to use description of the current post.', 'wpwautoposter' ), 'tab' => 'linkedin' ) );
	}
	/************************************* LinkedIn Tab Ends   ******************************************************/
	
	/************************************* Tumblr Tab Starts ******************************************************/
	if( !isset( $wpw_auto_poster_options['prevent_post_tb_metabox'] ) || empty( $wpw_auto_poster_options['prevent_post_tb_metabox'] )) { //check if not allowed for individual post in settings page
		
		$tbmetatab = array(
								'class'		=>	'tumblr',				//unique class name of each tabs
								'title' 	=>	__('Tumblr','wpwautoposter'), //  title of tab
								'active' 	=>	$defaulttabon	//it will by default make tab active on page load
						  );
		
		$defaulttabon = false; //when tumblr is on then inactive other tab by default
		
		//initiate tabs in metabox
		$poster_meta->addTabs($tbmetatab);
		
		if( WPW_AUTO_POSTER_TB_CONS_KEY == '' || WPW_AUTO_POSTER_TB_CONS_SECRET == '' ) { 
			
			$poster_meta->addGrantPermission( $prefix . 'tb_warning', array( 'desc' => __( 'Enter your Tumblr Application Details within the Settings page, otherwise the posting to Tubmlr won\'t work.', 'wpwautoposter'), 'url' => add_query_arg( array( 'page'=> 'wpw-auto-poster-settings' ), admin_url( 'admin.php' ) ), 'urltext' => __( 'Go to the Settings Page', 'wpwautoposter' ),'tab' => 'tumblr' ) );
		} else {
			
			if( !isset( $_SESSION['wpw_auto_poster_tb_user_id'] ) || empty( $_SESSION['wpw_auto_poster_tb_user_id'] ) )  {
				$poster_meta->addGrantPermission( $prefix . 'tb_grant', array( 'desc' => __( 'Your App doesn\'t have enough permissions to publish on Tumblr.', 'wpwautoposter'), 'url' => $tbposting->wpw_auto_poster_get_tb_login_url(), 'urltext' => __( 'Grant extended permissions now.', 'wpwautoposter' ),'tab' => 'tumblr' ) );
			}
		}
		
		//add label to show status
		$poster_meta->addTweetStatus( $prefix . 'tb_status',  array( 'name'=> __( 'Status:', 'wpwautoposter' ), 'desc' => __( 'Status of Tumblr wall post like published/unpublished.', 'wpwautoposter' ),'tab' => 'tumblr' ) );
		
		//post to tumblr
		$poster_meta->addPublishBox( $prefix . 'post_to_tumblr', array( 'name'=> __( 'Publish Post On Tumblr:', 'wpwautoposter' ), 'desc' => __( 'Publish this Post to Tumblr Userwall.', 'wpwautoposter' ) ,'tab' => 'tumblr' ) );
		
		//publish status to tumblr
		$poster_meta->addText( $prefix . 'tb_post_title', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Title:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom title which will be used on the wall post. Leave it empty to use the post title.', 'wpwautoposter' ), 'tab' => 'tumblr' ));
		
		//post link
		$poster_meta->addText( $prefix . 'tb_custom_post_link', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Link:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom link which will be used on the wall post. Leave it empty to use the link to the post. The link must start with http://', 'wpwautoposter' ), 'tab' => 'tumblr' ));
		
		//publish status descriptin to tumblr
		$poster_meta->addTextarea( $prefix . 'tb_post_desc', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Description:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter custom content which will appear underneath the post title in Tumblr. Leave it empty to use the post content. You can use the following shortcodes within the description:', 'wpwautoposter' ).
																	'<br /><code>{first_name}</code> - '.__( 'display the first name,', 'wpwautoposter' ).
																	'<br /><code>{last_name}</code> - '.__( 'display the last name,', 'wpwautoposter' ).
																	'<br /><code>{title}</code> - '.__( 'display the post title,', 'wpwautoposter' ).
																	'<br /><code>{sitename}</code> - '.__( 'display the sitename/blogname.', 'wpwautoposter' ), 'tab' => 'tumblr' ) );
	}
	/************************************* Tumblr Tab Ends ******************************************************/
	
	/************************************* Delicious Tab Starts ******************************************************/
	if( !isset( $wpw_auto_poster_options['prevent_post_dc_metabox'] ) || empty( $wpw_auto_poster_options['prevent_post_dc_metabox'] )) { //check if not allowed for individual post in settings page
		
		$dcmetatab = array(
								'class'		=>	'delicious',				//unique class name of each tabs
								'title' 	=>	__('Delicious','wpwautoposter'), //  title of tab
								'active' 	=>	$defaulttabon	//it will by default make tab active on page load
						  );
		
		$defaulttabon = false; //when delicious is on then inactive other tab by default
		
		//initiate tabs in metabox
		$poster_meta->addTabs($dcmetatab);
		
		if( WPW_AUTO_POSTER_DC_USERNAME == '' || WPW_AUTO_POSTER_DC_PASSWORD == '' ) { 
			
			$poster_meta->addGrantPermission( $prefix . 'dc_warning', array( 'desc' => __( 'Enter your Delicious User Details within the Settings page, otherwise the posting to Delicious won\'t work.', 'wpwautoposter'), 'url' => add_query_arg( array( 'page'=> 'wpw-auto-poster-settings' ), admin_url( 'admin.php' ) ), 'urltext' => __( 'Go to the Settings Page', 'wpwautoposter' ),'tab' => 'delicious' ) );
		}
		
		//add label to show status
		$poster_meta->addTweetStatus( $prefix . 'dc_status',  array( 'name'=> __( 'Status:', 'wpwautoposter' ), 'desc' => __( 'Status of Delicious wall post like published/unpublished.', 'wpwautoposter' ),'tab' => 'delicious' ) );
		
		//post to Delicious
		$poster_meta->addPublishBox( $prefix . 'post_to_delicious', array( 'name'=> __( 'Publish Post On Delicious:', 'wpwautoposter' ), 'desc' => __( 'Publish this Post to Delicious Userwall.', 'wpwautoposter' ) ,'tab' => 'delicious' ) );
		
		//publish status to Delicious
		$poster_meta->addText( $prefix . 'dc_post_title', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Title:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom title which will be used on the wall post. Leave it empty to use the post title.', 'wpwautoposter' ), 'tab' => 'delicious' ));
		
		//post link
		$poster_meta->addText( $prefix . 'dc_custom_post_link', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Link:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom link which will be used on the wall post. Leave it empty to use the link to the post. The link must start with http://', 'wpwautoposter' ), 'tab' => 'delicious' ));
		
		//publish status descriptin to Delicious
		$poster_meta->addTextarea( $prefix . 'dc_post_desc', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Description:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter custom content which will appear underneath the post title in Delicious. Leave it empty to use the post content. You can use the following shortcodes within the description. :', 'wpwautoposter' ).
																	'<br /><code>{first_name}</code> - '.__( 'display the first name,', 'wpwautoposter' ).
																	'<br /><code>{last_name}</code> - '.__( 'display the last name,', 'wpwautoposter' ).
																	'<br /><code>{title}</code> - '.__( 'display the post title,', 'wpwautoposter' ).
																	'<br /><code>{sitename}</code> - '.__( 'display the sitename/blogname.', 'wpwautoposter' ), 'tab' => 'delicious' ) );
	}
	/************************************* Delicious Tab Ends ******************************************************/
	
	/************************************* BufferApp Tab Starts ******************************************************/
	if( !isset( $wpw_auto_poster_options['prevent_post_ba_metabox'] ) || empty( $wpw_auto_poster_options['prevent_post_ba_metabox'] )) { //check if not allowed for individual post in settings page
		
		$dcmetatab = array(
								'class'		=>	'bufferapp',				//unique class name of each tabs
								'title' 	=>	__('BufferApp','wpwautoposter'), //  title of tab
								'active' 	=>	$defaulttabon	//it will by default make tab active on page load
						  );
		
		$defaulttabon = false; //when bufferapp is on then inactive other tab by default
		
		//initiate tabs in metabox
		$poster_meta->addTabs($dcmetatab);
		
		//get all bufferapp account authenticated
		$ba_users = array();
		
		$ba_users['']	= __( '--Select--','wpwautoposter' );
		
		if( isset( $_SESSION['wpw_auto_poster_ba_cache'] ) && !empty( $_SESSION['wpw_auto_poster_ba_cache'] ) ) {
			
			foreach ($_SESSION['wpw_auto_poster_ba_cache'] as $key => $account) {
				
				$ba_users[$account->id] = $account->formatted_username;
			}
		}
		
		if( WPW_AUTO_POSTER_BA_CLIENT_ID == '' || WPW_AUTO_POSTER_BA_CLIENT_SECRET == '' ) { 
			
			$poster_meta->addGrantPermission( $prefix . 'ba_warning', array( 'desc' => __( 'Enter your BufferApp Application Details within the Settings Page, otherwise posting to BufferApp won\'t work.', 'wpwautoposter'), 'url' => admin_url( 'edit.php?post_type=wpw_auto_poster&page=wpw-auto-poster-settings' ), 'urltext' => __( 'Go to the Settings Page', 'wpwautoposter' ),'tab' => 'bufferapp' ) );
		} else {
			if( !isset( $_SESSION['wpw_auto_poster_ba_user_id'] ) || empty( $_SESSION['wpw_auto_poster_ba_user_id'] ) ) {
				$poster_meta->addGrantPermission( $prefix . 'tb_grant', array( 'desc' => __( 'Your App doesn\'t have enough permissions to publish on BufferApp.', 'wpwautoposter'), 'url' => admin_url( 'edit.php?post_type=wpw_auto_poster&page=wpw-auto-poster-settings' ), 'urltext' => __( 'Go to Settings Page', 'wpwautoposter' ),'tab' => 'bufferapp' ) );
			}
		}
		
		//add label to show status
		$poster_meta->addTweetStatus( $prefix . 'ba_status',  array( 'name'=> __( 'Status:', 'wpwautoposter' ), 'desc' => __( 'Status of BufferApp wall post like published/unpublished.', 'wpwautoposter' ),'tab' => 'bufferapp' ) );
		
		//post to bufferapp
		$poster_meta->addPublishBox( $prefix . 'post_to_bufferapp', array( 'name'=> __( 'Publish Post On BufferApp:', 'wpwautoposter' ), 'desc' => __( 'Publish this post to your BufferApp Userwall.', 'wpwautoposter' ) ,'tab' => 'bufferapp' ) );
		
		//publish status to bufferapp
		$poster_meta->addText( $prefix . 'ba_post_title', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Title:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom title which will be used for the wall post. Leave it empty to use the post title.', 'wpwautoposter' ), 'tab' => 'bufferapp' ));
		
		//post to this account
		$poster_meta->addSelect( $prefix . 'ba_post_to_accounts', $ba_users, array( 'name'	=> __( 'Publish To This BufferApp Account:', 'wpwautoposter' ), 'std'=> array( '' ), 'desc' => __( 'Select an account to which you want to post. Leave it empty to use the default one from the settings page.', 'wpwautoposter' ), 'multiple' => true, 'placeholder' => __( 'Default', 'wpwautoposter' ), 'tab' => 'bufferapp') );
		
		//publish status to bufferapp image
		$poster_meta->addImage( $prefix . 'ba_post_image', array( 'name'=> __( 'Post Image:', 'wpwautoposter' ), 'desc' => __( 'Here you can upload a default image which will be used for the BufferApp wall post. Leave it empty to use the featured image. if featured image is also blank, then it will take default image from the settings page.', 'wpwautoposter' ), 'tab' => 'bufferapp' ) );
		
		//custom link to post to facebook
		$poster_meta->addText( $prefix . 'ba_custom_post_link', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Link:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom link which will be used for the wall post. Leave it empty to use the link of the current post. The link must start with', 'wpwautoposter' ).' http://<br /><strong>'.__( 'Note' , 'wpwautoposter' ).' : </strong>' .__( 'Link is only used for posting on facebook profile(s).', 'wpwautoposter' ), 'tab' => 'bufferapp' ));
		
		//comment to bufferapp
		$poster_meta->addTextarea( $prefix . 'ba_post_desc', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Description:', 'wpwautoposter' ), 'desc' => __( 'Here you can customize the content which will be used for BufferApp wall post. Leave it empty to use the post content. You can use following template tags within the status text:', 'wpwautoposter' ).
												 '<br /><code>{first_name}</code> - '.__('displays the first name,', 'wpwautoposter' ).
												 '<br /><code>{last_name}</code> - '.__('displays the last name,', 'wpwautoposter' ).
												 '<br /><code>{title}</code> - '.__('displays the post title,', 'wpwautoposter' ).
												 '<br /><code>{link}</code> - '.__('displays the post link,', 'wpwautoposter' ).
												 '<br /><code>{sitename}</code> - '.__('display the sitename/blogname.', 'wpwautoposter' ).
												 '<br /><strong>'.__( 'Note' , 'wpwautoposter' ).' : </strong>'. __( 'Description is only used for posting on facebook profile(s).', 'wpwautoposter' ), 'tab' => 'bufferapp' ));
	}
	/************************************* BufferApp Tab Ends ******************************************************/
	
	if( $defaulttabon ) { // Check no active tab
		
		//meta settings are not available
		$poster_meta->addParagraph( $prefix . 'no_meta_settings', array( 'value' => __( 'There is no meta settings allowed to be set for individual posts from global setting.', 'wpwautoposter' ) ) );
	}
	
	/*
	 * Don't Forget to Close up the meta box decleration
	 */
	//Finish Meta Box Decleration
	
	$poster_meta->Finish();
}

// add action to add custom meta box in custom post
add_action( 'load-post.php', 'wpw_auto_poster_add_meta_boxes' );
add_action( 'load-post-new.php', 'wpw_auto_poster_add_meta_boxes' );