<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Delicious Posting Class
 *
 * Handles all the functions to tweet on twitter
 *
 * @package Social Auto Poster
 * @since 1.3.0
 */
class Wpw_Auto_Poster_DC_Posting {

	public $delicious,$model, $logs;
	
	public function __construct() {
	
		global $wpw_auto_poster_model,$wpw_auto_poster_logs;
		
		$this->model = $wpw_auto_poster_model;
		$this->logs	 = $wpw_auto_poster_logs;
	}
	
	/**
	 * Include Delicious Class
	 * 
	 * Handles to load delicious class
	 * 
	 * @package Social Auto Poster
 	 * @since 1.3.0
	 */
	public function wpw_auto_poster_load_delicious() {
		
		global $wpw_auto_poster_options;
		
		//check delicious user name and password are not empty
		if( !empty( $wpw_auto_poster_options['delicious_username'] ) && !empty( $wpw_auto_poster_options['delicious_password'] ) ) {
		
			if( !class_exists( 'DeliciousBrownies' ) ) {
				require_once( WPW_AUTO_POSTER_SOCIAL_DIR . '/delicious/DeliciousBrownies.php' );
			}
			
			// Delicious Object
			$this->delicious = new DeliciousBrownies();
			$this->delicious->setUsername( WPW_AUTO_POSTER_DC_USERNAME );
			$this->delicious->setPassword( WPW_AUTO_POSTER_DC_PASSWORD );
			
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * Post To Delicious
	 * 
	 * Handles to Post on Delicious account
	 * 
	 * @package Social Auto Poster
	 * @since 1.3.0
	 */
	public function wpw_auto_poster_post_to_delicious( $post ) {
		
		global $wpw_auto_poster_options;

		//load twitter class
		$delicious = $this->wpw_auto_poster_load_delicious();
	
		//check twitter class is loaded or not
		if( !$delicious ) return false;
		
		//posting logs data
		$posting_logs_data = array();
		
		//meta prefix
		$prefix = WPW_AUTO_POSTER_META_PREFIX;

		//record logs for delicious posting
		$this->logs->wpw_auto_poster_add( 'Delicious posting to user account begins.' );
		
		//record logs for delicious username& password
		$this->logs->wpw_auto_poster_add( 'Delicious Username : ' . WPW_AUTO_POSTER_DC_USERNAME );
		$this->logs->wpw_auto_poster_add( 'Delicious Password : ' . WPW_AUTO_POSTER_DC_PASSWORD );
			
		$tags = '';
		$unique = 'false';
		//user data
		$userdata = get_userdata( $post->post_author );
		$first_name = $userdata->first_name; //user first name
		$last_name = $userdata->last_name; //user last name
		
		//published status
		$ispublished = get_post_meta( $post->ID, $prefix.'dc_status', true );
		
		//post title
		$customtitle = get_post_meta( $post->ID, $prefix.'dc_post_title', true );
		$posttitle = isset( $customtitle ) && !empty( $customtitle ) ? $customtitle : $post->post_title;
		
		//description
		$description = get_post_meta( $post->ID, $prefix.'dc_post_desc', true );
		$description = isset( $description ) && !empty( $description ) ? $description : strip_shortcodes( $post->post_content );
		//strip html kses and tags
		$description = $this->model->wpw_auto_poster_stripslashes_deep( $description, true );
		//decode some html
		$description = $this->model->wpw_auto_poster_html_decode( $description );
		
		//post link
		$wpw_auto_poster_dc_custom_link 	= get_post_meta( $post->ID, $prefix . 'dc_custom_post_link', true );
		
		//if post is published on facebook once then change url to prevent duplication
		if( isset( $ispublished ) && $ispublished == '1' ) { 
			$unique = 'true';
		}
				
		//post link for posting to delicious user wall
		$postlink = isset( $wpw_auto_poster_dc_custom_link ) && !empty( $wpw_auto_poster_dc_custom_link ) ? $wpw_auto_poster_dc_custom_link : '';
		//if custom link is set or not
		$customlink = !empty( $postlink ) ? 'true' : 'false';
				
		//do url in shortner form when shortner format is not set wordpress
		$postlink = $this->model->wpw_auto_poster_get_short_post_link( $postlink, $unique, $post->ID, $customlink, 'dc' );
	
		
		//check post is already posted on delicious or not
		$chkpost = $this->delicious->getPosts( $tags, $postlink );
		
		//replace shortcode
		$search_arr = array( '{title}', '{link}', '{first_name}' , '{last_name}', '{sitename}' );
		$replace_arr = array( $posttitle, $postlink, $first_name, $last_name, get_option( 'blogname') );
		$description = str_replace( $search_arr, $replace_arr, $description ); 	
		
		$deliciousdata = array( 
								'posttitle'		=>	$posttitle,
								'postlink' 		=>	$postlink,
								'tags'			=>	$tags,
								'description' 	=>	$description 
							);
	
		//posting logs data
		$posting_logs_data = array(	
										'title' 		=> $posttitle,
										'link' 			=> $postlink,
										'description'	=> $description
									);
		
		//User details
		$posting_logs_user_details = array(
												'account_id' 			=> WPW_AUTO_POSTER_DC_USERNAME,
												'display_name'			=> WPW_AUTO_POSTER_DC_USERNAME,
												'user_name'				=> WPW_AUTO_POSTER_DC_USERNAME,
												'tumblr_consumer_key' 	=> WPW_AUTO_POSTER_DC_USERNAME,
												'tumblr_consumer_secret'=> WPW_AUTO_POSTER_DC_PASSWORD
											);
		
		//record logs for delicious data
		$this->logs->wpw_auto_poster_add( 'Delicious post data : ' . var_export( $deliciousdata, true ) );
		
		if( !empty( $chkpost ) ) { // Update Post
			
			//update post to delicious
			$code = $this->delicious->updatePost( $postlink, $posttitle, $tags, $description );
			
			if( $code == 1 ){
				
				//posting logs store into database
				$this->model->wpw_auto_poster_insert_posting_log( $post->ID, 'dc', $posting_logs_data, $posting_logs_user_details );
				
				//record logs for post posting to delicious
				$this->logs->wpw_auto_poster_add( 'Delicious post updated to user account.' );
			} else{
				//record logs for post posting failed on delicious
				$this->logs->wpw_auto_poster_add( 'Problem to post on Delicious.' );
			}
		} else {
			
			// Send post to Delicious
			$code = $this->delicious->addPost( $postlink, $posttitle, $tags, $description );
			
			if( $code == 1 ){
				
				//posting logs store into database
				$this->model->wpw_auto_poster_insert_posting_log( $post->ID, 'dc', $posting_logs_data, $posting_logs_user_details );
				
				//record logs for post posting to delicious
				$this->logs->wpw_auto_poster_add( 'Delicious post added to user account.' );
			} else {
				//record logs for post posting failed on delicious
				$this->logs->wpw_auto_poster_add( 'Problem to post on Delicious.' );
			}
		}
		
		return $code;
	}
	
	/**
	 * Delicious Posting
	 * 
	 * Handles to delicious posting
	 * by post data
	 * 
	 * @package Social Auto Poster
 	 * @since 1.5.0
	 */
	public function wpw_auto_poster_dc_posting( $post ) {
		
		global $wpw_auto_poster_options;
		
		$prefix = WPW_AUTO_POSTER_META_PREFIX;

		//record logs for delicious is enable for posting
		$this->logs->wpw_auto_poster_add( 'Posting is enabled' );
					
		$res = $this->wpw_auto_poster_post_to_delicious( $post );
		
		if ( $res == '1' ) { //check post is publish on delicious or not
			
			//record logs for posting done on delicious
			$this->logs->wpw_auto_poster_add( 'Delicious posting completed successfully.' );
			
			update_post_meta( $post->ID, $prefix . 'dc_status', '1' );
			return true;
		}
		return false;
	}
}
?>