<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Fan Page Posting Class
 * 
 * Handles all the functions to post the submitted and approved
 * reviews to a chosen Fan Page / Facebook Account.
 * 
 * @package Social Auto Poster
 * @since 1.0.0
 */
class Wpw_Auto_Poster_FB_Posting {
	
	public $facebook, $message, $model, $logs, $_user_cache;
	
	public function __construct() {
		
		global $wpw_auto_poster_message_stack, $wpw_auto_poster_model,
				$wpw_auto_poster_logs;
		
		$this->message  = $wpw_auto_poster_message_stack;
		$this->model 	= $wpw_auto_poster_model;
		$this->logs		= $wpw_auto_poster_logs;
		
		//initialize the session value when data is saved in database
		add_action( 'init', array( $this, 'wpw_auto_poster_fb_initialize' ) );
	}
	
	/**
	 * Include Facebook Class
	 * 
	 * Handles to load facebook class
	 * 
	 * @package Social Auto Poster
 	 * @since 1.0.0
	 */
	public function wpw_auto_poster_load_facebook() {
		
		global $wpw_auto_poster_options;
		
		//check facebook application id and application secret is not empty or not
		if( !empty( $wpw_auto_poster_options['fb_app_id'] ) && !empty( $wpw_auto_poster_options['fb_app_secret'] ) ) {
			
			if( !class_exists( 'Facebook' ) ) {
				require_once( WPW_AUTO_POSTER_SOCIAL_DIR . '/facebook/facebook.php' );
			}
			
			$this->facebook = new Facebook( array(
													'appId' => WPW_AUTO_POSTER_FB_APP_ID,
													'secret' => WPW_AUTO_POSTER_FB_APP_SECRET,
													'cookie' => true
												));
			return true;
			
		} else {
			
			return false;
		}
	}
	
	/**
	 * Assign Facebook User's all Data to session
	 * 
	 * Handles to assign user's facebook data
	 * to sessoin & save to database
	 * 
	 * @package Social Auto Poster
 	 * @since 1.0.0
	 */
	public function wpw_auto_poster_fb_initialize() {
		
		global $wpw_auto_poster_options;
		
		//set session to set tab selected in settings page
		//isset( $_GET['page'] ) && $_GET['page'] == 'wpw-auto-poster-settings'
		if( isset( $_GET['wpw_fb_grant'] ) && $_GET['wpw_fb_grant'] == 'true'
			&& isset( $_GET['code'] ) && isset( $_REQUEST['state'] ) ) {
			
			//record logs for grant extended permission
			$this->logs->wpw_auto_poster_add( 'Facebook Grant Extended Permission', true );
			
			//record logs for get parameters set properly
			$this->logs->wpw_auto_poster_add( 'Get Parameters Set Properly.' );
			
			//load facebook class
			$facebook = $this->wpw_auto_poster_load_facebook();
			
			//check facebook class is exis or not
			if( !$facebook ) return false;
			
			// Facebook
			$user = $this->facebook->getUser();
			
			//record logs for user id
			$this->logs->wpw_auto_poster_add( 'Facebook User ID : '.$user );
			
			//check user is logged in facebook or not
			if( $user ) {
				
			 	try {
					
			        // Proceed knowing you have a logged in user who's authenticated.
					$_SESSION['wpweb_fb_user_cache'] = isset( $_SESSION['wpweb_fb_user_cache'] )
						? $_SESSION['wpweb_fb_user_cache'] : $this->facebook->api('/me');
			        $this->_user_cache =  $_SESSION['wpweb_fb_user_cache'];
			      
			        $_SESSION['wpweb_fb_user_id'] = isset( $_SESSION['wpweb_fb_user_id'] )
						? $_SESSION['wpweb_fb_user_id'] : $user;
					
					$_SESSION['wpweb_fb_user_accounts'] = $this->wpw_auto_poster_fb_fetch_accounts();
					
					// start code to manage session from database
					$wpw_auto_poster_fb_sess_data = get_option( 'wpw_auto_poster_fb_sess_data' );
					
					if( empty( $wpw_auto_poster_fb_sess_data ) ) {
						
						$sess_data = array(
											'wpw_auto_poster_fb_user_cache'		=>	$_SESSION['wpweb_fb_user_cache'],
											'wpw_auto_poster_fb_user_id'		=>	$_SESSION['wpweb_fb_user_id'],
											'wpw_auto_poster_fb_user_accounts'	=>	$_SESSION['wpweb_fb_user_accounts'],
											WPW_AUTO_POSTER_FB_SESS1 			=>	$_SESSION[WPW_AUTO_POSTER_FB_SESS1],
											WPW_AUTO_POSTER_FB_SESS2 			=>	$_SESSION[WPW_AUTO_POSTER_FB_SESS2],
											WPW_AUTO_POSTER_FB_SESS3 			=>	$_SESSION[WPW_AUTO_POSTER_FB_SESS3],
											WPW_AUTO_POSTER_FB_SESS4 			=>	isset( $_SESSION[WPW_AUTO_POSTER_FB_SESS4] ) ? $_SESSION[WPW_AUTO_POSTER_FB_SESS4] : '',
										);
						
						//update session data to options
						update_option( 'wpw_auto_poster_fb_sess_data', $sess_data );
				      	
						//record logs for session data updated to options
						$this->logs->wpw_auto_poster_add( 'Session Data Updated to Options' );
						
				    }// end code to manage session from database
			      	
				    //record logs for grant extend successfully
					$this->logs->wpw_auto_poster_add( 'Grant Extended Permission Successfully.' );
				    
				} catch( FacebookApiException $e ) {
					
					//record logs exception generated
					$this->logs->wpw_auto_poster_add( 'Facebook Exception : ' . $e->__toString() );
					
					//user is null
			 	  	$user = null;
			 	  	
				} //end catch
				
			} //end if to check user is not empty
			
			//set tab selected
	  		$this->message->add_session( 'poster-selected-tab', 'facebook' );
	  		
	  		//redirect to proper page
	  		wp_redirect( add_query_arg( array( 'wpw_fb_grant' => false, 'code' => false, 'state' => false ) ) );
			exit;
		} //end if to check page is set and wpw_fb_grant is set & its true & code is set & state is set in $_GET
	}
	
	/**
	 * Facebook Login URL
	 * 
	 * Getting the login URL from Facebook.
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_get_fb_login_url() {
		
		//load facebook class
		$facebook = $this->wpw_auto_poster_load_facebook();
		
		//check facebook class is exis or not
		if( !$facebook ) return false;
		
		$portvalue		= is_ssl() ? 'https://' : 'http://';
		$redirect_URL	= $portvalue.$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
		$redirect_URL	= add_query_arg( 'wpw_fb_grant', 'true',  $redirect_URL );
		$loginUrl		= $this->facebook->getLoginUrl( array(
														//'scope'	=> 'publish_actions,email,manage_pages,user_photos,user_groups',
														'scope'	=> 'publish_actions,email,manage_pages,publish_pages,user_posts,user_photos,user_groups',
														'redirect_uri'  => $redirect_URL
													) );
		return $loginUrl;
    }
	
    /**
	 * User Data
	 * 
	 * Getting the cached user data from the connected
	 * Facebook user (back end).
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_get_fb_user_data() {
		
		if( !empty( $this->_user_cache ) ) {
			return $this->_user_cache;
		}
	}
	
	/**
	 * Pages Tokens
	 * 
	 * Getting the the tokens from all pages/accounts which
	 * are associated with the connected Facebook account
	 * so that the admin chan choose to which page/account
	 * he wants to post the submitted and approved reviews to.
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_fb_get_pages_tokens() {
		
		//load facebook class
		$facebook = $this->wpw_auto_poster_load_facebook();
		
		//check facebook class is exis or not
		if( !$facebook ) return false;
		
		try {
			$ret = $this->facebook->api( '/' . $_SESSION['wpweb_fb_user_id'] . '/accounts/' );
		} catch ( Exception $e ) {
			return false;
		}
		return $ret;
	}
	
	/**
	 * Fetching Accounts
	 * 
	 * Fetching all the associated accounts from the connected
	 * Facebook user (site admin).
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_fb_fetch_accounts() {
		
		global $wpw_auto_poster_options;
		
		if( !isset( $wpw_auto_poster_options[ 'prevent_linked_accounts_access' ] ) ) {
			
			$page_tokens = $this->wpw_auto_poster_fb_get_pages_tokens();
			$page_tokens = isset( $page_tokens['data'] ) ? $page_tokens['data'] : array();
			
			// Getting user group data
			$group_tokens = $this->wpw_auto_poster_fb_get_groups_tokens();
			$group_tokens = isset( $group_tokens['data'] ) ? $group_tokens['data'] : array();
			
		} else {
        	$page_tokens 	= array();
        	$group_tokens 	= array();
        }
		
		$api = array();
		$api['auth_accounts'][$_SESSION['wpweb_fb_user_id']] = $this->_user_cache['name']." (".$_SESSION['wpweb_fb_user_id'].")";
		$api['auth_tokens'][$_SESSION['wpweb_fb_user_id']] = isset( $_SESSION['fb_'.WPW_AUTO_POSTER_FB_APP_ID.'_access_token'] ) ? $_SESSION['fb_'.WPW_AUTO_POSTER_FB_APP_ID.'_access_token'] : '';
		
		// Taking user auth tokens
		$user_auth_tokens = isset( $_SESSION['fb_'.WPW_AUTO_POSTER_FB_APP_ID.'_access_token'] ) ? $_SESSION['fb_'.WPW_AUTO_POSTER_FB_APP_ID.'_access_token'] : '';
		
		if( !isset( $wpw_auto_poster_options[ 'prevent_linked_accounts_access' ] ) ) {
			
			foreach( $page_tokens as $ptk ) {
				if( !isset( $ptk['id'] ) || !isset( $ptk['access_token'] ) ) continue;
				$api['auth_tokens'][$ptk['id']] = $ptk['access_token'];
				$api['auth_accounts'][$ptk['id']] = $ptk['name'];
			}
			
			// Creating user group data if user is administrator of that group
			foreach( $group_tokens as $gtk ) {
				if( isset($gtk['id']) && isset($gtk['administrator']) && $gtk['administrator'] == 1 ) {
					$api['auth_tokens'][$gtk['id']] = $user_auth_tokens;
					$api['auth_accounts'][$gtk['id']] = $gtk['name'];
				}
			}
		}
		
		return $api;
	}
	
	/**
	 * Post to User Wall on Facebook
	 * 
	 * Handles to post user wall on facebook
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_fb_post_to_userwall( $post ) {
		
		global $wpw_auto_poster_options;
		
		//load facebook class
		$facebook = $this->wpw_auto_poster_load_facebook();
		
		//check facebook class is exis or not
		if( !$facebook ) return false;
		
		//check facebook user id is set in session and not empty
		if( isset( $_SESSION['wpweb_fb_user_id'] ) && !empty( $_SESSION['wpweb_fb_user_id'] ) ) {
			
			//posting logs data
			$posting_logs_data = array();
			
			//metabox field prefix
			$prefix = WPW_AUTO_POSTER_META_PREFIX;
			
			$post_type 	= $post->post_type; //post type
			$unique 	= 'false'; //unique
			$userdata 	= get_userdata( $post->post_author ); //user data form post author
			$first_name	= $userdata->first_name; //user first name
			$last_name 	= $userdata->last_name; //user last name
			
			//published status
			$ispublished = get_post_meta( $post->ID, $prefix . 'fb_published_on_fb', true );
			
			if ( !isset( $wpw_auto_poster_options['prevent_post_metabox'] ) ) { //check if prevent metabox is not enable
				
				$wpw_auto_poster_fb_custom_title= get_post_meta( $post->ID, $prefix . 'fb_custom_title', true );
				$wpw_auto_poster_fb_user_id 	= get_post_meta( $post->ID, $prefix . 'fb_user_id' );
				$wpw_auto_fb_posting_method 	= get_post_meta( $post->ID, $prefix . 'fb_posting_method', true );
				$wpw_auto_fb_custom_status_msg 	= get_post_meta( $post->ID, $prefix . 'fb_custom_status_msg', true );
				$wpw_auto_poster_custom_link 	= get_post_meta( $post->ID, $prefix . 'fb_custom_post_link', true );
				$wpw_auto_poster_custom_desc 	= get_post_meta( $post->ID, $prefix . 'fb_custom_post_desc', true );
				$wpw_auto_poster_custom_caption = get_post_meta( $post->ID, $prefix . 'fb_custom_caption', true );
				$wpw_auto_poster_custom_img 	= get_post_meta( $post->ID, $prefix . 'fb_post_image', true );
				
			} //end if
			
			//get facebook user data
			$wpw_auto_poster_fb_sess_data 	= get_option( 'wpw_auto_poster_fb_sess_data' );
			
			//facebook access token
			$fb_access_token	= ( isset( $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_accounts'] )
									&& isset( $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_accounts']['auth_tokens'] ) )
									? $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_accounts']['auth_tokens'] : array();
			
			//facebook user id on whose wall the post will be posted
			$fb_user_ids = '';
			//check there is facebook user ids are set and not empty in metabox
			if( isset( $wpw_auto_poster_fb_user_id ) && !empty( $wpw_auto_poster_fb_user_id ) ) {
				//users from metabox
				$fb_user_ids 	= $wpw_auto_poster_fb_user_id;
			} //end if
			
			//check facebook user ids are empty in metabox and set in settings page
			if( empty( $fb_user_ids )
				&& isset( $wpw_auto_poster_options[ 'fb_type_'.$post_type.'_user' ] )
				&& !empty( $wpw_auto_poster_options[ 'fb_type_'.$post_type.'_user' ] ) ) {
				//users from settings
				$fb_user_ids = $wpw_auto_poster_options[ 'fb_type_'.$post_type.'_user' ];
			} //end if
			
			//check facebook user ids are empty selected for posting
			if( empty( $fb_user_ids ) ) {
				
				//record logs for facebook users are not selected
				$this->logs->wpw_auto_poster_add( 'Facebook posting users are not selected.' );
				
				//return false
				return false;
			} //end if to check user ids are empty
			
			//convert user ids to single array
			$post_to_users 	= ( array ) $fb_user_ids;
			
			//post custom title for posting on facebook userwall
			$title = !empty( $wpw_auto_poster_fb_custom_title ) ? $wpw_auto_poster_fb_custom_title : $post->post_title;
			//remove html entity from title
			$title = $this->model->wpw_auto_poster_html_decode( $title );
			
			//posting method
			$post_as 	= isset( $wpw_auto_fb_posting_method ) && !empty( $wpw_auto_fb_posting_method ) ? $wpw_auto_fb_posting_method :  $wpw_auto_poster_options[ 'fb_type_'.$post_type.'_method' ];
			
			//post link for posting to facebook user wall
			$postlink = isset( $wpw_auto_poster_custom_link ) && !empty( $wpw_auto_poster_custom_link ) ? $wpw_auto_poster_custom_link : '';
			//if custom link is set or not
			$customlink = !empty( $postlink ) ? 'true' : 'false';
			
			//do url shortner
			$postlink = $this->model->wpw_auto_poster_get_short_post_link( $postlink, $unique, $post->ID, $customlink, 'fb' );
			
			// not sure why this code here it should be above $postlink but lets keep it here
			//if post is published on facebook once then change url to prevent duplication
			if( isset( $ispublished ) && !empty( $ispublished ) ) {
				$unique = 'true';
			}
			
			//custom status message to post on facebook
			$custom_msg 	= isset( $wpw_auto_fb_custom_status_msg ) && $wpw_auto_fb_custom_status_msg ? $wpw_auto_fb_custom_status_msg : $wpw_auto_poster_options[ "custom_status_msg" ];
			
			//remove html entity from custom message
			$custom_msg = $this->model->wpw_auto_poster_html_decode( $custom_msg );
			
			//post content to post
			$post_content = isset( $wpw_auto_poster_custom_desc ) && !empty( $wpw_auto_poster_custom_desc ) ? $wpw_auto_poster_custom_desc
								: strip_shortcodes( $post->post_content );
			
			//strip html kses and tags
			$post_content = $this->model->wpw_auto_poster_stripslashes_deep( $post_content );
			//decode html entity
			$post_content = $this->model->wpw_auto_poster_html_decode( $post_content );
			
			// Taking the limited content to avoid the exception
			$post_content = $this->model->wpw_auto_poster_excerpt( $post_content, 9500 );
			
			//post custom caption to post on facebook
			$post_caption = isset( $wpw_auto_poster_custom_caption ) && !empty( $wpw_auto_poster_custom_caption ) ? $wpw_auto_poster_custom_caption : '';
			
			/**************
			 * Image Priority
			 * If metabox image set then take from metabox
			 * If metabox image is not set then take from featured image
			 * If featured image is not set then take from settings page
			 **************/
			
			//get featured image from post / page / custom post type
			$post_featured_img = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
			//check custom image is set in meta and not empty
			if( isset( $wpw_auto_poster_custom_img['src'] ) && !empty( $wpw_auto_poster_custom_img['src'] ) ) {
				$post_img = $wpw_auto_poster_custom_img['src'];
			} elseif ( isset( $post_featured_img[0] ) && !empty( $post_featured_img[0] ) ) {
				//check post featrued image is set the use that image
				$post_img = $post_featured_img[0];
			} else {
				//else get post image from settings page
				$post_img = $wpw_auto_poster_options['fb_custom_img'];
			}
			
			//posting logs data
			$posting_logs_data = array(
										'title'		=> $title,
										'content'	=> $post_content,
										'link'		=> $postlink,
										'fb_type'	=> $post_as,
									);
			switch( $post_as ) {
				
				case "feed_status":
					
					$post_method	= 'feed';
					$search_arr		= array( '{title}', '{link}', '{first_name}' , '{last_name}', '{site_name}', '%title%', '%link%' );
					$replace_arr	= array( $title, $postlink,$first_name, $last_name, get_option( 'blogname' ), $title, $postlink  );
					$final_msg		= str_replace( $search_arr, $replace_arr, $custom_msg );
					$send = array(
									'message' => $final_msg
								);
					$posting_logs_data['status'] = $final_msg;
					break;
					
				case "feed":
				default:
					$post_method = 'feed';
					$send = array();
					//check post image is not empty then pass to facebook
					if( !empty( $post_img ) ) {
						$send['picture'] = $post_img;
						$posting_logs_data['image'] = $post_img;
					}
					if( !empty( $post_caption ) ) {
						$send['caption'] = substr( $post_caption, 0, 999 );
						$posting_logs_data['caption'] = substr( $post_caption, 0, 999 );
					}
					
					$send['message'] 		= substr( $title, 0, 999 );
					$send['link'] 			= $postlink;
					$send['name'] 			= $post->post_title;
					$send['description'] 	= $post_content;
					
					break;
			}
			
			//initial value of posting flag
			$postflg = false;
			
			// if Post Reviews to this Fan Page/Account option is set
			if( !empty( $post_to_users ) ) {
				
				//get facebook account details
				$fb_accounts = array();
				if( isset( $_SESSION['wpweb_fb_user_accounts'] ) && !empty( $_SESSION['wpweb_fb_user_accounts'] ) ) {
					
					$fb_accounts = isset( $_SESSION['wpweb_fb_user_accounts']['auth_accounts'] ) 
									? $_SESSION['wpweb_fb_user_accounts']['auth_accounts'] : array();
				}
				
				//record logs for facebook users are not selected
				$this->logs->wpw_auto_poster_add( 'Facebook posting to user\'s wall begins with ' . $post_method . ' method.' );
				
				//Get user cache data
				$user_cache_data = isset( $_SESSION['wpweb_fb_user_cache'] ) ? $_SESSION['wpweb_fb_user_cache'] : array();
				
				foreach ( $post_to_users as $post_to ) {
					
					$send['access_token'] = '';
					
					//User details
					$posting_logs_user_details = array(
														'account_id' 	=> $post_to,
														'fb_app_id' 	=> WPW_AUTO_POSTER_FB_APP_ID,
														'fb_app_secret' => WPW_AUTO_POSTER_FB_APP_SECRET,
													);
					
					if( isset( $user_cache_data['id'] ) && $user_cache_data['id'] == $post_to ) { // Check facebook main user data
						
						$user_email = isset( $user_cache_data['email'] ) ? $user_cache_data['email'] : '';
						$posting_logs_user_details['display_name'] 	= isset( $user_cache_data['name'] ) ? $user_cache_data['name'] . ' (' . $user_email . ')' : '';
						$posting_logs_user_details['first_name'] 	= isset( $user_cache_data['first_name'] ) ? $user_cache_data['first_name'] : '';
						$posting_logs_user_details['last_name'] 	= isset( $user_cache_data['last_name'] ) ? $user_cache_data['last_name'] : '';
						$posting_logs_user_details['user_name'] 	= isset( $user_cache_data['username'] ) ? $user_cache_data['username'] : '';
						$posting_logs_user_details['user_email'] 	= $user_email;
						$posting_logs_user_details['profile_url'] 	= isset( $user_cache_data['link'] ) ? $user_cache_data['link'] : '';
						
					} else {//Account Name
						
						$posting_logs_user_details['display_name'] = isset( $fb_accounts[$post_to] ) ? $fb_accounts[$post_to] : '' ;
					}
					
					if( isset( $fb_access_token[$post_to] ) ) {//check there is access token is set
						$send['access_token'] = $fb_access_token[$post_to]; // most imp line
					} //end if
					
					//record logs for facebook user's access token
					$this->logs->wpw_auto_poster_add( 'Facebook posting access token for ' . $post_to  . ' : ' . $send['access_token'] );
					
					//record logs for facebook data
					$this->logs->wpw_auto_poster_add( 'Facebook post data : ' . var_export( $send, true ) );
					
					//check accesstoken is not empty
					if( !empty( $send['access_token'] ) ) {
						
						try {
							
							//post to facebook user wall
							$ret = $this->facebook->api( '/' . $post_to . '/' . $post_method . '/', 'POST', $send );
							
							//check id is set in response and not empty
							if( isset( $ret['id'] ) && !empty( $ret['id'] ) ) {
								
								//posting logs store into database
								$this->model->wpw_auto_poster_insert_posting_log( $post->ID, 'fb', $posting_logs_data, $posting_logs_user_details );
								
								//record logs for facebook users are not selected
								$this->logs->wpw_auto_poster_add( 'Facebook posted to user ID : ' . $post_to  . ' | Response ID '.$ret['id'] );
								
								//posting flag that posting successfully
								$postflg = true;
								
							} //end if
							
						} catch ( Exception $e ) {
							
							//record logs exception generated
							$this->logs->wpw_auto_poster_add( 'Facebook posting exception for ' . $post_to .' : ' . $e->__toString() );
							
						} //end catch
					} //end if to check accesstoken is not empty
				} //end foreach
			} //end if to check post_to is not empty
			
			//returning post flag
			return $postflg;
			
		} else {
			//record logs when grant extended permission not set
			$this->logs->wpw_auto_poster_add( 'Facebook grant extended permissions not set.' );
		} //end else
	}
	
	/**
	 * Reset Sessions
	 * 
	 * Resetting the Facebook sessions when the admin clicks on
	 * its link within the settings page.
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_fb_reset_session() {
		
		global $wpw_auto_poster_options;
		
		unset( $_SESSION['wpweb_fb_user_id'] );
		unset( $_SESSION['wpweb_fb_user_cache'] );
		unset( $_SESSION['wpweb_fb_user_accounts'] );
		update_option( 'wpw_auto_poster_fb_sess_data', '' );
		
		unset( $_SESSION[WPW_AUTO_POSTER_FB_SESS1] );
		unset( $_SESSION[WPW_AUTO_POSTER_FB_SESS2] );
		unset( $_SESSION[WPW_AUTO_POSTER_FB_SESS3] );
		unset( $_SESSION[WPW_AUTO_POSTER_FB_SESS4] );
		
		//check if facebook reset user link is clicked and fb_reset_user is set to 1
		if( isset( $_GET['fb_reset_user'] ) && $_GET['fb_reset_user'] == '1' ) {
			
			//get all post type
			$all_post_types = get_post_types( array( 'public' => true ), 'objects' );
			$all_post_types = is_array( $all_post_types ) ? $all_post_types : array();
			
			//unset users from settings page
			foreach ( $all_post_types as $posttype ) {
				
				//check postype is not object
				if( !is_object( $posttype ) ) continue;
				
				$label = @$posttype->labels->name ? $posttype->labels->name : $posttype->name;
				if( $label == 'Media' || $label == 'media' ) continue; // skip media
				
				//check if user is set for posting in settings page then unset it
				if( isset( $wpw_auto_poster_options[ 'fb_type_'.$posttype->name.'_user' ] ) ) {
					unset( $wpw_auto_poster_options[ 'fb_type_'.$posttype->name.'_user' ] );
				} //end if
				
			} //end foreach
			
			//update autoposter options to settings
			update_option( 'wpw_auto_poster_options', $wpw_auto_poster_options );
			
		} //end if
	}
	
	/**
	 * Get album photos from facebook
	 * 
	 * Handle to get album photos for particular id from facebook
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_fb_get_album_photos($aid, $limit=false) {
		
		//load facebook class
		$facebook = $this->wpw_auto_poster_load_facebook();
		
		//check facebook class is exis or not
		if( !$facebook ) return false;
		
		if (!$aid) return false;
		$limit = $limit ? '?limit=' . $limit : '';
		
		$fb_access_token = isset($_SESSION['wpweb_fb_user_accounts']['auth_tokens']) ? $_SESSION['wpweb_fb_user_accounts']['auth_tokens'] : array();
		$token = $fb_access_token[$_SESSION['wpweb_fb_user_id']];
		$send['access_token'] = $token; // most imp line
		
		try {
			$res = $this->facebook->api('/' . $aid . '/photos/' . $limit,'GET',$send);
		} catch (Exception $e) {
			return false;
		}
		
		return $res;
	}
	
	/**
	 * Get all events from facebook
	 * 
	 * Handle to get all events for particular id from facebook
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_fb_get_events_for( $for ) {
		
		//load facebook class
		$facebook = $this->wpw_auto_poster_load_facebook();
		
		//check facebook class is exis or not
		if( !$facebook ) return false;
		
		if (!$for) return false;
		
		$fb_access_token = isset($_SESSION['wpweb_fb_user_accounts']['auth_tokens']) ? $_SESSION['wpweb_fb_user_accounts']['auth_tokens'] : array();
		
		if( isset( $fb_access_token[$for] ) ) {
			$token = $fb_access_token[$for];
		} else {
			return false;
		}
		
		$send['access_token'] = $token; // most imp line
		
		try {
			$res = $this->facebook->api( '/' . $for . '/events/', 'GET', $send );
		} catch ( Exception $e ) {
			echo $e;
			return false;
		}
		
		return $res;
	}
	
	/**
	 * Get all albums from facebook
	 * 
	 * Handle to get all albums for particular id from facebook
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_fb_get_albums_for( $for ) {
		
		//load facebook class
		$facebook = $this->wpw_auto_poster_load_facebook();
		
		//check facebook class is exis or not
		if( !$facebook ) return false;
		
		if (!$for) return false;
		
		$fb_access_token = isset($_SESSION['wpweb_fb_user_accounts']['auth_tokens']) ? $_SESSION['wpweb_fb_user_accounts']['auth_tokens'] : array();
		$token = $fb_access_token[$for]; 
		$send['access_token'] = $token; // most imp line
		
		try {
			
			$res = $this->facebook->api('/' . $for . '/albums/?auth_token=' . $send);
			
		} catch (Exception $e) {
			
			return false;
		}
		
		return $res;
	}
	
	/**
	 * Display html in dashboard widget for grant permission
	 * 
	 * Handle to display html in dashboard widget for grant permission facebook
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_dashboard_permissions_widget() {
		
		if( isset( $_SESSION['wpweb_fb_user_id'] ) && !empty( $_SESSION['wpweb_fb_user_id'] ) )  {
			
			echo '<p>' . __( 'You already granted extended permissions.', 'wpwautoposter' ) . '</p>';
			echo '<a href="' . add_query_arg( array( 'page' => 'wpw-auto-poster-settings', 'fb_reset_user' => '1' ), admin_url( 'admin.php' ) ).'">' . __( 'Reset User Session', 'wpwautoposter' ) . '</a>';
		} else {
			echo '<p><a href="' . $this->wpw_auto_poster_get_fb_login_url() . '">' . __( 'Grant extended permissions', 'wpwautoposter' ) . '</a></p>';
		}
	}
	
	/**
	 * Facebook Posting
	 * 
	 * Handles to facebook posting
	 * by post data
	 * 
	 * @package Social Auto Poster
 	 * @since 1.5.0
	 */
	public function wpw_auto_poster_fb_posting( $post ) {
		
		global $wpw_auto_poster_options;
		
		$prefix = WPW_AUTO_POSTER_META_PREFIX;
		
		//record logs for facebook is enable for posting
		$this->logs->wpw_auto_poster_add( 'Posting is enabled' );
		
		//post to user wall on facebook
		$res = $this->wpw_auto_poster_fb_post_to_userwall( $post );
		
		//if( isset( $res['id'] ) && !empty( $res['id'] ) ) { //check post has been posted on facebook or not
		if( !empty( $res ) ) { //check post has been posted on facebook or not
			
			//record logs for posting done on facebook
			$this->logs->wpw_auto_poster_add( 'Facebook posting completed successfully.' );
			
			update_post_meta( $post->ID, $prefix . 'fb_published_on_fb', '1' );
			return true;
		}
		
		return false;
	}
	
	/**
	 * Group Tokens
	 * 
	 * Getting the the tokens from all group which
	 * are associated with the connected Facebook account
	 * so that the admin can choose to which group
	 * he wants to post the submitted and approved reviews to.
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_fb_get_groups_tokens() {
		
		// Load facebook class
		$facebook = $this->wpw_auto_poster_load_facebook();
		
		// Check facebook class is exis or not
		if( !$facebook ) return false;
		
		try {
			$fb_groups = $this->facebook->api( '/' . $_SESSION['wpweb_fb_user_id'] . '/groups/' );
		} catch ( Exception $e ) {
			return false;
		}
		
		return $fb_groups;
	}
}