<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * LinkedIn Posting Class
 *
 * Handles all the functions to post the submitted and approved
 * reviews to a chosen application owner account
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
class Wpw_Auto_Poster_Li_Posting {
	
	public $linkedinconfig, $linkedin, $message, $model, $logs;
	
	public function __construct() {
	
		global $wpw_auto_poster_message_stack, $wpw_auto_poster_model, $wpw_auto_poster_logs;
		
		$this->message = $wpw_auto_poster_message_stack;
		$this->model = $wpw_auto_poster_model;
		$this->logs	 = $wpw_auto_poster_logs;
		
		//intialize some data
		$this->wpw_auto_poster_li_initialize();
		
		//add action init for making user to logged in linkedin
		add_action( 'init', array( $this, 'wpw_auto_poster_li_user_logged_in' ) );
		
	}
	
	/**
	 * LinekedIn Get Access Tocken
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_li_get_access_token() {
		
		$access_tocken	= '';
		
		if( isset( $_SESSION['wpw_auto_poster_linkedin_oauth']['linkedin']['access'] ) ) {
			
			$li_access_data	= $_SESSION['wpw_auto_poster_linkedin_oauth']['linkedin']['access'];
			
			$access_tocken	= isset( $li_access_data['access_token'] ) ? $li_access_data['access_token'] : '';
		}
		
		return $access_tocken;
	}
	
	/**
	 * Include LinkedIn Class
	 * 
	 * Handles to load Linkedin class
	 * 
	 * @package Social Auto Poster
 	 * @since 1.0.0
	 */
	public function wpw_auto_poster_load_linkedin() {
		
		global $wpw_auto_poster_options;
		
		//linkedin declaration
		if( !empty( $wpw_auto_poster_options['linkedin_app_id'] ) && !empty( $wpw_auto_poster_options['linkedin_app_secret'] ) ) {

			if( !class_exists( 'LinkedInOAuth2' ) ) {
				require_once( WPW_AUTO_POSTER_SOCIAL_DIR . '/linkedin/LinkedIn.OAuth2.class.php' );
			}
			
			$call_back_url	= site_url().'/?wpwautoposter=linkedin';
			
			//linkedin api configuration
			$this->linkedinconfig = array(
									    	'appKey'       => WPW_AUTO_POSTER_LI_APP_ID,
										  	'appSecret'    => WPW_AUTO_POSTER_LI_APP_SECRET,
										  	'callbackUrl'  => $call_back_url
									  	 );
			
			//Get access token
			$access_token	= $this->wpw_auto_poster_li_get_access_token();
			
			//Load linkedin outh2 class
			$this->linkedin = new LinkedInOAuth2( $access_token );
			
			return true;
			
		} else {
			
			return false;
		}
	}
	
	/**
	 * Make Logged In User to LinekedIn
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_li_user_logged_in() {
		
		global $wpw_auto_poster_options;
		
		if( !empty( $wpw_auto_poster_options['linkedin_app_id'] ) && !empty( $wpw_auto_poster_options['linkedin_app_secret'] ) ) {
			
			//check $_GET['wpwautoposter'] equals to linkedin
			if( isset( $_GET['wpwautoposter'] ) && $_GET['wpwautoposter'] == 'linkedin'
				&& !empty( $_GET['code'] ) && !empty( $_GET['state'] ) ) {
				
				//record logs for grant extended permission
				$this->logs->wpw_auto_poster_add( 'LinkedIn Grant Extended Permission', true );
				
				//record logs for get parameters set properly
				$this->logs->wpw_auto_poster_add( 'Get Parameters Set Properly.' );
				
				//load linkedin class
				$linkedin	= $this->wpw_auto_poster_load_linkedin();
				$config		= $this->linkedinconfig;
				
				//check linkedin loaded or not
				if( !$linkedin ) return false;
				
				//Get Access token
				$arr_access_token	= $this->linkedin->getAccessToken( $config['appKey'], $config['appSecret'], $config['callbackUrl']);
				
				// code will excute when user does connect with linked in
				if( !empty( $arr_access_token['access_token'] ) ) { // if user allows access to linkedin
					
					//record logs for get type initiate called
					$this->logs->wpw_auto_poster_add( 'LinkedIn grant initiate called' );
					
					//record logs for get type response called
					$this->logs->wpw_auto_poster_add( 'LinkedIn permission granted by user' );
					
		        	//record logs for get type initiate called
					$this->logs->wpw_auto_poster_add( 'LinkedIn Request token retrieval success when clicked on allow access by user' );
		        	
					// the request went through without an error, gather user's 'access' tokens
					$_SESSION['wpw_auto_poster_linkedin_oauth']['linkedin']['access'] = $arr_access_token;
					
					// set the user as authorized for future quick reference
					$_SESSION['wpw_auto_poster_linkedin_oauth']['linkedin']['authorized'] = TRUE;
					
					//Get User Profiles
					$resultdata			= $this->linkedin->getProfile();
					
					//set user data to sesssion for further use
			        $_SESSION['wpw_auto_poster_li_cache'] = $resultdata;
		           	$_SESSION['wpw_auto_poster_li_user_id'] = isset( $resultdata['id'] ) ? $resultdata['id'] : '';
		           	
		           	//Get company data
		           	$company_data	= $this->wpw_auto_poster_get_company_data();
		           	
		           	//update company data in session
		           	$_SESSION['wpw_auto_poster_li_companies'] = $company_data;
		           	
		           	//Get group data
		           	$group_data	= $this->wpw_auto_poster_get_group_data();
		           	
		           	//Update group data in session
		           	$_SESSION['wpw_auto_poster_li_groups'] = $group_data;
		           	
					// redirect the user back to the demo page
					$this->message->add_session( 'poster-selected-tab', 'linkedin' );
					
					//set user data  to session
					$this->wpw_auto_poster_set_li_data_to_session();
					
					//record logs for grant extend successfully
					$this->logs->wpw_auto_poster_add( 'Grant Extended Permission Successfully.' );
					
					$poster_setting_url = add_query_arg( array('page' => 'wpw-auto-poster-settings' ), admin_url() );
					
					wp_redirect( $poster_setting_url );
					exit;
					
			  	} else {
			  		
					//record logs for access token retrieval
					$this->logs->wpw_auto_poster_add( 'LinkedIn access token retrieval failed' );					
		        }
				
			} //end if to check $_GET['wpwautoposter'] equals to linkedin
			
		} //end if to check linkedin app id and secret are not empty
		
	}
	
	/**
	 * Initializes Some Data to session
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_li_initialize() {
		
		global $wpw_auto_poster_options;
		
		//check user data is not empty and linkedin app id and secret are not empty
		if( !empty( $wpw_auto_poster_options['linkedin_app_id'] ) && !empty( $wpw_auto_poster_options['linkedin_app_secret'] ) ) {
			
			//Set Session From Options Value
			$wpw_auto_poster_li_sess_data	= get_option( 'wpw_auto_poster_li_sess_data' );
			
			if( !empty( $wpw_auto_poster_li_sess_data ) && !isset( $_SESSION['wpw_auto_poster_li_user_id'] ) ) { //check user data is not empty
				
				$_SESSION['wpw_auto_poster_li_user_id']		= $wpw_auto_poster_li_sess_data['wpw_auto_poster_li_user_id'];
				$_SESSION['wpw_auto_poster_li_cache']		= $wpw_auto_poster_li_sess_data['wpw_auto_poster_li_cache'];
				$_SESSION['wpw_auto_poster_li_oauth']		= $wpw_auto_poster_li_sess_data['wpw_auto_poster_li_oauth'];
				$_SESSION['wpw_auto_poster_linkedin_oauth']	= $wpw_auto_poster_li_sess_data['wpw_auto_poster_li_oauth']; //assign stored oauth token to database
				$_SESSION['wpw_auto_poster_li_companies']	= $wpw_auto_poster_li_sess_data['wpw_auto_poster_li_companies']; //assign stored companies to database
				$_SESSION['wpw_auto_poster_li_groups']		= $wpw_auto_poster_li_sess_data['wpw_auto_poster_li_groups']; //assign stored groups to database
			}
		}
	}
	
	/**
	 * Get LinkedIn Login URL
	 * 
	 * Handles to Return LinkedIn URL
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_get_li_login_url() {
		
		//$scope	= array( 'r_emailaddress', 'r_basicprofile', 'rw_nus', 'r_network', 'r_contactinfo', 'rw_company_admin', 'rw_groups', 'r_fullprofile', 'w_messages' );
		$scope	= array( 'r_emailaddress', 'r_basicprofile', 'rw_company_admin', 'w_share' );
		
		//load linkedin class
		$linkedin = $this->wpw_auto_poster_load_linkedin();
		
		//check linkedin loaded or not
		if( !$linkedin ) return false;
		
		//Get Linkedin config
		$config	= $this->linkedinconfig;
		
		try {//Prepare login URL
			$preparedurl	= $this->linkedin->getAuthorizeUrl( $config['appKey'], $config['callbackUrl'], $scope );
		} catch( Exception $e ) {
			$preparedurl	= '';
        }
        
		return $preparedurl;
	}
	
	
	/**
	 * Post To LinkedIn
	 * 
	 * Handles to Posting to Linkedin User Wall,
	 * Company Page / Group Posting
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_post_to_linkedin( $post ) {
		
		global $wpw_auto_poster_options;
		
		//meta prefix
		$prefix			= WPW_AUTO_POSTER_META_PREFIX;
		
		//Initilize linkedin posting
		$li_posting		= array();
		
		//load linkedin class
		$linkedin		= $this->wpw_auto_poster_load_linkedin();
		
		//check linkedin loaded or not
		if( !$linkedin ) return false;
		
		//check linkedin authorized session is true or not
		//need to do for linkedin posting code
		if( isset( $_SESSION['wpw_auto_poster_linkedin_oauth']['linkedin']['authorized'] ) 
			&& $_SESSION['wpw_auto_poster_linkedin_oauth']['linkedin']['authorized'] === TRUE ) {
			
			//posting logs data
			$posting_logs_data	= array();
			
			//record logs for linkedin posting
			//$this->logs->wpw_auto_poster_add( 'LinkedIn posting to '.$posting_type.' account begins.' );
			
			$unique	= 'false';
			
			//user data
			$userdata	= get_userdata( $post->post_author );
			$first_name	= $userdata->first_name; //user first name
			$last_name	= $userdata->last_name; //user last name
			
			//published status
			$ispublished	= get_post_meta( $post->ID, $prefix . 'li_status', true );			
			
			//post title
			$posttitle		= $post->post_title;
			
			//custom title from metabox
			$customtitle	= get_post_meta( $post->ID, $prefix . 'li_post_title', true );
			
			//custom title set use it otherwise user posttiel
			$title			= !empty( $customtitle ) ? $customtitle : $posttitle;
			
			//post image
			$postimage		= get_post_meta( $post->ID, $prefix . 'li_post_image', true );
			
			/**************
			 * Image Priority
			 * If metabox image set then take from metabox
			 * If metabox image is not set then take from featured image
			 * If featured image is not set then take from settings page
			 **************/
			
			//get featured image from post / page / custom post type
			$post_featured_img = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
			//check custom image is set in meta and not empty
			if( isset( $postimage['src'] ) && !empty( $postimage['src'] ) ) {
				$postimage = $postimage['src'];
			} elseif ( isset( $post_featured_img[0] ) && !empty( $post_featured_img[0] ) ) {
				//check post featrued image is set the use that image
				$postimage = $post_featured_img[0];
			} else {
				//else get post image from settings page
				$postimage = $wpw_auto_poster_options['li_post_image'];
			}
			
			//post link
			$postlink = get_post_meta( $post->ID, $prefix . 'li_post_link', true );
			$postlink = isset( $postlink ) && !empty( $postlink ) ? $postlink : '';
			//if custom link is set or not
			$customlink = !empty( $postlink ) ? 'true' : 'false';
			
			//do url shortner
			$postlink = $this->model->wpw_auto_poster_get_short_post_link( $postlink, $unique, $post->ID, $customlink, 'li' );
			
			// not sure why this code here it should be above $postlink but lets keep it here
			//if post is published on linkedin once then change url to prevent duplication
			if( isset( $ispublished ) && $ispublished == '1' ) {
				$unique = 'true';
			}
			
			//comments
			$comments = get_post_meta( $post->ID, $prefix . 'li_post_comment', true );
			$comments = !empty( $comments ) ? $comments : '';
			
			//get linkedin posting description
			$description 		= get_post_meta( $post->ID, $prefix . 'li_post_desc', true );
			$description 		= !empty( $description ) ? $description : strip_shortcodes( $post->post_content );
			
			//use 400 character to post to linkedin
			$description 		= $this->model->wpw_auto_poster_excerpt( $description, 400 );
			$description 		= $this->model->wpw_auto_poster_stripslashes_deep( $description, true );
			
			$search_arr 		= array( '{title}', '{link}', '{first_name}' , '{last_name}', '{site_name}' );
			$replace_arr 		= array( $title, $postlink, $first_name, $last_name, get_option( 'blogname') );
			$comments 			= str_replace( $search_arr, $replace_arr, $comments ); 				
			
			//Get title
			$title 				= $this->model->wpw_auto_poster_html_decode( $title );
			//Get comment
			$comments 			= $this->model->wpw_auto_poster_html_decode( $comments );
			
			//Linkedin Profile Data from setting //_wpweb_li_post_profile
			$li_post_profiles 	= get_post_meta( $post->ID, $prefix . 'li_post_profile' );
			
			if( empty( $li_post_profiles ) ) {//If profiles are empty in metabox
				
				$li_post_profiles	= isset( $wpw_auto_poster_options['li_type_'.$post->post_type.'_profile'] ) ? $wpw_auto_poster_options['li_type_'.$post->post_type.'_profile'] : '';
			}
			
			$content = array( 
								'title' 				=> $title,
								'submitted-url'			=> $postlink,
								'comment'				=> $comments,
								'submitted-image-url'	=> $postimage,
								'description'			=> $description
							);

			//posting logs data
			$posting_logs_data = array(	
											'title' 		=> $title,
											'comment' 		=> $comments,
											'link' 			=> $postlink,
											'image' 		=> $postimage,
											'description'	=> $description
										);
			
			//Get all Profiles
			$profile_datas	= $this->wpw_auto_poster_get_profiles_data();
			
			//record logs for linkedin data
			$this->logs->wpw_auto_poster_add( 'LinkedIn post data : ' . var_export( $content, true ) );
			
			//get user profile data
			$user_profile_data	= $this->wpw_auto_poster_get_li_user_data();			
			
			//Initilize all user/company/group data
			$company_data = $group_data = $userwall_data = $display_name_data = $display_id_data = array();
			
			//initial value of posting flag
			$postflg = false;
			
			try {
				if( !empty( $li_post_profiles ) ) {
					
					foreach ( $li_post_profiles as $li_post_profile ) {
						
						//Initilize log user details
						$posting_logs_user_details	= array();
						
						$split_profile	= explode( ':|:', $li_post_profile );
						
						$profile_type	= isset( $split_profile[0] ) ? $split_profile[0] : '';
						$profile_id		= isset( $split_profile[1] ) ? $split_profile[1] : '';
						
						//Linkedin Log user details
						$posting_logs_user_details['account_id'] 			= $profile_id;
						$posting_logs_user_details['linkedin_app_id']		= WPW_AUTO_POSTER_LI_APP_ID;
						$posting_logs_user_details['linkedin_app_secret']	= WPW_AUTO_POSTER_LI_APP_SECRET;
						
						if( $profile_type == 'user' ) { // Check facebook main user data
							
							$user_first_name= isset( $user_profile_data['firstName'] ) ? $user_profile_data['firstName'] : '';
							$user_last_name = isset( $user_profile_data['lastName'] ) ? $user_profile_data['lastName'] : '';
							$user_email		= isset( $user_profile_data['email-address'] ) ? $user_profile_data['email-address'] : '';
							$profile_url 	= isset( $user_profile_data['publicProfileUrl'] ) ? $user_profile_data['publicProfileUrl'] : '';
							$display_name	= $user_first_name . ' ' . $user_last_name;
							
							$posting_logs_user_details['display_name']	= $display_name;
							$posting_logs_user_details['first_name']	= $user_first_name;
							$posting_logs_user_details['last_name']		= $user_last_name;
							$posting_logs_user_details['user_name']		= $user_first_name;
							$posting_logs_user_details['user_email']	= $user_email;
							$posting_logs_user_details['profile_url']	= $profile_url;
							
						} else {
							
							//Account Name
							$posting_logs_user_details['display_name'] = isset( $profile_datas[$li_post_profile] ) ? $profile_datas[$li_post_profile] : '';
						}
						
						switch ( $profile_type ) {
							
							case 'user':
								
								if( !empty( $profile_id ) ) {
									
									$response	= $this->linkedin->shareStatus( $content );
								}
								
								//record logs for linkedin users are not selected
								$this->logs->wpw_auto_poster_add( 'Linked posted to User ID : ' . $profile_id  . '' );
								
								if( !empty( $response['updateKey'] ) ) {
									$postflg	= true;
								}
								
							break;
							
							case 'group':
								
								$response	= $this->linkedin->postToGroup( $profile_id, $title, $description, $content );
								
								//record logs for linkedin users are not selected
								$this->logs->wpw_auto_poster_add( 'Linked posted to Group ID : ' . $profile_id  . '' );
								
								$postflg	= true;
								
								/*if( !empty( $response['updateKey'] ) ) {
									$li_posting['success'] = 1;
								} else {
									$li_posting['fail'] = 1;
								}*/
								
							break;
							
							case 'company':
								
								$response	= $this->linkedin->postToCompany( $profile_id, $title, $content );
								
								//record logs for linkedin group are not selected
								$this->logs->wpw_auto_poster_add( 'Linked posted to Company ID : ' . $profile_id  . '' );
								
								if( !empty( $response['updateKey'] ) ) {
									$postflg	= true;
								}
								
							break;
						}
						
						if( $postflg ) {
							
							//posting logs store into database
							$this->model->wpw_auto_poster_insert_posting_log( $post->ID, 'li', $posting_logs_data, $posting_logs_user_details );
							
							$li_posting['success'] = 1;
							
						} else {
							
							$li_posting['fail'] = 1;
						}
						
					}
				}
			} catch ( Exception $e ) {
				
				//record logs exception generated
				$this->logs->wpw_auto_poster_add( 'LinkedIn posting Exception : ' . $e->__toString() );
				return false;
			}
			
		} else {
			
			//record logs when grant extended permission not set
			$this->logs->wpw_auto_poster_add( 'LinkedIn grant extended permissions not set.' );
		}
		
		return $li_posting;
	}
	
	/**
	 * Get LinkedIn Profiles
	 * 
	 * Function to get LinkedIn profiles
	 * UserWall/Company/Groups
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_get_profiles_data() {
		
		$profiles	= array();
		
		//Get Users Data
		$users		= $this->wpw_auto_poster_get_li_user_data();
		//Get Company Data
		$companies	= $this->wpw_auto_poster_get_company_data();
		//Get Groups Data
		$groups		= $this->wpw_auto_poster_get_group_data();
		
		if( !empty( $users ) ) {//If User Data is not empty
			
			$user_id	= isset( $users['id'] ) ? $users['id'] : '';
			$first_name	= isset( $users['firstName'] ) ? $users['firstName'] : '';
			$last_name	= isset( $users['lastName'] ) ? $users['lastName'] : '';
			
			if( !empty( $user_id ) ) {
				$profiles[ 'user:|:'. $user_id ]	= $first_name.' '.$last_name.' '.'( '. $user_id .' )';
			}
		}
		
		if( !empty( $companies ) ) {//If Company Data is not empty
			
			foreach ( $companies as $company_id => $company_name ) {
				
				$profiles[ 'company:|:'. $company_id ]	= $company_name;
			}
		}
		
		if( !empty( $groups ) ) {//If Group Data is not empty
			
			foreach ( $groups as $group_id => $group_name ) {
				
				$profiles[ 'group:|:'. $group_id ]	= $group_name;
			}
		}
		
		return $profiles;
	}
	
	/**
	 * Get LinkedIn User Data
	 *
	 * Function to get LinkedIn User Data
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_get_li_user_data() {
		
		$user_profile_data = '';
		
		if ( isset( $_SESSION['wpw_auto_poster_li_cache'] ) && !empty( $_SESSION['wpw_auto_poster_li_cache'] ) ) {
		
			$user_profile_data = $_SESSION['wpw_auto_poster_li_cache'];
		}
		
		return $user_profile_data;
	}
	
	/**
	 * Set Session Data of linkedin to session
	 * 
	 * Handles to set user data to session
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_set_li_data_to_session() {
		
		//fetch user data who is grant the premission
		$liuserdata = $this->wpw_auto_poster_get_li_user_data();
		
		if( isset( $liuserdata['id'] ) && !empty( $liuserdata['id'] ) ) {
			
			//record logs for user id
			$this->logs->wpw_auto_poster_add( 'LinkedIn User ID : '.$liuserdata['id'] );
			
			try {
		        
		        $_SESSION['wpw_auto_poster_li_user_id'] = isset( $_SESSION['wpw_auto_poster_li_user_id'] )
					? $_SESSION['wpw_auto_poster_li_user_id'] : $liuserdata['id'];

				$_SESSION['wpw_auto_poster_li_cache']	= isset( $_SESSION['wpw_auto_poster_li_cache'] ) 
					? $_SESSION['wpw_auto_poster_li_cache'] : $liuserdata;
					
				$_SESSION['wpw_auto_poster_li_oauth'] = isset( $_SESSION['wpw_auto_poster_li_oauth'] ) 
					? $_SESSION['wpw_auto_poster_li_oauth'] : $_SESSION['wpw_auto_poster_linkedin_oauth'];
				
				$_SESSION['wpw_auto_poster_li_companies'] = isset( $_SESSION['wpw_auto_poster_li_companies'] ) 
					? $_SESSION['wpw_auto_poster_li_companies'] : '';
				
				$_SESSION['wpw_auto_poster_li_groups'] = isset( $_SESSION['wpw_auto_poster_li_groups'] ) 
					? $_SESSION['wpw_auto_poster_li_groups'] : '';
				
				// start code to manage session from database 			
				$wpw_auto_poster_li_sess_data = get_option( 'wpw_auto_poster_li_sess_data' );
				
				if( empty( $wpw_auto_poster_li_sess_data ) ) {				
					
					$sess_data = array(
											'wpw_auto_poster_li_user_id'	=> $_SESSION['wpw_auto_poster_li_user_id'],
											'wpw_auto_poster_li_cache'		=> $liuserdata,
											'wpw_auto_poster_li_oauth'		=> $_SESSION['wpw_auto_poster_linkedin_oauth'],
											'wpw_auto_poster_li_companies'	=> $_SESSION['wpw_auto_poster_li_companies'],
											'wpw_auto_poster_li_groups'		=> $_SESSION['wpw_auto_poster_li_groups']
										);
					
			      	update_option( 'wpw_auto_poster_li_sess_data', $sess_data );
			      	
			      	//record logs for session data updated to options
					$this->logs->wpw_auto_poster_add( 'Session Data Updated to Options' );
				}
			} catch( Exception $e ) {

		 	  	$liuserdata = null;
			}
		}
	}
	
	/**
	 * Reset Sessions
	 *
	 * Resetting the Linkedin sessions when the admin clicks on
	 * its link within the settings page.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_li_reset_session() {
		
		update_option( 'wpw_auto_poster_li_sess_data', '' );
		
		if( isset( $_SESSION['wpw_auto_poster_li_user_id'] ) ) {//destroy userId session
			unset( $_SESSION['wpw_auto_poster_li_user_id'] );
		}
		if( isset( $_SESSION['wpw_auto_poster_li_cache'] ) ) {//destroy cache
			unset( $_SESSION['wpw_auto_poster_li_cache'] );
		}
		if( isset( $_SESSION['wpw_auto_poster_li_oauth'] ) ) {//destroy oauth
			unset( $_SESSION['wpw_auto_poster_li_oauth'] );
		}
		if( isset( $_SESSION['wpw_auto_poster_li_companies'] ) ) {//destroy company session
			unset( $_SESSION['wpw_auto_poster_li_companies'] );
		}
		if( isset( $_SESSION['wpw_auto_poster_li_groups'] ) ) {//destroy group session
			unset( $_SESSION['wpw_auto_poster_li_groups'] );
		}
		if( isset( $_SESSION['wpw_auto_poster_linkedin_oauth'] ) ) {//destroy linkedin session
			unset( $_SESSION['wpw_auto_poster_linkedin_oauth'] );
		}
	}
	
	/**
	 * LinkedIn Posting
	 * 
	 * Handles to linkedin posting
	 * by post data
	 * 
	 * @package Social Auto Poster
 	 * @since 1.5.0
	 */
	public function wpw_auto_poster_li_posting( $post ) {
		
		global $wpw_auto_poster_options;
		
		$prefix = WPW_AUTO_POSTER_META_PREFIX;

		//record logs for linkedin is enable for posting
		$this->logs->wpw_auto_poster_add( 'Posting is enabled' );
		
		$res = $this->wpw_auto_poster_post_to_linkedin( $post );
		
		if( isset( $res['success'] ) && !empty( $res['success'] ) ) { //check if error should not occured and successfully tweeted
			
			//record logs for posting done on linkedin
			$this->logs->wpw_auto_poster_add( 'LinkedIn posting completed successfully.' );
			
			update_post_meta( $post->ID, $prefix . 'li_status', '1' );
			return true;
		}
		
		return false;
	}
	
	/** 
	 * Linkedin Get Company Data
	 * 
	 * @package Social Auto Poster
	 * @since 1.5.0
	 */
	public function wpw_auto_poster_get_company_data() {
		
		//Initilize company array
		$company_data	= array();
		
		if( isset($_SESSION['wpw_auto_poster_li_companies'] ) ) {
			
			$company_data	= $_SESSION['wpw_auto_poster_li_companies'];
		} else {
			
			//Load linkedin class
			$this->wpw_auto_poster_load_linkedin();
			
			if( !empty( $this->linkedin ) ) { //If linkedin object is found
				
				//Get companies data
				$results	= $this->linkedin->getAdminCompanies();
				
				//Companies data
				$companies	= isset( $results['values'] ) ? $results['values'] : array();
				
				if( !empty( $companies ) ) {//If company data is not empty
					foreach ( $companies as $company ) {
						
						//if( !empty( $company['company'] ) ) {
							//Get company Id
							$company_array_id	= isset( $company['id'] ) ? $company['id'] : '';
							//Get company name
							$company_array_name	= isset( $company['name'] ) ? $company['name'] : '';
							
							//If company Id not found
							if( !empty( $company_array_id ) ) {
								$company_data[$company_array_id]	= $company_array_name;
							}
						//}
					}
				}
			}
		}
		
		return $company_data;
	}
		
	/** 
	 * Linkedin Get Group Data
	 * 
	 * @package Social Auto Poster
	 * @since 1.5.0
	 */
	public function wpw_auto_poster_get_group_data() { 
		
		//Initilize group array
		$group_data	= array();
		
		if( isset($_SESSION['wpw_auto_poster_li_groups'] ) ) {
			
			$group_data	= $_SESSION['wpw_auto_poster_li_groups'];
			
		} else {
			
			//Load linkedin class
			$this->wpw_auto_poster_load_linkedin();
			
			if( !empty( $this->linkedin ) ) { //If linkedin object is found
				
				//Get groups data
				$results	= $this->linkedin->getGroups();
				
				$groups		= isset( $results['values'] ) ? $results['values'] : array();
				
				if( !empty( $groups ) ) {//If groups is not empty
					
					foreach ( $groups as $group ) {
						
						//Get code is owner/member
						$membershipState = isset( $group['membershipState']['code'] ) ? $group['membershipState']['code'] : '';
						
						if( $membershipState == 'owner' ) {//If group owner
							//Get group Id
							$group_id	= isset( $group['_key'] ) ? $group['_key'] : '';
							//Get group name
							$group_name	= isset( $group['group']['name'] ) ? $group['group']['name'] : '';
							
							if( !empty( $group_id ) ) {//Group id is not empty
								$group_data[$group_id]	= $group_name;
							}
						}
					}
				}
			}
		}
		
		return $group_data;
	}
}