<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Misc Functions
 * 
 * 
 * @package Social Auto Poster
 * @since 1.0.0
 */

/**
 * Get Settings From Option Page
 * 
 * Handles to return all settings value
 * 
 * @package Social Auto Poster
 * @since 1.0.0
 */
function wpw_auto_poster_settings() {
	
	$settings = is_array(get_option('wpw_auto_poster_options')) ? get_option('wpw_auto_poster_options') : array();
	
	return $settings;
}

/**
 * Initialize some intial setup
 * 
 * @package Social Auto Poster
 * @since 1.0.0
 */
function wpw_auto_poster_initialize() {
	
	global $wpw_auto_poster_options;
	
	//Facebook Application ID and Secret
	$fb_app_id = isset( $wpw_auto_poster_options[ 'fb_app_id' ] ) ? $wpw_auto_poster_options[ 'fb_app_id' ] : '';
	$fb_app_secret = isset( $wpw_auto_poster_options[ 'fb_app_secret' ] ) ? $wpw_auto_poster_options[ 'fb_app_secret' ] : '';
	
	if( !defined( 'WPW_AUTO_POSTER_FB_APP_ID' ) ) {
		define( 'WPW_AUTO_POSTER_FB_APP_ID', $fb_app_id );
	}
	if( !defined( 'WPW_AUTO_POSTER_FB_APP_SECRET' ) ) {
		define( 'WPW_AUTO_POSTER_FB_APP_SECRET', $fb_app_secret );
	}
	
	// Defining the session variables
	if( !defined( 'WPW_AUTO_POSTER_FB_SESS1' ) ) {
		define( 'WPW_AUTO_POSTER_FB_SESS1', 'fb_'.WPW_AUTO_POSTER_FB_APP_ID.'_code' );
	}
	if( !defined( 'WPW_AUTO_POSTER_FB_SESS2' ) ) {
		define( 'WPW_AUTO_POSTER_FB_SESS2', 'fb_'.WPW_AUTO_POSTER_FB_APP_ID.'_access_token' );
	}
	if( !defined( 'WPW_AUTO_POSTER_FB_SESS3' ) ) {
		define( 'WPW_AUTO_POSTER_FB_SESS3', 'fb_'.WPW_AUTO_POSTER_FB_APP_ID.'_user_id' );
	}
	if( !defined( 'WPW_AUTO_POSTER_FB_SESS4' ) ) {
		define( 'WPW_AUTO_POSTER_FB_SESS4', 'fb_'.WPW_AUTO_POSTER_FB_APP_ID.'_state' );
	}
	
	//Twitter Consumer Key and Secret
	$tw_consumer_key = isset( $wpw_auto_poster_options['twitter_keys'] ) && isset( $wpw_auto_poster_options['twitter_keys']['0'] ) ? $wpw_auto_poster_options['twitter_keys']['0']['consumer_key'] : '';
	$tw_consumer_secret = isset( $wpw_auto_poster_options['twitter_keys'] ) && isset( $wpw_auto_poster_options['twitter_keys']['0'] ) ? $wpw_auto_poster_options['twitter_keys']['0']['consumer_secret'] : '';
	$tw_auth_token = isset( $wpw_auto_poster_options['twitter_keys'] ) && isset( $wpw_auto_poster_options['twitter_keys']['0'] ) ? $wpw_auto_poster_options['twitter_keys']['0']['oauth_token'] : '';
	$tw_auth_token_secret = isset( $wpw_auto_poster_options['twitter_keys'] ) && isset( $wpw_auto_poster_options['twitter_keys']['0'] ) ? $wpw_auto_poster_options['twitter_keys']['0']['oauth_secret'] : '';
	
	if( !defined( 'WPW_AUTO_POSTER_TW_CONS_KEY' ) ) {
		define( 'WPW_AUTO_POSTER_TW_CONS_KEY', $tw_consumer_key );
	}
	if( !defined( 'WPW_AUTO_POSTER_TW_CONS_SECRET' ) ) {
		define( 'WPW_AUTO_POSTER_TW_CONS_SECRET', $tw_consumer_secret );
	}
	if( !defined( 'WPW_AUTO_POSTER_TW_AUTH_TOKEN' ) ) {
		define( 'WPW_AUTO_POSTER_TW_AUTH_TOKEN', $tw_auth_token );
	}
	if( !defined( 'WPW_AUTO_POSTER_TW_AUTH_SECRET' ) ) {
		define( 'WPW_AUTO_POSTER_TW_AUTH_SECRET', $tw_auth_token_secret );
	}
	
	//LinkedIn Consumer Key and Secret
	$li_app_id = isset( $wpw_auto_poster_options[ 'linkedin_app_id'] ) ? $wpw_auto_poster_options[ 'linkedin_app_id'] : '';
	$li_app_secret = isset( $wpw_auto_poster_options[ 'linkedin_app_secret'] ) ? $wpw_auto_poster_options[ 'linkedin_app_secret'] : '';
	
	if( !defined( 'WPW_AUTO_POSTER_LI_APP_ID' ) ) {
		define( 'WPW_AUTO_POSTER_LI_APP_ID', $li_app_id);
	}
	if( !defined( 'WPW_AUTO_POSTER_LI_APP_SECRET' ) ) {
		define( 'WPW_AUTO_POSTER_LI_APP_SECRET', $li_app_secret );
	}
	if( !defined( 'WPW_AUTO_POSTER_LINKEDIN_PORT_HTTP' ) ) { //http port value
	 	define( 'WPW_AUTO_POSTER_LINKEDIN_PORT_HTTP', '80' );
	}
	if( !defined( 'WPW_AUTO_POSTER_LINKEDIN_PORT_HTTP_SSL' ) ) { //ssl port value
	  	define( 'WPW_AUTO_POSTER_LINKEDIN_PORT_HTTP_SSL', '443' );
	}
	
	//Tumblr Consumer Key and Secret
	$tb_consumer_key = isset( $wpw_auto_poster_options[ 'tumblr_consumer_key' ] ) ? $wpw_auto_poster_options[ 'tumblr_consumer_key' ] : '';
	$tb_consumer_secret = isset( $wpw_auto_poster_options[ 'tumblr_consumer_secret' ] ) ? $wpw_auto_poster_options[ 'tumblr_consumer_secret' ] : '';
	
	if( !defined( 'WPW_AUTO_POSTER_TB_CONS_KEY' ) ) {
		define( 'WPW_AUTO_POSTER_TB_CONS_KEY', $tb_consumer_key );
	}
	if( !defined( 'WPW_AUTO_POSTER_TB_CONS_SECRET' ) ) {
		define( 'WPW_AUTO_POSTER_TB_CONS_SECRET', $tb_consumer_secret );
	}
	
	//Delicious Username and password
	$delicious_username = isset( $wpw_auto_poster_options[ 'delicious_username' ] ) ? $wpw_auto_poster_options[ 'delicious_username' ] : '';
	$delicious_password = isset( $wpw_auto_poster_options[ 'delicious_password' ] ) ? $wpw_auto_poster_options[ 'delicious_password' ] : '';
	
	if( !defined( 'WPW_AUTO_POSTER_DC_USERNAME' ) ) {
		define( 'WPW_AUTO_POSTER_DC_USERNAME', $delicious_username );
	}
	if( !defined( 'WPW_AUTO_POSTER_DC_PASSWORD' ) ) {
		define( 'WPW_AUTO_POSTER_DC_PASSWORD', base64_decode( $delicious_password ) );
	}
	
	//BufferApp Client id and secret
	$ba_client_id = isset( $wpw_auto_poster_options[ 'bufferapp_client_id' ] ) ? $wpw_auto_poster_options['bufferapp_client_id'] : '';
	$ba_client_secret = isset( $wpw_auto_poster_options['bufferapp_client_secret' ] ) ? $wpw_auto_poster_options['bufferapp_client_secret'] : '';
	
	if( !defined( 'WPW_AUTO_POSTER_BA_CLIENT_ID' ) ) {
		define( 'WPW_AUTO_POSTER_BA_CLIENT_ID', $ba_client_id );
	}
	if( !defined( 'WPW_AUTO_POSTER_BA_CLIENT_SECRET' ) ) {
		define( 'WPW_AUTO_POSTER_BA_CLIENT_SECRET', $ba_client_secret );
	}
}