<?php
/**
 * Plugin Name: Social Auto Poster (shared on wplocker.com)
 * Plugin URI: http://www.wpweb.co.in/
 * Description: Social Auto Poster lets you automatically post all your content to several different social networks.
 * Version: 1.7.8
 * Author: WPWeb
 * Author URI: http://www.wpweb.co.in/
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Basic Plugin Definitions 
 * 
 * @package Social Auto Poster
 * @since 1.0.0
 */
if( !defined( 'WPW_AUTO_POSTER_VERSION' ) ) {
	define( 'WPW_AUTO_POSTER_VERSION', '1.7.8' ); //version of plugin
}
if( !defined( 'wpwautoposterlevel' ) ) {
	//specify the user's role capabilites who can access this plugins settings in backend
	//for more informatioon please check  http://codex.wordpress.org/Roles_and_Capabilities
	define( 'wpwautoposterlevel','manage_options'); //administrator role can use this plugin
}
if( !defined( 'WPW_AUTO_POSTER_DIR' ) ) {
	define( 'WPW_AUTO_POSTER_DIR', dirname( __FILE__ ) ); // plugin dir
}
if( !defined( 'WPW_AUTO_POSTER_URL' ) ) {
	define( 'WPW_AUTO_POSTER_URL', plugin_dir_url( __FILE__ ) ); // plugin url
}   
if( !defined( 'WPW_AUTO_POSTER_IMG_URL' ) ) {
	define( 'WPW_AUTO_POSTER_IMG_URL', WPW_AUTO_POSTER_URL . 'includes/images' ); // plugin image url
}   
if( !defined( 'WPW_AUTO_POSTER_ADMIN' ) ) {
	define( 'WPW_AUTO_POSTER_ADMIN', WPW_AUTO_POSTER_DIR . '/includes/admin' ); // plugin admin dir
}
if( !defined( 'WPW_AUTO_POSTER_META_DIR' ) ) {
	define( 'WPW_AUTO_POSTER_META_DIR', WPW_AUTO_POSTER_DIR . '/includes/meta-boxes' ); // path to meta boxes
}
if( !defined( 'WPW_AUTO_POSTER_META_URL' ) ) {
	define( 'WPW_AUTO_POSTER_META_URL', WPW_AUTO_POSTER_URL . 'includes/meta-boxes' ); // path to meta boxes
}
if( !defined( 'WPW_AUTO_POSTER_SOCIAL_DIR' ) ) {
	define( 'WPW_AUTO_POSTER_SOCIAL_DIR', WPW_AUTO_POSTER_DIR . '/includes/social/libraries' ); // path to meta boxes
}
if( !defined( 'WPW_AUTO_POSTER_TITLE_PREFIX' )) {
	define( 'WPW_AUTO_POSTER_TITLE_PREFIX', 'WPWeb' );
}
if( !defined( 'WPW_AUTO_POSTER_META_PREFIX' )) {
	define( 'WPW_AUTO_POSTER_META_PREFIX', '_wpweb_' ); //metabox prefix
}
if( !defined( 'WPW_AUTO_POSTER_LOGS_POST_TYPE' )) {
	define( 'WPW_AUTO_POSTER_LOGS_POST_TYPE', 'wpwautoposterlogs' ); //social posting logs post type
}
if ( ! defined( 'WPW_AUTO_POSTER_LOG_DIR' ) ) {
	define( 'WPW_AUTO_POSTER_LOG_DIR', ABSPATH . 'sap-logs/' );
}
if ( ! defined( 'WPW_AUTO_POSTER_PLUGIN_KEY' ) ) {
	define( 'WPW_AUTO_POSTER_PLUGIN_KEY', 'sap' );
}
if( !defined( 'WPW_AUTO_POSTER_BASENAME' ) ) {
	define( 'WPW_AUTO_POSTER_BASENAME', basename( WPW_AUTO_POSTER_DIR ) ); // base name
}

// Required Wpweb updater functions file
if ( ! function_exists( 'wpweb_updater_install' ) ) {
	require_once( 'includes/wpweb-upd-functions.php' );
}

/**
 * Load Text Domain
 * 
 * This gets the plugin ready for translation.
 * 
 * @package Social Auto Poster
 * @since 1.7.5
 */
function wpw_auto_poster_plugins_loaded() {
	
	// Set filter for plugin's languages directory
	$wpw_auto_poster_lang_dir	= dirname( plugin_basename( __FILE__ ) ) . '/languages/';
	$wpw_auto_poster_lang_dir	= apply_filters( 'wpw_auto_poster_languages_directory', $wpw_auto_poster_lang_dir );
	
	// Traditional WordPress plugin locale filter
	$locale	= apply_filters( 'plugin_locale',  get_locale(), 'wpwautoposter' );
	$mofile	= sprintf( '%1$s-%2$s.mo', 'wpwautoposter', $locale );
	
	// Setup paths to current locale file
	$mofile_local	= $wpw_auto_poster_lang_dir . $mofile;
	$mofile_global	= WP_LANG_DIR . '/' . WPW_AUTO_POSTER_BASENAME . '/' . $mofile;
	
	if ( file_exists( $mofile_global ) ) { // Look in global /wp-content/languages/social-auto-poster folder
		load_textdomain( 'wpwautoposter', $mofile_global );
	} elseif ( file_exists( $mofile_local ) ) { // Look in local /wp-content/plugins/social-auto-poster/languages/ folder
		load_textdomain( 'wpwautoposter', $mofile_local );
	} else { // Load the default language files
		load_plugin_textdomain( 'wpwautoposter', false, $wpw_auto_poster_lang_dir );
	}
}
add_action( 'plugins_loaded', 'wpw_auto_poster_plugins_loaded' );

/**
 * Activation Hook
 *
 * Register plugin activation hook.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
register_activation_hook( __FILE__, 'wpw_auto_poster_install' );

/**
 * Plugin Setup (On Activation)
 *
 * Does the initial setup, creates tables in the database and
 * stest default values for the plugin options.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
function wpw_auto_poster_install() {

	global $wpdb;
	
	// Cron jobs
	wp_clear_scheduled_hook( 'wpw_auto_poster_scheduled_cron' );
	
	//get plugin options from database
	$wpw_auto_poster_options = get_option( 'wpw_auto_poster_options' );
	
	//get option for when plugin is activating first time
	$wpw_auto_poster_set_option = get_option( 'wpw_auto_poster_set_option' );
	
	//check auto poster options is empty or not
	if( empty( $wpw_auto_poster_options ) ) {
		
		//set default settings of social auto poster
		wpw_auto_posting_default_settings();
		
		//update plugin version to option 
		update_option( 'wpw_auto_poster_set_option', '1.0' );
	}
	
	//check set option for plugin is set 1.0
	if( $wpw_auto_poster_set_option == '1.0' ) {
		
		$udpopt = false;
		
		if( !isset( $wpw_auto_poster_options['enable_logs'] ) ) { //check enable logs is not set
			$enable_logs = array( 'enable_logs' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $enable_logs );
			$udpopt = true;
		}
		//check url shortener facebook
		if( !isset( $wpw_auto_poster_options['fb_url_shortener'] ) ) {
			$fb_url_shortener = array( 'fb_url_shortener' => 'wordpress' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $fb_url_shortener );
			$udpopt = true;
		}
		
		//check url facebook bitly user name
		if( !isset( $wpw_auto_poster_options['fb_bitly_username'] ) ) {
			$fb_bitly_username = array( 'fb_bitly_username' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $fb_bitly_username );
			$udpopt = true;
		}
		
		//check url facebook bitly api key
		if( !isset( $wpw_auto_poster_options['fb_bitly_api_key'] ) ) {
			$fb_bitly_api_key = array( 'fb_bitly_api_key' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $fb_bitly_api_key );
			$udpopt = true;
		}
		
		//check url shortener twitter
		if( !isset( $wpw_auto_poster_options['tw_url_shortener'] ) ) {
			$tw_url_shortener = array( 'tw_url_shortener' => 'wordpress' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $tw_url_shortener );
			$udpopt = true;
		}
		
		//check url twitter bitly user name
		if( !isset( $wpw_auto_poster_options['tw_bitly_username'] ) ) {
			$tw_bitly_username = array( 'tw_bitly_username' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $tw_bitly_username );
			$udpopt = true;
		}
		
		//check url twitter bitly api key
		if( !isset( $wpw_auto_poster_options['tw_bitly_api_key'] ) ) {
			$tw_bitly_api_key = array( 'tw_bitly_api_key' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $tw_bitly_api_key );
			$udpopt = true;
		}
		
		//check url shortener linkedin
		if( !isset( $wpw_auto_poster_options['li_url_shortener'] ) ) {
			$li_url_shortener = array( 'li_url_shortener' => 'wordpress' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $li_url_shortener );
			$udpopt = true;
		}
		
		//check url linkedin bitly user name
		if( !isset( $wpw_auto_poster_options['li_bitly_username'] ) ) {
			$li_bitly_username = array( 'li_bitly_username' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $li_bitly_username );
			$udpopt = true;
		}
		
		//check url linkedin bitly api key
		if( !isset( $wpw_auto_poster_options['li_bitly_api_key'] ) ) {
			$li_bitly_api_key = array( 'li_bitly_api_key' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $li_bitly_api_key );
			$udpopt = true;
		}
		
		if( $udpopt == true ) { // if any of the settings need to be updated 				
			update_option( 'wpw_auto_poster_options', $wpw_auto_poster_options );
		}
		
		//update plugin version to option 
		update_option( 'wpw_auto_poster_set_option', '1.0.1' );
		
	} //check plugin set option value is 1.0
	
	//get option for when plugin is activating first time
	$wpw_auto_poster_set_option = get_option( 'wpw_auto_poster_set_option' );
	
	//check set option for plugin is set 1.0.1
	if( $wpw_auto_poster_set_option == '1.0.1' ) { 
		
		$udpopt = false;
		
		//Tumblr settings
		if( !isset( $wpw_auto_poster_options['enable_tumblr'] ) ) { //check enable tumblr is not set
			$enable_tumblr = array( 'enable_tumblr' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $enable_tumblr );
			$udpopt = true;
		}
		//check enable tumblr for is not set
		if( !isset( $wpw_auto_poster_options['enable_tumblr_for'] ) ) {
			$enable_tumblr_for = array( 'enable_tumblr_for' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $enable_tumblr_for );
			$udpopt = true;
		}
		//check content type of tumblr is not set
		if( !isset( $wpw_auto_poster_options['tumblr_content_type'] ) ) {
			$tumblr_content_type = array( 'tumblr_content_type' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $tumblr_content_type );
			$udpopt = true;
		}
		//check url shortener tumblr
		if( !isset( $wpw_auto_poster_options['tb_url_shortener'] ) ) {
			$tb_url_shortener = array( 'tb_url_shortener' => 'wordpress' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $tb_url_shortener );
			$udpopt = true;
		}
		//check url tumblr bitly user name
		if( !isset( $wpw_auto_poster_options['tb_bitly_username'] ) ) {
			$tb_bitly_username = array( 'tb_bitly_username' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $tb_bitly_username );
			$udpopt = true;
		}
		//check url tumblr bitly api key
		if( !isset( $wpw_auto_poster_options['tb_bitly_api_key'] ) ) {
			$tb_bitly_api_key = array( 'tb_bitly_api_key' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $tb_bitly_api_key );
			$udpopt = true;
		}
		//check consumer key is not set
		if( !isset( $wpw_auto_poster_options['tumblr_consumer_key'] ) ) {
			$tumblr_consumer_key = array( 'tumblr_consumer_key' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $tumblr_consumer_key );
			$udpopt = true;
		}
		//check consumer secret is not set
		if( !isset( $wpw_auto_poster_options['tumblr_consumer_secret'] ) ) { 
			$tumblr_consumer_secret = array( 'tumblr_consumer_secret' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $tumblr_consumer_secret );
			$udpopt = true;
		}
		
		//Delicious settings
		if( !isset( $wpw_auto_poster_options['enable_delicious'] ) ) { //check enable delicious is not set
			$enable_delicious = array( 'enable_delicious' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $enable_delicious );
			$udpopt = true;
		}
		//check enable delicious for is not set
		if( !isset( $wpw_auto_poster_options['enable_delicious_for'] ) ) {
			$enable_delicious_for = array( 'enable_delicious_for' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $enable_delicious_for );
			$udpopt = true;
		}
		//check url shortener delicious
		if( !isset( $wpw_auto_poster_options['dc_url_shortener'] ) ) {
			$dc_url_shortener = array( 'dc_url_shortener' => 'wordpress' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $dc_url_shortener );
			$udpopt = true;
		}
		//check url delicious bitly user name
		if( !isset( $wpw_auto_poster_options['dc_bitly_username'] ) ) {
			$dc_bitly_username = array( 'dc_bitly_username' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $dc_bitly_username );
			$udpopt = true;
		}
		//check url delicious bitly api key
		if( !isset( $wpw_auto_poster_options['dc_bitly_api_key'] ) ) {
			$dc_bitly_api_key = array( 'dc_bitly_api_key' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $dc_bitly_api_key );
			$udpopt = true;
		}
		//check username is set or not
		if( !isset( $wpw_auto_poster_options['delicious_username'] ) ) {
			$delicious_username = array( 'delicious_username' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $delicious_username );
			$udpopt = true;
		}
		//check password set or not
		if( !isset( $wpw_auto_poster_options['delicious_password'] ) ) { 
			$delicious_password = array( 'delicious_password' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $delicious_password );
			$udpopt = true;
		}
		
		//bufferapp settings
		if( !isset( $wpw_auto_poster_options['enable_bufferapp'] ) ) { //check enable bufferapp is not set
			$enable_bufferapp = array( 'enable_bufferapp' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $enable_bufferapp );
			$udpopt = true;
		}
		//check enable bufferapp for is not set
		if( !isset( $wpw_auto_poster_options['enable_bufferapp_for'] ) ) {
			$enable_bufferapp_for = array( 'enable_bufferapp_for' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $enable_bufferapp_for );
			$udpopt = true;
		}
		//check bufferapp url shortner is not set 
		if( !isset( $wpw_auto_poster_options['ba_url_shortener'] ) ) {
			$ba_url_shortener = array( 'ba_url_shortener' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $ba_url_shortener );
			$udpopt = true;
		}
		//check bufferapp bitly username is not set 
		if( !isset( $wpw_auto_poster_options['ba_bitly_username'] ) ) {
			$ba_bitly_username = array( 'ba_bitly_username' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $ba_bitly_username );
			$udpopt = true;
		}
		//check bufferapp bitly api key is not set 
		if( !isset( $wpw_auto_poster_options['ba_bitly_api_key'] ) ) {
			$ba_bitly_api_key = array( 'ba_bitly_api_key' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $ba_bitly_api_key );
			$udpopt = true;
		}
		//check bufferapp client secter is set or not
		if( !isset( $wpw_auto_poster_options['bufferapp_client_secret'] ) ) {
			$bufferapp_client_secret = array( 'bufferapp_client_secret' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $bufferapp_client_secret );
			$udpopt = true;
		}
		//check bufferapp clientid set or not
		if( !isset( $wpw_auto_poster_options['bufferapp_client_id'] ) ) { 
			$bufferapp_client_id = array( 'bufferapp_client_id' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $bufferapp_client_id );
			$udpopt = true;
		}
		//check bufferapp post image
		if( !isset( $wpw_auto_poster_options['ba_post_img'] ) ) { 
			$ba_post_img = array( 'ba_post_img' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $ba_post_img );
			$udpopt = true;
		}
		
		if( $udpopt == true ) { // if any of the settings need to be updated 				
			update_option( 'wpw_auto_poster_options', $wpw_auto_poster_options );
		}
		
		//update plugin version to option 
		update_option( 'wpw_auto_poster_set_option', '1.0.2' );
		
	} //check plugin set option value is 1.0.1
	
	//get option for when plugin is activating first time
	$wpw_auto_poster_set_option = get_option( 'wpw_auto_poster_set_option' );
	
	//check set option for plugin is set 1.0.2
	if( $wpw_auto_poster_set_option == '1.0.2' ) {
		
		$udpopt = false;
		
		if( !isset( $wpw_auto_poster_options['enable_posting_logs'] ) ) { //check enable posting logs is not set
			$enable_posting_logs = array( 'enable_posting_logs' => '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $enable_posting_logs );
			$udpopt = true;
		}
		
		if( isset( $wpw_auto_poster_options['twitter_consumer_key'] ) && isset( $wpw_auto_poster_options['twitter_consumer_secret'] )
			&& isset( $wpw_auto_poster_options['twitter_oauth_token'] ) && isset( $wpw_auto_poster_options['twitter_oauth_secret'] ) ) { //check twitter consumer key is set
			
			//Twitter Posting Class
			require_once( WPW_AUTO_POSTER_DIR . '/includes/social/class-wpw-auto-poster-tw-posting.php' ); // twitter posting class
			$wpw_auto_poster_tw_posting = new Wpw_Auto_Poster_TW_Posting();

			$twitter_keys_data = array(
											'consumer_key' 		=> $wpw_auto_poster_options['twitter_consumer_key'],
											'consumer_secret' 	=> $wpw_auto_poster_options['twitter_consumer_secret'],
											'oauth_token' 		=> $wpw_auto_poster_options['twitter_oauth_token'],
											'oauth_secret' 		=> $wpw_auto_poster_options['twitter_oauth_secret'],
										);
			
			$twitter_keys = array( 'twitter_keys' => array( $twitter_keys_data ) );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $twitter_keys );
			
			$tw_account_details = array();
			$user_profile_data = $wpw_auto_poster_tw_posting->wpw_auto_poster_get_user_data( $twitter_keys_data['consumer_key'], $twitter_keys_data['consumer_secret'], $twitter_keys_data['oauth_token'], $twitter_keys_data['oauth_secret'] );
			if( !empty( $user_profile_data ) ) { // Check user data are not empty
				
				if( isset( $user_profile_data->name ) && !empty( $user_profile_data->name ) ) { // Check user name is not empty
					
					$tw_account_details['1'] = $user_profile_data->name;
					
					$types = get_post_types( array( 'public'=>true ), 'objects' );
					$types = is_array( $types ) ? $types : array();
					
					foreach( $types as $type ) {
										
						if( !is_object( $type ) ) continue;
						
						$tw_type_user = array( 'tw_type_' . $type->name . '_user' => array( '1' ) );
						$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $tw_type_user );
					}
				}
			}
			
			//Update twitter acoount details
			update_option( 'wpw_auto_poster_tw_account_details', $tw_account_details );
			
			$udpopt = true;
		}
		
		if( $udpopt == true ) { // if any of the settings need to be updated 				
			update_option( 'wpw_auto_poster_options', $wpw_auto_poster_options );
		}
		
		//update plugin version to option 
		update_option( 'wpw_auto_poster_set_option', '1.0.3' );
		
	} //check plugin set option value is 1.0.2
	
	//get option for when plugin is activating first time
	$wpw_auto_poster_set_option = get_option( 'wpw_auto_poster_set_option' );
	
	//check set option for plugin is set 1.0.3
	if( $wpw_auto_poster_set_option == '1.0.3' ) {
		
		$udpopt = false;
			
		if( !isset( $wpw_auto_poster_options['schedule_wallpost_option'] ) ) { //check Schedule WallPost is set or not
			$schedule_wallpost_option = array('schedule_wallpost_option'=> '' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $schedule_wallpost_option );
			$udpopt = true;
		}
		
		if( !isset( $wpw_auto_poster_options['schedule_wallpost_time'] ) ) { //check Schedule Time is set or not
			$schedule_wallpost_time = array('schedule_wallpost_time'=> '0' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $schedule_wallpost_time );
			$udpopt = true;
		}
		
		if( $udpopt == true ) { // if any of the settings need to be updated 				
			update_option( 'wpw_auto_poster_options', $wpw_auto_poster_options );
		}
		
		//update plugin version to option 
		update_option( 'wpw_auto_poster_set_option', '1.0.4' );
		
	} //check plugin set option value is 1.0.3
	
	//get option for when plugin is activating first time
	$wpw_auto_poster_set_option = get_option( 'wpw_auto_poster_set_option' );
	
	//check set option for plugin is set 1.0.4
	if( $wpw_auto_poster_set_option == '1.0.4' ) {
		
		$udpopt = false;
			
		if( !isset( $wpw_auto_poster_options['schedule_wallpost_minute'] ) ) { //check Schedule Time is set or not
			$schedule_wallpost_minute = array('schedule_wallpost_minute'=> '0' );
			$wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $schedule_wallpost_minute );
			$udpopt = true;
		}
		
		if( $udpopt == true ) { // if any of the settings need to be updated 				
			update_option( 'wpw_auto_poster_options', $wpw_auto_poster_options );
		}
		
		//update plugin version to option 
		update_option( 'wpw_auto_poster_set_option', '1.0.5' );
		
	} //check plugin set option value is 1.0.4
	
	//get option for when plugin is activating first time
	$wpw_auto_poster_set_option = get_option( 'wpw_auto_poster_set_option' );
	
	//Change Log file Dir and create directory on activation
	wpw_auto_poster_create_files();
	
	//check set option for plugin is set 1.0.5
	if( $wpw_auto_poster_set_option == '1.0.5' ) {
		
		// future code will be done here
		
	} //check plugin set option value is 1.0.5
	
}

/**
 * Deactivation Hook
 *
 * Register plugin deactivation hook.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
register_deactivation_hook( __FILE__, 'wpw_auto_poster_uninstall' );

/**
 * Plugin Setup (On Deactivation)
 *
 * Deletes all the plugin options if the user has
 * set the option to do that.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
function wpw_auto_poster_uninstall() {

	global $wpdb;
	
	$wpw_auto_poster_options = get_option( 'wpw_auto_poster_options' );
	
	if( isset( $wpw_auto_poster_options['delete_options'] ) && !empty( $wpw_auto_poster_options['delete_options'] ) && $wpw_auto_poster_options['delete_options'] == '1') {
		
		//facebook posting class
		$fbposting = new Wpw_Auto_Poster_FB_Posting();
		//linkedin posting class
		$liposting = new Wpw_Auto_Poster_Li_Posting();
		//tumblr posting class
		$tbposting = new Wpw_Auto_Poster_TB_Posting();
		//bufferapp posting class
		$baposting = new Wpw_Auto_Poster_BA_Posting();
		
		//facebook session reset
		$fbposting->wpw_auto_poster_fb_reset_session();
		//linkedin session reset
		$liposting->wpw_auto_poster_li_reset_session();
		//tumblr session reset
		$tbposting->wpw_auto_poster_tb_reset_session();
		//bufferapp session reset
		$baposting->wpw_auto_poster_ba_reset_session();
		
		//delete auto poster options
		delete_option( 'wpw_auto_poster_options' );
		//deleter facebook session data
		delete_option( 'wpw_auto_poster_fb_sess_data' );
		//delete linkedin session data
		delete_option( 'wpw_auto_poster_li_sess_data' );
		//delete tumblr session data
		delete_option( 'wpw_auto_poster_tb_sess_data' );
		//delete bufferapp session data
		delete_option( 'wpw_auto_poster_ba_sess_data' );
		//delete twitter account data
		delete_option( 'wpw_auto_poster_tw_account_details' );
		//delete set option data
		delete_option( 'wpw_auto_poster_set_option' );
		
		// delete custom post type data
		$post_types = array( WPW_AUTO_POSTER_LOGS_POST_TYPE );
		
		foreach ( $post_types as $post_type ) {
			$args = array( 'post_type' => $post_type, 'post_status' => 'any', 'numberposts' => '-1' );
			$all_posts = get_posts( $args );
			foreach ( $all_posts as $post ) {
				wp_delete_post( $post->ID, true);
			}
		}
	}
}

/**
 * Default Settings
 *
 * Defining the default values for the plugin options.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
function wpw_auto_posting_default_settings() {

	global $wpw_auto_poster_options;
	
	//default values
	$wpw_auto_poster_options = array(
		//General Settings
		'delete_options'					=> '',
		'bitly_username'					=> '',
		'bitly_api_key'						=> '',
		'enable_logs'						=> '',
		'enable_posting_logs'				=> '',
		//Facebook Settings
		'enable_facebook'					=> '',
		'enable_facebook_for'				=> '',
		'fb_url_shortener'					=> 'wordpress',
		'fb_bitly_username'					=> '',
		'fb_bitly_api_key'					=> '',
		'fb_app_id'							=> '',
		'fb_app_secret'						=> '',
		'prevent_linked_accounts_access'	=> '',
		'prevent_post_metabox'				=> '',
		'prevent_post_tw_metabox'			=> '',
		'prevent_post_li_metabox'			=> '',
		'prevent_post_tb_metabox'			=> '',
		'prevent_post_dc_metabox'			=> '',
		'prevent_post_ba_metabox'			=> '',
		'fb_custom_img'						=> '',
		'custom_status_msg'					=> __( 'New blog post:', 'wpwautoposter' ) . '  {title} - {link}',
		//Twitter Settings
		'enable_twitter'					=> '',
		'enable_twitter_for'				=> '',
		'tw_url_shortener'					=> 'wordpress',
		'tw_bitly_username'					=> '',
		'tw_bitly_api_key'					=> '',
		'twitter_keys'						=> '',
		'tw_tweet_template'					=> 'title_link',
		'tw_custom_tweet_template'			=> '',
		//LinkedIn Settings
		'enable_linkedin'					=> '',
		'enable_linkedin_for'				=> '',
		'li_url_shortener'					=> 'wordpress',
		'li_bitly_username'					=> '',
		'li_bitly_api_key'					=> '',
		'linkedin_app_id'					=> '',
		'linkedin_app_secret'				=> '',
		'li_post_image'						=> '',
		//Tumblr settting
		'enable_tumblr'						=> '',
		'enable_tumblr_for'					=> '',
		'tb_url_shortener'					=> 'wordpress',
		'tb_bitly_username'					=> '',
		'tb_bitly_api_key'					=> '',
		'tumblr_content_type'				=> '',
		'tumblr_consumer_key'				=> '',
		'tumblr_consumer_secret'			=> '',
		//Delicious settting
		'enable_delicious'					=> '',
		'enable_delicious_for'				=> '',
		'dc_url_shortener'					=> 'wordpress',
		'dc_bitly_username'					=> '',
		'dc_bitly_api_key'					=> '',
		'delicious_username'				=> '',
		'delicious_password'				=> '',
		//BufferApp settting
		'enable_bufferapp'					=> '',
		'enable_bufferapp_for'				=> '',
		'ba_url_shortener'					=> 'wordpress',
		'ba_bitly_username'					=> '',
		'ba_bitly_api_key'					=> '',
		'bufferapp_client_id'				=> '',
		'bufferapp_client_secret'			=> '',
		'ba_post_img'						=> '',
		'schedule_wallpost_option'			=> '',
		'schedule_wallpost_time'			=> '0',
		'schedule_wallpost_minute'			=> '0'
	);
	
	// apply filters for default settings
	$wpw_auto_poster_options = apply_filters( 'wpw_auto_poster_default_settings', $wpw_auto_poster_options );
	
	update_option( 'wpw_auto_poster_options', $wpw_auto_poster_options );
}

/**
 * Create Files/Directories
 * 
 * Handle to create files/directories on activation
 * 
 * @package Social Auto Poster
 * @since 1.6.2
 */
function wpw_auto_poster_create_files() {
	
	$files = array(
		array(
			'base' 		=> WPW_AUTO_POSTER_LOG_DIR,
			'file' 		=> 'index.html',
			'content' 	=> ''
		)
	);
	
	foreach ( $files as $file ) {
		if ( wp_mkdir_p( $file['base'] ) && ! file_exists( trailingslashit( $file['base'] ) . $file['file'] ) ) {
			if ( $file_handle = @fopen( trailingslashit( $file['base'] ) . $file['file'], 'w' ) ) {
				fwrite( $file_handle, $file['content'] );
				fclose( $file_handle );
			}
		}
	}
}

/**
 * Add plugin action links
 *
 * Adds a settings, support and docs link to the plugin list.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
function wpw_auto_poster_add_settings_link( $links ) {
	$plugin_links = array(
		'<a href="'.add_query_arg( array( 'page' => 'wpw-auto-poster-settings' ), admin_url( 'admin.php') ).'">'.__( 'Settings', 'wpwautoposter').'</a>',
		'<a href="http://support.wpweb.co.in/">'.__( 'Support', 'wpwautoposter').'</a>',
		'<a href="http://wpweb.co.in/documents/social-auto-poster/">'.__( 'Docs', 'wpwautoposter').'</a>'		
	);

	return array_merge( $plugin_links, $links );
}
//add plugin settings, support and docs link to plugin listing page			
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'wpw_auto_poster_add_settings_link' );

/**
 * Start Session
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
function wpw_auto_poster_sessionset() {

	global $wpdb, $wpw_auto_poster_message_stack;	

	if( !session_id() ) { 
		@session_start();
	}

	$settingspage = add_query_arg( array( 'page' => 'wpw-auto-poster-settings' ), admin_url( 'admin.php' ) );
	
	$wpw_auto_poster_fb_sess_data = get_option( 'wpw_auto_poster_fb_sess_data' );	
	
	if( !empty( $wpw_auto_poster_fb_sess_data ) &&  WPW_AUTO_POSTER_FB_APP_ID != '' ) {	
		if( ! isset( $_SESSION['wpweb_fb_user_id'] ) ) { 
			$_SESSION['wpweb_fb_user_cache'] 	= $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_cache'];
			$_SESSION['wpweb_fb_user_id'] 		= $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_id'];
			$_SESSION['wpweb_fb_user_accounts'] = $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_accounts'];
			$_SESSION[WPW_AUTO_POSTER_FB_SESS1] = $wpw_auto_poster_fb_sess_data[WPW_AUTO_POSTER_FB_SESS1];
			$_SESSION[WPW_AUTO_POSTER_FB_SESS2] = $wpw_auto_poster_fb_sess_data[WPW_AUTO_POSTER_FB_SESS2];
			$_SESSION[WPW_AUTO_POSTER_FB_SESS3] = $wpw_auto_poster_fb_sess_data[WPW_AUTO_POSTER_FB_SESS3];
			$_SESSION[WPW_AUTO_POSTER_FB_SESS4] = $wpw_auto_poster_fb_sess_data[WPW_AUTO_POSTER_FB_SESS4];
		}
	}
	//Reset Facebook User Data
	if( isset( $_GET['fb_reset_user'] ) && $_GET['fb_reset_user'] == '1' ) {
		$fbposting = new Wpw_Auto_Poster_FB_Posting();
		$fbposting->wpw_auto_poster_fb_reset_session();
		$wpw_auto_poster_message_stack->add_session( 'poster-selected-tab', 'facebook' );
		wp_redirect( $settingspage );
		exit;	
	}
	
	//Reset LinkedIn User Data
	if( isset( $_GET['li_reset_user'] ) && $_GET['li_reset_user'] == '1' ) {
		$liposting = new Wpw_Auto_Poster_Li_Posting();
		$liposting->wpw_auto_poster_li_reset_session();
		$wpw_auto_poster_message_stack->add_session( 'poster-selected-tab', 'linkedin' );
		wp_redirect( $settingspage );
		exit;	
	}
	//Reset Twitter User Data
	if( isset( $_GET['tb_reset_user'] ) && $_GET['tb_reset_user'] == '1' ) { // if user reset session to tumblr
		$tbposting = new Wpw_Auto_Poster_TB_Posting();
		$tbposting->wpw_auto_poster_tb_reset_session();
		$wpw_auto_poster_message_stack->add_session( 'poster-selected-tab', 'tumblr' );
		wp_redirect( $settingspage );
		exit;
	}
	//Reset BufferApp User Data
	if( isset( $_GET['ba_reset_user'] ) && $_GET['ba_reset_user'] == '1' ) {
		$baposting = new Wpw_Auto_Poster_BA_Posting();
		$baposting->wpw_auto_poster_ba_reset_session();
		$wpw_auto_poster_message_stack->add_session( 'poster-selected-tab', 'bufferapp' );
		wp_redirect( $settingspage );
		exit;	
	}
}

global $wpw_auto_poster_options, $wpw_auto_poster_message_stack, $wpw_auto_poster_model,
		$wpw_auto_poster_fb_posting, $wpw_auto_poster_tw_posting, $wpw_auto_poster_li_posting,$wpw_auto_poster_tb_posting,
		$wpw_auto_poster_ba_posting, $wpw_auto_poster_dc_posting,
		$wpw_auto_poster_scripts, $wpw_auto_poster_render, $wpw_auto_poster_admin, $wpw_auto_poster_logs;
		
/**
 * Include different files needed for our plugin.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */  
require_once( WPW_AUTO_POSTER_DIR . '/includes/wpw-auto-poster-misc-functions.php' ); // plugin options class
$wpw_auto_poster_options = wpw_auto_poster_settings();
wpw_auto_poster_initialize();

//Register Post Types
require_once( WPW_AUTO_POSTER_DIR . '/includes/wpw-auto-poster-post-types.php' );

//Logs Class
require_once( WPW_AUTO_POSTER_DIR . '/includes/class-wpw-auto-poster-logs.php'); 
$wpw_auto_poster_logs = new Wpw_Auto_Poster_Logs();

//Message Stack Class
require_once( WPW_AUTO_POSTER_DIR . '/includes/class-wpw-auto-poster-message-stack.php'); 
$wpw_auto_poster_message_stack = new Wpw_Auto_Poster_Message_Stack();

//Model Class
require_once( WPW_AUTO_POSTER_DIR . '/includes/class-wpw-auto-poster-model.php' );
$wpw_auto_poster_model = new Wpw_Auto_Poster_Model();

//Facebook Posting Class
require_once( WPW_AUTO_POSTER_DIR . '/includes/social/class-wpw-auto-poster-fb-posting.php' ); // fan page posting class
$wpw_auto_poster_fb_posting = new Wpw_Auto_Poster_FB_Posting();

//Twitter Posting Class
require_once( WPW_AUTO_POSTER_DIR . '/includes/social/class-wpw-auto-poster-tw-posting.php' ); // twitter posting class
$wpw_auto_poster_tw_posting = new Wpw_Auto_Poster_TW_Posting();

//Linkein Posting Class
require_once( WPW_AUTO_POSTER_DIR . '/includes/social/class-wpw-auto-poster-li-posting.php' ); // linkedin posting class
$wpw_auto_poster_li_posting = new Wpw_Auto_Poster_Li_Posting();

//Tumblr Posting Class
require_once( WPW_AUTO_POSTER_DIR . '/includes/social/class-wpw-auto-poster-tb-posting.php' ); // tumblr posting class
$wpw_auto_poster_tb_posting = new Wpw_Auto_Poster_TB_Posting();

//Delicious Posting Class
require_once( WPW_AUTO_POSTER_DIR . '/includes/social/class-wpw-auto-poster-dc-posting.php' ); // delicious posting class
$wpw_auto_poster_dc_posting = new Wpw_Auto_Poster_DC_Posting();

//BufferApp Posting Class
require_once( WPW_AUTO_POSTER_DIR . '/includes/social/class-wpw-auto-poster-ba-posting.php' ); // bufferapp posting class
$wpw_auto_poster_ba_posting = new Wpw_Auto_Poster_BA_Posting();

//Metabox File to add metabox
require_once( WPW_AUTO_POSTER_META_DIR . '/wpw-auto-poster-meta-box.php' );

//Including the Scripts and Styles Files
require_once( WPW_AUTO_POSTER_DIR . '/includes/class-wpw-auto-poster-scripts.php' ); 
$wpw_auto_poster_scripts = new Wpw_Auto_Posting_Scripts();
$wpw_auto_poster_scripts->add_hooks();

//Render Class to handles most of HTML designs for plugin
require_once( WPW_AUTO_POSTER_DIR . '/includes/class-wpw-auto-poster-renderer.php' );
$wpw_auto_poster_render = new Wpw_Auto_Poster_Renderer();

//Admin Class to handles all admin functionalities
require_once( WPW_AUTO_POSTER_ADMIN . '/class-wpw-auto-poster-admin.php' );
$wpw_auto_poster_admin = new Wpw_Auto_Posting_AdminPages();
$wpw_auto_poster_admin->add_hooks();

//session set
add_action( 'init','wpw_auto_poster_sessionset' );

//check Social Updater is activated
if( class_exists( 'Wpweb_Upd_Admin' ) ) {
	
	// Plugin updates
	wpweb_queue_update( plugin_basename( __FILE__ ), WPW_AUTO_POSTER_PLUGIN_KEY );
	
	/**
	 * Include Auto Updating Files
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	require_once( WPWEB_UPD_DIR . '/updates/class-plugin-update-checker.php' ); // auto updating
	
	$WpwebAutoPosterUpdateChecker = new WpwebPluginUpdateChecker (
		'http://wpweb.co.in/Updates/SAP/license-info.php',
		__FILE__,
		WPW_AUTO_POSTER_PLUGIN_KEY
	);
	
	/**
	 * Auto Update
	 * 
	 * Get the license key and add it to the update checker.
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_add_secret_key( $query ) {
		
		$plugin_key	= WPW_AUTO_POSTER_PLUGIN_KEY;
		
		$query['lickey'] = wpweb_get_plugin_purchase_code( $plugin_key );
		return $query;
	}
	
	$WpwebAutoPosterUpdateChecker->addQueryArgFilter( 'wpw_auto_poster_add_secret_key' );
} // end check WPWeb Updater is activated