<?php

/**
 * Gets an instance of TWP_Twitter class
 *
 * @type function
 * @date 16/06/2015
 * @since 1.0
 *
 * @param N/A
 * @return object
 **/

// Declare global database / table version variable
global $twp_db_version;

// Define current database / table version
$twp_db_version = '1.0';

/**
 * Function that runs on plugin activation / installation
 *
 * @type function
 * @date 16/06/2015
 * @since 1.0
 *
 * @param N/A
 * @return N/A
 **/

function twp_install() {

    global $wpdb;
 
    $charset_collate = $wpdb->get_charset_collate();
    
    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

	$sql = "CREATE TABLE " . $wpdb->prefix . "twp_queue (
		ID int(11) NOT NULL AUTO_INCREMENT,
        post_ID bigint(20) UNSIGNED NOT NULL,
		queue mediumint(9) NOT NULL,
		UNIQUE KEY id (ID)
	)" .  $charset_collate;

    dbDelta( $sql );
    
    // ...
    
    $sql = "CREATE TABLE " . $wpdb->prefix . "twp_log (
		ID int(11) NOT NULL AUTO_INCREMENT,
        post_ID bigint(20) UNSIGNED NOT NULL,
        type VARCHAR(10) NOT NULL,
		tweet TEXT NOT NULL,
        short_url VARCHAR(50) NOT NULL,
        timestamp TIMESTAMP NOT NULL,
        tweet_ID bigint(30) UNSIGNED NOT NULL,
		UNIQUE KEY id (ID)
	) " . $charset_collate;

    dbDelta( $sql );
    
    // ...
    
    $sql = "CREATE TABLE " . $wpdb->prefix . "twp_stats (
		ID int(11) NOT NULL AUTO_INCREMENT,
        tweet_ID bigint(30) UNSIGNED NOT NULL,
        stat_type VARCHAR(50) NOT NULL,
		stat_value LONGTEXT NOT NULL,
        timestamp TIMESTAMP NOT NULL,
		UNIQUE KEY id (ID)
	) " . $charset_collate;

    dbDelta( $sql );

    // Load default settings
    twp_load_settings();
    twp_schedule_task();
    
}

// ...

/**
 * Provide plugin with default settings on plugin activation (if not defined)
 *
 * @type function
 * @date 16/06/2015
 * @since 1.0
 *
 * @param N/A
 * @return N/A
 **/

function twp_load_settings() {
    
    global $twp_db_version;
    
    $default = array(
		'post_type' => array( 0 => 'post' ),
        'queue_new_post' => 0,
        'tweet_text' => '{{TITLE}} - {{URL}}',
        'loop' => 1
    );
    
    add_option( 'twp_queue_status', 'paused' );
    add_option( 'twp_settings_options', $default );
    add_option( 'twp_db_version', $twp_db_version );
    
}

// ...

/**
 * Prevent redirection on plugin's re-activation. Once is enough :)
 *
 * @type function
 * @date 16/06/2015
 * @since 1.0
 *
 * @param N/A
 * @return N/A
 **/

function twp_activate() {
    
    global $wpdb;
    
    if( twp_get_option( 'twp_settings', 'analytics' ) != 1 ) 
        twp_schedule_task();
    
    add_option('twp_activation_redirect', true);
    
    if( get_option( 'twp_refresh_tokens' ) != 2 ) :
        delete_option( 'twp_twitter_oauth_token' );
        delete_option( 'twp_twitter_oauth_token_secret' );
        delete_option( 'twp_twitter_is_authed' );
        update_option( 'twp_refresh_tokens', 2 );
    endif;
    
    if( get_option( 'twp_stats_truncated' ) != 1 ) :
        $wpdb->query( "TRUNCATE " . $wpdb->prefix . "twp_stats" );
        update_option( 'twp_stats_truncated', 1 );
    endif;
}

// ...

/**
 * Schedule Cron Job
 *
 * @type function
 * @date 16/06/2015
 * @since 1.0
 * @updated 1.3.5
 *
 * @param N/A
 * @return N/A
 **/

function twp_schedule_task() {
    
    if( ! wp_next_scheduled( 'tweet_wheel_tweet' ) )
        wp_schedule_event( current_time( 'timestamp' ), 'minutely', 'tweet_wheel_tweet' );
    
    if( ! wp_next_scheduled( 'tweet_wheel_stats' ) )
        wp_schedule_event( current_time( 'timestamp' ), 'hourly', 'tweet_wheel_stats' );

}  