<?php




###############################################
# WP hook, filter, cron & setup functions
###############################################


// runs when the plugin is activated in the WP plugins page.
function wpi_activate()
{

	/*
	update_option('wpi_n_new_indexed', 0);
	update_option('wpi_first_visit', 1);
	update_option('wpi_status', 0);
	update_option('wpi_tags', 0);
	update_option('wpi_homepage', 0);
	update_option('wpi_auth', 0);
	update_option('wpi_rss', 0);
	update_option('wpi_check', 3);
	update_option('wpi_relatedposts', 0);
	update_option('wpi_ping', 0);
	update_option('wpi_num_pings_today', 0);
	update_option('wpi_num_links_today', 0);
	update_option('wpi_num_tags_today', 0);
	update_option('wpi_last_bulk_ping', 0);
	*/

	// schedule some new events. We hook our index checking functions onto these WP events in wpi.php
	// We schedule them for 3 mins in the future so you've got time to save the settings - then things start happeneing.
	wp_schedule_event(time()+180, 'wpi_15_mins', 'wpi_quater_hour_cron_event');
	wp_schedule_event(time()+120, 'wpi_3_hrs', 'wpi_three_hour_cron_event');
	wp_schedule_event(strtotime('tomorrow'), 'daily', 'wpi_daily_cron_event');

	wpi_log('Plugin activated!');

}


// Runs when the plugin is deactivated
function wpi_deactivate()
{

	wp_clear_scheduled_hook('wpi_daily_cron_event');
	wp_clear_scheduled_hook('wpi_three_hour_cron_event');
	wp_clear_scheduled_hook('wpi_quater_hour_cron_event');

	wpi_log('Plugin deactivated.');

}


// add more specific cron time intervals to WP's cron feature
function wpi_new_cron_intervals($interval)
{

	$interval['wpi_15_mins'] = array('interval' => 15*60, 'display' => 'Once every 15 mins');
	$interval['wpi_3_hrs'] = array('interval' => 60*60*3, 'display' => 'Once every 3 hours');
	return $interval;

}


// clear the gauge dial stats daily
function wpi_clear_daily_stats()
{

	update_option('wpi_num_pings_today', 0);
	update_option('wpi_num_links_today', 0);
	update_option('wpi_num_tags_today', 0);

}


// adds the "Indexation Status" colored option to the WP admin toolbar, when viewing a post page.
function wpi_admin_toolbar($wp_toolbar)
{

	// don't show this bar for anything other than a single post
	if( !is_single() )
		return;

	// swipe the post id from the bowls of WP
	global $wp_query;
	$post_id = $wp_query->post->ID;
	if( !$post_id )
		return;

	$base_style = '
		font-weight:bold;
		text-shadow:none;
		color:#fff;
		padding: 2px 6px;
		font-size: 12px;
		-webkit-border-radius: 4px;
		border-radius: 4px;
		-webkit-box-shadow: 1px 1px 0px 0px #000;
		box-shadow: 1px 1px 0px 0px #000;
	';
	$meta = get_post_meta($post_id);
	
	if( isset($meta['_wpi_indexed']) ) {
		$index_status = 'Indexed as of ' . date('jS M Y @H:i', $meta['_wpi_indexed'][0]);
		$style = 'background-color:#109618;';
	}
	elseif( isset($meta['_wpi_not_indexed']) ) {
		$index_status = 'Not Indexed as of ' . date('jS M Y @H:i', $meta['_wpi_not_indexed'][0]);
		$style = 'background-color:#DC3912;';
	}
	else {
		$index_status = 'Index status unchecked';
		$style = 'background-color:#3366CC;';
	}

	// spit out a toolbar
	$wp_toolbar->add_node( array(
		'id' => 'wpi',
		'title' => "<span style=\"$base_style $style\">WP Indexer</span>"
	) );

	$wp_toolbar->add_node( array(
		'id' => 'wpi-index-status',
		'title' => $index_status,
		'parent' => 'wpi',
	) );

}


// Runs before most other things when you visit a WP admin URL
function wpi_admin_init()
{

	wp_enqueue_script('jquery');

}


// Adds the admin menu to the left side in WP
function wpi_admin_menu()
{

	add_menu_page(
		WPI_NAME,
		WPI_NAME,
		'manage_options',
		WPI_SLUG,
		'wpi_admin_dashboard',
		'http://wpindexer.s3.amazonaws.com/img/logo_16x16.png',
		100
	);

	// add a fake subpage with the same details (mostly) as the menu page above, so we don't get a redundant, dupe subpage
	// This is just to fix a WP quirk
	add_submenu_page( 
		WPI_SLUG,
		'Dashboard',
		'Dashboard',
		'manage_options',
		WPI_SLUG,
		'wpi_admin_dashboard'
	);

	add_submenu_page( 
		WPI_SLUG,
		'Settings',
		'Settings',
		'manage_options',
		'wpi-settings',
		'wpi_admin_settings'
	);

	add_submenu_page( 
		WPI_SLUG,
		'Log',
		'Log',
		'manage_options',
		'wpi-log',
		'wpi_admin_log'
	);
/*
	add_submenu_page( 
		WPI_SLUG,
		'Support',
		'Support',
		'manage_options',
		'wpi-support',
		'wpi_admin_support'
	);
*/
}


// Output our css and javscript files to the admin <head>
function wpi_admin_head()
{

	if( isset($_GET['wpi_local']) )
		$base_url = WPI_URL;
	else
		$base_url = 'http://wpindexer.s3.amazonaws.com';
		

	echo "\n\n<!-- WP Indexer admin css and javascript -->\n";
	echo "\t<link rel='stylesheet' href='$base_url/css/uniform.aristo.css' type='text/css' media='all' />\n";
	echo "\t<link rel='stylesheet' href='$base_url/css/admin-styles.css' type='text/css' media='all' />\n";
	echo "\t<script type='text/javascript' src='$base_url/js/jquery.uniform.js'></script>\n";
	echo "\t<script type='text/javascript' src='$base_url/js/admin-scripts.js'></script>\n";
	echo "<!-- /WP Indexer -->\n\n";

}


// Loops through the WP cron data and returns the time a specific event is next going to happen.
// Used mainly to help generate the paragraph at the bottom of the dashboard.
function wpi_get_next_cron_time($hook)
{

	$crons = get_option('cron');

	foreach( $crons as $time => $cron_data )
		foreach( $cron_data as $cron_hook_name => $data )
			if( $cron_hook_name === $hook )
				return $time;

	return false;

}




###############################################
# General, non-WP helper functions
###############################################


// given a UNIX timestamp (in the future), this returns things like:
// 10 seconds
// 1 day
function wpi_format_time($timestamp)
{

	$mins = round($timestamp / 60);
	$hours = round($mins / 60);
	$days = round($hours / 24);

	if( $timestamp < 60 ) {
		$maybe_s = ( $timestamp > 0 && $timestamp <= 1 ? '' : 's' );
		return "$timestamp second$maybe_s";
	}

	elseif( $mins < 60 ) {
		$maybe_s = ( $mins > 0 && $mins <= 1 ? '' : 's' );
		return "$mins minute$maybe_s";
	}

	elseif( $hours < 24 ) {
		$maybe_s = ( $hours > 0 && $hours <= 1 ? '' : 's' );
		return "$hours hour$maybe_s";
	}

	else {
		$maybe_s = ( $days > 0 && $days <= 1 ? '' : 's' );
		return "$days day$maybe_s";
	}

}


// similar to wpi_format_time(), but this function gives the difference between the timestamp and now.
function wpi_time_until($timestamp, $future_prefix=false, $single_past_string=false)
{

	$until = '';
	$diff = (int) $timestamp - time();
	
	if( $diff < 0 ) {
		if( $single_past_string )
			return $single_past_string;
		$maybe_ago = ' ago';
		$diff = abs($diff);
	}
	else
		$maybe_ago = '';

	$mins = round($diff / 60);
	$hours = round($mins / 60);
	$days = round($hours / 24);
	$future_prefix = ( $future_prefix ? $future_prefix : '' );

	if( $diff < 60 ) {
		$maybe_s = ( $diff > 1 ? 's' : '' );
		return "$future_prefix$diff second$maybe_s$maybe_ago";
	}

	elseif( $mins < 60 ) {
		$maybe_s = ( $mins > 1 ? 's' : '' );
		return "$future_prefix$mins minute$maybe_s$maybe_ago";
	}

	elseif( $hours < 24 ) {
		$maybe_s = ( $hours > 1 ? 's' : '' );
		return "$future_prefix$hours hour$maybe_s$maybe_ago";
	}

	else {
		$maybe_s = ( $days > 1 ? 's' : '' );
		return "$future_prefix$days day$maybe_s$maybe_ago";
	}

}


// http://stackoverflow.com/a/838239/1333791
// use with usort, like this: usort( $array, 'wpi_sort_array_by_length' );
function wpi_sort_array_by_length($a, $b)
{

	return strlen($b) - strlen($a);

}


// http://stackoverflow.com/a/10705098/1333791
// Replaces a random number of string matches of $search in $str.
// Used for auth links.
function wpi_replace_n_occurences($str, $search, $replace, $n)
{

	// Get all occurences of $search and their offsets within the string
	$count = preg_match_all('/\b'.preg_quote($search, '/').'\b/', $str, $matches, PREG_OFFSET_CAPTURE);

	// Get string length information so we can account for replacement strings that are of a different length to the search string
	$searchLen = strlen($search);
	$diff = strlen($replace) - $searchLen;
	$offset = 0;

	// Loop $n random matches and replace them, if $n < 1 || $n > $count, replace all matches
	$toReplace = ($n < 1 || $n > $count) ? array_keys($matches[0]) : (array) array_rand($matches[0], $n);
	foreach ($toReplace as $match) {
		$str = substr($str, 0, $matches[0][$match][1] + $offset).$replace.substr($str, $matches[0][$match][1] + $searchLen + $offset);
		$offset += $diff;
	}

	return $str;

}


// http://stackoverflow.com/a/2510540/1333791
function wpi_format_bytes($size, $precision = 2)
{

	if($size === 0)
		return '0 bytes';

	$base = log($size) / log(1024);
	$suffixes = array('bytes', 'kb', 'MB', 'GB', 'TB');

	return round(pow(1024, $base - floor($base)), $precision) . ' ' . $suffixes[floor($base)];

}


###############################################
# WPI admin page functions
###############################################


// A handy way to generate template pages without duplicating cruft all over the place.
// It wraps the requested template inside container.php which is basically the WPI box with header
function wpi_render_template($template_name, $template_vars=array())
{

	$container_template = WPI_PATH . 'templates/container.php';
	$page_template = WPI_PATH . 'templates/' . $template_name . '.php';

	extract($template_vars);

	// get the page content
	if( file_exists($page_template) ) {
		ob_start();
		require $page_template;
		$page_content = ob_get_contents();
		ob_end_clean();
	}

	// now echo the container and everything will be rendered correctly
	require $container_template;

}


// Gathers data and renders the WPI dashboard
function wpi_admin_dashboard()
{

	global $wpdb;
	$vars = array();

	$vars['admin_msgs'] = array();

	if( (bool) get_option('wpi_first_visit') ) {
		$vars['admin_msgs'][] = array( 'msg'=>'Thanks for using WP Indexer! If you need any help just hit the <a href="' . $_SERVER['PHP_SELF'] . '?page=wpi-support">support page</a> and I\'ll help you out.' );
		update_option('wpi_first_visit', 0);
	}

	$num_new_indexed = get_option('wpi_n_new_indexed', 0);
	if( $num_new_indexed ) {
		$vars['admin_msgs'][] = array( 'msg'=>"$num_new_indexed new posts indexed since you were last here!" );
		update_option('wpi_n_new_indexed', 0);
	}

	$vars['plugin_errors'] = wpi_get_errors();

	$vars['index_stats']['goog_index_num_total'] = get_option('wpi_index_num_total', 0);
	$vars['index_stats']['goog_index_num_1st_grade'] = get_option('wpi_index_num_1st_grade', 0);
	$vars['index_stats']['goog_index_num_2nd_grade'] = $vars['index_stats']['goog_index_num_total'] - $vars['index_stats']['goog_index_num_1st_grade'];

	// get the total, current post count
	$vars['index_stats']['num_total_posts'] = $wpdb->get_var("
		SELECT
			COUNT(ID) AS num_posts
		FROM
			$wpdb->posts AS p
		WHERE
			p.post_status = 'publish'
		AND
			p.post_type = 'post'
	");

	// get how many posts are either indexed
	$num_indexed_posts = $wpdb->get_var("
		SELECT
			COUNT(post_id)
		FROM
			$wpdb->postmeta AS pm
		WHERE
			pm.meta_key = '_wpi_indexed'
		GROUP BY
			pm.meta_key
	");

	// get how many posts are either indexed
	$num_not_indexed = $wpdb->get_var("
		SELECT
			COUNT(post_id)
		FROM
			$wpdb->postmeta AS pm
		WHERE
			pm.meta_key = '_wpi_not_indexed'
		GROUP BY
			pm.meta_key
	");

	$vars['index_stats']['num_indexed_posts'] = ( !empty($num_indexed_posts) ? $num_indexed_posts : 0 );
	$vars['index_stats']['num_not_checked_posts'] = $vars['index_stats']['num_total_posts'] - $num_indexed_posts - $num_not_indexed;
	$vars['index_stats']['num_not_checked_posts'] = ( $vars['index_stats']['num_not_checked_posts'] > 0 ? $vars['index_stats']['num_not_checked_posts'] : 0 );
	$vars['index_stats']['num_not_indexed_posts'] = $vars['index_stats']['num_total_posts'] - $num_indexed_posts - $vars['index_stats']['num_not_checked_posts'];
	$vars['index_stats']['num_not_indexed_posts'] = ( $vars['index_stats']['num_not_indexed_posts'] > 0 ? $vars['index_stats']['num_not_indexed_posts'] : 0 );

	$vars['index_stats']['overview']['homepage']['total'] = 1;
	$vars['index_stats']['overview']['homepage']['indexed'] = get_option('wpi_index_num_homepage', 0);
	if( $vars['index_stats']['overview']['homepage']['indexed'] > $vars['index_stats']['overview']['homepage']['total'] )
		$vars['index_stats']['overview']['homepage']['indexed'] = $vars['index_stats']['overview']['homepage']['total'];
	$vars['index_stats']['overview']['homepage']['percent'] = round($vars['index_stats']['overview']['homepage']['indexed'] / $vars['index_stats']['overview']['homepage']['total'] * 100);
	$vars['index_stats']['overview']['homepage']['percent_rounded'] = round($vars['index_stats']['overview']['homepage']['percent'], -1);

	$vars['index_stats']['overview']['posts']['total'] = $vars['index_stats']['num_total_posts'];
	$vars['index_stats']['overview']['posts']['indexed'] = $vars['index_stats']['num_indexed_posts'];
	if( $vars['index_stats']['overview']['posts']['indexed'] > $vars['index_stats']['overview']['posts']['total'] )
		$vars['index_stats']['overview']['posts']['indexed'] = $vars['index_stats']['overview']['posts']['total'];
	$vars['index_stats']['overview']['posts']['percent'] = round($vars['index_stats']['overview']['posts']['indexed'] / $vars['index_stats']['overview']['posts']['total'] * 100);
	$vars['index_stats']['overview']['posts']['percent_rounded'] = round($vars['index_stats']['overview']['posts']['percent'], -1);

	$vars['index_stats']['overview']['categories']['total'] = wp_count_terms('category');
	$vars['index_stats']['overview']['categories']['indexed'] = get_option('wpi_index_num_category', 0);
	if( $vars['index_stats']['overview']['categories']['indexed'] > $vars['index_stats']['overview']['categories']['total'] )
		$vars['index_stats']['overview']['categories']['indexed'] = $vars['index_stats']['overview']['categories']['total'];
	$vars['index_stats']['overview']['categories']['percent'] = round($vars['index_stats']['overview']['categories']['indexed'] / $vars['index_stats']['overview']['categories']['total'] * 100);
	$vars['index_stats']['overview']['categories']['percent_rounded'] = round($vars['index_stats']['overview']['categories']['percent'], -1);

	$vars['index_stats']['overview']['tags']['total'] = wp_count_terms('post_tag');
	$vars['index_stats']['overview']['tags']['indexed'] = get_option('wpi_index_num_tag', 0);
	if( $vars['index_stats']['overview']['tags']['indexed'] > $vars['index_stats']['overview']['tags']['total'] )
		$vars['index_stats']['overview']['tags']['indexed'] = $vars['index_stats']['overview']['tags']['total'];
	$vars['index_stats']['overview']['tags']['percent'] = round($vars['index_stats']['overview']['tags']['indexed'] / $vars['index_stats']['overview']['tags']['total'] * 100);
	$vars['index_stats']['overview']['tags']['percent_rounded'] = round($vars['index_stats']['overview']['tags']['percent'], -1);

	$users = count_users();
	$vars['index_stats']['overview']['authors']['indexed'] = get_option('wpi_index_num_author', 0);
	$vars['index_stats']['overview']['authors']['total'] = $users['total_users'];
	if( $vars['index_stats']['overview']['authors']['indexed'] > $vars['index_stats']['overview']['authors']['total'] )
		$vars['index_stats']['overview']['authors']['indexed'] = $vars['index_stats']['overview']['authors']['total'];
	$vars['index_stats']['overview']['authors']['percent'] = round($vars['index_stats']['overview']['authors']['indexed'] / $vars['index_stats']['overview']['authors']['total'] * 100);
	$vars['index_stats']['overview']['authors']['percent_rounded'] = round($vars['index_stats']['overview']['authors']['percent'], -1);
	
	$future_prefix = 'in ';
	$single_past_string = 'imminently';
	$vars['next_checks']['posts'] = wpi_time_until( wpi_get_next_cron_time('wpi_quater_hour_cron_event'), $future_prefix, $single_past_string );
	$vars['next_checks']['site'] = wpi_time_until( wpi_get_next_cron_time('wpi_three_hour_cron_event'), $future_prefix, $single_past_string );
	$vars['next_checks']['num_posts_to_check'] = (int) get_option('wpi_check');
	$vars['next_checks']['posts_checked_per_second'] = $vars['next_checks']['num_posts_to_check'] / (15*60);
	$vars['next_checks']['posts_checked_daily'] = $vars['next_checks']['num_posts_to_check'] * 4 * 24;
	$vars['next_checks']['seconds_for_complete_post_recheck'] = @($vars['index_stats']['overview']['posts']['total'] / $vars['next_checks']['posts_checked_per_second']); // silencing a possible division by zero

	// if the division above was a zero, the var will be false. If so they've got 0 posts being checked. So...
	if( !$vars['next_checks']['seconds_for_complete_post_recheck'] ) {
		$vars['next_checks']['time_for_complete_post_recheck'] = 'million years :)';
	}
	else {
		$seconds_to_calc = ( $vars['next_checks']['seconds_for_complete_post_recheck'] < 60*15 ? 60*15 : $vars['next_checks']['seconds_for_complete_post_recheck'] );
		$vars['next_checks']['time_for_complete_post_recheck'] = wpi_format_time($seconds_to_calc);
	}

	$vars['gauges']['num_pings_today'] = get_option('wpi_num_pings_today', 0);
	$vars['gauges']['num_links_today'] = get_option('wpi_num_links_today', 0);
	$vars['gauges']['num_tags_today'] = get_option('wpi_num_tags_today', 0);

	if( isset($_GET['wpi_debug']) ) {
		$vars['debug'] = true;
		echo '<h2>WPI debug: $vars</h2><pre>' . print_r($vars, true) . '</pre>';
	}

	if( isset($_GET['wpi_dash_demo']) ) {


		$vars['admin_msgs'][] = array( 'msg'=>"14 new posts indexed since you were last here!" );

		$vars['plugin_errors'] = array();

		$vars['index_stats']['goog_index_num_total'] = 1472;
		$vars['index_stats']['goog_index_num_1st_grade'] = 393;
		$vars['index_stats']['goog_index_num_2nd_grade'] = $vars['index_stats']['goog_index_num_total'] - $vars['index_stats']['goog_index_num_1st_grade'];

		$vars['index_stats']['num_total_posts'] = 709;
		$vars['index_stats']['num_indexed_posts'] = 393;
		$vars['index_stats']['num_not_checked_posts'] = 218;
		$vars['index_stats']['num_not_indexed_posts'] = 98;

		$vars['index_stats']['overview']['homepage']['total'] = 1;
		$vars['index_stats']['overview']['homepage']['indexed'] = 1;
		if( $vars['index_stats']['overview']['homepage']['indexed'] > $vars['index_stats']['overview']['homepage']['total'] )
			$vars['index_stats']['overview']['homepage']['indexed'] = $vars['index_stats']['overview']['homepage']['total'];
		$vars['index_stats']['overview']['homepage']['percent'] = round($vars['index_stats']['overview']['homepage']['indexed'] / $vars['index_stats']['overview']['homepage']['total'] * 100);
		$vars['index_stats']['overview']['homepage']['percent_rounded'] = round($vars['index_stats']['overview']['homepage']['percent'], -1);

		$vars['index_stats']['overview']['posts']['total'] = $vars['index_stats']['num_total_posts'];
		$vars['index_stats']['overview']['posts']['indexed'] = $vars['index_stats']['num_indexed_posts'];
		if( $vars['index_stats']['overview']['posts']['indexed'] > $vars['index_stats']['overview']['posts']['total'] )
			$vars['index_stats']['overview']['posts']['indexed'] = $vars['index_stats']['overview']['posts']['total'];
		$vars['index_stats']['overview']['posts']['percent'] = round($vars['index_stats']['overview']['posts']['indexed'] / $vars['index_stats']['overview']['posts']['total'] * 100);
		$vars['index_stats']['overview']['posts']['percent_rounded'] = round($vars['index_stats']['overview']['posts']['percent'], -1);

		$vars['index_stats']['overview']['categories']['total'] = 34;
		$vars['index_stats']['overview']['categories']['indexed'] = 30;
		if( $vars['index_stats']['overview']['categories']['indexed'] > $vars['index_stats']['overview']['categories']['total'] )
			$vars['index_stats']['overview']['categories']['indexed'] = $vars['index_stats']['overview']['categories']['total'];
		$vars['index_stats']['overview']['categories']['percent'] = round($vars['index_stats']['overview']['categories']['indexed'] / $vars['index_stats']['overview']['categories']['total'] * 100);
		$vars['index_stats']['overview']['categories']['percent_rounded'] = round($vars['index_stats']['overview']['categories']['percent'], -1);

		$vars['index_stats']['overview']['tags']['total'] = 243;
		$vars['index_stats']['overview']['tags']['indexed'] = 112;
		if( $vars['index_stats']['overview']['tags']['indexed'] > $vars['index_stats']['overview']['tags']['total'] )
			$vars['index_stats']['overview']['tags']['indexed'] = $vars['index_stats']['overview']['tags']['total'];
		$vars['index_stats']['overview']['tags']['percent'] = round($vars['index_stats']['overview']['tags']['indexed'] / $vars['index_stats']['overview']['tags']['total'] * 100);
		$vars['index_stats']['overview']['tags']['percent_rounded'] = round($vars['index_stats']['overview']['tags']['percent'], -1);

		$users = 4;
		$vars['index_stats']['overview']['authors']['indexed'] = 1;
		$vars['index_stats']['overview']['authors']['total'] = 4;
		if( $vars['index_stats']['overview']['authors']['indexed'] > $vars['index_stats']['overview']['authors']['total'] )
			$vars['index_stats']['overview']['authors']['indexed'] = $vars['index_stats']['overview']['authors']['total'];
		$vars['index_stats']['overview']['authors']['percent'] = round($vars['index_stats']['overview']['authors']['indexed'] / $vars['index_stats']['overview']['authors']['total'] * 100);
		$vars['index_stats']['overview']['authors']['percent_rounded'] = round($vars['index_stats']['overview']['authors']['percent'], -1);
		
		$future_prefix = 'in ';
		$single_past_string = 'imminently';
		$vars['next_checks']['posts'] = '3 mins';
		$vars['next_checks']['site'] = '1 hour';
		$vars['next_checks']['num_posts_to_check'] = 5;
		$vars['next_checks']['posts_checked_per_second'] = $vars['next_checks']['num_posts_to_check'] / (15*60);
		$vars['next_checks']['posts_checked_daily'] = $vars['next_checks']['num_posts_to_check'] * 4 * 24;
		$vars['next_checks']['seconds_for_complete_post_recheck'] = @($vars['index_stats']['overview']['posts']['total'] / $vars['next_checks']['posts_checked_per_second']); // silencing a possible division by zero

		$vars['next_checks']['time_for_complete_post_recheck'] = '2 days';

		$vars['gauges']['num_pings_today'] = 74;
		$vars['gauges']['num_links_today'] = 32;
		$vars['gauges']['num_tags_today'] = 53;

	}

	wpi_render_template( 'dashboard', $vars );
	
}


// Gathers data and renders the WPI settings page
function wpi_admin_settings()
{

	$vars = array();
	$vars['admin_msgs'] = array();
	$vars['plugin_errors'] = wpi_get_errors();

	// if this is a POST request, deal with that
	if( isset($_POST['wpi_save_settings']) ) {

		// put all the form vars into an array, one at a time.
		// Then use the save function to store them all.
		$update = array();
		
		$update['wpi_status'] = ( isset($_POST['wpi_status']) ? 1 : 0 );
		$update['wpi_tags'] = ( isset($_POST['wpi_tags']) ? (int)$_POST['wpi_tags'] : 0 );
		if( $update['wpi_tags'] > 9 )
			$update['wpi_tags'] = 9;
		$update['wpi_homepage'] = ( isset($_POST['wpi_homepage']) ? 1 : 0 );
		$update['wpi_auth'] = ( isset($_POST['wpi_auth']) ? (int)$_POST['wpi_auth'] : 0 );
		if( $update['wpi_auth'] > 9 )
			$update['wpi_auth'] = 9;
		$update['wpi_rss'] = ( isset($_POST['wpi_rss']) ? 1 : 0 );
		$update['wpi_check'] = ( isset($_POST['wpi_check']) ? (int)$_POST['wpi_check'] : 0 );
		if( $update['wpi_check'] > 9 )
			$update['wpi_check'] = 9;
		$update['wpi_relatedposts'] = ( isset($_POST['wpi_relatedposts']) ? (int)$_POST['wpi_relatedposts'] : 0 );
		if( $update['wpi_relatedposts'] > 9 )
			$update['wpi_relatedposts'] = 9;
		$update['wpi_ping'] = ( isset($_POST['wpi_ping']) ? 1 : 0 );

		// now save the data
		foreach( $update as $name => $value )
			update_option($name, $value);

		// confirmation messages are always nice
		$vars['admin_msgs'][] = array( 'msg'=>'Settings updated', 'type'=>'good' );
		wpi_log('Plugin settings updated!');

	}

	// collect the plugins settings for display
	$vars['wpi_status'] = ( (bool) get_option('wpi_status') ? ' checked="checked" ' : '' );
	$vars['wpi_tags'] = (int) get_option('wpi_tags');
	$vars['wpi_homepage'] = ( (bool) get_option('wpi_homepage') ? ' checked="checked" ' : '' );
	$vars['wpi_auth'] = (int) get_option('wpi_auth');
	$vars['wpi_rss'] = ( (bool) get_option('wpi_rss') ? ' checked="checked" ' : '' );
	$vars['wpi_check'] = (int) get_option('wpi_check');
	$vars['wpi_relatedposts'] = (int) get_option('wpi_relatedposts');
	$vars['wpi_ping'] = ( (bool) get_option('wpi_ping') ? ' checked="checked" ' : '' );

	if( isset($_GET['wpi_debug']) ) {
		$vars['debug'] = true;
		echo '<h2>WPI debug: $vars</h2><pre>' . print_r($vars, true) . '</pre>';
		echo '<h2>WPI debug: $_POST</h2><pre>' . print_r($_POST, true) . '</pre>';
	}

	wpi_render_template( 'settings', $vars );

}


// Gathers data and renders the WPI log page
function wpi_admin_log()
{

	$vars = array();
	$vars['admin_msgs'] = array();

	if( isset($_POST['wpi_clear_log']) ) {
		if( wpi_clearlog() )
			$vars['admin_msgs'][] = array( 'msg'=>'Log Cleared', 'type'=>'good' );
		else
			$vars['admin_msgs'][] = array( 'msg'=>'Could not clear WPI log. Please make sure this log.txt file is writable by the server: /wp-content/plugins/wp-indexer/txt/log.txt', 'type'=>'bad' );
	}

	// get all log entries if they've clicked the button
	$num = ( isset($_POST['wpi_show_all']) ? 10000 : 250 );
	$vars['log'] = wpi_get_log( $num, true );;

	// if we've got all the log entries, show a special title and set a var so we don't show the "Show All" btn.
	if( $vars['log']['total_num'] === $vars['log']['num'] ) {
		$vars['title'] = 'All Log Entries';
		$vars['showing_all'] = true;
	}
	else {
		$vars['title'] = 'Recent Log Entries';
		$vars['showing_all'] = false;
	}

	$vars['plugin_errors'] = wpi_get_errors();

	wpi_render_template( 'log', $vars );

}


// Gathers data and renders the WPI support page
function wpi_admin_support()
{

	$vars = array();
	wpi_render_template( 'support', $vars );

}




###############################################
# WPI-specific helper functions
###############################################


// checks the hosting, WP and WPI status and returns an array of errors messages (if any).
// Used on dashboard, settings and log to show list of any errors.
function wpi_get_errors()
{
	
	$errors = array();
	
	if( !(bool) get_option('wpi_status', 0) )
		$errors[] = 'WPI is turned off so nothing will happen. Turn it on in the settings.';

	if( $_SERVER['HTTP_HOST'] === 'localhost' )
		$errors[] = 'WPI won\'t work on localhost because Google can\'t index your blog.';

	if( (bool) ini_get('safe_mode') )
		$errors[] = 'Your php.ini settings show that safe_mode is ON which can cause problems. Contact your host to see if they will turn this off.';

	if( !function_exists('curl_init') )
		$errors[] = 'It looks like your server doesn\'t have cURL installed - you\'ll need this. Ask your host to install it for you.';

	if( WPI_FOL !== str_replace('.php', '', WPI_PLUG_FILE_NAME) )
		$errors[] = 'The plugin folder is incorrectly named! Please change the plugin folder to "' . WPI_FOL . '" (without quotes) to ensure things work correctly :)';
	
	if( strnatcmp( phpversion(), '5.2' ) < 0  )
		$errors[] = 'Your PHP version is ' . phpversion() . ' and not the minimum required (5.2). Upgrade the PHP version or try ' . WPI_NAME . ' on a different server.';
	
	global $wp_version;
	if( strnatcmp( $wp_version, '3.3' ) < 0  )
		$errors[] = 'Your WordPress version is ' . $wp_version . ' and not the minimum recommended (3.3). Upgrade WordPress to fix this issue.';
	
	//if( !(bool) ini_get("allow_url_fopen") )
		//$errors[] = 'The php.ini setting "allow_url_fopen" is disabled which may cause problems with fetching some content and images. You should ask your host to enable this.';
	
	if( file_exists( ABSPATH.PLUGINDIR."/".WPI_PLUG_FILE_NAME ) )
		$errors[] = 'It looks like you haven\'t uploaded the plugin correctly. It should be in it\'s own folder - not directly in the plugins folder. The correct path should be "wp-content/plugins/' . WPI_FOL . '/". Please upload the plugin in it\'s own folder.';

	if( !is_writable(WPI_PATH . 'txt/log.txt') )
		$errors[] = 'WPI needs to log it\'s activity in a text file, but it\'s not writable by your server. You need to chmod the following file to 777 in your FTP program: /wp-content/plugins/wp-indexer/txt/log.txt';

	if( !file_exists(WPI_PATH . 'txt/stopwords.txt') )
		$errors[] = 'Can\'t file the list of stopwords. WPI expected it to be here: /wp-content/plugins/wp-indexer/txt/stopwords.txt';

	return $errors;
	
}


// Adds a new line to the WPI log.txt. It auto prefixes with the date and time.
function wpi_log($message)
{

	$date = gmdate('jS M Y H:i:s');
	$log_path = WPI_PATH . 'txt/log.txt';
	if( is_writable($log_path) )
		file_put_contents($log_path, "$date\t$message\n", FILE_APPEND);

}


// clear the log.txt file if it's getting to huge.
// Triggered by the "Clear Log" button on the plugin Log page.
function wpi_clearlog()
{

	$log_path = WPI_PATH . 'txt/log.txt';

	if( is_writable($log_path) ) {
		file_put_contents($log_path, '');
		return true;
	}

	return false;

}


// returns an array of log items from log.txt
function wpi_get_log($limit=false, $return_as_string=false)
{

	$data = array();
	$log_path = WPI_PATH . 'txt/log.txt';
	$data['entries'] = file($log_path);
	$data['total_num'] = count($data['entries']);

	// if the log is more than 5k entries, trim and reload
	if( $data['total_num'] > 10000 ) {
		wpi_log("Log size larger than 10k entries. Trimming...");
		file_put_contents($log_path, array_slice($data['entries'], 0, 10000));
		$data['entries'] = file($log_path);
		$data['total_num'] = count($data['entries']);
	}

	// put the latest ones at the top
	$data['entries'] = array_reverse($data['entries']);

	
	$data['size'] = wpi_format_bytes( filesize($log_path) );

	if( $limit )
		$data['entries'] = array_slice($data['entries'], 0, $limit);
	
	$data['num'] = count($data['entries']);

	if( $return_as_string )
		$data['entries'] = implode('', $data['entries']);

	return $data;

}


// returns array of links, optionally limited
function wpi_load_homepage_links($limit=false)
{
	
	$urls = array(
		'http://www.deviantart.com/users/outgoing?[URL]',
		'http://www.aboutus.org/[URL]',
		'http://www.quantcast.com/[URL]',
		'http://www.alexa.com/siteinfo/[URL]',
		'http://www.alexa.com/data/details/?url=[URL]',
		'http://page2rss.com/page?url=[URL]',
		'http://www.cubestat.com/[URL]',
		'http://uptime.netcraft.com/up/graph?site=[URL]',
		'http://www.alexa.com/data/details/traffic_details/[URL]',
		'http://www.alexa.com/siteinfo/[URL]/',
		'http://www.markosweb.com/www/[URL]/',
		'http://www.protect-x.com/info/[URL]',
		'http://www.surcentro.com/en/info/[URL]',
		'http://indexed.webmasterhome.cn/?domain=[URL]',
		'http://indexed.linkhelper.cn/?weburl=[URL]',
		'http://www.123cha.com/domain/?q=[URL]',
		'http://www.linkhelper.cn/?weburl=[URL]&bshow=1&selectall=1&checkbaiducount=1&checkpr=1&checkbacklink=1&checkbaiducachetime=1&links=',
		'http://indexed.linkhelper.cn/querypr.asp?url=[URL]',
		'http://www.sogou.com/web?query=[URL]',
		'http://alexa.epclean.com/?url=[URL]',
		'http://so.5eo.com/alexa/index.php?url=[URL]',
		'http://alexa.seek114.com/[URL].html',
		'http://alexa.epclean.com/alexa.asp?url=[URL]',
		'http://www.123cha.com/alexa/[URL]/',
		'http://www.linkhelper.cn/queryhistory.asp?weburl=[URL]',
		'http://whois.toolsky.com/?domain=[URL]',
		'http://www.911cha.com/whois/[URL].html',
		'http://blogsearch.sogou.com/blog?query=[URL]&num=10&w=07010300',
		'http://pr.toolsky.com/pr.asp?domain=[URL]',
		'http://web.archive.org/web/*/http://[URL]',
		'http://cnweb.search.live.com/results.aspx?q=[URL]&go=&form=QBRE',
		'http://ip.toolsky.com/?IPstr=[URL]',
		'http://www.netinfo.org.ua/[URL].htm',
		'http://cnweb.search.live.com/results.aspx?q=[URL]&form=QBLH',
		'http://www.sogou.com/web?query=[URL]&_asf=www.sogou.com&_ast=1225639193&w=01019900&p=40040100',
		'http://a.55.la/index.php?domainName=[URL]',
		'http://www.sogou.com/web?query=link%3A[URL]',
		'http://search.msn.com/results.aspx?q=site%3A[URL]',
		'http://www.myip.cn/[URL]/1',
		'http://www.myip.cn/inlinks.php?q=[URL]',
		'http://www.sitedossier.com/site/[URL]',
		'http://www.alexa.com/data/details/traffic_details/[URL]?q=',
		'http://www.xamq.com/tj/index/?url=[URL]',
		'http://www.sogou.com/web?query=link%3A[URL]',
		'http://www.alexa.com/data/details/traffic_details?url=[URL]',
		'http://cnweb.search.live.com/results.aspx?go=&form=QBLH&q=site%3A[URL]',
		'http://www.chaxia.com/alexa/Index.asp?url=[URL]',
		'http://www.sogou.com/web?query=link%3A[URL]&num=10',
		'http://seo.seores.com/?domain=[URL]&seorank=alexa',
		'http://seo.seores.com/?domain=http%3A%2F%2F[URL]&seorank=alexa&seorank=pr&seose=baidu&seose=google&seose=yahoo',
		'http://www.linkhelper.cn/?weburl=[URL]',
		'http://www.sogou.com/web?query=link:[URL]',
		'http://tool.liehuo.net/baidu.php/[URL]/1/1/',
		'http://tool.liehuo.net/baidu.php/[URL]/0/1/',
		'http://seo.seores.com/index.asp?domain=http%3A%2F%2F[URL]&seorank=alexa&seorank=pr&seose=baidu&seose=google&seose=yahoo',
		'http://www.cubestat.com/www.[URL]',
		'http://www.theamericanmuslim.org/tam.php?URL=[URL]',
		'http://domaintz.com/tools/overview/[URL]',
		'http://whois.domaintools.com/[URL]',
		'http://www.domaintools.com/research/hosting-history/?q=[URL]',
		'http://www.downforeveryoneorjustme.com/[URL]',
		'http://www.isup.me/[URL]',
		'http://isitdownforjustme.com/result.php?s=[URL]',
		'http://www.status.ws/[URL]',
		'http://isitdownjustforme.com/result.php?s=[URL]',
		'http://www.websitedown.info/[URL]',
		'http://doj.me/?url=[URL]',
		'http://isdownorjustme.com/result.php?s=[URL]',
		'http://isitjustdownforme.com/result.php?s=[URL]',
		'http://downorisitjustme.com/res.php?url=[URL]',
		'http://www.websitenotworking.com/[URL]',
		'http://dnscheck.pingdom.com/?domain=[URL]',
		'http://pingability.com/zoneinfo.jsp?domain=[URL]',
		'http://validator.w3.org/checklink?uri=[URL]&hide_type=all&depth=&check=Check',
		'http://wgtools.com/link-checker/?url=[URL]',
		'http://www.webmaster-toolkit.com/link-checker.shtml?url=http%3A%2F%2F[URL]&type=href',
		'http://www.ranks.nl/cgi-bin/ranksnl/tools/checklink.cgi?uri=[URL]&hide_type=all&no_accept_language=on&recursive=on&depth=0&check=Check',
		'http://dndetails.com/[URL]',
		'https://developers.google.com/speed/pagespeed/insights#url=[URL]&mobile=false',
	);


	if( $limit ) {
		shuffle($urls);
		$urls = array_slice($urls, 0, (int)$limit);
	}
	
	return $urls;

}


// wrapper for various HTTP web request abilities
// $post_vars should be an array of post data
// This is rarely used anymore, since we now use WPI_Curly for bulk requests
function wpi_http($url, $post_vars=false, $http_headers=false, $return_info=false)
{

	if( !function_exists('curl_init') ) {
		wpi_log('cURL functions not installed on server!');
		return false;
	}

	if( !$http_headers )
		$http_headers = array("Accept: text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*"."/*;q=0.5", "Cache-Control: max-age=0", "Connection: keep-alive", "Keep-Alive: 300", "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7", "Accept-Language: en-us,en;q=0.5", "Pragma: ");

	$curl = curl_init();
	curl_setopt($curl, CURLOPT_URL, $url);
	if( $post_vars ) {
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $post_vars);
	}
	if( strstr('https', $url) ) {
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false );
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false );
	}
	curl_setopt($curl, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)");
	curl_setopt($curl, CURLOPT_HTTPHEADER, $http_headers);
	curl_setopt($curl, CURLOPT_ENCODING, "gzip,deflate");
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($curl, CURLOPT_TIMEOUT, 5);
	curl_setopt($curl, CURLOPT_AUTOREFERER, 1);
	@curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1); // silenced to remove the warning when safe_mode or open_basedir are on
	$html = curl_exec($curl);
	curl_close($curl);


	return $html;

}


// returns an array of pre-tested ping targets
function wpi_load_ping_list()
{

	// these are all pre-tested services that work with the weblogUpdates.extendedPing protocol
	return array(
		'http://audiorpc.weblogs.com/RPC2',
		'http://bloglines.com/ping',
		'http://blogpeople.net/ping',
		'http://blogpeople.net/servlet/weblogUpdates',
		'http://blogpingr.de/ping/rpc2',
		'http://blogsearch.google.ae/ping/RPC2',
		'http://blogsearch.google.at/ping/RPC2',
		'http://blogsearch.google.be/ping/RPC2',
		'http://blogsearch.google.bg/ping/RPC2',
		'http://blogsearch.google.ca/ping/RPC2',
		'http://blogsearch.google.ch/ping/RPC2',
		'http://blogsearch.google.cl/ping/RPC2',
		'http://blogsearch.google.co.cr/ping/RPC2',
		'http://blogsearch.google.co.hu/ping/RPC2',
		'http://blogsearch.google.co.id/ping/RPC2',
		'http://blogsearch.google.co.il/ping/RPC2',
		'http://blogsearch.google.co.in/ping/RPC2',
		'http://blogsearch.google.co.jp/ping/RPC2',
		'http://blogsearch.google.co.ma/ping/RPC2',
		'http://blogsearch.google.co.nz/ping/RPC2',
		'http://blogsearch.google.co.th/ping/RPC2',
		'http://blogsearch.google.co.uk/ping/RPC2',
		'http://blogsearch.google.co.ve/ping/RPC2',
		'http://blogsearch.google.co.za/ping/RPC2',
		'http://blogsearch.google.com.ar/ping/RPC2',
		'http://blogsearch.google.com.au/ping/RPC2',
		'http://blogsearch.google.com.br/ping/RPC2',
		'http://blogsearch.google.com.co/ping/RPC2',
		'http://blogsearch.google.com.do/ping/RPC2',
		'http://blogsearch.google.com.mx/ping/RPC2',
		'http://blogsearch.google.com.my/ping/RPC2',
		'http://blogsearch.google.com.pe/ping/RPC2',
		'http://blogsearch.google.com.sa/ping/RPC2',
		'http://blogsearch.google.com.sg/ping/RPC2',
		'http://blogsearch.google.com.tr/ping/RPC2',
		'http://blogsearch.google.com.tw/ping/RPC2',
		'http://blogsearch.google.com.ua/ping/RPC2',
		'http://blogsearch.google.com.uy/ping/RPC2',
		'http://blogsearch.google.com.vn/ping/RPC2',
		'http://blogsearch.google.com/ping/RPC2',
		'http://blogsearch.google.de/ping/RPC2',
		'http://blogsearch.google.es/ping/RPC2',
		'http://blogsearch.google.fi/ping/RPC2',
		'http://blogsearch.google.fr/ping/RPC2',
		'http://blogsearch.google.gr/ping/RPC2',
		'http://blogsearch.google.hr/ping/RPC2',
		'http://blogsearch.google.ie/ping/RPC2',
		'http://blogsearch.google.it/ping/RPC2',
		'http://blogsearch.google.jp/ping/RPC2',
		'http://blogsearch.google.lt/ping/RPC2',
		'http://blogsearch.google.nl/ping/RPC2',
		'http://blogsearch.google.pl/ping/RPC2',
		'http://blogsearch.google.pt/ping/RPC2',
		'http://blogsearch.google.ro/ping/RPC2',
		'http://blogsearch.google.ru/ping/RPC2',
		'http://blogsearch.google.se/ping/RPC2',
		'http://blogsearch.google.sk/ping/RPC2',
		'http://blogsearch.google.tw/ping/RPC2',
		'http://blogsearch.google.us/ping/RPC2',
		'http://ping.blo.gs',
		//'http://ping.blogs.yandex.ru/RPC2',
		//'http://ping.feedburner.com',
		'http://ping.pubsub.com/ping',
		'http://ping.syndic8.com/xmlrpc.php',
		'http://rpc.aitellu.com',
		//'http://rpc.reader.livedoor.com/ping',
		'http://rpc.weblogs.com/RPC2',
		'http://www.bloglines.com/ping',
		'http://www.blogpeople.net/ping',
		'http://www.blogpeople.net/servlet/weblogUpdates',
		'http://www.blogsearch.google.ae/ping/RPC2',
		'http://www.blogsearch.google.at/ping/RPC2',
		'http://www.blogsearch.google.be/ping/RPC2',
		'http://www.blogsearch.google.bg/ping/RPC2',
		'http://www.blogsearch.google.ca/ping/RPC2',
		'http://www.blogsearch.google.ch/ping/RPC2',
		'http://www.blogsearch.google.cl/ping/RPC2',
		'http://www.blogsearch.google.co.cr/ping/RPC2',
		'http://www.blogsearch.google.co.hu/ping/RPC2',
		'http://www.blogsearch.google.co.id/ping/RPC2',
		'http://www.blogsearch.google.co.il/ping/RPC2',
		'http://www.blogsearch.google.co.in/ping/RPC2',
		'http://www.blogsearch.google.co.jp/ping/RPC2',
		'http://www.blogsearch.google.co.ma/ping/RPC2',
		'http://www.blogsearch.google.co.nz/ping/RPC2',
		'http://www.blogsearch.google.co.th/ping/RPC2',
		'http://www.blogsearch.google.co.uk/ping/RPC2',
		'http://www.blogsearch.google.co.ve/ping/RPC2',
		'http://www.blogsearch.google.co.za/ping/RPC2',
		'http://www.blogsearch.google.com.ar/ping/RPC2',
		'http://www.blogsearch.google.com.au/ping/RPC2',
		'http://www.blogsearch.google.com.br/ping/RPC2',
		'http://www.blogsearch.google.com.co/ping/RPC2',
		'http://www.blogsearch.google.com.do/ping/RPC2',
		'http://www.blogsearch.google.com.mx/ping/RPC2',
		'http://www.blogsearch.google.com.my/ping/RPC2',
		'http://www.blogsearch.google.com.pe/ping/RPC2',
		'http://www.blogsearch.google.com.sa/ping/RPC2',
		'http://www.blogsearch.google.com.sg/ping/RPC2',
		'http://www.blogsearch.google.com.tr/ping/RPC2',
		'http://www.blogsearch.google.com.tw/ping/RPC2',
		'http://www.blogsearch.google.com.ua/ping/RPC2',
		'http://www.blogsearch.google.com.uy/ping/RPC2',
		'http://www.blogsearch.google.com.vn/ping/RPC2',
		'http://www.blogsearch.google.com/ping/RPC2',
		'http://www.blogsearch.google.de/ping/RPC2',
		'http://www.blogsearch.google.es/ping/RPC2',
		'http://www.blogsearch.google.fi/ping/RPC2',
		'http://www.blogsearch.google.fr/ping/RPC2',
		'http://www.blogsearch.google.gr/ping/RPC2',
		'http://www.blogsearch.google.hr/ping/RPC2',
		'http://www.blogsearch.google.ie/ping/RPC2',
		'http://www.blogsearch.google.it/ping/RPC2',
		'http://www.blogsearch.google.jp/ping/RPC2',
		'http://www.blogsearch.google.lt/ping/RPC2',
		'http://www.blogsearch.google.nl/ping/RPC2',
		'http://www.blogsearch.google.pl/ping/RPC2',
		'http://www.blogsearch.google.pt/ping/RPC2',
		'http://www.blogsearch.google.ro/ping/RPC2',
		'http://www.blogsearch.google.ru/ping/RPC2',
		'http://www.blogsearch.google.se/ping/RPC2',
		'http://www.blogsearch.google.sk/ping/RPC2',
		'http://www.blogsearch.google.us/ping/RPC2',
		//'http://xmlrpc.bloggernetz.de/RPC2',
		'http://xping.pubsub.com/ping',
	);

}


// returns a valid XML ping structure, ready to POST to a ping service.
function wpi_build_ping_request($title, $blog_url, $post_url='', $rss_url='')
{

	return "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>
	<methodCall>
		<methodName>weblogUpdates.extendedPing</methodName>
		<params>
			<param>
				<value>$title</value>
			</param>
			<param>
				<value>$blog_url</value>
			</param>
			<param>
				<value>$post_url</value>
			</param>
			<param>
				<value>$rss_url</value>
			</param>
		</params>
	</methodCall>";

}




###############################################
# WPI main feature functions
###############################################


// this is called when a new post is made, and it decides which features to run.
function wpi_action_wrapper($post_id=false)
{

	// if this function is trying to run in a loop, don't let it
	if( isset($GLOBALS['WPI_RUNNING']) )
		return false;
	$GLOBALS['WPI_RUNNING'] = true;
	
	// the publish_post action also fires when a publihed post is being EDITED.
	// We need to stop that or it will cause infinite looping...
	if( isset($_POST['original_post_status']) && $_POST['original_post_status'] === 'publish' )
		return false;
	
	// also we don't need to do anything for post revisions, as it's autoposted spam by WP
	if( wp_is_post_revision($post_id) )
		return false;
	
	$plugin_errors = wpi_get_errors();
	if( !empty($plugin_errors) ) {
		wpi_log('Errors detected - can\'t run plugin. See plugin settings page in WP for more info.');
		return false;
	}
	
	if( !$post_id || !is_int($post_id) ) {
		wpi_log("Post id '$post_id' is invalid!");
		return false;
	}

	// include our custom classes and check everything's in place
	require_once WPI_PATH . 'lib/WPI_Curly.class.php';
	if( !class_exists('WPI_Curly') ) {
		wpi_log('Couldn\'t load class WPI_Curly!');
		return false;
	}
	
	if( !function_exists('curl_init') ) {
		wpi_log('cURL functions not installed on server!');
		return false;
	}
	
	require_once WPI_PATH . 'lib/WPI_SIP.class.php';
	if( !class_exists('WPI_SIP') ) {
		wpi_log('Couldn\'t load class WPI_SIP!');
		return false;
	}

	// ok we look good to go from here
	wpi_log("---> WPI starting to process post_id=$post_id...");

	// this will be an array, with each item being another array like so:
	// array( 'name'=>... 'url'=>... )
	// Each feature function should return an array in this format ready for pinging
	// If the 'name' key is empty, when pinging the URL will be used as the name
	$links_gathered = array();

	// Relevant Tags
	$num_tags = (int) get_option('wpi_tags');
	if( $num_tags )
		wpi_add_tags($post_id, $num_tags);

	// Homepage Links
	if( (bool) get_option('wpi_homepage') ) {
		$new_links = wpi_get_homepage_links(1);
		$links_gathered = array_merge($links_gathered, $new_links);
	}

	// Authority Pingbacks
	$num_auth_links = (int) get_option('wpi_auth');
	if( $num_auth_links )
		wpi_get_auth_links($post_id, $num_auth_links);

	// RSS Pinging
	if( (bool) get_option('wpi_rss') ) {
		$new_links = wpi_get_rss_links($post_id);
		$links_gathered = array_merge($links_gathered, $new_links);
	}

	// mass ping links collected if required
	if( (bool) get_option('wpi_ping') )
		wpi_bulk_ping($links_gathered);

}


// update the blog overall index stats (everything but "posts" under "Indexation Overview" on the dash)
// Runs via the wpi_three_hour_cron_event
function wpi_check_site_index_status()
{

	if( !(bool) get_option('wpi_status') )
		return false;

	$wpi_errors = wpi_get_errors();
	if( !empty($wpi_errors) ) {
		wpi_log('Can\'t check site index status because ' . count($wpi_errors) . ' errors were found!');
		return false;
	}

	// include our custom classes and check everything's in place
	require_once WPI_PATH . 'lib/WPI_Curly.class.php';
	if( !class_exists('WPI_Curly') ) {
		wpi_log('Couldn\'t load class WPI_Curly!');
		return false;
	}

	if( !function_exists('curl_init') ) {
		wpi_log('cURL functions not installed on server!');
		return false;
	}

	$blog_url = get_option('siteurl');
	$google_q = 'http://www.google.com/search?q=';

	$c = new WPI_Curly;

	// add this in later, or do it as a seperate query for clarity. It's the RSS for the WP links in the dashboard, to be added to the wpi_links_today wp_option.
	//$blog_link_query = 'http://www.google.com/search?ie=utf-8&q=' . urlencode("link:$blog_url") . '&tbm=blg&tbs=sbd:1&output=rss';
	//$c->add( array( 'url' => $blog_link_query, 'query_type' => 'blog_link' ) );

	$overall_query = $google_q . urlencode("site:$blog_url");
	$c->add( array( 'url' => $overall_query, 'query_type' => 'homepage' ) );

	$author_query = $google_q . urlencode("site:$blog_url inurl:/author");
	$c->add( array( 'url' => $author_query, 'query_type' => 'author' ) );

	$tag_query = $google_q . urlencode("site:$blog_url inurl:/tag");
	$c->add( array( 'url' => $tag_query, 'query_type' => 'tag' ) );

	$category_query = $google_q . urlencode("site:$blog_url inurl:/category");
	$c->add( array( 'url' => $category_query, 'query_type' => 'category' ) );

	$data = $c->fetch();

	foreach( $data as $item ) {

		if( $item['http_code'] === 0 ) {
			wpi_log("Index Timeout: Google timedout checking for $blog_url ($item[query_type]) (http_code: $item[http_code])");
			continue;
		}

		if( $item['http_code'] !== 200 ) {
			wpi_log("Index Refused: Google refused check for $blog_url ($item[query_type]) (http_code: $item[http_code])");
			continue;
		}

		if( strstr($item['html'], 'did not match any documents') ) {
			wpi_log("Not Yet Indexed: $blog_url ($item[query_type])");
			continue;
		}

		preg_match('#<div id="resultStats">(About )?([0-9,]+) result#si', $item['html'], $matches);
		if( !empty($matches[2]) ) {
			$num_results = (int) str_replace(',', '', $matches[2]);
			update_option( 'wpi_index_num_'.$item['query_type'], $num_results );
			wpi_log("Indexed Stat OK: $blog_url ($item[query_type]) has $num_results results indexed");
			continue;
		}

		// don't know what happened here. Google cache format maybe changed
		wpi_log("Index Unparsable: Couldn't parse html for $item[query_type]: $item[url]");

	}

}


// Checks the index status in Google for the required number (0-9) of unindexed posts.
// This runs via the wpi_quater_hour_cron_event hook
function wpi_check_post_index_status()
{

	if( !(bool) get_option('wpi_status') )
		return false;

	$wpi_errors = wpi_get_errors();
	if( !empty($wpi_errors) ) {
		wpi_log('Can\'t check post index status because ' . count($wpi_errors) . ' errors were found!');
		return false;
	}

	// don't bother checking post stats if the homepage isn't indexed yet
	if( (bool) get_option('wpi_homepage', 0) ) {
		wpi_log('No point checking post index status because the homepage isn\'t indexed yet');
		return false;
	}

	// include our custom classes and check everything's in place
	require_once WPI_PATH . 'lib/WPI_Curly.class.php';
	if( !class_exists('WPI_Curly') ) {
		wpi_log('Couldn\'t load class WPI_Curly!');
		return false;
	}

	if( !function_exists('curl_init') ) {
		wpi_log('cURL functions not installed on server!');
		return false;
	}

	$num_posts_to_check = (int) get_option('wpi_check');
	$posts_ids = wpi_get_unindexed_post_ids($num_posts_to_check);

	// build the Curly array
	$c = new WPI_Curly;

	foreach( $posts_ids as $post_id ) {
		$post_url = get_permalink($post_id);
		$cache_url = 'http://webcache.googleusercontent.com/search?q=' . urlencode('cache:' . $post_url);
		$c->add( array(
			'url' => $cache_url,
			'post_id' => $post_id,
			'post_url' => $post_url
		) );
	}

	$data = $c->fetch();

	foreach( $data as $item ) {

		if( $item['http_code'] === 0 || empty($item['html']) ) {
			wpi_log("Index Timeout: Google timedout trying to check $item[url] (http_code: $item[http_code])");
			continue;
		}

		if( $item['http_code'] === 404 ) {
			update_post_meta($item['post_id'], '_wpi_not_indexed', gmdate('U'));
			wpi_log("Not Yet Indexed: $item[post_url]");
			continue;
		}

		if( $item['http_code'] !== 200 ) {
			wpi_log("Index Refused: Google refused check for $item[url] (http_code: $item[http_code])");
			continue;
		}

		if( strstr($item['html'], 'snapshot of the page as it appeared') ) {
			preg_match('#snapshot of the page as it appeared on ([^.]+)\.#si', $item['html'], $matches);
			$cache_time_stamp = strtotime( $matches[1], gmdate('U') );
			update_post_meta($item['post_id'], '_wpi_indexed', $cache_time_stamp);
			wpi_log("Indexed on $matches[1]: $item[post_url]");
			$num_indexed = get_option('wpi_n_new_indexed', 0);
			update_option('wpi_n_new_indexed', $num_indexed+1);
			continue;
		}

		// sometimes google like to redirect to a search result if the URL is broken. We can detect that...
		if( strstr($item['html'], '<a href="/intl/en/about.html">About Google</a>‎') ) {
			wpi_log("Index Redirect: Google couldn't read the URL ($item[url]), so it redirected to a SE results page");
			continue;
		}

		// don't know what happened here. Google cache format maybe changed
		wpi_log("Index Unparsable: Couldn't parse html for $item[url]");

	}

}


// The core meaty query to get an array of unindexed posts from the DB.
// It returns an array of post_ids that either have the _wpi_not_indexed meta,
// or no wpi meta ta all (i.e. they're unchecked).
// We're using RAND() ordering in this query, which is a bad thing.
// But after testing on a blog with ~5k posts it's still under 100ms.
function wpi_get_unindexed_post_ids($num)
{

	global $wpdb;
	$num = (int) $num;

	// get all posts that WPI hasn't checked yet, or has checked but arn't indexed.
	$unchecked_post_ids = $wpdb->get_results("
		SELECT
			DISTINCT ID
		FROM
			$wpdb->posts AS p
		LEFT JOIN
			$wpdb->postmeta AS pm
		ON
			p.ID=pm.post_id
		WHERE
			p.post_status = 'publish'
		AND
			p.post_type = 'post'
		AND
		(
					pm.meta_key = '_wpi_not_indexed'
				OR
					p.ID NOT IN
					(
						SELECT
							DISTINCT post_id
						FROM
							$wpdb->postmeta
						WHERE
							meta_key = '_wpi_indexed'
						OR
							meta_key = '_wpi_not_indexed'
					)
			)
		ORDER BY
			RAND()
		LIMIT $num
	", ARRAY_N);

	// clean up the WP query array
	$post_ids = array();
	foreach( $unchecked_post_ids as $pid )
		$post_ids[] = $pid[0];

	return $post_ids;

}


// This is a helper query function that powers the list of related posts below the content.
// It's pretty resource intensive, so it's only run on a single post page (not on cat views).
// This function will favor the same posts (that happen to have the lowest post IDs) first.
function wpi_get_related_unindexed_posts($post_id, $num_posts)
{

	global $wpdb;
	$post_id = (int) $post_id;
	$num_posts = (int) $num_posts;

	// find posts that have the same post tags or categories as this one and are unindexed
	// we exclude the Uncategorized cat, and also the original post_id
	$posts = $wpdb->get_results("
		SELECT
			p.ID,
			p.post_title,
			tr.term_taxonomy_id
		FROM
			$wpdb->posts AS p
		LEFT JOIN
			$wpdb->term_relationships AS tr
		ON
			p.ID = tr.object_id
		LEFT JOIN
			$wpdb->postmeta AS pm
		ON
			p.ID=pm.post_id
		WHERE
			p.ID != $post_id
		AND
			tr.term_taxonomy_id != 1
		AND
		(
				pm.meta_key = '_wpi_not_indexed'
			OR
				p.ID NOT IN
				(
					SELECT
						DISTINCT post_id
					FROM
						$wpdb->postmeta
					WHERE
						meta_key = '_wpi_indexed'
					OR
						meta_key = '_wpi_not_indexed'
				)
		)
		AND
			tr.term_taxonomy_id IN
			(
				SELECT
					term_taxonomy_id
				FROM
					$wpdb->term_relationships
				WHERE
					object_id = $post_id
			)
		GROUP BY
			p.ID
		LIMIT
			$num_posts
	", ARRAY_A);

	return $posts;

}


// Function that builds the HTML for the related posts below content.
// Called, if required, with a filter on "the_content"
function wpi_add_related_unindexed_posts($content)
{

	// don't show on category/archive pages, because the query is resource heavy.
	if( !is_single() )
		return $content;

	// we're using this in the loop (via a the_content filter) so post ID is easily grabbable
	global $post;

	$num_posts = (int) get_option('wpi_relatedposts', 0);
	$related_posts = wpi_get_related_unindexed_posts($post->ID, $num_posts);

	$html = '<div id="related_sites"><h3>Top Similiar Posts</h3><ul>';
	foreach( $related_posts as $rel )
		$html .= '<li><a href="' . get_permalink($rel['ID']) . '">' . $rel['post_title'] . '</a></li>';
	$html .= '</ul></div><div class="fixed"></div>';

	return $content . $html;

}


// Acquires the given number of homepage links. It's run each time a post is made.
// The $force_site_url var it just for testing (because no homepage links work with localhost)
// Returns an array that can be passed to the wpi_bulk_ping function
function wpi_get_homepage_links($num_links=1, $force_site_url=false)
{

	if( $num_links === 0 )
		return false;

	// loading list
	$sitelist = wpi_load_homepage_links();

	// get this blog's details, and prepare the URL
	if( $force_site_url )
		$blog_url = $force_site_url;
	else
		$blog_url = get_option('siteurl');
	$blog_url = str_replace(
		array('www.', 'http://'),
		'',
		$blog_url
	);
	if( substr($blog_url, -1, 1) === '/')
		$blog_url = substr($blog_url, 0, -1);

	$blog_title = get_option('blogname');

	// we'll store the confirmed links here as we get them, and return them at the end
	$links_gathered = array();

	// loop and get required num links
	for( $i=0; $i<$num_links; $i++ ) {

		// shuffling list to ensure random link
		shuffle($sitelist);

		// inserting URL into link URL
		$link = str_replace("[URL]", $blog_url, $sitelist[0]);

		// connecting to the site
		$html = wpi_http($link);

		// no luck with this link...
		if( empty($html) ) {
			wpi_log("Unable to connect to $link");
			continue;
		}

		// if link found on site store it
		if( preg_match("#href=[\"']?http://(www.)?$blog_url#si", $html) ) {

			$site_url = 'http://' . preg_replace( '#/.*#si', '', str_replace( 'http://', '', $link) );
			
			// try 2 different patterns to extract an rss url from the html page
			preg_match('#http://[^\s"\'>]+\.rss#si', $html, $rss_match);
			if( !empty($rss_match[1]) )
				$rss_url = $rss_match[1];
			else {
				preg_match('#type=[\'"]?application/rss\+xml[\'"]?([^\n>]+)href=[\'"]?(http[^"\'\s>]+)[\'"]?#si', $html, $rss_match);
				$rss_url = ( !empty($rss_match[1]) ? $rss_match[1] : '' );
			}

			// try and extract a title, but use the link as a backup
			preg_match('#<title>([a-z0-9./!"£$%^&*\(\)\#,-]+)</title>#si', $html, $title_match);
			$title = ( !empty($title_match[1]) ? $title_match[1] : $link );

			$links_gathered[] = array(
				'type' => 'homepage_link',
				'title' => $title,
				'blog_url' => $site_url,
				'post_url' => $link,
				'rss_url' => $rss_url,
				'can_ping' => 'yes'
			);

			wpi_log("Homepage link gathered: $link");

		}
		
		// Otherwise return as link not found
		else
			wpi_log("Homepage link not found: $link");

	}

	// update num links today, but only if we've got some
	if( !empty($links_gathered) ) {
		$num_links_today = get_option( 'wpi_num_links_today', 0 );
		$new_total_num_links = count($links_gathered) + $num_links_today;
		update_option( 'wpi_num_links_today', $new_total_num_links );
	}

	wpi_log( count($links_gathered) . ' total homepage links gathered');
	return $links_gathered;
	
}


// Creates an array (passable to the wpi_bulk_ping function) that contains details of every URL in WP that changes when a new posts is made.
// The original post details are NOT included, because we just let WP ping that on it's own.
function wpi_get_rss_links($post_id)
{
	
	global $wp_rewrite;

	// get wordpress vars
	$site_url = get_option('siteurl');
	if( substr($site_url, -1, 1) === '/')
		$site_url = substr($site_url, 0, -1);
	
	$blog_title = get_option('blogname');
	$post_title = get_the_title($post_id);
	
	$post_url = get_permalink($post_id);
	if( substr($post_url, -1, 1) === '/')
		$post_url = substr($post_url, 0, -1);

	// find out the correct rss feed exctionsion for the type of URL the site is using
	if( strstr($post_url, '?') )
		$pretty_links = false;
	else
		$pretty_links = true;

	// compile feed array
	$feeds = array();

	// post comments feed
	$feeds[] = array(
		'type' => 'rss_comments',
		'title' => $post_title . ' Comments',
		'blog_url' => $site_url,
		'post_url' => $post_url,
		'rss_url' => ( $pretty_links ? "$post_url/feed" : "$post_url&feed=comments-rss2" ),
		'can_ping' => 'yes'
	);

	// post categories feed
	$cats = get_the_category($post_id);
	foreach( $cats as $cat ) {
		$feeds[] = array(
			'type' => 'rss_category',
			'title' => $cat->name,
			'blog_url' => $site_url,
			'post_url' => ( $pretty_links ? "$site_url/category/{$cat->slug}" : "$site_url/?cat={$cat->cat_ID}" ),
			'rss_url' => ( $pretty_links ? "$site_url/category/{$cat->slug}/feed" : "$site_url/?cat={$cat->cat_ID}&feed=rss2" ),
			'can_ping' => 'yes'
		);
	}

	// tag page and search page feeds
	$tags = wp_get_post_tags($post_id);
	foreach( $tags as $tag ) {

		// tags
		$feeds[] = array(
			'type' => 'rss_tag',
			'title' => $tag->name,
			'blog_url' => $site_url,
			'post_url' => ( $pretty_links ? "$site_url/tag/{$tag->slug}" : "$site_url/?tag={$tag->term_id}" ),
			'rss_url' => ( $pretty_links ? "$site_url/tag/{$tag->slug}/feed" : "$site_url/?tag={$tag->term_id}&feed=rss2" ),
			'can_ping' => 'yes'
		);

		// search
		$feeds[] = array(
			'type' => 'rss_search',
			'title' => "Search for {$tag->name}",
			'blog_url' => $site_url,
			'post_url' => $site_url . '/?s=' . urlencode($tag->name),
			'rss_url' => $site_url . '/?s=' . urlencode($tag->name) . '&feed=rss2',
			'can_ping' => 'yes'
		);

	}

	// author feed
	$post = get_post($post_id);
	$author_name = get_the_author_meta('user_nicename', $post->post_author);
	$feeds[] = array(
		'type' => 'rss_author',
		'title' => "Posts by $author_name",
		'blog_url' => $site_url,
		'post_url' => ( $pretty_links ? "$site_url/author/$author_name" : "$site_url?author={$post->post_author}" ),
		'rss_url' => ( $pretty_links ? "$site_url/author/$author_name/feed" : "$site_url?author={$post->post_author}&feed=rss2" ),
		'can_ping' => 'yes'
	);

	// archive for this year
	$year = gmdate("Y");
	$feeds[] = array(
		'type' => 'rss_archive',
		'title' => "Posts in $year",
		'blog_url' => $site_url,
		'post_url' => ( $pretty_links ? "$site_url/$year" : "$site_url?m=$year" ),
		'rss_url' => ( $pretty_links ? "$site_url/$year/feed" : "$site_url?m=$year&feed=rss2" ),
		'can_ping' => 'yes'
	);

	// archive for this month
	$month = gmdate("m");
	$feeds[] = array(
		'type' => 'rss_archive',
		'title' => "Posts in $year/$month",
		'blog_url' => $site_url,
		'post_url' => ( $pretty_links ? "$site_url/$year/$month" : "$site_url?m=$year$month" ),
		'rss_url' => ( $pretty_links ? "$site_url/$year/$month/feed" : "$site_url?m=$year$month&feed=rss2" ),
		'can_ping' => 'yes'
	);

	return $feeds;

}


// Uses the Google Blogsearch RSS URL to find kw related blogs, then links to them from within post content.
function wpi_get_auth_links($post_id, $max_links=5)
{
	
	// we get links to other, popular blogs from icerockets RSS search feature
	//$icerocket = 'http://www.icerocket.com/search?tab=blog&q=title%3A%22[TAG]%22&dl=&dh=&lng=en&rss=1';
	$google_blogsearch = 'http://www.google.com/search?tbm=blg&q=[TAG]&output=rss';

	$tags = wp_get_post_tags($post_id);
	if( empty($tags) ) {
		wpi_log("No tags found for post_id $post_id. Can't generate auth links");
		return false;
	}
	
	// sort tags by length. The longest are likely the most specific, and will yield better link results.
	$plain_tags = array();
	foreach( $tags as $tag )
		$plain_tags[] = $tag->name;
	usort( $plain_tags, 'wpi_sort_array_by_length' );

	// now reduce the tags to the num required
	$plain_tags = array_slice($plain_tags, 0, $max_links);

	// get the post content. We'll modify it below by addibng links, then save at the end.
	$post = get_post($post_id);
	$content = $post->post_content;

	// compile the Curly array then fetch the xml
	$c = new WPI_Curly;
	foreach( $plain_tags as $tag ) {
		// if the tag's not in the content, or it's already linked, leave it alone
		if(	!stristr($content, $tag) ||	stristr($content,  $tag . '</a>') )
			continue;

		$c->add( str_replace('[TAG]', urlencode($tag), $google_blogsearch) );
	}
	$curly = $c->fetch();

	// now loop Google's returned xml, extract the keyword from Curly's url param, then replace that kw in the content with a link
	foreach( $curly as $item ) {

		// get the tag from the url
		preg_match('#q=([^&]+)#si', $item['url'], $matches);
		$tag = urldecode($matches[1]);

		// get a random link
		preg_match_all('#<link>([^<]+)</link>#si', $item['html'], $matches, PREG_PATTERN_ORDER);
		// remove Google's own link
		if( isset($matches[1][0]) )
			unset($matches[1][0]);
		sort($matches[1]);
		shuffle($matches[1]);
		$chosen_url = $matches[1][0];

		$html_link = '<a href="' . $chosen_url . '">' . $tag . '</a>';
		$content = wpi_replace_n_occurences($content, $tag, $html_link, 1);
		
	}

	$new_post = array(
		'ID' => $post_id,
		'post_content' => $content
	);

	wp_update_post($new_post);
	wpi_log("Added " . count($curly) . " auth links for post_id=$post_id");

}


// Takes an special array format (that's returned by many other WPI functions) and bulk pings the details to the ping list.
// WPI's internal ping list is divided between the number of URLs to ping, so the same services never get over-pinged.
function wpi_bulk_ping($array, $total_max_pings=999)
{

	if( empty($array) )
		return false;

	// don't ping if we've already done so in the last 30 mins
	if( get_option('wpi_last_bulk_ping', 0) > time()-(60*30) ) {
		wpi_log('Ping Blocked: We won\'t ping now as we did so in the last 30 mins');
		return false;
	}
	update_option('wpi_last_bulk_ping', time());

	$ping_list = wpi_load_ping_list();
	shuffle($ping_list);
	$ping_list = array_slice($ping_list, 0, $total_max_pings);

	// work out how many pings each URL should get, so as not to spam the same ping service over and over
	$num_pings_per_url = floor( count($ping_list) / count($array) );

	$c = new WPI_Curly;

	// loop and stack the Curly requests
	foreach( $array as $item ) {

		if( !isset($item['can_ping']) || empty($item['can_ping']) || $item['can_ping'] === 'no' )
			continue;

		for( $i=0; $i<$num_pings_per_url; ++$i ) {

			$ping_url = array_pop($ping_list);
			$request = wpi_build_ping_request( $item['title'], $item['blog_url'], $item['post_url'], $item['rss_url'] );

			$header = array();
			$header[] = "Host: " . preg_replace( '#/.*#si', '', str_replace( 'http://', '', $ping_url) );
			$header[] = "Content-type: text/xml";
			$header[] = "Content-length: " . strlen($request) . "\r\n";
			$header[] = $request;
			
			$c->add( array(
				'url' => $ping_url,
				'opt' => array(
					'CURLOPT_CUSTOMREQUEST' => 'POST',
					'CURLOPT_HTTPHEADER' => $header,
					'CURLOPT_TIMEOUT' => 7
				),
				// add tracking data for easy reference later
				'ping_data' => array(
					'title' => $item['title'],
					'blog_url' => $item['blog_url'],
					'post_url' => $item['post_url'],
					'rss_url' => $item['rss_url']
				)
			) );

		}

	}

	// execute the HTTP requests
	$data = $c->fetch();
	//print_r($data);

	// loop and check the status of each request & log each item individually
	$status = array(
		'num_ping_services' => count($ping_list),
		'num_urls_passed_to_function' => count($array),
		'num_pings_per_url' => $num_pings_per_url,
		'total_pings_done' => count($data),
		'ping_ok' => 0,
		'ping_fail' => 0
	);

	foreach( $data as $item ) {

		// determine the url to use as a ref in the logs
		$msg_url = ( !empty($item['ping_data']['rss_url']) ? $item['ping_data']['rss_url'] : $item['ping_data']['post_url'] );

		if( $item['http_code'] === 0 || empty($item['html']) ) {
			wpi_log("Ping Timeout: $item[url] trying to ping $msg_url");
			++$status['ping_fail'];
			continue;
		}

		if( $item['http_code'] !== 200 ) {
			wpi_log("Ping HTTP Error: $item[url] failed to load when pinging $msg_url (http_code: $item[http_code])");
			++$status['ping_fail'];
			continue;
		}
	
		$response = @xmlrpc_decode($item['html']);
		if( $response && xmlrpc_is_fault($response) ) {
			wpi_log("Ping Failed: $item[url] didn\'t return valid xml when pinging $msg_url (xmlrpc: $response[faultString]. FaultCode: $response[faultCode])");
			++$status['ping_fail'];
			continue;
		}
		
		if( isset($response['flerror']) && !empty($response['flerror']) ) {
			$message = ( isset($response['message']) ? trim($response['message']) : 'fail' );
			wpi_log("Ping Rejected: $item[url] rejected $msg_url (message: $message)");
			++$status['ping_fail'];
			continue;
		}
		
		$message = ( isset($response['message']) ? trim($response['message']) : 'ok' );
		++$status['ping_ok'];

	}

	// update the daily num pings
	$num_pings_today = get_option( 'wpi_num_pings_today', 0 );
	$new_total_num_pings = $status['ping_ok'] + $num_pings_today;
	update_option( 'wpi_num_pings_today', $new_total_num_pings );

	// log and return
	wpi_log("Ping OK: $status[ping_ok] pings executed successfully");
	return $status;

}


// Uses the WPI_SIP class to find relevant keywords and phrases in the content, and adds them as WP tags.
// These tags can then be used automatically with the wpi_get_rss_links() and wpi_bulk_ping() functions.
function wpi_add_tags($post_id, $max_tags=3)
{

	if( empty($max_tags) || empty($post_id) )
		return false;

	$post = get_post($post_id);

	$sip = new WPI_SIP;
	$stop_path = WPI_PATH . 'txt/stopwords.txt';
	if( !file_exists($stop_path) ) {
		wpi_log("Couldn't load stop words - can't detect tags! (Stop file should be here: $stop_path");
		return false;
	}

	$sip->load_stops($stop_path);
	$tags = $sip->get_tags($post->post_content);
	$tags = array_slice($tags, 0, $max_tags);	

	if( !empty($tags) ) {

		// add the new tags to the post, in addition to any already there
		wp_set_post_tags( $post_id, $tags, true );

		// update today's tag count
		$num_tags_today = get_option( 'wpi_num_tags_today', 0 );
		$new_total_num_tags = count($tags) + $num_tags_today;
		update_option( 'wpi_num_tags_today', $new_total_num_tags );

	}

	wpi_log("Added these tags to post_id=$post_id: " . implode(', ', $tags));

}

