
<h1 class="wpi-title-icon wpi-dashboard-icon">Dashboard</h1>

<script type="text/javascript" src="https://www.google.com/jsapi"></script>
<script type="text/javascript">
	google.load("visualization", "1", {packages:["corechart","gauge"]});
	
	google.setOnLoadCallback(drawWpiIndexPie);
	function drawWpiIndexPie() {
		var data = google.visualization.arrayToDataTable([
			['Task',		'Index Stats'],
			['Indexed',		<?php echo $index_stats['num_indexed_posts']; ?>],
			['Not Indexed',	<?php echo $index_stats['num_not_indexed_posts']; ?>],
			['Unchecked',	<?php echo $index_stats['num_not_checked_posts']; ?>],
		]);

		var options = {
			backgroundColor: '#F3F7FA',
			legend: {
				position: 'bottom',
				textStyle: {fontSize: 11},
			},
			slices: [
				{color: '#109618'},
				{color: '#DC3912'},
				{color: '#3366CC'},
			],
			pieSliceTextStyle: {fontSize:13},
			chartArea: {
				left:0,
				top:20,
				height: 180,
				width: '100%'
			}
		};

		var chart = new google.visualization.PieChart(document.getElementById('wpi_chart_index_pie'));
		chart.draw(data, options);
	}

	google.setOnLoadCallback(drawWpiGauges);
	function drawWpiGauges() {
		var data = google.visualization.arrayToDataTable([
			['Label',	'Value'],
			['Pings',	<?php echo $gauges['num_pings_today']; ?>],
			['Links',	<?php echo $gauges['num_links_today']; ?>],
			['Tags',	<?php echo $gauges['num_tags_today']; ?>]
		]);

		var options = {
			width: 505,
			redFrom: 90, redTo: 100,
			yellowFrom:75, yellowTo: 90,
			greenFrom:50, greenTo: 75,
			minorTicks: 5
		};

		var chart = new google.visualization.Gauge(document.getElementById('wpi_chart_gauges'));
		chart.draw(data, options);
	}

</script>

<div class="wpi_dashbox_left">
	<div class="wpi_dashbox_head">Post Indexation</div>
	<div class="wpi_dashbox_body" id="wpi_chart_index_pie"></div>
</div>

<div class="wpi_dashbox_right">
	<div class="wpi_dashbox_head">Indexation Overview</div>
	<div class="wpi_dashbox_body">
		<table>
			<tr>
				<td>Homepage</td>
				<td>
					<?php echo number_format($index_stats['overview']['homepage']['indexed']); ?>
					/
					<?php echo number_format($index_stats['overview']['homepage']['total']); ?>
				</td>
				<td>
					<span class="wpi_indexation_stat wpi_stat_<?php echo $index_stats['overview']['homepage']['percent_rounded']; ?>">
						<?php echo $index_stats['overview']['homepage']['percent']; ?>%
					</span>
				</td>
			</tr>
			<tr>
				<td>Posts</td>
				<td>
					<?php echo number_format($index_stats['overview']['posts']['indexed']); ?>
					/
					<?php echo number_format($index_stats['overview']['posts']['total']); ?>
				</td>
				<td>
					<span class="wpi_indexation_stat wpi_stat_<?php echo $index_stats['overview']['posts']['percent_rounded']; ?>">
						<?php echo $index_stats['overview']['posts']['percent']; ?>%
					</span>
				</td>
			</tr>
			<tr>
				<td>Categories</td>
				<td>
					<?php echo number_format($index_stats['overview']['categories']['indexed']); ?>
					/
					<?php echo number_format($index_stats['overview']['categories']['total']); ?>
				</td>
				<td>
					<span class="wpi_indexation_stat wpi_stat_<?php echo $index_stats['overview']['categories']['percent_rounded']; ?>">
						<?php echo $index_stats['overview']['categories']['percent']; ?>%
					</span>
				</td>
			</tr>
			<tr>
				<td>Tags</td>
				<td>
					<?php echo number_format($index_stats['overview']['tags']['indexed']); ?>
					/
					<?php echo number_format($index_stats['overview']['tags']['total']); ?>
				</td>
				<td>
					<span class="wpi_indexation_stat wpi_stat_<?php echo $index_stats['overview']['tags']['percent_rounded']; ?>">
						<?php echo $index_stats['overview']['tags']['percent']; ?>%
					</span>
				</td>
			</tr>
			<tr>
				<td>Authors</td>
				<td>
					<?php echo number_format($index_stats['overview']['authors']['indexed']); ?>
					/
					<?php echo number_format($index_stats['overview']['authors']['total']); ?>
				</td>
				<td>
					<span class="wpi_indexation_stat wpi_stat_<?php echo $index_stats['overview']['authors']['percent_rounded']; ?>">
						<?php echo $index_stats['overview']['authors']['percent']; ?>%
					</span>
				</td>
			</tr>
		</table>

		<!--
		<p>Homepage 1/1 100%</p>
		<p>Posts 2/4 50%</p>
		<p>Categories 2/10 20%</p>
		<p>Tags 20/30 67%</p>
		<p>Authors 1/1 100%</p>
	-->
	</div>
</div>

<div class="wpi_dashbox_full" style="height:200px;">
	<div class="wpi_dashbox_head">Key Activity Today</div>
	<div class="wpi_dashbox_body" id="wpi_chart_gauges"></div>
	<!-- 
	<p>log gauge data daily. Links aquired by WPI added to <a href="view-source:https://www.google.com/search?ie=utf-8&q=link:http://localhost/&tbm=blg&tbs=sbd:1&output=rss">incoming blog links</a>.</p>
	<p>Log all this in wpi_daily_stats as json array, and cron wipe it daily. Under each gauge show a list of data generated today. So in code when wpi_log'ing, we should also do wpi_log_daily($type='ping_num/link_data', $data);</p>
	-->
</div>

<div class="wpi_dashbox_full" style="margin-bottom: 0px;">
	<div class="wpi_dashbox_body">
		<p>
			Indexation status of <b><?php echo $next_checks['num_posts_to_check']; ?> more posts</b> will be checked <b><?php echo $next_checks['posts']; ?></b> and all core stats will be updated <b><?php echo $next_checks['site']; ?></b>.
			At this rate <b><?php echo $next_checks['posts_checked_daily']; ?> posts</b> will be checked daily, so your blog gets a complete post re-check every <b><?php echo $next_checks['time_for_complete_post_recheck']; ?></b>.
		</p>
	</div>
</div>

<div style="clear: both;"></div>
