
<h1 class="wpi-title-icon wpi-settings-icon">Settings</h1>

<p>Choose which features you want to use then click "Save Settings". When anything happens you can see it in the <a href="<?php echo $_SERVER['PHP_SELF']; ?>?page=wpi-log">WPI log</a>.</p>

<form action="<?php echo $_SERVER['PHP_SELF']; ?>?page=wpi-settings<?php if( isset($debug) ) echo '&wpi_debug'; ?>" method="POST">

	<table>

		<tr>
			<td class="wpi-pad-checkbox-td">
				<input type="checkbox" name="wpi_status" <?php echo $wpi_status; ?>/>
			</td>
			<td class="wpi-setting-desc">
				<b>Plugin Status</b>
				<p>This is the master on/off switch. Remember, even when on, WPI will only do the items you choose below.</p>
			</td>
		</tr>

		<tr>
			<td>
				<select name="wpi_tags">
					<option><?php echo $wpi_tags; ?></option>
					<option disabled="disabled">---</option>
					<option>0</option>
					<option>1</option>
					<option>2</option>
					<option>3</option>
					<option>4</option>
					<option>5</option>
					<option>6</option>
					<option>7</option>
					<option>8</option>
					<option>9</option>
				</select>
			</td>
			<td class="wpi-setting-desc">
				<b>Relevant Tags</b>
				<p>Automatically add this many tags to each new post.</p>
			</td>
		</tr>

		<tr>
			<td class="wpi-pad-checkbox-td">
				<input type="checkbox" name="wpi_homepage" <?php echo $wpi_homepage; ?>/>
			</td>
			<td class="wpi-setting-desc">
				<b>Homepage Links</b>
				<p>This gets a new "stat" link to your blog's homepage with each new post. This helps with linkjuice, balancing out your link profile and of course indexing.</p>
			</td>
		</tr>

		<tr>
			<td>
				<select name="wpi_auth">
					<option><?php echo $wpi_auth; ?></option>
					<option disabled="disabled">---</option>
					<option>0</option>
					<option>1</option>
					<option>2</option>
					<option>3</option>
					<option>4</option>
					<option>5</option>
					<option>6</option>
					<option>7</option>
					<option>8</option>
					<option>9</option>
				</select>
			</td>
			<td class="wpi-setting-desc">
				<b>Authority Pingbacks</b>
				<p>For each post add this many relevant, in-content links to other blogs. WP will pingback these blogs and get links for you.</p>
			</td>
		</tr>

		<tr>
			<td class="wpi-pad-checkbox-td">
				<input type="checkbox" name="wpi_rss" <?php echo $wpi_rss; ?>/>
			</td>
			<td class="wpi-setting-desc">
				<b>RSS Pinging</b>
				<p>Not just the post URL benefits from pinging. Other URLs (and their feeds) change like the category, author page, tags etc. WPI will ping those for you.</p>
			</td>
		</tr>

		<tr>
			<td>
				<select name="wpi_check">
					<option><?php echo $wpi_check; ?></option>
					<option disabled="disabled">---</option>
					<option>0</option>
					<option>1</option>
					<option>2</option>
					<option>3</option>
					<option>4</option>
					<option>5</option>
					<option>6</option>
					<option>7</option>
					<option>8</option>
					<option>9</option>
				</select>
			</td>
			<td class="wpi-setting-desc">
				<b>Index Check Quantity</b>
				<p>This is how many posts to re-check the index status of every 15 minutes. You need this on to provide many core features of WPI.</p>
			</td>
		</tr>

		<tr>
			<td class="wpi-pad-checkbox-td">
				<input type="checkbox" name="wpi_ping" <?php echo $wpi_ping; ?>/>
			</td>
			<td class="wpi-setting-desc">
				<b>Smart Pinging</b>
				<p>WPI's bulk pinger divides it's internal ping list between the URLs to ping, so the same ping serivces never get spammed with too many updates. WP still pings the main post - WPI does everything else.</p>
			</td>
		</tr>

		<tr>
			<td>
				<select name="wpi_relatedposts">
					<option><?php echo $wpi_relatedposts; ?></option>
					<option disabled="disabled">---</option>
					<option>0</option>
					<option>1</option>
					<option>2</option>
					<option>3</option>
					<option>4</option>
					<option>5</option>
					<option>6</option>
					<option>7</option>
					<option>8</option>
					<option>9</option>
				</select>
			</td>
			<td class="wpi-setting-desc">
				<b>Unindexed Related Posts</b>
				<p>Show a list of related posts below each post you make. The difference here is that all these posts are unindexed.</p>
			</td>
		</tr>

	</table>

	<div id="wpi-btn-wrap">
		<input class="wpi-btn green" type="submit" name="wpi_save_settings" value="Save Settings" />
	</div>

</form>
