<?php


/*
	Plugin Name: WP Indexer
	Plugin URI: http://wpindexer.com
	Description: Get 93.56% more pages indexed in Google in 6 days
	Author: Sam Woods
	License: Copyright WPI 2013
	Version: 1.0.0
*/


/*

	Disclaimer
		
		This software is provided "as is", without warranty of any kind, express or
		implied, including but not limited to the warranties of merchantability,
		fitness for a particular purpose and noninfringement. In no event shall the
		authors or copyright holders be liable for any claim, damages or other
		liability, whether in an action of contract, tort or otherwise, arising from,
		out of or in connection with the software or the use or other dealings in
		the software.


	Changelog

		v1.0.0
		13th March 2013
			Release		Stable first release
			Bug fix		Stopped the "unexpected output" msg when activating on old WP's

		v0.1.6
		11th March 2013
			Bug fix		Finally fixed index unparsable for homepage stats
			Update		Settings now kept between deactivations
			Update		Error shown when plugin deactivated
			Update		First index check does homepage before posts

		v0.1.5
		10th March 2013
			Bug Fix		Regex to match Google num results fixed
			Bug Fix		Removed constantly breaking ping services
			Update		First index stat collection happens 3 mins after activation

		v0.1.4
		8th March 2013
			Bug Fix		No more curl errors when open_basedir is on

		v0.1.3
		8th March 2013
			Feature		WPI will now only bulk ping a max of once every 30 mins
			Feature		Much better log file management
			Update		Successful pings now shown in 1 log line to avoid log bloat
			Update		Added dash error if stopwords.txt isn't there
			Update		Increased ping timeout from 5 to 7 seconds
			Update		Added G redirect detection when collecting index status
			Update		The same unindexed posts are no longer checked too frequently
			Bug Fix		Updated error msg log.txt location
			Bug Fix		Stopped tags like "http www" from appearing
			Bug Fix		Author ping-URLs with spaces now correctly created

		v0.1.2
		7th March 2013
			Feature		Added "N new posts since last visit" to dash
			Feature		Added debugging of dash and setting vars: &wpi_debug
			Update		Made "Index Unparsable" message more verbose
			Bug Fix		Added correct grammar in dash para when plugin off
			Bug Fix		Removed negative numbers for pie charts
			Bug Fix		Removed a division by zero notice

		v0.1.1
		5th March 2013
			Update		Better HTTP timeout detection
			Update		Cleaned up post index status toolbar
			Update		Better css+js assest rendering
			Update		Moved all css, js and images to S3
			Update		Support page information updated
			Update		Improved related-unindexed-posts query
			Update		Related posts only shown in posts, not cats
			Update		Blocked snooper access with .htacess
			Bug Fix		Fixed button css colors
			Bug Fix		Fixed broken log.txt link
			Bug Fix		Fixed wp cron array data iteration

		v0.1
		5th March 2013
			Release		First Beta version


	Included Works

		Icons
			http://www.iconfinder.com/icondetails/49386/48/settings_icon (http://pixelmixer.ru/)
			http://www.famfamfam.com/lab/icons/silk/
			http://www.iconfinder.com/search/?q=iconset%3AAristocracy_WebDesignTuts

		Code Snippets
			http://stackoverflow.com/a/838239/1333791
			http://stackoverflow.com/a/10705098/1333791
			http://stackoverflow.com/a/2510540/1333791

		Libraries
			http://jquery.com/
			https://developers.google.com/chart/
			http://uniformjs.com/


	Debugging
	
		You can include several url param to see extra output in the plugins admin area:
			&wpi_local		use local css and js assest instead of s3
			&wpi_debug		see the page data before it's rendered

*/


// show all errors for debugging
//error_reporting(E_ALL);
//ini_set('display_errors', '1');


// don't load the plugin for direct requests
if( !function_exists('get_option') )
	exit;


// set some useful constants
define( 'WPI_VERSION', '1.0.0' );
define( 'WPI_NAME', 'WP Indexer' );
define( 'WPI_SLUG', 'wp-indexer' );
define( 'WPI_PLUG_FILE_NAME', 'wp-indexer.php' );
define( 'WPI_PATH', str_replace( basename(__FILE__), '', __FILE__ ) );
define( 'WPI_FOL', trim( dirname( plugin_basename( __FILE__ ) ) ) );
define( "WPI_URL", WP_PLUGIN_URL . '/' . WPI_FOL );


// include core WPI functions
require WPI_PATH . 'functions.php';


// we need this WP file now to check author details when compiling RSS feeds
require_once ABSPATH . 'wp-includes/pluggable.php';


// hack to stop WP screaming in it's core when trying to do normal stuff
if( empty($wp_rewrite) && empty($GLOBALS['wp_rewrite']) )
	$GLOBALS['wp_rewrite'] = $wp_rewrite = new WP_Rewrite();


// add/remove wp_options and wp_cron
register_activation_hook(WPI_PATH . WPI_PLUG_FILE_NAME, 'wpi_activate');
register_deactivation_hook(WPI_PATH . WPI_PLUG_FILE_NAME, 'wpi_deactivate');


// this allows us to run our cron every 15 mins instead of hourly
add_filter('cron_schedules', 'wpi_new_cron_intervals');


// these action connect the scheduled events in the activation hook, and the cron function
add_action('wpi_quater_hour_cron_event', 'wpi_check_post_index_status');
add_action('wpi_three_hour_cron_event', 'wpi_check_site_index_status');
add_action('wpi_daily_cron_event', 'wpi_clear_daily_stats');


// adds the admin menu, css & js
add_action('admin_init', 'wpi_admin_init');
add_action('admin_menu', 'wpi_admin_menu');
add_action('admin_head', 'wpi_admin_head');


// only do the heavy lifting if the plugin's turned on
if( (bool) get_option('wpi_status') ) {

	// trigger action_wrapper when a post is made
	add_action('publish_post', 'wpi_action_wrapper');
	add_action('publish_future_post', 'wpi_action_wrapper');
	add_action('xmlrpc_publish_post', 'wpi_action_wrapper');
	add_action('private_to_publish', 'wpi_action_wrapper');
	add_action('publish_phone', 'wpi_action_wrapper');

	// maybe add related but unindexed posts below content
	if( (bool) get_option('wpi_relatedposts') )
		add_filter('the_content', 'wpi_add_related_unindexed_posts');

	// only add BZ toolbar if we're using WP 3.3+
	if( version_compare(get_bloginfo('version'), '3.3', '>=') )
		add_action('admin_bar_menu', 'wpi_admin_toolbar', 9999);

}

