-- Adminer 4.2.5 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP TABLE IF EXISTS `wp_affiliates_banners_tbl`;
CREATE TABLE `wp_affiliates_banners_tbl` (
  `number` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `ref_url` varchar(255) NOT NULL DEFAULT '',
  `link_text` varchar(100) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `creative_type` varchar(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`number`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `wp_affiliates_clickthroughs_tbl`;
CREATE TABLE `wp_affiliates_clickthroughs_tbl` (
  `refid` varchar(128) DEFAULT 'none',
  `date` date NOT NULL DEFAULT '0000-00-00',
  `time` time NOT NULL DEFAULT '00:00:00',
  `browser` varchar(200) DEFAULT 'No information',
  `ipaddress` varchar(50) DEFAULT 'No information',
  `referralurl` varchar(200) DEFAULT 'none detected (maybe a direct link)',
  `buy` varchar(10) DEFAULT 'NO',
  `campaign_id` varchar(64) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `wp_affiliates_leads_tbl`;
CREATE TABLE `wp_affiliates_leads_tbl` (
  `lead_id` int(12) NOT NULL AUTO_INCREMENT,
  `buyer_email` varchar(128) NOT NULL DEFAULT '',
  `refid` varchar(128) NOT NULL DEFAULT '',
  `reference` varchar(20) NOT NULL DEFAULT '',
  `date` date NOT NULL DEFAULT '0000-00-00',
  `time` time NOT NULL DEFAULT '00:00:00',
  `ipaddress` varchar(50) NOT NULL DEFAULT '',
  `buyer_name` varchar(128) NOT NULL DEFAULT '',
  PRIMARY KEY (`lead_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `wp_affiliates_payouts_tbl`;
CREATE TABLE `wp_affiliates_payouts_tbl` (
  `refid` varchar(128) NOT NULL DEFAULT '',
  `date` date NOT NULL DEFAULT '0000-00-00',
  `time` time NOT NULL DEFAULT '00:00:00',
  `payout_payment` varchar(10) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `wp_affiliates_relations_tbl`;
CREATE TABLE `wp_affiliates_relations_tbl` (
  `record_id` int(12) NOT NULL AUTO_INCREMENT,
  `unique_ref` varchar(128) NOT NULL DEFAULT '',
  `refid` varchar(128) NOT NULL DEFAULT '',
  `reference` varchar(128) NOT NULL DEFAULT '',
  `date` date NOT NULL DEFAULT '0000-00-00',
  `time` time NOT NULL DEFAULT '00:00:00',
  `ipaddress` varchar(50) NOT NULL DEFAULT '',
  `additional_info` text NOT NULL,
  PRIMARY KEY (`record_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `wp_affiliates_sales_tbl`;
CREATE TABLE `wp_affiliates_sales_tbl` (
  `refid` varchar(128) NOT NULL DEFAULT '',
  `date` date NOT NULL DEFAULT '0000-00-00',
  `time` time NOT NULL DEFAULT '00:00:00',
  `browser` varchar(200) NOT NULL DEFAULT '',
  `ipaddress` varchar(50) NOT NULL DEFAULT '',
  `payment` varchar(10) NOT NULL DEFAULT '',
  `sale_amount` varchar(10) NOT NULL DEFAULT '',
  `txn_id` varchar(64) NOT NULL DEFAULT '',
  `item_id` varchar(128) NOT NULL DEFAULT '',
  `buyer_email` varchar(128) NOT NULL DEFAULT '',
  `campaign_id` varchar(64) NOT NULL DEFAULT '',
  `buyer_name` varchar(128) NOT NULL DEFAULT '',
  `is_tier_comm` varchar(64) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `wp_affiliates_tbl`;
CREATE TABLE `wp_affiliates_tbl` (
  `refid` varchar(128) NOT NULL DEFAULT '',
  `pass` varchar(128) NOT NULL DEFAULT '',
  `company` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(5) NOT NULL DEFAULT '',
  `firstname` varchar(40) NOT NULL DEFAULT '',
  `lastname` varchar(40) NOT NULL DEFAULT '',
  `website` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `payableto` varchar(100) NOT NULL DEFAULT '',
  `street` varchar(100) NOT NULL DEFAULT '',
  `town` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `country` varchar(100) NOT NULL DEFAULT '',
  `phone` varchar(30) NOT NULL DEFAULT '',
  `fax` varchar(30) NOT NULL DEFAULT '',
  `date` date NOT NULL DEFAULT '0000-00-00',
  `paypalemail` varchar(100) NOT NULL DEFAULT '',
  `commissionlevel` varchar(10) NOT NULL DEFAULT '',
  `referrer` varchar(30) NOT NULL DEFAULT '',
  `tax_id` varchar(128) NOT NULL DEFAULT '',
  `account_details` text NOT NULL,
  `sec_tier_commissionlevel` varchar(10) NOT NULL DEFAULT '',
  `account_status` enum('approved','pending','inactive') DEFAULT 'approved',
  `tax_form_submitted` varchar(24) NOT NULL DEFAULT '',
  PRIMARY KEY (`refid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `wp_affiliates_user_link_tbl`;
CREATE TABLE `wp_affiliates_user_link_tbl` (
  `linkage_id` int(12) NOT NULL AUTO_INCREMENT,
  `referrer_id` varchar(128) NOT NULL DEFAULT '',
  `email` varchar(128) NOT NULL DEFAULT '',
  `ipaddress` varchar(128) NOT NULL DEFAULT '',
  `reference` varchar(128) NOT NULL DEFAULT '',
  `date` date NOT NULL DEFAULT '0000-00-00',
  `time` time NOT NULL DEFAULT '00:00:00',
  PRIMARY KEY (`linkage_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `wp_atap_logs`;
CREATE TABLE `wp_atap_logs` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL,
  `log_status` int(11) NOT NULL,
  `log_time` varchar(255) DEFAULT NULL,
  `log_details` text,
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `wp_atap_logs` (`log_id`, `post_id`, `log_status`, `log_time`, `log_details`) VALUES
(1,	1328,	1,	'2015-12-30 05:32:58 AM',	'Tweeted Successfully on hotfile_pw'),
(2,	1341,	0,	'2015-12-30 05:54:07 AM',	'Status is over 140 characters.');

DROP TABLE IF EXISTS `wp_commentmeta`;
CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `wp_commentmeta` (`meta_id`, `comment_id`, `meta_key`, `meta_value`) VALUES
(337,	114,	'akismet_result',	'false'),
(338,	114,	'akismet_history',	'a:2:{s:4:\"time\";d:1451510528.8092060089111328125;s:5:\"event\";s:9:\"check-ham\";}'),
(655,	220,	'akismet_result',	'false'),
(656,	220,	'akismet_history',	'a:2:{s:4:\"time\";d:1451611047.8010981082916259765625;s:5:\"event\";s:9:\"check-ham\";}'),
(1213,	406,	'akismet_result',	'false'),
(1214,	406,	'akismet_history',	'a:2:{s:4:\"time\";d:1451942945.594532012939453125;s:5:\"event\";s:9:\"check-ham\";}'),
(1282,	429,	'akismet_result',	'false'),
(1283,	429,	'akismet_history',	'a:2:{s:4:\"time\";d:1451962905.6388509273529052734375;s:5:\"event\";s:9:\"check-ham\";}'),
(1306,	437,	'akismet_result',	'false'),
(1307,	437,	'akismet_history',	'a:2:{s:4:\"time\";d:1451969767.1423590183258056640625;s:5:\"event\";s:9:\"check-ham\";}'),
(1309,	438,	'akismet_result',	'false'),
(1310,	438,	'akismet_history',	'a:2:{s:4:\"time\";d:1451969885.4629840850830078125;s:5:\"event\";s:9:\"check-ham\";}'),
(1336,	447,	'akismet_result',	'false'),
(1337,	447,	'akismet_history',	'a:2:{s:4:\"time\";d:1451989103.8317420482635498046875;s:5:\"event\";s:9:\"check-ham\";}'),
(1384,	463,	'akismet_result',	'false'),
(1385,	463,	'akismet_history',	'a:2:{s:4:\"time\";d:1452004181.341991901397705078125;s:5:\"event\";s:9:\"check-ham\";}'),
(1390,	465,	'akismet_result',	'false'),
(1391,	465,	'akismet_history',	'a:2:{s:4:\"time\";d:1452006897.467914104461669921875;s:5:\"event\";s:9:\"check-ham\";}'),
(1477,	494,	'akismet_result',	'false'),
(1478,	494,	'akismet_history',	'a:2:{s:4:\"time\";d:1452136240.9791591167449951171875;s:5:\"event\";s:9:\"check-ham\";}'),
(1705,	570,	'akismet_result',	'false'),
(1706,	570,	'akismet_history',	'a:2:{s:4:\"time\";d:1452221727.7423241138458251953125;s:5:\"event\";s:9:\"check-ham\";}'),
(1759,	588,	'akismet_result',	'false'),
(1760,	588,	'akismet_history',	'a:2:{s:4:\"time\";d:1452244045.6817009449005126953125;s:5:\"event\";s:9:\"check-ham\";}'),
(1921,	642,	'akismet_result',	'false'),
(1922,	642,	'akismet_history',	'a:2:{s:4:\"time\";d:1452329628.4061830043792724609375;s:5:\"event\";s:9:\"check-ham\";}'),
(1957,	654,	'akismet_result',	'false'),
(1958,	654,	'akismet_history',	'a:2:{s:4:\"time\";d:1452351613.666531085968017578125;s:5:\"event\";s:9:\"check-ham\";}'),
(2023,	676,	'akismet_result',	'false'),
(2024,	676,	'akismet_history',	'a:2:{s:4:\"time\";d:1452376206.10315704345703125;s:5:\"event\";s:9:\"check-ham\";}');

DROP TABLE IF EXISTS `wp_comments`;
CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `wp_comments` (`comment_ID`, `comment_post_ID`, `comment_author`, `comment_author_email`, `comment_author_url`, `comment_author_IP`, `comment_date`, `comment_date_gmt`, `comment_content`, `comment_karma`, `comment_approved`, `comment_agent`, `comment_type`, `comment_parent`, `user_id`) VALUES
(114,	2136,	'Gail',	'willybarnhill@gmail.com',	'http://www.iglesiadedios-ar.com/index.php/component/k2/item/4-softbank-gets-in-on-china-s-p2p-lending-craze-with-10-million-investment-in-edai',	'23.95.107.5',	'2015-12-30 21:22:08',	'2015-12-30 21:22:08',	'Many people at the moment uncovered that whenever discussing in regards to the worst nutritional \r\ngoods round protein drinks would be the finest.',	0,	'0',	'Mozilla/5.0 (X11; CrOS x86_64 6310.68.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.96 Safari/537.36',	'',	0,	0),
(220,	3125,	'cneam.com',	'lucretiagotch@googlemail.com',	'http://cneam.com/index.php/publication/lois-et-reglementation/item/23-code-de-la-couverture-m%C3%A9-dicale-de-base',	'45.57.160.253',	'2016-01-01 01:17:27',	'2016-01-01 01:17:27',	'En nødvendig løsning for enhver ejendom uden fast telefonforbindelse, såsom sommerhuse, opankrede både mm.\r\nPowerMax Pro GSM modemet kan fungere somm primær eller bacup kommunikation og understøtter rapportering til kontrolcentral, privattelefon (talebesked og SMS) samt 2-vejs audio.',	0,	'0',	'Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0',	'',	0,	0),
(406,	5555,	'frazierxzpfjepglq.snack.ws',	'dorothyhudd@gmx.net',	'http://frazierxzpfjepglq.snack.ws/miles-de-pequenos-trabajan-en-las-plantaciones-de-tabaco-de-eeuu.html',	'192.240.99.165',	'2016-01-04 21:29:05',	'2016-01-04 21:29:05',	'Hemos registrado tu valoración de la página El Tiempo en Flores de Ávila y se \r\nprocesará en las próximas horas para contabilizar la puntuación media.',	0,	'0',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.10; rv:34.0) Gecko/20100101 Firefox/34.0',	'',	0,	0),
(429,	5749,	'Blanca',	'jannabaumgaertner@gmail.com',	'http://lindsayenglish17.blog.com/2015/12/17/los-mejores-lugares-para-campar-y-caminar-cerca-de-sunriver-oregon/',	'50.2.28.38',	'2016-01-05 03:01:45',	'2016-01-05 03:01:45',	'Por ejemplo, si vamos a tener nuestra maceta siempre \r\nen el exterior, podemos utilizar una mezcla comercial para macetas \r\nestándar, sin embargo, si planeas mover el contenedor al interior durante \r\nel invierno, es preferible comprar un sustrato \r\npara plantas de interior, ya que huelen mejor.',	0,	'0',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.10; rv:34.0) Gecko/20100101 Firefox/34.0',	'',	0,	0),
(437,	5749,	'Joycelyn',	'christinpinkerton@gmail.com',	'https://www.wikipedia.org/',	'191.101.81.179',	'2016-01-05 04:56:07',	'2016-01-05 04:56:07',	'Hi there very nice web site!! Man .. Beautiful .. Wonderful ..\r\n\r\nI will bookmark your web site and take the feeds additionally?\r\nI am happy to seek out a lot of helpful info right here \r\nwithin the submit, we need develop extra strategies in this regard, thanks for sharing.\r\n. . . . .',	0,	'0',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:34.0) Gecko/20100101 Firefox/34.0',	'',	0,	0),
(438,	5749,	'Ewan',	'carlbasham@googlemail.com',	'http://www.Gaiaonline.com/journal/?mode=view&amp;post_id=38343757&amp;u=38484723',	'104.144.29.35',	'2016-01-05 04:58:05',	'2016-01-05 04:58:05',	'Así que no hay excusa y no os olvideis de poner una bufanda a vuestras plantas mientras dure el invierno.',	0,	'0',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.10; rv:34.0) Gecko/20100101 Firefox/34.0',	'',	0,	0),
(447,	5749,	'Kaitlyn',	'raymundotoothman@gmail.com',	'http://www.gaiaonline.com/journal/?mode=view&amp;post_id=38345787&amp;u=38469143',	'23.232.137.90',	'2016-01-05 10:18:23',	'2016-01-05 10:18:23',	'Tus hijos pueden seguir el crecimiento de las plantas de frijol \r\na través de la germinación, el crecimiento, la floración y cuando la planta da los frijoles.',	0,	'0',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:34.0) Gecko/20100101 Firefox/34.0',	'',	0,	0),
(463,	5749,	'Tressa',	'jonellehartz@web.de',	'http://nanowrimo.org/participants/ualethinspas1975',	'23.232.176.151',	'2016-01-05 14:29:41',	'2016-01-05 14:29:41',	'If there ever is a break breakdown in society and you have simply spent a number of time \r\nand money prepping and increase your stores and equipment and having the foresight to only be prepared.',	0,	'0',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:34.0) Gecko/20100101 Firefox/34.0',	'',	0,	0),
(465,	5749,	'nq.st',	'staceyperivolaris@web.de',	'http://nq.st/viverosengeneralroca21198+',	'179.61.190.179',	'2016-01-05 15:14:57',	'2016-01-05 15:14:57',	'Las mejores plantas que podemos regalar para levantar el ánimo son las del género Echeveria, pues se dice que estas plantas \r\ntransmiten energía positiva.',	0,	'0',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:34.0) Gecko/20100101 Firefox/34.0',	'',	0,	0),
(494,	6416,	'Jeffrey',	'christopher.huondekermadec@gmail.com',	'http://www.workwithh4ead.com/2016/01/03/paint-an-body-shop-blues/',	'192.227.169.254',	'2016-01-07 03:10:40',	'2016-01-07 03:10:40',	'Nearly all outlets will be content to give you an estimate for painting or physique repair.\r\nNo make a difference what you need to have completed, \r\nskilled automobile physique shops will be able to do the work speedily and efficiently, and you will not have to fret about heading to five various areas to get your automobile back in tip-best form.\r\nThough the glasses of a car are made up of high quality material but they \r\ncan\'t withstand thunderstorm or a collision.',	0,	'0',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.9; rv:35.0) Gecko/20100101 Firefox/35.0',	'',	0,	0),
(570,	7326,	'Guides By Dean Graziosi',	'cierrajarvis@zoho.com',	'http://Erreur',	'138.186.175.2',	'2016-01-08 02:55:27',	'2016-01-08 02:55:27',	'For latest news you have to visit web and on the web I found this web page \r\nas a most excellent web page for most recent updates.',	0,	'0',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36',	'',	0,	0),
(588,	7659,	'Theodore',	'suzettebox@gmail.com',	'http://pandv14.info/2015/12/12/what-time-is-walmart-open-till-on-christmas-eve/',	'23.232.176.121',	'2016-01-08 09:07:25',	'2016-01-08 09:07:25',	'On the subject of backing up knowledge, backup tapes or exterior arduous drives don\'t come \r\nfor reasonable prices.',	0,	'0',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36',	'',	0,	0),
(642,	8829,	'Sarah',	'lorenzo.ardill@gmx.net',	'http://Ireport.Cnn.com/people/cHBqnaC0I',	'172.245.254.44',	'2016-01-09 08:53:48',	'2016-01-09 08:53:48',	'Definitely consider that which you said. Your favourite justification appeared to be on the net the \r\nsimplest thing to understand of. I say to you, \r\nI definitely get annoyed at the same time as other people consider concerns that they just \r\ndon\'t know about. You managed to hit the nail \r\nupon the highest and defined out the entire thing without having \r\nside-effects , other people could take a signal. Will likely \r\nbe back to get more. Thanks',	0,	'0',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.99 Safari/537.36',	'',	0,	0),
(654,	9073,	'decatur illinois Banquet hall',	'danellesturgeon@googlemail.com',	'http://Www.consult-Hc.Co.uk/when-to-see-a-doctor/',	'172.245.73.19',	'2016-01-09 15:00:13',	'2016-01-09 15:00:13',	'This text is worth everyone\'s attention. How can I find out more?',	0,	'0',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.99 Safari/537.36',	'',	0,	0),
(676,	9281,	'Alejandrina',	'mabel_schofield@gawab.com',	'http://community.cookinglight.com/member.php?405488-incandescentbab',	'104.168.97.143',	'2016-01-09 21:50:06',	'2016-01-09 21:50:06',	'I used to be suggested this website by means of \r\nmy cousin. I\'m now not certain whether this submit \r\nis written by way of him as no one else understand \r\nsuch particular approximately my difficulty.\r\n\r\nYou are incredible! Thank you!',	0,	'0',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.99 Safari/537.36',	'',	0,	0);

DROP TABLE IF EXISTS `wp_links`;
CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `wp_microblogposter_accounts`;
CREATE TABLE `wp_microblogposter_accounts` (
  `account_id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(200) NOT NULL DEFAULT '',
  `password` varchar(200) DEFAULT NULL,
  `consumer_key` varchar(200) DEFAULT NULL,
  `consumer_secret` varchar(200) DEFAULT NULL,
  `access_token` varchar(200) DEFAULT NULL,
  `access_token_secret` varchar(200) DEFAULT NULL,
  `type` varchar(100) NOT NULL DEFAULT '',
  `message_format` text,
  `extra` text,
  PRIMARY KEY (`account_id`),
  UNIQUE KEY `username_type` (`username`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `wp_microblogposter_logs`;
CREATE TABLE `wp_microblogposter_logs` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `account_type` varchar(100) NOT NULL DEFAULT '',
  `username` varchar(200) NOT NULL DEFAULT '',
  `post_id` bigint(20) unsigned NOT NULL,
  `action_result` tinyint(4) NOT NULL,
  `update_message` text,
  `log_type` varchar(50) NOT NULL DEFAULT 'regular',
  `log_message` text,
  `log_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `wp_microblogposter_old_items`;
CREATE TABLE `wp_microblogposter_old_items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `publish_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `item_type` varchar(50) NOT NULL DEFAULT 'post',
  `extra` text,
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `wp_options`;
CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(1,	'siteurl',	'http://hotfile.pw',	'yes'),
(2,	'home',	'http://hotfile.pw',	'yes'),
(3,	'blogname',	'Hotfile.pw: 1-CLICK Downloads',	'yes'),
(4,	'blogdescription',	'Free one-click downloads! With us you can downloads big files easily and securely.',	'yes'),
(5,	'users_can_register',	'0',	'yes'),
(6,	'admin_email',	'admin@hotfile.pw',	'yes'),
(7,	'start_of_week',	'1',	'yes'),
(8,	'use_balanceTags',	'0',	'yes'),
(9,	'use_smilies',	'1',	'yes'),
(10,	'require_name_email',	'1',	'yes'),
(11,	'comments_notify',	'1',	'yes'),
(12,	'posts_per_rss',	'10',	'yes'),
(13,	'rss_use_excerpt',	'0',	'yes'),
(14,	'mailserver_url',	'mail.example.com',	'yes'),
(15,	'mailserver_login',	'login@example.com',	'yes'),
(16,	'mailserver_pass',	'password',	'yes'),
(17,	'mailserver_port',	'110',	'yes'),
(18,	'default_category',	'17',	'yes'),
(19,	'default_comment_status',	'open',	'yes'),
(20,	'default_ping_status',	'open',	'yes'),
(21,	'default_pingback_flag',	'1',	'yes'),
(22,	'posts_per_page',	'10',	'yes'),
(23,	'date_format',	'F j, Y',	'yes'),
(24,	'time_format',	'g:i a',	'yes'),
(25,	'links_updated_date_format',	'F j, Y g:i a',	'yes'),
(26,	'comment_moderation',	'0',	'yes'),
(27,	'moderation_notify',	'1',	'yes'),
(28,	'permalink_structure',	'/%category%/%postname%.html',	'yes'),
(29,	'hack_file',	'0',	'yes'),
(30,	'blog_charset',	'UTF-8',	'yes'),
(31,	'moderation_keys',	'',	'no'),
(32,	'active_plugins',	'a:18:{i:0;s:19:\"akismet/akismet.php\";i:1;s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";i:2;s:41:\"aryo-widget-device/aryo-widget-device.php\";i:3;s:42:\"auto-hyperlink-urls/autohyperlink-urls.php\";i:4;s:31:\"bbcode-deluxe/bbcode-deluxe.php\";i:5;s:49:\"delete-duplicate-posts/delete-duplicate-posts.php\";i:6;s:37:\"disable-comments/disable-comments.php\";i:7;s:33:\"duplicate-menu/duplicate-menu.php\";i:8;s:47:\"facebook-auto-publish/facebook-auto-publish.php\";i:9;s:25:\"menu-image/menu-image.php\";i:10;s:35:\"responsive-menu/responsive-menu.php\";i:11;s:33:\"ssh-sftp-updater-support/sftp.php\";i:13;s:35:\"tweet-wheel-pro/tweet-wheel-pro.php\";i:14;s:33:\"w3-total-cache/w3-total-cache.php\";i:15;s:33:\"wp-delete-tags/wp-delete-tags.php\";i:16;s:29:\"wp-image-seo/wp-image-seo.php\";i:17;s:25:\"wp-indexer/wp-indexer.php\";i:18;s:43:\"wp-twitter-autopost/wp-twitter-autopost.php\";}',	'yes'),
(33,	'category_base',	'',	'yes'),
(34,	'ping_sites',	'http://rpc.pingomatic.com/\nhttp://audiorpc.weblogs.com/RPC2\nhttp://bing.com/webmaster/ping.aspx\nhttp://blog.with2.net/ping.php\nhttp://blog.youdao.com/ping/RPC2\nhttp://blogping.unidatum.com/RPC2\nhttp://blogsearch.google.com/ping/RPC2\nhttp://catapings.com/ping.php\nhttp://effbot.org/rpc/ping.cgi\nhttp://news2paper.com/ping\nhttp://ping.bitacoras.com/\nhttp://ping.bloggers.jp/rpc/\nhttp://ping.fc2.com\nhttp://ping.groove-cast.com/ping.php\nhttp://ping.pubsub.com/ping\nhttp://ping.rss.drecom.jp\nhttp://ping.syndic8.com/xmlrpc.php\nhttp://ping.wordblog.de\nhttp://rpc.bloggerei.de/ping/\nhttp://rpc.twingly.com/\nhttp://rpc.weblogs.com/RPC2\nhttp://serenebach.net/rep.cgi\nhttp://services.newsgator.com/ngws/xmlrpcping.aspx\nhttp://wasalive.com/ping/\nhttp://xianguo.com/xmlrpc/ping.php\nhttp://xping.pubsub.com/ping/\nhttp://blogpeople.net/servlet/weblogUpdates\nhttp://blogsearch.google.co.in/ping/RPC2\nhttp://blogsearch.google.co.it/ping/RPC2\nhttp://blogsearch.google.co.jp/ping/RPC2\nhttp://blogsearch.google.co.ma/ping/RPC2\nhttp://blogsearch.google.com.ar/ping/RPC2\nhttp://blogsearch.google.com.au/ping/RPC2\nhttp://blogsearch.google.com.br/ping/RPC2\nhttp://blogsearch.google.com.co/ping/RPC2\nhttp://blogsearch.google.com.do/ping/RPC2\nhttp://blogsearch.google.com.mx/ping/RPC2\nhttp://blogsearch.google.com.my/ping/RPC2\nhttp://blogsearch.google.com.pe/ping/RPC2\nhttp://blogsearch.google.com.sa/ping/RPC2\nhttp://blogsearch.google.com.sg/ping/RPC2\nhttp://blogsearch.google.com.tr/ping/RPC2\nhttp://blogsearch.google.ae/ping/RPC2\nhttp://blogsearch.google.at/ping/RPC2\nhttp://blogsearch.google.be/ping/RPC2\nhttp://blogsearch.google.bg/ping/RPC2\nhttp://blogsearch.google.ca/ping/RPC2\nhttp://blogsearch.google.ch/ping/RPC2\nhttp://blogsearch.google.cl/ping/RPC2\nhttp://blogsearch.google.co.cr/ping/RPC2\nhttp://blogsearch.google.co.hu/ping/RPC2\nhttp://blogsearch.google.co.id/ping/RPC2\nhttp://blogsearch.google.co.il/ping/RPC2\nhttp://xping.pubsub.com/ping\nhttp://rpc.technorati.com/rpc/ping\nhttp://rpc.twingly.com\nhttp://api.feedster.com/ping\nhttp://api.moreover.com/RPC2\nhttp://api.moreover.com/ping\nhttp://www.blogdigger.com/RPC2\nhttp://www.blogshares.com/rpc.php\nhttp://www.blogsnow.com/ping\nhttp://www.blogstreet.com/xrbin/xmlrpc.cgi\nhttp://bulkfeeds.net/rpc\nhttp://www.newsisfree.com/xmlrpctest.php\nhttp://ping.blo.gs/\nhttp://ping.feedburner.com\nhttp://ping.weblogalot.com/rpc.php\nhttp://rpc.blogrolling.com/pinger/\nhttp://www.feedsubmitter.com\nhttp://blo.gs/ping.php\nhttp://www.pingerati.net\nhttp://www.pingmyblog.com\nhttp://geourl.org/ping\nhttp://ipings.com\nhttp://www.weblogalot.com/ping\nhttp://api.my.yahoo.com/ping\nhttp://blogmatcher.com/\nhttp://blogpeople.net/ping\nhttp://blogsearch.google.com.tw/ping/RPC2\nhttp://blogsearch.google.com.ua/ping/RPC2\nhttp://blogsearch.google.com.uy/ping/RPC2\nhttp://blogsearch.google.com.vn/ping/RPC2\nhttp://blogsearch.google.co.nz/ping/RPC2\nhttp://blogsearch.google.co.th/ping/RPC2\nhttp://blogsearch.google.co.uk/ping/RPC2\nhttp://blogsearch.google.co.ve/ping/RPC2\nhttp://blogsearch.google.co.za/ping/RPC2\nhttp://blogsearch.google.de/ping/RPC2\nhttp://blogsearch.google.es/ping/RPC2\nhttp://blogsearch.google.fi/ping/RPC2\nhttp://blogsearch.google.fr/ping/RPC2\nhttp://blogsearch.google.gr/ping/RPC2\nhttp://blogsearch.google.hr/ping/RPC2\nhttp://blogsearch.google.ie/ping/RPC2\nhttp://blogsearch.google.in/ping/RPC2\nhttp://blogsearch.google.it/ping/RPC2\nhttp://blogsearch.google.jp/ping/RPC2\nhttp://blogsearch.google.lt/ping/RPC2\nhttp://blogsearch.google.nl/ping/RPC2\nhttp://blogsearch.google.pl/ping/RPC2\nhttp://blogsearch.google.pt/ping/RPC2\nhttp://blogsearch.google.ro/ping/RPC2\nhttp://blogsearch.google.ru/ping/RPC2\nhttp://blogsearch.google.se/ping/RPC2\nhttp://blogsearch.google.sk/ping/RPC2\nhttp://blogsearch.google.tw/ping/RPC2\nhttp://blogsearch.google.us/ping/RPC2\nhttp://bulkfeeds.net\nhttp://coreblog.org/ping/\nhttp://feedsky.com/api/RPC2\nhttp://geourl.org/ping/\nhttp://hamo-search.com/ping.php\nhttp://holycowdude.com/rpc/ping\nhttp://mapufacture.com/georss/ping/api\nhttp://mod-pubsub.org\nhttp://mod-pubsub.org/kn_apps/blogchatt\nhttp://newsblog.jungleboots.org/ping.php\nhttp://ping.amagle.com/\nhttp://ping.bitacoras.com\nhttp://ping.bloggers.jp/rpc\nhttp://ping.blogoon.net\nhttp://ping.blo.gs\nhttp://ping.blogs.yandex.ru/RPC2\nhttp://ping.cocolog-nifty.com/xmlrpc\nhttp://pinger.blogflux.com/rpc\nhttp://ping.exblog.jp/xmlrpc\nhttp://ping.fakapster.com/rpc\nhttp://ping.kutsulog.net\nhttp://ping.myblog.jp\nhttp://ping.namaan.net/rpc\nhttp://pingoat.com/goat/RPC2\nhttp://pingqueue.com/rpc/\nhttp://ping.rootblog.com/rpc.php\nhttp://ping.snap.com/ping/RPC2\nhttp://ping.speenee.com/xmlrpc\nhttp://ping.weblogalot.com\nhttp://ping.weblogs.se/\nhttp://rcs.datashed.net\nhttp://rcs.datashed.net/RPC2\nhttp://rcs.salon.com/RPC2\nhttp://r.hatena.ne.jp/rpc\nhttp://rpc.blogbuzzmachine.com/RPC2\nhttp://rpc.blogrolling.com\nhttp://rpc.britblog.com\nhttp://rpc.icerocket.com:10080\nhttp://rpc.newsgator.com/\nhttp://rpc.pingomatic.com\nhttp://rpc.reader.livedoor.com/ping\nhttp://rpc.tailrank.com\nhttp://rpc.tailrank.com/feedburner/RPC2\nhttp://rpc.technorati.com/ping\nhttp://rpc.technorati.jp/rpc/ping\nhttp://rpc.weblogs.com\nhttp://rpc.wpkeys.com\nhttp://submitblogs.com/\nhttp://thingamablog.sourceforge.net/ping.php\nhttp://topicexchange.com\nhttp://topicexchange.com/RPC2eping.php\nhttp://www.2bet.com/\nhttp://www.2rss.com\nhttp://www.a2b.cc\nhttp://www.a2b.cc/setloc/bp.a2b\nhttp://www.bitacoles.net/ping.php\nhttp://www.blogarama.com/\nhttp://www.blogbits.com/\nhttp://www.blogcatalog.com/\nhttp://www.blogdex.net/\nhttp://www.blogdigger.com\nhttp://www.blogexplosion.com\nhttp://www.bloggernity.com/\nhttp://www.bloglines.com/ping\nhttp://www.blogoole.com/ping/\nhttp://www.blogoon.net/ping/\nhttp://www.blogpeople.net\nhttp://www.blogpeople.net/ping\nhttp://www.blogpeople.net/servlet/weblogUpdates\nhttp://www.blogpulse.com/submit.html\nhttp://www.blogroots.com\nhttp://www.blogroots.com/tb_populi.blog?id=1\nhttp://www.blogsdominicanos.com/ping\nhttp://www.blogshares.com\nhttp://www.blogstreet.com\nhttp://www.blogwise.com/\nhttp://www.feedblitz.com/f/f.fbz?XmlPing\nhttp://www.feedsky.com/api/RPC2\nhttp://www.feedster.com/\nhttp://www.globeofblogs.com/\nhttp://www.holycowdude.com/rpc/ping/\nhttp://www.lasermemory.com\nhttp://www.lasermemory.com/lsrpc/\nhttp://www.linksboy.com/\nhttp://www.lsblogs.com/\nhttp://www.mod-pubsub.org/kn_apps/blogchatter/ping.php\nhttp://www.mod-pubsub.org/ping.php\nhttp://www.mod-pubsub.orgping.php\nhttp://www.newsisfree.com\nhttp://www.newsisfree.com/RPC\nhttp://www.newsisfree.com/RPCCloud\nhttp://www.octora.com/add_rss.php\nhttp://www.ohlinks.com\nhttp://www.popdex.com\nhttp://www.popdex.com/addsite.php\nhttp://www.readablog.com/\nhttp://www.rogerlinks.com/linker/index.shtml\nhttp://www.snipsnap.org\nhttp://www.snipsnap.org/RPC2\nhttp://www.syndic8.com/xmlrpc.php\nhttp://www.wasalive.com/ping/\nhttp://www.weblogs.com/RPC2\nhttp://www.weblogues.com\nhttp://www.weblogues.com/RPC/\nhttp://www.xianguo.com/xmlrpc/ping.php\nhttp://xmlrpc.blogg.de/\nhttp://xmlrpc.bloggernetz.de/RPC2\nhttp://xping.pubsub.comping/\nhttp://zhuaxia.com/rpc/server.php\nhttp://1470.net/api/ping\nhttp://api.my.yahoo.com/RPC2\nhttp://api.my.yahoo.com/rss/ping\nhttp://api.feedster.com/ping.php\nhttp://api.my.yahoo.co.jp/RPC2\nhttp://bblog.com/ping.php\nhttp://bitacoras.net/ping\nhttp://blog.goo.ne.jp/XMLRPC\nhttp://blogbot.dk/io/xml-rpc.php\nhttp://blogdb.jp/xmlrpc\nhttp://blogmatcher.com/u.php\nhttp://fgiasson.com/pings/ping.php\nhttp://ping.blogg.de/\nhttp://ping.blogmura.jp/rpc/\nhttp://ping.fc2.com/\nhttp://ping.feedburner.com/\nhttp://ping.myblog.jp/\nhttp://ping.wordblog.de/\nhttp://pinger.blogflux.com/rpc/\nhttp://pingoo.jp/ping\nhttp://rcs.datashed.net/RPC2/\nhttp://rpc.aitellu.com\nhttp://rpc.britblog.com/\nhttp://rpc.icerocket.com:10080/\nhttp://rpc.odiogo.com/ping/\nhttp://rpc.wpkeys.com/\nhttp://signup.alerts.msn.com/alerts-PREP/submitPingExtended.doz\nhttp://snipsnap.org\nhttp://snipsnap.org/RPC2\nhttp://syndic8.com/xmlrpc.php\nhttp://topicexchange.com/RPC2\nhttp://trackback.bakeinu.jp/bakeping.php\nhttp://www.blo.gs/ping.php\nhttp://www.blogsdominicanos.com/ping/\nhttp://www.blogsearch.google.ae/ping/RPC2\nhttp://www.blogsearch.google.at/ping/RPC2\nhttp://www.blogsearch.google.be/ping/RPC2\nhttp://www.blogsearch.google.bg/ping/RPC2\nhttp://www.blogsearch.google.ca/ping/RPC2\nhttp://www.blogsearch.google.ch/ping/RPC2\nhttp://www.blogsearch.google.cl/ping/RPC2\nhttp://www.blogsearch.google.co.cr/ping/RPC2\nhttp://www.blogsearch.google.co.hu/ping/RPC2\nhttp://www.blogsearch.google.co.id/ping/RPC2\nhttp://www.blogsearch.google.co.il/ping/RPC2\nhttp://www.blogsearch.google.co.in/ping/RPC2\nhttp://www.blogsearch.google.co.jp/ping/RPC2\nhttp://www.blogsearch.google.co.ma/ping/RPC2\nhttp://www.blogsearch.google.co.nz/ping/RPC2\nhttp://www.blogsearch.google.co.th/ping/RPC2\nhttp://www.blogsearch.google.co.uk/ping/RPC2\nhttp://www.blogsearch.google.co.ve/ping/RPC2\nhttp://www.blogsearch.google.co.za/ping/RPC2\nhttp://www.blogsearch.google.com.ar/ping/RPC2\nhttp://www.blogsearch.google.com.au/ping/RPC2\nhttp://www.blogsearch.google.com.br/ping/RPC2\nhttp://www.blogsearch.google.com.co/ping/RPC2\nhttp://www.blogsearch.google.com.do/ping/RPC2\nhttp://www.blogsearch.google.com.mx/ping/RPC2\nhttp://www.blogsearch.google.com.my/ping/RPC2\nhttp://www.blogsearch.google.com.pe/ping/RPC2\nhttp://www.blogsearch.google.com.sa/ping/RPC2\nhttp://www.blogsearch.google.com.sg/ping/RPC2\nhttp://www.blogsearch.google.com.tr/ping/RPC2\nhttp://www.blogsearch.google.com.tw/ping/RPC2\nhttp://www.blogsearch.google.com.ua/ping/RPC2\nhttp://www.blogsearch.google.com.uy/ping/RPC2\nhttp://www.blogsearch.google.com.vn/ping/RPC2\nhttp://www.blogsearch.google.com/ping/RPC2\nhttp://www.blogsearch.google.de/ping/RPC2\nhttp://www.blogsearch.google.es/ping/RPC2\nhttp://www.blogsearch.google.fi/ping/RPC2\nhttp://www.blogsearch.google.fr/ping/RPC2\nhttp://www.blogsearch.google.gr/ping/RPC2\nhttp://www.blogsearch.google.hr/ping/RPC2\nhttp://www.blogsearch.google.ie/ping/RPC2\nhttp://www.blogsearch.google.it/ping/RPC2\nhttp://www.blogsearch.google.jp/ping/RPC2\nhttp://www.blogsearch.google.lt/ping/RPC2\nhttp://www.blogsearch.google.nl/ping/RPC2\nhttp://www.blogsearch.google.pl/ping/RPC2\nhttp://www.blogsearch.google.pt/ping/RPC2\nhttp://www.blogsearch.google.ro/ping/RPC2\nhttp://www.blogsearch.google.ru/ping/RPC2\nhttp://www.blogsearch.google.se/ping/RPC2\nhttp://www.blogsearch.google.sk/ping/RPC2\nhttp://www.blogsearch.google.us/ping/RPC2\nhttp://www.catapings.com/ping.php\nhttp://www.imblogs.net/ping/\nhttp://www.ping.blo.gs\nhttp://www.ping.wordblog.de\nhttp://www.serenebach.net/rep.cgi\nhttp://www.zhuaxia.com/rpc/server.php\nhttp://xmlrpc.blogg.de\nhttps://phobos.apple.com/WebObjects/MZFinance.woa/wa/pingPodcast',	'yes'),
(35,	'comment_max_links',	'2',	'yes'),
(36,	'gmt_offset',	'0',	'yes'),
(37,	'default_email_category',	'1',	'yes'),
(38,	'recently_edited',	'a:2:{i:0;s:57:\"/home/hotfile/wp-content/themes/wp-themingstrap/style.css\";i:2;s:0:\"\";}',	'no'),
(39,	'template',	'wp-themingstrap',	'yes'),
(40,	'stylesheet',	'wp-themingstrap',	'yes'),
(41,	'comment_whitelist',	'1',	'yes'),
(42,	'blacklist_keys',	'',	'no'),
(43,	'comment_registration',	'0',	'yes'),
(44,	'html_type',	'text/html',	'yes'),
(45,	'use_trackback',	'0',	'yes'),
(46,	'default_role',	'subscriber',	'yes'),
(47,	'db_version',	'35700',	'yes'),
(48,	'uploads_use_yearmonth_folders',	'1',	'yes'),
(49,	'upload_path',	'',	'yes'),
(50,	'blog_public',	'1',	'yes'),
(51,	'default_link_category',	'0',	'yes'),
(52,	'show_on_front',	'posts',	'yes'),
(53,	'tag_base',	'',	'yes'),
(54,	'show_avatars',	'1',	'yes'),
(55,	'avatar_rating',	'G',	'yes'),
(56,	'upload_url_path',	'',	'yes'),
(57,	'thumbnail_size_w',	'150',	'yes'),
(58,	'thumbnail_size_h',	'150',	'yes'),
(59,	'thumbnail_crop',	'1',	'yes'),
(60,	'medium_size_w',	'300',	'yes'),
(61,	'medium_size_h',	'300',	'yes'),
(62,	'avatar_default',	'mystery',	'yes'),
(63,	'large_size_w',	'1024',	'yes'),
(64,	'large_size_h',	'1024',	'yes'),
(65,	'image_default_link_type',	'none',	'yes'),
(66,	'image_default_size',	'',	'yes'),
(67,	'image_default_align',	'',	'yes'),
(68,	'close_comments_for_old_posts',	'0',	'yes'),
(69,	'close_comments_days_old',	'14',	'yes'),
(70,	'thread_comments',	'1',	'yes'),
(71,	'thread_comments_depth',	'5',	'yes'),
(72,	'page_comments',	'0',	'yes'),
(73,	'comments_per_page',	'50',	'yes'),
(74,	'default_comments_page',	'newest',	'yes'),
(75,	'comment_order',	'asc',	'yes'),
(76,	'sticky_posts',	'a:0:{}',	'yes'),
(77,	'widget_categories',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(78,	'widget_text',	'a:3:{i:1;a:0:{}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1225:\"<center><!-- start rardownload.net code -->\r\n<a href=\"http://rardownload.net/\" target=\"_blank\"><img src=\"http://i23.fastpic.ru/big/2011/0621/5e/90b339391af953d660d84cc2684d7b5e.gif\" title=\"RARdownload\" alt=\"Full RAR Downloads\" width=\"88\" height=\"31\" border=\"0\" onerror=\"this.src=\'http://rardownload.net/img/rard_b.gif\'\" /></a>\r\n<!-- end rardownload.net code -->\r\n<a title=\"Free Downloads\" href=\"http://twilight.ws/\"><strong><img src=\"http://static.twilight.ws/twilight.ws_button1.gif\" width=\"88\" height=\"31\" border=\"0\" alt=\"Free Downloads\" /></strong></a>\r\n<!--Start DirtyWarez.com Code-->\r\n<a href=\"http://dirtywarez.com/\" title=\"Full Warez Download @ dirtywarez.com\">\r\n<img src=\"http://dirtywarez.com/images/aff.gif\" alt=\"Free Full Warez Download @ dirtywarez.com\" title=\"Free Full Warez Download @ dirtywarez.com\" width=\"88\" height=\"31\" border=\"0\"></a>\r\n<!--End DirtyWarez.com Code-->\r\n<br><br><!-- Start KatzDDL.ws 176x62 -->\r\n<a href=\"http://katzddl.ws/\" target=\"_blank\" title=\"Free Full Premium Downloads\"><b><img src=\"http://static.katzddl.ws/button.gif\" title=\"KatzDDL.ws - http://katzddl.ws/ \" alt=\"Free Full Premium Downloads\" width=\"176\" height=\"62\" border=\"0\" /></b></a><!-- End KatzDDL.ws 176x62 -->\r\n</center>\r\n\";s:6:\"filter\";b:0;s:18:\"awd_display_widget\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}',	'yes'),
(79,	'widget_rss',	'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}',	'yes'),
(80,	'uninstall_plugins',	'a:4:{s:47:\"facebook-auto-publish/facebook-auto-publish.php\";s:25:\"fbap_free_network_destroy\";s:45:\"twitter-auto-publish/twitter-auto-publish.php\";s:25:\"twap_free_network_destroy\";s:33:\"jc-pinterest-pin/pinterestpin.php\";a:2:{i:0;s:12:\"PinterestPin\";i:1;s:9:\"uninstall\";}s:35:\"tweet-wheel-pro/tweet-wheel-pro.php\";s:13:\"twp_uninstall\";}',	'no'),
(81,	'timezone_string',	'',	'yes'),
(82,	'page_for_posts',	'0',	'yes'),
(83,	'page_on_front',	'0',	'yes'),
(84,	'default_post_format',	'0',	'yes'),
(85,	'link_manager_enabled',	'0',	'yes'),
(86,	'finished_splitting_shared_terms',	'1',	'yes'),
(87,	'site_icon',	'0',	'yes'),
(88,	'medium_large_size_w',	'768',	'yes'),
(89,	'medium_large_size_h',	'0',	'yes'),
(90,	'initial_db_version',	'35700',	'yes'),
(91,	'wp_user_roles',	'a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:67:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"wpt_twitter_oauth\";b:1;s:18:\"wpt_twitter_custom\";b:1;s:18:\"wpt_twitter_switch\";b:1;s:13:\"wpt_can_tweet\";b:1;s:13:\"wpt_tweet_now\";b:1;s:36:\"microblogposter_who_can_auto_publish\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:13:\"wpt_can_tweet\";b:1;s:36:\"microblogposter_who_can_auto_publish\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:12:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:13:\"wpt_can_tweet\";b:1;s:36:\"microblogposter_who_can_auto_publish\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:7:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:13:\"wpt_can_tweet\";b:1;s:36:\"microblogposter_who_can_auto_publish\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:3:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:36:\"microblogposter_who_can_auto_publish\";b:1;}}}',	'yes'),
(92,	'widget_search',	'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:18:\"awd_display_widget\";s:15:\"visible-desktop\";}s:12:\"_multiwidget\";i:1;}',	'yes'),
(93,	'widget_recent-posts',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(94,	'widget_recent-comments',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(95,	'widget_archives',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(96,	'widget_meta',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(97,	'sidebars_widgets',	'a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"main_sidebar\";a:3:{i:0;s:8:\"search-2\";i:1;s:10:\"nav_menu-2\";i:2;s:6:\"text-2\";}s:14:\"header_sidebar\";a:0:{}s:13:\"array_version\";i:3;}',	'yes'),
(151,	'ftp_credentials',	'a:3:{s:8:\"hostname\";s:14:\"localhost:2661\";s:8:\"username\";s:4:\"root\";s:15:\"connection_type\";s:3:\"ssh\";}',	'yes'),
(129127,	'_site_transient_timeout_theme_roots',	'1466114364',	'yes'),
(129128,	'_site_transient_theme_roots',	'a:6:{s:8:\"platform\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";s:9:\"twentyten\";s:7:\"/themes\";s:15:\"wp-themingstrap\";s:7:\"/themes\";}',	'yes'),
(100,	'widget_pages',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(101,	'widget_calendar',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(102,	'widget_tag_cloud',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(103,	'widget_nav_menu',	'a:2:{i:2;a:3:{s:5:\"title\";s:9:\"Main Menu\";s:8:\"nav_menu\";i:18;s:18:\"awd_display_widget\";s:15:\"visible-desktop\";}s:12:\"_multiwidget\";i:1;}',	'yes'),
(104,	'cron',	'a:12:{i:1466150890;a:1:{s:17:\"tweet_wheel_tweet\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:8:\"minutely\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1466151803;a:1:{s:8:\"ddp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"30min\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1800;}}}i:1466152211;a:1:{s:18:\"w3_pgcache_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:18:\"w3_pgcache_cleanup\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1466153226;a:1:{s:17:\"tweet_wheel_stats\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1466154552;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1466155762;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1466155777;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1466156177;a:1:{s:24:\"akismet_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1466160297;a:1:{s:25:\"wpi_three_hour_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:9:\"wpi_3_hrs\";s:4:\"args\";a:0:{}s:8:\"interval\";i:10800;}}}i:1466190257;a:1:{s:35:\"check_plugin_updates-pinterest-auto\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1466208000;a:1:{s:20:\"wpi_daily_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}',	'yes'),
(13417,	'_site_transient_timeout_browser_72ccb266eb9276f497ef7e8eaecdaec0',	'1453161477',	'yes'),
(13418,	'_site_transient_browser_72ccb266eb9276f497ef7e8eaecdaec0',	'a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"47.0.2526.106\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}',	'yes'),
(14797,	'_transient_dash_91cf481bdcff97d36bc4763744848eba',	'<h4>\n	<a href=\"http://feedproxy.google.com/~r/W3TOTALCACHE/~3/3ls41y0DNZI/opting-out-of-object-caching-for-certain-objects\">medhaniehabte1 on &quot;Opting out of Object Caching for certain objects&quot;</a>\n</h4>\n<h4>\n	<a href=\"http://feedproxy.google.com/~r/W3TOTALCACHE/~3/u3ifsCU0gyU/recently-an-error-occurred-while-creating-the-css-js-minify-cache-10\">Homika on &quot;Recently an error occurred while creating the CSS / JS minify cache&quot;</a>\n</h4>\n<h4>\n	<a href=\"http://feedproxy.google.com/~r/W3TOTALCACHE/~3/N1_dmRDg5sg/how-to-configure-w3-total-cache-and-cloudflare-in-a-right-way\">Norbertjmx on &quot;How to configure W3 Total Cache and Cloudflare in a right way&quot;</a>\n</h4>\n\n<p style=\"text-align: center;\">\n	<a href=\"http://feeds.feedburner.com/W3TOTALCACHE\" target=\"_blank\">View Feed</a>\n</p>\n',	'no'),
(14798,	'_transient_timeout_dash_54e0612bb2ce53db0827d5e7c3c1b7dc',	'1452700465',	'no'),
(14799,	'_transient_dash_54e0612bb2ce53db0827d5e7c3c1b7dc',	'\n<p style=\"text-align: center;\">\n	<a href=\"http://feeds.feedburner.com/W3EDGE\" target=\"_blank\">View Feed</a>\n</p>\n',	'no'),
(11673,	'w3tc_request_data',	'',	'no'),
(14794,	'_transient_timeout_feed_mod_6c78d00722dae650afc8789333d5c38e',	'1452700465',	'no'),
(14795,	'_transient_feed_mod_6c78d00722dae650afc8789333d5c38e',	'1452657265',	'no'),
(11716,	'_transient_timeout_w3tc_license_status',	'1452817812',	'no'),
(11717,	'_transient_w3tc_license_status',	'no_key',	'no'),
(113600,	'_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9',	'1464608396',	'no'),
(113601,	'_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9',	'1464565196',	'no'),
(99384,	'_site_transient_browser_dee24e1cb8ffa5ebe8021356c173956d',	'a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"48.0.2564.116\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}',	'yes'),
(99383,	'_site_transient_timeout_browser_dee24e1cb8ffa5ebe8021356c173956d',	'1458599923',	'yes'),
(52879,	'xyz_fbap_dnt_shw_notice',	'hide',	'yes'),
(48445,	'_site_transient_timeout_browser_74d24de62497d1079db4a4dd1bf6cf7e',	'1455317184',	'yes'),
(48446,	'_site_transient_browser_74d24de62497d1079db4a4dd1bf6cf7e',	'a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"48.0.2564.103\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}',	'yes'),
(113440,	'_site_transient_timeout_browser_670a5ab763d60c1df0e16a2a74951c56',	'1465076549',	'yes'),
(113441,	'_site_transient_browser_670a5ab763d60c1df0e16a2a74951c56',	'a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"50.0.2661.102\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}',	'yes'),
(113605,	'_transient_feed_mod_b9388c83948825c1edaef0d856b7b109',	'1464565197',	'no'),
(113597,	'_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca',	'1464565194',	'no'),
(113595,	'_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca',	'1464608394',	'no'),
(113596,	'_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca',	'1464608394',	'no'),
(123,	'can_compress_scripts',	'1',	'yes'),
(113602,	'_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109',	'1464608397',	'no'),
(113603,	'_transient_feed_b9388c83948825c1edaef0d856b7b109',	'a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 29 May 2016 23:13:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"363@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"The most downloaded plugin for WordPress (almost 30 million downloads). Use All in One SEO Pack to automatically optimize your site for Search Engines\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"5790@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Increase your traffic, view your stats, speed up your site, and protect yourself from hackers with Jetpack.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Google Analytics by MonsterInsights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"Connect Google Analytics with WordPress by adding your Google Analytics tracking code. Get the stats that matter.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Syed Balkhi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"25254@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"9542@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2082@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The Wordfence WordPress security plugin provides free enterprise-class WordPress security, protecting your website from hacks and malware.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2646@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"1169@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 14 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2572@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"6743@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"12073@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"Easy Web Performance Optimization (WPO) using caching: browser, page, object, database, minify and content delivery network support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"51888@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26907@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"28395@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"50539@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Displays Google Analytics reports in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"31973@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"UpdraftPlus WordPress Backup Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38058@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"21738@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"Take the guesswork out of WordPress security. iThemes Security offers 30+ ways to lock down WordPress in an easy-to-use WordPress security plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"iThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Clef Two-Factor Authentication\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wpclef/#post-47509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Dec 2012 01:25:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"47509@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Modern two-factor that people love to use: strong authentication without passwords or tokens; single sign on/off; magical user experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Dave Ross\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26607@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Meta Slider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/ml-slider/#post-49521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Feb 2013 16:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"49521@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Easy to use WordPress Slider plugin. Create responsive slideshows with Nivo Slider, Flex Slider, Coin Slider and Responsive Slides.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matcha Labs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 29 May 2016 23:39:57 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:7:\"expires\";s:29:\"Sun, 29 May 2016 23:48:45 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Sun, 29 May 2016 23:13:45 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20130911150210\";}',	'no'),
(14796,	'_transient_timeout_dash_91cf481bdcff97d36bc4763744848eba',	'1452700465',	'no'),
(113606,	'_transient_timeout_plugin_slugs',	'1464675753',	'no'),
(113607,	'_transient_plugin_slugs',	'a:28:{i:0;s:19:\"akismet/akismet.php\";i:1;s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";i:2;s:42:\"auto-hyperlink-urls/autohyperlink-urls.php\";i:3;s:39:\"azurecurve-bbcode/azurecurve-bbcode.php\";i:4;s:17:\"bbcode/bbcode.php\";i:5;s:31:\"bbcode-deluxe/bbcode-deluxe.php\";i:6;s:49:\"delete-duplicate-posts/delete-duplicate-posts.php\";i:7;s:37:\"disable-comments/disable-comments.php\";i:8;s:33:\"duplicate-menu/duplicate-menu.php\";i:9;s:47:\"facebook-auto-publish/facebook-auto-publish.php\";i:10;s:31:\"infobarwp-pro/infobarwp-pro.php\";i:11;s:33:\"jc-pinterest-pin/pinterestpin.php\";i:12;s:25:\"menu-image/menu-image.php\";i:13;s:41:\"aryo-widget-device/aryo-widget-device.php\";i:14;s:35:\"responsive-menu/responsive-menu.php\";i:15;s:41:\"social-auto-poster/social-auto-poster.php\";i:16;s:33:\"ssh-sftp-updater-support/sftp.php\";i:17;s:56:\"transposh-translation-filter-for-wordpress/transposh.php\";i:18;s:35:\"tweet-wheel-pro/tweet-wheel-pro.php\";i:19;s:33:\"w3-total-cache/w3-total-cache.php\";i:20;s:41:\"wp-pinterest-automatic/pinterest-auto.php\";i:21;s:25:\"affiliate/wp-referral.php\";i:22;s:29:\"wp-image-seo/wp-image-seo.php\";i:23;s:33:\"wp-delete-tags/wp-delete-tags.php\";i:24;s:36:\"affiliate2/wp_affiliate_platform.php\";i:25;s:25:\"wp-indexer/wp-indexer.php\";i:26;s:61:\"wp-limit-posts-automatically/wp-limit-posts-automatically.php\";i:27;s:43:\"wp-twitter-autopost/wp-twitter-autopost.php\";}',	'no'),
(113608,	'_transient_timeout_dash_88ae138922fe95674369b1cb3d215a2b',	'1464608397',	'no'),
(113609,	'_transient_dash_88ae138922fe95674369b1cb3d215a2b',	'<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2016/05/wordpress-4-5-2/\'>WordPress 4.5.2 Security Release</a> <span class=\"rss-date\">May 6, 2016</span><div class=\"rssSummary\">WordPress 4.5.2 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.5.1 and earlier are affected by a SOME vulnerability through Plupload, the third-party library WordPress uses for uploading files. WordPress versions 4.2 through 4.5.1 are vulnerable to reflected XSS [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://z9.io/2016/05/27/wordpress-is-thirteen/\'>Donncha: WordPress is thirteen!</a></li><li><a class=\'rsswidget\' href=\'https://poststatus.com/wordpress-org-draft-podcast/\'>Post Status: WordPress.org — Draft podcast</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/jetpack-4-0-3-patches-a-critical-xss-vulnerability\'>WPTavern: Jetpack 4.0.3 Patches a Critical XSS Vulnerability</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\'dashboard-news-plugin\'><span>Popular Plugin:</span> <a href=\'https://wordpress.org/plugins/google-analytics-dashboard-for-wp/\' class=\'dashboard-news-plugin-link\'>Google Analytics Dashboard for WP</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=google-analytics-dashboard-for-wp&amp;_wpnonce=33359f42ea&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'Google Analytics Dashboard for WP\'>Install</a>)</span></li></ul></div>',	'no'),
(144,	'box-sets_children',	'a:0:{}',	'yes'),
(136,	'_transient_twentysixteen_categories',	'1',	'yes'),
(137,	'_site_transient_timeout_wporg_theme_feature_list',	'1451134163',	'yes'),
(138,	'_site_transient_wporg_theme_feature_list',	'a:4:{s:6:\"Colors\";a:15:{i:0;s:5:\"black\";i:1;s:4:\"blue\";i:2;s:5:\"brown\";i:3;s:4:\"gray\";i:4;s:5:\"green\";i:5;s:6:\"orange\";i:6;s:4:\"pink\";i:7;s:6:\"purple\";i:8;s:3:\"red\";i:9;s:6:\"silver\";i:10;s:3:\"tan\";i:11;s:5:\"white\";i:12;s:6:\"yellow\";i:13;s:4:\"dark\";i:14;s:5:\"light\";}s:6:\"Layout\";a:9:{i:0;s:12:\"fixed-layout\";i:1;s:12:\"fluid-layout\";i:2;s:17:\"responsive-layout\";i:3;s:10:\"one-column\";i:4;s:11:\"two-columns\";i:5;s:13:\"three-columns\";i:6;s:12:\"four-columns\";i:7;s:12:\"left-sidebar\";i:8;s:13:\"right-sidebar\";}s:8:\"Features\";a:20:{i:0;s:19:\"accessibility-ready\";i:1;s:8:\"blavatar\";i:2;s:10:\"buddypress\";i:3;s:17:\"custom-background\";i:4;s:13:\"custom-colors\";i:5;s:13:\"custom-header\";i:6;s:11:\"custom-menu\";i:7;s:12:\"editor-style\";i:8;s:21:\"featured-image-header\";i:9;s:15:\"featured-images\";i:10;s:15:\"flexible-header\";i:11;s:20:\"front-page-post-form\";i:12;s:19:\"full-width-template\";i:13;s:12:\"microformats\";i:14;s:12:\"post-formats\";i:15;s:20:\"rtl-language-support\";i:16;s:11:\"sticky-post\";i:17;s:13:\"theme-options\";i:18;s:17:\"threaded-comments\";i:19;s:17:\"translation-ready\";}s:7:\"Subject\";a:3:{i:0;s:7:\"holiday\";i:1;s:13:\"photoblogging\";i:2;s:8:\"seasonal\";}}',	'yes'),
(202,	'akismet_show_user_comments_approved',	'0',	'yes'),
(180,	'widget_akismet_widget',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(181,	'_transient_timeout_feed_1a61025b8c723dcbf7c25d7082deaf8c',	'1451182222',	'no'),
(210,	'_transient_timeout_feed_mod_1a61025b8c723dcbf7c25d7082deaf8c',	'1451185372',	'no'),
(211,	'_transient_feed_mod_1a61025b8c723dcbf7c25d7082deaf8c',	'1451142172',	'no'),
(190,	'transposh_options',	'a:42:{s:16:\"default_language\";s:2:\"en\";s:18:\"viewable_languages\";s:5:\"en,de\";s:16:\"sorted_languages\";s:280:\"en,af,sq,ar,hy,az,eu,be,bn,bs,bg,ca,ceb,ny,zh,zh-tw,hr,cs,da,nl,eo,et,fi,fr,gl,ka,de,el,gu,ht,ha,hmn,mw,he,hi,hu,is,ig,id,ga,it,ja,jw,kn,kk,km,ko,lo,la,lv,lt,mk,mg,ms,ml,mt,mi,mr,mn,my,ne,no,fa,pl,pt,pa,ro,ru,sr,st,si,sk,sl,so,es,su,sw,sv,tl,tg,ta,te,th,tr,uk,ur,uz,vi,cy,yi,yo,zu\";s:26:\"allow_full_version_upgrade\";i:1;s:27:\"allow_anonymous_translation\";i:1;s:24:\"enable_default_translate\";i:0;s:23:\"enable_search_translate\";i:1;s:29:\"transposh_gettext_integration\";i:1;s:25:\"transposh_locale_override\";i:1;s:17:\"enable_permalinks\";i:1;s:21:\"enable_footer_scripts\";i:0;s:22:\"enable_detect_redirect\";i:0;s:23:\"transposh_collect_stats\";i:1;s:25:\"transposh_backup_schedule\";s:1:\"0\";s:13:\"transposh_key\";s:0:\"\";s:20:\"enable_autotranslate\";i:1;s:24:\"enable_autoposttranslate\";i:1;s:7:\"msn_key\";s:0:\"\";s:10:\"google_key\";s:0:\"\";s:20:\"preferred_translator\";i:1;s:6:\"oht_id\";s:0:\"\";s:7:\"oht_key\";s:0:\"\";s:18:\"widget_progressbar\";i:0;s:24:\"widget_allow_set_deflang\";i:0;s:12:\"widget_theme\";s:12:\"ui-lightness\";s:20:\"enable_url_translate\";i:0;s:17:\"jqueryui_override\";s:0:\"\";s:22:\"dont_add_rel_alternate\";i:0;s:24:\"parser_dont_break_puncts\";i:0;s:25:\"parser_dont_break_numbers\";i:0;s:26:\"parser_dont_break_entities\";i:0;s:12:\"debug_enable\";i:0;s:14:\"debug_loglevel\";i:3;s:13:\"debug_logfile\";s:0:\"\";s:14:\"debug_remoteip\";s:0:\"\";s:29:\"transposh_admin_hide_warnings\";s:0:\"\";s:17:\"enable_superproxy\";i:0;s:14:\"superproxy_key\";s:0:\"\";s:14:\"superproxy_ips\";s:0:\"\";s:10:\"yandex_key\";s:0:\"\";s:21:\"preferred_translators\";s:7:\"g,b,y,a\";s:18:\"widget_remove_logo\";i:1;}',	'yes'),
(48462,	'_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a',	'1454723411',	'yes'),
(48463,	'_site_transient_poptags_40cd750bba9870f18aada2478b24840a',	'a:100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"5663\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3554\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3503\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"3011\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2738\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"2224\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"2168\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"2009\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"1956\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"1949\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"1939\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1886\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1791\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1589\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1520\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1502\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:4:\"1447\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1302\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1262\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1248\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:4:\"1140\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:4:\"1066\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:4:\"1040\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:3:\"984\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:3:\"946\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"901\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"883\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:3:\"883\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"872\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"867\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"854\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"807\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"766\";}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";s:3:\"747\";}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";s:3:\"740\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"735\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"729\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"725\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"721\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"718\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"706\";}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";s:3:\"701\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"681\";}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";s:3:\"675\";}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";s:3:\"657\";}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";s:3:\"655\";}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";s:3:\"648\";}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"CSS\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";s:3:\"642\";}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";s:3:\"635\";}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";s:3:\"629\";}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";s:3:\"608\";}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";s:3:\"598\";}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";s:3:\"595\";}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";s:3:\"589\";}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";s:3:\"585\";}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";s:3:\"578\";}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";s:3:\"575\";}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";s:3:\"574\";}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";s:3:\"569\";}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";s:3:\"561\";}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";s:3:\"546\";}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";s:3:\"538\";}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";s:3:\"533\";}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";s:3:\"522\";}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";s:3:\"521\";}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";s:3:\"510\";}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";s:3:\"504\";}s:7:\"picture\";a:3:{s:4:\"name\";s:7:\"picture\";s:4:\"slug\";s:7:\"picture\";s:5:\"count\";s:3:\"504\";}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";s:3:\"499\";}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";s:3:\"498\";}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";s:3:\"476\";}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";s:3:\"475\";}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";s:3:\"472\";}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";s:3:\"462\";}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";s:3:\"461\";}s:8:\"pictures\";a:3:{s:4:\"name\";s:8:\"pictures\";s:4:\"slug\";s:8:\"pictures\";s:5:\"count\";s:3:\"457\";}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";s:3:\"432\";}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";s:3:\"429\";}s:5:\"flash\";a:3:{s:4:\"name\";s:5:\"flash\";s:4:\"slug\";s:5:\"flash\";s:5:\"count\";s:3:\"422\";}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";s:3:\"421\";}s:4:\"shop\";a:3:{s:4:\"name\";s:4:\"shop\";s:4:\"slug\";s:4:\"shop\";s:5:\"count\";s:3:\"418\";}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";s:3:\"415\";}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";s:3:\"414\";}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";s:3:\"408\";}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";s:3:\"403\";}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";s:3:\"400\";}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";s:3:\"400\";}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";s:3:\"398\";}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"News\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";s:3:\"396\";}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";s:3:\"389\";}s:9:\"thumbnail\";a:3:{s:4:\"name\";s:9:\"thumbnail\";s:4:\"slug\";s:9:\"thumbnail\";s:5:\"count\";s:3:\"389\";}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";s:3:\"389\";}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";s:3:\"382\";}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";s:3:\"380\";}s:8:\"lightbox\";a:3:{s:4:\"name\";s:8:\"lightbox\";s:4:\"slug\";s:8:\"lightbox\";s:5:\"count\";s:3:\"379\";}s:4:\"text\";a:3:{s:4:\"name\";s:4:\"text\";s:4:\"slug\";s:4:\"text\";s:5:\"count\";s:3:\"379\";}s:9:\"automatic\";a:3:{s:4:\"name\";s:9:\"automatic\";s:4:\"slug\";s:9:\"automatic\";s:5:\"count\";s:3:\"377\";}s:6:\"upload\";a:3:{s:4:\"name\";s:6:\"upload\";s:4:\"slug\";s:6:\"upload\";s:5:\"count\";s:3:\"375\";}s:6:\"paypal\";a:3:{s:4:\"name\";s:6:\"paypal\";s:4:\"slug\";s:6:\"paypal\";s:5:\"count\";s:3:\"375\";}s:7:\"profile\";a:3:{s:4:\"name\";s:7:\"profile\";s:4:\"slug\";s:7:\"profile\";s:5:\"count\";s:3:\"371\";}}',	'yes'),
(139,	'recently_activated',	'a:0:{}',	'yes'),
(153,	'theme_mods_twentysixteen',	'a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1451123297;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}',	'yes'),
(141,	'current_theme',	'WP ThemingStrap',	'yes'),
(142,	'theme_mods_platform',	'a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1451123162;s:4:\"data\";a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";N;s:9:\"sidebar-3\";N;s:9:\"sidebar-4\";N;s:9:\"sidebar-5\";N;s:9:\"sidebar-6\";N;s:9:\"sidebar-7\";N;s:9:\"sidebar-8\";N;s:9:\"sidebar-9\";N;}}}',	'yes'),
(143,	'theme_switched',	'',	'yes'),
(206,	'rewrite_rules',	'a:161:{s:10:\"(en|de)/?$\";s:26:\"index.php?lang=$matches[1]\";s:19:\"(en|de)/^wp-json/?$\";s:39:\"index.php?rest_route=/&lang=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:22:\"(en|de)/^wp-json/(.*)?\";s:50:\"index.php?rest_route=/$matches[2]&lang=$matches[1]\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:55:\"(en|de)/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:50:\"(en|de)/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:43:\"(en|de)/category/(.+?)/page/?([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[2]&paged=$matches[3]&lang=$matches[1]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:25:\"(en|de)/category/(.+?)/?$\";s:52:\"index.php?category_name=$matches[2]&lang=$matches[1]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:52:\"(en|de)/tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?tag=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:47:\"(en|de)/tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?tag=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:40:\"(en|de)/tag/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?tag=$matches[2]&paged=$matches[3]&lang=$matches[1]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:22:\"(en|de)/tag/([^/]+)/?$\";s:42:\"index.php?tag=$matches[2]&lang=$matches[1]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:53:\"(en|de)/type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?post_format=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:48:\"(en|de)/type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?post_format=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:41:\"(en|de)/type/([^/]+)/page/?([0-9]{1,})/?$\";s:68:\"index.php?post_format=$matches[2]&paged=$matches[3]&lang=$matches[1]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:23:\"(en|de)/type/([^/]+)/?$\";s:50:\"index.php?post_format=$matches[2]&lang=$matches[1]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:20:\"(en|de)/robots\\.txt$\";s:35:\"index.php?robots=1&lang=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:56:\"(en|de)/.*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:35:\"index.php?feed=old&lang=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:28:\"(en|de)/.*wp-app\\.php(/.*)?$\";s:36:\"index.php?error=403&lang=$matches[1]\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:26:\"(en|de)/.*wp-register.php$\";s:40:\"index.php?register=true&lang=$matches[1]\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:40:\"(en|de)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?&feed=$matches[2]&lang=$matches[1]\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:35:\"(en|de)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?&feed=$matches[2]&lang=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:28:\"(en|de)/page/?([0-9]{1,})/?$\";s:45:\"index.php?&paged=$matches[2]&lang=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:49:\"(en|de)/comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?&feed=$matches[2]&withcomments=1&lang=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"(en|de)/comments/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?&feed=$matches[2]&withcomments=1&lang=$matches[1]\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:52:\"(en|de)/search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?s=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:47:\"(en|de)/search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?s=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:40:\"(en|de)/search/(.+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?s=$matches[2]&paged=$matches[3]&lang=$matches[1]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:22:\"(en|de)/search/(.+)/?$\";s:40:\"index.php?s=$matches[2]&lang=$matches[1]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:55:\"(en|de)/author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?author_name=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:50:\"(en|de)/author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?author_name=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:43:\"(en|de)/author/([^/]+)/page/?([0-9]{1,})/?$\";s:68:\"index.php?author_name=$matches[2]&paged=$matches[3]&lang=$matches[1]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:25:\"(en|de)/author/([^/]+)/?$\";s:50:\"index.php?author_name=$matches[2]&lang=$matches[1]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:77:\"(en|de)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&feed=$matches[5]&lang=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:72:\"(en|de)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&feed=$matches[5]&lang=$matches[1]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:65:\"(en|de)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&paged=$matches[5]&lang=$matches[1]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:47:\"(en|de)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:80:\"index.php?year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&lang=$matches[1]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:64:\"(en|de)/([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:81:\"index.php?year=$matches[2]&monthnum=$matches[3]&feed=$matches[4]&lang=$matches[1]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:59:\"(en|de)/([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:81:\"index.php?year=$matches[2]&monthnum=$matches[3]&feed=$matches[4]&lang=$matches[1]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:52:\"(en|de)/([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:82:\"index.php?year=$matches[2]&monthnum=$matches[3]&paged=$matches[4]&lang=$matches[1]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:34:\"(en|de)/([0-9]{4})/([0-9]{1,2})/?$\";s:64:\"index.php?year=$matches[2]&monthnum=$matches[3]&lang=$matches[1]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:51:\"(en|de)/([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?year=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:46:\"(en|de)/([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?year=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:39:\"(en|de)/([0-9]{4})/page/?([0-9]{1,})/?$\";s:61:\"index.php?year=$matches[2]&paged=$matches[3]&lang=$matches[1]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:21:\"(en|de)/([0-9]{4})/?$\";s:43:\"index.php?year=$matches[2]&lang=$matches[1]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:35:\"(en|de)/.?.+?/attachment/([^/]+)/?$\";s:49:\"index.php?attachment=$matches[2]&lang=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"(en|de)/.?.+?/attachment/([^/]+)/trackback/?$\";s:54:\"index.php?attachment=$matches[2]&tb=1&lang=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"(en|de)/.?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?attachment=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"(en|de)/.?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?attachment=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"(en|de)/.?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?attachment=$matches[2]&cpage=$matches[3]&lang=$matches[1]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"(en|de)/.?.+?/attachment/([^/]+)/embed/?$\";s:60:\"index.php?attachment=$matches[2]&embed=true&lang=$matches[1]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"(en|de)/(.?.+?)/embed/?$\";s:58:\"index.php?pagename=$matches[2]&embed=true&lang=$matches[1]\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:28:\"(en|de)/(.?.+?)/trackback/?$\";s:52:\"index.php?pagename=$matches[2]&tb=1&lang=$matches[1]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:48:\"(en|de)/(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?pagename=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:43:\"(en|de)/(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?pagename=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:36:\"(en|de)/(.?.+?)/page/?([0-9]{1,})/?$\";s:65:\"index.php?pagename=$matches[2]&paged=$matches[3]&lang=$matches[1]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:43:\"(en|de)/(.?.+?)/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?pagename=$matches[2]&cpage=$matches[3]&lang=$matches[1]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:32:\"(en|de)/(.?.+?)(?:/([0-9]+))?/?$\";s:64:\"index.php?pagename=$matches[2]&page=$matches[3]&lang=$matches[1]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:44:\"(en|de)/.+?/[^/]+.html/attachment/([^/]+)/?$\";s:49:\"index.php?attachment=$matches[2]&lang=$matches[1]\";s:36:\".+?/[^/]+.html/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"(en|de)/.+?/[^/]+.html/attachment/([^/]+)/trackback/?$\";s:54:\"index.php?attachment=$matches[2]&tb=1&lang=$matches[1]\";s:46:\".+?/[^/]+.html/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"(en|de)/.+?/[^/]+.html/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?attachment=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:66:\".+?/[^/]+.html/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"(en|de)/.+?/[^/]+.html/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?attachment=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:61:\".+?/[^/]+.html/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"(en|de)/.+?/[^/]+.html/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?attachment=$matches[2]&cpage=$matches[3]&lang=$matches[1]\";s:61:\".+?/[^/]+.html/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"(en|de)/.+?/[^/]+.html/attachment/([^/]+)/embed/?$\";s:60:\"index.php?attachment=$matches[2]&embed=true&lang=$matches[1]\";s:42:\".+?/[^/]+.html/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"(en|de)/(.+?)/([^/]+).html/embed/?$\";s:80:\"index.php?category_name=$matches[2]&name=$matches[3]&embed=true&lang=$matches[1]\";s:27:\"(.+?)/([^/]+).html/embed/?$\";s:63:\"index.php?category_name=$matches[1]&name=$matches[2]&embed=true\";s:39:\"(en|de)/(.+?)/([^/]+).html/trackback/?$\";s:74:\"index.php?category_name=$matches[2]&name=$matches[3]&tb=1&lang=$matches[1]\";s:31:\"(.+?)/([^/]+).html/trackback/?$\";s:57:\"index.php?category_name=$matches[1]&name=$matches[2]&tb=1\";s:59:\"(en|de)/(.+?)/([^/]+).html/feed/(feed|rdf|rss|rss2|atom)/?$\";s:86:\"index.php?category_name=$matches[2]&name=$matches[3]&feed=$matches[4]&lang=$matches[1]\";s:51:\"(.+?)/([^/]+).html/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:54:\"(en|de)/(.+?)/([^/]+).html/(feed|rdf|rss|rss2|atom)/?$\";s:86:\"index.php?category_name=$matches[2]&name=$matches[3]&feed=$matches[4]&lang=$matches[1]\";s:46:\"(.+?)/([^/]+).html/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:47:\"(en|de)/(.+?)/([^/]+).html/page/?([0-9]{1,})/?$\";s:87:\"index.php?category_name=$matches[2]&name=$matches[3]&paged=$matches[4]&lang=$matches[1]\";s:39:\"(.+?)/([^/]+).html/page/?([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&paged=$matches[3]\";s:54:\"(en|de)/(.+?)/([^/]+).html/comment-page-([0-9]{1,})/?$\";s:87:\"index.php?category_name=$matches[2]&name=$matches[3]&cpage=$matches[4]&lang=$matches[1]\";s:46:\"(.+?)/([^/]+).html/comment-page-([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&cpage=$matches[3]\";s:43:\"(en|de)/(.+?)/([^/]+).html(?:/([0-9]+))?/?$\";s:86:\"index.php?category_name=$matches[2]&name=$matches[3]&page=$matches[4]&lang=$matches[1]\";s:35:\"(.+?)/([^/]+).html(?:/([0-9]+))?/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&page=$matches[3]\";s:33:\"(en|de)/.+?/[^/]+.html/([^/]+)/?$\";s:49:\"index.php?attachment=$matches[2]&lang=$matches[1]\";s:25:\".+?/[^/]+.html/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"(en|de)/.+?/[^/]+.html/([^/]+)/trackback/?$\";s:54:\"index.php?attachment=$matches[2]&tb=1&lang=$matches[1]\";s:35:\".+?/[^/]+.html/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"(en|de)/.+?/[^/]+.html/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?attachment=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:55:\".+?/[^/]+.html/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"(en|de)/.+?/[^/]+.html/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?attachment=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:50:\".+?/[^/]+.html/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"(en|de)/.+?/[^/]+.html/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?attachment=$matches[2]&cpage=$matches[3]&lang=$matches[1]\";s:50:\".+?/[^/]+.html/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"(en|de)/.+?/[^/]+.html/([^/]+)/embed/?$\";s:60:\"index.php?attachment=$matches[2]&embed=true&lang=$matches[1]\";s:31:\".+?/[^/]+.html/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"(en|de)/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:38:\"(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:41:\"(en|de)/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[2]&feed=$matches[3]&lang=$matches[1]\";s:33:\"(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:34:\"(en|de)/(.+?)/page/?([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[2]&paged=$matches[3]&lang=$matches[1]\";s:26:\"(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:41:\"(en|de)/(.+?)/comment-page-([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[2]&cpage=$matches[3]&lang=$matches[1]\";s:33:\"(.+?)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&cpage=$matches[2]\";s:16:\"(en|de)/(.+?)/?$\";s:52:\"index.php?category_name=$matches[2]&lang=$matches[1]\";s:8:\"(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";}',	'yes'),
(146,	'pagelines-settings',	'a:113:{s:13:\"email_capture\";s:0:\"\";s:21:\"pagelines_custom_logo\";s:69:\"http://hotfile.pw/wp-content/themes/platform/images/logo-platform.png\";s:17:\"pagelines_favicon\";s:79:\"http://hotfile.pw/wp-content/themes/platform/admin/images/favicon-pagelines.ico\";s:11:\"twittername\";s:0:\"\";s:19:\"pagelines_touchicon\";s:0:\"\";s:9:\"templates\";s:0:\"\";s:14:\"resettemplates\";s:0:\"\";s:24:\"pagelines_callout_header\";s:0:\"\";s:27:\"pagelines_callout_subheader\";s:0:\"\";s:23:\"pagelines_callout_image\";s:71:\"http://hotfile.pw/wp-content/themes/platform/images/callout_default.png\";s:22:\"pagelines_callout_link\";s:20:\"http://pagelines.com\";s:14:\"layout_default\";s:17:\"one-sidebar-right\";s:6:\"layout\";a:9:{s:12:\"saved_layout\";s:17:\"one-sidebar-right\";s:9:\"last_edit\";s:17:\"one-sidebar-right\";s:13:\"content_width\";i:960;s:17:\"one-sidebar-right\";a:4:{s:16:\"maincolumn_width\";i:640;s:20:\"primarysidebar_width\";i:320;s:12:\"gutter_width\";i:20;s:13:\"content_width\";i:960;}s:16:\"one-sidebar-left\";a:4:{s:16:\"maincolumn_width\";i:640;s:20:\"primarysidebar_width\";i:320;s:12:\"gutter_width\";i:20;s:13:\"content_width\";i:960;}s:17:\"two-sidebar-right\";a:4:{s:16:\"maincolumn_width\";i:480;s:20:\"primarysidebar_width\";i:240;s:12:\"gutter_width\";i:20;s:13:\"content_width\";i:960;}s:16:\"two-sidebar-left\";a:4:{s:16:\"maincolumn_width\";i:480;s:20:\"primarysidebar_width\";i:240;s:12:\"gutter_width\";i:20;s:13:\"content_width\";i:960;}s:18:\"two-sidebar-center\";a:4:{s:16:\"maincolumn_width\";i:480;s:20:\"primarysidebar_width\";i:240;s:12:\"gutter_width\";i:20;s:13:\"content_width\";i:960;}s:9:\"fullwidth\";a:4:{s:16:\"maincolumn_width\";i:960;s:20:\"primarysidebar_width\";i:0;s:12:\"gutter_width\";i:0;s:13:\"content_width\";i:0;}}s:11:\"resetlayout\";s:0:\"\";s:16:\"site_design_mode\";s:6:\"canvas\";s:6:\"bodybg\";s:7:\"#000000\";s:6:\"pagebg\";s:7:\"#FFFFFF\";s:15:\"page_content_bg\";s:7:\"#FFFFFF\";s:13:\"border_layout\";s:7:\"#E9E9E9\";s:11:\"headercolor\";s:7:\"#000000\";s:12:\"text_primary\";s:7:\"#000000\";s:14:\"text_secondary\";s:7:\"#AFAFAF\";s:13:\"text_tertiary\";s:7:\"#777777\";s:9:\"linkcolor\";s:7:\"#225E9B\";s:15:\"linkcolor_hover\";s:7:\"#0F457C\";s:17:\"box_color_primary\";s:7:\"#F7F7F7\";s:14:\"border_primary\";s:7:\"#E9E9E9\";s:21:\"border_primary_shadow\";s:7:\"#DDDDDD\";s:24:\"border_primary_highlight\";s:7:\"#FFFFFF\";s:17:\"text_shadow_color\";s:7:\"#FFFFFF\";s:19:\"box_color_secondary\";s:7:\"#F1F1F1\";s:16:\"border_secondary\";s:7:\"#DDDDDD\";s:23:\"border_secondary_shadow\";s:7:\"#CCCCCC\";s:18:\"box_color_tertiary\";s:7:\"#E1E1E1\";s:15:\"border_tertiary\";s:7:\"#CCCCCC\";s:22:\"border_tertiary_shadow\";s:7:\"#999999\";s:11:\"footer_text\";s:7:\"#999999\";s:16:\"footer_highlight\";s:7:\"#FFFFFF\";s:24:\"footer_text_shadow_color\";s:7:\"#000000\";s:12:\"type_headers\";a:1:{s:4:\"font\";s:7:\"georgia\";}s:12:\"type_primary\";a:1:{s:4:\"font\";s:7:\"georgia\";}s:14:\"type_secondary\";a:3:{s:4:\"font\";s:13:\"lucida_grande\";s:4:\"kern\";s:6:\"0.10em\";s:9:\"transform\";s:9:\"uppercase\";}s:11:\"type_inputs\";a:1:{s:4:\"font\";s:11:\"courier_new\";}s:14:\"typekit_script\";s:0:\"\";s:15:\"fontreplacement\";s:0:\"\";s:9:\"font_file\";s:0:\"\";s:12:\"replace_font\";s:2:\"h1\";s:15:\"icon_pos_bottom\";s:2:\"21\";s:14:\"icon_pos_right\";s:1:\"1\";s:7:\"rsslink\";s:1:\"1\";s:12:\"facebooklink\";s:0:\"\";s:11:\"twitterlink\";s:0:\"\";s:12:\"linkedinlink\";s:0:\"\";s:11:\"youtubelink\";s:0:\"\";s:17:\"nav_use_hierarchy\";s:0:\"\";s:16:\"enable_drop_down\";s:0:\"\";s:16:\"drop_down_shadow\";s:1:\"1\";s:16:\"drop_down_arrows\";s:1:\"1\";s:10:\"hidesearch\";s:0:\"\";s:18:\"breadcrumb_no_link\";s:0:\"\";s:16:\"blog_layout_mode\";s:8:\"magazine\";s:17:\"full_column_posts\";s:1:\"2\";s:10:\"thumb_blog\";s:1:\"1\";s:12:\"thumb_single\";s:0:\"\";s:12:\"thumb_search\";s:0:\"\";s:14:\"thumb_category\";s:1:\"1\";s:13:\"thumb_archive\";s:1:\"1\";s:10:\"thumb_clip\";s:1:\"1\";s:13:\"byline_author\";s:1:\"1\";s:11:\"byline_date\";s:1:\"1\";s:15:\"byline_comments\";s:1:\"1\";s:17:\"byline_categories\";s:0:\"\";s:12:\"excerpt_blog\";s:1:\"1\";s:14:\"excerpt_single\";s:0:\"\";s:14:\"excerpt_search\";s:1:\"1\";s:16:\"excerpt_category\";s:1:\"1\";s:15:\"excerpt_archive\";s:1:\"1\";s:10:\"pagetitles\";s:0:\"\";s:21:\"continue_reading_text\";s:16:\"Continue Reading\";s:12:\"content_blog\";s:0:\"\";s:14:\"content_search\";s:0:\"\";s:16:\"content_category\";s:0:\"\";s:15:\"content_archive\";s:0:\"\";s:23:\"post_footer_social_text\";s:56:\"If you enjoyed this article, please consider sharing it!\";s:14:\"share_facebook\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:19:\"share_twitter_cache\";s:0:\"\";s:15:\"share_delicious\";s:1:\"1\";s:10:\"share_mixx\";s:0:\"\";s:12:\"share_reddit\";s:1:\"1\";s:10:\"share_digg\";s:0:\"\";s:17:\"share_stumbleupon\";s:0:\"\";s:12:\"excerpt_tags\";s:10:\"<p><br><a>\";s:18:\"sidebar_no_default\";s:0:\"\";s:20:\"sidebar_wrap_widgets\";s:3:\"top\";s:11:\"footer_logo\";s:78:\"http://hotfile.pw/wp-content/themes/platform/images/logo-platformpro-small.png\";s:11:\"footer_more\";s:174:\"Thanks for dropping by! Feel free to join the discussion by leaving comments, and stay updated by subscribing to the <a href=\'http://hotfile.pw/index.php/feed/\'>RSS feed</a>.\";s:12:\"footer_terms\";s:19:\"&copy; 2015 HOTFILE\";s:14:\"box_col_number\";s:1:\"3\";s:9:\"box_items\";s:1:\"5\";s:14:\"box_thumb_size\";s:2:\"64\";s:15:\"box_default_tax\";s:13:\"default-boxes\";s:12:\"partner_link\";s:0:\"\";s:9:\"google_ie\";s:0:\"\";s:13:\"forum_options\";s:0:\"\";s:17:\"disable_ajax_save\";s:0:\"\";s:18:\"inline_dynamic_css\";s:0:\"\";s:12:\"enable_debug\";s:0:\"\";s:17:\"hide_introduction\";s:0:\"\";s:9:\"customcss\";s:6:\"body{}\";s:13:\"headerscripts\";s:0:\"\";s:13:\"footerscripts\";s:0:\"\";s:16:\"asynch_analytics\";s:0:\"\";}',	'yes'),
(147,	'pagelines_template_map',	'a:8:{s:6:\"header\";a:4:{s:4:\"hook\";s:16:\"pagelines_header\";s:4:\"name\";s:11:\"Site Header\";s:6:\"markup\";s:7:\"content\";s:8:\"sections\";a:3:{i:0;s:17:\"PageLinesBranding\";i:1;s:12:\"PageLinesNav\";i:2;s:18:\"PageLinesSecondNav\";}}s:6:\"footer\";a:4:{s:4:\"hook\";s:16:\"pagelines_footer\";s:4:\"name\";s:11:\"Site Footer\";s:6:\"markup\";s:7:\"content\";s:8:\"sections\";a:1:{i:0;s:17:\"PageLinesFootCols\";}}s:9:\"templates\";a:4:{s:4:\"hook\";s:18:\"pagelines_template\";s:4:\"name\";s:14:\"Page Templates\";s:6:\"markup\";s:7:\"content\";s:9:\"templates\";a:9:{s:7:\"default\";a:2:{s:4:\"name\";s:12:\"Default Page\";s:8:\"sections\";a:1:{i:0;s:16:\"PageLinesContent\";}}s:5:\"posts\";a:2:{s:4:\"name\";s:11:\"Posts Pages\";s:8:\"sections\";a:1:{i:0;s:16:\"PageLinesContent\";}}i:404;a:2:{s:4:\"name\";s:14:\"404 Error Page\";s:8:\"sections\";a:1:{i:0;s:16:\"PageLinesNoPosts\";}}s:6:\"single\";a:2:{s:4:\"name\";s:16:\"Single Post Page\";s:8:\"sections\";a:1:{i:0;s:16:\"PageLinesContent\";}}s:5:\"alpha\";a:3:{s:4:\"name\";s:12:\"Feature Page\";s:8:\"sections\";a:3:{i:0;s:17:\"PageLinesFeatures\";i:1;s:14:\"PageLinesBoxes\";i:2;s:16:\"PageLinesContent\";}s:7:\"version\";s:3:\"pro\";}s:4:\"beta\";a:3:{s:4:\"name\";s:13:\"Carousel Page\";s:8:\"sections\";a:2:{i:0;s:17:\"PageLinesCarousel\";i:1;s:16:\"PageLinesContent\";}s:7:\"version\";s:3:\"pro\";}s:5:\"gamma\";a:3:{s:4:\"name\";s:8:\"Box Page\";s:8:\"sections\";a:3:{i:0;s:18:\"PageLinesHighlight\";i:1;s:16:\"PageLinesSoapbox\";i:2;s:14:\"PageLinesBoxes\";}s:7:\"version\";s:3:\"pro\";}s:5:\"delta\";a:3:{s:4:\"name\";s:14:\"Highlight Page\";s:8:\"sections\";a:2:{i:0;s:18:\"PageLinesHighlight\";i:1;s:16:\"PageLinesContent\";}s:7:\"version\";s:3:\"pro\";}s:7:\"epsilon\";a:3:{s:4:\"name\";s:11:\"Banner Page\";s:8:\"sections\";a:3:{i:0;s:18:\"PageLinesHighlight\";i:1;s:16:\"PageLinesBanners\";i:2;s:16:\"PageLinesContent\";}s:7:\"version\";s:3:\"pro\";}}}s:4:\"main\";a:4:{s:4:\"hook\";s:14:\"pagelines_main\";s:4:\"name\";s:17:\"Text Content Area\";s:6:\"markup\";s:4:\"copy\";s:9:\"templates\";a:3:{s:7:\"default\";a:2:{s:4:\"name\";s:17:\"Page Content Area\";s:8:\"sections\";a:2:{i:0;s:17:\"PageLinesPostLoop\";i:1;s:17:\"PageLinesComments\";}}s:5:\"posts\";a:2:{s:4:\"name\";s:23:\"Posts Page Content Area\";s:8:\"sections\";a:3:{i:0;s:18:\"PageLinesPostsInfo\";i:1;s:17:\"PageLinesPostLoop\";i:2;s:19:\"PageLinesPagination\";}}s:6:\"single\";a:2:{s:4:\"name\";s:24:\"Single Post Content Area\";s:8:\"sections\";a:5:{i:0;s:16:\"PageLinesPostNav\";i:1;s:17:\"PageLinesPostLoop\";i:2;s:17:\"PageLinesShareBar\";i:3;s:17:\"PageLinesComments\";i:4;s:19:\"PageLinesPagination\";}}}}s:8:\"morefoot\";a:4:{s:4:\"name\";s:13:\"Morefoot Area\";s:4:\"hook\";s:18:\"pagelines_morefoot\";s:6:\"markup\";s:7:\"content\";s:8:\"sections\";a:2:{i:0;s:17:\"PageLinesMorefoot\";i:1;s:19:\"PageLinesTwitterBar\";}}s:8:\"sidebar1\";a:4:{s:4:\"name\";s:9:\"Sidebar 1\";s:4:\"hook\";s:18:\"pagelines_sidebar1\";s:6:\"markup\";s:4:\"copy\";s:8:\"sections\";a:1:{i:0;s:14:\"PrimarySidebar\";}}s:8:\"sidebar2\";a:4:{s:4:\"name\";s:9:\"Sidebar 2\";s:4:\"hook\";s:18:\"pagelines_sidebar2\";s:6:\"markup\";s:4:\"copy\";s:8:\"sections\";a:1:{i:0;s:16:\"SecondarySidebar\";}}s:12:\"sidebar_wrap\";a:5:{s:4:\"name\";s:12:\"Sidebar Wrap\";s:4:\"hook\";s:22:\"pagelines_sidebar_wrap\";s:6:\"markup\";s:4:\"copy\";s:7:\"version\";s:3:\"pro\";s:8:\"sections\";a:0:{}}}',	'yes'),
(148,	'pl_dynamic_version',	'1.4.4',	'yes'),
(154,	'theme_mods_twentyten',	'a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1451123438;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:19:\"primary-widget-area\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:21:\"secondary-widget-area\";N;s:24:\"first-footer-widget-area\";N;s:25:\"second-footer-widget-area\";N;s:24:\"third-footer-widget-area\";N;s:25:\"fourth-footer-widget-area\";N;}}}',	'yes'),
(159,	'theme_mods_wp-themingstrap',	'a:3:{i:0;b:0;s:16:\"background_image\";s:0:\"\";s:18:\"nav_menu_locations\";a:0:{}}',	'yes'),
(160,	'widget_themingstrap_socialmedia_widget',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(708,	'_transient_timeout__wpt_most_recent_tweet_1300',	'1451451772',	'no'),
(709,	'_transient__wpt_most_recent_tweet_1300',	'1',	'no'),
(710,	'_transient_timeout__wpt_most_recent_tweet_1302',	'1451451905',	'no'),
(711,	'_transient__wpt_most_recent_tweet_1302',	'1',	'no'),
(712,	'_transient_timeout__wpt_most_recent_tweet_1304',	'1451452035',	'no'),
(713,	'_transient__wpt_most_recent_tweet_1304',	'1',	'no'),
(720,	'_transient__wpt_most_recent_tweet_1308',	'1',	'no'),
(714,	'_transient_timeout__wpt_most_recent_tweet_1306',	'1451452165',	'no'),
(715,	'_transient__wpt_most_recent_tweet_1306',	'1',	'no'),
(170,	'WPLANG',	'',	'yes'),
(177,	'transposh_db_version',	'1.06',	'yes'),
(179,	'widget_transposh',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(289,	'akismet_spam_count',	'833',	'yes'),
(451,	'category_children',	'a:0:{}',	'yes'),
(213,	'themingstrap_theme_options',	'a:33:{s:11:\"footer_copy\";s:0:\"\";s:17:\"headerlogo-upload\";s:0:\"\";s:14:\"favicon-upload\";s:51:\"http://hotfile.pw/wp-content/uploads/2015/12/15.png\";s:6:\"submit\";s:12:\"Save Options\";s:11:\"twitter_uid\";s:0:\"\";s:12:\"facebook_uid\";s:0:\"\";s:12:\"linkedin_uid\";s:0:\"\";s:11:\"youtube_uid\";s:0:\"\";s:7:\"rss_uid\";s:0:\"\";s:15:\"google_plus_uid\";s:0:\"\";s:13:\"pinterest_uid\";s:0:\"\";s:23:\"themingstrap_inline_css\";s:0:\"\";s:22:\"themingstrap_inline_js\";s:0:\"\";s:10:\"breadcrumb\";i:0;s:10:\"cta_button\";i:0;s:10:\"front_page\";i:0;s:13:\"home_headline\";N;s:16:\"home_subheadline\";N;s:17:\"home_content_area\";N;s:8:\"cta_text\";N;s:7:\"cta_url\";N;s:16:\"featured_content\";N;s:24:\"google_site_verification\";N;s:22:\"bing_site_verification\";N;s:23:\"yahoo_site_verification\";N;s:23:\"site_statistics_tracker\";N;s:11:\"stumble_uid\";N;s:13:\"instagram_uid\";N;s:8:\"yelp_uid\";N;s:9:\"vimeo_uid\";N;s:14:\"foursquare_uid\";N;s:27:\"themingstrap_inline_js_head\";s:0:\"\";s:29:\"themingstrap_inline_js_footer\";s:0:\"\";}',	'yes'),
(312,	'nav_menu_options',	'a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}',	'yes'),
(236,	'wp_affiliates_clickthrough_version',	'4.9',	'yes'),
(216,	'wp_referral_affcheck',	'1',	'yes'),
(217,	'wp_referral_amount',	'1',	'yes'),
(218,	'wp_referral_amount_ccode',	'USD',	'yes'),
(219,	'wp_referral_notif_s',	'Good News!',	'yes'),
(220,	'wp_referral_notif_b',	'{user_nicename} just signed up! Keep up the good work!',	'yes'),
(221,	'wp_referral_wprefmobileapi',	'OGoy',	'yes'),
(222,	'wp_referral_register_url',	'',	'yes'),
(223,	'wp_referral_cookie_life',	'',	'yes'),
(224,	'wp_referral_notif',	'yes',	'yes'),
(225,	'wp_referral_fb',	'',	'yes'),
(226,	'wp_referral_wprefedit',	'yes',	'yes'),
(283,	'wordpress_api_key',	'efd5345b2c69',	'yes'),
(232,	'wp_aff_cookie_life',	'21',	'yes'),
(233,	'wp_aff_commission_level',	'25',	'yes'),
(239,	'wp_affiliates_payouts_version',	'4.9',	'yes'),
(240,	'wp_affiliates_banners_version',	'4.9',	'yes'),
(241,	'wp_affiliates_rel_tbl_version',	'4.9',	'yes'),
(242,	'wp_affiliates_linkage_tbl_version',	'4.9',	'yes'),
(243,	'wp_affiliate_platform_configs',	's:1491:\"a:6:{s:18:\"wp_aff_index_title\";s:31:\"Welcome to The Affiliate Center\";s:17:\"wp_aff_index_body\";s:1005:\"Join our affiliate program and start earning money for every sale you send our way! Simply create your account, place your linking code into your website and watch your account balance grow as your visitors become our customers.<br />\r\n<h3>How Does it Work?</h3>\r\nThe process is very simple:<br /><br />\r\n1. Visitor clicks on an affiliate link on your site or in an email.<br /><br />\r\n2. The visitors IP is logged and a cookie is placed in their browser for tracking purposes.<br /><br />\r\n3. The visitor browses our site, and may decide to order.<br /><br />\r\n4. If the visitor orders (the order does not need to be placed during the same browser session - cookies and IPs are stored up to a configurable amount of time), the order will be registered as a sale for you and you will receive commission for this sale.<br /><br />\r\n<h3>Already an Affiliate?</h3>\r\nPlease visit the Affiliate Login page and enter your username and password to gain access to your account statistics, banners, linking code.\r\n\";s:33:\"wp_aff_comm_notif_senders_address\";s:48:\"Hotfile.pw: 1-CLICK Downloads <admin@hotfile.pw>\";s:31:\"wp_aff_comm_notif_email_subject\";s:29:\"You just earned a commission!\";s:28:\"wp_aff_comm_notif_email_body\";s:118:\"Great news, you have just earned a commission!\n\nPlease log into your affiliate account to view the details.\n\nThank You\";s:29:\"wp_aff_do_not_show_sc_warning\";s:0:\"\";}\";',	'yes'),
(244,	'wp_aff_platform_configs_v2',	'a:6:{s:18:\"wp_aff_index_title\";s:31:\"Welcome to The Affiliate Center\";s:17:\"wp_aff_index_body\";s:1005:\"Join our affiliate program and start earning money for every sale you send our way! Simply create your account, place your linking code into your website and watch your account balance grow as your visitors become our customers.<br />\r\n<h3>How Does it Work?</h3>\r\nThe process is very simple:<br /><br />\r\n1. Visitor clicks on an affiliate link on your site or in an email.<br /><br />\r\n2. The visitors IP is logged and a cookie is placed in their browser for tracking purposes.<br /><br />\r\n3. The visitor browses our site, and may decide to order.<br /><br />\r\n4. If the visitor orders (the order does not need to be placed during the same browser session - cookies and IPs are stored up to a configurable amount of time), the order will be registered as a sale for you and you will receive commission for this sale.<br /><br />\r\n<h3>Already an Affiliate?</h3>\r\nPlease visit the Affiliate Login page and enter your username and password to gain access to your account statistics, banners, linking code.\r\n\";s:33:\"wp_aff_comm_notif_senders_address\";s:48:\"Hotfile.pw: 1-CLICK Downloads <admin@hotfile.pw>\";s:31:\"wp_aff_comm_notif_email_subject\";s:29:\"You just earned a commission!\";s:28:\"wp_aff_comm_notif_email_body\";s:118:\"Great news, you have just earned a commission!\n\nPlease log into your affiliate account to view the details.\n\nThank You\";s:29:\"wp_aff_do_not_show_sc_warning\";s:0:\"\";}',	'yes'),
(245,	'wp_aff_platform_version',	'5.9.4',	'yes'),
(246,	'wp_aff_currency_symbol',	'$',	'yes'),
(247,	'wp_aff_currency',	'USD',	'yes'),
(248,	'wp_aff_senders_email_address',	'Hotfile.pw: 1-CLICK Downloads <admin@hotfile.pw>',	'yes'),
(249,	'wp_aff_signup_email_subject',	'Affiliate Login Details',	'yes'),
(250,	'wp_aff_signup_email_body',	'Thank you for registering with us. Here are your login details...\n\nAffiliate ID: {user_name}\nEmail: {email} \n\nPasswd: {password} \n\nYou can Log into the system at the following URL:\n{login_url}\n\nPlease log into your account to get banners and view your real-time statistics.\n\nThank You\nAdministrator\n______________________________________________________\nTHIS IS AN AUTOMATED RESPONSE. \n***DO NOT RESPOND TO THIS EMAIL****',	'yes'),
(237,	'wp_affiliates_sales_version',	'4.9',	'yes'),
(238,	'wp_affiliates_leads_version',	'4.9',	'yes'),
(234,	'wp_aff_site_title',	'WP Affiliate Platform',	'yes'),
(235,	'wp_affiliates_version',	'4.9',	'yes'),
(201,	'akismet_strictness',	'1',	'yes'),
(251,	'wp_aff_default_affiliate_landing_url',	'',	'yes'),
(330,	'excerpt_length',	'418',	'yes'),
(406,	'mo_openid_share_widget_customize_direction_horizontal',	'1',	'yes'),
(420,	'mo_openid_auto_register_enable',	'1',	'yes'),
(421,	'mo_openid_register_disabled_message',	'Registration is disabled for this website. Please contact the administrator for any queries.',	'yes'),
(428,	'mo_openid_social_comment_disqus_label',	'Disqus Comments',	'yes'),
(458,	'aioseop_options',	'a:90:{s:12:\"aiosp_donate\";s:0:\"\";s:16:\"aiosp_home_title\";s:29:\"Hotfile.pw: 1-CLICK Downloads\";s:22:\"aiosp_home_description\";s:82:\"Free one-click downloads! With us you can downloads big files easily and securely.\";s:20:\"aiosp_togglekeywords\";s:1:\"0\";s:19:\"aiosp_home_keywords\";s:7:\"hotfile\";s:26:\"aiosp_use_static_home_info\";s:1:\"0\";s:9:\"aiosp_can\";s:2:\"on\";s:30:\"aiosp_no_paged_canonical_links\";s:0:\"\";s:31:\"aiosp_customize_canonical_links\";s:0:\"\";s:22:\"aiosp_can_set_protocol\";s:4:\"auto\";s:20:\"aiosp_rewrite_titles\";s:1:\"1\";s:20:\"aiosp_force_rewrites\";s:1:\"1\";s:24:\"aiosp_use_original_title\";s:1:\"0\";s:16:\"aiosp_cap_titles\";s:2:\"on\";s:14:\"aiosp_cap_cats\";s:2:\"on\";s:28:\"aiosp_home_page_title_format\";s:12:\"%page_title%\";s:23:\"aiosp_page_title_format\";s:28:\"%page_title% » %blog_title%\";s:23:\"aiosp_post_title_format\";s:28:\"%post_title% » %blog_title%\";s:27:\"aiosp_category_title_format\";s:32:\"%category_title% » %blog_title%\";s:26:\"aiosp_archive_title_format\";s:31:\"%archive_title% » %blog_title%\";s:23:\"aiosp_date_title_format\";s:22:\"%date% » %blog_title%\";s:25:\"aiosp_author_title_format\";s:24:\"%author% » %blog_title%\";s:22:\"aiosp_tag_title_format\";s:21:\"%tag% » %blog_title%\";s:25:\"aiosp_search_title_format\";s:24:\"%search% » %blog_title%\";s:24:\"aiosp_description_format\";s:13:\"%description%\";s:22:\"aiosp_404_title_format\";s:33:\"Nothing found for %request_words%\";s:18:\"aiosp_paged_format\";s:14:\" - Part %page%\";s:17:\"aiosp_enablecpost\";s:2:\"on\";s:17:\"aiosp_cpostactive\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:19:\"aiosp_cpostadvanced\";s:1:\"0\";s:18:\"aiosp_cpostnoindex\";s:0:\"\";s:19:\"aiosp_cpostnofollow\";s:0:\"\";s:16:\"aiosp_cpostnoodp\";s:0:\"\";s:17:\"aiosp_cpostnoydir\";s:0:\"\";s:17:\"aiosp_cposttitles\";s:0:\"\";s:21:\"aiosp_posttypecolumns\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:15:\"aiosp_admin_bar\";s:2:\"on\";s:23:\"aiosp_custom_menu_order\";s:2:\"on\";s:19:\"aiosp_google_verify\";s:0:\"\";s:17:\"aiosp_bing_verify\";s:0:\"\";s:22:\"aiosp_pinterest_verify\";s:0:\"\";s:22:\"aiosp_google_publisher\";s:0:\"\";s:28:\"aiosp_google_disable_profile\";s:0:\"\";s:29:\"aiosp_google_sitelinks_search\";s:0:\"\";s:26:\"aiosp_google_set_site_name\";s:0:\"\";s:30:\"aiosp_google_specify_site_name\";s:0:\"\";s:28:\"aiosp_google_author_advanced\";s:1:\"0\";s:28:\"aiosp_google_author_location\";a:1:{i:0;s:3:\"all\";}s:29:\"aiosp_google_enable_publisher\";s:2:\"on\";s:30:\"aiosp_google_specify_publisher\";s:0:\"\";s:25:\"aiosp_google_analytics_id\";s:0:\"\";s:32:\"aiosp_ga_use_universal_analytics\";s:0:\"\";s:25:\"aiosp_ga_advanced_options\";s:2:\"on\";s:15:\"aiosp_ga_domain\";s:0:\"\";s:21:\"aiosp_ga_multi_domain\";s:0:\"\";s:21:\"aiosp_ga_addl_domains\";s:0:\"\";s:21:\"aiosp_ga_anonymize_ip\";s:0:\"\";s:28:\"aiosp_ga_display_advertising\";s:0:\"\";s:22:\"aiosp_ga_exclude_users\";s:0:\"\";s:29:\"aiosp_ga_track_outbound_links\";s:0:\"\";s:25:\"aiosp_ga_link_attribution\";s:0:\"\";s:27:\"aiosp_ga_enhanced_ecommerce\";s:0:\"\";s:20:\"aiosp_use_categories\";s:2:\"on\";s:26:\"aiosp_use_tags_as_keywords\";s:2:\"on\";s:32:\"aiosp_dynamic_postspage_keywords\";s:2:\"on\";s:22:\"aiosp_category_noindex\";s:0:\"\";s:26:\"aiosp_archive_date_noindex\";s:2:\"on\";s:28:\"aiosp_archive_author_noindex\";s:2:\"on\";s:18:\"aiosp_tags_noindex\";s:2:\"on\";s:20:\"aiosp_search_noindex\";s:0:\"\";s:17:\"aiosp_404_noindex\";s:0:\"\";s:17:\"aiosp_tax_noindex\";s:0:\"\";s:23:\"aiosp_paginated_noindex\";s:0:\"\";s:24:\"aiosp_paginated_nofollow\";s:0:\"\";s:11:\"aiosp_noodp\";s:0:\"\";s:12:\"aiosp_noydir\";s:0:\"\";s:18:\"aiosp_skip_excerpt\";s:0:\"\";s:27:\"aiosp_generate_descriptions\";s:2:\"on\";s:20:\"aiosp_run_shortcodes\";s:0:\"\";s:33:\"aiosp_hide_paginated_descriptions\";s:0:\"\";s:32:\"aiosp_dont_truncate_descriptions\";s:0:\"\";s:19:\"aiosp_schema_markup\";s:2:\"on\";s:20:\"aiosp_unprotect_meta\";s:0:\"\";s:14:\"aiosp_ex_pages\";s:0:\"\";s:20:\"aiosp_post_meta_tags\";s:0:\"\";s:20:\"aiosp_page_meta_tags\";s:0:\"\";s:21:\"aiosp_front_meta_tags\";s:0:\"\";s:20:\"aiosp_home_meta_tags\";s:0:\"\";s:12:\"aiosp_do_log\";s:0:\"\";s:29:\"aiosp_attachment_title_format\";s:27:\"%post_title% | %blog_title%\";}',	'yes'),
(465,	'wp_image_seo_alt',	'%title',	'yes'),
(466,	'wp_image_seo_title',	'%title Photo',	'yes'),
(467,	'wp_image_seo_override',	'on',	'yes'),
(468,	'wp_image_seo_override_title',	'on',	'yes'),
(328,	'tonjoo_ecae_options',	'a:53:{s:14:\"excerpt_method\";s:9:\"paragraph\";s:5:\"width\";s:3:\"500\";s:15:\"strip_shortcode\";s:3:\"yes\";s:16:\"strip_empty_tags\";s:3:\"yes\";s:15:\"disable_on_feed\";s:3:\"yes\";s:14:\"special_method\";s:2:\"no\";s:7:\"justify\";s:2:\"no\";s:17:\"extra_html_markup\";s:4:\"span\";s:10:\"show_image\";s:3:\"yes\";s:14:\"image_position\";s:4:\"none\";s:16:\"image_width_type\";s:6:\"manual\";s:11:\"image_width\";s:3:\"300\";s:17:\"image_padding_top\";s:1:\"5\";s:19:\"image_padding_right\";s:1:\"5\";s:20:\"image_padding_bottom\";s:1:\"5\";s:18:\"image_padding_left\";s:1:\"5\";s:22:\"location_settings_type\";s:5:\"basic\";s:4:\"home\";s:3:\"yes\";s:10:\"front_page\";s:3:\"yes\";s:7:\"archive\";s:3:\"yes\";s:6:\"search\";s:3:\"yes\";s:13:\"advanced_home\";s:3:\"all\";s:19:\"advanced_home_width\";s:1:\"0\";s:18:\"advanced_frontpage\";s:3:\"all\";s:24:\"advanced_frontpage_width\";s:1:\"0\";s:16:\"advanced_archive\";s:3:\"all\";s:22:\"advanced_archive_width\";s:1:\"0\";s:15:\"advanced_search\";s:3:\"all\";s:21:\"advanced_search_width\";s:1:\"0\";s:18:\"advanced_page_main\";s:7:\"disable\";s:24:\"advanced_page_main_width\";s:1:\"0\";s:21:\"button_display_option\";s:6:\"normal\";s:9:\"read_more\";s:4:\"more\";s:21:\"read_more_text_before\";s:0:\"\";s:15:\"readmore_inline\";s:2:\"no\";s:15:\"read_more_align\";s:6:\"center\";s:11:\"button_font\";s:0:\"\";s:16:\"button_font_size\";s:2:\"14\";s:11:\"button_skin\";s:20:\"ecae-buttonskin-none\";s:10:\"custom_css\";s:395:\".ecae-link {\r\n	display: block;\r\n	padding: 16px 5px;\r\n	border: 3px solid #ff9a04;\r\n	-webkit-border-radius: 150px;\r\n	-moz-border-radius: 150px;\r\n	border-radius: 150px;\r\n	width: 60px;\r\n	height: 60px;\r\n	font-size: 14px;\r\n	font-weight: bold;\r\n	margin: 15px auto 0px auto;\r\n}\r\n.ecae-link:hover {\r\n	border: 3px solid #ff9a04;\r\n	background: #ff9a04;\r\n	color: #fff !important;\r\n	text-decoration: none;\r\n}\";s:15:\"excerpt_in_page\";s:0:\"\";s:14:\"home_post_type\";s:0:\"\";s:13:\"home_category\";s:0:\"\";s:19:\"frontpage_post_type\";s:0:\"\";s:18:\"frontpage_category\";s:0:\"\";s:17:\"archive_post_type\";s:0:\"\";s:16:\"archive_category\";s:0:\"\";s:16:\"search_post_type\";s:0:\"\";s:15:\"search_category\";s:0:\"\";s:24:\"excerpt_in_page_advanced\";s:0:\"\";s:13:\"advanced_page\";s:18:\"a:1:{i:0;s:1:\"2\";}\";s:14:\"page_post_type\";s:28:\"a:1:{i:0;a:1:{i:0;s:1:\"0\";}}\";s:13:\"page_category\";s:28:\"a:1:{i:0;a:1:{i:0;s:1:\"0\";}}\";}',	'yes'),
(476,	'RMVer',	'2.8.5',	'yes'),
(477,	'RMOptions',	'a:72:{s:2:\"RM\";s:9:\"main-menu\";s:7:\"RMBreak\";i:800;s:7:\"RMDepth\";i:2;s:5:\"RMTop\";i:10;s:7:\"RMRight\";i:5;s:5:\"RMCss\";s:0:\"\";s:7:\"RMTitle\";s:9:\"Main Menu\";s:9:\"RMLineCol\";s:7:\"#FFFFFF\";s:10:\"RMClickBkg\";s:7:\"#ff9a04\";s:12:\"RMClickTitle\";s:0:\"\";s:9:\"RMBkgTran\";N;s:6:\"RMFont\";s:0:\"\";s:5:\"RMPos\";s:0:\"\";s:7:\"RMImage\";s:0:\"\";s:7:\"RMWidth\";i:75;s:5:\"RMBkg\";s:7:\"#43494C\";s:8:\"RMBkgHov\";s:7:\"#3C3C3C\";s:10:\"RMTitleCol\";s:7:\"#FFFFFF\";s:9:\"RMTextCol\";s:7:\"#FFFFFF\";s:8:\"RMBorCol\";s:7:\"#3C3C3C\";s:12:\"RMTextColHov\";s:7:\"#FFFFFF\";s:13:\"RMTitleColHov\";s:7:\"#FFFFFF\";s:6:\"RMAnim\";s:7:\"overlay\";s:9:\"RMPushCSS\";s:0:\"\";s:10:\"RMTitleBkg\";s:7:\"#43494C\";s:10:\"RMFontSize\";i:13;s:11:\"RMTitleSize\";i:14;s:9:\"RMBtnSize\";i:13;s:8:\"RMCurBkg\";s:7:\"#43494C\";s:8:\"RMCurCol\";s:7:\"#FFFFFF\";s:9:\"RMAnimSpd\";d:0.5;s:9:\"RMTranSpd\";d:1;s:10:\"RMTxtAlign\";s:4:\"left\";s:8:\"RMSearch\";N;s:8:\"RMExpand\";N;s:12:\"RMLinkHeight\";i:20;s:10:\"RMExternal\";N;s:6:\"RMSide\";s:4:\"left\";s:8:\"RMFooter\";s:6:\"footer\";s:10:\"RMClickImg\";s:0:\"\";s:8:\"RMMinify\";s:6:\"minify\";s:12:\"RMClickClose\";N;s:8:\"RMRemImp\";N;s:3:\"RMX\";N;s:10:\"RMMinWidth\";i:0;s:10:\"RMMaxWidth\";i:0;s:11:\"RMExpandPar\";s:6:\"expand\";s:11:\"RMIgnParCli\";N;s:10:\"RMCliToClo\";N;s:11:\"RMSearchPos\";s:5:\"below\";s:11:\"RMTitleLink\";s:0:\"\";s:10:\"RMTitleLoc\";s:5:\"_self\";s:6:\"RMHtml\";s:0:\"\";s:9:\"RMHtmlLoc\";s:5:\"above\";s:11:\"RMShortcode\";N;s:12:\"RMLineHeight\";i:5;s:11:\"RMLineWidth\";i:33;s:12:\"RMLineMargin\";i:6;s:17:\"RMClickImgClicked\";s:0:\"\";s:11:\"RMAccordion\";N;s:8:\"RMArShpA\";s:8:\"\"\\u25b2\"\";s:8:\"RMArShpI\";s:8:\"\"\\u25bc\"\";s:8:\"RMArImgA\";s:0:\"\";s:8:\"RMArImgI\";s:0:\"\";s:9:\"RMTrigger\";s:11:\"#click-menu\";s:9:\"RMPushBtn\";N;s:11:\"RMCurBkgHov\";s:7:\"#43494C\";s:11:\"RMCurColHov\";s:7:\"#FFFFFF\";s:8:\"RMWalker\";s:0:\"\";s:9:\"RMUseTran\";N;s:5:\"RMLoc\";s:5:\"right\";s:15:\"RMThemeLocation\";s:0:\"\";}',	'yes'),
(340,	'excerpt_everywhere_length',	'500',	'yes'),
(341,	'excerpt_everywhere_align',	'aligncenter',	'yes'),
(342,	'excerpt_everywhere_moretext',	'more',	'yes'),
(343,	'excerpt_everywhere_moreimg',	'',	'yes'),
(344,	'excerpt_everywhere_rss',	'yes',	'yes'),
(345,	'excerpt_everywhere_homepage',	'no',	'yes'),
(346,	'excerpt_everywhere_sticky',	'no',	'yes'),
(347,	'excerpt_everywhere_thumb',	'medium',	'yes'),
(348,	'excerpt_everywhere_class',	'',	'yes'),
(2118,	'delete_duplicate_posts_options',	'a:5:{s:7:\"default\";s:7:\"options\";s:11:\"ddp_enabled\";b:1;s:14:\"ddp_statusmail\";b:0;s:8:\"ddp_keep\";s:6:\"oldest\";s:9:\"ddp_limit\";s:2:\"25\";}',	'yes'),
(113598,	'_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9',	'1464608396',	'no'),
(113599,	'_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9',	'a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Donncha: WordPress is thirteen!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"http://z9.io/?p=89499890\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"http://z9.io/2016/05/27/wordpress-is-thirteen/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1231:\"<p>You could have knocked me over with a feather today when I read <a href=\"https://ma.tt/2016/05/wordpress-is-a-teenager/\">Matt&#8217;s post</a> announcing that WordPress was celebrating a birthday!</p>\n<p>It didn&#8217;t seem so long ago that we were working on b2++, hacking the multiuser bits in and doing all sorts of crazy things with it.</p>\n<p>Now I&#8217;m &#8220;typing&#8221; this on a mobile phone by swiping my finger across a virtual keyboard. Back then the closest to this that I could imagine would be some sort of SMS integration!</p>\n<p>WordPress today is unrecognisable from what it was back then, especially if you use the slick Calypso interface.</p>\n<p>I&#8217;m looking forward to seeing what the next few years bring.</p>\n\n<p><strong>Related Posts</strong><ul><li> <a href=\"http://z9.io/2013/08/02/like-a-dog-and-his-ball/\" rel=\"bookmark\" title=\"Permanent Link: Like a dog and his ball\">Like a dog and his ball</a></li><li> <a href=\"http://z9.io/2009/01/28/wordpress-mu-27/\" rel=\"bookmark\" title=\"Permanent Link: WordPress MU 2.7\">WordPress MU 2.7</a></li><li> <a href=\"http://z9.io/2008/09/02/wordpress-mu-261/\" rel=\"bookmark\" title=\"Permanent Link: WordPress MU 2.6.1\">WordPress MU 2.6.1</a></li></ul></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2016 22:57:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Donncha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"Post Status: WordPress.org — Draft podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=24730\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://poststatus.com/wordpress-org-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3592:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Joe Hoyle &#8212; the CTO of Human Made &#8212; and Brian Krogsgard.</p>\n<p><span>In this episode, Joe and Brian discuss the structure and function of the WordPress.org website, which is the hub of the WordPress project. From the actual software distribution, to discussions about the project, to support, and buying swag: it all happens from WordPress.org. We break down what’s what and what we think you should know.</span></p>\n<p><!--[if lt IE 9]><script>document.createElement(\'audio\');</script><![endif]-->\n<a href=\"https://audio.simplecast.com/38479.mp3\">https://audio.simplecast.com/38479.mp3</a><br />\n<a href=\"http://audio.simplecast.com/38479.mp3\">Direct Download</a></p>\n<h3>Notes</h3>\n<p>Who owns WordPress.org?<br />\nWho works on WordPress.org<br />\nHow WordPress.org distributes software updates</p>\n<h3>Different Sections of WordPress.org Navigation</h3>\n<ul>\n<li>Showcase</li>\n<li>WordPress theme directory &#8212; and reviews &#8212; and commercial themes</li>\n<li>WordPress plugin directory &#8212; and reviews</li>\n<li>Mobile &#8212; Redirects to .com</li>\n<li>Support Forums / Codex &#8220;documentation&#8221;</li>\n<li>Make WordPress (Get Involved)</li>\n<li>About (many sub pages and also project structure)</li>\n<li>Blog</li>\n<li>Hosting</li>\n<li>Download (button &#8212; in future to be <a href=\"https://make.wordpress.org/meta/2016/02/29/get-wordpress-improving-the-path-to-wordpress/\">Get WordPress</a>)</li>\n</ul>\n<h3>Other Sections</h3>\n<ul>\n<li><a href=\"https://core.trac.wordpress.org/\">core.trac.wordpress.org</a></li>\n<li><a href=\"https://developer.wordpress.org/\">developer.wordpress.org</a></li>\n<li><a href=\"https://mercantile.wordpress.org/\">mercantile.wordpress.org</a></li>\n<li><a href=\"http://jobs.wordpress.net/\">jobs.wordpress.net</a></li>\n<li><a href=\"https://learn.wordpress.org/\">learn.wordpress.org</a></li>\n<li><a href=\"https://wordpress.org/ideas/\">Ideas</a></li>\n</ul>\n<h3>Other Linked Sites</h3>\n<ul>\n<li><a href=\"https://central.wordcamp.org/\">WordCamp</a></li>\n<li><a href=\"http://wordpress.tv/\">WordPress.tv</a></li>\n<li><a href=\"https://buddypress.org/\">BuddyPress</a></li>\n<li><a href=\"https://bbpress.org/\">bbPress</a></li>\n<li><a href=\"https://wordpress.com/\">WordPress.com</a></li>\n<li><a href=\"https://ma.tt/\">ma.tt</a></li>\n</ul>\n<h3>Active Projects for Improving</h3>\n<ul>\n<li><a href=\"https://make.wordpress.org/meta/tag/helphub/\">Helphub</a></li>\n<li>Handbooks (theme), plugin published</li>\n<li>Plugin directory</li>\n</ul>\n<h3>Links</h3>\n<ul>\n<li><a href=\"https://make.wordpress.org/meta/\">Blog for WordPress.org projects</a></li>\n</ul>\n<h3>Sponsor</h3>\n<p><span>This episode is sponsored by Gravity Forms. <a href=\"http://www.gravityforms.com/\">Gravity Forms</a>  makes the best web forms on the planet. Over a million WordPress sites are already using Gravity Forms. Is yours? For more information, check out their <a href=\"http://www.gravityforms.com/\">website</a> and thank you to Gravity Forms for being a Post Status partner. </span><b> </b></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2016 19:18:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Katie Richards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: Jetpack 4.0.3 Patches a Critical XSS Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=55036\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://wptavern.com/jetpack-4-0-3-patches-a-critical-xss-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2266:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/07/jetpack-logo.gif\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/07/jetpack-logo.gif?resize=700%2C276\" alt=\"jetpack-logo\" class=\"aligncenter size-full wp-image-27470\" /></a></p>\n<p><a href=\"https://jetpack.com/2016/05/27/jetpack-4-0-3-critical-security-update/\" target=\"_blank\">Jetpack 4.0.3 is a security release</a> that contains an important fix for a critical vulnerability that has been present in the plugin since version 2.0, released in 2012. According to Jetpack team member Sam Hotchkiss, a stored XSS vulnerability was found in the way that some Jetpack shortcodes are processed, which allows an attacker to insert JavaScript into comments to hijack a visitor&#8217;s browser.</p>\n<p>This particular bug is similar to one <a href=\"https://blog.sucuri.net/2016/05/security-advisory-stored-xss-bbpress-2.html\" target=\"_blank\">recently found and patched in bbPress</a>.</p>\n<p>&#8220;Similar issues may exist in other plugins, and it’s a good reminder about the power of regular expressions to create issues when parsing data,&#8221; Hotchkiss said.</p>\n<p>The Jetpack team has been working with the WordPress security team to push out point releases for all vulnerable branches of the plugin&#8217;s codebase, which includes all versions following 2.0. They are using WordPress&#8217; core automatic update system, so all sites that have not explicitly opted out will receive the security update.</p>\n<p>&#8220;Fortunately, we have no evidence of this being used in the wild,&#8221; Hotchkiss said. &#8220;However, now that this update is public, it’s just a matter of time before someone attempts to exploit it.&#8221; The Jetpack team is advising users to update as soon as possible, as the update also fixes any potential exploits that may have already been put in place.</p>\n<p>The team credits Marc-Alexandre Montpas from <a href=\"https://sucuri.net/\" target=\"_blank\">Sucuri</a> for finding the bug and disclosing it responsibly. Users will be notified about the security release via email, but those who have Akismet and/or VaultPress installed have already been protected since the first reporting of the vulnerability.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2016 01:05:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Post Status: Growing a lifestyle business without losing the lifestyle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=24644\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://poststatus.com/growing-lifestyle-business/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8760:\"<p><em><strong>Editor&#8217;s Note</strong>: This is a guest post by Nate Wright. Nate is a WordPress developer and solopreneur. He runs <a href=\"http://themeofthecrop.com\">Theme of The Crop</a>, a niche WordPress theme company geared toward restaurant websites. You can learn more about Nate on his <a href=\"https://poststatus.com/profiles/nate-wright/\">Post Status profile</a> and follow him on <a href=\"https://twitter.com/natewr\">Twitter</a>.</em></p>\n<hr />\n<p>Here&#8217;s a scenario you&#8217;re probably familiar with: a friend or family member, not terribly tech-savvy, approaches you with an idea. Why don&#8217;t you build Facebook for clowns? What about Uber for sandwiches?</p>\n<p>Their ideas are often a little better than these. Sometimes they&#8217;re worse. But in my case the conversation always gets to the same point in the end.</p>\n<p>You can build stuff on the internet. Why aren&#8217;t you shooting for the stars? Don&#8217;t you want to be rich like Zuckerberg?</p>\n<p>Right now some of you may be thinking: yes I do! This post isn&#8217;t for you.</p>\n<p>This is for those of you who cringe at the thought of your days filling up with hiring and training staff, conducting meetings, or filling out paperwork. Those of you who don&#8217;t want to live the big siloed life of a CEO. Who dove into the WordPress market because you wanted to build things yourself. For yourself.</p>\n<h3>The rockstars and the rest of us</h3>\n<p>It’s hard to find someone more widely admired among WordPress developers &#8212; and more deserving of that admiration &#8212; than <a href=\"https://pippinsplugins.com/about/\">Pippin Williamson</a>. So when he <a href=\"https://pippinsplugins.com/control-give-grow/\">described his evolution</a> from staunch go-it-aloner to team leader, many of us sat up and listened.</p>\n<p>The <a href=\"https://pippinsplugins.com/control-give-grow/#comments\">comments</a> in response to that post exhibit a common mix of anxiety, frustration and hope for us go-it-aloners, who have carved out small (and not so small) niches in the WordPress world.</p>\n<p>We’re overstretched and under resourced. We lack good marketing strategies. And we can see that growth will come from transforming our businesses into larger enterprises.</p>\n<p>But then we start thinking about what that means. The hiring. The firing. The training. The meetings. The paperwork. <i>The liability</i>.</p>\n<p>&#8216;I don’t want to be the next Zuckerberg,&#8217; you may think. Then, hopefully, you’ll laugh at the absurdity. But really, you may think, &#8216;I don’t even want to be the next <a href=\"http://carlhancock.com/\">Carl Hancock</a> or <a href=\"https://yoast.com/author/joost/\">Joost de Valk</a>.&#8217;</p>\n<p>Let me be honest with you. I’ll stop putting words in your mouth and put them in mine.</p>\n<p>I have a lifestyle business. No, I don’t sell lifestyle products. I have a business <em>tailored to my lifestyle</em>.</p>\n<p>I have a business that allows to me to take lunch when I want, finish the day when I want, go on holiday when I want, write the code that I want. That’s my job perk. That’s my killer bonus. No, that’s my Shangri-La.</p>\n<p>When people tell you to hire early or scale quickly, they’re right that giving up control can be liberating. But it can also be encumbering. It brings new responsibilities at the same time that it releases you from old ones.</p>\n<p>Whether or not growing your team is right for you will depend on your temperament, your appetite and the kind of lifestyle you want.</p>\n<h3>Being a little fish in a big pond</h3>\n<p>But let’s be honest. You took a chance on the WordPress market because you saw a window of opportunity. That window may be closing.</p>\n<p>In the last few years we’ve seen a lot of consolidation. The theme market exploded, <a href=\"http://inside.envato.com/envato-stories-muhammad-haris-themefusion-2/\">made millions for a few</a>, and then caused a gold rush which <a href=\"http://scottbolinger.com/wordpress-theme-business/\">saturated the market and pushed out small operators</a>.</p>\n<p>At the same time, two big traditional distribution channels dried up: the official <a href=\"https://wordpress.org/themes/\">WordPress.org theme repository</a>, which has a huge backlog of themes awaiting approval, and <a href=\"https://theme.wordpress.com/\">Automattic’s marketplace</a>, which is closed to new entrants.</p>\n<p>We’re also seeing more traditional investment in WordPress properties. The big one is the <a href=\"http://recode.net/2014/05/05/wordpress-parent-automattic-has-raised-160-million-now-valued-at-1-16-billion-post-money/\">$160 million raised by Automattic</a> and Automattic&#8217;s subsequent <a href=\"https://poststatus.com/automattic-acquired-woocommerce-woothemes/\">acquisition of WooThemes</a>. Many actors are moving more aggressively to leverage or retain their market position. Syed Balkhi is on a buying and building spree (<a href=\"http://enviragallery.com/about-us/\">1</a>, <a href=\"http://optinmonster.com/about/\">2</a>, <a href=\"https://wpforms.com/say-hello-to-wpforms/\">3</a>, <a href=\"http://wptavern.com/syed-balkhi-acquires-google-analytics-by-yoast-renames-to-monsterinsights\">4</a>). Ninja Forms did a <a href=\"https://ninjaforms.com/releasing-three/\">ground-up rebuild</a>. Pippin’s shedding non-essential products (<a href=\"https://pippinsplugins.com/easy-content-types-acquired/\">1</a>, <a href=\"https://pippinsplugins.com/nikhil-vimal-adopts-front-end-registration-and-login-forms-plugin/\">2</a>) and <a href=\"https://pippinsplugins.com/selfish/\">purging some third-party addons</a>.</p>\n<p>The ecosystem looks increasingly unfriendly to us go-it-aloners. Automattic was the first to go big. Given exclusive commercial access to the WordPress trademark, it carved out its own space and split WordPress down the middle. Now the other half &#8212; the WordPress for the rest of us &#8212; is going big too.</p>\n<p>The nice thing about being a small operator is that you only need a tiny sliver of the pie. But as the size of the market has grown, it’s become more difficult to attract attention. Showing up with a good product isn’t enough.</p>\n<h3>Going it alone, together</h3>\n<p>My lifestyle business is working well for me. Revenue keeps inching up. Slowly.</p>\n<p>But it might not make it in a different kind of WordPress space. I’ve been thinking a lot about that lately. And I bet you have too.</p>\n<p>Where’s the market going? What am I willing to trade to survive? Which headaches are <a href=\"http://www.codeinwp.com/blog/transparency-report-14/\">worth changing direction for</a> and which headaches aren’t?</p>\n<p>Here are some of the ideas I’ve been tossing around:</p>\n<h3>Contractors</h3>\n<p>Hiring out. I could scale up or down easily, depending on how well it goes. But it’s tough to manage quality when juggling vendors.</p>\n<p>And what would I contract? I’d like to shed my bumbling efforts in marketing and traffic generation. But that seems like precisely the kind of job full of jackals who don’t know what they’re doing.</p>\n<p>Ok, that’s harsh. I’ll just say: I worry it’d be a headache to manage it well.</p>\n<p>Theme development seems the most plausible, since there’s a large body of talented, hungry themers washing up from the stormy seas of ThemeForest. But it may be the least valuable since the market is being swallowed up by a few big themes.</p>\n<h3>Commissions</h3>\n<p>Affiliate marketing is already working for me. A little. I could go further and recruit theme or plugin developers to sell from my site on commission.</p>\n<p>Then I’m saddled with support for products I didn’t build. Can I maintain quality? Can I drive enough traffic to be an attractive outlet for them? Will I end up with all of the headaches I wanted to avoid?</p>\n<h3>Partnerships</h3>\n<p>Maybe I’ll trade in my king-of-the-hill cap and bring on partners. Not employees. Genuine partners with overlapping skill sets. Instead of being a go-it-aloner we can be two or three go-it-aloners going it alone together!</p>\n<p>Or maybe that’s just a terrible way to run a business.</p>\n<h3>Alliances</h3>\n<p>There are a lot of us out there. Independent themers looking to expand beyond ThemeForest or give up on the old freemium approach of the official repository. Plugin developers looking for a new home or seeking out themes that will integrate with their plugins.</p>\n<p>We could probably do something special if we made stronger alliances. Combined to build to stronger platforms for our products.</p>\n<p>But that sounds like a lot of project management. Isn’t that what we were hoping to avoid?</p>\n<p>I don’t know. I’m going to go write some code.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 May 2016 18:10:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Nate Wright\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WP Mobile Apps: WordPress for iOS: Version 6.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://apps.wordpress.com/?p=3416\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://apps.wordpress.com/2016/05/25/wordpress-for-ios-version-6-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3021:\"<p>Hi there, WordPress users! <a href=\"https://itunes.apple.com/us/app/wordpress/id335703880?mt=8&uo=6&at=&ct=\">Version 6.2 of the WordPress for iOS app</a> is now available in the App Store.</p>\n<h1>What&#8217;s New:</h1>\n<p><strong>Sharing just got easier!</strong> Post content from apps to your WordPress.com site with a new Share extension. Also, share a post right from your editor’s preview screen.</p>\n\n<a href=\"https://apps.wordpress.com/img_2229_2/\"><img width=\"169\" height=\"300\" src=\"https://apps.files.wordpress.com/2016/05/img_2229_2.png?w=169&h=300\" class=\"attachment-medium size-medium\" alt=\"IMG_2229_2\" /></a>\n<a href=\"https://apps.wordpress.com/img_2230/\"><img width=\"169\" height=\"300\" src=\"https://apps.files.wordpress.com/2016/05/img_2230.png?w=169&h=300\" class=\"attachment-medium size-medium\" alt=\"IMG_2230\" /></a>\n\n<p><strong>Improved clipboard support: </strong>Working with images? You can now copy and paste single images in your editor.</p>\n<p><strong>Login with ease:</strong> We improved error messages for self-hosted users.</p>\n<p><strong>Enhancements:</strong> Because &#8220;good&#8221; is not enough! Here&#8217;s the full <a href=\"https://github.com/wordpress-mobile/WordPress-iOS/issues?q=is%3Aclosed+is%3Aissue+milestone%3A6.2+label%3A%22%5BType%5D+Enhancement%22\">list of enhancements</a>.</p>\n<p><strong>Bugs, be gone!</strong> We zapped bugs that prevented images from rendering properly and caused backspaces to misbehave.  You can see the full list of bug fixes <a href=\"https://github.com/wordpress-mobile/WordPress-iOS/issues?q=is%3Aclosed+is%3Aissue+milestone%3A6.1+label%3A%22%5BType%5D+Bug%22\">here</a>!</p>\n<h1>Thank You</h1>\n<p>Thanks to all of the contributors who worked on this release:<br />\n<a href=\"https://github.com/aerych\">@aerych</a>, <a href=\"https://github.com/akirk\">@akirk</a>, <a href=\"https://github.com/alexcurylo\">@alexcurylo</a>, <a href=\"https://github.com/astralbodies\">@astralbodies</a>, <a href=\"https://github.com/diegoreymendez\">@diegoreymendez</a>, <a href=\"https://github.com/frosty\">@frosty</a>, <a href=\"https://github.com/jleandroperez\">@jleandroperez</a>, <a href=\"https://github.com/koke\">@koke</a>, <a href=\"https://github.com/kurzee\">@kurzee</a>, <a href=\"https://github.com/kwonye\">@kwonye</a>, <a href=\"https://github.com/maxme\">@maxme</a>, <a href=\"https://github.com/nheagy\">@nheagy</a>, <a href=\"https://github.com/rachelmcr\">@rachelmcr</a>, <a href=\"https://github.com/sendhil\">@sendhil</a>, <a href=\"https://github.com/mattmiklic\">@mattmiklic</a> and <a href=\"https://github.com/SergioEstevao\">@SergioEstevao</a>.</p>\n<p>You can track the development progress for the next update by visiting <a href=\"https://github.com/wordpress-mobile/WordPress-iOS/issues?utf8=✓&q=is%3Aissue+milestone%3A6.3+\" target=\"_blank\">our 6.3 milestone on GitHub</a>. Until next time!</p><img alt=\"\" border=\"0\" src=\"https://pixel.wp.com/b.gif?host=apps.wordpress.com&blog=108068616&post=3416&subd=apps&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 May 2016 06:05:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"diegoreymendez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"WPTavern: In Case You Missed It – Issue 9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=55015&preview_id=55015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://wptavern.com/in-case-you-missed-it-issue-9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8011:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png\" rel=\"attachment wp-att-50955\"><img class=\"size-full wp-image-50955\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png?resize=676%2C292\" alt=\"In Case You Missed It Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/112901923@N07/16153818039\">Night Moves</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc/2.0/\">(license)</a>\n<p>There’s a lot of great WordPress content published in the community but not all of it is featured on the Tavern. This post is an assortment of items related to WordPress that caught my eye but didn’t make it into a full post.</p>\n<h2>Chris Lema Launches Beyond Good</h2>\n<p>Chris Lema has launched a new site called <a href=\"http://beyondgood.com/\">Beyond Good </a>that provides insight, tips, and methodologies for leading employees to become better than good. If it&#8217;s anything like his other sites, it&#8217;s sure to be a hit in the WordPress community.</p>\n<h2>Remote Jobs, a Remote Worker Specific Jobs Board</h2>\n<p>Chris Wallace and the team at Lift have launched <a href=\"https://remotejobs.com/\">Remote Jobs</a>, a jobs board specifically catered to remote workers. According to Wallace, &#8220;The site exists to help others find remote jobs that connect them with their passions in life.&#8221; Check out the site as there&#8217;s already a decent listing of opportunities available for remote workers.</p>\n<h2>Why .Blog is Worth $19M</h2>\n<p>Matt Mullenweg participated in a <a href=\"http://venturebeat.com/2016/05/12/the-creator-of-wordpress-on-why-blog-was-worth-19-million/\">phone interview with VentureBeat</a>. The first question in the interview asks why the .blog domain is worth $19M.</p>\n<blockquote><p>Well, the domain business is actually a really good business because you can sell a domain and people use it and keep it forever. So, if you look at like a Verisign, or people who have TLDs, it’s actually an incredible business.</p>\n<p>We really wanted .blog to be open, and some of the other applications for .blog were closed, including Google — so, let’s say for example, only Blogger could have a .blog domain. And we thought that .blog should be open to everyone, even if they’re not using WordPress.</p>\n<p>I gotta be honest though, it was a stressful auction.</p></blockquote>\n<p>There are other tidbits of information included in the interview that I highly encourage you to read. If I were Google, I&#8217;d be upset as .blog is the perfect complimentary domain for Blogger.</p>\n<h2>Drupal Association Gives Community Member a Lifetime Ban</h2>\n<p>DrupalCon New Orleans took place last week and during the event, several speakers <a href=\"https://www.drupal.org/node/2729687\">experienced online harassment</a> in the form of derogatory racist, homophobic, and misogynistic comments and images from an anonymous Twitter account. Upon further investigation by community members and the Drupal Association technical and event staff, the harassment was tracked to an attendee at the event.</p>\n<blockquote><p>This person was then confronted by members of the Drupal Association staff and the Community Working Group. They were asked to leave the event and informed that they have been banned from attending any future DrupalCons as well as any events produced by the Drupal Association, in accordance with the <a href=\"https://events.drupal.org/neworleans2016/code-conduct\" rel=\"nofollow\">DrupalCon Code of Conduct</a>, which states, &#8216;We do not tolerate harassment of conference participants in any form.&#8217; Shortly after the person left the conference, the account from which the harassing tweets were made was deleted.</p></blockquote>\n<p>This is an excellent example of why Codes of Conduct exist for events. By the way, check out the <a href=\"https://plan.wordcamp.org/code-of-conduct/\">Code of Conduct</a> that&#8217;s in place for every WordCamp. If you experience harassment of any kind at a WordCamp, please tell event staff.</p>\n<h2>Plans Published to Upgrade WordPress Support Forums</h2>\n<p>Jennifer Dodd published a <a href=\"https://make.wordpress.org/meta/2016/05/19/wordpress-org-forums-upgrade/\">detailed plan</a> for migrating the WordPress.org support forums from bbPress 1.x to 2.x. The project is a huge undertaking and involves moving massive amounts of data. If all goes according to plan, the support forums will be on bbPress 2.x by the end of the year. I&#8217;m sure a lot of support forum volunteers are stoked to hear this news.</p>\n<h2>What NOT to Name a WordPress Theme</h2>\n<p>This tweet by Ryan Sullivan gave me a good laugh.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">I\'d strongly consider rebranding. <a href=\"https://t.co/9MeevJTlPq\">pic.twitter.com/9MeevJTlPq</a></p>\n<p>&mdash; Ryan D. Sullivan (@ryandonsullivan) <a href=\"https://twitter.com/ryandonsullivan/status/733120690816065536\">May 19, 2016</a></p></blockquote>\n<p></p>\n<h2>Tom McFarlin on Improving the WordPress Plugin UX</h2>\n<p>Tom McFarlin published a <a href=\"https://tommcfarlin.com/wordpress-plugin-user-experience-2/\">great article</a> that offers ideas on how plugin developers can improve the WordPress plugin user experience. His first suggestion is a key reason I think GravityForms became successful.</p>\n<blockquote><p>Try to make sure that your project tightly integrates with the core WordPress user interface.</p></blockquote>\n<p>When I witnessed GravityForms for the first time in 2009, I loved how it integrated into the WordPress backend as if it were a part of the core software. Fast forward to 2016 and plugins that tie into a service are experimenting with overlay interfaces that replace WordPress&#8217;. The most recent example I recall is WP Forms <a href=\"http://wptavern.com/wpforms-aims-to-be-the-most-beginner-friendly-forms-plugin-for-wordpress\">that I reviewed</a> earlier this year.</p>\n<p>In my review, I specifically noted that the interface the developers used allowed me to focus on creating forms. It doesn&#8217;t seem like it&#8217;s a WordPress core feature and it didn&#8217;t have too. While the advice McFarlin gives is likely accurate for most cases, there are plugins that benefit from having a unique user interface different from WordPress&#8217;.</p>\n<h2>Don&#8217;t Edit Core</h2>\n<p>This comic <a href=\"http://www.commitstrip.com/en/2016/05/17/coder-dilemma-9-the-upgrade/\">created by CommitStrip</a> made me smile.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Coder Dilemma #9 &#8211; The Upgrade<br /> <a href=\"https://t.co/2Tu2l1tgYX\">https://t.co/2Tu2l1tgYX</a> <a href=\"https://t.co/xnMr2VdYWv\">pic.twitter.com/xnMr2VdYWv</a></p>\n<p>&mdash; CommitStrip (@CommitStrip) <a href=\"https://twitter.com/CommitStrip/status/732505464768843776\">May 17, 2016</a></p></blockquote>\n<p></p>\n<h2>Wapuu Tattoo!</h2>\n<p>In what is a traditional part of this series, I end each issue by featuring a Wapuu design. For those who don&#8217;t know, Wapuu is the <a href=\"http://wapuu.jp/2015/12/12/wapuu-origins/\">unofficial mascot</a> of the WordPress project. WordCamp St. Louis 2016, took place last weekend and one of the attendees had a Wapuu tattoo! Wapuu looks good everywhere, including human skin!</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Wapuu has been sighted at <a href=\"https://twitter.com/hashtag/wcstl?src=hash\">#wcstl</a> <a href=\"https://twitter.com/hashtag/wordpress?src=hash\">#wordpress</a> <a href=\"https://twitter.com/hashtag/wapuu?src=hash\">#wapuu</a> <a href=\"https://t.co/4HYlp6GI0S\">pic.twitter.com/4HYlp6GI0S</a></p>\n<p>&mdash; Nile Flores (@blondishnet) <a href=\"https://twitter.com/blondishnet/status/731504592668758017\">May 14, 2016</a></p></blockquote>\n<p></p>\n<p>That&#8217;s it for issue nine. If you recently discovered a cool resource or post related to WordPress, please share it with us in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 May 2016 22:30:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: WordPress Meta Team Publishes Prototypes of The Plugin Directory Redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=55006\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/wordpress-meta-team-publishes-prototypes-of-the-plugin-directory-redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3713:\"<p>In early 2015, the WordPress.org Meta team <a href=\"http://wptavern.com/wordpress-plugin-directory-launches-new-design\">redesigned</a> the <a href=\"https://wordpress.org/plugins/\">WordPress plugin directory</a> and added a number of new features. In an effort to iterate on the page&#8217;s layout, the Meta Team has <a href=\"https://make.wordpress.org/meta/2016/05/19/plugin-directory-prototypes/\">published prototypes</a> of a new design for the <a href=\"http://codepen.io/mapk/full/jqxqbo/\">plugin directory&#8217;s home</a> and <a href=\"http://codepen.io/mapk/full/KzGQKv/\">search results pages</a>.</p>\n<p>The prototypes are inspired by <a href=\"https://get.wp.com/\">Get WordPress</a>, a landing page that provides key information about the WordPress project at a glance.</p>\n<p>There are a few things to keep in mind while looking at these prototypes. The first is that plugin information displayed on the page is inaccurate. Second, the Pro and Light classifications are for design purposes only. Third, links at the bottom will point to their corresponding pages.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/PluginDirectoryMockup1.png\"><img class=\"size-full wp-image-55007\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/PluginDirectoryMockup1.png?resize=1025%2C2753\" alt=\"WordPress Plugin Directory Homepage Protoype\" /></a>WordPress Plugin Directory Homepage Protoype\n<p>Unlike the current design, the prototype displays far less information. Authors, Last Updated, Compatibility, and Active Installs are absent from the homepage view. Initial feedback <a href=\"https://make.wordpress.org/meta/2016/05/19/plugin-directory-prototypes/#comment-8151\">highlights the concern</a> that too much information has been stripped away.</p>\n<p>In response to a comment on the announcement post, Samuel Sidler, <span class=\"st\">Apollo Team Lead at Automattic and contributor to the Meta team</span>, <a href=\"https://make.wordpress.org/meta/2016/05/19/plugin-directory-prototypes/#comment-8154\">explains</a> why he doesn&#8217;t think the information is useful to users.</p>\n<blockquote><p>Author, as you said, is only really useful for insiders. The latter two, meanwhile, are already taken into account in the search results. If a plugin doesn’t have a recent compatible version, it will move down the list. If it’s too old, it won’t get shown at all (which is the case today).</p>\n<p>Active installs is more interesting, but we account for it weighting search results as-is. I actually find it refreshing to <em>not</em> show the active installs as it allows for less-popular plugins to get more downloads. Users will be less likely to click the popular plugins (outside of familiar names) and more likely to find the plugin they actually need.</p></blockquote>\n<p>Another commenter suggests <a href=\"https://profiles.wordpress.org/awakensolutions/\">creating a simple/advanced view. </a>By default, the page could display a simplistic design while giving power users an option for more details.</p>\n<p>&#8220;Just like <a href=\"https://wordpress.org/about/philosophy/\" rel=\"nofollow\">WordPress core</a>, we strive to design for the majority and build features for the 80%,&#8221; Sidler said in response to the comment. &#8220;An &#8216;advanced&#8217; view doesn’t meet that requirement, in my eyes.&#8221;</p>\n<p>The Meta team is iterating quickly and will soon publish a prototype of the plugin details page. If you have feedback on the plugin homepage and search result prototypes, please leave a comment on <a href=\"https://make.wordpress.org/meta/2016/05/19/plugin-directory-prototypes/\">the announcement post</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 May 2016 20:19:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: WPWeekly Episode 235 – Interview with James Giroux Envato’s WordPress Evangelist\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=55000&preview_id=55000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"http://wptavern.com/wpweekly-episode-235-interview-with-james-giroux-envatos-wordpress-evangelist\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1298:\"<p>In this episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"https://jamesgiroux.ca/\">James Giroux</a>, Envato&#8217;s WordPress evangelist. We discuss a number of topics including what he&#8217;s accomplished since taking over the position in January, the item support policy change, and author driven pricing.</p>\n<p>We also find out what his favorite part of the job is and what he enjoys most about his role at Envato. Last but not least, we discover what the company is doing to shorten the length of time it takes to get through the review queue.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, June 1st 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #235:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 May 2016 19:18:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: BuddyPress Launches Style Modules Trial Initiative\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54954\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://wptavern.com/buddypress-launches-style-modules-trial-initiative\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3960:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/customize-posts.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/customize-posts.jpg?resize=1024%2C583\" alt=\"photo credit: Paintbrush - (license)\" class=\"size-full wp-image-54351\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/93249705@N03/13067171403\">Paintbrush</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nd/2.0/\">(license)</a>\n<p>BuddyPress core developer <a href=\"https://twitter.com/hnla\" target=\"_blank\">Hugo Ashmore</a> announced a new trial initiative this week that aims to create a library of CSS and JavaScript snippets to help users customize their communities. The <a href=\"https://bpdevel.wordpress.com/2016/05/11/buddypress-style-modules/\" target=\"_blank\">Style Modules</a> project will aggregate community-submitted code that enhances BuddyPress components in a plug-and-play manner.</p>\n<p>Developers who want to contribute to the project can submit their modules by creating a ticket on <a href=\"https://buddypress.trac.wordpress.org/newticket\" target=\"_blank\">BP trac</a> and attaching a zip file that includes the CSS/JS files, a readme.md, and a screenshot.</p>\n<p>Users who want to add a module will need to create a /style-modules/ directory and then unzip the module inside it. The next step requires the user to copy functions from the module&#8217;s readme file to their theme&#8217;s functions.php file, a step which provides a significant hurdle for a non-technical BuddyPress community manager.</p>\n<p>&#8220;Initially this is a trial to see whether we get sufficient interest in the concept to continue and develop further, perhaps enhancing the loading process with enqueueing of files based on directory scanning and loading of files as an array but run from the core theme compat class, removing the need for users to copy the loading functions to their functions file,&#8221; Ashmore said.</p>\n<p>The project&#8217;s GitHub repository includes <a href=\"https://github.com/buddypress/style-modules/wiki/Style-Modules-Listings\">an example module</a> that re-styles the members list into a grid layout. Other example ideas Ashmore suggested include a new look for profile entries, a different presentation for the activity posting form, or something as simple as changing the font size for the activity stream.</p>\n<p>The experimental initiative will test the waters to see if the BuddyPress community will chip in to provide enough modules to make this a real library. The support policy stated in the proposal doesn&#8217;t offer much incentive for module authors to submit their work:</p>\n<blockquote><p>Provision of modules and use of them is entirely the discretion of the authors and users, while BP will run some basic checks on the module BP does not guarantee that the modules will work in all given situations or installs, or accept any liability in their use. Support for a module remains the responsibility of the author to ensure the continued effectiveness of the module with updates to themes, WP or BP.</p></blockquote>\n<p>Historically, BuddyPress has struggled to present itself as an easily customizable solution for communities. <a href=\"http://codex.buddypress.org/themes/theme-compatibility-1-7/a-quick-look-at-1-7-theme-compatibility/\" target=\"_blank\">Theme compatibility</a>, introduced in April 2013, made it easier to use BP with any theme, but unless you purchase a theme specifically designed for the plugin, its default output is rather generic and in need of heavy styling.</p>\n<p>The <a href=\"https://bpdevel.wordpress.com/2016/05/11/buddypress-style-modules/\" target=\"_blank\">BuddyPress Style Modules</a> concept is an attempt to make it easier for community managers to enhance BP components with different looks, but the project will need to provide a compelling reason for developers to contribute modules and continue to maintain them.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 May 2016 02:34:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: The .blog Domain Extension Is Now Open to Registrars\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54971\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"http://wptavern.com/the-blog-domain-extension-is-now-open-to-registrars\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2083:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/blogging.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/blogging.jpg?resize=960%2C521\" alt=\"photo credit: Luis Llerena\" class=\"size-full wp-image-54799\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/3ZHG0XOIT6\">Luis Llerena</a>\n<p>Today marks a moment in internet history, as the very first .blog domain is now operational on WordPress.com. Knock Knock, WHOIS There, a subsidiary of Automattic, launched <a href=\"https://nic.blog/\" target=\"_blank\">Nic.blog</a> today to begin getting registrars to sign up to sell the new TLD.</p>\n<p>Automattic <a href=\"http://wptavern.com/automattic-to-oversee-the-sale-and-registration-of-top-level-blog-domains\" target=\"_blank\">won the rights to oversee the sale and registration of the .blog domain</a> in 2015 via a bidding process that is estimated to have closed around $20 million. The domain extension is so new that Twitter doesn&#8217;t yet support it as a valid link, but Automattic expects to activate 250,000 new names in 2016.</p>\n<p>According to the new nic.blog information site, registrars that sign up to sell .blog domains will be able to participate in an incentive partnership model that rewards a higher volume of sales:</p>\n<blockquote><p>Pricing will be in the standard range for new gTLDs, with premium names available in several tiers. High margins for registrars will be guaranteed by an incentive model, rewarding sales above a certain baseline. Final terms will be published in the coming weeks.</p></blockquote>\n<p>Automattic is opening up the .blog TLD to registrars around the world and companies can sign up on nic.blog to learn more about the requirements. Individuals who are interested in purchasing a .blog domain should review the tentative <a href=\"https://nic.blog/launch-plan/\" target=\"_blank\">launch plan</a> published today. Registration will be open to trademark owners during the Sunrise period starting in August 2016, followed by a Landrush period in October.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 May 2016 23:26:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: After Eight Years, Thematic Theme’s Lead Developers Discontinue the Project\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54967\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/after-eight-years-thematic-themes-lead-developers-discontinue-the-project\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3812:\"<p>Gene Robinson, lead developer of the Thematic WordPress theme, has <a href=\"http://thematictheme.com/2016/05/15/thematic-retrospective/\">announced</a> that the project will no longer be developed. Thematic <a href=\"https://wordpress.org/themes/thematic/\">was last updated</a> in 2013 and is actively installed on more than 4K sites. Users are advised to migrate to a different theme as updates will no longer be released. As WordPress core evolves, sites using Thematic may develop incompatibilities.</p>\n<h2>Continuing The Legacy with a Different Name</h2>\n<p>Although development on Thematic is discontinuing, Robinson has forked the project and renamed it to <a href=\"http://d.eciduo.us\">Deciduous. </a>The project picks up where Thematic leaves off. Those interested in continuing development can <a href=\"https://github.com/emhr/Deciduous\">follow it on GitHub</a> where pull requests are welcomed. Robinson is also seeking links to other projects that are derivative of Thematic.</p>\n<h2>Where to Get Support for Thematic</h2>\n<p>Users who need support are advised to post on the <a href=\"https://wordpress.org/support/theme/thematic\">WordPress.org support forums</a> for the Thematic theme, &#8220;The support forums on the Thematic website are shutting down due to the lack of community involvement, moderation, and developer feedback,&#8221; Robinson said. &#8220;Hopefully the greater WordPress support community will be able to help you find a resolution.&#8221;</p>\n<h2>A Look Back</h2>\n<p>The years 2008-2009 is an interesting time frame in WordPress&#8217; history. A number of commercial theme and plugin companies, WordPress-centric sites, and projects were launched. Among these was the <a href=\"https://web.archive.org/web/20080611165821/http://themeshaper.com/thematic-for-wordpress/\">Thematic theme</a> by Ian Stewart, theme Wrangler for Automattic. Thematic was more than just a theme, it was an opportunity for Stewart to learn how WordPress&#8217; theme system works.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/ThematicThemePreview.png\"><img class=\"size-full wp-image-54981\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/ThematicThemePreview.png?resize=951%2C740\" alt=\"Thematic Theme Preview from WordPress.org\" /></a>Preview of Thematic from WordPress.org\n<p>He regularly shared his knowledge with the community through <a href=\"https://themeshaper.com/\">ThemeShaper.com</a>, a site now owned by Automattic that features contributions from other members of the theme team. It was the wild west of theme development in 2008 and any person who regularly shared theme development techniques became an influential member of the community.</p>\n<p>Two years after launching Thematic, Stewart <a href=\"https://themeshaper.com/2010/03/04/ian-stewart-joined-automattic/\">joined Automattic</a> as a theme wrangler.</p>\n<blockquote><p>What can I say besides awesome, awesome, awesome? The enormous opportunity for learning and improvement; all the super-talented, friendly people; the chance to work on so many really, really cool projects—it’s almost unbelievable. This is a dream job for me.</p></blockquote>\n<p>The hiring allowed him to make available all of his commercial child themes built on the Thematic framework available free of charge to the community.</p>\n<h2>Did You Learn From Thematic?</h2>\n<p>It&#8217;s bittersweet and slightly nostalgic to see the theme come to an end. When I launched the Tavern in 2009, I regularly linked to tutorials and articles published by Stewart. I&#8217;m almost certain Thematic and its creator helped out a number of budding theme developers between 2008-2011. Let us know in the comments if you used Thematic for any projects or what you learned from its code.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 May 2016 20:45:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Post Status: WordPress as a Headless CMS — Draft podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=24518\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://poststatus.com/wordpress-headless-cms-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2870:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Joe Hoyle &#8212; the CTO of Human Made &#8212; and Brian Krogsgard.</p>\n<p><span>Joe and Brian discuss WordPress as a Headless CMS. They talk about what a Headless CMS is, WordPress’s strengths and weaknesses as a Headless CMS, popular frameworks to utilize, and offer up example websites to check out.</span></p>\n<p><a href=\"https://audio.simplecast.com/37861.mp3\">https://audio.simplecast.com/37861.mp3</a><br />\n<a href=\"http://audio.simplecast.com/37861.mp3\">Direct Download</a></p>\n<h3>Examples</h3>\n<ul>\n<li><a href=\"https://www.guggenheim.org/\">The Guggenheim</a></li>\n<li><a href=\"https://adayofrest.hm/boston-2016/\">A Day of Rest Boston</a></li>\n<li><a href=\"https://ustwo.com/\">ustwo</a></li>\n<li><a href=\"http://skaled.com/\">Skaled</a></li>\n<li><a href=\"http://tri.be/\">Modern Tribe</a></li>\n</ul>\n<h3>Links</h3>\n<ul>\n<li><a href=\"https://angularjs.org/\">Angular</a></li>\n<li><a href=\"https://facebook.github.io/react/\">React</a></li>\n<li><a href=\"http://blog.scalac.io/2016/02/16/react-vs-angular-2.html\">React vs Angular 2</a></li>\n<li><a href=\"https://getmoxied.net/lean/\">Lean, an Agular for WordPress framework</a></li>\n<li><a href=\"https://pantheon.io/decoupled-cms\">Decoupled CMS</a></li>\n<li><a href=\"https://css-tricks.com/what-is-a-headless-cms/\">What is a Headless CMS?</a></li>\n<li><a href=\"http://petya.in/we-need-to-talk-about-the-rest-api-the-non-developer-guide-to-the-future-of-wordpress/\">We Need to Talk about the REST API</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/05/16/rest-api-authentication-broker/\">Introducing the REST API Authentication Broker</a></li>\n<li><a href=\"https://hmn.md/2016/01/14/introducing-our-wordpress-rest-api-white-paper/\">Human Made&#8217;s REST API White Paper</a></li>\n</ul>\n<h3>Sponsor</h3>\n<p><span>Today’s show is sponsored by </span><a href=\"http://optinmonster.com\"><span>OptinMonster</span></a><span>. OptinMonster allows you to convert visitors into subscribers. You can easily create &amp; A/B test beautiful lead capture forms without a developer. They recently released </span><a href=\"http://optinmonster.com/introducing-optinmonster-3-0-taking-your-conversion-optimization-to-the-next-level/\"><span>OptinMonster 3.0</span></a><span>, with an all new builder interface and other great features.</span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 May 2016 17:47:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Katie Richards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: Take Granular Control of WordPress’ Update System with Easy Updates Manager\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54952\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"http://wptavern.com/take-granular-control-of-wordpress-update-system-with-easy-updates-manager\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3933:\"<p>When <a href=\"https://wordpress.org/news/2013/10/basie/\">WordPress 3.7 &#8220;Basie&#8221;</a> was released in 2013, it brought automatic updates to the masses. By default, WordPress automatically updates to point releases. Using <a href=\"https://codex.wordpress.org/Configuring_Automatic_Background_Updates\">additional constants</a> within wp-config.php, you can configure WordPress to automatically update themes, plugins, and major releases.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerFeaturedImage.png\"><img class=\"aligncenter size-full wp-image-54958\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerFeaturedImage.png?resize=650%2C207\" alt=\"Easy Update Manager Featured Image\" /></a></p>\n<p>If you want granular control over the WordPress update system without touching code, check out <a href=\"https://wordpress.org/plugins/stops-core-theme-and-plugin-updates/\">Easy Updates Manager</a>. Easy Updates Manager is a free plugin that&#8217;s active on more than 70k sites. It&#8217;s maintained by <a href=\"https://profiles.wordpress.org/kidsguide/\">Matthew</a>, <a href=\"https://profiles.wordpress.org/ronalfy/\">Ronald Huereca</a>, <a href=\"https://profiles.wordpress.org/roary86/\">Roary Tubbs</a>, and <a href=\"https://profiles.wordpress.org/bigwing/\">BigWing Interactive</a>.</p>\n<h2>Countless Number of Configurations Available</h2>\n<p>Once activated, you&#8217;ll find the options page by browsing to Dashboard &gt; Update Options. There are two different interfaces for configuring updates. The first includes a number of toggle switches that disable/enable updates. The second is a traditional screen with radial buttons.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerDashboard.png\"><img class=\"size-full wp-image-54959\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerDashboard.png?resize=1025%2C432\" alt=\"Easy Update Manager Dashboard\" /></a>Easy Updates Manager Dashboard\n<p>Traditional settings page for Easy Updates Manager.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerGeneralSettings.png\"><img class=\"size-full wp-image-54960\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerGeneralSettings.png?resize=566%2C480\" alt=\"Easy Update Manager General Settings\" /></a>Easy Updates Manager General Settings\n<p>One of the highlights of Easy Updates Manager is the ability to enable automatic updates for individual themes and plugins. It&#8217;s a convenient way to update themes and plugins that rarely cause issues. There&#8217;s also a built-in logging feature that when enabled creates a new table in the database. It logs the username, update type, version, action, status, and date.</p>\n<p>Logging is listed as a beta feature and should be used at your own risk. It also may not work with all commercial themes and plugins. Here&#8217;s what the log looks like after I updated three plugins.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerLogs.png\"><img class=\"size-full wp-image-54961\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerLogs.png?resize=1025%2C350\" alt=\"Easy Update Management Log\" /></a>Easy Updates Management Log\n<p>Easy Updates Manager also includes the ability to exclude users from manipulating the plugin&#8217;s settings. The plugin contains additional features that I encourage you to explore by using it on a test site.</p>\n<p>Thanks to the number of options available, users have a countless number of update configurations to choose from. I tested the plugin on WordPress 4.6 alpha and it works as expected. You can <a href=\"https://wordpress.org/plugins/stops-core-theme-and-plugin-updates/\">download it for free</a> from the WordPress plugin directory.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 May 2016 07:17:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: WordPress 4.6 Improves the Accessibility of the Tag and Category Management Pages\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54910\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://wptavern.com/wordpress-4-6-improves-the-accessibility-of-the-tag-and-category-management-pages\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2775:\"<p>Among the improvements coming in WordPress 4.6 are <a href=\"https://make.wordpress.org/core/2016/05/16/categories-and-tags-screens-changes/\">accessibility enhancements</a> to the Category and Tag management pages. The flow of each page has been changed so that the visual order of elements match the tab order. This allows those who navigate with keyboards to access the Add New Tag or Add New Category area first.</p>\n<p>Andrea Fercia, WordPress core committer and a member of the accessibility team, explains why the changes matter, &#8220;For accessibility, the visual order should always match the tab order. The main functionality in a page should just be the first thing in the source markup and other parts of the user interface should never be &#8216;skipped&#8217;.&#8221;</p>\n<p>The following image shows the tab order of elements on the Tag management screen in WordPress 4.5. In order to reach the Add New Tag section, you need to tab through a number of checkboxes, each tag in the tag cloud, and various quick edit links. This is a time-consuming and frustrating process.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/WordPress45TagManagementPage.png\"><img class=\"size-full wp-image-54944\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/WordPress45TagManagementPage.png?resize=1025%2C806\" alt=\"WordPress 4.5 Tag Management Element Order\" /></a>WordPress 4.5 Tag Management Element Order\n<p>In WordPress 4.6, the Add New Tag section is the first visual element as well as the first section accessed when pressing the tab key.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/WordPress46TagManagementScreen.png\"><img class=\"size-full wp-image-54945\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/WordPress46TagManagementScreen.png?resize=1025%2C792\" alt=\"WordPress 4.6 Tag Management Screen\" /></a>WordPress 4.6 Tag Management Screen\n<p>The new flow is more logical and provides consistency between the tag and category management screens, &#8220;From an accessibility point of view, the content structure and organization will be easier to understand and navigate,&#8221; Fercia said.</p>\n<p>WordPress theme and plugin authors who have added custom functionality to these screens are advised to double-check their code against the bleeding edge version of WordPress 4.6. There&#8217;s also an <a href=\"https://core.trac.wordpress.org/ticket/35664\">in-depth ticket</a> where developers and users can see how the team reached a consensus to implement the changes. If you have any questions or concerns please leave a comment on the <a href=\"https://make.wordpress.org/core/2016/05/16/categories-and-tags-screens-changes/\">announcement post</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 May 2016 19:30:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: New Plugin Uses BuddyPress Email API to Send bbPress Forum Emails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54863\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://wptavern.com/new-plugin-uses-buddypress-email-api-to-send-bbpress-forum-emails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3011:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/09/buddypress-bbpress.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/09/buddypress-bbpress.jpg?resize=1025%2C493\" alt=\"buddypress-bbpress\" class=\"aligncenter size-full wp-image-30982\" /></a></p>\n<p><a href=\"http://wptavern.com/buddypress-2-5-0-released-features-customizable-emails-and-support-for-emoji\" target=\"_blank\">BuddyPress 2.5</a>, released in March, introduced customizable emails via a new <a href=\"http://wptavern.com/buddypress-2-5-will-add-customizable-emails-via-a-new-bp-email-api\" target=\"_blank\">BP Email API</a>. This new feature allows community managers to easily edit BuddyPress-generated emails in the admin and make design changes in the customizer.</p>\n<p>It didn&#8217;t take long for developers to think of bringing this same customizability to bbPress emails. <a href=\"https://profiles.wordpress.org/thebrandonallen/\" target=\"_blank\">Brandon Allen</a> has just released <a href=\"https://wordpress.org/plugins/bp-emails-for-bbp/\" target=\"_blank\">BP Emails for BBP</a>, a plugin that sends forum and topic subscription emails using the new BP Email API.</p>\n<p>Once installed, administrators will find templates for new forum topics and topic replies under the same Emails menu item with the 16 customizable BuddyPress core emails.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/buddypress-bbpress-emails.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/buddypress-bbpress-emails.png?resize=1025%2C305\" alt=\"buddypress-bbpress-emails\" class=\"aligncenter size-full wp-image-54878\" /></a></p>\n<p>Allen noted that the plugin sends emails differently than bbPress, which puts every subscriber email in the BCC field and sends one email. Instead, it sends a separate email to each subscriber, which Allen said may improve deliverability given that some email providers look unfavorably on emails with large BCC fields.</p>\n<p>I tested the plugin and found that it works as advertised for customizing and sending bbPress emails. There are no settings to configure. It simply adds the same functionality that users now expect from BuddyPress core emails with all the same customization options.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/bbpress-subscription-email.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/bbpress-subscription-email.png?resize=1025%2C500\" alt=\"bbpress-subscription-email\" class=\"aligncenter size-full wp-image-54929\" /></a></p>\n<p><a href=\"https://wordpress.org/plugins/bp-emails-for-bbp/\" target=\"_blank\">BP Emails for BBP</a> is available on WordPress.org. It does not work with bbPress alone but requires both bbPress 2.5+ and BuddyPress 2.5+ to be active. With the help of this plugin, a community manager can brand all the email communications generated by the site so that the design and wording is consistent across both plugins.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 May 2016 05:32:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: BuddyPress 2.6 to Introduce New API for Navigation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54803\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://wptavern.com/buddypress-2-6-to-introduce-new-api-for-navigation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2401:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/09/buddypress-logo-blue.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/09/buddypress-logo-blue.png?resize=839%2C398\" alt=\"buddypress-logo-blue\" class=\"aligncenter size-full wp-image-30655\" /></a></p>\n<p>In an exceptionally well-documented <a href=\"https://buddypress.trac.wordpress.org/changeset/10745/\" target=\"_blank\">commit message</a>, BuddyPress lead developer Boone Gorges introduced a new API to manage single item navigation, thanks to contributions from core developers Mathieu Viet and Raymond Hoh. Gorges summarized the changes to how BuddyPress will handle navigation in the upcoming 2.6 release:</p>\n<blockquote><p>The new BP_Core_Nav overhauls the way that BuddyPress registers, stores, and renders navigation items. Navigations are now component-specific, eliminating the potential for confusion and conflict between navigation items with similar names in different components, and opening the possibility of generating navs for separate objects of the same type on a single pageload.</p></blockquote>\n<p>The previous navigation system used bp_nav and bp_options_nav, global properties that managed nav and subnav across all of BuddyPress&#8217; components. Developers had a difficult time extending navigation and sometimes ended up stepping on each other&#8217;s toes when adding similar navigation items.</p>\n<p>&#8220;The new system eliminates most of these problems, by removing direct access to the underlying navigation data, while providing a full-fledged API for accessing and modifying that data,&#8221; Gorges said.</p>\n<p>Although the new API ensures backward compatibility with the legacy bp_nav and bp_options_nav, plugin developers whose extensions depend on these methods will want to update their code. With the exception of certain configurations running PHP 5.2.x, most plugins should work the same as before.</p>\n<p>However, Gorges&#8217; <a href=\"https://buddypress.trac.wordpress.org/changeset/10745/\" target=\"_blank\">commit message</a> details a handful of small ways that the new API may break backward compatibility in a few rare instances. BuddyPress plugin developers will want to review these ahead of the upcoming 2.6 release. Beta 1 is just one week away from release on May 25 and the official release is targeted for June 15.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 May 2016 05:06:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: Wes Bos Launches Free React.js + Redux Online Course\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54903\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://wptavern.com/wes-bos-launches-free-react-js-redux-online-course\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3193:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/react-redux-course.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/react-redux-course.png?resize=1025%2C465\" alt=\"react-redux-course\" class=\"aligncenter size-full wp-image-54916\" /></a></p>\n<p><a href=\"http://wesbos.com/\" target=\"_blank\">Wes Bos</a>, a developer and educator known for his high quality video tutorials, has just launched a free online course for building JavaScript apps with <a href=\"https://facebook.github.io/react/\" target=\"_blank\">React.js</a> and <a href=\"http://redux.js.org/\" target=\"_blank\">Redux</a>. The 2.5 hour <a href=\"https://learnredux.com/\" target=\"_blank\">Learn Redux</a> course includes 20 videos that guide developers through building an example &#8216;Reduxstagram&#8217; app to present the core ideas behind Redux.</p>\n<p>To get the most out of Learn Redux, students should have a decent foundation of React and ES6. Bos recommends those who are not comfortable with React to start with his <a href=\"https://reactforbeginners.com/\" target=\"_blank\">React for Beginners</a> course.</p>\n<p>After you sign up, you&#8217;ll receive an email with a link to the starter files and access to the videos. The example app uses Webpack to bundle ES6 modules into a single JavaScript file, so the course begins with a video on using NPM and Webpack to set up a local development environment. Learn Redux includes:</p>\n<ul>\n<li>Access to all 20 videos</li>\n<li>All starter files</li>\n<li>Webpack Build Templates</li>\n<li>Stepped and finished solutions</li>\n</ul>\n<p>Bos spent more than 100 hours producing this series in partnership with <a href=\"https://getsentry.com/welcome/\" target=\"_blank\">Sentry</a> as a sponsor. Anyone who signs up receives a $50 Sentry credit.</p>\n<p>After Calypso was announced, Bos, who describes himself as &#8220;a huge WordPress fan,&#8221; wrote a <a href=\"http://wesbos.com/wordpress-calypso-react/\" target=\"_blank\">post</a> dispelling rumors that WordPress was ditching PHP and being rewritten in Node.js. He also urged WordPress developers to learn JavaScript.</p>\n<p>&#8220;This is thunder in the distance as to what is to come in WordPress,&#8221; Bos said. &#8220;Much of the theme writing I do is already in JavaScript – I often use WordPress as just an API to get data out of, and then use frameworks like Angular, React, Google Maps or jQuery to display that data. I’m not building an entire website in a JavaScript framework, but much of the interactive view layer of these sites is moving into JavaScript frameworks.&#8221;</p>\n<p>If you want to be ready to dive into the next generation of WordPress site and application development with knowledge of one of the most popular JS frameworks, the free <a href=\"https://learnredux.com/\" target=\"_blank\">Learn Redux</a> course offers all the tools necessary for getting started with React.js, Redux, and React Router.</p>\n<p>&#8220;Our trusty PHP template files aren’t going anywhere anytime soon, but I’ll bet you dollars to donuts you’ll be writing a lot more JavaScript in your WordPress sites in the years to come,&#8221; Bos said.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2016 21:50:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"WPTavern: Daniel Bachhuber Discusses WP-CLI, the WP REST API, and the Challenges of Contributing to Open Source on Roots Radio Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:142:\"http://wptavern.com/daniel-bachhuber-discusses-wp-cli-the-wp-rest-api-and-the-challenges-of-contributing-to-open-source-on-roots-radio-podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7828:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/daniel-bachhuber.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/daniel-bachhuber.jpg?resize=300%2C300\" alt=\"daniel-bachhuber\" class=\"alignright size-medium wp-image-54898\" /></a><a href=\"https://danielbachhuber.com/\" target=\"_blank\">Daniel Bachhuber</a>, maintainer of the <a href=\"http://wp-cli.org/\" target=\"_blank\">WP-CLI</a> project and a contributing developer to the <a href=\"http://v2.wp-api.org/\" target=\"_blank\">WP REST API</a>, joined Chris Carr and Austin Pray on a recent episode of the <a href=\"https://roots.io/podcast/ep13/\" target=\"_blank\">Roots Radio podcast</a>. Bachhuber discussed his recent experience crowdfunding his work on &#8220;<a href=\"https://wp-cli.org/restful/\" target=\"_blank\">A More RESTful WP-CLI</a>&#8221; as well as the challenges he&#8217;s encountered as a contributor to various open source projects over the years.</p>\n<p>In the first part of the episode, Bachhuber shared how he spent the 283 hours of time that the WordPress community funded to advance the WP-CLI and WP REST API projects. The funding gave him the opportunity to dedicate time split between the two projects. Bachhuber put in approximately 95 hours towards the REST API in January and February but the bulk of the hours went towards making WP-CLI more friendly for developers who work with the REST API.</p>\n<p>&#8220;WordPress developers are going to be putting a lot of time now towards writing REST endpoints that expose their functionality to the world, and it would be really nice if WP-CLI interoperated nicely with that and allowed you to use that functionality at the command line without having to separately write your own WP-CLI commands,&#8221; Bachhuber said.</p>\n<p>He discussed the challenge of scoping out this broad goal and what he learned about crowdfunding during the process.</p>\n<p>&#8220;The RESTful WP-CLI kickstarter project was intentionally ambitious, because I&#8217;m a guy who has big ideas and likes to do big things,&#8221; Bachhuber said. &#8220;There are some things I feel really happy that I&#8217;ve been able to ship and produce so far, and there are other features that, for one reason or another, I haven&#8217;t quite been able to execute  yet and that&#8217;s a bit frustrating.</p>\n<p>&#8220;It&#8217;s a whole different ball game trying to manage the expectations of your Kickstarter backers than it is a single client. I&#8217;ve got 107 clients that I have to make happy,&#8221; he said.</p>\n<p>Nevertheless, Bachhuber said he was able to get the issue backlog for WP-CLI down to less than 60 issues and the dedicated time has allowed him to resolve old issues that have &#8220;languished since the dawn of time.&#8221;</p>\n<p>As part of the rewards offered for contributors to the crowdfunding campaign, Bachhuber offered his time consulting with individuals and organizations, which he found to be easier than traditional physical swag rewards.</p>\n<p>&#8220;I&#8217;m really glad that I chose [consulting] over having to give out physical swag, because it&#8217;s very difficult to procure and ship to everyone, particularly when you have international backers,&#8221; he said. &#8220;Even though I&#8217;ve spent a lot of my time fulfilling the rewards and talking with people and having calls with them and meeting up with them in person, it&#8217;s a much easier effort to manage than sending 100 coffee mugs across the world.&#8221;</p>\n<p>When asked if he&#8217;d do it again, Bachhuber said yes but emphasized that spending this much time on an open source project only works if you keep a healthy balance with other aspects of life.</p>\n<p>&#8220;I think it&#8217;s really important that if you&#8217;re contributing to open source projects on a regular basis or even maintaining them, that you balance your time between that and other things,&#8221; he said. &#8220;It&#8217;s really easy to get burned out on said open source project if you spend 100% of your time on it for a whole month or six months.</p>\n<p>&#8220;I was pretty intentional to say that the money I was raising was going to cover my involvement with the project for six months, a certain number of hours, and that it was going to be a part-time thing. That was a really healthy way to approach it. I think I would have gotten burned out if I had just tried to dive into it, crank it out, and move on to the next thing,&#8221; Bachhuber said.</p>\n<h3>The Emotional Challenges of Working on Open Source Projects</h3>\n<p>During the course of the interview Bachhuber was asked to share his feelings on what he referred to as &#8220;the kerfuffle with the REST API&#8221; that happened in February. The REST API team had written a merge proposal in September 2015 that recommended merging the API in two parts &#8211; the infrastructure in 4.4 and the posts, comments, terms, and users endpoints in 4.5 or 4.6. After partially executing on that proposal, the team held a status chat to discuss the plan moving forward.</p>\n<p>Bachhuber said that the discussion became &#8220;a very emotionally fraught event&#8221; after Matt Mullenweg said the project needed feature parity with the WordPress admin before any of the endpoints could be considered for merge. After putting hundreds of hours into the project alongside a handful of dedicated contributors who were already spread thin, he found this new requirement was a difficult pill to swallow.</p>\n<p>&#8220;For better or for worse, as a maintainer or even a participant of an open source project, you have to have a thick skin and realize that all the time the decisions that are made are not about you &#8211; they are about the project,&#8221; Bachhuber said. &#8220;Even if you are personally offended by the decision, it doesn&#8217;t matter because it isn&#8217;t about you. It&#8217;s really difficult to deal with emotionally.&#8221;</p>\n<p>Bachhuber&#8217;s years of contributing to and maintaing open source projects has taught him a few things about managing stress and conflict that <a href=\"https://2016.europe.wordcamp.org/session/my-condolences-youre-now-the-maintainer-of-a-popular-open-source-project/\" target=\"_blank\">he plans to share at WordCamp Europe</a> in a talk titled, &#8220;My condolences, You&#8217;re now the maintainer of a popular OS project.&#8221;</p>\n<p>&#8220;I find a lot of joy in maintaining open source projects,&#8221; Bachhuber said. &#8220;I also have to actively work to address the emotional side of the equation to make sure I&#8217;m in a healthy space to continue maintaining the project and the project is not affecting me personally. It&#8217;s taken me years to come to a point where I&#8217;m comfortable with that.&#8221;</p>\n<p>In the case of the WP REST API, Bachhuber has come to a place where he can compartmentalize his emotional reactions and responses to the differing opinions.</p>\n<p>&#8220;I&#8217;ve come to a point now where I care but I don&#8217;t care,&#8221; he said. &#8220;I care in the sense that I&#8217;d still love to see those endpoints go into core and see the fruits of our labors realized. I don&#8217;t care because I&#8217;m not emotionally attached to that happening on any particular time frame. I honestly would rather it happen when it&#8217;s ready to happen over prematurely, and I realize I might not be the best qualified person to make that decision.&#8221;</p>\n<p>In the remainder of the episode, Bachhuber and Carr discuss React, Redux, Karma, Enzyme, and other tools for testing and developing with the REST API. Check out the recording of the episode on <a href=\"https://roots.io/podcast/ep13/\" target=\"_blank\">Roots Radio</a> for more details about Bachhuber&#8217;s work on WP-CLI and his crowdfunding experience.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2016 06:03:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"WPTavern: The WordPress.org Recommended Hosting Page is Revamped, Features Flywheel for the First Time\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54822\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"http://wptavern.com/the-wordpress-org-recommended-hosting-page-is-revamped-features-flywheel-for-the-first-time\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8235:\"<p>DreamHost, Flywheel, and SiteGround have joined Bluehost on WordPress.org&#8217;s new <a href=\"https://wordpress.org/hosting/\">recommended hosting</a> page. In mid 2015, Matt Mullenweg, co-founder of the open source WordPress project, <a href=\"http://wptavern.com/the-recommended-hosting-page-on-wordpress-org-starts-over-from-scratch\">announced</a> the page would be revamped. To have a chance at being listed webhosting companies needed to fill out a 40-question survey.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/RecommendedHostsPage.png\"><img class=\"size-full wp-image-54844\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/RecommendedHostsPage.png?resize=790%2C642\" alt=\"2016 Recommended Hosts Page\" /></a>2016 Recommended Hosts Page\n<p>This is Flywheel&#8217;s first time on the page. <a href=\"https://getflywheel.com/\">Flywheel</a>, launched in 2013, is a managed WordPress hosting company with an emphasis towards designers and agencies. I asked Dusty Davidson, c<span class=\"team__role\">o-Founder and CEO of Flywheel</span>, what it means to be included on the page. &#8220;We&#8217;re obviously excited to be included, and think it really reflects on the work we&#8217;ve done to create a great experience for WordPress users,&#8221; he<span class=\"team__role\"> said. </span></p>\n<p>The recommended webhosting page on WordPress.org is incredibly lucrative. Based on conversations I&#8217;ve had with employees of hosts listed, it can generate millions of dollars in revenue. I asked Davidson what impact this will have on his company, &#8220;<span class=\"team__role\">I&#8217;m sure it will undoubtedly send a good deal of traffic, but honestly we&#8217;re just humbled and excited to be recognized,&#8221; he said. </span></p>\n<h2>A New Round of Controversy</h2>\n<p>Over the years, companies have come and gone from the recommended hosting page. However, Bluehost in particular has consistently appeared on the list, including the most recent iteration. Bluehost is owned by <a href=\"http://www.endurance.com/\">Endurance International Group</a> who <a href=\"http://www.prweb.com/releases/2014/05/prweb11874425.htm\">invested in Automattic</a> in 2014. Because Mullenweg is the CEO of Automattic and controls who is listed on the page, it&#8217;s easy to see why it regularly generates controversy.</p>\n<p>Kevin Ohashi of ReviewSignal.com, <a href=\"http://reviewsignal.com/blog/2016/05/12/wordpress-org-updates-hosting-recommendations-nobody-knows-selection-criteria/\">criticized the lack of transparency</a> regarding the process for how hosts.</p>\n<blockquote><p>Who is responsible for this revamp? What were the selection criteria? How often will it be updated? Will existing companies be continuously re-evaluated?</p></blockquote>\n<p>These are important questions to ask and there are no publicly documented answers. In a follow up post, <a href=\"http://reviewsignal.com/blog/2016/05/13/wordpress-org-hosting-recommendations-listing-criteria/\">Ohashi investigated</a> what criteria needs to be met for being listed on the page. The post contains a number of screenshots of his private conversation with <a href=\"https://profiles.wordpress.org/macmanx\">James Huff</a>, who has volunteered for the WordPress project for 12 years and has worked at Automattic for five years.</p>\n<p>Huff was directly related to the project and influenced who was chosen thanks to his involvement on the WordPress Support Team. Within the conversation, he shares details of the process and mentions that no money exchanged hands. Early in the conversation, Ohashi tells Huff that he wants to learn and publish how the process works. However, Huff had no idea that everything he said would be made public.</p>\n<p>&#8220;I was invited to what sounded like a friendly chat over direct message from a concerned community member, after he was referred to me by a friend,&#8221; Huff said. &#8220;At no point was it clarified or even implied that anything discussed would be made public.&#8221;</p>\n<p><del>Conversations held in a private matter should remain private unless given permission to publish them, something I discovered the hard way.</del> Unfortunately, the post comes across as a public interrogation of Huff. I asked Huff, who was shaken by the experience, how it has affected him moving forward as it relates to the WordPress project.</p>\n<p>&#8220;I&#8217;d be lying if I said my feelings weren&#8217;t at least shaken by the experience, especially considering how polite he was to my friend and how hostile he was towards me apparently just because I work for Automattic, but this isn&#8217;t the first time that has happened to me and I don&#8217;t expect it to be the last,&#8221; he said.</p>\n<p>&#8220;There&#8217;s an usually prevalent negative bias against Automatticians who contribute to WordPress.&#8221;</p>\n<h2>Mullenweg Provides Clarification</h2>\n<p>Mullenweg <a href=\"http://reviewsignal.com/blog/2016/05/13/wordpress-org-hosting-recommendations-listing-criteria/#comment-1011\">commented on the post</a> where he not only sticks up for Huff, but answers some of the controversial questions raised by Ohashi. Mullenweg explains how the applicants were chosen, how the criteria is weighted, who makes the final decisions, and how much money is involved. Here is his comment in full.</p>\n<blockquote><p>&#8216;I would like to see some transparency in the process&#8217;</p>\n<p>As stated on the page, the listing is completely arbitrary. The process was: There was a survey, four applicants were chosen, and the page was updated. That might repeat later in the year, or the process might change.</p>\n<p>&#8216;how criteria are weighted&#8217;</p>\n<p>There is no criteria or weighting. It ultimately is one person’s opinion. Information that is important is reflected in the questions asked in the survey, but that is not everything that is taken into account. (I have looked at this site in the past, for example.)</p>\n<p>&#8216;who is making the decisions&#8217;</p>\n<p>I am. James helped in sorting through the many submissions that came in, doing additional research, and digging on finalists, but ultimately the decision was mine. You can and should blame me fully for any issues you have with it. I appreciate James’ help in this go-round, but he will not be involved at all with any future updates. (So, please leave him alone.)</p>\n<p>&#8216;how much money is involved&#8217;</p>\n<p>There was no money involved. Obviously being listed on the page is hugely valuable and impacts the listed (or unlisted) businesses a great deal. This is why I take full responsibility for the listing, now and in the future — I have been fortunate to be extraordinarily successful and no financial or business consideration any of the applicants could offer matters to me. A host could offer $100,000,000 to be listed on the page for 1 day, and I would say no.</p></blockquote>\n<p>It&#8217;s unfortunate that the information in Mullenweg&#8217;s comment is not published in an official post announcing the changes to the recommended hosting page. If an official post was published that included the same information in his comment, it&#8217;s possible it would have eliminated most of the confusion, uncertainty, and doubt surrounding it.</p>\n<h2>Should WordPress.org Have a Recommended Hosting Page?</h2>\n<p>Due to the investments EIG has made in Automattic, Mullenweg&#8217;s role at the company, and him making the final decisions, there will always be a potential conflict of interest despite taking full responsibility of the page and the processes associated with it.</p>\n<p>Should WordPress.org have a recommended hosting page? What if the page was replaced with information people could use to make informed decisions on choosing a host? It would eliminate potential conflicts of interest and if there was a host Mullenweg felt strongly about, he could label it as a partner of the project. This would make it clear that any financial connection with the company is a business relationship.</p>\n<p>Are you hosting with any of the companies listed on the recommended hosting page? If so, tell us about your experience in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 May 2016 16:39:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: WordPress Accessibility Team Seeks Testers Using Speech Recognition Technology\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54829\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"http://wptavern.com/wordpress-accessibility-team-seeks-testers-using-speech-recognition-technology\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2791:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/glasses.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/glasses.jpg?resize=1024%2C562\" alt=\"photo credit: Let\'s Read - (license)\" class=\"size-full wp-image-54851\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/42788859@N00/320216939\">Let&#8217;s Read</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc-sa/2.0/\">(license)</a>\n<p>The World Health Organization estimates that <a href=\"http://www.who.int/mediacentre/factsheets/fs282/en/\" target=\"_blank\">285 million people</a> worldwide are living with some form of visual impairment and 39 million of those are estimated to be blind. Many people with low vision depend on speech recognition technology to navigate the web and communicate their thoughts. This type of software also assists people who have carpal tunnel, RSI (Repetitive Stress Injuries) and/or limited mobility in their hands and arms.</p>\n<p>Rian Rietveld and the Accessibility team are working to improve the experience of using WordPress with speech recognition software, such as <a href=\"http://www.nuance.com/dragon/index.htm\" target=\"_blank\">Dragon Naturally Speaking</a> (widely considered as one of the best for desktop use.) In particular, <a href=\"https://core.trac.wordpress.org/ticket/23562\" target=\"_blank\">the task of adding media to a post has a number of obstacles</a> that make it nearly impossible for those using speech recognition software.</p>\n<p>Rietveld <a href=\"https://make.wordpress.org/accessibility/2016/05/13/20th-wordpress-accessibility-test-add-media-with-speech-recognition-software/\" target=\"_blank\">posted three tests</a> to the Accessibility team&#8217;s blog today, inviting those who use <a href=\"http://www.nuance.com/dragon/index.htm\" target=\"_blank\">Dragon Naturally Speaking</a> or other assistive technology to help the contributors determine the roadblocks that need to be removed for adding media. These tests include actions like adding media, editing attachment details, and creating a gallery.</p>\n<p>If you use WordPress with assistive technology for speech recognition, completing these tests and offering your feedback is one way to get involved as a contributor. You don&#8217;t necessarily have to use Dragon Naturally Speaking, as there are many newer alternatives such as Windows Speech Recognition (Cortana) and Chrome&#8217;s speech recognition powered by Google Speech to Text. Testers can report their experiences, along with the assistive technology/browser/OS, in the comments on Rietveld&#8217;s <a href=\"https://make.wordpress.org/accessibility/2016/05/13/20th-wordpress-accessibility-test-add-media-with-speech-recognition-software/\" target=\"_blank\">post</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 May 2016 22:40:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: Happytables Pivots to Provide Restaurant Analytics and Insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=41046\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/happytables-pivots-to-provide-restaurant-analytics-and-insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5302:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/happy-tables.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/happy-tables.jpg?resize=1000%2C608\" alt=\"happy-tables\" class=\"aligncenter size-full wp-image-54835\" /></a></p>\n<p><a href=\"http://www.happytables.com/\" target=\"_blank\">Happytables</a> is changing from being a platform that hosts restaurant websites to one that provides analytics and insights by tapping into apps that restaurants are already using to promote their businesses. The company uses WordPress as a command center for the application that communicates with various restaurant-tech APIs to deliver information to the dashboard in realtime.</p>\n<p>&#8220;We started with the website builder a while back,&#8221; Founder and CEO Noel Tock said. &#8220;It’s been a great ride, but we realized two things: 1) Website builders have become a race to the bottom with regards to revenue as well as extremely competitive, and 2) From our many conversations with restaurants, their challenges have become much larger; consolidating data and insights from all the products they now use.&#8221;</p>\n<p>One of the Happytables beta restaurants in London uses 14 different applications to manage its sales, operations, and marketing, and Tock says this trend is only growing.</p>\n<p>&#8220;The centre of gravity is shifting from the Point of Sale to a very fragmented collection of siloed products (reservations, online ordering, staff scheduling/wages, loyalty, waitlist, social, etc.),&#8221; Tock said. &#8220;Becoming that 30,000 foot view whilst generating actionable insights across the portfolio of applications is the challenge we’ve taken on with the new Happytables.&#8221;</p>\n<p>The first installation of the new Happytables was set up for <a href=\"http://whyteandbrown.com/\" target=\"_blank\">Whyte &amp; Brown</a> in London where the team is focusing their beta testing. The application currently aggregates data from POS (Point of Sale) and Social, but Tock says this will rapidly evolve to providing various insights from POS and Labor, such as revenue forecasting, employee performance, and breakfast/lunch/dinner performance.</p>\n<p>&#8220;It’s been very exciting working towards actionable insights, whereby we can tell a waiter that he/she was underselling a certain product or category compared to their colleagues, or that a particular employee performs a lot better on lunch then on dinner,&#8221; Tock said.</p>\n<p>Below you can see an example of Happytables&#8217; latest kitchen dashboard, using the team view as opposed to the individual employee recommendations/suggestions view.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/Happytables_kitchen_dashboard.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/Happytables_kitchen_dashboard.png?resize=1025%2C731\" alt=\"Happytables_kitchen_dashboard\" class=\"aligncenter size-full wp-image-54833\" /></a></p>\n<p>The new Happytables uses WordPress as a backend and the WP REST API and ReactJS on the frontend.  Although the development team still uses WordPress as one of its core technologies, the infrastructure is a bit more complicated.</p>\n<p>&#8220;It’s not pure WordPress for the data storage,&#8221; CTO Aaron Jorbin said. &#8220;In fact, very little of it is actually stored inside WordPress. It is used to store some information about the restaurant and manage requests to third parties where we fetch the data and then store it in DynamoDB.&#8221;</p>\n<p>The screenshots in this post show the WordPress theme in full screen mode, but Jorbin said the restaurant staff never interact with wp-admin. Restaurant operators use the app to view all the realtime information coming in so that they can make better decisions about how they run their businesses.</p>\n<p>Happytables is still hosting its customers from its first iteration as a website builder, but Tock said most are not good candidates for the beta.</p>\n<p>&#8220;The infrastructure is quite different now as we’re capturing different types of data (previously web content, now largely transactional data),&#8221; he said. &#8220;Our customers on the website builder platform came from all walks of life, so there’s not many who fit the ideal beta candidate (using Micros/Aloha as POS, based in London, run a multiunit restaurant, etc.).</p>\n<p>&#8220;We&#8217;re just looking to see how we can fit this into the larger Happytables model downstream,&#8221; Tock said. &#8220;If we’re going to implement so many API’s, there’s also value in tying those back to the website.&#8221;</p>\n<p>Not many aspects of the new infrastructure have been open sourced yet, as the team has been moving fast. Tock said they hope to make some of their code public further down the road after it&#8217;s been tested.</p>\n<p>&#8220;Once we’re past testing/beta, I’m sure a number of features will become more mature tools and move into their own public repo if they are of that sort of benefit,&#8221; he said. The new infrastructure is one of the many exciting ways that the WP REST API is being used to bring a host of information into WordPress from various third party applications and tie it all together in a useful way.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 May 2016 19:45:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Matt: Mom on Tinder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2016/05/mom-on-tinder/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:227:\"<p>If you&#8217;re looking for a fun Friday read, <a href=\"http://www.gq.com/story/my-mom-ran-my-tinder\">check out this story of a young GQ writer who gave control of his Tinder account to his Mom</a>. It&#8217;s adorkable.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 May 2016 16:35:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"WPTavern: GitLab Courts Disgruntled GitHub Customers with Response to Recent Pricing Hike\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54780\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://wptavern.com/gitlab-courts-disgruntled-github-customers-with-response-to-recent-pricing-hike\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5016:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/gitlab.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/gitlab.png?resize=1025%2C371\" alt=\"gitlab\" class=\"aligncenter size-full wp-image-50741\" /></a></p>\n<p>Yesterday GitHub <a href=\"http://wptavern.com/github-introduces-unlimited-private-repositories-hikes-prices-for-organizations\" target=\"_blank\">announced</a> pricing changes that give all paid plans unlimited repositories and change plans to a pricing-per-user model. Individual developers are the most likely customers to benefit from the changes, but many organizations will see an exponential increase in pricing.</p>\n<p>GitLab, a competitor in the Git repository hosting space, immediately addressed disgruntled GitHub customers with a <a href=\"https://about.gitlab.com/2016/05/11/git-repository-pricing/\" target=\"_blank\">pricing comparison</a> on the company&#8217;s blog. Co-founder and CEO <a href=\"https://twitter.com/sytses\" target=\"_blank\">Sid Sijbrandij</a> noted that the three main players in this space, GitHub, Bitbucket, and GitLab, all offer unlimited private repositories but that it doesn&#8217;t cost companies more to host additional repositories for a given user.</p>\n<p>Sijbrandij attributes the change to the increase in the <a href=\"https://www.sequoiacap.com/article/build-us-microservices/\" target=\"_blank\">microservices model</a>, a development approach that breaks software down into smaller, related pieces that communicate with one another via APIs.</p>\n<p>&#8220;As more and more developers, teams, and organizations seek out the advantages of microservices, they’ll need more repositories to support this new code structure,&#8221; Sijbrandij said. &#8220;Basically, the more microservices you have the more repositories you’ll need. That is why it is not surprising that GitHub has announced free private repositories.&#8221;</p>\n<p>Sijbrandij referenced several examples where GitHub&#8217;s pricing changes hit open source organizations hard, including <a href=\"https://github.com/edx/\" target=\"_blank\">Open edX</a>, a non-profit with a large number of contributors, which <a href=\"https://news.ycombinator.com/item?id=11674530\" target=\"_blank\">posted</a> the following on Hacker News:</p>\n<blockquote><p>I work for a non-profit open source organization that <a href=\"https://github.com/edx/\" target=\"_blank\">collaborates on github</a>. We have lots of people who aren&#8217;t employees, but have signed a contributor agreement with our organization and contribute changes to our software. Our bill will go up from $200/month to over $2000/month with this new pricing. We can afford it (it&#8217;s still a small fraction of our AWS bill) but it will force us to look at other alternatives. Github&#8217;s code review tools are already pretty mediocre compared to other tools like gerrit, and we&#8217;ve long since moved off of GitHub issue tracking due to lack of features compared to JIRA.</p></blockquote>\n<p>Sijbrandij emphasized that the team at GitLab believes “everyone can contribute,” a mission which drives GitLab.com&#8217;s pricing structure to offer unlimited private repositories, unlimited contributors, and unlimited CI runners for free. The on-premises solution, which includes enterprise features and support, is what keeps the lights on at the company. GitLab.com, the free, hosted version, runs the same enterprise edition software but is, by Sijbrandij&#8217;s own admission, still <a href=\"https://gitlab.com/gitlab-com/operations/issues/42\" target=\"_blank\">struggling with sluggish performance</a>.</p>\n<p>Earlier this year when open source project maintainers <a href=\"http://wptavern.com/open-source-project-maintainers-confront-github-with-open-letter-on-issue-management\" target=\"_blank\">confronted GitHub with an open letter on issue management</a>, GitLab differentiated itself by <a href=\"http://wptavern.com/gitlab-courts-open-source-project-maintainers-with-response-to-dear-github-letter\" target=\"_blank\">responding</a> to the situation with a new initiative focused on “making GitLab the best place for big open source projects.”</p>\n<p>Nearly a month later, <a href=\"http://wptavern.com/github-responds-to-letter-from-open-source-project-maintainers\" target=\"_blank\">GitHub finally responded</a> with an apology to open source project maintainers and a promise to address their concerns with a steady string of changes.</p>\n<p>GitHub has not given any indication of reversing its recent decision to change its pricing structure. However, with competitors like GitLab putting on the heat, GitHub may be forced to make some changes to its paid plans. At the very least, it could inspire the company to address concerns about organizations having to pay for inactive users and perhaps spur GitHub to offer customers the ability to distinguish between collaborators on open source projects and users who simply need access to private repositories.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 May 2016 02:33:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"WPTavern: How Authors With Plugins in the Official Directory Can Use Tags to Get a Moderator’s Attention\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54441\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"http://wptavern.com/how-authors-with-plugins-in-the-official-directory-can-use-tags-to-get-a-moderators-attention\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2627:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/05/WordPressAdviceForNewUsers.png\"><img class=\"size-full wp-image-44085\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/05/WordPressAdviceForNewUsers.png?resize=612%2C237\" alt=\"WordPress Advice For New Users\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/99329675@N02/11064947983\">What You Need To Know About Food Poisoning</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">(license)</a>\n<p>It&#8217;s almost inevitable that as a WordPress plugin gains popularity, it will receive a bad review. How plugin authors handle and respond to bad reviews is crucial, especially in a public forum. Mika Epstein, who helps review plugins before they&#8217;re added to the directory and is a dedicated support forum volunteer, <a href=\"https://make.wordpress.org/plugins/2016/05/03/handling-bad-reviews/\">gives advice </a>on how to handle and respond to bad reviews.</p>\n<p>Bad reviews are classified as those written as spam, trolling, emotional blackmail for support, and those that should have been a support post. Since the plugin review system is powered by bbPress, plugin authors can add tags to reviews in order to draw a moderator&#8217;s attention. The tags include:</p>\n<ul>\n<li><strong>Modlook</strong> &#8211; This tag notifies moderators that a particular thread needs their attention. If you think a review is spam, don&#8217;t respond to it. Instead, add the Modlook and Spam tags and let a moderator decide if the review should be deleted.</li>\n<li><strong>Sockpuppet</strong> &#8211; If you suspect a review is part of a spamming campaign where a group of people are marking a plugin as one or five stars, apply the sockpuppet and modlook tags to the review.</li>\n<li><strong>Wrongplugin</strong> &#8211; Add the wrongplugin tag to the review if you believe it&#8217;s for a different plugin. The team can move the review to the appropriate place.</li>\n<li><strong>Pluginmod</strong> &#8211; Add this tag to a review if you need an administrator&#8217;s attention. This usually results in the team performing a full review of your plugin. If it&#8217;s determined that it breaks any of <a href=\"https://wordpress.org/plugins/about/guidelines/\">the guidelines</a>, it will be removed until they&#8217;re fixed.</li>\n</ul>\n<p>Developers who host plugins in the official directory should make note of these tags and use them when necessary. The tag system is generally unknown to the public but it&#8217;s a great way for moderators to keep on top of the forums and reviews.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 May 2016 01:06:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: WPWeekly Episode 234 – All Things WordCamp with Andrea Middleton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=54807&preview_id=54807\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/wpweekly-episode-234-all-things-wordcamp-with-andrea-middleton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2896:\"<p>In this episode of WordPress Weekly, Marcus Couch and I are joined by <a href=\"https://thethingwiththestuff.wordpress.com/\">Andrea Middleton</a>, who works at Automattic as a Community Organizer for the WordPress open source project. We discuss a number of topics including, updates to the WordCamp Central website, the <a href=\"https://make.wordpress.org/community/2016/03/02/transitioning-to-wordpress-community-support/\">for-profit subsidiary</a>, and the experimental <a href=\"http://wptavern.com/wordpress-to-launch-experimental-wordcamp-incubator-program\">WordCamp incubator program</a>.</p>\n<p>At the conclusion of our interview with Middleton, Mendel Kurland, GoDaddy&#8217;s Evangelist, joined us to describe his experiences attending DrupalCons. DrupalCons are events similar to WordCamps but on a larger scale. He tells us what the similarities and differences are and the unique things they do that he&#8217;d like to see WordCamps adopt. We close out the show with Marcus&#8217; plugin picks of the week.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-4-5-2-patches-two-security-vulnerabilities\">WordPress 4.5.2 Patches Two Security Vulnerabilities</a><br />\n<a href=\"http://wptavern.com/automattic-is-protecting-its-woo-woothemes-and-woocommerce-trademarks\">Automattic is Protecting its Woo, WooThemes, and WooCommerce Trademarks</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/disable-core-update-email/\">Disable WordPress Core Update Email</a> allows used to disable the default notification email sent by WordPress after an automatic core update is applied.</p>\n<p><a href=\"https://wordpress.org/plugins/downgrade/\">Downgrade </a>enables users to easily downgrade WordPress to an earlier version. It&#8217;s a handy diagnostics tool that helps determine if a new WordPress release is the cause of errors.</p>\n<p><a href=\"https://wordpress.org/plugins/woo-customer-insight\">Woo Customer Insight </a>provides greater insight into what visitors are doing on your sites. It allows you to see the pages your customers are visiting, where they&#8217;re clicking, the time spent on the different pages, and more.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, May 18th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #234:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 May 2016 23:23:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matt: .Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46554\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://ma.tt/2016/05/blog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:858:\"<p>It&#8217;s now public that Automattic is the company behind Knock Knock Whois There LLC, the registry for the new .blog TLD. (And a great pun.) We wanted to stay stealth while in the bidding process and afterward in order not to draw too much attention, but nonetheless the cost of the .blog auction got up there (people are <a href=\"http://www.theregister.co.uk/2015/02/13/who_just_bought_dotblog_for_30m/\">estimating around $20M</a>). I&#8217;m excited we won and think that it will be both an amazing business going forward and give lots of folks an opportunity to have a fantastic domain name in a new namespace and with an easy-to-say TLD. <a href=\"https://dotblog.wordpress.com/\">You can sign up to be first in line to reserve a domain here</a>. If you have a trademark you can get in August, and then October for the &#8220;land rush.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 May 2016 19:23:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: Automattic to Oversee the Sale and Registration of Top-Level .Blog Domains\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54788\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/automattic-to-oversee-the-sale-and-registration-of-top-level-blog-domains\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2974:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/blogging.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/blogging.jpg?resize=960%2C521\" alt=\"photo credit: Luis Llerena\" class=\"size-full wp-image-54799\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/3ZHG0XOIT6\">Luis Llerena</a>\n<p>Automattic <a href=\"https://en.blog.wordpress.com/2016/05/12/coming-soon-new-blog-domains-for-websites/\" target=\"_blank\">announced</a> today that it will begin offering top-level .blog domain registration starting in August 2016. The .blog domain extension will be available to both WordPress and non-WordPress sites.</p>\n<p>According to <a href=\"https://twitter.com/markarms\" target=\"_blank\">Mark Armstrong</a>, an Automattic subsidiary is exclusively managing the registration of .blog domains and will be offering it for purchase through WordPress.com and other domain registrars.</p>\n<p>&#8220;Automattic subsidiary Knock Knock Whois There LLC, in partnership with the domain company Primer Nivel, won the rights to the .blog domain in 2015 through an auction process overseen by the Internet Corporation for Assigned Names and Numbers (ICANN), the non profit organization that oversees namespaces of the internet,&#8221; Armstrong said.</p>\n<p>In an <a href=\"https://ma.tt/2016/05/blog/\" target=\"_blank\">announcement</a> on his blog, Automattic CEO Matt Mullenweg said they used the Knock Knock Whois There LLC company name to &#8220;stay stealth while in the bidding process,&#8221; which closed around $19 million.</p>\n<p>Although WordPress.com is currently providing the registration information site at <a href=\"https://dotblog.wordpress.com/\" target=\"_blank\">dotblog.wordpress.com</a>, Armstrong said that the company is using <a href=\"http://www.nominet.uk/\" target=\"_blank\">Nominet</a> (the backend registry provider for .UK) to provide the technical infrastructure for managing the domain extension.</p>\n<p>Registration for .blog domains will be offered in a phased approach during the second half of 2016, according to the following estimated timeframe:</p>\n<ul>\n<li><strong>Sunrise (August):</strong> Trademark owners will be able to register .blog domains associated with their brands</li>\n<li><strong>Landrush (October):</strong> Before .blog becomes available to the public, domains may be registered during the landrush period on an application basis.</li>\n<li><strong>General Availability (November):</strong> Automattic plans to begin offering .blog domains to the general public before the end of the year.</li>\n</ul>\n<p>With the exclusive rights to manage the sale of millions of .blog domains, Automattic has the opportunity to promote WordPress.com as a potential host for new registrants. The company hasn&#8217;t finalized the price but Armstrong said it will be &#8220;in the standard range for new top-level domains with some premium pricing for higher-value names.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 May 2016 18:19:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: Critical Vulnerabilities Found in PhpStorm, Immediate Update Advised\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54770\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://wptavern.com/critical-vulnerabilities-found-in-phpstorm-immediate-update-advised\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2128:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/09/phpstorm-wp-feature.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/09/phpstorm-wp-feature.jpg?resize=1025%2C471\" alt=\"phpstorm-wp-feature\" class=\"aligncenter size-full wp-image-30739\" /></a></p>\n<p>JetBrains <a href=\"http://blog.jetbrains.com/blog/2016/05/11/security-update-for-intellij-based-ides-v2016-1-and-older-versions/\" target=\"_blank\">announced</a> today that it has released a security update for PhpStorm and all of its other IntelliJ-based IDEs due to a set of critical vulnerabilities:</p>\n<blockquote><p>The cross-site request forgery (CSRF) flaw in the IDE’s built-in webserver allowed an attacker to access local file system from a malicious web page without user consent.</p>\n<p>Over-permissive CORS settings allowed attackers to use a malicious website in order to access various internal API endpoints, gain access to data saved by the IDE, and gather various meta-information like IDE version or open a project.</p></blockquote>\n<p>PhpStorm is by far <a href=\"http://www.sitepoint.com/best-php-ide-2014-survey-results/\" target=\"_blank\">the most favored IDE for PHP developers</a>. It&#8217;s also widely used among WordPress developers, especially since <a href=\"http://wptavern.com/phpstorm-8-released-with-full-wordpress-support\" target=\"_blank\">version 8 added official support for WordPress</a>.</p>\n<p>The update issued today patches the critical vulnerabilities inside the underlying IntelliJ platform that powers nearly a dozen popular IDEs. Installing the update is as easy as selecting &#8216;Check for Updates&#8217; inside the IDE. Alternatively, customers can download the most recent version from JetBrains.com and the <a href=\"http://blog.jetbrains.com/blog/2016/05/11/security-update-for-intellij-based-ides-v2016-1-and-older-versions/\" target=\"_blank\">security announcement</a> includes links to download older versions.</p>\n<p>Although the JetBrains security team is not aware of these vulnerabilities having been exploited, immediate update is recommended.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 May 2016 22:26:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: GitHub Introduces Unlimited Private Repositories, Hikes Prices for Organizations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54746\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://wptavern.com/github-introduces-unlimited-private-repositories-hikes-prices-for-organizations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7590:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/04/github-octocat.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/04/github-octocat.jpg?resize=857%2C400\" alt=\"github-octocat\" class=\"aligncenter size-full wp-image-42456\" /></a></p>\n<p>GitHub has been inundated with negative feedback after <a href=\"https://github.com/blog/2164-introducing-unlimited-private-repositories\" target=\"_blank\">announcing a major change to its pricing</a> today. All paid plans now include unlimited private repositories, but there&#8217;s a catch. The new pricing structure requires GitHub.com organizations to purchase a seat for each user. At $9 per user/month, collaborating on private repositories is now far more costly than the legacy plans which started at $25/month for 10 repositories and unlimited members.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/github-pricing.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/github-pricing.png?resize=1025%2C392\" alt=\"github-pricing\" class=\"aligncenter size-full wp-image-54756\" /></a></p>\n<p>The change is good news for individual developers with paid accounts, as they are no longer charged on a per-repository basis. However, many owners of organizations are finding the new pricing to be untenable and are actively considering alternatives. For comparison, Bitbucket offers unlimited private repositories and <a href=\"https://bitbucket.org/product/pricing\" target=\"_blank\">charges $1/user/month</a>. Unlimited users caps out at $200/month.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/Krogsgard\">@Krogsgard</a> EDD org alone will go from $25 per month to $592 per month <a href=\"https://twitter.com/github\">@github</a></p>\n<p>&mdash; Pippinsplugins (@pippinsplugins) <a href=\"https://twitter.com/pippinsplugins/status/730396802638176257\">May 11, 2016</a></p></blockquote>\n<p></p>\n<p>While unlimited private repositories is an exciting benefit that enables developers to make their code more modular, it isn&#8217;t a benefit that every organization needs.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/github\">@github</a> Terrible news. I work on an open-source organization &gt;100 devs. We have 2 private repos for internal projects. $900+ vs $25 really!?</p>\n<p>&mdash; João Ventura (@jcnventura) <a href=\"https://twitter.com/jcnventura/status/730319187667759104\">May 11, 2016</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/williamsba\">@williamsba</a> ours jumped to $1,204 :-( <a href=\"https://twitter.com/github\">@github</a></p>\n<p>&mdash; Tom Willmot (@tomwillmot) <a href=\"https://twitter.com/tomwillmot/status/730391291691995136\">May 11, 2016</a></p></blockquote>\n<p></p>\n<p><a href=\"https://easydigitaldownloads.com/\" target=\"_blank\">Easy Digital Downloads</a> creator Pippin Williamson <a href=\"http://www.twitlonger.com/show/n_1solvjd\" target=\"_blank\">explained</a> why he is frustrated with what amounts to a 2,276% increase in costs for his organization:</p>\n<blockquote><p>I actually have no problems with the pricing for new organizations. It&#8217;s their space and they provide a huge number of valuable tools. It is absolutely worth it.</p>\n<p>The problem I have is the drastic increase for existing customers. It&#8217;s largely the principal of increasing a customer&#8217;s cost by 2,276% without giving them any additional value.</p>\n<p>The value that Github provides me and my team does not change at all with the new pricing, only what I pay per month.</p></blockquote>\n<p>Samuel &#8220;Otto&#8221; Wood <a href=\"http://www.twitlonger.com/show/n_1solviv\" target=\"_blank\">contends</a> that GitHub&#8217;s $9/user/month is a reasonable price to pay for having all the functionality of GitHub hosted for an organization but that the alternative of building your own is far more economical.</p>\n<blockquote><p>A &#8220;private&#8221; repo is, you know, private. On your own server. Git is, after all, decentralized. You could plop a normal git repo on any private VPS you like in a matter of under an hour. If you&#8217;re collaborating with a small group of like 5 people, then coordination is not really a big deal that I&#8217;d pay $45 a month to use GitHub for it. You can use any tooling you like, make any website you like. You could probably reproduce the important parts of GitHub that you need for your private setup using WordPress in like a day or two. </p>\n<p>It just seems to me that any advantages of using GitHub at all seem largely nullified by using private repos. Yes, collaboration and using the same toolset you are used to, I get that. But here you&#8217;re falling prey to vendor lock-in once again. You&#8217;re used to it, you like it, you&#8217;re afraid of change, pay up. Simple. </p>\n<p>The advantage of open source software is the freedom to say &#8220;up yours&#8221; and build your own version instead. Git is open source. Think about it. A $15 a month VPS could easily fit your needs for both privacy and collaboration.</p></blockquote>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/github\">@github</a> found a way to be more expensive than the datacenter that runs my app. Seriously, what\'s happening at <a href=\"https://twitter.com/github\">@github</a> ???</p>\n<p>&mdash; Adilson Carvalho (@lcadilson) <a href=\"https://twitter.com/lcadilson/status/730405070819471361\">May 11, 2016</a></p></blockquote>\n<p></p>\n<p>GitHub has established itself as the de facto code collaboration site by offering free hosting for public, open source repositories. However, the emphasis on &#8220;social coding&#8221; no longer extends to private repositories as organization owners will have little incentive to add more collaborators under the new pricing structure. It discourages organizations from adding users to be bug reporters or third-party collaborators. Teams and agencies hit hardest by the changes are now examining competitors like Bitbucket and self-hosted GitLab.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Today is for <a href=\"https://twitter.com/gitlab\">@gitlab</a> what 2007 was for <a href=\"https://twitter.com/WordPress\">@WordPress</a>. If code is poetry, Gitlab is your library. Own your code like you own your content. ❤️</p>\n<p>&mdash; John James Jacoby (@JJJ) <a href=\"https://twitter.com/JJJ/status/730417868047790080\">May 11, 2016</a></p></blockquote>\n<p></p>\n<p>Organization owners will not be forced onto the new pricing plans immediately and GitHub promises to give a year&#8217;s notice before mandating a switch to the new plans:</p>\n<blockquote><p>We want everyone to have a plan with unlimited private repositories, but don’t worry—you are welcome to stay on your current plan while you evaluate the new cost structure and understand how to best manage your organization members and their private repository access. And while we&#8217;re currently not enforcing a timeline to move, rest assured that you&#8217;ll have at least 12 months notice before any mandated change to your plan.</p></blockquote>\n<p>While many individual developers will see lower monthly prices and even prorated credits on their accounts, the exponential cost increase for GitHub&#8217;s largest customers may cause a mass exodus to the company&#8217;s more affordable competitors. Are you moving your organization off of GitHub? Let us know in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 May 2016 19:27:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: Affinity: A Free WordPress Wedding Theme from Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54688\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wptavern.com/affinity-a-free-wordpress-wedding-theme-from-automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3832:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/affinity.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/affinity.png?resize=800%2C471\" alt=\"affinity\" class=\"aligncenter size-full wp-image-54691\" /></a></p>\n<p>Affinity is the latest addition to WordPress.com&#8217;s small collection of <a href=\"https://wordpress.com/themes/search/wedding/\" target=\"_blank\">themes created specifically for weddings</a>. This highly customizable, elegant theme was designed by <a href=\"http://carolinemoore.net/\" target=\"_blank\">Caroline Moore</a> with weddings and family announcements in mind.</p>\n<p>Affinity is a one-page theme with support for five different panels. Each panel&#8217;s content can be assigned in the customizer under Theme Options by selecting a page from a drop-down.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/panel.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/panel.png?resize=660%2C231\" alt=\"panel\" class=\"aligncenter size-full wp-image-54717\" /></a></p>\n<p>With the customizable panel approach users are not locked into providing content for sections they don&#8217;t need. Single posts and pages support full screen featured images that, if used as a panel, become the background of that section. Affinity offers the option to set the header image opacity to create better contrast with header text. Users can also enable or disable scrolling on the header and front-page featured images.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/affinity-home-page.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/affinity-home-page.png?resize=200%2C474\" alt=\"affinity-home-page\" class=\"alignright size-full wp-image-54693\" /></a></p>\n<p>Affinity includes support for a sidebar widget area and three optional widget areas in the footer. If widgets are added to the sidebar, the one-column layout becomes a two-column layout. It also has a fullwidth page template for removing the sidebar on select pages.</p>\n<p>The different panels give users ample space for adding photos, links to registries, personal stories, info about the bridal party, and anything else related to the event. Affinity includes a Guestbook page template with a special format for displaying visitors&#8217; comments. Turning the Guestbook on is as easy as setting the page template and making sure that comments are enabled.</p>\n<p>Another unique feature of the theme is its post intro area that displays beneath the headline before the first paragraph. It pulls content from the excerpt field and post authors can use it to capture readers&#8217; attention with a quick summary or highlight.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/affinity-post-intro.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/affinity-post-intro.png?resize=660%2C328\" alt=\"affinity-post-intro\" class=\"aligncenter size-full wp-image-54729\" /></a></p>\n<p>Check out the <a href=\"https://affinitydemo.wordpress.com/\" target=\"_blank\">live demo</a> to see the theme in action. It shows an example of panels that display quotes, an RSVP form, event details, and an engagement story.</p>\n<p>Since no wedding or family announcement is the same, Affinity&#8217;s multi-panel approach offers flexibility for many different types of uses. If you&#8217;re creating a wedding website and are not finding enough customization options with a hosted service, this theme makes it quick and easy to set it up with WordPress. It&#8217;s not yet available on WordPress.org, but you can download a copy for your self-hosted site for free from the sidebar of its <a href=\"https://wordpress.com/themes/affinity\" target=\"_blank\">homepage on WordPress.com</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 May 2016 06:52:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: Help WPCampus Gather Data on How Schools and Campuses Use WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://wptavern.com/help-wpcampus-gather-data-on-how-schools-and-campuses-use-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1247:\"<p>The organizers of <a href=\"https://2016.wpcampus.org/\">WPCampus</a> are <a href=\"https://www.surveymonkey.com/r/wpcampus05-2016\">seeking feedback</a> via a survey on how schools and campuses utilize WordPress in their environments. The survey consists of five sections:</p>\n<ul>\n<li>How Do You Use WordPress on Campus</li>\n<li>Site Demographics, Traffic, and Data</li>\n<li>Plugins, Themes, and Features</li>\n<li>Security, Performance, and Hosting</li>\n<li>Your Team Structure &amp; Workflows</li>\n</ul>\n<p>There are a couple of perks for those who fill out the survey. Respondents will receive an anonymized version of the complete data set. Those who complete four or more sections will be entered into a drawing to win a free ticket to the conference and will receive a $5 Starbucks or Amazon Gift card.</p>\n<p>Answer the questions that you know and skip the ones you don&#8217;t. The team needs as much data as possible to provide a clearer picture of WordPress&#8217; use in higher education. If you know someone or an organization that uses WordPress in higher education, please <a href=\"https://www.surveymonkey.com/r/wpcampus05-2016\">share the survey</a> with them. The survey closes on May 27th.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 May 2016 03:21:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: What Do You Think of the Recommended Plugins Page in WordPress?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54437\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/what-do-you-think-of-the-recommended-plugins-page-in-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3913:\"<p>In late 2014, <a href=\"http://wptavern.com/wordpress-4-1-to-introduce-plugin-recommendations\">WordPress 4.1 added</a> a Recommended Plugins tab that takes into account the plugins you have installed and suggests plugins based on which ones are commonly used together. After nearly a year and a half since it was added, I asked the <a href=\"https://twitter.com/wptavern/status/727578470415532032\">Tavern&#8217;s Twitter followers</a> if they have ever installed plugins recommended by WordPress.</p>\n<p>I was surprised to discover that some people don&#8217;t know the tab exists.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/wptavern\">@wptavern</a> There\'s a \"Recommended\" tab?!?</p>\n<p>&mdash; Joe Taiabjee (@joetek) <a href=\"https://twitter.com/joetek/status/727581218414407681\">May 3, 2016</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/wptavern\">@wptavern</a> I\'ve just noticed the Recommended tab. It seems to show those plugins with most Active Installs. Interesting, but a bit \'hidden\'</p>\n<p>&mdash; Alejandro Vargas S. (@Alejandro_V_S) <a href=\"https://twitter.com/Alejandro_V_S/status/727836820159930369\">May 4, 2016</a></p></blockquote>\n<p></p>\n<p>Steve Brown says the recommendations are useful.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/wptavern\">@wptavern</a> yep :) very useful feature indeed</p>\n<p>&mdash; Steve Brown (@stevna) <a href=\"https://twitter.com/stevna/status/727681984504287232\">May 4, 2016</a></p></blockquote>\n<p></p>\n<p>Some people view the page as an opportunity for Automattic to advertise its plugins while others don&#8217;t trust the recommendations.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/wptavern\">@wptavern</a> I have no needs for the Automattic plugins that are almost only being recommended there</p>\n<p>&mdash; Marko Heijnen (@markoheijnen) <a href=\"https://twitter.com/markoheijnen/status/727624592399998976\">May 3, 2016</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/wptavern\">@wptavern</a> Once. However 10 of the plugins recommended on page 1 are untested with my version of WP. So wouldnt rely on the recommendations</p>\n<p>&mdash; WPin.me (@wp_in) <a href=\"https://twitter.com/wp_in/status/727725233843671040\">May 4, 2016</a></p></blockquote>\n<p></p>\n<p>When I viewed the recommended plugins page in 2014, the results displayed plugins that weren&#8217;t updated in years.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/RecommendedPluginsTab.png\"><img class=\"size-full wp-image-35318\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/RecommendedPluginsTab.png?resize=1025%2C527\" alt=\"Plugins Recommended To Me Based on Data of Sites with Similar Plugins Installed\" /></a>Plugins Recommended To Me Based on Data of Sites with Similar Plugins Installed\n<p>Today, the page displays more relevant results with recently updated plugins. On the first page of results for WP Tavern, only one plugin from Automattic is recommended. The second page of results doesn&#8217;t list any plugins authored by Automattic.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/2016RecommendedPlugins.png\"><img class=\"size-full wp-image-54616\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/2016RecommendedPlugins.png?resize=1025%2C514\" alt=\"Recommended Plugins in 2016\" /></a>Recommended Plugin Results in 2016\n<p>To help determine how useful the recommended plugins page is, I&#8217;d like you to take this short survey. Results will be displayed on Tuesday, May 17th. In addition to the survey, you can leave your feedback in the comments.</p>\n<div class=\"pd-embed\" type=\"type\"></div>\n<p></p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 May 2016 03:19:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Automattic is Protecting its Woo, WooThemes, and WooCommerce Trademarks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54645\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"http://wptavern.com/automattic-is-protecting-its-woo-woothemes-and-woocommerce-trademarks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6735:\"<p>When <a href=\"http://wptavern.com/automattic-acquires-woocommerce\">Automattic acquired WooThemes in 2015</a>, it gained employees, plugins, themes, and the company&#8217;s trademarks. These trademarks include, standard character marks, logos, and specific graphics such as the Verified WooExpert badges. One of the responsibilities of a trademark owner is to protect it from infringement.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/VerifiedWooExpertServicemark.png\"><img class=\"size-full wp-image-54702\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/VerifiedWooExpertServicemark.png?resize=1025%2C621\" alt=\"Verified WooExpert Service Mark\" /></a>Verified WooExpert Service Mark\n<p>WooGPL is a service that provides customers with commercial themes, plugins, and extensions for WooCommerce at a discounted rate. In March, Automattic <a href=\"https://woogpl.com/woogpl-is-closing/\">sent Billy Ablett</a>, owner of <a href=\"https://woogpl.com\">WooGPL</a>, the following notice that informs him that his domain infringes the Woo and WooCommerce trademarks.</p>\n<blockquote><p>I’m writing to you on behalf of Automattic Inc. regarding your use of the Woo and WooCommerce trademarks.</p>\n<p>As you may know, Automattic owns the Woo, WooCommerce, and WooThemes brands, as well as the associated trademarks. We recently learned of https://woogpl.com, which actively makes use of our registered trademarks in both its name and promotion. We are very concerned that your use of Woo and WooCommerce will create confusion by communicating that your WooCommerce products are endorsed by or associated with Automattic, when in fact it is not.</p>\n<p>While Automattic appreciates that you are providing products that build on WooCommerce open source software, that fact does not authorize you to use Woo, WooThemes or WooCommerce trademarks.</p>\n<p>To minimize user confusion and to protect our own intellectual property, we unfortunately must insist that you take prompt steps to change your domain name to something that doesn’t include &#8216;Woo&#8217; in the prefix, and change your product descriptions to avoid confusion and potentially misleading consumers to believe they are purchasing our products. An example of this would be: WooCommerce Email Customiser Pro would need to be changed to Email Customiser Pro for WooCommerce.</p>\n<p>For more information, please see our <a href=\"https://www.woothemes.com/style-guide/#sg-trademarks\">Trademark Guidelines</a>.</p>\n<p>While we are appreciative that you have included a disclaimer on your site, unfortunately this would not be sufficient and we would still insist that the domain name and product names be changed.</p></blockquote>\n<p>While it&#8217;s not the sole reason <a href=\"https://woogpl.com/woogpl-is-closing/\">WooGPL is shutting down</a>, the notice provides a convenient opportunity to rebrand to <a href=\"https://www.gplkit.com/\">GPL Kit</a>, something the company was already planning to do.</p>\n<p>&#8220;We would have eventually closed down WooGPL due to GPL Kit however, it would have been great to close it down on our terms when the time was right,&#8221; Daniel, who is part of the GPL Kit team told the Tavern.</p>\n<p>Daniel says that when he started WooGPL there wasn&#8217;t a trademark registered with the Woo character mark until October of 2015.</p>\n<p>A search of the United States Patent and Trademark Office for Woo contains over 1K results. However, this is the only character mark for Woo that I found. The filing date is October 22nd, 2015 and is in the approval process.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/WooCharacterMark.png\"><img class=\"size-full wp-image-54703\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/WooCharacterMark.png?resize=1003%2C557\" alt=\"Woo Character Mark\" /></a>Woo Character Mark\n<h2>When You Should Ask For Permission</h2>\n<p>WooThemes has a <a href=\"https://www.woothemes.com/style-guide/#sg-trademarks\">style guide</a> on its site that explains how the brand is used and has details on when Woo™, WooCommerce®, and WooThemes® names, logos, and related icons collectively known as Woo Marks can be used without permission. The following chart provides some examples.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/PermissionChartForWooTrademarks.png\"><img class=\"size-full wp-image-54704\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/PermissionChartForWooTrademarks.png?resize=1010%2C814\" alt=\"Examples of When You Do and Don\'t Need Permission\" /></a>Examples of When You Do and Don&#8217;t Need Permission\n<p>If you&#8217;re in doubt, you can email Automattic&#8217;s trademark team  <a href=\"mailto:trademarks@automattic.com\">trademarks @ automattic.com</a> to receive clarification.</p>\n<h2>Woo&#8217;s at Risk?</h2>\n<p>There are quite a few businesses in the WordPress ecosystem that use Woo in their name and domain. <a href=\"http://www.woorockets.com/\">WooRockets</a> is a WooCommerce theme shop while <a href=\"http://wooassist.com/\">WooAssist</a> provides support and maintenance for store owners.</p>\n<p>I reached out to both companies to determine if Automattic sent them the same notice it sent to WooGPL. While I didn&#8217;t receive a response from WooRockets, John Gamour of WooAssist provided the Tavern with the following statement:</p>\n<blockquote><p>No, we haven&#8217;t been contacted by Automattic about that. It would be dissapointing if we were asked to change our name as our founder Nicholas Jones reached out to WooThemes before starting Wooassist and they gave the OK. We have also worked with Matt Cohen and James Koster on a project and nothing was ever mentioned about our name.</p></blockquote>\n<p>I tried to get in touch with Paul Sieminski, legal counsel for Automattic, to learn what the criteria is for violating the trademarks, who&#8217;s at risk, and how long they have enforced the marks but he could not be reached for comment.</p>\n<h2>Better to be Safe Than Sorry</h2>\n<p>As WooGPL discovered, adding a disclaimer to the bottom of your sites may not be enough. Considering the cost and potential impacts of re branding a company or product, it&#8217;s important to know as soon as possible if you&#8217;re infringing a company&#8217;s trademarks.</p>\n<p>Business owners in the WooCommerce and WooThemes ecosystem should double-check the <a href=\"https://www.woothemes.com/style-guide/#sg-trademarks\">style guide</a> to make sure you&#8217;re not violating any guidelines. Owners can also take a proactive step and contact Automattic&#8217;s trademark team to determine if your business meets the requirements.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 May 2016 20:21:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: WooCommerce Releases Storefront 2.0 with Major Improvements to Mobile Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54641\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://wptavern.com/woocommerce-releases-storefront-2-0-with-major-improvements-to-mobile-design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3509:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/storefront-update.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/storefront-update.png?resize=1025%2C451\" alt=\"storefront-update\" class=\"aligncenter size-full wp-image-54669\" /></a></p>\n<p><a href=\"https://wordpress.org/themes/storefront/\" target=\"_blank\">Storefront</a>, the official WooCommerce theme built to work seamlessly with the plugin, has just passed the <a href=\"https://www.woothemes.com/2016/05/storefront-2-0-release/\" target=\"_blank\">2.0 milestone</a>. This release introduces a new &#8220;best sellers&#8221; section to the homepage and adds compatibility with the upcoming WooCommerce 2.6’s tabbed “My Account” section and the average rating widget.</p>\n<p>The most important update in Storefront 2.0 is the redesigned mobile experience. According to <a href=\"http://resources.mobify.com/50-mobile-commerce-stats.html\" target=\"_blank\">Mobify</a>, 30% of mobile shoppers will abandon a transaction if the experience is not optimized for mobile. <a href=\"http://www.themobileplaybook.com/\" target=\"_blank\">Google&#8217;s Mobile Playbook</a> says that not having a mobile optimized website is like closing your store one day each week. To keep pace with the expectations of mobile buyers, WooCommerce has drastically reduced Storefront&#8217;s mobile header height by 60% and has added the search, shopping cart, and account links to a sticky bottom menu for easy access.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/storefront-mobile-home.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/storefront-mobile-home.png?resize=799%2C697\" alt=\"storefront-mobile-home\" class=\"aligncenter size-full wp-image-54671\" /></a></p>\n<p>Storefront 2.0 includes many design improvements that make the theme cleaner and more flexible. This update removes Helvetica in favor of Source Sans, which WooCommerce says gives them access to a wider variety of weights they can use to &#8220;provide greater depth and cohesion.&#8221; Other notable design changes include:</p>\n<ul>\n<li>Borders have been largely removed so that pages don’t feel quite so broken up.</li>\n<li>The breadcrumb and the main navigation are now wrapped in their own content regions, cementing them as unique components.</li>\n<li>Product reviews and comments tweaked to make them cleaner and more scannable.</li>\n<li>Blog post meta has been redesigned to include the author Gravatar.</li>\n<li>Softer design treatment for tables with colors based on the main background color.</li>\n<li>oEmbeds have been styled to match the rest of Storefront (including typography, padding, colors).</li>\n<li>Integrated WordPress 4.5’s custom logo feature so users can add a logo without using a plugin.</li>\n</ul>\n<p><a href=\"https://wordpress.org/themes/storefront/\" target=\"_blank\">Storefront</a> is active on more than 50,000 websites. There are nearly a dozen free themes on WordPress.org that use it as a parent theme and another dozen commercial themes on WooThemes.com. If you use a heavily customized Storefront child theme, you may want to test its compatibility with the 2.0 update on a development site to ensure that there are no visual surprises. If you have any ideas or recommendations for updates to Storefront, you can leave feedback on the theme&#8217;s <a href=\"http://ideas.woothemes.com/forums/275029-storefront\" target=\"_blank\">idea board</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 May 2016 22:23:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WPTavern: Timber 1.0 Is Now Available on WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54396\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://wptavern.com/timber-1-0-is-now-available-on-wordpress-org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5932:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/timber.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/timber.png?resize=1025%2C405\" alt=\"timber\" class=\"aligncenter size-full wp-image-54630\" /></a></p>\n<p>Last week the creators of <a href=\"https://wordpress.org/plugins/timber-library/\" target=\"_blank\">Timber</a>, the plugin that enables WordPress theme developers to write HTML using the <a href=\"http://twig.sensiolabs.org/\" target=\"_blank\">Twig Template Engine</a>, released version 1.0 on WordPress.org. The plugin is active on more than 10,000 websites where theme authors have elected to keep PHP files separate from HTML. Timber is built on DRY and MVC principles to solve the problem stated in its unofficial tagline: <em>&#8220;Because WordPress is awesome, but the_loop isn&#8217;t.&#8221;</em></p>\n<p>Over the past four years, the open source project has evolved from being a starter theme to a plugin that can be added to existing themes. It is now used on <a href=\"http://upstatement.com/timber/#showcase\" target=\"_blank\">thousands of websites</a> and has 83 <a href=\"https://github.com/timber/timber/graphs/contributors\" target=\"_blank\">contributors</a> listed on GitHub.</p>\n<p>&#8220;In 2012 I was getting more into WordPress after doing lots of JS development with <a href=\"http://handlebarsjs.com/\" target=\"_blank\">Handlebars</a> (a JS templating language),&#8221; Timber creator Jared Novack said. &#8220;I went to WordCamp Providence to learn more about state-of-the-art WordPress ways. I remember thinking: &#8216;This is great, but I really miss the cleanliness of Handlebars &#8212; I wish someone would make something like that for WordPress.&#8217; That&#8217;s when I realized, I was that someone.&#8221;</p>\n<p>Novack was playing around with <a href=\"http://www.smarty.net/\" target=\"_blank\">Smarty</a> and <a href=\"https://mustache.github.io/\" target=\"_blank\">Mustache</a> before he finally discovered Fabien Potencier&#8217;s <a href=\"http://twig.sensiolabs.org/\" target=\"_blank\">Twig project</a>.</p>\n<p>&#8220;The syntax felt so natural I almost didn&#8217;t need to read the docs (don&#8217;t worry, I did),&#8221; he said. &#8220;I realized what I needed was a way to marry Twig and WordPress, and thus: Timber was born.&#8221;</p>\n<p>At that time Novack&#8217;s company, <a href=\"https://upstatement.com/\" target=\"_blank\">Upstatement</a>, was beginning development on a big new project for Random House to enable their marketers to generate unique sites from a library of templates. This client project became Timber&#8217;s first test case.</p>\n<p>&#8220;Originally, Timber was a parent theme, like _s. But after we completed the Random House project, I realized I wanted to apply Timber functionality to existing sites,&#8221; Novack said. &#8220;I converted it into a plugin that could be employed on existing themes which is the form it takes today.&#8221;</p>\n<p>The plugin allows designers skilled with HTML and CSS to create themes without having extensive knowledge of PHP and WordPress functions. Timber successfully powers sites like Michael Bloomberg&#8217;s <a href=\"https://www.thetrace.org/\" target=\"_blank\">The Trace</a>, <a href=\"http://everytown.org/\" target=\"_blank\">Everytown for Gun Safety</a>, <a href=\"https://www.hoteltonight.com/\" target=\"_blank\">Hotel Tonight</a>, and the <a href=\"http://harvardlawreview.org/\" target=\"_blank\">Harvard Law Review</a>.</p>\n<h3>Timber 1.0 Puts the Project on the Path of Stability</h3>\n<p>As of Timber 1.0, developers can now include the project as a plugin or require it as a <a href=\"https://packagist.org/packages/timber/timber\" target=\"_blank\">Composer dependency</a>.</p>\n<p>&#8220;The big news is that 1.0 represents a maturing of the platform — developers can use Timber and Twig with confidence that they’re building on top of a stable and universal platform,&#8221; Novack said.</p>\n<p>This release sheds years of deprecated functions and methods dating back to the project&#8217;s early days in 2013. Novack said that technical and documentation debt were the biggest hurdles in getting to 1.0.</p>\n<p>&#8220;In hindsight it’s so easy to build stuff, but so hard to build a complete system,&#8221; he said. &#8220;When Timber started it was just for me and the documentation could just live in my head. I’d add and improve stuff and then live with some of the quirks.&#8221;</p>\n<p>As the project and its contributors grew, Novack found it difficult to keep up with the growing codebase while running his company. Bringing it to a place of maturity with up-to-date automated testing and documentation took nearly a year.</p>\n<p>&#8220;Backwards compatibility was also a major challenge,&#8221; Novack said. &#8220;As ideas and new code got submitted, development slowed as every decision might have implications for existing users. We would deprecate features, but I was hesitant to remove things that I knew were mistakes, but that people were using.&#8221;</p>\n<p>Developers are encouraged to read the <a href=\"https://github.com/timber/timber/wiki/1.0-Upgrade-Guide\" target=\"_blank\">1.0 Upgrade Guide</a>, as there may be additional steps required depending on how Timber is being used. This release adds a few new features but the most important change is the bulk removal of older sections of the codebase. The upgrade guide outlines all of the object properties and static methods that will need to be updated so that nothing breaks. In the future, Timber-powered themes will be easier to maintain, with fewer quirks and better-documented features.</p>\n<p>&#8220;The key learning for me is that the ultimate &#8216;killer feature&#8217; is stability and predictability,&#8221; Novack said. &#8220;When everything is organized cleanly and developers can use the things that they would intuitively expect — that’s success.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 May 2016 17:52:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Post Status: WordPress Security — Draft podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=24378\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://poststatus.com/wordpress-security-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2296:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Joe Hoyle &#8212; the CTO of Human Made &#8212; and Brian Krogsgard.</p>\n<p><span>Security &#8212; in WordPress core, distributed plugins and themes, and in our custom code &#8212; is a constant battle. It’s important to be vigilant with our security practices, from the perspective of managing our websites and when writing code. In this episode, Joe and Brian discuss the nature of WordPress security, best practices for writing secure code, and dig into various situations WordPress developers and site owners may run into.</span></p>\n<a href=\"https://audio.simplecast.com/37301.mp3\">https://audio.simplecast.com/37301.mp3</a>\n<p><a href=\"http://audio.simplecast.com/37301.mp3\">Direct Download</a></p>\n<h3>Links</h3>\n<ul>\n<li><a href=\"http://codex.wordpress.org/Hardening_WordPress\">Hardening WordPress</a></li>\n<li><a href=\"https://wordpress.org/about/security/\">About WordPress Security</a></li>\n<li><a href=\"https://make.wordpress.org/themes/2015/05/19/a-guide-to-writing-secure-themes-part-1-introduction/\">A Guide to Writing Secure Themes</a></li>\n<li><a href=\"http://ben.lobaugh.net/uploads/writing-secure-plugins-and-themes/#/\">Writing Secure Plugins &amp; Themes</a> by Ben Lobaugh</li>\n<li><a href=\"https://codex.wordpress.org/Class_Reference/wpdb\">$wpdb</a></li>\n<li><a href=\"https://wpvulndb.com/\">WP Scan</a></li>\n<li><a href=\"https://blog.sucuri.net/2015/03/understanding-wordpress-plugin-vulnerabilities.html\">Understanding Vulnerabilities</a></li>\n</ul>\n<h3>Sponsor: Pagely</h3>\n<p><a href=\"https://pagely.com\"><span>Pagely</span></a><span> offers best in class managed WordPress hosting, powered by the Amazon Cloud, the Internet’s most reliable infrastructure. Post Status is proudly hosted by Pagely. Thank you to </span><a href=\"https://pagely.com\"><span>Pagely</span></a><span> for being a Post Status partner.</span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 May 2016 01:01:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Katie Richards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Apple and Podcasting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46548\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://ma.tt/2016/05/apple-and-podcasting/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:557:\"<p><a href=\"https://marco.org/2016/05/07/apple-role-in-podcasting\">Marco Arment has a great take on how the decentralized nature of podcasting is a feature</a>, not a bug, and Apple being more proactive there would be harmful to the ecosystem. As an aside, since I&#8217;ve been in Houston more recently, which means driving a lot, I&#8217;ve been really loving his app <a href=\"https://overcast.fm/\">Overcast</a> and I opted in to the optional paid subscription for it. I just need to get in more of a habit of listening to podcasts outside of Houston.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 08 May 2016 14:17:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"WPTavern: VersionPress 3.0 Adds New Search Feature, Bulk Undo, and Commit Tracking per Environment\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54530\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://wptavern.com/versionpress-3-0-adds-new-search-feature-bulk-undo-and-commit-tracking-per-environment\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3843:\"<p><a href=\"https://blog.versionpress.net/2016/04/versionpress-3-0-released/\" target=\"_blank\">VersionPress 3.0</a>, released this week, is the first version since the plugin <a href=\"http://wptavern.com/versionpress-transitions-into-a-free-open-source-project\" target=\"_blank\">became a free, open source project</a>. Creators Borek Bernard and Jan Voráček, who originally attempted to crowdfund the project and then <a href=\"http://wptavern.com/versionpress-raises-400k-in-seed-funding\" target=\"_blank\">raised $400,000 in seed funding</a>, <a href=\"http://wptavern.com/versionpress-transitions-into-a-free-open-source-project\" target=\"_blank\">announced</a> last month that they are transitioning to a public development model.</p>\n<p>The team&#8217;s goal with this release was to polish up the experience of using VersionPress in the default WordPress installation while adding more useful features. However, it is not yet ready for use in production, according to Bernard.</p>\n<p>&#8220;We’re still keeping VersionPress in the <a href=\"http://docs.versionpress.net/en/getting-started/about-eap\" target=\"_blank\">“early access” period</a>, because of the third party plugins integration story but on simpler sites, VersionPress already shines,&#8221; he said.</p>\n<p>One of the most notable new features in VersionPress 3.0 is the plugin&#8217;s ability to track commits with the environment where they were created. Users can view changes in the admin and easily see if they were pushed to the staging or production environment.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/commit-tracking-in-environment.gif\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/commit-tracking-in-environment.gif?resize=725%2C347\" alt=\"commit-tracking-in-environment\" class=\"aligncenter size-full wp-image-54599\" /></a></p>\n<p>Version 3.0 also adds searching capabilities for filtering commits by author, date, commit message, and WordPress action. This release also includes a new bulk undo feature for commits and many improvements to the core versioning engine.</p>\n<h3>VersionPress 4.0 to Focus on Support for 3rd Party Plugins</h3>\n<p>One of the reasons the VersionPress team decided to go with a public development model was to mitigate the plugin&#8217;s conflicts with third-party themes and plugins. This was only possible if the opened up the codebase for contribution from other developers.</p>\n<p>&#8220;While we had most of the WordPress core covered pretty well, there was still this huge ecosystem of WordPress plugins and themes that could cause trouble to VersionPress in million different ways,&#8221; Borek said. &#8220;In the long run, the project had to turn into OSS should it be successful, and, fortunately, we met investors who understood this and supported our vision.&#8221;</p>\n<p>Borek and the team plan to focus on adding support for complex third party plugins in version 4.0, tentatively scheduled for mid-2016. One commenter on the post mentioned that a lack of WooCommerce support is a major thing holding him back from using VersionPress on projects. Borek confirmed that WooCommerce is high on their list of plugins they want to support.</p>\n<p>&#8220;Our goal remains the same: to take all the incredibly powerful functionality of Git and package it so that every WordPress user can use it,&#8221; Borek said.</p>\n<p>Since most site owners interested in this plugin are not running vanilla installations of WordPress, support for third party plugins will be a major leap forward for the project with the potential to greatly expand its user base. Check out VersionPress&#8217; <a href=\"http://docs.versionpress.net/en/release-notes/roadmap\" target=\"_blank\">roadmap</a> to follow along with its progress and see what&#8217;s next.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 May 2016 22:04:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: WordPress 4.5.2 Patches Two Security Vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54594\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/wordpress-4-5-2-patches-two-security-vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1441:\"<p>The WordPress core team has <a href=\"https://wordpress.org/news/2016/05/wordpress-4-5-2/\">released WordPress 4.5.2</a> which patches two security vulnerabilities in WordPress versions 4.5.1 and below. The first is a <a href=\"http://www.benhayak.com/2015/06/same-origin-method-execution-some.html\">SOME vulnerability</a> (Same-Origin Method Execution) in Plupload, the third-party library WordPress uses for uploading files. The second is a reflected cross-site-scripting vulnerability in MediaElement.js, the third-party library used for media players.</p>\n<p>Auto updates are rolling out to sites but if you don&#8217;t want to wait, browse to Dashboard &gt; Updates and click the Update Now button. Mario Heiderich, Masato Kinugawa, and Filedescriptor of <a href=\"https://cure53.de/\">Cure53</a> are credited with <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsibly disclosing</a> the vulnerabilities.</p>\n<p>In addition to the release, the core team has <a href=\"https://make.wordpress.org/core/2016/05/06/imagemagick-vulnerability-information/\">published a post</a> concerning the <a href=\"https://imagetragick.com/\">multiple vulnerabilities</a> discovered in ImageMagick, a popular image processing script used on thousands of webhosting servers. The post describes how WordPress is affected and what the team is doing to mitigate issues.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 May 2016 20:01:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WPTavern: Laravel Releases Valet, a Minimalist Development Environment with Support for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54580\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://wptavern.com/laravel-releases-valet-a-minimalist-development-environment-with-support-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3404:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/valet-parking.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/valet-parking.jpg?resize=900%2C520\" alt=\"photo credit: Valet Parking, Las Vegas, NV - (license)\" class=\"size-full wp-image-54589\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/55151301@N00/175606346\">Valet Parking, Las Vegas, NV</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nd/2.0/\">(license)</a>\n<p><a href=\"https://laravel.com/\" target=\"_blank\">Laravel</a>, the open source MVC PHP framework created for application development, has just released <a href=\"https://laravel.com/docs/5.2/valet\" target=\"_blank\">Valet</a>, a minimalist development environment for Mac. It uses just 7mb of RAM, because it doesn&#8217;t include Vagrant, Apache, Nginx, or a /etc/hosts file. Here&#8217;s how it works:</p>\n<blockquote><p>Laravel Valet configures your Mac to always run PHP&#8217;s built-in web server in the background when your machine starts. Then, using DnsMasq, Valet proxies all requests on the *.dev domain to point to sites installed on your local machine.\n</p></blockquote>\n<p>Valet supports Laravel, Lumen, Statamic, Craft, Jigsaw, and even has a driver for WordPress. It&#8217;s handy if you just need a simple, fast development environment without virtualization. Developers can also share sites publicly via local tunnels. It&#8217;s as easy as navigating to the site&#8217;s directory in the terminal and running the <code>valet share</code> command, which generates a publicly accessible URL.</p>\n<p><a href=\"https://wppusher.com/\" target=\"_blank\">WP Pusher</a> founder Peter Suhm, who is active in both the Laravel and WordPress communities, wrote a <a href=\"http://blog.wppusher.com/a-minimalist-development-environment-for-wordpress-with-laravel-valet/\" target=\"_blank\">tutorial</a> for setting up Valet for WordPress development.</p>\n<p>&#8220;For larger apps, I generally prefer my development environment to be very similar to production,&#8221; Suhm said. &#8220;Vagrant and Docker are great for that. Valet is great for all those quick and dirty WordPress installations you need, just to test something or quickly work on an idea. If you don’t need anything else besides PHP 7 and a database, Valet is a great setup.&#8221;</p>\n<p>Since it doesn&#8217;t require a ton of dependencies, Valet is quick to set up and doesn&#8217;t require any configuration. Developers don&#8217;t even need to make Valet aware that their app is WordPress &#8211; you can simply drop WordPress core files into a folder on your machine and then access the site in your browser.</p>\n<p>If you&#8217;re looking for a new lightweight development environment or just a quick way to do some PHP 7 testing for WordPress plugins, Valet may fit nicely into your workflow. You can install it using <a href=\"http://brew.sh/\" target=\"_blank\">Homebrew</a>. View the <a href=\"https://laravel.com/docs/5.2/valet#installation\" target=\"_blank\">docs</a> for installation and site setup or follow along with Suhm&#8217;s <a href=\"http://blog.wppusher.com/a-minimalist-development-environment-for-wordpress-with-laravel-valet/\" target=\"_blank\">tutorial</a>.</p>\n<p>To see a quick demo of Valet in action, check out the two-minute introduction video created by Adam Wathan:</p>\n<div class=\"embed-wrap\"></div>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 May 2016 18:44:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: WordPress 4.6 to Drop Open Sans in the Admin in Favor of System Fonts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54507\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"http://wptavern.com/wordpress-4-6-to-drop-open-sans-in-the-admin-in-favor-of-system-fonts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2130:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/system-fonts-firefox-osx.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/system-fonts-firefox-osx.png?resize=1025%2C450\" alt=\"system-fonts-firefox-osx\" class=\"aligncenter size-full wp-image-54575\" /></a></p>\n<p>WordPress 4.6 will bid farewell to Open Sans in the admin in favor of using system fonts. Open Sans, which loads from Google Fonts as an external resource, has been in use in the admin since 2013.</p>\n<p>&#8220;At the time of introduction in 3.8, there were not good system fonts common to all platforms at the time,&#8221; WordPress lead developer <a href=\"http://helenhousandi.com/\" target=\"_blank\">Helen Hou-Sandí</a> said in her <a href=\"https://core.trac.wordpress.org/changeset/37361\" target=\"_blank\">commit</a> message. &#8220;In the years since, Windows, Android, OS X, iOS, Firefox OS, and various flavors of Linux have all gotten their own (good) system UI fonts.&#8221;</p>\n<p>Now that the admin doesn&#8217;t have to load fonts from Google, it should feel faster and will provide a better experience for developers who are working offline.</p>\n<p>Dropping Open Sans originated as part of the <a href=\"https://make.wordpress.org/core/features/font-natively/\" target=\"_blank\">Font Natively</a> feature project led by WordPress designer <a href=\"https://mattmiklic.com/\" target=\"_blank\">Matt Miklic</a>, Mark Uraine, and Helen Hou-Sandí. The project page provides screenshots for the WP admin with Open Sans in Firefox on OSX vs the admin with system fonts, but the team noted that they are in need of more screenshots from different environments.</p>\n<p>Anytime that WordPress can shed a third-party dependency while improving the experience in the admin is a win for everyone. The commit comes early in the release cycle in order to get more people testing for misalignments and any other issues. Feel free to report any bugs you experience with the change, as work is still ongoing on the <a href=\"https://core.trac.wordpress.org/ticket/36753\" target=\"_blank\">ticket</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 May 2016 20:50:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: Ninja Forms Update Patches Critical Security Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54556\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"http://wptavern.com/ninja-forms-update-patches-critical-security-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4325:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/03/NinjaFormsFeaturedImage.png\"><img class=\"aligncenter size-full wp-image-40019\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/03/NinjaFormsFeaturedImage.png?resize=840%2C273\" alt=\"Ninja Forms Featured Image\" /></a><a href=\"https://wordpress.org/plugins/ninja-forms/\">Ninja Forms</a>, a popular plugin active on more than 500K websites, released an update 48 hours ago that addresses a critical security vulnerability. Wordfence <a href=\"https://www.wordfence.com/blog/2016/05/ninja-forms-shell-upload-vulnerability-high-risk/\">is reporting</a> that Ninja Forms versions 2.9.36 to 2.9.42 contain multiple security vulnerabilities.</p>\n<p>One of the vulnerabilities allows an attacker to upload and execute code remotely on WordPress sites. The only information needed to exploit the vulnerability is the URL of the target site that&#8217;s using a form powered by an affected version of Ninja Forms.</p>\n<p>Kevin Stover, CTO of Ninja Forms, explains to the Tavern how they discovered the vulnerabilities:</p>\n<blockquote><p>About two weeks ago, we were contacted by a security researcher, James Golovich, regarding a file upload issue within Ninja Forms. He demonstrated that it was possible to upload an arbitrary file using some test code that hadn’t been removed during our build process.</p>\n<p>We realised that the test code had accidentally been utilised in other areas of the plugin, and we immediately began working on a fix. While the issue was being patched, we reached out to the devs at the <a href=\"http://wordpress.org/\" target=\"_blank\" rel=\"noreferrer\">WordPress.org</a> repo and began the processes of preparing for auto updating users of the affected versions.</p>\n<p>Once the patch had been tested, we pushed version 2.9.43 and .1 versions of 2.9.36 &#8211; 2.9.42. Shortly after, <a href=\"http://wordpress.org/\" target=\"_blank\" rel=\"noreferrer\">WordPress.org</a> began pushing out automatic updates.</p></blockquote>\n<p>As to why there wasn&#8217;t a post published immediately on the official <a href=\"https://ninjaforms.com/blog/\">Ninja Forms blog</a> announcing the update, &#8220;We didn’t want to go public with the vulnerability until our users had time to update, both to the newest version and the .1 versions,&#8221; Stover said.</p>\n<p>&#8220;James Golovich&#8217;s responsible disclosure gave us time to fix the issue and for our users to update to safe versions before disclosing the vulnerability on his site,&#8221; he said. The company has since <a href=\"https://ninjaforms.com/important-security-update-always-hurt-ones-love/\">published a blog post </a>concerning the update.</p>\n<p>Working with the WordPress security team, automatic updates started rolling out on Tuesday, May 3rd. If automatic plugin updates are disabled, you&#8217;re highly encouraged to update manually to 2.9.45 as soon as possible. The Ninja Forms team is also working with a number of large webhosts to ensure as many sites as possible are updated.</p>\n<p>Wordfence is not detecting wide-spread exploitation but this could change in the next few days as details of the exploit emerge.</p>\n<p>When it comes to security vulnerabilities, the ability to upload and execute code remotely is about as severe as it gets. Golovich is credited with <a href=\"http://www.pritect.net/blog/ninja-forms-2-9-42-critical-security-vulnerabilities\">responsibly disclosing</a> the vulnerability to the Ninja Forms team. He also provides technical details of each vulnerability, most of which are in the Ninja Forms 3.0 code base.</p>\n<p>According to Golovich, the most vulnerable code is a proof of concept:</p>\n<blockquote><p>The following vulnerable code was, according to Kyle Johnson of the WP Ninjas team &#8216;not a live feature of Ninja Forms, but was more of a proof of concept for a future free feature.&#8217; Unfortunately, even proof of concept code that is accessible is still vulnerable to attack. This is the most critical vulnerability here because it potentially allows an attacker to execute arbitrary php code on a site.</p></blockquote>\n<p>Users should update as soon as possible as it&#8217;s only a matter of time before tools are created that can easily take advantage of the exploit.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 May 2016 20:46:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: WordPress.org Support Forums Adds Accessibility Section\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54472\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wptavern.com/wordpress-org-support-forums-adds-accessibility-section\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3619:\"<p>Earlier this year, the WordPress project made a huge move by <a href=\"http://wptavern.com/wordpress-adopts-accessibility-coding-standards-for-all-new-and-updated-code\">adopting accessibility coding standards</a> for new and updated code. If you&#8217;re struggling to meet <a href=\"https://www.w3.org/WAI/intro/wcag\">WCAG 2.0 guidelines</a> in your WordPress projects and need help, check out the new <a href=\"https://wordpress.org/support/forum/accessibility\">Accessibility section</a> in the WordPress.org support forums.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/WPAccessibilitySupport.png\"><img class=\"size-full wp-image-54551\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/WPAccessibilitySupport.png?resize=1025%2C487\" alt=\"WordPress Accessibility Support\" /></a>WordPress Accessibility Support\n<p>Amanda Rush, who helps WordPress developers make their themes and plugins accessible, says the forum is the result of a conversation with a support team member at WordCamp Atlanta.</p>\n<p>&#8220;I <span class=\"message_body\">mentioned that part of what makes the job difficult when it comes to making WordPress accessible is stopping during our work to answer occasional questions.<br />\n</span></p>\n<p>&#8220;Most of the time the answer is not a quick one, because in the case of screen reader users, you have to first find out how well they can use their tech, how familiar they are with WordPress itself, and if neither of those chances are high, you spend time giving them a crash course in either one or both, and then answer their question,&#8221; <span class=\"message_body\">Rush said. </span></p>\n<p>Most of the people on the <a href=\"https://make.wordpress.org/accessibility/\">WordPress Accessibility team</a> are volunteers with full-time jobs which limits their ability to provide one-on-one support. Many of the support queries come through email or direct messages to individuals on the team. The forum enables everyone to participate in the support process.</p>\n<p>&#8220;If people ask their questions publicly, I or others not necessarily on the Accessibility Team can answer, and the answers are then public,&#8221; Rush said.</p>\n<p>&#8220;We have a pattern library on GitHub, which we all contribute to when we have time. But there are all kinds of solutions being passed around on Twitter and spread across other people&#8217;s GitHub accounts. So if someone asks a question like that, we can either point to something in specific cases, which is most of them, there&#8217;s probably already a specific solution that someone&#8217;s built, and we can link to that,&#8221; Rush told the Tavern.</p>\n<p>The accessibility support forum also comes with a side benefit, &#8220;W<span class=\"message_body\">e don&#8217;t have to say no all the time when people ask for support, or what looks like all the time to some people. Everyone can help each other </span><span class=\"message_body\">out and Google has a public resource,&#8221; Rush said.<br />\n</span></p>\n<p>The support forum comes at a time where accessibility is an increasingly important part of web development. For example, the European Union <a href=\"http://europa.eu/rapid/press-release_IP-16-1654_en.htm\">recently agreed to new rules</a> that will make public sector websites and apps more accessible.</p>\n<p>If you have any questions related to accessibility, you can post them on the forum. If you have experience and knowledge in the accessibility field, consider answering questions as it&#8217;s a great way to contribute to the WordPress project.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 May 2016 20:13:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"WPTavern: Font Awesome CDN Now in Beta, Loads Icons Asynchronously with Automatic Accessibility Best Practices\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"http://wptavern.com/font-awesome-cdn-now-in-beta-loads-icons-asynchronously-with-automatic-accessibility-best-practices\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2903:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/font-awesome.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/font-awesome.png?resize=1025%2C326\" alt=\"font-awesome\" class=\"aligncenter size-full wp-image-54532\" /></a></p>\n<p><a href=\"https://fortawesome.github.io/Font-Awesome/\" target=\"_blank\">Font Awesome</a>, the open source vector icon collection used by more than 300 plugins on WordPress.org and many free and commercial themes, <a href=\"https://articles.fortawesome.com/announcing-font-awesome-cdn-81773e0b301f#.egol888o7\" target=\"_blank\">announced the beta release of its new CDN</a>. Developers can now add a single line of code to bring the icons and CSS toolkit into their projects.</p>\n<p>The icon files and CSS are hosted by <a href=\"https://www.maxcdn.com/\" target=\"_blank\">MaxCDN</a>, which serves a cached version that loads quickly on websites that use Font Awesome. The CDN uses <a href=\"https://github.com/typekit/webfontloader\" target=\"_blank\">Web Font Loader</a>, which was co-developed by Google and Typekit, to load the icons asynchronously. This also gives developers <a href=\"https://github.com/typekit/webfontloader#events\" target=\"_blank\">CSS and JavaScript events</a> to hook into on loading.</p>\n<p><a href=\"http://wptavern.com/font-awesome-4-6-0-adds-new-accessibility-icons-category\" target=\"_blank\">FontAwesome 4.6 added a new accessibility icon category</a> and the new CDN helps to automate outputting the correct markup. If the icon you&#8217;re using has semantic meaning, including an accurate title attribute with the inline icon will trigger Font Awesome&#8217;s JS to do the rest.</p>\n<p>Font Awesome requires an email address from those want to use the CDN so it can issue a unique embed code for each. Developers also have the option to register a Font Awesome CDN account to keep track of sites and apps where they are using the icons, and manage multiple embed codes. Once logged in, you can enable or disable auto-accessibility, asynchronous icon loading, easy updates to newer Font Awesome versions, and CSS or JS embed.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/font-awesome-account.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/font-awesome-account.png?resize=1025%2C865\" alt=\"font-awesome-account\" class=\"aligncenter size-full wp-image-54543\" /></a></p>\n<p>One of the most convenient reasons to use the CDN is to simplify updates. WordPress plugin and theme developers do not have to bump versions or push any code to use the latest version. Font Awesome version changes can be triggered on an individual basis for each embed code in a developer&#8217;s account dashboard. Check out the instructions at <a href=\"https://cdn.fontawesome.com/\" target=\"_blank\">cdn.fontawesome.com</a> to get your project hooked up.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 May 2016 18:09:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WP Mobile Apps: WordPress for Android: Version 5.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://apps.wordpress.com/?p=3352\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://apps.wordpress.com/2016/05/05/wordpress-for-android-version-5-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3203:\"<p>Hello WordPress users! <a href=\"https://play.google.com/store/apps/details?id=org.wordpress.android\" target=\"_blank\">Version 5.3 of the WordPress for Android app</a> is now available in the Google Play Store.</p>\n<h1>Account Settings and App Settings</h1>\n<p>We split the old Account Settings into two distinct screens: Account Settings for everything related to your account, and App Settings for everything specific to the App, like the interface language, PIN lock, and Analytics opt-out.</p>\n<p><img class=\"alignnone size-full wp-image-3354\" src=\"https://apps.files.wordpress.com/2016/04/screenshot-2016-04-04_15-43-50-172.png?w=640\" alt=\"screenshot-2016-04-04_15.43.50.172\" /></p>\n<h1>Delete WordPress.com site</h1>\n<p>With 5.3, you can now export your content (posts, pages, and settings) by email and delete your WordPress.com site from the app.</p>\n<p><img class=\"alignnone size-full wp-image-3356\" src=\"https://apps.files.wordpress.com/2016/04/screenshot-2016-04-04_15-45-34-504.png?w=640\" alt=\"screenshot-2016-04-04_15.45.34.504\" /></p>\n<h1>Other Changes</h1>\n<p>Version 5.3 also comes with a few other enhancements:</p>\n<ul>\n<li>New styling of the action bar in the Reader.</li>\n<li>If you made changes to a post, you&#8217;ll see a confirmation blink on <strong>Blog Posts</strong> when returning to the <strong>My site</strong> screen.</li>\n<li>Better styling of the Post and Page Preview screen.</li>\n<li>An updated support tool reduces crashes.</li>\n</ul>\n\n<a href=\"https://apps.wordpress.com/2016/05/05/wordpress-for-android-version-5-3/screenshot-2016-04-04_15-59-35-639/\"><img width=\"84\" height=\"150\" src=\"https://apps.files.wordpress.com/2016/04/screenshot-2016-04-04_15-59-35-639.png?w=84&h=150\" class=\"attachment-thumbnail size-thumbnail\" alt=\"screenshot-2016-04-04_15.59.35.639\" /></a>\n<a href=\"https://apps.wordpress.com/2016/05/05/wordpress-for-android-version-5-3/screenshot-2016-04-04_16-01-41-971/\"><img width=\"84\" height=\"150\" src=\"https://apps.files.wordpress.com/2016/04/screenshot-2016-04-04_16-01-41-971.png?w=84&h=150\" class=\"attachment-thumbnail size-thumbnail\" alt=\"screenshot-2016-04-04_16.01.41.971\" /></a>\n\n<p>We&#8217;re working hard on new features for the next version &#8212; you can track our development progress for the next release by visiting <a href=\"https://github.com/wordpress-mobile/WordPress-Android/milestones/5.4\">our 5.4 milestone on GitHub</a>.</p>\n<h1>Thank you</h1>\n<p>Thanks to our contributors: <a href=\"https://github.com/aforcier\">@aforcier</a>, <a href=\"https://github.com/daniloercoli\">@daniloercoli</a>, <a href=\"https://github.com/hypest\">@hypest</a>, <a href=\"https://github.com/kwonye\">@kwonye</a>, <a href=\"https://github.com/maxme\">@maxme</a>, <a href=\"https://github.com/mzorz\">@mzorz</a>, <a href=\"https://github.com/nbradbury\">@nbradbury</a>, <a href=\"https://github.com/oguzkocer\">@oguzkocer</a>, <a href=\"https://github.com/rishabh7m\">@rishabh7m</a>, <a href=\"https://github.com/roundhill\">@roundhill</a>, and <a href=\"https://github.com/tonyr59h\">@tonyr59h</a>.</p><img alt=\"\" border=\"0\" src=\"https://pixel.wp.com/b.gif?host=apps.wordpress.com&blog=108068616&post=3352&subd=apps&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 May 2016 08:57:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Maxime\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: WPWeekly Episode 233 – Recap of WordCamp Chicago 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=54518&preview_id=54518\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"http://wptavern.com/wpweekly-episode-233-recap-of-wordcamp-chicago-2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2903:\"<p>On this episode of WordPress Weekly, I describe my experience attending WordCamp Chicago 2016 this past weekend. Marcus Couch and I then discuss the news of the week including a new tool that helps WordCamp organizers create customized name badges.</p>\n<p>We also have a lengthy discussion on the freemium business model and how it&#8217;s affecting users of themes and plugins downloaded from the official directories. Last but not least, we talk about WooCommerce Connect, a new SaaS tool from Automattic that has a tight relationship with Jetpack.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordcamp-organizers-get-new-tool-for-creating-personalized-wordcamp-badges\">WordCamp Organizers Get New Tool for Creating Personalized WordCamp Badges</a><br />\n<a href=\"http://wptavern.com/wordpress-is-now-100-translated-into-marathi\">WordPress is Now 100% Translated Into Marathi</a><br />\n<a href=\"http://wptavern.com/templatic-hacked-files-and-databases-compromised\">Templatic Hacked, Files and Databases Compromised</a><br />\n<a href=\"http://wptavern.com/wordpress-theme-review-team-votes-on-new-guidelines-to-ban-obtrusive-upselling\">WordPress Theme Review Team Votes on New Guidelines to Ban Obtrusive Upselling</a><br />\n<a href=\"http://wptavern.com/automattic-introduces-woocommerce-connect-hosted-components-for-e-commerce\">Automattic Introduces WooCommerce Connect, Hosted Components for E-Commerce</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/rss-feed-canceller/\">RSS Feed Canceller </a>provides more control over your RSS feed. You can turn it on or off per post and control whether or not a post is excluded from the feed.</p>\n<p><a href=\"https://wordpress.org/plugins/tld-woocommerce-downloadable-product-update-emails/\">TLD WooCommerce Downloadable Product Update Emails</a> is a simple plugin that notifies customers who purchased a downloadable product via email that there&#8217;s an update available.</p>\n<p><a href=\"https://wordpress.org/plugins/inline-click-to-tweet/\">Inline Click To Tweet</a> allows authors to highlight text from within the visual editor and make it tweetable by clicking within the post or page.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, May 11th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #233:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 May 2016 08:46:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WPTavern: WordCamp Chicago 2016 Was a Deep Dish of Fun\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54453\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://wptavern.com/wordcamp-chicago-2016-was-a-deep-dish-of-fun\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5547:\"<p><a href=\"https://2016.chicago.wordcamp.org/\">WordCamp Chicago 2016</a> was held at University Center in the heart of Chicago, IL, where more than 300 attendees spent the weekend learning about WordPress. The event was organized by Ryan Erwin and a <a href=\"https://2016.chicago.wordcamp.org/organizers/\">team of volunteers. </a></p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/JJJWCChicago2016.jpg\"><img class=\"size-full wp-image-54500\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/JJJWCChicago2016.jpg?resize=1024%2C768\" alt=\"John James Jacoby talking about bbPress and BuddyPress\" /></a>John James Jacoby talking about bbPress and BuddyPress\n<p>Tracks were split up into three separate rooms limiting the amount of background noise during sessions. Giving attendees a schedule is handled differently at most camps. Some provide a paper schedule while others put it on the back of the name badge.</p>\n<p>At WordCamp Chicago, schedule boards were displayed outside each room that corresponded with a track number. This made it easier for attendees to determine if they wanted to stay in the room for the next session.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/WCChicago2016Schedule.jpg\"><img class=\"size-full wp-image-54501\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/WCChicago2016Schedule.jpg?resize=1024%2C1365\" alt=\"Schedule Board Outside The Room Hosting Track 1\" /></a>Schedule Board Outside The Room Hosting Track 1\n<p>WordCamps are a great way to stress test a venue&#8217;s network but the WiFi at WordCamp Chicago was flawless. I didn&#8217;t experience any issues and it remained fast throughout the event. I didn&#8217;t stick around for lunch as there are plenty of lunch options available within walking distance of the venue.</p>\n<h2>The After Party</h2>\n<p>Most WordCamps host an after party at a restaurant, bar, or other establishment away from the venue. WordCamp Chicago&#8217;s after party was held at the venue. It included, non-alcoholic and alcoholic drinks, food, and card games on each table. It was fun mingling and networking with people without having to compete with blaring music or a loud atmosphere.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/WCChicago2016AfterParty.jpg\"><img class=\"size-full wp-image-54503\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/WCChicago2016AfterParty.jpg?resize=1024%2C768\" alt=\"WordCamp Chicago 2016 After Party\" /></a>WordCamp Chicago 2016 After Party\n<p>Out of all the sessions I attended, my favorite is <a href=\"https://2016.chicago.wordcamp.org/session/disastrous-deals-to-profitable-projects-comparing-my-best-and-worst-client-experiences/\">by Kyle Maurer,</a> who shared experiences and advice from <a href=\"http://realbigmarketing.com/\">building client websites</a> over the years.</p>\n<p>One of the biggest pieces of advice he shared is to build direct relationships with clients. No one is going to fight your battles as much as you and third-parties are unlikely to stick their neck out. Managing direct relationships leads to trust, referrals, and being rehired to do additional work.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/KyleMaurerSlideWCChicago2016.jpg\"><img class=\"size-full wp-image-54504\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/KyleMaurerSlideWCChicago2016.jpg?resize=1024%2C768\" alt=\"A Slide from Kyle Maurer\'s Presentation\" /></a>A Slide from Kyle Maurer&#8217;s Presentation\n<p>His session contains a lot of great information and I highly encourage you to watch it when it&#8217;s published on WordPress.tv.</p>\n<h2>WordCamps Offer a Lot of Value For The Price</h2>\n<p>Throughout the event, I spoke to a number of people and noted the following. Many attendees said they received more value than expected paying $40 a ticket. Some have spent hundreds of dollars on conference tickets and didn&#8217;t enjoy themselves or come away with nearly as much information.</p>\n<p>I discovered a number of attendees are part of one or more WordPress meetup groups. According to Meetup.com, there are at least <a href=\"http://www.meetup.com/find/?allMeetups=false&keywords=Chicago+WordPress&radius=25&userFreeform=chicago+I&mcId=c60601&change=yes&sort=recommended&eventFilter=mysugg\">four WordPress groups </a>with hundreds of members spread throughout the Chicago area. It&#8217;s a strong indication that the WordPress community in Chicago is thriving and supportive of each other.</p>\n<h2>WordCamp Chicago in 2017</h2>\n<p>It was a pleasure attending WordCamp Chicago and making new friends. I especially enjoyed speaking to WordPress Weekly listeners and getting their feedback. Also for those wondering, I satisfied my craving for deep-dish pizza via <a href=\"http://www.loumalnatis.com/arizona-phoenix\">Lou Malnati&#8217;s</a>. The pizza tastes better than I remembered. If you&#8217;re ever in the Chicago area, you have to try Lou Malnati&#8217;s pizza.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/TheLou.jpg\"><img class=\"size-full wp-image-54505\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/TheLou.jpg?resize=1024%2C768\" alt=\"The Lou!\" /></a>The Lou!\n<p>Everyone involved with WordCamp Chicago 2016 did a great job. If you didn&#8217;t get a chance to attend this year, don&#8217;t worry. After taking a break for a few weeks, the organizing team plans to begin organizing WordCamp Chicago 2017.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 May 2016 03:00:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Automattic Introduces WooCommerce Connect, Hosted Components for E-Commerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54476\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"http://wptavern.com/automattic-introduces-woocommerce-connect-hosted-components-for-e-commerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5426:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/woocommerce-logo.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/woocommerce-logo.png?resize=1025%2C466\" alt=\"woocommerce-logo\" class=\"aligncenter size-full wp-image-54492\" /></a></p>\n<p><a href=\"https://www.woothemes.com/woocommerce/\" target=\"_blank\">WooCommerce</a> is the current leader in e-commerce software, capturing <a href=\"https://wappalyzer.com/categories/ecommerce\" target=\"_blank\">31% of the market</a>, thanks to its relatively user-friendly interface and connection to WordPress. However, setting up a WooCommerce site, or any e-commerce site for that matter, is not for the faint of heart, no matter how user-friendly the software. It requires knowledge of hosting, PCI compliance, payment gateways, SSL certificates, shipping methods, tax, and more.</p>\n<p>When <a href=\"http://wptavern.com/automattic-acquires-woocommerce\" target=\"_blank\">Automattic acquired WooCommerce</a> last May, the company accepted the challenge to make it as easy to create stores online as WordPress.com has done for websites.</p>\n<p>“I believe that the web needs an open, independent and easy-to-use commerce platform that you can run yourself on your own website,” Matt Mullenweg said in his <a href=\"https://www.youtube.com/watch?v=xJOfTB8-daA\" target=\"_blank\">video</a> announcement of the acquisition.</p>\n<p>Automattic has been working to simplify selling with WooCommerce and today the company announced <a href=\"https://www.woothemes.com/2016/05/woocommerce-connect-announcement/\" target=\"_blank\">WooCommerce Connect</a>, the secret project that Mullenweg <a href=\"https://twitter.com/WooConf/status/717725650916741120\" target=\"_blank\">hinted</a> at during WooConf.</p>\n<p>WC Connect is WooCommerce&#8217;s new Automattic-hosted SaaS architecture that was created to offer store features in a more user-friendly way. It is built on the WP REST API and offers a simplified Calypso-style interface for configuring options.</p>\n<p>The first service offered via the alpha version of WC Connect is real-time USPS shipping rates for US-based stores. It eliminates the need for a USPS API key as well as a subscription key from WooCommerce. One of the advantages for the user is that there are fewer software updates to install for extensions, as all the code is maintained on Automattic&#8217;s servers.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/usps-wc-connect.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/usps-wc-connect.png?resize=650%2C362\" alt=\"usps-wc-connect\" class=\"aligncenter size-full wp-image-54493\" /></a></p>\n<h3>What&#8217;s Next for WooCommerce Connect?</h3>\n<p>If the testing goes well, WooCommerce plans to roll Connect into the plugin&#8217;s core to make it easier to serve more hosted e-commerce components. The team is also working on expanding shipping options for the beta.</p>\n<p>&#8220;In the near future we hope to integrate with further shipping services, most likely Canada Post next,&#8221; said WooThemes co-founder <a href=\"https://twitter.com/mark_forrester\" target=\"_blank\">Mark Forrester</a>. &#8220;Shipping and payment options seem the logical place for us to start.&#8221;</p>\n<p>Forrester confirmed that while the USPS shipping method is free, WooThemes is exploring monetizing other service offerings in the future. If WC Connect has a successful beta period, the team will consider using the same model for offering payment gateways in the future.</p>\n<p>&#8220;Setting up payments for your store should be simple and behind the scenes,&#8221; Forrester said. &#8220;We believe we can offer better options for our customers working closely with payment partners and using connected services.&#8221;</p>\n<p>Forrester said that the team hopes WC Connect can be baked into WooCommerce core soon, but they will make the decision based on user feedback from the alpha/beta period.</p>\n<p>Those who create WooCommerce extensions and depend on its ecosystem may be wondering whether the SaaS model will overtake the plugin entirely. Last May, during his WooCommerce Q&amp;A, Matt Mullenweg <a href=\"https://ma.tt/2015/05/woomattic/#comment-583541\" target=\"_blank\">confirmed</a> that Automattic is not moving towards a 100% SaaS model.</p>\n<p>&#8220;If or when we do SAAS, the plugin isn’t going away, it’ll continue as it has,&#8221; Mullenweg said.</p>\n<p>WooCommerce is not being rolled into Jetpack, as many suspected when Automattic acquired the product. However, WC Connect does require users to connect to WordPress.com via Jetpack.</p>\n<p>&#8220;We feel it makes sense to leverage the code/infrastructure of one of the most powerful WordPress connected services,&#8221; Forrester said.</p>\n<p>The team is aiming to make WC Connect a simpler way to connect services to online stores without users having to leave their WooCommerce dashboards. Many store owners would rather pay for hosted software they don&#8217;t have to update as opposed to self-hosted extensions that require regular maintenance.</p>\n<p>If the strategy of offering hosted e-commmerce components succeeds at making store management easier for non-developers, Automattic will be able to profit from offering compelling commercial WC Connect services, such as payment gateways, and expand WooCommerce&#8217;s global reach.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 May 2016 22:20:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: New Super Emoji Plus+ Plugin Adds an Elegant Emoji Picker to WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54422\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"http://wptavern.com/new-super-emoji-plus-plugin-adds-an-elegant-emoji-picker-to-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3082:\"<p>Last week when Beyoncé released her new Lemonade album, <a href=\"http://www.wired.com/2016/04/beyonce-lemonade-lemon-emoji/\" target=\"_blank\">lemon and bee emoji usage spiked on Twitter</a>. According to Twitter&#8217;s stats, during the month of April there were more than 2 million tweets that included at least one lemon emoji, 62% of which happened since the album release. The bee emoji, representing the Beyhive of Beyoncé fans, also found its way into 1.8 million tweets during April.</p>\n<p>There&#8217;s no denying that emoji permeate our culture and communication on the web, especially the mobile web. When people are excited, when they are communicating from the heart, they often use emoji. According to a study performed by emotional marketing platform Emogi last year, <a href=\"http://www.adweek.com/socialtimes/report-92-of-online-consumers-use-emoji-infographic/627521\" target=\"_blank\">92% of people online use emoji</a> and 63% of them are frequent users.</p>\n<p>Last year WordPress 4.2 <a href=\"http://wptavern.com/wordpress-4-2-on-track-to-expand-core-support-for-emoji\" target=\"_blank\">expanded core support for emoji</a>, adding along with it the ability to natively handle Chinese, Japanese, and Korean characters. This improvement came not a moment too soon, but emoji are still not readily accessible when publishing with WordPress until you launch the emoji keyboard for your operating system. There&#8217;s something disjointed about having to launch a separate keyboard when you&#8217;re trying to compose your thoughts.</p>\n<p><a href=\"https://wordpress.org/plugins/super-emoji-plus/\" target=\"_blank\">Super Emoji Plus+</a> is a new plugin that makes emoji more accessible. It was created by <a href=\"https://profiles.wordpress.org/ericlewis/\" target=\"_blank\">Eric Andrew Lewis</a>, a WordPress core contributor and developer at The New York Times. The plugin adds an elegant emoji picker to the post edit screen. It can be launched from the toolbar or via autocomplete when you start typing an emoji name, such as &#8220;:lemon&#8221;.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/super-emoji-toolbar.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/super-emoji-toolbar.png?resize=1025%2C640\" alt=\"super-emoji-toolbar\" class=\"aligncenter size-full wp-image-54458\" /></a></p>\n<p>If you use emoji in your WordPress posts, Super Emoji Plus+ provides convenient access to the full list. There&#8217;s no easier way to add emoji if you&#8217;re working from a desktop, as most emoji keyboard experiences are inferior to the one presented in this plugin. Having it installed removes the need for cheat sheets and saves you from having to remember the correct key combinations to launch an emoji keyboard. Super Emoji Plus+ <a href=\"https://ericandrewlewis.com/2016/04/super-emoji-plus-is-now-in-beta/\" target=\"_blank\">went into beta last week</a> and is now <a href=\"https://wordpress.org/plugins/super-emoji-plus/\" target=\"_blank\">available on WordPress.org</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 May 2016 06:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: bbPress 2.5.9 Patches Cross-Site-Scripting Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54439\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"http://wptavern.com/bbpress-2-5-9-patches-cross-site-scripting-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:945:\"<p>John James Jacoby, lead developer of bbPress, has <a href=\"https://bbpress.org/blog/2016/05/bbpress-2-5-9/\">released bbPress 2.5.9</a> to patch a security vulnerability, &#8220;bbPress 2.5.8 and below are susceptible to a cross-site-scripting vulnerability that&#8217;s due to the way users are linked to their profiles when they are mentioned in topics and replies,&#8221; Jacoby said.</p>\n<p>Marc-Alexandre Montpas is credited for <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsibly disclosing</a> the vulnerability to the WordPress security team. The patch has already been applied to bbPress 2.6, which is currently in development. Users are advised to update their bbPress installations as soon as possible. Users who encounter issues updating to 2.5.9 can report them to the <a href=\"https://bbpress.org/forums/\">bbPress support forums</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 May 2016 23:10:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 29 May 2016 23:39:55 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:14:\"content-length\";s:6:\"225327\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Sun, 29 May 2016 23:30:16 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";s:13:\"accept-ranges\";s:5:\"bytes\";}s:5:\"build\";s:14:\"20130911150210\";}',	'no'),
(129129,	'_site_transient_update_themes',	'O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1466112566;s:7:\"checked\";a:6:{s:8:\"platform\";s:5:\"1.4.4\";s:13:\"twentyfifteen\";s:3:\"1.4\";s:14:\"twentyfourteen\";s:3:\"1.6\";s:13:\"twentysixteen\";s:3:\"1.0\";s:9:\"twentyten\";s:3:\"2.1\";s:15:\"wp-themingstrap\";s:5:\"1.0.1\";}s:8:\"response\";a:3:{s:13:\"twentyfifteen\";a:4:{s:5:\"theme\";s:13:\"twentyfifteen\";s:11:\"new_version\";s:3:\"1.5\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentyfifteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentyfifteen.1.5.zip\";}s:14:\"twentyfourteen\";a:4:{s:5:\"theme\";s:14:\"twentyfourteen\";s:11:\"new_version\";s:3:\"1.7\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentyfourteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentyfourteen.1.7.zip\";}s:13:\"twentysixteen\";a:4:{s:5:\"theme\";s:13:\"twentysixteen\";s:11:\"new_version\";s:3:\"1.2\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentysixteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentysixteen.1.2.zip\";}}s:12:\"translations\";a:0:{}}',	'yes'),
(129130,	'_site_transient_update_plugins',	'O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1466112565;s:8:\"response\";a:9:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:6:\"3.1.11\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/akismet.3.1.11.zip\";}s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"520\";s:4:\"slug\";s:19:\"all-in-one-seo-pack\";s:6:\"plugin\";s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";s:11:\"new_version\";s:5:\"2.3.5\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/all-in-one-seo-pack/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/all-in-one-seo-pack.2.3.5.zip\";}s:42:\"auto-hyperlink-urls/autohyperlink-urls.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:2:\"27\";s:4:\"slug\";s:19:\"auto-hyperlink-urls\";s:6:\"plugin\";s:42:\"auto-hyperlink-urls/autohyperlink-urls.php\";s:11:\"new_version\";s:3:\"5.0\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/auto-hyperlink-urls/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/auto-hyperlink-urls.5.0.zip\";s:14:\"upgrade_notice\";s:235:\"Recommended major update: new features; improved handling; hardening; minor bug fixes; added unit tests; improved localization; verified compatibility through WP 4.4; minimum WP support now 4.1; updated copyright date (2016); and more.\";}s:31:\"bbcode-deluxe/bbcode-deluxe.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"63789\";s:4:\"slug\";s:13:\"bbcode-deluxe\";s:6:\"plugin\";s:31:\"bbcode-deluxe/bbcode-deluxe.php\";s:11:\"new_version\";s:10:\"2016.04.10\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/bbcode-deluxe/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/bbcode-deluxe.zip\";}s:37:\"disable-comments/disable-comments.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22847\";s:4:\"slug\";s:16:\"disable-comments\";s:6:\"plugin\";s:37:\"disable-comments/disable-comments.php\";s:11:\"new_version\";s:3:\"1.5\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/disable-comments/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/disable-comments.zip\";}s:25:\"menu-image/menu-image.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"41062\";s:4:\"slug\";s:10:\"menu-image\";s:6:\"plugin\";s:25:\"menu-image/menu-image.php\";s:11:\"new_version\";s:5:\"2.6.4\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/menu-image/\";s:7:\"package\";s:53:\"https://downloads.wordpress.org/plugin/menu-image.zip\";}s:35:\"responsive-menu/responsive-menu.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"48170\";s:4:\"slug\";s:15:\"responsive-menu\";s:6:\"plugin\";s:35:\"responsive-menu/responsive-menu.php\";s:11:\"new_version\";s:5:\"2.8.8\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/responsive-menu/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/responsive-menu.2.8.8.zip\";}s:33:\"ssh-sftp-updater-support/sftp.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"23801\";s:4:\"slug\";s:24:\"ssh-sftp-updater-support\";s:6:\"plugin\";s:33:\"ssh-sftp-updater-support/sftp.php\";s:11:\"new_version\";s:5:\"0.7.1\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/ssh-sftp-updater-support/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/ssh-sftp-updater-support.0.7.1.zip\";}s:29:\"wp-image-seo/wp-image-seo.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"36017\";s:4:\"slug\";s:12:\"wp-image-seo\";s:6:\"plugin\";s:29:\"wp-image-seo/wp-image-seo.php\";s:11:\"new_version\";s:5:\"1.1.3\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wp-image-seo/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/plugin/wp-image-seo.zip\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:12:{s:39:\"azurecurve-bbcode/azurecurve-bbcode.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"56791\";s:4:\"slug\";s:17:\"azurecurve-bbcode\";s:6:\"plugin\";s:39:\"azurecurve-bbcode/azurecurve-bbcode.php\";s:11:\"new_version\";s:5:\"1.0.0\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/azurecurve-bbcode/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/azurecurve-bbcode.1.0.0.zip\";}s:17:\"bbcode/bbcode.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"3479\";s:4:\"slug\";s:6:\"bbcode\";s:6:\"plugin\";s:17:\"bbcode/bbcode.php\";s:11:\"new_version\";s:5:\"1.0.1\";s:3:\"url\";s:37:\"https://wordpress.org/plugins/bbcode/\";s:7:\"package\";s:49:\"https://downloads.wordpress.org/plugin/bbcode.zip\";}s:49:\"delete-duplicate-posts/delete-duplicate-posts.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"10022\";s:4:\"slug\";s:22:\"delete-duplicate-posts\";s:6:\"plugin\";s:49:\"delete-duplicate-posts/delete-duplicate-posts.php\";s:11:\"new_version\";s:3:\"3.1\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/delete-duplicate-posts/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/delete-duplicate-posts.3.1.zip\";}s:33:\"duplicate-menu/duplicate-menu.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"33245\";s:4:\"slug\";s:14:\"duplicate-menu\";s:6:\"plugin\";s:33:\"duplicate-menu/duplicate-menu.php\";s:11:\"new_version\";s:3:\"0.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-menu/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/duplicate-menu.0.2.zip\";}s:47:\"facebook-auto-publish/facebook-auto-publish.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"43716\";s:4:\"slug\";s:21:\"facebook-auto-publish\";s:6:\"plugin\";s:47:\"facebook-auto-publish/facebook-auto-publish.php\";s:11:\"new_version\";s:5:\"1.2.4\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/facebook-auto-publish/\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/plugin/facebook-auto-publish.1.2.4.zip\";}s:31:\"infobarwp-pro/infobarwp-pro.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"40388\";s:4:\"slug\";s:9:\"infobarwp\";s:6:\"plugin\";s:31:\"infobarwp-pro/infobarwp-pro.php\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/infobarwp/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/infobarwp.1.0.zip\";}s:33:\"jc-pinterest-pin/pinterestpin.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"51079\";s:4:\"slug\";s:16:\"jc-pinterest-pin\";s:6:\"plugin\";s:33:\"jc-pinterest-pin/pinterestpin.php\";s:11:\"new_version\";s:5:\"1.0.1\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/jc-pinterest-pin/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/jc-pinterest-pin.zip\";}s:41:\"aryo-widget-device/aryo-widget-device.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"42821\";s:4:\"slug\";s:18:\"aryo-widget-device\";s:6:\"plugin\";s:41:\"aryo-widget-device/aryo-widget-device.php\";s:11:\"new_version\";s:5:\"1.1.0\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/aryo-widget-device/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/aryo-widget-device.1.1.0.zip\";}s:56:\"transposh-translation-filter-for-wordpress/transposh.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"6824\";s:4:\"slug\";s:42:\"transposh-translation-filter-for-wordpress\";s:6:\"plugin\";s:56:\"transposh-translation-filter-for-wordpress/transposh.php\";s:11:\"new_version\";s:5:\"0.9.6\";s:3:\"url\";s:73:\"https://wordpress.org/plugins/transposh-translation-filter-for-wordpress/\";s:7:\"package\";s:85:\"https://downloads.wordpress.org/plugin/transposh-translation-filter-for-wordpress.zip\";}s:33:\"w3-total-cache/w3-total-cache.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:4:\"9376\";s:4:\"slug\";s:14:\"w3-total-cache\";s:6:\"plugin\";s:33:\"w3-total-cache/w3-total-cache.php\";s:11:\"new_version\";s:7:\"0.9.4.1\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/w3-total-cache/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/w3-total-cache.0.9.4.1.zip\";s:14:\"upgrade_notice\";s:140:\"Thanks for using W3 Total Cache! This release includes important security updates designed to contribute to a secure WordPress installation.\";}s:25:\"affiliate/wp-referral.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"49518\";s:4:\"slug\";s:9:\"affiliate\";s:6:\"plugin\";s:25:\"affiliate/wp-referral.php\";s:11:\"new_version\";s:5:\"1.6.0\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/affiliate/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/affiliate.1.6.0.zip\";s:14:\"upgrade_notice\";s:169:\"This version has been tested for compatibility with WordPress 4.4, improves keyword substitution performance,enhances the user interface and adds an option for nofollow.\";}s:33:\"wp-delete-tags/wp-delete-tags.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"63136\";s:4:\"slug\";s:14:\"wp-delete-tags\";s:6:\"plugin\";s:33:\"wp-delete-tags/wp-delete-tags.php\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/wp-delete-tags/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/wp-delete-tags.zip\";}}}',	'yes'),
(3175,	'lpa_post_wordcut',	'Lettercut',	'yes'),
(3176,	'lpa_post_letters',	'300',	'yes'),
(3177,	'lpa_post_linktext',	'',	'yes'),
(3178,	'lpa_post_ending',	'',	'yes'),
(3179,	'lpa_post_home',	'on',	'yes'),
(3180,	'lpa_post_category',	'on',	'yes'),
(3181,	'lpa_post_archive',	'on',	'yes'),
(3182,	'lpa_post_search',	'on',	'yes'),
(3183,	'lpa_striptags',	'',	'yes'),
(113604,	'_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109',	'1464608397',	'no'),
(557,	'_transient_timeout_facebook_locale',	'1451521097',	'no'),
(558,	'_transient_facebook_locale',	'en_US',	'no'),
(559,	'widget_facebook-like',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(560,	'widget_facebook-send',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(561,	'widget_facebook-follow',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(562,	'widget_facebook-like-box',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(563,	'widget_facebook-recommendations',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(564,	'widget_facebook-activity-feed',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(630,	'widget_aktt-widget',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(726,	'wp_autopost_ver',	'2.8.6',	'yes'),
(446,	'widget_mo_openid_sharing_ver_wid',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(445,	'widget_mo_openid_login_wid',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(444,	'mo_openid_cust',	'0',	'yes'),
(447,	'widget_mo_openid_sharing_hor_wid',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(463,	'seo-friendly-images',	'a:1:{s:5:\"rules\";a:1:{i:0;a:2:{s:7:\"domains\";a:1:{i:0;s:3:\"all\";}s:7:\"options\";a:9:{s:3:\"alt\";s:6:\"%title\";s:5:\"title\";s:12:\"%title photo\";s:12:\"override_alt\";s:2:\"on\";s:14:\"override_title\";s:2:\"on\";s:21:\"strip_extension_title\";s:2:\"on\";s:22:\"attach_internal_images\";s:3:\"def\";s:22:\"attach_external_images\";s:3:\"def\";s:14:\"external_links\";s:2:\"on\";s:6:\"enable\";s:2:\"on\";}}}}',	'yes'),
(474,	'awesome_responsive_menu',	'a:4:{s:23:\"awesome_responsive_menu\";s:9:\"Main Menu\";s:13:\"menu_bg_color\";s:7:\"#ffffff\";s:15:\"menu_text_color\";s:7:\"#ffffff\";s:30:\"awesome_responsive_menu_effect\";s:1:\"1\";}',	'yes'),
(11695,	'_site_transient_update_core',	'O:8:\"stdClass\":4:{s:7:\"updates\";a:3:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.5.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.5.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.5.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.5.2-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.5.2\";s:7:\"version\";s:5:\"4.5.2\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":12:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.5.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.5.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.5.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.5.2-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.5.2\";s:7:\"version\";s:5:\"4.5.2\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";s:13:\"support_email\";s:26:\"updatehelp42@wordpress.org\";s:9:\"new_files\";s:1:\"1\";}i:2;O:8:\"stdClass\":12:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.4.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.4.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.4.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.4.3-new-bundled.zip\";s:7:\"partial\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.4.3-partial-1.zip\";s:8:\"rollback\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.4.3-rollback-1.zip\";}s:7:\"current\";s:5:\"4.4.3\";s:7:\"version\";s:5:\"4.4.3\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:5:\"4.4.1\";s:13:\"support_email\";s:26:\"updatehelp42@wordpress.org\";s:9:\"new_files\";s:0:\"\";}}s:12:\"last_checked\";i:1466112563;s:15:\"version_checked\";s:5:\"4.4.1\";s:12:\"translations\";a:0:{}}',	'yes'),
(811,	'external_updates-pinterest-auto',	'O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1451505371;s:14:\"checkedVersion\";s:5:\"4.0.5\";s:6:\"update\";O:8:\"stdClass\":6:{s:2:\"id\";i:0;s:4:\"slug\";s:14:\"pinterest-auto\";s:7:\"version\";s:5:\"4.0.6\";s:8:\"homepage\";s:90:\"http://codecanyon.net/item/pinterest-automatic-pin-wordpress-plugin/2203314?ref=ValvePress\";s:12:\"download_url\";s:93:\"http://deandev.com/upgrades/plugin_update.php?id=2203314&key=2b35dec65674314f5d8d9fe900dc03b8\";s:14:\"upgrade_notice\";s:68:\"Upgrade to the most recent version for new features and bug fixes...\";}}',	'yes'),
(571,	'facebook_og_action',	'1',	'yes'),
(576,	'xyz_credit_link',	'0',	'yes'),
(577,	'fbap_installed_date',	'1451436331',	'yes'),
(578,	'xyz_fbap_application_id',	'588832997935857',	'yes'),
(579,	'xyz_fbap_application_secret',	'3e0aed596a882c3502bff651bb9db9f1',	'yes'),
(580,	'xyz_fbap_fb_id',	'hotfile.pw',	'yes'),
(581,	'xyz_fbap_message',	'{POST_TITLE}{POST_CONTENT}',	'yes'),
(582,	'xyz_fbap_po_method',	'2',	'yes'),
(583,	'xyz_fbap_post_permission',	'1',	'yes'),
(584,	'xyz_fbap_current_appln_token',	'',	'yes'),
(585,	'xyz_fbap_af',	'0',	'yes'),
(586,	'xyz_fbap_pages_ids',	'-1',	'yes'),
(587,	'xyz_fbap_future_to_publish',	'1',	'yes'),
(588,	'xyz_fbap_apply_filters',	'',	'yes'),
(589,	'xyz_fbap_free_version',	'1.2.4',	'yes'),
(590,	'xyz_fbap_include_pages',	'0',	'yes'),
(591,	'xyz_fbap_include_posts',	'1',	'yes'),
(592,	'xyz_fbap_include_categories',	'All',	'yes'),
(593,	'xyz_fbap_include_customposttypes',	'',	'yes'),
(594,	'xyz_fbap_peer_verification',	'1',	'yes'),
(595,	'xyz_fbap_post_logs',	'a:5:{i:0;a:4:{s:6:\"postid\";i:58527;s:8:\"acc_type\";s:8:\"Facebook\";s:11:\"publishtime\";i:1466150343;s:6:\"status\";s:85:\"a:1:{s:5:\"/feed\";s:59:\"Error validating application. Application has been deleted.\";}\";}i:1;a:4:{s:6:\"postid\";i:58529;s:8:\"acc_type\";s:8:\"Facebook\";s:11:\"publishtime\";i:1466150476;s:6:\"status\";s:85:\"a:1:{s:5:\"/feed\";s:59:\"Error validating application. Application has been deleted.\";}\";}i:2;a:4:{s:6:\"postid\";i:58531;s:8:\"acc_type\";s:8:\"Facebook\";s:11:\"publishtime\";i:1466150602;s:6:\"status\";s:85:\"a:1:{s:5:\"/feed\";s:59:\"Error validating application. Application has been deleted.\";}\";}i:3;a:4:{s:6:\"postid\";i:58533;s:8:\"acc_type\";s:8:\"Facebook\";s:11:\"publishtime\";i:1466150730;s:6:\"status\";s:85:\"a:1:{s:5:\"/feed\";s:59:\"Error validating application. Application has been deleted.\";}\";}i:4;a:4:{s:6:\"postid\";i:58535;s:8:\"acc_type\";s:8:\"Facebook\";s:11:\"publishtime\";i:1466150858;s:6:\"status\";s:85:\"a:1:{s:5:\"/feed\";s:59:\"Error validating application. Application has been deleted.\";}\";}}',	'yes'),
(596,	'xyz_fbap_premium_version_ads',	'1',	'yes'),
(597,	'xyz_fbap_default_selection_edit',	'0',	'yes'),
(598,	'xyz_fbap_fb_token',	'CAAIXil2sivEBAJ0ZAdkiu3b8kG3IKd67uND51BOqwlK0ZBmYsE4WkTJRMAeE8bDVbLl8UWQQbZBCXx33oMuGUTwpACjnvUVkMSaYlDMdMDTTtg3GM23jU5XFQdE5kdOHHtrZCpnRDVE4bYWaBjtZBupgsZAwelt0bfqT4nyCEktDBoQ9WRFAZAbHzvjG3TONUF6aUE6QGKUcAZDZD',	'yes'),
(599,	'xyz_fbap_fb_numericid',	'',	'yes'),
(609,	'twap_installed_date',	'1451449459',	'yes'),
(11680,	'disable_comments_options',	'a:5:{s:19:\"disabled_post_types\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:10:\"attachment\";}s:17:\"remove_everywhere\";b:1;s:9:\"permanent\";b:1;s:16:\"extra_post_types\";b:0;s:10:\"db_version\";i:6;}',	'yes'),
(638,	'widget_ngfb-widget-buttons',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(680,	'wpt_server_string',	'<ul>\r\n				<li>Your server time:<br /><code>Wed, 30-Dec-15 04:49:26 UTC</code></li><li>Twitter\'s server time: <br /><code>Wed, 30-Dec-15 04:48:57 UTC</code></li>\r\n				<li>Your server timezone: UTC</li>\r\n				<li>Your time stamp matches the Twitter server time</li>\r\n				\r\n			</ul>',	'yes'),
(686,	'wtt_oauth_hash',	'285cc111787c572daaa788fe542dc762',	'yes'),
(687,	'jd_last_tweet',	'New post: Cockos Reaper 511 x86x64 Portable http://hotfile.pw/apps/cockos-reaper-511-x86x64-portable.html REAPER is a powerful but s',	'yes'),
(14792,	'_transient_timeout_feed_6c78d00722dae650afc8789333d5c38e',	'1452700465',	'no'),
(14793,	'_transient_feed_6c78d00722dae650afc8789333d5c38e',	'a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://pipes.yahoo.com/pipes/pipe.info?_id=02f556aa2f503be89aa9d89723644f40\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The fastest and most complete WordPress performance plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"http://pipes.yahoo.com/pipes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:5:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"medhaniehabte1 on &quot;Opting out of Object Caching for certain objects&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"http://feedproxy.google.com/~r/W3TOTALCACHE/~3/3ls41y0DNZI/opting-out-of-object-caching-for-certain-objects\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Thu, 01 Oct 2015 09:59:10 PDT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"7494075@http://wordpress.org/support/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:873:\"<p>Greetings, </p>\n<p>I am trying to determine a way in which the cache automatically clears when a page or specific object/plugin/application is updated in our Wordpress page. I ask because whenever, I update certain content, the changes do not appear, even when clearing browser cache. It is then that I have to empty the caches within W3TC. </p>\n<p>Is it possible to have the cache empty automatically whenever any object/page/data is updated? If not, then what steps can I take to assure that whenever a change is made, it automatically appears. For some pages, its fine, but for others not as much.</p>\n<p>Hope it helps.</p>\n<p><a rel=\"nofollow\" target=\"_blank\" href=\"https://wordpress.org/plugins/w3-total-cache/\">https://wordpress.org/plugins/w3-total-cache/</a>\n</p><img src=\"http://feeds.feedburner.com/~r/W3TOTALCACHE/~4/3ls41y0DNZI\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://wordpress.org/support/topic/opting-out-of-object-caching-for-certain-objects#post-7494075\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"Homika on &quot;Recently an error occurred while creating the CSS / JS minify cache&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"http://feedproxy.google.com/~r/W3TOTALCACHE/~3/u3ifsCU0gyU/recently-an-error-occurred-while-creating-the-css-js-minify-cache-10\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Wed, 30 Sep 2015 09:00:12 PDT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"7489392@http://wordpress.org/support/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:731:\"<p>I have exactly the same problem. \"admin-bar-button\" plugin was disabled and then deleted but I still get the following error: </p>\n<p>\"Recently an error occurred while creating the CSS / JS minify cache: File \"/home/enjoyyourcooking.com/wp-content/plugins/admin-bar-button/adminBar-front.css\" doesn\'t exist.\"</p>\n<p><a rel=\"nofollow\" target=\"_blank\" href=\"http://s14.postimg.org/743dgj31t/Screen_Shot_2015_09_30_at_11_56_06_AM.png\">Screenshot</a></p>\n<p>Tried flashing cache, playing with settings of W3 Total Cache. This file is not mentioned in any W3 Total Cache settings. Nothing helps. How can I get rid off this error?\n</p><img src=\"http://feeds.feedburner.com/~r/W3TOTALCACHE/~4/u3ifsCU0gyU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"https://wordpress.org/support/topic/recently-an-error-occurred-while-creating-the-css-js-minify-cache-10#post-7489392\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"Norbertjmx on &quot;How to configure W3 Total Cache and Cloudflare in a right way&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"http://feedproxy.google.com/~r/W3TOTALCACHE/~3/N1_dmRDg5sg/how-to-configure-w3-total-cache-and-cloudflare-in-a-right-way\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Wed, 30 Sep 2015 02:07:53 PDT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"7487666@http://wordpress.org/support/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:852:\"<p>Hey Rakesh,</p>\n<p>Have you checked out these tutorials on cloudflare? They might help you.</p>\n<p><a rel=\"nofollow\" target=\"_blank\" href=\"https://support.cloudflare.com/hc/en-us/articles/200169756-Can-I-use-WordPress-caching-plugins-like-Super-Cache-or-W3-Total-Cache-W3TC-with-CloudFlare-\">https://support.cloudflare.com/hc/en-us/articles/200169756-Can-I-use-WordPress-caching-plugins-like-Super-Cache-or-W3-Total-Cache-W3TC-with-CloudFlare-</a></p>\n<p><a rel=\"nofollow\" target=\"_blank\" href=\"https://support.cloudflare.com/hc/en-us/articles/200169546-What-fields-do-I-need-to-enter-in-W3TC-W3-Total-Cache-settings-\">https://support.cloudflare.com/hc/en-us/articles/200169546-What-fields-do-I-need-to-enter-in-W3TC-W3-Total-Cache-settings-</a>\n</p><img src=\"http://feeds.feedburner.com/~r/W3TOTALCACHE/~4/N1_dmRDg5sg\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://wordpress.org/support/topic/how-to-configure-w3-total-cache-and-cloudflare-in-a-right-way#post-7487666\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"mani04 on &quot;Internal Server Error, no access to most pages&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"http://feedproxy.google.com/~r/W3TOTALCACHE/~3/NR8NCo1KAr0/internatl-server-error-no-access-to-most-pages\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 29 Sep 2015 01:13:54 PDT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"7482801@http://wordpress.org/support/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:388:\"<p>My hosting provider checked the server again and found a problem. The permissions for the root directory were set wrong. Now my homepage works, but it displays no content. Also /wp-admin still doesn\'t work (internal server error).</p>\n<p>I\'m waiting for their reply to check again.\n</p><img src=\"http://feeds.feedburner.com/~r/W3TOTALCACHE/~4/NR8NCo1KAr0\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://wordpress.org/support/topic/internatl-server-error-no-access-to-most-pages#post-7482801\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"rakesh.mekaguda on &quot;How to configure W3 Total Cache and Cloudflare in a right way&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"http://feedproxy.google.com/~r/W3TOTALCACHE/~3/6b1YEF7T6Rc/how-to-configure-w3-total-cache-and-cloudflare-in-a-right-way\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Mon, 28 Sep 2015 12:15:00 PDT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"7480816@http://wordpress.org/support/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:310:\"<p>I found that using W3 Total Cache and Cloudfalre makes my website to load fast, tried the both but not seen any improvement. anyone suggest detailed  tutorial to configure W3 Total Cache with Cloudflare.\n</p><img src=\"http://feeds.feedburner.com/~r/W3TOTALCACHE/~4/6b1YEF7T6Rc\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://wordpress.org/support/topic/how-to-configure-w3-total-cache-and-cloudflare-in-a-right-way#post-7480816\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:4:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:40:\"http://feeds.feedburner.com/W3TOTALCACHE\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:4:\"next\";s:4:\"href\";s:93:\"http://pipes.yahoo.com/pipes/pipe.run?_id=02f556aa2f503be89aa9d89723644f40&_render=rss&page=2\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:40:\"http://feeds.feedburner.com/W3TOTALCACHE\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:4:\"info\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:12:\"w3totalcache\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:28:\"http://www.w3.org/1999/xhtml\";a:1:{s:4:\"meta\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"name\";s:6:\"robots\";s:7:\"content\";s:7:\"noindex\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:22:\"http://pipes.yahoo.com\";a:1:{s:4:\"meta\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"name\";s:5:\"pipes\";s:7:\"content\";s:9:\"noprocess\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:13:\"last-modified\";s:29:\"Wed, 13 Jan 2016 03:46:04 GMT\";s:4:\"date\";s:29:\"Wed, 13 Jan 2016 03:53:21 GMT\";s:7:\"expires\";s:29:\"Wed, 13 Jan 2016 03:53:21 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";s:13:\"accept-ranges\";s:4:\"none\";s:4:\"vary\";s:15:\"Accept-Encoding\";}s:5:\"build\";s:14:\"20130911040210\";}',	'no'),
(688,	'wpt_promotion_scheduled',	'1',	'yes'),
(690,	'_transient_timeout__wpt_twit_instant',	'1466150869',	'no'),
(691,	'_transient__wpt_twit_instant',	'58535',	'no'),
(692,	'_transient_timeout__wpt_most_recent_tweet_1290',	'1451451114',	'no'),
(693,	'_transient__wpt_most_recent_tweet_1290',	'1',	'no'),
(694,	'_transient_timeout__wpt_most_recent_tweet_1288',	'1451451127',	'no'),
(695,	'_transient__wpt_most_recent_tweet_1288',	'1',	'no'),
(696,	'_transient_timeout__wpt_most_recent_tweet_1292',	'1451451244',	'no'),
(697,	'_transient__wpt_most_recent_tweet_1292',	'1',	'no'),
(719,	'_transient_timeout__wpt_most_recent_tweet_1308',	'1451452411',	'no'),
(700,	'_transient_timeout__wpt_most_recent_tweet_1294',	'1451451375',	'no'),
(701,	'_transient__wpt_most_recent_tweet_1294',	'1',	'no'),
(702,	'_transient_timeout__wpt_most_recent_tweet_1296',	'1451451505',	'no'),
(703,	'_transient__wpt_most_recent_tweet_1296',	'1',	'no'),
(704,	'_transient_timeout__wpt_most_recent_tweet_1298',	'1451451636',	'no'),
(705,	'_transient__wpt_most_recent_tweet_1298',	'1',	'no'),
(718,	'microblogposter_who_can_auto_publish',	'[\"administrator\",\"editor\",\"author\",\"contributor\",\"subscriber\"]',	'yes'),
(721,	'_transient_timeout__wpt_most_recent_tweet_1310',	'1451452431',	'no'),
(722,	'_transient__wpt_most_recent_tweet_1310',	'1',	'no'),
(813,	'wp_pinterest_automatic_version_updated',	'1451545502',	'yes'),
(814,	'wp_pinterest_last_run',	'1451545231',	'yes'),
(815,	'wp_pinterest_next_interval',	'4',	'yes'),
(816,	'wp_pinterest_p',	'',	'yes'),
(2403,	'_site_transient_timeout_available_translations',	'1451584491',	'yes'),
(2404,	'_site_transient_available_translations',	'a:72:{s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-30 08:58:25\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-12 10:15:45\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/4.4/ary.zip\";s:3:\"iso\";a:2:{i:1;s:5:\"ar_MA\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 20:53:51\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 08:50:29\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:22:\"Продължение\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-16 05:09:40\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-18 21:20:44\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 16:27:03\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 16:20:56\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 22:48:20\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 14:19:21\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-29 08:36:14\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/4.4/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-29 08:35:52\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-30 01:21:40\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 13:34:17\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-15 11:52:35\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 04:39:48\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-06 23:10:59\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 10:23:11\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 12:35:15\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 13:19:37\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:6:\"4.3-RC\";s:7:\"updated\";s:19:\"2015-08-04 06:10:33\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.3-RC/es_CO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"4.2.5\";s:7:\"updated\";s:19:\"2015-10-29 16:32:18\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.5/es_VE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-23 00:46:01\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/es_AR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 17:35:10\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-29 19:19:47\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-19 14:33:57\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 05:14:35\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 21:19:15\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-20 13:36:08\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-23 06:49:15\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 13:47:35\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 02:16:19\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-22 14:45:38\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-24 15:25:30\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-12 11:44:09\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.1.8\";s:7:\"updated\";s:19:\"2015-03-26 15:20:27\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.8/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 18:10:01\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"להמשיך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 05:11:43\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 22:05:31\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-12 18:07:25\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Tovább\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-17 13:36:47\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-21 16:17:50\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 00:20:24\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-21 08:04:30\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-25 07:46:19\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 07:35:25\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 20:07:24\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-15 05:49:00\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:5:\"4.1.8\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.8/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ေဆာင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 10:01:09\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-26 12:41:06\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-14 12:19:44\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.3-RC\";s:7:\"updated\";s:19:\"2015-08-02 07:53:33\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.3-RC/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-19 13:20:56\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:5:\"4.1.8\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.8/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"دوام\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-10 18:05:56\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-30 22:40:18\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 18:41:28\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-11 16:33:02\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-30 10:37:54\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-06 16:10:24\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Nadaljujte\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 09:13:24\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 09:09:51\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 23:28:56\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 03:22:55\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-20 03:52:15\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-17 23:12:27\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.1.8\";s:7:\"updated\";s:19:\"2015-03-26 16:45:38\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.8/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:7:\"4.4-RC1\";s:7:\"updated\";s:19:\"2015-12-04 10:22:09\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4-RC1/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-11-27 09:19:03\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-11 18:51:41\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-12 22:55:08\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}',	'yes'),
(728,	'wptp_post_types',	'a:2:{s:4:\"post\";a:4:{s:21:\"post-published-update\";s:1:\"1\";s:19:\"post-published-text\";s:13:\"#title# #url#\";s:18:\"post-edited-update\";s:1:\"1\";s:16:\"post-edited-text\";s:13:\"#title# #url#\";}s:4:\"page\";a:4:{s:21:\"post-published-update\";s:0:\"\";s:19:\"post-published-text\";s:29:\"New page added: #title# #url#\";s:18:\"post-edited-update\";s:0:\"\";s:16:\"post-edited-text\";s:26:\"Page edited: #title# #url#\";}}',	'yes'),
(729,	'wptp_url_stripper',	'',	'yes'),
(730,	'wptp_remove_noalphnum',	'0',	'yes'),
(731,	'wptp_max_num_tags',	'3',	'yes'),
(732,	'wptp_max_chars_disp',	'15',	'yes'),
(733,	'wptp_replace_chars_disp',	'',	'yes'),
(734,	'wtt_show_custom_tweet',	'administrator',	'yes'),
(735,	'wptp_tweet_remote',	'0',	'yes'),
(736,	'wptp_excerpt_post',	'30',	'yes'),
(737,	'wptp_dynamic_analytics',	'0',	'yes'),
(738,	'wptp_use_dynamic_analytics',	'category',	'yes'),
(739,	'wptp_tweet_custom_link',	'tweet_link',	'yes'),
(741,	'wptp_send_tweet_default',	'0',	'yes'),
(742,	'wptp_tweet_edit_action',	'0',	'yes'),
(743,	'wptp_post_quick_updates',	'0',	'yes'),
(744,	'twitterconnected',	'1',	'yes'),
(745,	'wptp_keyword_format_config',	'0',	'yes'),
(746,	'wptp_last_tweet_msg',	'WinToUSB Enterprise 29 Multilingual http://hotfile.pw/apps/wintousb-enterprise-29-multilingual.html?utm_campaign=&utm_medium=twitter&utm_source=twitter',	'yes'),
(747,	'wptp_status_notifier_last',	'a:2:{i:0;i:58535;i:1;s:71:\"401 Unauthorized: Authentication credentials were missing or incorrect.\";}',	'yes'),
(812,	'wp_pinterest_automatic_version_last',	'4.0.6\n',	'yes'),
(754,	'atap_settings',	'a:10:{s:12:\"auto_publish\";s:1:\"1\";s:7:\"api_key\";s:25:\"H9dBx5FT9dqVOYkxOiY5e5Ewz\";s:10:\"api_secret\";s:50:\"O4KssnIjFtEbGcbkGobFd1vFnpOZCPgOaQo3tDg0j6XPfXilPV\";s:12:\"access_token\";s:50:\"4675176744-mQLxbbO0gsQbiFygXUzOrBoBvTMqkK4nXC1AZ6O\";s:19:\"access_token_secret\";s:45:\"xN8BRHYDuDMtxpng3g1wamlCwv0ZyjAUHZUTRnsdUCEgE\";s:14:\"message_format\";s:36:\"#post_title #post_link #post_content\";s:14:\"bitly_username\";s:0:\"\";s:13:\"bitly_api_key\";s:0:\"\";s:10:\"post_types\";a:1:{i:0;s:4:\"post\";}s:8:\"category\";a:1:{i:0;s:3:\"all\";}}',	'yes'),
(757,	'smap_installed_date',	'1451453702',	'yes'),
(797,	'xyz_smap_fb_token',	'CAAIXil2sivEBAPgImw6kVbu1JoovN1JXdeNWIDdu5kE13qi19DyBm6XUzlBK9F6fxWtq2ArcbVc9YGgADvcOhhzP9TZC3LhdinTAtuSMdZBxuUBOo4wJauJ77FDAkmA6Mfh22ylAmsHkY8sZBJSVXmy1EcZCJAZCMZCX5z3yxIueyA5mALZAAbplKBXj1PmljruYhtrYwxYZAAZDZD',	'yes'),
(798,	'xyz_smap_fb_numericid',	'',	'yes'),
(653,	'widget_wpt-latest-tweets',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(654,	'widget_wpt-search-tweets',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(668,	'no-analytics',	'1',	'yes'),
(677,	'wtt_user_permissions',	'administrator',	'yes'),
(678,	'wpt_can_tweet',	'contributor',	'yes'),
(800,	'wp_url_failure',	'0',	'yes'),
(801,	'newlink-published-text',	'',	'yes'),
(802,	'jd_twit_blogroll',	'',	'yes'),
(803,	'app_consumer_key',	'H9dBx5FT9dqVOYkxOiY5e5Ewz',	'yes'),
(804,	'app_consumer_secret',	'O4KssnIjFtEbGcbkGobFd1vFnpOZCPgOaQo3tDg0j6XPfXilPV',	'yes'),
(805,	'oauth_token',	'4675176744-mQLxbbO0gsQbiFygXUzOrBoBvTMqkK4nXC1AZ6O',	'yes'),
(806,	'oauth_token_secret',	'xN8BRHYDuDMtxpng3g1wamlCwv0ZyjAUHZUTRnsdUCEgE',	'yes'),
(807,	'wptp_api_twitter_user_name',	'hotfile_pw',	'yes'),
(820,	'wp_pinterest_automatic_username',	'hotfile2909',	'yes'),
(821,	'wp_pinterest_automatic_session',	'TWc9PSZBZ3U4QVNiWXJEWitDRTRXSTlWUU45eUdqeUpTY09WL1ZBdnNQWHdReGc1VU5hbWpMNThpbVZRUmlSRWJiSGZqdllJdHphWjE3eHgzWDIzdVYxOTcrTDd6cWk0UEQvZ0UvMVNIajFqTUN4TXExSUZmbnh4M0N1K3k0VnlVZnlscjk4Yk1ZQm9MbU5zOEpYaUI1WXNsZ0pNMC9mcGtsMENTMVd2UVJVeEZqc0czdk44Q0VDOENTM05STE9NN1VKQ1JhWWlzTGx3aU84TmxTSnFFRjUzd3lObmNSWlp0dVdUeGtIbW5ZOHRWY2VPcjlPditucmxGUU5RWW9idzRidjVhQVYrbEN2UlBla2NraGNkVG50U0cxZ0t1WWt5bnYwVjgrREtOZnFiTjRMZkhhc0FkQnN6eWRhTlYwL0FQb2NCSy9tcFRFVUVIRERWQ3Jkb1VlYXNmZWRoQTU4NmppZ2FHeTVPbG8rcHJPMlZKS0Qwd2lmVk1mSFRvMjJ3ZThGa0p3WlZaK2RJWnJ6MmVZc29LaTZOYzVueXVIS2FGNW04U0FNZlZFNW5WQVBvaTRFU0ppM09Db0ExSytDQ2VtMEU5NFpwTXNnbmJ5L2luS3UyOHNCczh2cWJkUE9nRURPR2hHcmRlZ0lBV2xEYz0mbElkVU95K1NpNy8yZnJscjZyeTNjTFhVMTh3PQ==',	'yes'),
(822,	'wp_pinterest_boards',	'a:2:{s:3:\"ids\";a:1:{i:0;s:18:\"487303690869683346\";}s:6:\"titles\";a:1:{i:0;s:9:\"Downloads\";}}',	'yes'),
(826,	'wp_pinterest_user',	'admin@hotfile.pw',	'yes'),
(827,	'wp_pinterest_pass',	'123456f',	'yes'),
(828,	'wp_pinterest_board',	'487303690869683346',	'yes'),
(829,	'wp_pinterest_default',	'{Downloads|GET|free} [post_title]',	'yes'),
(830,	'wp_pinterest_default_more',	'Check more at [post_link]',	'yes'),
(831,	'wp_pinterest_options',	'a:5:{i:0;s:7:\"OPT_PIN\";i:1;s:9:\"OPT_CHECK\";i:2;s:7:\"OPT_BOT\";i:3;s:9:\"OPT_FRONT\";i:4;s:14:\"OPT_QUEUE_ONLY\";}',	'yes'),
(832,	'wp_pinterest_types',	'a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}',	'yes'),
(833,	'wp_pinterest_automatic_wordpress_tags',	'a:1:{i:0;s:0:\"\";}',	'yes'),
(834,	'wp_pinterest_automatic_wordpress_category',	'a:1:{i:0;s:2:\"20\";}',	'yes'),
(835,	'wp_pinterest_automatic_pinterest_category',	'a:1:{i:0;s:18:\"487303690869683346\";}',	'yes'),
(836,	'wp_pinterest_proxies',	'',	'yes'),
(837,	'wp_pinterest_automatic_cf',	'',	'yes'),
(838,	'wp_pinterest_automatic_selector',	'',	'yes'),
(839,	'wp_pinterest_automatic_tax',	'category,product_cat',	'yes'),
(840,	'wp_pinterest_automatic_tax_tags',	'post_tag,product_tag',	'yes'),
(841,	'wp_pinterest_automatic_excerpt',	'150',	'yes'),
(842,	'wp_pinterest_search_replace',	'',	'yes'),
(843,	'wp_pinterest_search_replace_txt',	'',	'yes'),
(844,	'wp_pinterest_automatic_interval_min',	'3',	'yes'),
(845,	'wp_pinterest_automatic_interval_max',	'5',	'yes'),
(846,	'wp_pinterest_automatic_interval_from_h',	'00',	'yes'),
(847,	'wp_pinterest_automatic_interval_from_m',	'00',	'yes'),
(848,	'wp_pinterest_automatic_interval_to_h',	'23',	'yes'),
(849,	'wp_pinterest_automatic_interval_to_m',	'59',	'yes'),
(850,	'wp_pinterest_automatic_interval_clear',	'7',	'yes'),
(851,	'save',	'Save Changes',	'yes'),
(857,	'wp_twitter_failure',	'1',	'yes'),
(860,	'wp_pinterest_automatic_pinterest_tags',	'a:1:{i:0;s:18:\"487303690869683346\";}',	'yes'),
(884,	'wp_automatic_last_pin_url',	'http://pinterest.com/pin/487303622160388901',	'yes'),
(885,	'wp_automatic_last_pin_src',	'http://i76.fastpic.ru/big/2015/1228/40/df5645c81506b9a40939e266ea92c840.jpg',	'yes'),
(896,	'wpi_status',	'1',	'yes'),
(897,	'wpi_tags',	'0',	'yes'),
(898,	'wpi_homepage',	'0',	'yes'),
(899,	'wpi_auth',	'0',	'yes'),
(900,	'wpi_rss',	'1',	'yes'),
(901,	'wpi_check',	'0',	'yes'),
(902,	'wpi_relatedposts',	'0',	'yes'),
(903,	'wpi_ping',	'1',	'yes'),
(905,	'wpi_num_tags_today',	'0',	'yes'),
(906,	'wpi_last_bulk_ping',	'1458891498',	'yes'),
(1719,	'wpi_num_pings_today',	'0',	'yes'),
(1720,	'wpi_num_links_today',	'0',	'yes'),
(2341,	'twp_queue_status',	'paused',	'yes'),
(2342,	'twp_settings_options',	'a:4:{s:9:\"post_type\";a:1:{i:0;s:4:\"post\";}s:14:\"queue_new_post\";i:0;s:10:\"tweet_text\";s:19:\"{{TITLE}} - {{URL}}\";s:4:\"loop\";i:1;}',	'yes'),
(2343,	'twp_db_version',	'1.0',	'yes'),
(2345,	'twp_refresh_tokens',	'2',	'yes'),
(2346,	'twp_stats_truncated',	'1',	'yes'),
(122683,	'_transient_timeout_w3tc.verify_plugins',	'1466342519',	'no'),
(122684,	'_transient_w3tc.verify_plugins',	'1',	'no'),
(122685,	'wptp_auth_missing',	'',	'yes'),
(129759,	'_transient_doing_cron',	'1466150859.3190050125122070312500',	'yes');

DROP TABLE IF EXISTS `wp_pingoo_payed_referrals`;
CREATE TABLE `wp_pingoo_payed_referrals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_email` varchar(255) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  `referral_id` int(11) NOT NULL,
  `payment_id` int(11) NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `wp_pingoo_payments`;
CREATE TABLE `wp_pingoo_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `ammount` decimal(10,0) NOT NULL,
  `currency` varchar(3) NOT NULL,
  `sent_to_paypal` int(11) NOT NULL,
  `status` varchar(255) NOT NULL,
  `paypal_response` longtext NOT NULL,
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `wp_postmeta`;
CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `wp_postmeta` (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(1,	2,	'_wp_page_template',	'default'),
(24,	15,	'_oembed_62f5dcfdbdffc65a2f3b3bc57a16d6fa',	'{{unknown}}'),
(18,	15,	'_edit_last',	'1'),
(22,	15,	'_oembed_26b869790ce990a92e9d6b2f8b1e765c',	'{{unknown}}'),
(21,	15,	'_edit_lock',	'1451293875:1'),
(23,	15,	'_oembed_c922ca49b0768ceb0903f1d38d7d7f4f',	'{{unknown}}'),
(8,	7,	'the_box_icon',	'http://hotfile.pw/wp-content/themes/platform/images/fbox1.png'),
(9,	8,	'the_box_icon',	'http://hotfile.pw/wp-content/themes/platform/images/fbox2.png'),
(10,	9,	'the_box_icon',	'http://hotfile.pw/wp-content/themes/platform/images/fbox3.png'),
(15,	12,	'_wp_attached_file',	'2015/12/favicon.jpg'),
(16,	13,	'_wp_attached_file',	'2015/12/15.png'),
(17,	13,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:16;s:6:\"height\";i:16;s:4:\"file\";s:14:\"2015/12/15.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(25,	17,	'_menu_item_type',	'taxonomy'),
(26,	17,	'_menu_item_menu_item_parent',	'0'),
(27,	17,	'_menu_item_object_id',	'3'),
(28,	17,	'_menu_item_object',	'category'),
(29,	17,	'_menu_item_target',	''),
(30,	17,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(31,	17,	'_menu_item_xfn',	''),
(32,	17,	'_menu_item_url',	''),
(34,	18,	'_menu_item_type',	'taxonomy'),
(35,	18,	'_menu_item_menu_item_parent',	'0'),
(36,	18,	'_menu_item_object_id',	'6'),
(37,	18,	'_menu_item_object',	'category'),
(38,	18,	'_menu_item_target',	''),
(39,	18,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(40,	18,	'_menu_item_xfn',	''),
(41,	18,	'_menu_item_url',	''),
(43,	19,	'_menu_item_type',	'taxonomy'),
(44,	19,	'_menu_item_menu_item_parent',	'0'),
(45,	19,	'_menu_item_object_id',	'12'),
(46,	19,	'_menu_item_object',	'category'),
(47,	19,	'_menu_item_target',	''),
(48,	19,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(49,	19,	'_menu_item_xfn',	''),
(50,	19,	'_menu_item_url',	''),
(52,	20,	'_menu_item_type',	'taxonomy'),
(53,	20,	'_menu_item_menu_item_parent',	'0'),
(54,	20,	'_menu_item_object_id',	'14'),
(55,	20,	'_menu_item_object',	'category'),
(56,	20,	'_menu_item_target',	''),
(57,	20,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(58,	20,	'_menu_item_xfn',	''),
(59,	20,	'_menu_item_url',	''),
(61,	21,	'_menu_item_type',	'taxonomy'),
(62,	21,	'_menu_item_menu_item_parent',	'0'),
(63,	21,	'_menu_item_object_id',	'5'),
(64,	21,	'_menu_item_object',	'category'),
(65,	21,	'_menu_item_target',	''),
(66,	21,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(67,	21,	'_menu_item_xfn',	''),
(68,	21,	'_menu_item_url',	''),
(70,	22,	'_menu_item_type',	'taxonomy'),
(71,	22,	'_menu_item_menu_item_parent',	'0'),
(72,	22,	'_menu_item_object_id',	'1'),
(73,	22,	'_menu_item_object',	'category'),
(74,	22,	'_menu_item_target',	''),
(75,	22,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(76,	22,	'_menu_item_xfn',	''),
(77,	22,	'_menu_item_url',	''),
(79,	23,	'_menu_item_type',	'taxonomy'),
(80,	23,	'_menu_item_menu_item_parent',	'0'),
(81,	23,	'_menu_item_object_id',	'8'),
(82,	23,	'_menu_item_object',	'category'),
(83,	23,	'_menu_item_target',	''),
(84,	23,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(85,	23,	'_menu_item_xfn',	''),
(86,	23,	'_menu_item_url',	''),
(88,	24,	'_menu_item_type',	'taxonomy'),
(89,	24,	'_menu_item_menu_item_parent',	'0'),
(90,	24,	'_menu_item_object_id',	'13'),
(91,	24,	'_menu_item_object',	'category'),
(92,	24,	'_menu_item_target',	''),
(93,	24,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(94,	24,	'_menu_item_xfn',	''),
(95,	24,	'_menu_item_url',	''),
(97,	25,	'_menu_item_type',	'taxonomy'),
(98,	25,	'_menu_item_menu_item_parent',	'0'),
(99,	25,	'_menu_item_object_id',	'4'),
(100,	25,	'_menu_item_object',	'category'),
(101,	25,	'_menu_item_target',	''),
(102,	25,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(103,	25,	'_menu_item_xfn',	''),
(104,	25,	'_menu_item_url',	''),
(106,	26,	'_menu_item_type',	'taxonomy'),
(107,	26,	'_menu_item_menu_item_parent',	'0'),
(108,	26,	'_menu_item_object_id',	'15'),
(109,	26,	'_menu_item_object',	'category'),
(110,	26,	'_menu_item_target',	''),
(111,	26,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(112,	26,	'_menu_item_xfn',	''),
(113,	26,	'_menu_item_url',	''),
(115,	27,	'_menu_item_type',	'taxonomy'),
(116,	27,	'_menu_item_menu_item_parent',	'0'),
(117,	27,	'_menu_item_object_id',	'17'),
(118,	27,	'_menu_item_object',	'category'),
(119,	27,	'_menu_item_target',	''),
(120,	27,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(121,	27,	'_menu_item_xfn',	''),
(122,	27,	'_menu_item_url',	''),
(197,	36,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:15:\"2015/12/app.png\";s:5:\"sizes\";a:4:{s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:15:\"app-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:13:\"app-24x24.png\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:13:\"app-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:13:\"app-48x48.png\";s:5:\"width\";i:48;s:6:\"height\";i:48;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(124,	28,	'_menu_item_type',	'taxonomy'),
(125,	28,	'_menu_item_menu_item_parent',	'0'),
(126,	28,	'_menu_item_object_id',	'7'),
(127,	28,	'_menu_item_object',	'category'),
(128,	28,	'_menu_item_target',	''),
(129,	28,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(130,	28,	'_menu_item_xfn',	''),
(131,	28,	'_menu_item_url',	''),
(133,	29,	'_menu_item_type',	'taxonomy'),
(134,	29,	'_menu_item_menu_item_parent',	'0'),
(135,	29,	'_menu_item_object_id',	'9'),
(136,	29,	'_menu_item_object',	'category'),
(137,	29,	'_menu_item_target',	''),
(138,	29,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(139,	29,	'_menu_item_xfn',	''),
(140,	29,	'_menu_item_url',	''),
(142,	30,	'_menu_item_type',	'taxonomy'),
(143,	30,	'_menu_item_menu_item_parent',	'0'),
(144,	30,	'_menu_item_object_id',	'10'),
(145,	30,	'_menu_item_object',	'category'),
(146,	30,	'_menu_item_target',	''),
(147,	30,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(148,	30,	'_menu_item_xfn',	''),
(149,	30,	'_menu_item_url',	''),
(151,	31,	'_menu_item_type',	'taxonomy'),
(152,	31,	'_menu_item_menu_item_parent',	'0'),
(153,	31,	'_menu_item_object_id',	'16'),
(154,	31,	'_menu_item_object',	'category'),
(155,	31,	'_menu_item_target',	''),
(156,	31,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(157,	31,	'_menu_item_xfn',	''),
(158,	31,	'_menu_item_url',	''),
(160,	32,	'_menu_item_type',	'taxonomy'),
(161,	32,	'_menu_item_menu_item_parent',	'0'),
(162,	32,	'_menu_item_object_id',	'11'),
(163,	32,	'_menu_item_object',	'category'),
(164,	32,	'_menu_item_target',	''),
(165,	32,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(166,	32,	'_menu_item_xfn',	''),
(167,	32,	'_menu_item_url',	''),
(169,	33,	'_menu_item_type',	'custom'),
(170,	33,	'_menu_item_menu_item_parent',	'0'),
(171,	33,	'_menu_item_object_id',	'33'),
(172,	33,	'_menu_item_object',	'custom'),
(173,	33,	'_menu_item_target',	''),
(174,	33,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(175,	33,	'_menu_item_xfn',	''),
(176,	33,	'_menu_item_url',	'http://hotfile.pw'),
(178,	34,	'_menu_item_type',	'custom'),
(179,	34,	'_menu_item_menu_item_parent',	'0'),
(180,	34,	'_menu_item_object_id',	'34'),
(181,	34,	'_menu_item_object',	'custom'),
(182,	34,	'_menu_item_target',	''),
(183,	34,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(184,	34,	'_menu_item_xfn',	''),
(185,	34,	'_menu_item_url',	'http://hotfile.pw/top100'),
(187,	35,	'_menu_item_type',	'custom'),
(188,	35,	'_menu_item_menu_item_parent',	'0'),
(189,	35,	'_menu_item_object_id',	'35'),
(190,	35,	'_menu_item_object',	'custom'),
(191,	35,	'_menu_item_target',	''),
(192,	35,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(193,	35,	'_menu_item_xfn',	''),
(194,	35,	'_menu_item_url',	'http://hotfile.pw/sitemap.xml'),
(196,	36,	'_wp_attached_file',	'2015/12/app.png'),
(237,	17,	'_thumbnail_id',	'36'),
(199,	33,	'_menu_item_image_size',	'menu-24x24'),
(200,	33,	'_menu_item_image_title_position',	'after'),
(201,	17,	'_menu_item_image_size',	'menu-24x24'),
(202,	17,	'_menu_item_image_title_position',	'after'),
(203,	25,	'_menu_item_image_size',	'menu-24x24'),
(204,	25,	'_menu_item_image_title_position',	'after'),
(205,	21,	'_menu_item_image_size',	'menu-24x24'),
(206,	21,	'_menu_item_image_title_position',	'after'),
(207,	18,	'_menu_item_image_size',	'menu-24x24'),
(208,	18,	'_menu_item_image_title_position',	'after'),
(209,	28,	'_menu_item_image_size',	'menu-24x24'),
(210,	28,	'_menu_item_image_title_position',	'after'),
(211,	23,	'_menu_item_image_size',	'menu-24x24'),
(212,	23,	'_menu_item_image_title_position',	'after'),
(213,	29,	'_menu_item_image_size',	'menu-24x24'),
(214,	29,	'_menu_item_image_title_position',	'after'),
(215,	30,	'_menu_item_image_size',	'menu-24x24'),
(216,	30,	'_menu_item_image_title_position',	'after'),
(217,	32,	'_menu_item_image_size',	'menu-24x24'),
(218,	32,	'_menu_item_image_title_position',	'after'),
(219,	19,	'_menu_item_image_size',	'menu-24x24'),
(220,	19,	'_menu_item_image_title_position',	'after'),
(221,	24,	'_menu_item_image_size',	'menu-24x24'),
(222,	24,	'_menu_item_image_title_position',	'after'),
(223,	20,	'_menu_item_image_size',	'menu-24x24'),
(224,	20,	'_menu_item_image_title_position',	'after'),
(225,	26,	'_menu_item_image_size',	'menu-24x24'),
(226,	26,	'_menu_item_image_title_position',	'after'),
(227,	31,	'_menu_item_image_size',	'menu-24x24'),
(228,	31,	'_menu_item_image_title_position',	'after'),
(229,	22,	'_menu_item_image_size',	'menu-24x24'),
(230,	22,	'_menu_item_image_title_position',	'after'),
(231,	27,	'_menu_item_image_size',	'menu-24x24'),
(232,	27,	'_menu_item_image_title_position',	'after'),
(233,	34,	'_menu_item_image_size',	'menu-24x24'),
(234,	34,	'_menu_item_image_title_position',	'after'),
(235,	35,	'_menu_item_image_size',	'menu-24x24'),
(236,	35,	'_menu_item_image_title_position',	'after'),
(243,	38,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:16:\"2015/12/home.png\";s:5:\"sizes\";a:4:{s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:16:\"home-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:14:\"home-24x24.png\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:14:\"home-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:14:\"home-48x48.png\";s:5:\"width\";i:48;s:6:\"height\";i:48;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(242,	38,	'_wp_attached_file',	'2015/12/home.png'),
(244,	33,	'_thumbnail_id',	'38'),
(245,	39,	'_wp_attached_file',	'2015/12/mac.png'),
(246,	39,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:15:\"2015/12/mac.png\";s:5:\"sizes\";a:4:{s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:15:\"mac-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:13:\"mac-24x24.png\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:13:\"mac-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:13:\"mac-48x48.png\";s:5:\"width\";i:48;s:6:\"height\";i:48;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(247,	25,	'_thumbnail_id',	'39'),
(248,	40,	'_wp_attached_file',	'2015/12/games.png'),
(249,	40,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:17:\"2015/12/games.png\";s:5:\"sizes\";a:4:{s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:17:\"games-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:15:\"games-24x24.png\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:15:\"games-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:15:\"games-48x48.png\";s:5:\"width\";i:48;s:6:\"height\";i:48;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(250,	21,	'_thumbnail_id',	'40'),
(251,	41,	'_wp_attached_file',	'2015/12/Sykonist-Console-Gamecube-orange.ico'),
(252,	41,	'_wp_attachment_metadata',	'a:4:{s:5:\"width\";i:0;s:6:\"height\";i:0;s:4:\"file\";s:44:\"2015/12/Sykonist-Console-Gamecube-orange.ico\";s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(253,	18,	'_thumbnail_id',	'40'),
(254,	42,	'_wp_attached_file',	'2015/12/tv.png'),
(255,	42,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:14:\"2015/12/tv.png\";s:5:\"sizes\";a:4:{s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:14:\"tv-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:12:\"tv-24x24.png\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:12:\"tv-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:12:\"tv-48x48.png\";s:5:\"width\";i:48;s:6:\"height\";i:48;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(256,	32,	'_thumbnail_id',	'42'),
(257,	43,	'_wp_attached_file',	'2015/12/movie-alt-128.png'),
(258,	43,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:25:\"2015/12/movie-alt-128.png\";s:5:\"sizes\";a:4:{s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:25:\"movie-alt-128-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:23:\"movie-alt-128-24x24.png\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:23:\"movie-alt-128-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:23:\"movie-alt-128-48x48.png\";s:5:\"width\";i:48;s:6:\"height\";i:48;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(259,	28,	'_thumbnail_id',	'43'),
(260,	44,	'_wp_attached_file',	'2015/12/bluray.png'),
(261,	44,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:200;s:6:\"height\";i:200;s:4:\"file\";s:18:\"2015/12/bluray.png\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"bluray-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:18:\"bluray-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"themingstrap-150\";a:4:{s:4:\"file\";s:18:\"bluray-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"themingstrap-200\";a:4:{s:4:\"file\";s:18:\"bluray-200x200.png\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"home-blog-thumb\";a:4:{s:4:\"file\";s:18:\"bluray-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:16:\"bluray-24x24.png\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:16:\"bluray-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:16:\"bluray-48x48.png\";s:5:\"width\";i:48;s:6:\"height\";i:48;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(262,	23,	'_thumbnail_id',	'44'),
(263,	45,	'_wp_attached_file',	'2015/12/music.png'),
(264,	45,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:17:\"2015/12/music.png\";s:5:\"sizes\";a:4:{s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:17:\"music-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:15:\"music-24x24.png\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:15:\"music-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:15:\"music-48x48.png\";s:5:\"width\";i:48;s:6:\"height\";i:48;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(265,	29,	'_thumbnail_id',	'45'),
(266,	46,	'_wp_attached_file',	'2015/12/youtube.png'),
(267,	46,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:48;s:6:\"height\";i:34;s:4:\"file\";s:19:\"2015/12/youtube.png\";s:5:\"sizes\";a:3:{s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:17:\"youtube-24x17.png\";s:5:\"width\";i:24;s:6:\"height\";i:17;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:17:\"youtube-36x26.png\";s:5:\"width\";i:36;s:6:\"height\";i:26;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:17:\"youtube-48x34.png\";s:5:\"width\";i:48;s:6:\"height\";i:34;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(268,	30,	'_thumbnail_id',	'46'),
(269,	47,	'_wp_attached_file',	'2015/12/icon-documentary-3.png'),
(270,	47,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:136;s:6:\"height\";i:102;s:4:\"file\";s:30:\"2015/12/icon-documentary-3.png\";s:5:\"sizes\";a:4:{s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:29:\"icon-documentary-3-100x75.png\";s:5:\"width\";i:100;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:28:\"icon-documentary-3-24x18.png\";s:5:\"width\";i:24;s:6:\"height\";i:18;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:28:\"icon-documentary-3-36x27.png\";s:5:\"width\";i:36;s:6:\"height\";i:27;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:28:\"icon-documentary-3-48x36.png\";s:5:\"width\";i:48;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(271,	19,	'_thumbnail_id',	'47'),
(272,	48,	'_wp_attached_file',	'2015/12/iphone.png'),
(273,	48,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:256;s:6:\"height\";i:256;s:4:\"file\";s:18:\"2015/12/iphone.png\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"iphone-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:18:\"iphone-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"themingstrap-150\";a:4:{s:4:\"file\";s:18:\"iphone-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"themingstrap-200\";a:4:{s:4:\"file\";s:18:\"iphone-200x200.png\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"home-blog-thumb\";a:4:{s:4:\"file\";s:18:\"iphone-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:16:\"iphone-24x24.png\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:16:\"iphone-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:16:\"iphone-48x48.png\";s:5:\"width\";i:48;s:6:\"height\";i:48;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(274,	24,	'_thumbnail_id',	'48'),
(275,	49,	'_wp_attached_file',	'2015/12/ebooks.jpg'),
(276,	49,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:190;s:6:\"height\";i:190;s:4:\"file\";s:18:\"2015/12/ebooks.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"ebooks-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:18:\"ebooks-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"themingstrap-150\";a:4:{s:4:\"file\";s:18:\"ebooks-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"home-blog-thumb\";a:4:{s:4:\"file\";s:18:\"ebooks-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:16:\"ebooks-24x24.jpg\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:16:\"ebooks-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:16:\"ebooks-48x48.jpg\";s:5:\"width\";i:48;s:6:\"height\";i:48;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(277,	20,	'_thumbnail_id',	'49'),
(278,	50,	'_wp_attached_file',	'2015/12/eMagazine_icon.jpg'),
(279,	50,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:360;s:6:\"height\";i:360;s:4:\"file\";s:26:\"2015/12/eMagazine_icon.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"eMagazine_icon-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"eMagazine_icon-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:26:\"eMagazine_icon-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"themingstrap-150\";a:4:{s:4:\"file\";s:26:\"eMagazine_icon-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"themingstrap-200\";a:4:{s:4:\"file\";s:26:\"eMagazine_icon-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"themingstrap-300\";a:4:{s:4:\"file\";s:26:\"eMagazine_icon-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"home-blog-thumb\";a:4:{s:4:\"file\";s:26:\"eMagazine_icon-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:24:\"eMagazine_icon-24x24.jpg\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:24:\"eMagazine_icon-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:24:\"eMagazine_icon-48x48.jpg\";s:5:\"width\";i:48;s:6:\"height\";i:48;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(280,	26,	'_thumbnail_id',	'50'),
(281,	51,	'_wp_attached_file',	'2015/12/Video-tutorial-icon.jpg'),
(282,	51,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:250;s:6:\"height\";i:293;s:4:\"file\";s:31:\"2015/12/Video-tutorial-icon.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"Video-tutorial-icon-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:31:\"Video-tutorial-icon-100x117.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:117;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"themingstrap-150\";a:4:{s:4:\"file\";s:31:\"Video-tutorial-icon-150x176.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:176;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"themingstrap-200\";a:4:{s:4:\"file\";s:31:\"Video-tutorial-icon-200x234.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:234;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"home-blog-thumb\";a:4:{s:4:\"file\";s:31:\"Video-tutorial-icon-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:29:\"Video-tutorial-icon-20x24.jpg\";s:5:\"width\";i:20;s:6:\"height\";i:24;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:29:\"Video-tutorial-icon-31x36.jpg\";s:5:\"width\";i:31;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:29:\"Video-tutorial-icon-41x48.jpg\";s:5:\"width\";i:41;s:6:\"height\";i:48;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(283,	31,	'_thumbnail_id',	'51'),
(284,	52,	'_wp_attached_file',	'2015/12/icon128-2x.png'),
(285,	52,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:256;s:6:\"height\";i:256;s:4:\"file\";s:22:\"2015/12/icon128-2x.png\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"icon128-2x-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:22:\"icon128-2x-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"themingstrap-150\";a:4:{s:4:\"file\";s:22:\"icon128-2x-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"themingstrap-200\";a:4:{s:4:\"file\";s:22:\"icon128-2x-200x200.png\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"home-blog-thumb\";a:4:{s:4:\"file\";s:22:\"icon128-2x-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:20:\"icon128-2x-24x24.png\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:20:\"icon128-2x-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:20:\"icon128-2x-48x48.png\";s:5:\"width\";i:48;s:6:\"height\";i:48;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(286,	22,	'_thumbnail_id',	'52'),
(287,	53,	'_wp_attached_file',	'2015/12/misc.jpg'),
(288,	53,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:256;s:6:\"height\";i:256;s:4:\"file\";s:16:\"2015/12/misc.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"misc-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"themingstrap-100\";a:4:{s:4:\"file\";s:16:\"misc-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"themingstrap-150\";a:4:{s:4:\"file\";s:16:\"misc-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"themingstrap-200\";a:4:{s:4:\"file\";s:16:\"misc-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"home-blog-thumb\";a:4:{s:4:\"file\";s:16:\"misc-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:14:\"misc-24x24.jpg\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"menu-36x36\";a:4:{s:4:\"file\";s:14:\"misc-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"menu-48x48\";a:4:{s:4:\"file\";s:14:\"misc-48x48.jpg\";s:5:\"width\";i:48;s:6:\"height\";i:48;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;s:8:\"keywords\";a:0:{}}}'),
(289,	27,	'_thumbnail_id',	'53'),
(290,	54,	'_wp_attached_file',	'2015/12/top100_icon_35.png'),
(291,	54,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:35;s:6:\"height\";i:35;s:4:\"file\";s:26:\"2015/12/top100_icon_35.png\";s:5:\"sizes\";a:1:{s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:24:\"top100_icon_35-24x24.png\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(292,	34,	'_thumbnail_id',	'54'),
(293,	55,	'_wp_attached_file',	'2015/12/sitemap.png'),
(294,	55,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:32;s:6:\"height\";i:32;s:4:\"file\";s:19:\"2015/12/sitemap.png\";s:5:\"sizes\";a:1:{s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:17:\"sitemap-24x24.png\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(295,	35,	'_thumbnail_id',	'55'),
(296,	57,	'_edit_last',	'1'),
(300,	57,	'_oembed_80a8b3929c345267084ce98a58e75574',	'{{unknown}}'),
(299,	57,	'_edit_lock',	'1451309736:1'),
(301,	57,	'_oembed_3041485c8c64d00061de8ac4ed7d07c9',	'{{unknown}}'),
(302,	57,	'_oembed_0501899d36e4d690d26d5da65ec931d8',	'{{unknown}}'),
(303,	59,	'_edit_last',	'1'),
(307,	59,	'_oembed_0a1009815073152d9991c7a3b3366178',	'{{unknown}}'),
(309,	59,	'_oembed_a69d1893f00b1ae251b22a18019800cf',	'{{unknown}}'),
(306,	59,	'_edit_lock',	'1451309859:1'),
(308,	59,	'_oembed_aff00a4b63519382617c03676e83dea8',	'{{unknown}}'),
(310,	61,	'_edit_last',	'1'),
(314,	61,	'_oembed_f2e5ed13910b366a271cfc821a4b84e9',	'{{unknown}}'),
(316,	61,	'_oembed_0d6c077225bb77797704c7711a329964',	'{{unknown}}'),
(313,	61,	'_edit_lock',	'1451309981:1'),
(315,	61,	'_oembed_2c3e1a0e4a55481d5ea69bb3a100f107',	'{{unknown}}'),
(317,	63,	'_edit_last',	'1'),
(321,	63,	'_oembed_93b48aae0766dc08dbc75953c748afff',	'{{unknown}}'),
(323,	65,	'_edit_last',	'1'),
(320,	63,	'_edit_lock',	'1451313264:1'),
(322,	63,	'_oembed_9e3cc6fca5b2bfc982ca2d272255ab52',	'{{unknown}}'),
(327,	65,	'_oembed_01d8856d25499d4aeb11404dd65010d7',	'{{unknown}}'),
(326,	65,	'_edit_lock',	'1451311361:1'),
(328,	65,	'_oembed_631153f494360cecc6c2dcc367ee637c',	'{{unknown}}'),
(329,	65,	'_oembed_b1310ad418395cfe0eb016f13288b13b',	'{{unknown}}'),
(330,	67,	'_edit_last',	'1'),
(334,	67,	'_oembed_4e49e2577a7c0eee1cd3912f9be10c0f',	'{{unknown}}'),
(335,	67,	'_oembed_5d97b435c681b5a1090331ffbe25d871',	'{{unknown}}'),
(333,	67,	'_edit_lock',	'1451311484:1'),
(339,	70,	'_edit_last',	'1'),
(343,	70,	'_oembed_e620b5ce696f8a0052ad410bb5db4707',	'{{unknown}}'),
(342,	70,	'_edit_lock',	'1451313339:1'),
(344,	70,	'_oembed_0c12753be0372df96fb78c88238e969b',	'{{unknown}}'),
(345,	70,	'_oembed_7537f263ba6fd6253ac71adeaa2ca66e',	'{{unknown}}'),
(359,	75,	'_edit_last',	'1'),
(355,	73,	'_edit_lock',	'1451313462:1'),
(352,	73,	'_edit_last',	'1'),
(356,	73,	'_oembed_124f8bd086d70a42a4aa1ded1a174f1b',	'{{unknown}}'),
(357,	73,	'_oembed_40b648b6202fb8b3bdf7ecc80627901b',	'{{unknown}}'),
(358,	73,	'_oembed_176e75268023ac48de37de4bac29ae32',	'{{unknown}}'),
(363,	75,	'_oembed_f74d87357dbe047fc5b3fd456d9f997f',	'{{unknown}}'),
(362,	75,	'_edit_lock',	'1451314822:1'),
(364,	75,	'_oembed_2d4ab87a6853b27566188d016c936687',	'{{unknown}}'),
(365,	77,	'_edit_last',	'1'),
(369,	77,	'_oembed_bc395f4ee9841bcfcfbc56ac05ab4261',	'{{unknown}}'),
(368,	77,	'_edit_lock',	'1451314944:1'),
(370,	77,	'_oembed_0b3f24e355972fbe79c0e734476606bc',	'{{unknown}}'),
(371,	79,	'_edit_last',	'1'),
(375,	79,	'_oembed_d439e0e5115dedbcc58852b309d92bb7',	'{{unknown}}'),
(374,	79,	'_edit_lock',	'1451315067:1'),
(376,	79,	'_oembed_59090920cb072257cacd7816b5250906',	'{{unknown}}'),
(377,	81,	'_edit_last',	'1'),
(381,	81,	'_oembed_89a6a106fe21c21536857a860b0fe1b5',	'{{unknown}}'),
(383,	83,	'_edit_last',	'1'),
(380,	81,	'_edit_lock',	'1451316931:1'),
(382,	81,	'_oembed_1b7ae439927f5696a034a459090f8c4e',	'{{unknown}}'),
(387,	83,	'_oembed_617a81fd58d95dcd201a68b3ebbbfdea',	'{{unknown}}'),
(386,	83,	'_edit_lock',	'1451317054:1'),
(388,	83,	'_oembed_806cd17c297f6ba6788a6522ec53cd59',	'{{unknown}}'),
(389,	85,	'_edit_last',	'1'),
(393,	85,	'_oembed_d7d40f15712c99e64b48b8cba4af60ab',	'{{unknown}}'),
(392,	85,	'_edit_lock',	'1451317177:1'),
(394,	85,	'_oembed_080ddfd1b22bff5bb4a8641ca7fc3c51',	'{{unknown}}'),
(395,	87,	'_edit_last',	'1'),
(399,	87,	'_oembed_a5068603530d5bd5285f1eaf18789eac',	'{{unknown}}'),
(398,	87,	'_edit_lock',	'1451318434:1'),
(400,	87,	'_oembed_6c9f7682b5c7fd642e747a0181ceaad3',	'{{unknown}}'),
(401,	89,	'_edit_last',	'1'),
(405,	89,	'_oembed_a5e06a39736f6bb129150a6c66cb7658',	'{{unknown}}'),
(407,	91,	'_edit_last',	'1'),
(404,	89,	'_edit_lock',	'1451318557:1'),
(406,	89,	'_oembed_7b8e3c28b2eff5a4972f4746766c2927',	'{{unknown}}'),
(411,	91,	'_oembed_982a3046f28daba1a106fdb62356bede',	'{{unknown}}'),
(410,	91,	'_edit_lock',	'1451320546:1'),
(412,	91,	'_oembed_277b3d7410a4e7b46a504edf807c34a8',	'{{unknown}}'),
(413,	93,	'_edit_last',	'1'),
(417,	93,	'_oembed_2013ca44698fe5b201495972be072881',	'{{unknown}}'),
(416,	93,	'_edit_lock',	'1451320669:1'),
(418,	93,	'_oembed_3d04d04dc1202d0a1e0ae82652169f6f',	'{{unknown}}'),
(419,	95,	'_edit_last',	'1'),
(423,	95,	'_oembed_0f7f4246bc37ddbb91d01c48b6ce9377',	'{{unknown}}'),
(422,	95,	'_edit_lock',	'1451320792:1'),
(424,	95,	'_oembed_3474e0aba8ac91b8364130895dfc6418',	'{{unknown}}'),
(425,	97,	'_edit_last',	'1'),
(429,	97,	'_oembed_ac6f7ccadb3c9bee2f73f982bcae0cb1',	'{{unknown}}'),
(428,	97,	'_edit_lock',	'1451320915:1'),
(430,	97,	'_oembed_04342bc7fc1f60cbba590957359935c2',	'{{unknown}}'),
(431,	99,	'_edit_last',	'1'),
(435,	99,	'_oembed_7a8d2c5dec03fae482761cec8360c42c',	'{{unknown}}'),
(434,	99,	'_edit_lock',	'1451324138:1'),
(436,	99,	'_oembed_5bf3fa2dad3b19cae693cd2b7e36f5fa',	'{{unknown}}'),
(437,	101,	'_edit_last',	'1'),
(441,	101,	'_oembed_551998a9d33364da48eb9b112a1a2bcd',	'{{unknown}}'),
(442,	101,	'_oembed_64979849c2779eb59968912f0bd4f10c',	'{{unknown}}'),
(440,	101,	'_edit_lock',	'1451324261:1'),
(443,	103,	'_edit_last',	'1'),
(447,	103,	'_oembed_57d9f52c4faa9e9866f7a0aa5ce4803a',	'{{unknown}}'),
(446,	103,	'_edit_lock',	'1451324384:1'),
(448,	103,	'_oembed_e23f4fd28c024664e8c2e4b0d29c2fb7',	'{{unknown}}'),
(449,	105,	'_edit_last',	'1'),
(453,	105,	'_oembed_d97dad1970ed7eaf70448015ba10beeb',	'{{unknown}}'),
(452,	105,	'_edit_lock',	'1451324507:1'),
(454,	105,	'_oembed_5fbf994b30e1c1a4c2c92dfc0946380f',	'{{unknown}}'),
(455,	107,	'_edit_last',	'1'),
(459,	107,	'_oembed_4d2a86a72cada0bfa8e6d28a3dfe0c6e',	'{{unknown}}'),
(461,	109,	'_edit_last',	'1'),
(458,	107,	'_edit_lock',	'1451324630:1'),
(460,	107,	'_oembed_aeb89382f9d348362deb21d283f4abc5',	'{{unknown}}'),
(465,	109,	'_oembed_80bbe50317901a4a886768f2c746ae63',	'{{unknown}}'),
(464,	109,	'_edit_lock',	'1451325625:1'),
(466,	109,	'_oembed_904e5268b436d7fb1c570513b5b3e81d',	'{{unknown}}'),
(467,	111,	'_edit_last',	'1'),
(471,	111,	'_oembed_d812d569bd7c30a1f6d98d46bc76059a',	'{{unknown}}'),
(472,	111,	'_oembed_6984b6362e0c402aa700b4a8b2244b12',	'{{unknown}}'),
(470,	111,	'_edit_lock',	'1451325748:1'),
(473,	113,	'_edit_last',	'1'),
(477,	113,	'_oembed_2f9469abf39abbac085ec0922822a4e4',	'{{unknown}}'),
(478,	113,	'_oembed_54c038bbc4e401e4968474b9871ea279',	'{{unknown}}'),
(476,	113,	'_edit_lock',	'1451325871:1'),
(479,	115,	'_edit_last',	'1'),
(483,	115,	'_oembed_7ca5e254d38eff1ffb10bb2825016df4',	'{{unknown}}'),
(484,	115,	'_oembed_a3cb0e5410c4287a415fc0d363feaf0d',	'{{unknown}}'),
(482,	115,	'_edit_lock',	'1451325993:1'),
(485,	117,	'_edit_last',	'1'),
(489,	117,	'_oembed_88c57f641beff4de241fb00647e0c8be',	'{{unknown}}'),
(490,	117,	'_oembed_4e3b72be92f2bd03dd77d5b3c36f4d96',	'{{unknown}}'),
(488,	117,	'_edit_lock',	'1451326116:1'),
(491,	119,	'_edit_last',	'1'),
(495,	119,	'_oembed_751c57f86794d559afcf78cf4171caf1',	'{{unknown}}'),
(494,	119,	'_edit_lock',	'1451326240:1'),
(496,	119,	'_oembed_d32215e6cb84f1269d07d382ef211829',	'{{unknown}}'),
(497,	121,	'_edit_last',	'1'),
(501,	121,	'_oembed_f647e30b4365a73f1078e1486d520ff6',	'{{unknown}}'),
(502,	121,	'_oembed_e544cb097279635a5dade465bf422121',	'{{unknown}}'),
(500,	121,	'_edit_lock',	'1451327727:1'),
(503,	123,	'_edit_last',	'1'),
(507,	123,	'_oembed_9c7806cf9140bde3728a7c7def43ee0b',	'{{unknown}}'),
(506,	123,	'_edit_lock',	'1451327850:1'),
(508,	123,	'_oembed_0afe1e367fabb50e528072560416ffb3',	'{{unknown}}'),
(509,	125,	'_edit_last',	'1'),
(513,	125,	'_oembed_53745d1c7ba9d072091f9a3197b38d2a',	'{{unknown}}'),
(514,	125,	'_oembed_194051664a231849132507496542ae2e',	'{{unknown}}'),
(512,	125,	'_edit_lock',	'1451327973:1'),
(515,	127,	'_edit_last',	'1'),
(519,	127,	'_oembed_26ca0b642e2a49a42eb6fd9b02fc8427',	'{{unknown}}'),
(518,	127,	'_edit_lock',	'1451328097:1'),
(520,	127,	'_oembed_d9cc8c75805c093ca770078c4efa7cbc',	'{{unknown}}'),
(521,	129,	'_edit_last',	'1'),
(525,	129,	'_oembed_a6d9894dddc1f2a45fe1dbf027e38a3a',	'{{unknown}}'),
(526,	129,	'_oembed_be7786018b5037628aa3586339048395',	'{{unknown}}'),
(524,	129,	'_edit_lock',	'1451328220:1'),
(527,	131,	'_edit_last',	'1'),
(531,	131,	'_oembed_ea41f6bc329fcadc32f5ad7541cab9b4',	'{{unknown}}'),
(534,	133,	'_edit_last',	'1'),
(530,	131,	'_edit_lock',	'1451329232:1'),
(532,	131,	'_oembed_941891a78fca24d72553b19e1c18252f',	'{{unknown}}'),
(533,	131,	'_oembed_74eafe1b78f11e935e0f8b5ce6fbba7f',	'{{unknown}}'),
(538,	133,	'_oembed_af221ddb6dbdfd6f520ac40fb2e935b1',	'{{unknown}}'),
(540,	135,	'_edit_last',	'1'),
(537,	133,	'_edit_lock',	'1451329355:1'),
(539,	133,	'_oembed_5b68fcb78498f12f40f73842908d3237',	'{{unknown}}'),
(544,	135,	'_oembed_c3128e046d701204922aa3ecb98ba193',	'{{unknown}}'),
(545,	135,	'_oembed_8e80a1ab4538c5c5897f43a9a10bbbea',	'{{unknown}}'),
(543,	135,	'_edit_lock',	'1451329478:1'),
(546,	137,	'_edit_last',	'1'),
(550,	137,	'_oembed_e12a0e337337a1a5486399070492efd0',	'{{unknown}}'),
(549,	137,	'_edit_lock',	'1451329601:1'),
(551,	137,	'_oembed_f6619dc6f150366daf295cf4fe609364',	'{{unknown}}'),
(552,	139,	'_edit_last',	'1'),
(556,	139,	'_oembed_de265723c961e68a0791988d5cbc7ee2',	'{{unknown}}'),
(558,	141,	'_edit_last',	'1'),
(555,	139,	'_edit_lock',	'1451329724:1'),
(557,	139,	'_oembed_96b1b9e7c571edfb7bd43dbdfaf548cd',	'{{unknown}}'),
(562,	141,	'_oembed_ef1adfaea8eb7dfb9ad0d9367b162dd1',	'{{unknown}}'),
(563,	141,	'_oembed_9b10e38ad7e1a4494909e5adf7eea59b',	'{{unknown}}'),
(561,	141,	'_edit_lock',	'1451329846:1'),
(564,	143,	'_edit_last',	'1'),
(568,	143,	'_oembed_5687555c3f05eddc08272f0f8c10aaa3',	'{{unknown}}'),
(567,	143,	'_edit_lock',	'1451329971:1'),
(569,	143,	'_oembed_1a453218231c3b48ff2bdc1293de0475',	'{{unknown}}'),
(570,	145,	'_edit_last',	'1'),
(584,	149,	'_edit_last',	'1'),
(577,	147,	'_edit_last',	'1'),
(573,	145,	'_edit_lock',	'1451331339:1'),
(574,	145,	'_oembed_d282c26cb854c3860e762eb9b699a401',	'{{unknown}}'),
(575,	145,	'_oembed_8380d44abe4338204d427a291ecef5ca',	'{{unknown}}'),
(576,	145,	'_oembed_6b700f8c417e435516e8841628c6fafd',	'{{unknown}}'),
(591,	151,	'_edit_last',	'1'),
(580,	147,	'_edit_lock',	'1451331464:1'),
(581,	147,	'_oembed_c93ef70f0de7c0688d7ba77b226b5134',	'{{unknown}}'),
(582,	147,	'_oembed_11a50704116fbe86acc51a33b080f05b',	'{{unknown}}'),
(583,	147,	'_oembed_44b4be8ca06cc04907ebb181fcbd9072',	'{{unknown}}'),
(588,	149,	'_oembed_9800535832e75782a12b39ff9ed4d9cc',	'{{unknown}}'),
(587,	149,	'_edit_lock',	'1451331587:1'),
(589,	149,	'_oembed_9eea8ba9dfea4f4f31a0b391efb87edc',	'{{unknown}}'),
(590,	149,	'_oembed_4ed8bebf97d32c596649834903ca56b6',	'{{unknown}}'),
(609,	155,	'_oembed_edbdc43086d18d6d54d148d704766527',	'{{unknown}}'),
(598,	153,	'_edit_last',	'1'),
(594,	151,	'_edit_lock',	'1451331711:1'),
(595,	151,	'_oembed_781d61ff56798b73c0b0fd4773643e40',	'{{unknown}}'),
(596,	151,	'_oembed_8f92fc6e5489000643927a98194faa2b',	'{{unknown}}'),
(597,	151,	'_oembed_47f9fa3db5c02040cffc26d7072b8409',	'{{unknown}}'),
(605,	155,	'_edit_last',	'1'),
(601,	153,	'_edit_lock',	'1451331835:1'),
(602,	153,	'_oembed_f52d4fbd5bffa70ba44ab6e392495d8f',	'{{unknown}}'),
(603,	153,	'_oembed_c78a2e094ef6ec50ec4232cf3a85745a',	'{{unknown}}'),
(604,	153,	'_oembed_f576582722f2623b2246d0bb8d72df5d',	'{{unknown}}'),
(612,	157,	'_edit_last',	'1'),
(608,	155,	'_edit_lock',	'1451331960:1'),
(610,	155,	'_oembed_15b57f6867ae4a15101217d8234ad5d9',	'{{unknown}}'),
(611,	155,	'_oembed_f6add1f212efa4c7299fb0a24b96b882',	'{{unknown}}'),
(616,	157,	'_oembed_cd3adb5a8a3237cdf5b3942e6841aff0',	'{{unknown}}'),
(618,	157,	'_oembed_b52555d521b776278b11b549548913f2',	'{{unknown}}'),
(615,	157,	'_edit_lock',	'1451332830:1'),
(617,	157,	'_oembed_a3dcc541f9014de4645625e6bf6baa25',	'{{unknown}}'),
(619,	159,	'_edit_last',	'1'),
(623,	159,	'_oembed_5baa28727515c3fb00b093a17c31d27c',	'{{unknown}}'),
(622,	159,	'_edit_lock',	'1451332952:1'),
(624,	159,	'_oembed_923bd3b76c0dfed621de933ad43a6852',	'{{unknown}}'),
(625,	159,	'_oembed_817a20c097c2beb8b6487f84fdd5cbeb',	'{{unknown}}'),
(626,	161,	'_edit_last',	'1'),
(630,	161,	'_oembed_98cf167372a59f4abd10a765992e326a',	'{{unknown}}'),
(629,	161,	'_edit_lock',	'1451333075:1'),
(631,	161,	'_oembed_0a5b2b45a563815782135b1a24048d75',	'{{unknown}}'),
(632,	161,	'_oembed_9eda017d313ad405b0e85f43a81151e0',	'{{unknown}}'),
(633,	163,	'_edit_last',	'1'),
(637,	163,	'_oembed_f7277a75e982d0500e37f70ba987571e',	'{{unknown}}'),
(639,	163,	'_oembed_af450eff672847ff3f0177de0abdf850',	'{{unknown}}'),
(636,	163,	'_edit_lock',	'1451333201:1'),
(638,	163,	'_oembed_ab0e222257c7974cccede289fc79b363',	'{{unknown}}'),
(640,	165,	'_edit_last',	'1'),
(644,	165,	'_oembed_811c60562133ac9d182a8c6a155e8a29',	'{{unknown}}'),
(643,	165,	'_edit_lock',	'1451333324:1'),
(645,	165,	'_oembed_9c4cb27959cf83f87b4d3dfc2c097027',	'{{unknown}}'),
(646,	165,	'_oembed_298bfaea82d843231e9deffff84dfa1b',	'{{unknown}}'),
(647,	167,	'_edit_last',	'1'),
(651,	167,	'_oembed_9f77efb6536b61d958f2549c4511e375',	'{{unknown}}'),
(650,	167,	'_edit_lock',	'1451333447:1'),
(652,	167,	'_oembed_6bd86d958b8d6fb37510b49cc4cbd882',	'{{unknown}}'),
(653,	167,	'_oembed_cfdb1763a59c8e787d3c8997f0cd4e09',	'{{unknown}}'),
(654,	169,	'_edit_last',	'1'),
(658,	169,	'_oembed_7d57f7a1d586ce0787e17a25721b27f8',	'{{unknown}}'),
(661,	171,	'_edit_last',	'1'),
(657,	169,	'_edit_lock',	'1451333570:1'),
(659,	169,	'_oembed_a31f62d2f159cbfac35e09a72d923638',	'{{unknown}}'),
(660,	169,	'_oembed_e76e167fa40da2fdcffcd997f320f155',	'{{unknown}}'),
(665,	171,	'_oembed_9d0bbd997c3f0f49a5dbcfd93d415146',	'{{unknown}}'),
(668,	173,	'_edit_last',	'1'),
(664,	171,	'_edit_lock',	'1451333693:1'),
(666,	171,	'_oembed_efe89cb88aca2868af6d0ed3b6d08563',	'{{unknown}}'),
(667,	171,	'_oembed_3a21fe4e42086175000c05071aa43147',	'{{unknown}}'),
(672,	173,	'_oembed_fa3fac6e492b5065987ff2e27b740a75',	'{{unknown}}'),
(673,	173,	'_oembed_c8f1ea0516b6f219c22d16c83dcc3c72',	'{{unknown}}'),
(671,	173,	'_edit_lock',	'1451333816:1'),
(674,	173,	'_oembed_424f592450debdcfab38fafb73342492',	'{{unknown}}'),
(675,	175,	'_edit_last',	'1'),
(679,	175,	'_oembed_5e9860acf261dfee20a0401045f92db4',	'{{unknown}}'),
(678,	175,	'_edit_lock',	'1451333939:1'),
(680,	175,	'_oembed_4a3b8c81125c4ce681792508e90a943f',	'{{unknown}}'),
(681,	175,	'_oembed_bfecf6613f51021d869ece2cb4a92eea',	'{{unknown}}'),
(682,	177,	'_edit_last',	'1'),
(686,	177,	'_oembed_a16a452a2814b2551b0777e3d12e3847',	'{{unknown}}'),
(688,	177,	'_oembed_8f4566bd98643c026cbc64bc72710846',	'{{unknown}}'),
(685,	177,	'_edit_lock',	'1451334062:1'),
(687,	177,	'_oembed_a202d2ab35a2074924de4c3c94e9d423',	'{{unknown}}'),
(689,	179,	'_edit_last',	'1'),
(693,	179,	'_oembed_95fa8a02ada64c634dc9a3b05d566ef4',	'{{unknown}}'),
(692,	179,	'_edit_lock',	'1451334185:1'),
(694,	179,	'_oembed_c67e4e0ebbb40fe15b54fb50834488b2',	'{{unknown}}'),
(695,	179,	'_oembed_518b1eb2737b62abf86537cc855cc8a6',	'{{unknown}}'),
(696,	181,	'_edit_last',	'1'),
(700,	181,	'_oembed_1a4a8736b27b30c5e6c297d4f3293535',	'{{unknown}}'),
(701,	181,	'_oembed_552ec3c70d64704baef21bf9dd973f7a',	'{{unknown}}'),
(699,	181,	'_edit_lock',	'1451334947:1'),
(702,	181,	'_oembed_7b7a5b61b6e82476350a8a38a6562cf7',	'{{unknown}}'),
(703,	183,	'_edit_last',	'1'),
(707,	183,	'_oembed_65f5a2d1789f6cb73b23eee6e54d7101',	'{{unknown}}'),
(708,	183,	'_oembed_af6a91d43a73be3de00bd1191140c2fa',	'{{unknown}}'),
(706,	183,	'_edit_lock',	'1451335069:1'),
(709,	183,	'_oembed_76a4e936a264002ea27135dcc6534099',	'{{unknown}}'),
(710,	185,	'_edit_last',	'1'),
(714,	185,	'_oembed_0fa99aa4145ae7bf8eed0b8c3378fa98',	'{{unknown}}'),
(715,	185,	'_oembed_17997af0b2a11d5071f6476743c984bb',	'{{unknown}}'),
(713,	185,	'_edit_lock',	'1451335193:1'),
(716,	185,	'_oembed_b4a2fa848a2e21397c784324429dcdc3',	'{{unknown}}'),
(717,	187,	'_edit_last',	'1'),
(721,	187,	'_oembed_f3bb6323b262e7e6806a1de2c3e75c99',	'{{unknown}}'),
(724,	189,	'_edit_last',	'1'),
(720,	187,	'_edit_lock',	'1451335316:1'),
(722,	187,	'_oembed_1093cb2b3122f30ef24f86b9dc3c7182',	'{{unknown}}'),
(723,	187,	'_oembed_b8c95116b4e4f3be8bcbedf99d5b8bd1',	'{{unknown}}'),
(728,	189,	'_oembed_fa7644066049da5bb98ece6f61341509',	'{{unknown}}'),
(727,	189,	'_edit_lock',	'1451335439:1'),
(729,	189,	'_oembed_6869967e39154efd9f36fe9803ffc70e',	'{{unknown}}'),
(730,	189,	'_oembed_3b39009804a9c5a2be06e24f3eb07967',	'{{unknown}}'),
(731,	191,	'_edit_last',	'1'),
(735,	191,	'_oembed_a63bf479af8ab8edfe7ba9da68b32914',	'{{unknown}}'),
(734,	191,	'_edit_lock',	'1451335562:1'),
(736,	191,	'_oembed_e9c661c9baae7ad850c6e7a6d010f9a7',	'{{unknown}}'),
(737,	191,	'_oembed_92d302343b220e63ad5bd3fceb04e9b2',	'{{unknown}}'),
(738,	193,	'_edit_last',	'1'),
(742,	193,	'_oembed_ff80c0cc87eba08036594fd470b596e2',	'{{unknown}}'),
(743,	193,	'_oembed_7585e5fe54d0910be21f3cd5e5dc5bde',	'{{unknown}}'),
(741,	193,	'_edit_lock',	'1451335685:1'),
(744,	193,	'_oembed_eee30ad832f85d11142cc6be23cdf00b',	'{{unknown}}'),
(745,	195,	'_edit_last',	'1'),
(749,	195,	'_oembed_9964a23d96253712c2343de25fe7cbcf',	'{{unknown}}'),
(752,	197,	'_edit_last',	'1'),
(748,	195,	'_edit_lock',	'1451335809:1'),
(750,	195,	'_oembed_1edbea459d646f7b4006e0974e6fe3a2',	'{{unknown}}'),
(751,	195,	'_oembed_9c9693e6f291a596ad6c15b10f324e71',	'{{unknown}}'),
(756,	197,	'_oembed_4d62fb5b3490ec46160966eb135c267f',	'{{unknown}}'),
(759,	199,	'_edit_last',	'1'),
(755,	197,	'_edit_lock',	'1451335932:1'),
(757,	197,	'_oembed_a7142f721a2caa90172674cbc96927a2',	'{{unknown}}'),
(758,	197,	'_oembed_33613549985eaa46d94c4e159a54ba4c',	'{{unknown}}'),
(763,	199,	'_oembed_8a5691d0636b12f4e7361f4e1303cd9f',	'{{unknown}}'),
(762,	199,	'_edit_lock',	'1451336055:1'),
(764,	199,	'_oembed_454feec6e9ff845cbc28e22041997965',	'{{unknown}}'),
(765,	199,	'_oembed_8e4727e333350cdc09cb5c91b61cd4af',	'{{unknown}}'),
(766,	201,	'_edit_last',	'1'),
(770,	201,	'_oembed_f2a644da6f89b71c6b5aa069cd06971d',	'{{unknown}}'),
(769,	201,	'_edit_lock',	'1451336178:1'),
(771,	201,	'_oembed_786ba70f4d405d3cbfaa7a7a91dd5b4e',	'{{unknown}}'),
(772,	201,	'_oembed_f09a510d991eb67ccae373ec830590e6',	'{{unknown}}'),
(773,	203,	'_edit_last',	'1'),
(777,	203,	'_oembed_22c622cc73b9cd5dd7687a426efb01a4',	'{{unknown}}'),
(776,	203,	'_edit_lock',	'1451336301:1'),
(778,	203,	'_oembed_fee18fb5cfbebbb04631690c0b999ad2',	'{{unknown}}'),
(779,	203,	'_oembed_856b9c4ab461674c1569d4d3d9bbb674',	'{{unknown}}'),
(780,	205,	'_edit_last',	'1'),
(784,	205,	'_oembed_78a048233330ec0b76f6ef372c5826bc',	'{{unknown}}'),
(783,	205,	'_edit_lock',	'1451336424:1'),
(785,	205,	'_oembed_7c71f20ac679944a10d5fea9f713ab9b',	'{{unknown}}'),
(786,	205,	'_oembed_23ac8be7740da5a1486cdf043adb9351',	'{{unknown}}'),
(787,	207,	'_edit_last',	'1'),
(791,	207,	'_oembed_8b54e4bf1b9a53f940614f0cbd2ccfc2',	'{{unknown}}'),
(790,	207,	'_edit_lock',	'1451336547:1'),
(792,	207,	'_oembed_334e88265120e6c91fa256bf4e0ece68',	'{{unknown}}'),
(793,	207,	'_oembed_ab9f147aa4265c78b72f01dbaca596f3',	'{{unknown}}'),
(794,	209,	'_edit_last',	'1'),
(798,	209,	'_oembed_cd0d49a262642ec93a14947e02833955',	'{{unknown}}'),
(797,	209,	'_edit_lock',	'1451336670:1'),
(799,	209,	'_oembed_81b67c186ffaa20a850781c171d320a5',	'{{unknown}}'),
(800,	209,	'_oembed_d01108d45b32a3e0a49ef4a419aa58ca',	'{{unknown}}'),
(801,	211,	'_edit_last',	'1'),
(805,	211,	'_oembed_2da006e422ecf480ab8a607a352f550e',	'{{unknown}}'),
(807,	211,	'_oembed_83dc2dba48f425a01dc85784a98f5abe',	'{{unknown}}'),
(804,	211,	'_edit_lock',	'1451336792:1'),
(806,	211,	'_oembed_763463ec0dc17c09c1d732751a05655e',	'{{unknown}}'),
(808,	213,	'_edit_last',	'1'),
(812,	213,	'_oembed_a099321b45fcf6c677b5c59caa893629',	'{{unknown}}'),
(814,	213,	'_oembed_320437782a42cb2234e6eb585cedaf58',	'{{unknown}}'),
(811,	213,	'_edit_lock',	'1451336915:1'),
(813,	213,	'_oembed_68412b43d64c8ed6f02fd7dbc7ca57ed',	'{{unknown}}'),
(815,	215,	'_edit_last',	'1'),
(819,	215,	'_oembed_2582d54223f47aa1adaf0084ac53ae78',	'{{unknown}}'),
(821,	215,	'_oembed_3b5446b5f7c4f06c1c486b9764d170db',	'{{unknown}}'),
(818,	215,	'_edit_lock',	'1451337038:1'),
(820,	215,	'_oembed_c257076d32f04b33a6aa2a26bc1dbf90',	'{{unknown}}'),
(822,	217,	'_edit_last',	'1'),
(826,	217,	'_oembed_5e781b2d92261f85b726d7f67d631a57',	'{{unknown}}'),
(827,	217,	'_oembed_9aeafcbadb2178d54db6ace593710f89',	'{{unknown}}'),
(825,	217,	'_edit_lock',	'1451337162:1'),
(828,	217,	'_oembed_b818dab6fbd9c71cbdaaeeb69e8f30af',	'{{unknown}}'),
(829,	219,	'_edit_last',	'1'),
(833,	219,	'_oembed_ad35e6d9f4c97192631e7a4de54d80ef',	'{{unknown}}'),
(832,	219,	'_edit_lock',	'1451337285:1'),
(834,	219,	'_oembed_c741191412e57836cae2f34cc3fe1e47',	'{{unknown}}'),
(835,	219,	'_oembed_1f9d371f45a1baaaf53d860c4a52a8b6',	'{{unknown}}'),
(836,	221,	'_edit_last',	'1'),
(840,	221,	'_oembed_a4844c73c8e216dc914278c9356ecd8f',	'{{unknown}}'),
(839,	221,	'_edit_lock',	'1451337408:1'),
(841,	221,	'_oembed_eb5bab50500805d54faf6c3c7d278bbc',	'{{unknown}}'),
(842,	221,	'_oembed_b6cf64b121f403433389be59a2fe24ff',	'{{unknown}}'),
(843,	223,	'_edit_last',	'1'),
(847,	223,	'_oembed_404eddd601e2a4ccdfe6d0598c1445e6',	'{{unknown}}'),
(846,	223,	'_edit_lock',	'1451337531:1'),
(848,	223,	'_oembed_f0b67e86131d01526dbcf8b40a28e360',	'{{unknown}}'),
(849,	223,	'_oembed_6b470a01fe37c0569b9925e7b0b2a2a3',	'{{unknown}}'),
(850,	225,	'_edit_last',	'1'),
(854,	225,	'_oembed_adbcf2724f86d3a871c0833c8b9ae950',	'{{unknown}}'),
(853,	225,	'_edit_lock',	'1451337654:1'),
(855,	225,	'_oembed_a3766aa223aac30b323c49b0168f86a2',	'{{unknown}}'),
(856,	225,	'_oembed_9ca90549eebcf123bcfc1106c05fa925',	'{{unknown}}'),
(857,	227,	'_edit_last',	'1'),
(861,	227,	'_oembed_4aa73cb4c1da0fa5da14daed0706abf9',	'{{unknown}}'),
(860,	227,	'_edit_lock',	'1451337777:1'),
(862,	227,	'_oembed_6916224c4ff32baa3c6a29d237a9f177',	'{{unknown}}'),
(863,	227,	'_oembed_e6fd0fc49c0aa2f2eaef035706399848',	'{{unknown}}'),
(864,	229,	'_edit_last',	'1'),
(868,	229,	'_oembed_3a1bd31a4d1cab41dd9f2ea873698cff',	'{{unknown}}'),
(871,	231,	'_edit_last',	'1'),
(867,	229,	'_edit_lock',	'1451338536:1'),
(869,	229,	'_oembed_994602a934c43d1306da12e84f2d5ee6',	'{{unknown}}'),
(870,	229,	'_oembed_247aa199ca6993ab4b03f69b318d3393',	'{{unknown}}'),
(875,	231,	'_oembed_baf50439ae5cda80f92e977486ecccb3',	'{{unknown}}'),
(878,	233,	'_edit_last',	'1'),
(874,	231,	'_edit_lock',	'1451338659:1'),
(876,	231,	'_oembed_ec2d5e7df18d4be6f25129ba37b68a10',	'{{unknown}}'),
(877,	231,	'_oembed_299a97f80e685c41d37afb56047e9fef',	'{{unknown}}'),
(882,	233,	'_oembed_047f3edcdd6f2dca37348827e9b349ea',	'{{unknown}}'),
(881,	233,	'_edit_lock',	'1451338782:1'),
(883,	233,	'_oembed_524fb01208adce04ac47350bc199a3dd',	'{{unknown}}'),
(884,	233,	'_oembed_60a54e722016fbee99047e4ae07133ce',	'{{unknown}}'),
(885,	235,	'_edit_last',	'1'),
(889,	235,	'_oembed_50940297ee1b2b99bcc1ae04f6d74775',	'{{unknown}}'),
(891,	235,	'_oembed_6a1f032fc1820840a7a7cb3706965713',	'{{unknown}}'),
(888,	235,	'_edit_lock',	'1451338907:1'),
(890,	235,	'_oembed_817b72c33386eafedb1bca6cce6660da',	'{{unknown}}'),
(892,	238,	'_edit_last',	'1'),
(896,	238,	'_oembed_febd0b76f90d79dbe9c4117d2cbd812c',	'{{unknown}}'),
(895,	238,	'_edit_lock',	'1451339094:1'),
(897,	238,	'_oembed_94f6f980742f6a04be513fabe53c2abc',	'{{unknown}}'),
(898,	238,	'_oembed_c4d25aeac997199d400fd9eb8dfc185c',	'{{unknown}}'),
(899,	240,	'_edit_last',	'1'),
(903,	240,	'_oembed_58f3390496c35c25745b9f574c26e7af',	'{{unknown}}'),
(902,	240,	'_edit_lock',	'1451350836:1'),
(904,	240,	'_oembed_619a61589188bf5424110e118c3fa488',	'{{unknown}}'),
(905,	240,	'_oembed_14ce2b6426efe43b47c77d7519155b29',	'{{unknown}}'),
(906,	242,	'_edit_last',	'1'),
(910,	242,	'_oembed_9a280800980b7f0229af6aed4bb1758e',	'{{unknown}}'),
(909,	242,	'_edit_lock',	'1451350959:1'),
(911,	242,	'_oembed_9e1e7e9a2fd8366660c9fb7dd36e012f',	'{{unknown}}'),
(912,	242,	'_oembed_6b2e6102e34330dfeedfa2dc95e7299d',	'{{unknown}}'),
(913,	244,	'_edit_last',	'1'),
(917,	244,	'_oembed_09827a903b73ae1f6cedfc08a2626ea2',	'{{unknown}}'),
(916,	244,	'_edit_lock',	'1451351081:1'),
(918,	244,	'_oembed_c7de1826816ab00efe42c05e794e6ce6',	'{{unknown}}'),
(919,	244,	'_oembed_1d2aaad4c564eb8ce102e206b56c6f62',	'{{unknown}}'),
(920,	246,	'_edit_last',	'1'),
(924,	246,	'_oembed_0eb9ff5b4a0d6717752dacdbf5a8698a',	'{{unknown}}'),
(923,	246,	'_edit_lock',	'1451351205:1'),
(925,	246,	'_oembed_e25b4f6c6ae679a68a4713d32c13f353',	'{{unknown}}'),
(926,	246,	'_oembed_9958598ba7ba04cc8a5c938e3d653386',	'{{unknown}}'),
(927,	248,	'_edit_last',	'1'),
(931,	248,	'_oembed_54cf2527966444aa034c4e745ff82ad5',	'{{unknown}}'),
(930,	248,	'_edit_lock',	'1451351328:1'),
(932,	248,	'_oembed_ffb17248acb459fedb636395ba3e3457',	'{{unknown}}'),
(933,	248,	'_oembed_e998389d81fdfbd97bdccad345214f31',	'{{unknown}}'),
(934,	250,	'_edit_last',	'1'),
(938,	250,	'_oembed_963a325f4e0869946635f9c3b1903147',	'{{unknown}}'),
(941,	252,	'_edit_last',	'1'),
(937,	250,	'_edit_lock',	'1451351451:1'),
(939,	250,	'_oembed_ba2fe200c1f9aa4013f3569ba39814f1',	'{{unknown}}'),
(940,	250,	'_oembed_8fe88482efa1a99159e2c7a01a582488',	'{{unknown}}'),
(945,	252,	'_oembed_c57fef907bb0d672044ca67d994ec46c',	'{{unknown}}'),
(944,	252,	'_edit_lock',	'1451351574:1'),
(946,	252,	'_oembed_df53c0c4195647f6b657f39edb2816d5',	'{{unknown}}'),
(947,	252,	'_oembed_2c4f29ae67a7c35a468228221591f399',	'{{unknown}}'),
(948,	254,	'_edit_last',	'1'),
(952,	254,	'_oembed_e6ad04893646a4087821f3b306225d0a',	'{{unknown}}'),
(951,	254,	'_edit_lock',	'1451351697:1'),
(953,	254,	'_oembed_0f1071768e17a09051e8e0e9b30caaf8',	'{{unknown}}'),
(954,	254,	'_oembed_664e85f1e65cedfb30a83be23127818c',	'{{unknown}}'),
(955,	256,	'_edit_last',	'1'),
(959,	256,	'_oembed_4edb6703eef67289e1151e43dd65368b',	'{{unknown}}'),
(961,	256,	'_oembed_ab7f33ee7c15c6eb30cdf274a77784e7',	'{{unknown}}'),
(958,	256,	'_edit_lock',	'1451351819:1'),
(960,	256,	'_oembed_66dfc2bb0eddda45b656214bbd4f460f',	'{{unknown}}'),
(962,	258,	'_edit_last',	'1'),
(966,	258,	'_oembed_b2932800bbc69ed37188bf088613002d',	'{{unknown}}'),
(965,	258,	'_edit_lock',	'1451351942:1'),
(967,	258,	'_oembed_7f2f09d9cc3ce47700830b254e673608',	'{{unknown}}'),
(968,	258,	'_oembed_949eadc71d2ce221aa40fdf7c3daa79f',	'{{unknown}}'),
(969,	260,	'_edit_last',	'1'),
(973,	260,	'_oembed_ade3e26211a00f4895f257ac1b034451',	'{{unknown}}'),
(972,	260,	'_edit_lock',	'1451352065:1'),
(974,	260,	'_oembed_0959eb9842f692422f0d925211a0c5ab',	'{{unknown}}'),
(975,	260,	'_oembed_6fc5fc889f12aa2152d70e818dbb82a6',	'{{unknown}}'),
(976,	262,	'_edit_last',	'1'),
(980,	262,	'_oembed_80c303824f722c68edb07b1dc9f60126',	'{{unknown}}'),
(979,	262,	'_edit_lock',	'1451352928:1'),
(981,	262,	'_oembed_b52dd4b09be972de63320775c2c1e264',	'{{unknown}}'),
(982,	262,	'_oembed_50f4403b2d81a0ba8abbee16f0eddf8f',	'{{unknown}}'),
(983,	264,	'_edit_last',	'1'),
(987,	264,	'_oembed_d130abaec03559cd6ff88efc6af7a44a',	'{{unknown}}'),
(986,	264,	'_edit_lock',	'1451353052:1'),
(988,	264,	'_oembed_5039343de83a194a960b743ea4e11ef8',	'{{unknown}}'),
(989,	264,	'_oembed_4fc8b04f6d0ef694eddea78bd141559d',	'{{unknown}}'),
(990,	266,	'_edit_last',	'1'),
(994,	266,	'_oembed_335adc1447c43f965e41e1696556e977',	'{{unknown}}'),
(993,	266,	'_edit_lock',	'1451353175:1'),
(995,	266,	'_oembed_9241f00219471777c9185eb9374557f9',	'{{unknown}}'),
(996,	266,	'_oembed_0969719667b556ccafed8e2c89d94d3d',	'{{unknown}}'),
(997,	268,	'_edit_last',	'1'),
(1001,	268,	'_oembed_3a42d8c6c82bb83299057a2c04355969',	'{{unknown}}'),
(1000,	268,	'_edit_lock',	'1451353298:1'),
(1002,	268,	'_oembed_c6561d98598c74ce9336763dda574e38',	'{{unknown}}'),
(1003,	268,	'_oembed_b603c8d6cbc3830971663a00528b7999',	'{{unknown}}'),
(1004,	270,	'_edit_last',	'1'),
(1008,	270,	'_oembed_842e838ad01063cc9f87663d1b2280b1',	'{{unknown}}'),
(1007,	270,	'_edit_lock',	'1451353421:1'),
(1009,	270,	'_oembed_8ad51f15c182c013e8c1a77b6fee14ce',	'{{unknown}}'),
(1010,	270,	'_oembed_cd77792b97958a67c5c537568ba6a562',	'{{unknown}}'),
(1011,	272,	'_edit_last',	'1'),
(1015,	272,	'_oembed_f0bf08f6462bcf2a77334da49a1285db',	'{{unknown}}'),
(1014,	272,	'_edit_lock',	'1451353545:1'),
(1016,	272,	'_oembed_f7cb7e29079028c3e6de496db7051813',	'{{unknown}}'),
(1017,	272,	'_oembed_2db737da32fde84f94df4f236f1860bc',	'{{unknown}}'),
(1018,	274,	'_edit_last',	'1'),
(1022,	274,	'_oembed_49176aa17848bc748edd1c1208fe9cd4',	'{{unknown}}'),
(1021,	274,	'_edit_lock',	'1451353668:1'),
(1023,	274,	'_oembed_7aded15617d9f06d756caeac4527bdf4',	'{{unknown}}'),
(1024,	274,	'_oembed_e660d4384b180ea3fe423e4936f40350',	'{{unknown}}'),
(1025,	276,	'_edit_last',	'1'),
(1029,	276,	'_oembed_6122db57c576ae71fe3fe1287ac2e697',	'{{unknown}}'),
(1028,	276,	'_edit_lock',	'1451353792:1'),
(1030,	276,	'_oembed_20aac7482e8d770a0cb368e8b0359bb9',	'{{unknown}}'),
(1031,	276,	'_oembed_57ff862d87c6abf4598ba04074c905dc',	'{{unknown}}'),
(1032,	278,	'_edit_last',	'1'),
(1036,	278,	'_oembed_73aa8f9340834cf0c0240499b72a4e71',	'{{unknown}}'),
(1035,	278,	'_edit_lock',	'1451353915:1'),
(1037,	278,	'_oembed_ff4c1e982f86d517dc6926a7f7b28bc9',	'{{unknown}}'),
(1038,	278,	'_oembed_d6a8f145e6a135cc674064dcad0b9e73',	'{{unknown}}'),
(1039,	280,	'_edit_last',	'1'),
(1043,	280,	'_oembed_7917cab9d1e9510d1b154dd3b3392adf',	'{{unknown}}'),
(1042,	280,	'_edit_lock',	'1451354038:1'),
(1044,	280,	'_oembed_9e5d63681b8538f0e6fadfd69d4db0b4',	'{{unknown}}'),
(1045,	280,	'_oembed_df9257a3ce7c2fd101d2fed5724e77f1',	'{{unknown}}'),
(1046,	282,	'_edit_last',	'1'),
(1050,	282,	'_oembed_4c667f41a5f9a007cf00d6b683dd13cc',	'{{unknown}}'),
(1049,	282,	'_edit_lock',	'1451354161:1'),
(1051,	282,	'_oembed_1afe014cba24e515b05e80ae5af63b51',	'{{unknown}}'),
(1052,	282,	'_oembed_7efac954d57615cc7c87b8b4f66b1606',	'{{unknown}}'),
(1053,	284,	'_edit_last',	'1'),
(1057,	284,	'_oembed_27b34a8f6c562636c1ceee6d495c30bc',	'{{unknown}}'),
(1056,	284,	'_edit_lock',	'1451354285:1'),
(1058,	284,	'_oembed_6195ae454b1cbc6829b3d405e72e8fb1',	'{{unknown}}'),
(1059,	284,	'_oembed_2a0a3da3f39bd0816e723600b4352906',	'{{unknown}}'),
(1060,	286,	'_edit_last',	'1'),
(1064,	286,	'_oembed_b3eae3576f5aec3d42e7306159b9908b',	'{{unknown}}'),
(1063,	286,	'_edit_lock',	'1451354408:1'),
(1065,	286,	'_oembed_0f9ff4fa2a69d9a129565105713b9e38',	'{{unknown}}'),
(1066,	286,	'_oembed_2f10263ee58d0de2ff9fe0c36e93ab5b',	'{{unknown}}'),
(1067,	288,	'_edit_last',	'1'),
(1071,	288,	'_oembed_a065ae541b85b06cc4a872dc287743ce',	'{{unknown}}'),
(1070,	288,	'_edit_lock',	'1451354530:1'),
(1072,	288,	'_oembed_0d17c22fd96535bf2b7dc5e55f3fabf8',	'{{unknown}}'),
(1073,	288,	'_oembed_2a4c64bba258fb49d5f3323980d3000f',	'{{unknown}}'),
(1074,	290,	'_edit_last',	'1'),
(1078,	290,	'_oembed_fd57cda972709decd9e4f06c8d7b0465',	'{{unknown}}'),
(1077,	290,	'_edit_lock',	'1451354654:1'),
(1079,	290,	'_oembed_fd4f9ceb28d03f6bb3d947f6e84e66db',	'{{unknown}}'),
(1080,	290,	'_oembed_cf7d946028f75abb2027fb1b2c2fe243',	'{{unknown}}'),
(1081,	292,	'_edit_last',	'1'),
(1085,	292,	'_oembed_65ea42a3a95e3155c7eefd29715deb85',	'{{unknown}}'),
(1084,	292,	'_edit_lock',	'1451354777:1'),
(1086,	292,	'_oembed_69e72b18be3b3f7ecf57bd077eff64af',	'{{unknown}}'),
(1087,	292,	'_oembed_d866c661136eecdf0f1c546a1c9c2f58',	'{{unknown}}'),
(1088,	294,	'_edit_last',	'1'),
(1092,	294,	'_oembed_f2e885afbb1d4daaec8660c8b18e2eb0',	'{{unknown}}'),
(1091,	294,	'_edit_lock',	'1451354899:1'),
(1093,	294,	'_oembed_5183af6c6e1970bdfeb1498678b7fa47',	'{{unknown}}'),
(1094,	294,	'_oembed_774df0905c01d675f088188b88ee57a8',	'{{unknown}}'),
(1095,	296,	'_edit_last',	'1'),
(1099,	296,	'_oembed_9c01ee76dd8edc3bc525e6e2cf79f66e',	'{{unknown}}'),
(1098,	296,	'_edit_lock',	'1451355023:1'),
(1100,	296,	'_oembed_c76e7d392c94f8cd515929eead786a50',	'{{unknown}}'),
(1101,	296,	'_oembed_0c2cfd5c78c39db0ed818dd5c641d72e',	'{{unknown}}'),
(1102,	298,	'_edit_last',	'1'),
(1106,	298,	'_oembed_7661e64a020752f6198cd6f1834709c6',	'{{unknown}}'),
(1105,	298,	'_edit_lock',	'1451355146:1'),
(1107,	298,	'_oembed_d7502380ccc027a125be3b518273a58b',	'{{unknown}}'),
(1108,	298,	'_oembed_9ecc045cdf25794cde52bfc36d2c8243',	'{{unknown}}'),
(1109,	300,	'_edit_last',	'1'),
(1113,	300,	'_oembed_b9f570d5fd65bdc320bc04cb97aad6ca',	'{{unknown}}'),
(1115,	300,	'_oembed_7ba6258e8620f1ece8dfae989f2e8284',	'{{unknown}}'),
(1112,	300,	'_edit_lock',	'1451355269:1'),
(1114,	300,	'_oembed_b947d5aed81f3c5800d3b52101a9f854',	'{{unknown}}'),
(1116,	302,	'_edit_last',	'1'),
(1120,	302,	'_oembed_5d0776af7cc99a8b76559cf8d8be607a',	'{{unknown}}'),
(1119,	302,	'_edit_lock',	'1451355392:1'),
(1121,	302,	'_oembed_26d7a9755a58b8fc7f0e36f6f5d9f08f',	'{{unknown}}'),
(1122,	302,	'_oembed_e86d46dcbdd43354b2a8173db7f8bbb0',	'{{unknown}}'),
(1123,	304,	'_edit_last',	'1'),
(1127,	304,	'_oembed_ca6d73e71c9736a6c90cc2d2dde8f00e',	'{{unknown}}'),
(1126,	304,	'_edit_lock',	'1451355515:1'),
(1128,	304,	'_oembed_cc7a0e6d4438b9dd17eab2a8c9992a37',	'{{unknown}}'),
(1129,	304,	'_oembed_8d63fa9a988e17285be9e178101107ea',	'{{unknown}}'),
(1130,	306,	'_edit_last',	'1'),
(1134,	306,	'_oembed_05cf6a421e5ddb623c7eb2ceee09e8a2',	'{{unknown}}'),
(1133,	306,	'_edit_lock',	'1451355638:1'),
(1135,	306,	'_oembed_3fb3e2800efa2f5489c5eb6446d23cdf',	'{{unknown}}'),
(1136,	306,	'_oembed_1ede02ece63a9fa7eae39ed5d954daae',	'{{unknown}}'),
(1137,	308,	'_edit_last',	'1'),
(1141,	308,	'_oembed_466f11c0d9db272c62249a996b220d1b',	'{{unknown}}'),
(1140,	308,	'_edit_lock',	'1451355762:1'),
(1142,	308,	'_oembed_d3ea73891dec08e4c147fd1238c7d264',	'{{unknown}}'),
(1143,	308,	'_oembed_92684f8003c72bb1cfde5fd422988b96',	'{{unknown}}'),
(1144,	310,	'_edit_last',	'1'),
(1148,	310,	'_oembed_c1162657a726dca787117dac46842b82',	'{{unknown}}'),
(1147,	310,	'_edit_lock',	'1451355885:1'),
(1149,	310,	'_oembed_fc85edbb5ca5ac69291f940125b4ae9b',	'{{unknown}}'),
(1150,	310,	'_oembed_f50e05d54f09c6069ce35d169e815ffc',	'{{unknown}}'),
(1151,	312,	'_edit_last',	'1'),
(1155,	312,	'_oembed_71ea9c3080e89b2bcdfa7f15b41a52f7',	'{{unknown}}'),
(1156,	312,	'_oembed_fea079190f9792ddb704450ad08e30b8',	'{{unknown}}'),
(1154,	312,	'_edit_lock',	'1451356008:1'),
(1157,	312,	'_oembed_bbddd0de93ba12cf80d5906da95f94e6',	'{{unknown}}'),
(1158,	314,	'_edit_last',	'1'),
(1162,	314,	'_oembed_128ec830aa8e8282a1574071c8593352',	'{{unknown}}'),
(1164,	314,	'_oembed_81c1d1ec1a4346a0e5d6558ebd00fa4a',	'{{unknown}}'),
(1161,	314,	'_edit_lock',	'1451356131:1'),
(1163,	314,	'_oembed_839d03cd2a90b244be65238bc32a21a6',	'{{unknown}}'),
(1165,	316,	'_edit_last',	'1'),
(1169,	316,	'_oembed_ba59ba146e1cd80ec3f2dd8dcf82d555',	'{{unknown}}'),
(1168,	316,	'_edit_lock',	'1451356253:1'),
(1170,	316,	'_oembed_1a1e5fb4b7a1305b260fce6987766d4d',	'{{unknown}}'),
(1171,	316,	'_oembed_fe511c5ffca491f5071cb3a74943dd5a',	'{{unknown}}'),
(1172,	318,	'_edit_last',	'1'),
(1176,	318,	'_oembed_72a9ae1489289c1fd26e4933a562a072',	'{{unknown}}'),
(1175,	318,	'_edit_lock',	'1451356544:1'),
(1177,	318,	'_oembed_bc5a7b4fef754ec3978e6c357604efb4',	'{{unknown}}'),
(1178,	318,	'_oembed_25a333ec85895d0b3c4a0f303f979ca5',	'{{unknown}}'),
(1179,	320,	'_edit_last',	'1'),
(1183,	320,	'_oembed_309b244e25574d7659f5bb4cfe2c47fc',	'{{unknown}}'),
(1182,	320,	'_edit_lock',	'1451356668:1'),
(1184,	320,	'_oembed_5435f258ac0e0a9363446b4e45e845f1',	'{{unknown}}'),
(1185,	320,	'_oembed_472f65fa35d2af1e1f4a3f85f1f6397e',	'{{unknown}}'),
(1186,	322,	'_edit_last',	'1'),
(1190,	322,	'_oembed_580dde6d86c5c473c4929e7b3044539d',	'{{unknown}}'),
(1189,	322,	'_edit_lock',	'1451356791:1'),
(1191,	322,	'_oembed_ca6f337eaefc6b44deba95ba9ca417d7',	'{{unknown}}'),
(1192,	322,	'_oembed_c0cdcae06c1b08b7ecc65765686454f9',	'{{unknown}}'),
(1193,	324,	'_edit_last',	'1'),
(1197,	324,	'_oembed_0f009c9dd431d54ddbdfc10a0951e3ef',	'{{unknown}}'),
(1196,	324,	'_edit_lock',	'1451356914:1'),
(1198,	324,	'_oembed_49aca27c29ad90b6c35ade5c84bd04aa',	'{{unknown}}'),
(1199,	324,	'_oembed_75768276c6d05ebeb359bd355c58a9e6',	'{{unknown}}'),
(1200,	326,	'_edit_last',	'1'),
(1204,	326,	'_oembed_5157faf7502c731a7f12928e017eb619',	'{{unknown}}'),
(1203,	326,	'_edit_lock',	'1451357038:1'),
(1205,	326,	'_oembed_a8e437a693cce2c70a6c855172e529be',	'{{unknown}}'),
(1206,	326,	'_oembed_50f47a06b3bf024a50566f8e4f4046b2',	'{{unknown}}'),
(1207,	328,	'_edit_last',	'1'),
(1211,	328,	'_oembed_139d228e0d8ca8342be02ffe0bc2928b',	'{{unknown}}'),
(1210,	328,	'_edit_lock',	'1451357161:1'),
(1212,	328,	'_oembed_e2463f71ebf3c9195a73b5b9fef79ad4',	'{{unknown}}'),
(1213,	328,	'_oembed_17eda09fb0435be30ca230ec46c09679',	'{{unknown}}'),
(1214,	330,	'_edit_last',	'1'),
(1218,	330,	'_oembed_5f9fb2975ea7f6c8bc847551a2469a12',	'{{unknown}}'),
(1217,	330,	'_edit_lock',	'1451357284:1'),
(1219,	330,	'_oembed_7547b6a887ff10a82ddcc31a7107f9cd',	'{{unknown}}'),
(1220,	330,	'_oembed_1efd58666926473aaa692772245e1a58',	'{{unknown}}'),
(1221,	332,	'_edit_last',	'1'),
(1225,	332,	'_oembed_92725ac760c31191f30c7ee537489921',	'{{unknown}}'),
(1228,	334,	'_edit_last',	'1'),
(1224,	332,	'_edit_lock',	'1451357406:1'),
(1226,	332,	'_oembed_6e2234607fb0cae628f924b7b399f2f5',	'{{unknown}}'),
(1227,	332,	'_oembed_9a1b7983ccee481901de06eca926e12a',	'{{unknown}}'),
(1232,	334,	'_oembed_bb0535ca0e62157a5aef255f74a8030d',	'{{unknown}}'),
(1231,	334,	'_edit_lock',	'1451357529:1'),
(1233,	334,	'_oembed_82e2269587967d92857907c8048e6977',	'{{unknown}}'),
(1234,	334,	'_oembed_2e4e5ff5889878283b17c813d700f129',	'{{unknown}}'),
(1235,	336,	'_edit_last',	'1'),
(1239,	336,	'_oembed_1579d61e5e35045e72aa9dae89de5ee3',	'{{unknown}}'),
(1238,	336,	'_edit_lock',	'1451357652:1'),
(1240,	336,	'_oembed_af55af6d63c72940be0c23d5ab888d1a',	'{{unknown}}'),
(1241,	336,	'_oembed_46397b4cc582e30a1f3c337ca1ce2f1e',	'{{unknown}}'),
(1242,	338,	'_edit_last',	'1'),
(1246,	338,	'_oembed_81bd3b47ea9f37bed4ac898863c309fb',	'{{unknown}}'),
(1245,	338,	'_edit_lock',	'1451357775:1'),
(1247,	338,	'_oembed_7854439e1454f3261e00ff1e5193128d',	'{{unknown}}'),
(1248,	338,	'_oembed_63965b28119d30b07da01042055247ce',	'{{unknown}}'),
(1249,	340,	'_edit_last',	'1'),
(1253,	340,	'_oembed_2602cbef9a348ad6cb6bc6b14c19e99b',	'{{unknown}}'),
(1252,	340,	'_edit_lock',	'1451357898:1'),
(1254,	340,	'_oembed_a4ac004e32a6519edbe520b201b3be2c',	'{{unknown}}'),
(1255,	340,	'_oembed_5622df36a67cc962cd9ddc11a1744d91',	'{{unknown}}'),
(1256,	342,	'_edit_last',	'1'),
(1260,	342,	'_oembed_8a1ece160e15429a48712e85e258fe3e',	'{{unknown}}'),
(1259,	342,	'_edit_lock',	'1451358020:1'),
(1261,	342,	'_oembed_5e819b33fb57b56e6193df0dd4a5e1b2',	'{{unknown}}'),
(1262,	342,	'_oembed_a68d4647b54d760e016ed4190807536d',	'{{unknown}}'),
(1263,	344,	'_edit_last',	'1'),
(1267,	344,	'_oembed_2a1026dbc71bb46955f86340b7aa5893',	'{{unknown}}'),
(1266,	344,	'_edit_lock',	'1451358143:1'),
(1268,	344,	'_oembed_60922a56a8f45163ded0f845007709fd',	'{{unknown}}'),
(1269,	344,	'_oembed_939d8acc315cfad28efd90c74008a4d4',	'{{unknown}}'),
(1270,	346,	'_edit_last',	'1'),
(1274,	346,	'_oembed_80199b6365c6f0cb7088920ccde77b2f',	'{{unknown}}'),
(1273,	346,	'_edit_lock',	'1451358266:1'),
(1275,	346,	'_oembed_a5cc32873256f592e6f063c6f0698e55',	'{{unknown}}'),
(1276,	346,	'_oembed_a4ac70371fadfb27591e77dff77c6dfb',	'{{unknown}}'),
(1277,	348,	'_edit_last',	'1'),
(1281,	348,	'_oembed_7de7862bfabaf577b9361f708a170d30',	'{{unknown}}'),
(1280,	348,	'_edit_lock',	'1451358389:1'),
(1282,	348,	'_oembed_fada1f2311c20b5678563690aa7368e4',	'{{unknown}}'),
(1283,	348,	'_oembed_78671ce0cd12aa9c5c2d955a188dd5dd',	'{{unknown}}'),
(1284,	350,	'_edit_last',	'1'),
(1288,	350,	'_oembed_3f2dea653aad7380cb333f7acf9f5129',	'{{unknown}}'),
(1287,	350,	'_edit_lock',	'1451358512:1'),
(1289,	350,	'_oembed_08a5bbc68fbb6d7e00154c07f7017647',	'{{unknown}}'),
(1290,	350,	'_oembed_4eedc7e561c3e28126bb332dda0a294b',	'{{unknown}}'),
(1291,	352,	'_edit_last',	'1'),
(1295,	352,	'_oembed_452a5c5469302b66316ca72baeff868c',	'{{unknown}}'),
(1294,	352,	'_edit_lock',	'1451358635:1'),
(1296,	352,	'_oembed_bb9d1ce858f1a40d5eb9e06b158753c5',	'{{unknown}}'),
(1297,	352,	'_oembed_539da5e8d882e0327c4809e630956f1b',	'{{unknown}}'),
(1298,	354,	'_edit_last',	'1'),
(1302,	354,	'_oembed_01c22c9a979775d2813efe22c37b34ac',	'{{unknown}}'),
(1304,	354,	'_oembed_a72e450a3469f39a6ab9295cb38a88f3',	'{{unknown}}'),
(1301,	354,	'_edit_lock',	'1451358758:1'),
(1303,	354,	'_oembed_0b98b3160ca4361f3eaf431e5774c43c',	'{{unknown}}'),
(1305,	356,	'_edit_last',	'1'),
(1309,	356,	'_oembed_6014dfde7379353bcb47144d49d30226',	'{{unknown}}'),
(1308,	356,	'_edit_lock',	'1451358881:1'),
(1310,	356,	'_oembed_14600f527db9e55e9e8ff39150dbc4c1',	'{{unknown}}'),
(1311,	356,	'_oembed_a16f26232de7b794963f48c7c350bfd1',	'{{unknown}}'),
(1312,	358,	'_edit_last',	'1'),
(1316,	358,	'_oembed_bcd5e56255e760099256e139270fef3a',	'{{unknown}}'),
(1318,	358,	'_oembed_7afac906ddd4fe6bea9afb6fd9951c59',	'{{unknown}}'),
(1315,	358,	'_edit_lock',	'1451359006:1'),
(1317,	358,	'_oembed_689b6f8db804b8367240bf98b7005008',	'{{unknown}}'),
(1319,	360,	'_edit_last',	'1'),
(1323,	360,	'_oembed_5243357010f4d862d203dd3d0252faad',	'{{unknown}}'),
(1322,	360,	'_edit_lock',	'1451359128:1'),
(1324,	360,	'_oembed_18601f9096bb0cc95b480d1dcd669ba2',	'{{unknown}}'),
(1325,	360,	'_oembed_7a24cd6c4f4a36324efa2b2e32458ef8',	'{{unknown}}'),
(1326,	362,	'_edit_last',	'1'),
(1330,	362,	'_oembed_e57685928a1531bb0c4c8ae73dbef8e8',	'{{unknown}}'),
(1333,	364,	'_edit_last',	'1'),
(1329,	362,	'_edit_lock',	'1451359252:1'),
(1331,	362,	'_oembed_61916fe00fd65c09233115e7f5fa2bc4',	'{{unknown}}'),
(1332,	362,	'_oembed_4842bea821c7ba3d0a6ee423bf3af5da',	'{{unknown}}'),
(1337,	364,	'_oembed_beca46d3d3214221cb45f86b0d9080b0',	'{{unknown}}'),
(1336,	364,	'_edit_lock',	'1451359375:1'),
(1338,	364,	'_oembed_e12bb1e766fe9eb1180d1c044a5c8c67',	'{{unknown}}'),
(1339,	364,	'_oembed_4d8ea36104419bbcc50bbe8b725572c0',	'{{unknown}}'),
(1340,	366,	'_edit_last',	'1'),
(1344,	366,	'_oembed_d69457585f722cb4575030deae6fadf0',	'{{unknown}}'),
(1345,	366,	'_oembed_1e1e0aa2ab33eaf6e3acb4264f44f128',	'{{unknown}}'),
(1343,	366,	'_edit_lock',	'1451359498:1'),
(1346,	366,	'_oembed_b5fdd131c9a06660cd60d4cf71376d5b',	'{{unknown}}'),
(1347,	368,	'_edit_last',	'1'),
(1351,	368,	'_oembed_8bf96b7b7cff0222198915651b100090',	'{{unknown}}'),
(1350,	368,	'_edit_lock',	'1451359621:1'),
(1352,	368,	'_oembed_70ca497d31bad9d3dab6362d80ee0a45',	'{{unknown}}'),
(1353,	368,	'_oembed_3b581a31d5f91f56394b2e3bbbb6f38b',	'{{unknown}}'),
(1354,	370,	'_edit_last',	'1'),
(1358,	370,	'_oembed_22c4468599ed4c6296eba3fbd1ad12a6',	'{{unknown}}'),
(1357,	370,	'_edit_lock',	'1451359983:1'),
(1359,	370,	'_oembed_4a2e58c02e39298eef21c1add400745b',	'{{unknown}}'),
(1360,	370,	'_oembed_b51a92321d4fca4990eedb28257caf13',	'{{unknown}}'),
(1361,	372,	'_edit_last',	'1'),
(1365,	372,	'_oembed_9564af4b4776fa970bac290809b751d5',	'{{unknown}}'),
(1364,	372,	'_edit_lock',	'1451359867:1'),
(1366,	372,	'_oembed_e273db11ea8db722215dcad696db37cd',	'{{unknown}}'),
(1367,	372,	'_oembed_5e848bcfc89a8bc03dd4e3d6526751b0',	'{{unknown}}'),
(1371,	374,	'_edit_last',	'1'),
(1382,	376,	'_oembed_3e7803383ce5909b19676b5c07af3934',	'{{unknown}}'),
(1378,	376,	'_edit_last',	'1'),
(1374,	374,	'_edit_lock',	'1451359990:1'),
(1375,	374,	'_oembed_758706de8d391eb5dd73f3c6c2e6d793',	'{{unknown}}'),
(1376,	374,	'_oembed_b6ec622856fe549298dce080aff976de',	'{{unknown}}'),
(1377,	374,	'_oembed_551245a0107052dc51a8c005229d0f37',	'{{unknown}}'),
(1383,	376,	'_oembed_eda896f7b7d0d69c6cf5b2a74ef0794c',	'{{unknown}}'),
(1381,	376,	'_edit_lock',	'1451360113:1'),
(1384,	376,	'_oembed_a24ea9ed8bb66a33193d7a22d605b69b',	'{{unknown}}'),
(1385,	378,	'_edit_last',	'1'),
(1389,	378,	'_oembed_65b7aa5af200ce8ada53a74d8425a3ed',	'{{unknown}}'),
(1391,	378,	'_oembed_f976c63ab7df0f9fd61e3faff3974381',	'{{unknown}}'),
(1388,	378,	'_edit_lock',	'1451360236:1'),
(1390,	378,	'_oembed_4d44c20cdee0e553abd2529e3fbcdcf1',	'{{unknown}}'),
(1392,	380,	'_edit_last',	'1'),
(1396,	380,	'_oembed_a4dcf17c4952c2db74b6d07c17162648',	'{{unknown}}'),
(1395,	380,	'_edit_lock',	'1451360360:1'),
(1397,	380,	'_oembed_dc41f22b3e813efafda6ad8f83fcde2b',	'{{unknown}}'),
(1398,	380,	'_oembed_b0d9c2ea4181aad939f9e3fa7e493f3d',	'{{unknown}}'),
(1399,	382,	'_edit_last',	'1'),
(1403,	382,	'_oembed_f7ceb72260814b70f9849440dee50310',	'{{unknown}}'),
(1402,	382,	'_edit_lock',	'1451360483:1'),
(1404,	382,	'_oembed_7f7953ba81845649cb0fe5ebbd94bfdb',	'{{unknown}}'),
(1405,	382,	'_oembed_60ea554a85be50453d09fbd9e401c8e9',	'{{unknown}}'),
(1406,	384,	'_edit_last',	'1'),
(1410,	384,	'_oembed_741df88dce56a2fcec9c88ff89484d10',	'{{unknown}}'),
(1409,	384,	'_edit_lock',	'1451360606:1'),
(1411,	384,	'_oembed_ba80021b724f3f92db0cf59c4228b1c2',	'{{unknown}}'),
(1412,	384,	'_oembed_1f8729d055cd2b8443d0fa15e3969ac8',	'{{unknown}}'),
(1413,	386,	'_edit_last',	'1'),
(1417,	386,	'_oembed_7cefb096192d4cf27683f32d88356d45',	'{{unknown}}'),
(1416,	386,	'_edit_lock',	'1451360729:1'),
(1418,	386,	'_oembed_cea12cdad8905df5aaad93eace726844',	'{{unknown}}'),
(1419,	386,	'_oembed_a104110400a0f4473fa2c6f2a7319b32',	'{{unknown}}'),
(1420,	388,	'_edit_last',	'1'),
(1424,	388,	'_oembed_afe1be399e33eb01ce9cc9eaa8ba3dbe',	'{{unknown}}'),
(1423,	388,	'_edit_lock',	'1451360852:1'),
(1425,	388,	'_oembed_4be9532d0fc44223a89428d4ab19335b',	'{{unknown}}'),
(1426,	388,	'_oembed_02144e85958a64a84ff272c0b91bd748',	'{{unknown}}'),
(1427,	390,	'_edit_last',	'1'),
(1431,	390,	'_oembed_579ef9154d963895c890955cb4154a64',	'{{unknown}}'),
(1430,	390,	'_edit_lock',	'1451360975:1'),
(1432,	390,	'_oembed_11cf61156d204bc374236c6cd917624e',	'{{unknown}}'),
(1433,	390,	'_oembed_ae4387841646430a32b4c31939fd744f',	'{{unknown}}'),
(1434,	392,	'_edit_last',	'1'),
(1438,	392,	'_oembed_1835d6469944b6b51e3997c80fdac90f',	'{{unknown}}'),
(1437,	392,	'_edit_lock',	'1451361098:1'),
(1439,	392,	'_oembed_f740493ce613e0c1e0a2af92eabf8b8f',	'{{unknown}}'),
(1440,	392,	'_oembed_1198280951d0324b22509d402f48d61e',	'{{unknown}}'),
(1441,	394,	'_edit_last',	'1'),
(1445,	394,	'_oembed_df72691268c5b25d04ffae178834edb3',	'{{unknown}}'),
(1448,	396,	'_edit_last',	'1'),
(1444,	394,	'_edit_lock',	'1451361222:1'),
(1446,	394,	'_oembed_0a7bfd90819d512538db196f2a90a182',	'{{unknown}}'),
(1447,	394,	'_oembed_7c7865696dad97cba7ca273a6e40327a',	'{{unknown}}'),
(1452,	396,	'_oembed_e125c0aadfa5a599dd95fadf618c0c2a',	'{{unknown}}'),
(1454,	396,	'_oembed_366d20cdb7d764d9a8098b2e34720150',	'{{unknown}}'),
(1451,	396,	'_edit_lock',	'1451361345:1'),
(1453,	396,	'_oembed_ddf00d619b61746bb17b9169036e6d82',	'{{unknown}}'),
(1455,	398,	'_edit_last',	'1'),
(1459,	398,	'_oembed_99b11a38eec01b2787bac96ecc16d395',	'{{unknown}}'),
(1458,	398,	'_edit_lock',	'1451361468:1'),
(1460,	398,	'_oembed_21190aef7d31ac94c0f597cc05728f76',	'{{unknown}}'),
(1461,	398,	'_oembed_b7780c51e083b7b151a801d2bb271d13',	'{{unknown}}'),
(1462,	400,	'_edit_last',	'1'),
(1466,	400,	'_oembed_4558bddfbdd4c40ea75bbfe8fdc13d7a',	'{{unknown}}'),
(1465,	400,	'_edit_lock',	'1451361591:1'),
(1467,	400,	'_oembed_06f903d413c952efabe5559e1f5a9e04',	'{{unknown}}'),
(1468,	400,	'_oembed_53988b6c74e3e5b9890a26b99e1f0a90',	'{{unknown}}'),
(1469,	402,	'_edit_last',	'1'),
(1473,	402,	'_oembed_c7c864dd5b13532f8235680b8ed4c029',	'{{unknown}}'),
(1472,	402,	'_edit_lock',	'1451361714:1'),
(1474,	402,	'_oembed_9b2de28ad4fef13cd4e3b7cfa012c226',	'{{unknown}}'),
(1475,	402,	'_oembed_26ad2b3aa4246b2a130f1e73322e8209',	'{{unknown}}'),
(1476,	404,	'_edit_last',	'1'),
(1480,	404,	'_oembed_e0f5754569c945548a090f3a83f5dda7',	'{{unknown}}'),
(1479,	404,	'_edit_lock',	'1451361838:1'),
(1481,	404,	'_oembed_0c165b52d36bab489e29fe006db19842',	'{{unknown}}'),
(1482,	404,	'_oembed_67e68aadf22f904854238cfb968767e2',	'{{unknown}}'),
(1483,	406,	'_edit_last',	'1'),
(1487,	406,	'_oembed_8bdd78fec3c0d3d499d29af61596e2d8',	'{{unknown}}'),
(1486,	406,	'_edit_lock',	'1451361961:1'),
(1488,	406,	'_oembed_7040c4a6d5a1142fefba2da00979a121',	'{{unknown}}'),
(1489,	406,	'_oembed_08229c4d6a77778524868609eecf67c3',	'{{unknown}}'),
(1490,	408,	'_edit_last',	'1'),
(1494,	408,	'_oembed_1820b73e5ce0412b5fde35e30559ffbb',	'{{unknown}}'),
(1493,	408,	'_edit_lock',	'1451362086:1'),
(1495,	408,	'_oembed_9ccee9ab874d9d164eee61f1a305944e',	'{{unknown}}'),
(1496,	408,	'_oembed_9f24059d2d24c351d66649ef367752bb',	'{{unknown}}'),
(1497,	410,	'_edit_last',	'1'),
(1501,	410,	'_oembed_28b213cd213ce75c557a5a184ac499ce',	'{{unknown}}'),
(1500,	410,	'_edit_lock',	'1451362209:1'),
(1502,	410,	'_oembed_10f2b9f2771444cd5cb873228d179cb1',	'{{unknown}}'),
(1503,	410,	'_oembed_e2a8df275f6a25af15e24376de07536b',	'{{unknown}}'),
(1504,	412,	'_edit_last',	'1'),
(1508,	412,	'_oembed_51cbae62aea32b1242152c48a641aa7d',	'{{unknown}}'),
(1507,	412,	'_edit_lock',	'1451362332:1'),
(1509,	412,	'_oembed_276508d8d6e18aa6b359d9c10acf98ed',	'{{unknown}}'),
(1510,	412,	'_oembed_dd54cc50d105c2286ee73592528ece64',	'{{unknown}}'),
(1511,	414,	'_edit_last',	'1'),
(1515,	414,	'_oembed_008cde918488fa334e91f96fa305386c',	'{{unknown}}'),
(1514,	414,	'_edit_lock',	'1451362455:1'),
(1516,	414,	'_oembed_3eef494a9e959b9e877b8c072b02da7c',	'{{unknown}}'),
(1517,	414,	'_oembed_41d13abb682a6a0e1ab17c59a42d45f7',	'{{unknown}}'),
(1518,	416,	'_edit_last',	'1'),
(1522,	416,	'_oembed_171f9f741ce6a9a357404b21ce8bfabb',	'{{unknown}}'),
(1521,	416,	'_edit_lock',	'1451362579:1'),
(1523,	416,	'_oembed_b2023303130ecfc399f7296242ecbe48',	'{{unknown}}'),
(1524,	416,	'_oembed_cae73dd6f4c906623b0ae00d5b3e71ac',	'{{unknown}}'),
(1525,	418,	'_edit_last',	'1'),
(1529,	418,	'_oembed_daca32a0cf5923e06a72abc6eec33963',	'{{unknown}}'),
(1528,	418,	'_edit_lock',	'1451362701:1'),
(1530,	418,	'_oembed_e90e342e6347cd908673c3b02a585c59',	'{{unknown}}'),
(1531,	418,	'_oembed_ce4c5e2774a13d0439a518562efc13eb',	'{{unknown}}'),
(1532,	420,	'_edit_last',	'1'),
(1536,	420,	'_oembed_46507be9cd83913409b91043ae2bb0c9',	'{{unknown}}'),
(1535,	420,	'_edit_lock',	'1451362825:1'),
(1537,	420,	'_oembed_c99baf6de05327ddfda2f9405a9fe956',	'{{unknown}}'),
(1538,	420,	'_oembed_a6e4452404321e4ef6dc3de2247b43b5',	'{{unknown}}'),
(1539,	422,	'_edit_last',	'1'),
(1543,	422,	'_oembed_74e46490802fb69242d108dc548a2968',	'{{unknown}}'),
(1542,	422,	'_edit_lock',	'1451362948:1'),
(1544,	422,	'_oembed_dcebcff803a01d172bc4ecb0d5c5ef68',	'{{unknown}}'),
(1545,	422,	'_oembed_aa9522da229345e5180b32cd1c9f663c',	'{{unknown}}'),
(1546,	424,	'_edit_last',	'1'),
(1550,	424,	'_oembed_eddd6866fd3992194c70320754a14c87',	'{{unknown}}'),
(1549,	424,	'_edit_lock',	'1451363071:1'),
(1551,	424,	'_oembed_b9070e5892cf4e0441a4cbfa80502acc',	'{{unknown}}'),
(1552,	424,	'_oembed_fc6c19a32f11e2c7e8e0a233a9d55456',	'{{unknown}}'),
(1553,	426,	'_edit_last',	'1'),
(1557,	426,	'_oembed_0ff2ff172535dbb07beb63c4bec80d71',	'{{unknown}}'),
(1556,	426,	'_edit_lock',	'1451363194:1'),
(1558,	426,	'_oembed_3e59e11165e54eff0fcdb1d70edc922f',	'{{unknown}}'),
(1559,	426,	'_oembed_b0955b2d4c304910dc02775e3f775a58',	'{{unknown}}'),
(1560,	428,	'_edit_last',	'1'),
(1564,	428,	'_oembed_98b97ac9f61a0856ee16442ccc327d98',	'{{unknown}}'),
(1563,	428,	'_edit_lock',	'1451363318:1'),
(1565,	428,	'_oembed_930c930ae3294801e8dd4bfe57f86378',	'{{unknown}}'),
(1566,	428,	'_oembed_8c32597b7a073d6851e76903081ab11f',	'{{unknown}}'),
(1567,	430,	'_edit_last',	'1'),
(1571,	430,	'_oembed_a21636512878d7145660b1c51f28fefc',	'{{unknown}}'),
(1570,	430,	'_edit_lock',	'1451363442:1'),
(1572,	430,	'_oembed_363aa980566931ec1f19f35ac8929838',	'{{unknown}}'),
(1573,	430,	'_oembed_33ef0234efff89ca7e348217759905d2',	'{{unknown}}'),
(1574,	432,	'_edit_last',	'1'),
(1578,	432,	'_oembed_3e4f93783b4cd4e980e2e59d5a79e9c8',	'{{unknown}}'),
(1577,	432,	'_edit_lock',	'1451363565:1'),
(1579,	432,	'_oembed_1e159d79684c25ddb83a0a07b2f22392',	'{{unknown}}'),
(1580,	432,	'_oembed_0b16735b3f8543f4a6d22aca61e1a29f',	'{{unknown}}'),
(1581,	434,	'_edit_last',	'1'),
(1585,	434,	'_oembed_3cf153f82950b5cc9236511fdb698747',	'{{unknown}}'),
(1584,	434,	'_edit_lock',	'1451363688:1'),
(1586,	434,	'_oembed_dbda0f270079c0e944f6a8d7b3bf4c6c',	'{{unknown}}'),
(1587,	434,	'_oembed_9622308b6c024ea8884b90d0e139eb7e',	'{{unknown}}'),
(1588,	436,	'_edit_last',	'1'),
(1592,	436,	'_oembed_a4cf13e6868a2d8d3852f29df6051878',	'{{unknown}}'),
(1593,	436,	'_oembed_d9eaaf24037409a5d7ce96b7aa595a2c',	'{{unknown}}'),
(1591,	436,	'_edit_lock',	'1451363813:1'),
(1594,	436,	'_oembed_15bad21b47bcb77d4f5abb8df24b4e8d',	'{{unknown}}'),
(1595,	438,	'_menu_item_type',	'custom'),
(1596,	438,	'_menu_item_menu_item_parent',	'0'),
(1597,	438,	'_menu_item_object_id',	'438'),
(1598,	438,	'_menu_item_object',	'custom'),
(1599,	438,	'_menu_item_target',	''),
(1600,	438,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1601,	438,	'_menu_item_xfn',	''),
(1602,	438,	'_menu_item_url',	'http://hotfile.pw'),
(1603,	439,	'_menu_item_type',	'taxonomy'),
(1604,	439,	'_menu_item_menu_item_parent',	'0'),
(1605,	439,	'_menu_item_object_id',	'3'),
(1606,	439,	'_menu_item_object',	'category'),
(1607,	439,	'_menu_item_target',	''),
(1608,	439,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1609,	439,	'_menu_item_xfn',	''),
(1610,	439,	'_menu_item_url',	''),
(1611,	440,	'_menu_item_type',	'taxonomy'),
(1612,	440,	'_menu_item_menu_item_parent',	'0'),
(1613,	440,	'_menu_item_object_id',	'4'),
(1614,	440,	'_menu_item_object',	'category'),
(1615,	440,	'_menu_item_target',	''),
(1616,	440,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1617,	440,	'_menu_item_xfn',	''),
(1618,	440,	'_menu_item_url',	''),
(1619,	441,	'_menu_item_type',	'taxonomy'),
(1620,	441,	'_menu_item_menu_item_parent',	'0'),
(1621,	441,	'_menu_item_object_id',	'5'),
(1622,	441,	'_menu_item_object',	'category'),
(1623,	441,	'_menu_item_target',	''),
(1624,	441,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1625,	441,	'_menu_item_xfn',	''),
(1626,	441,	'_menu_item_url',	''),
(1627,	442,	'_menu_item_type',	'taxonomy'),
(1628,	442,	'_menu_item_menu_item_parent',	'0'),
(1629,	442,	'_menu_item_object_id',	'6'),
(1630,	442,	'_menu_item_object',	'category'),
(1631,	442,	'_menu_item_target',	''),
(1632,	442,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1633,	442,	'_menu_item_xfn',	''),
(1634,	442,	'_menu_item_url',	''),
(1635,	443,	'_menu_item_type',	'taxonomy'),
(1636,	443,	'_menu_item_menu_item_parent',	'0'),
(1637,	443,	'_menu_item_object_id',	'7'),
(1638,	443,	'_menu_item_object',	'category'),
(1639,	443,	'_menu_item_target',	''),
(1640,	443,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1641,	443,	'_menu_item_xfn',	''),
(1642,	443,	'_menu_item_url',	''),
(1643,	444,	'_menu_item_type',	'taxonomy'),
(1644,	444,	'_menu_item_menu_item_parent',	'0'),
(1645,	444,	'_menu_item_object_id',	'8'),
(1646,	444,	'_menu_item_object',	'category'),
(1647,	444,	'_menu_item_target',	''),
(1648,	444,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1649,	444,	'_menu_item_xfn',	''),
(1650,	444,	'_menu_item_url',	''),
(1651,	445,	'_menu_item_type',	'taxonomy'),
(1652,	445,	'_menu_item_menu_item_parent',	'0'),
(1653,	445,	'_menu_item_object_id',	'9'),
(1654,	445,	'_menu_item_object',	'category'),
(1655,	445,	'_menu_item_target',	''),
(1656,	445,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1657,	445,	'_menu_item_xfn',	''),
(1658,	445,	'_menu_item_url',	''),
(1659,	446,	'_menu_item_type',	'taxonomy'),
(1660,	446,	'_menu_item_menu_item_parent',	'0'),
(1661,	446,	'_menu_item_object_id',	'10'),
(1662,	446,	'_menu_item_object',	'category'),
(1663,	446,	'_menu_item_target',	''),
(1664,	446,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1665,	446,	'_menu_item_xfn',	''),
(1666,	446,	'_menu_item_url',	''),
(1667,	447,	'_menu_item_type',	'taxonomy'),
(1668,	447,	'_menu_item_menu_item_parent',	'0'),
(1669,	447,	'_menu_item_object_id',	'11'),
(1670,	447,	'_menu_item_object',	'category'),
(1671,	447,	'_menu_item_target',	''),
(1672,	447,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1673,	447,	'_menu_item_xfn',	''),
(1674,	447,	'_menu_item_url',	''),
(1675,	448,	'_menu_item_type',	'taxonomy'),
(1676,	448,	'_menu_item_menu_item_parent',	'0'),
(1677,	448,	'_menu_item_object_id',	'12'),
(1678,	448,	'_menu_item_object',	'category'),
(1679,	448,	'_menu_item_target',	''),
(1680,	448,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1681,	448,	'_menu_item_xfn',	''),
(1682,	448,	'_menu_item_url',	''),
(1683,	449,	'_menu_item_type',	'taxonomy'),
(1684,	449,	'_menu_item_menu_item_parent',	'0'),
(1685,	449,	'_menu_item_object_id',	'13'),
(1686,	449,	'_menu_item_object',	'category'),
(1687,	449,	'_menu_item_target',	''),
(1688,	449,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1689,	449,	'_menu_item_xfn',	''),
(1690,	449,	'_menu_item_url',	''),
(1691,	450,	'_menu_item_type',	'taxonomy'),
(1692,	450,	'_menu_item_menu_item_parent',	'0'),
(1693,	450,	'_menu_item_object_id',	'14'),
(1694,	450,	'_menu_item_object',	'category'),
(1695,	450,	'_menu_item_target',	''),
(1696,	450,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1697,	450,	'_menu_item_xfn',	''),
(1698,	450,	'_menu_item_url',	''),
(1699,	451,	'_menu_item_type',	'taxonomy'),
(1700,	451,	'_menu_item_menu_item_parent',	'0'),
(1701,	451,	'_menu_item_object_id',	'15'),
(1702,	451,	'_menu_item_object',	'category'),
(1703,	451,	'_menu_item_target',	''),
(1704,	451,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1705,	451,	'_menu_item_xfn',	''),
(1706,	451,	'_menu_item_url',	''),
(1707,	452,	'_menu_item_type',	'taxonomy'),
(1708,	452,	'_menu_item_menu_item_parent',	'0'),
(1709,	452,	'_menu_item_object_id',	'16'),
(1710,	452,	'_menu_item_object',	'category'),
(1711,	452,	'_menu_item_target',	''),
(1712,	452,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1713,	452,	'_menu_item_xfn',	''),
(1714,	452,	'_menu_item_url',	''),
(1715,	453,	'_menu_item_type',	'taxonomy'),
(1716,	453,	'_menu_item_menu_item_parent',	'0'),
(1717,	453,	'_menu_item_object_id',	'1'),
(1718,	453,	'_menu_item_object',	'category'),
(1719,	453,	'_menu_item_target',	''),
(1720,	453,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1721,	453,	'_menu_item_xfn',	''),
(1722,	453,	'_menu_item_url',	''),
(1723,	454,	'_menu_item_type',	'taxonomy'),
(1724,	454,	'_menu_item_menu_item_parent',	'0'),
(1725,	454,	'_menu_item_object_id',	'17'),
(1726,	454,	'_menu_item_object',	'category'),
(1727,	454,	'_menu_item_target',	''),
(1728,	454,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1729,	454,	'_menu_item_xfn',	''),
(1730,	454,	'_menu_item_url',	''),
(1731,	455,	'_menu_item_type',	'custom'),
(1732,	455,	'_menu_item_menu_item_parent',	'0'),
(1733,	455,	'_menu_item_object_id',	'455'),
(1734,	455,	'_menu_item_object',	'custom'),
(1735,	455,	'_menu_item_target',	''),
(1736,	455,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1737,	455,	'_menu_item_xfn',	''),
(1738,	455,	'_menu_item_url',	'http://hotfile.pw/top100'),
(1739,	456,	'_menu_item_type',	'custom'),
(1740,	456,	'_menu_item_menu_item_parent',	'0'),
(1741,	456,	'_menu_item_object_id',	'456'),
(1742,	456,	'_menu_item_object',	'custom'),
(1743,	456,	'_menu_item_target',	''),
(1744,	456,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1745,	456,	'_menu_item_xfn',	''),
(1746,	456,	'_menu_item_url',	'http://hotfile.pw/sitemap.xml'),
(1747,	457,	'_menu_item_type',	'custom'),
(1748,	457,	'_menu_item_menu_item_parent',	'0'),
(1749,	457,	'_menu_item_object_id',	'457'),
(1750,	457,	'_menu_item_object',	'custom'),
(1751,	457,	'_menu_item_target',	''),
(1752,	457,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1753,	457,	'_menu_item_xfn',	''),
(1754,	457,	'_menu_item_url',	'http://hotfile.pw/wp-login.php'),
(1773,	457,	'_menu_item_image_size',	'menu-24x24'),
(1756,	458,	'_edit_last',	'1'),
(1760,	458,	'_oembed_60c277f7348f856a4c0eb182942d6880',	'{{unknown}}'),
(1759,	458,	'_edit_lock',	'1451363936:1'),
(1761,	458,	'_oembed_5de94b31e29a177765136b7b99a471cd',	'{{unknown}}'),
(1762,	458,	'_oembed_e04fc05da1103ff38fb31b24b3d5004b',	'{{unknown}}'),
(1763,	460,	'_wp_attached_file',	'2015/12/login.png'),
(1764,	460,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:32;s:6:\"height\";i:32;s:4:\"file\";s:17:\"2015/12/login.png\";s:5:\"sizes\";a:1:{s:10:\"menu-24x24\";a:4:{s:4:\"file\";s:15:\"login-24x24.png\";s:5:\"width\";i:24;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;s:8:\"keywords\";a:0:{}}}'),
(1765,	457,	'_thumbnail_id',	'460'),
(1766,	461,	'_edit_last',	'1'),
(1770,	461,	'_oembed_5f3efd21cb9329c07a1dbdc73d948b68',	'{{unknown}}'),
(1769,	461,	'_edit_lock',	'1451364060:1'),
(1771,	461,	'_oembed_12489bf8831c92a4cfc82ae13a4e6e2d',	'{{unknown}}'),
(1772,	461,	'_oembed_54e8c2800687c0549f42698fff5939ec',	'{{unknown}}'),
(1774,	457,	'_menu_item_image_title_position',	'after'),
(1775,	463,	'_edit_last',	'1'),
(1779,	463,	'_oembed_16cadecefcc78f4e17400246da45f864',	'{{unknown}}'),
(1778,	463,	'_edit_lock',	'1451364183:1'),
(1780,	463,	'_oembed_7b905bf1565ddd77b13ca3710a6a0e91',	'{{unknown}}'),
(1781,	463,	'_oembed_040d3741c2e69569dd87181a56eac713',	'{{unknown}}'),
(1782,	465,	'_edit_last',	'1'),
(1786,	465,	'_oembed_a51acc2760fbb48088920369239a6b8c',	'{{unknown}}'),
(1787,	465,	'_oembed_b69ff30e04ab70077af65dba998436a9',	'{{unknown}}'),
(1785,	465,	'_edit_lock',	'1451364308:1'),
(1788,	465,	'_oembed_60763021e42361e6b8ce8d9d97b11f1f',	'{{unknown}}'),
(1789,	467,	'_edit_last',	'1'),
(1793,	467,	'_oembed_1424d61d665f95d0c6807c06197a3757',	'{{unknown}}'),
(1792,	467,	'_edit_lock',	'1451364432:1'),
(1794,	467,	'_oembed_8b5ddd7263d9211a479212daa539992d',	'{{unknown}}'),
(1795,	467,	'_oembed_e237d398bc7c0664313b16e96d6fdd38',	'{{unknown}}'),
(1796,	469,	'_edit_last',	'1'),
(1800,	469,	'_oembed_b416573ebaba3bd8d7d8d79f0ce45534',	'{{unknown}}'),
(1799,	469,	'_edit_lock',	'1451364555:1'),
(1801,	469,	'_oembed_ecfb54e82a9a25a6ece433173b703b9f',	'{{unknown}}'),
(1802,	469,	'_oembed_ea14c7f4bc61b6978325bcc93827d3e3',	'{{unknown}}'),
(1803,	471,	'_edit_last',	'1'),
(1807,	471,	'_oembed_7e3b2706fbf126e3079e37c52a0aee16',	'{{unknown}}'),
(1806,	471,	'_edit_lock',	'1451364681:1'),
(1808,	471,	'_oembed_d7655f442cc89182d6a6cc09a2ff44e1',	'{{unknown}}'),
(1809,	471,	'_oembed_1585c2b91bcc69dd82a380a7f4cd00c4',	'{{unknown}}'),
(1810,	473,	'_edit_last',	'1'),
(1814,	473,	'_oembed_dc1f55e22b37142a9ed9cfd7f570318b',	'{{unknown}}'),
(1813,	473,	'_edit_lock',	'1451364803:1'),
(1815,	473,	'_oembed_0b23261e02c71ae4644d8550fb0c813f',	'{{unknown}}'),
(1816,	473,	'_oembed_e6144cd808c7f0ee1b4efc2b935d03e9',	'{{unknown}}'),
(1817,	475,	'_edit_last',	'1'),
(1821,	475,	'_oembed_42d4130052ad94db7c95e8115118a048',	'{{unknown}}'),
(1820,	475,	'_edit_lock',	'1451364927:1'),
(1822,	475,	'_oembed_3cab6a96b936cd1bb05343daad4907ec',	'{{unknown}}'),
(1823,	475,	'_oembed_82d034133f579b2975c3ff576bdd163d',	'{{unknown}}'),
(1824,	477,	'_edit_last',	'1'),
(1828,	477,	'_oembed_ec6efb77926e4413a820a630f399f2e4',	'{{unknown}}'),
(1827,	477,	'_edit_lock',	'1451365051:1'),
(1829,	477,	'_oembed_57f3e29a01a39847b7d792cb7d66d2db',	'{{unknown}}'),
(1830,	477,	'_oembed_bd17fbec32f31ac4d4db6aa7788e2c2c',	'{{unknown}}'),
(1831,	479,	'_edit_last',	'1'),
(1835,	479,	'_oembed_2ad0941cd6348684866507f58dfafea4',	'{{unknown}}'),
(1838,	481,	'_edit_last',	'1'),
(1834,	479,	'_edit_lock',	'1451365175:1'),
(1836,	479,	'_oembed_9c07825e5ebc096d42c8cc9eb24712e7',	'{{unknown}}'),
(1837,	479,	'_oembed_3c521b4dd16f1e40007e102324b7ee3c',	'{{unknown}}'),
(1842,	481,	'_oembed_e2559fe76b6b5fcb6d4bf441359cac1a',	'{{unknown}}'),
(1841,	481,	'_edit_lock',	'1451365298:1'),
(1843,	481,	'_oembed_bd9cec57266fd9b69726f609b70c3f5f',	'{{unknown}}'),
(1844,	481,	'_oembed_679ee872beafc0d9c0632ede1f4edaf9',	'{{unknown}}'),
(1845,	483,	'_edit_last',	'1'),
(1849,	483,	'_oembed_49c2d98302bde61c125d82d72cdc80fc',	'{{unknown}}'),
(1851,	483,	'_oembed_30d79bf2bcb3673c1696968b71490503',	'{{unknown}}'),
(1848,	483,	'_edit_lock',	'1451365421:1'),
(1850,	483,	'_oembed_574ffe5841957e88b141b325f5db344c',	'{{unknown}}'),
(1852,	485,	'_edit_last',	'1'),
(1856,	485,	'_oembed_292fec19848fb189081a0d26247a4108',	'{{unknown}}'),
(1858,	485,	'_oembed_4de02c0936247536379407b99887a952',	'{{unknown}}'),
(1855,	485,	'_edit_lock',	'1451365546:1'),
(1857,	485,	'_oembed_50ba9cad70220e12dd2b28042e3a13c9',	'{{unknown}}'),
(1859,	487,	'_edit_last',	'1'),
(1863,	487,	'_oembed_d0201acc7e84fb7008feade58624875b',	'{{unknown}}'),
(1862,	487,	'_edit_lock',	'1451365669:1'),
(1864,	487,	'_oembed_7c1650197d127116811dbea3a5f98b77',	'{{unknown}}'),
(1865,	487,	'_oembed_6bbbbc8ab29b38af606b9ca57e154023',	'{{unknown}}'),
(1866,	489,	'_edit_last',	'1'),
(1870,	489,	'_oembed_53247611b6b12119d5484a6cca1dbbd1',	'{{unknown}}'),
(1869,	489,	'_edit_lock',	'1451365793:1'),
(1871,	489,	'_oembed_1ba7228d28728673537f608d1e6cdffe',	'{{unknown}}'),
(1872,	489,	'_oembed_8dbfeb29dd8ab9eb1fb73ee372a55999',	'{{unknown}}'),
(1873,	491,	'_edit_last',	'1'),
(1877,	491,	'_oembed_b65791db86767d752d6316637785667c',	'{{unknown}}'),
(1876,	491,	'_edit_lock',	'1451365918:1'),
(1878,	491,	'_oembed_abd729670fe9e000efa2ea64b163d163',	'{{unknown}}'),
(1879,	491,	'_oembed_75f96408477fec29139bd9070ac72a1a',	'{{unknown}}'),
(1880,	493,	'_edit_last',	'1'),
(1884,	493,	'_oembed_f8ec51f6dd7eed652effc1a60b759442',	'{{unknown}}'),
(1883,	493,	'_edit_lock',	'1451366041:1'),
(1885,	493,	'_oembed_7bdaab27fdd2d463b1223ec31022bc5c',	'{{unknown}}'),
(1886,	493,	'_oembed_537f1f6eb59b19425e5055d02928d940',	'{{unknown}}'),
(1887,	495,	'_edit_last',	'1'),
(1891,	495,	'_oembed_af2dc5bc6659005f2333fa819f66199e',	'{{unknown}}'),
(1890,	495,	'_edit_lock',	'1451366165:1'),
(1892,	495,	'_oembed_0dabd60fd62e88720f6d1f8b26d38c58',	'{{unknown}}'),
(1893,	495,	'_oembed_5e2bedeb44d4de7a686e88a0a2b11355',	'{{unknown}}'),
(1894,	497,	'_edit_last',	'1'),
(1898,	497,	'_oembed_ccc858a57b5b973497ab773a94c99c8f',	'{{unknown}}'),
(1897,	497,	'_edit_lock',	'1451366291:1'),
(1899,	497,	'_oembed_a3de3991ac752990bcf8ca7c9b1f21ed',	'{{unknown}}'),
(1900,	497,	'_oembed_e24db03a2c47215e242bbb0af424baf9',	'{{unknown}}'),
(1901,	499,	'_edit_last',	'1'),
(1905,	499,	'_oembed_3e03d9484b5acb9974f3415e6608885b',	'{{unknown}}'),
(1904,	499,	'_edit_lock',	'1451366414:1'),
(1906,	499,	'_oembed_42a944708015dad789b8f05e4e201741',	'{{unknown}}'),
(1907,	499,	'_oembed_0641d7e04f9f8bed0acec79b6393b574',	'{{unknown}}'),
(1908,	501,	'_edit_last',	'1'),
(1912,	501,	'_oembed_4795e7b96cadb9cbe20922426bfce5fc',	'{{unknown}}'),
(1911,	501,	'_edit_lock',	'1451366537:1'),
(1913,	501,	'_oembed_c34d4dd754ec9f675f79674970f2e5ed',	'{{unknown}}'),
(1914,	501,	'_oembed_d0a0d79254effcffb40e21efb87753a4',	'{{unknown}}'),
(1915,	503,	'_edit_last',	'1'),
(1919,	503,	'_oembed_d240bb49e3600f85c5e79858b364ce27',	'{{unknown}}'),
(1918,	503,	'_edit_lock',	'1451366664:1'),
(1920,	503,	'_oembed_94239afcc73c32c62efea5ed7cd7956a',	'{{unknown}}'),
(1921,	503,	'_oembed_b98f07391f437b9f95296d6219a6728f',	'{{unknown}}'),
(1922,	505,	'_edit_last',	'1'),
(1926,	505,	'_oembed_cb7e2810a90659227b05dfffae4a47ed',	'{{unknown}}'),
(1925,	505,	'_edit_lock',	'1451366788:1'),
(1927,	505,	'_oembed_39430254794a130b5825d37bdf9fe910',	'{{unknown}}'),
(1928,	505,	'_oembed_ebf97f0980cda0ac1271e18b62b232b9',	'{{unknown}}'),
(1929,	507,	'_edit_last',	'1'),
(1933,	507,	'_oembed_192e5840fc8273ccd5d06bbdce7583cc',	'{{unknown}}'),
(1932,	507,	'_edit_lock',	'1451366911:1'),
(1934,	507,	'_oembed_91caf9be0f78629db3d627dc61388d48',	'{{unknown}}'),
(1935,	507,	'_oembed_7720a90a94d553cdb97d7ad8e736d6b4',	'{{unknown}}'),
(1936,	509,	'_edit_last',	'1'),
(1940,	509,	'_oembed_16d1157fc30f0b23f511152a6af6694c',	'{{unknown}}'),
(1939,	509,	'_edit_lock',	'1451367034:1'),
(1941,	509,	'_oembed_ba30cf9db5c53530fc5d0f5988c6d676',	'{{unknown}}'),
(1942,	509,	'_oembed_130c58f894912b2c05e23ac68616b8db',	'{{unknown}}'),
(1943,	511,	'_edit_last',	'1'),
(1947,	511,	'_oembed_6340b87d4ea8099723d347a36c9e586c',	'{{unknown}}'),
(1948,	511,	'_oembed_d3509a9ab239b98a47984cab2e304b18',	'{{unknown}}'),
(1946,	511,	'_edit_lock',	'1451367157:1'),
(1949,	511,	'_oembed_db756a6ec84bc7d8f02ac777fde05eed',	'{{unknown}}'),
(1950,	513,	'_edit_last',	'1'),
(1954,	513,	'_oembed_7aeafa6748fe03afce792d4c9d7f79b9',	'{{unknown}}'),
(1953,	513,	'_edit_lock',	'1451367281:1'),
(1955,	513,	'_oembed_7e27d7a1aa28ba0abe40c0e0c2b3bed4',	'{{unknown}}'),
(1956,	513,	'_oembed_03e310b1b9b00418207289b70e0413e3',	'{{unknown}}'),
(1957,	515,	'_edit_last',	'1'),
(1961,	515,	'_oembed_5915659416c0b2f26e4a6bf8261b446a',	'{{unknown}}'),
(1960,	515,	'_edit_lock',	'1451367404:1'),
(1962,	515,	'_oembed_8b6bcac611681286f5ae841c85145a23',	'{{unknown}}'),
(1963,	515,	'_oembed_00ef2715f4e41d35d7583db38da518b7',	'{{unknown}}'),
(1964,	517,	'_edit_last',	'1'),
(1968,	517,	'_oembed_3df5ced4ceb2104a5e90ca7d774767b0',	'{{unknown}}'),
(1967,	517,	'_edit_lock',	'1451367528:1'),
(1969,	517,	'_oembed_6f26d7cf987a2dc8a94fa08b3df5ddca',	'{{unknown}}'),
(1970,	517,	'_oembed_6746b0b4c602a4a26e0273994d8d4a6e',	'{{unknown}}'),
(1971,	519,	'_edit_last',	'1'),
(1975,	519,	'_oembed_a023692934f1200e1e448347d7399029',	'{{unknown}}'),
(1974,	519,	'_edit_lock',	'1451367651:1'),
(1976,	519,	'_oembed_de813c8cfd1f44600769308975976bc0',	'{{unknown}}'),
(1977,	519,	'_oembed_982dea43320cc0e6097e1d2b1dc20f9a',	'{{unknown}}'),
(1978,	521,	'_edit_last',	'1'),
(1982,	521,	'_oembed_2f6cea2110d678360684c246e0d2a269',	'{{unknown}}'),
(1981,	521,	'_edit_lock',	'1451367774:1'),
(1983,	521,	'_oembed_bc984628be99018fcaba841c0ff6b5e8',	'{{unknown}}'),
(1984,	521,	'_oembed_e20b9913777a3f5d780cc532b6774836',	'{{unknown}}'),
(1985,	523,	'_edit_last',	'1'),
(1989,	523,	'_oembed_8e60bfcceafcb2d2be7edb94241cab09',	'{{unknown}}'),
(1992,	525,	'_edit_last',	'1'),
(1988,	523,	'_edit_lock',	'1451367898:1'),
(1990,	523,	'_oembed_7f8b8348218b11d15b840c6464872860',	'{{unknown}}'),
(1991,	523,	'_oembed_6024159f0431eda10133a2e48149362a',	'{{unknown}}'),
(2003,	527,	'_oembed_8254e1d8d556d59f8691b952ea3022d5',	'{{unknown}}'),
(1999,	527,	'_edit_last',	'1'),
(1995,	525,	'_edit_lock',	'1451368028:1'),
(1996,	525,	'_oembed_84ac098f86187c433940f3f347a66607',	'{{unknown}}'),
(1997,	525,	'_oembed_6029d274b467090efef076305a2b7676',	'{{unknown}}'),
(1998,	525,	'_oembed_8d049cb5d6575bd5267de71d7b606f5e',	'{{unknown}}'),
(2004,	527,	'_oembed_cab5c045c3a983ea4bc97617a19b0dd1',	'{{unknown}}'),
(2002,	527,	'_edit_lock',	'1451369540:1'),
(2005,	527,	'_oembed_4279a87c963ac1da100059ddf07c86ef',	'{{unknown}}'),
(2006,	529,	'_edit_last',	'1'),
(2010,	529,	'_oembed_1f4ec8e7ccee474e87e6681c1677d991',	'{{unknown}}'),
(2009,	529,	'_edit_lock',	'1451369664:1'),
(2011,	529,	'_oembed_b663f8551f85d5dc90a473c4381e9548',	'{{unknown}}'),
(2012,	529,	'_oembed_7bc4658176d02be242d3b9bcdc533b33',	'{{unknown}}'),
(2013,	531,	'_edit_last',	'1'),
(2017,	531,	'_oembed_851bae280c39d15950a3d2494c64eeaa',	'{{unknown}}'),
(2016,	531,	'_edit_lock',	'1451369787:1'),
(2018,	531,	'_oembed_3534dfd988c3dfb754929484608d1ed6',	'{{unknown}}'),
(2019,	531,	'_oembed_e86260851ec0f408a7c22b81d1d6d5bf',	'{{unknown}}'),
(2020,	533,	'_edit_last',	'1'),
(2024,	533,	'_oembed_396a05c90e9bfc3959a72f7a75778ee0',	'{{unknown}}'),
(2027,	535,	'_edit_last',	'1'),
(2023,	533,	'_edit_lock',	'1451371606:1'),
(2025,	533,	'_oembed_fb2e0c1a4bd7f1356bdf35b257888bba',	'{{unknown}}'),
(2026,	533,	'_oembed_84e6d9c8c2d8df0317624239444f9e0b',	'{{unknown}}'),
(2031,	535,	'_oembed_afa4d3a8182d5e86ed0ce27cd6ed3bdf',	'{{unknown}}'),
(2030,	535,	'_edit_lock',	'1451371730:1'),
(2032,	535,	'_oembed_ddf29cfc4e5a9b4004cbfca5e08c4944',	'{{unknown}}'),
(2033,	535,	'_oembed_8a665458cf3ddbae9c1f9dc1ec7ce0c1',	'{{unknown}}'),
(2034,	537,	'_edit_last',	'1'),
(2038,	537,	'_oembed_af66c720731de81cc8f6126bc6fd2507',	'{{unknown}}'),
(2041,	539,	'_edit_last',	'1'),
(2037,	537,	'_edit_lock',	'1451371868:1'),
(2039,	537,	'_oembed_64abf26f7f7685708ea5f929cea508f7',	'{{unknown}}'),
(2040,	537,	'_oembed_100a57e500410b34bd351dcdbbe091f6',	'{{unknown}}'),
(2045,	539,	'_oembed_88cea8880c020d3f6fea1f9ba9253b00',	'{{unknown}}'),
(2046,	539,	'_oembed_a299ad30fe4517b6874071243d6b15c6',	'{{unknown}}'),
(2044,	539,	'_edit_lock',	'1451371998:1'),
(2047,	539,	'_oembed_274f3fb87bf90254ac7e828a64fc1ba3',	'{{unknown}}'),
(2048,	541,	'_edit_last',	'1'),
(2052,	541,	'_oembed_ff1f961ea3f8b5be1f327c34d275b2c3',	'{{unknown}}'),
(2054,	541,	'_oembed_ec772a3720f452ff6b3b2f74b6191f93',	'{{unknown}}'),
(2051,	541,	'_edit_lock',	'1451372498:1'),
(2053,	541,	'_oembed_b57d33e459451448358ae51712bee781',	'{{unknown}}'),
(2055,	543,	'_edit_last',	'1'),
(2059,	543,	'_oembed_3381b4ffe5e543c149700203f0ae3ceb',	'{{unknown}}'),
(2058,	543,	'_edit_lock',	'1451372622:1'),
(2060,	543,	'_oembed_98e837a1fbdee1d556f2371814e981fc',	'{{unknown}}'),
(2061,	543,	'_oembed_9ad4e05261ad03152bb861c0b0af1346',	'{{unknown}}'),
(2062,	546,	'_edit_last',	'1'),
(2066,	548,	'_edit_last',	'1'),
(2065,	546,	'_edit_lock',	'1451373370:1'),
(2076,	551,	'_edit_last',	'1'),
(2069,	548,	'_edit_lock',	'1451373494:1'),
(2070,	548,	'_oembed_789e4f6b8aa098f5956adbf515afefe7',	'{{unknown}}'),
(2071,	548,	'_oembed_9ca686a26f5857719d1270afb2c7de8a',	'{{unknown}}'),
(2072,	548,	'_oembed_570365db5206ac849de1439dad2fe50d',	'{{unknown}}'),
(2073,	546,	'_oembed_07b9dfafc412edef64abbedfd0477c56',	'{{unknown}}'),
(2074,	546,	'_oembed_b7d851c10d3a800df849e803bee180c8',	'{{unknown}}'),
(2075,	546,	'_oembed_373d582b02da33c331dd50af01064101',	'{{unknown}}'),
(2080,	551,	'_oembed_d794c4d50d3eaf5e0788c9d336d16c44',	'{{unknown}}'),
(2079,	551,	'_edit_lock',	'1451374371:1'),
(2081,	551,	'_oembed_28d8d650e2f1137f52b54c2a4bc4e295',	'{{unknown}}'),
(2082,	551,	'_oembed_ef8646d541884cb6f74bb296872a4a1f',	'{{unknown}}'),
(2083,	553,	'_edit_last',	'1'),
(2087,	553,	'_oembed_069071227dca728e30d854d9a76d8972',	'{{unknown}}'),
(2090,	555,	'_edit_last',	'1'),
(2086,	553,	'_edit_lock',	'1451381731:1'),
(2088,	553,	'_oembed_6bd7c18bc068cd16685e1e205c7b1253',	'{{unknown}}'),
(2089,	553,	'_oembed_0639a98ac6b46c870298a4c8846dd14c',	'{{unknown}}'),
(2094,	555,	'_oembed_0ffb205b0395a1679ccff979a6b40951',	'{{unknown}}'),
(2093,	555,	'_edit_lock',	'1451381855:1'),
(2095,	555,	'_oembed_bc7e59b5dc71463d9f73fd62345886a1',	'{{unknown}}'),
(2096,	555,	'_oembed_7187b89697029178d3da5ec81ae6df82',	'{{unknown}}'),
(2097,	557,	'_edit_last',	'1'),
(2101,	557,	'_oembed_2bc69bd9d6c3d0f01a2c0421728db1ad',	'{{unknown}}'),
(2100,	557,	'_edit_lock',	'1451381978:1'),
(2102,	557,	'_oembed_33d19e041ae881d64873982c32b9da6c',	'{{unknown}}'),
(2103,	557,	'_oembed_837c9b0084c206fe7222080ddc9a4b69',	'{{unknown}}'),
(2104,	559,	'_edit_last',	'1'),
(2108,	559,	'_oembed_8918483e361e5fbc7375f231b453b129',	'{{unknown}}'),
(2107,	559,	'_edit_lock',	'1451382100:1'),
(2109,	559,	'_oembed_6b45c46e387adc3f05bfde75f7d2b332',	'{{unknown}}'),
(2110,	559,	'_oembed_4455fbaed785f5ae0e605ee494a7c88a',	'{{unknown}}'),
(2111,	561,	'_edit_last',	'1'),
(2115,	561,	'_oembed_92fa2f9e8f9776a656f3a9f9a20354ac',	'{{unknown}}'),
(2118,	563,	'_edit_last',	'1'),
(2114,	561,	'_edit_lock',	'1451382223:1'),
(2116,	561,	'_oembed_b0adbdee09e0dcb2c62c6f718e02ffde',	'{{unknown}}'),
(2117,	561,	'_oembed_ce4a294becb7018b2ab1507b3c37c8e5',	'{{unknown}}'),
(2122,	563,	'_oembed_2e5ba9f90136dbc311bf17349a5ea905',	'{{unknown}}'),
(2123,	563,	'_oembed_5d0fa605db6496f39668bf0b7ed6dc10',	'{{unknown}}'),
(2121,	563,	'_edit_lock',	'1451382346:1'),
(2124,	563,	'_oembed_14f9002de7c0f3da0190c694ed66ddc0',	'{{unknown}}'),
(2125,	565,	'_edit_last',	'1'),
(2129,	565,	'_oembed_78796eed86986882fdc3807fe134f490',	'{{unknown}}'),
(2128,	565,	'_edit_lock',	'1451382469:1'),
(2130,	565,	'_oembed_5c8faa177a9f74ce47404bd97f81bab4',	'{{unknown}}'),
(2131,	565,	'_oembed_e23060ad4dcf60dab450b016ff91b940',	'{{unknown}}'),
(2132,	567,	'_edit_last',	'1'),
(2136,	567,	'_oembed_8259d9fe37dd8bf9f668d0d1bc92ed47',	'{{unknown}}'),
(2135,	567,	'_edit_lock',	'1451382592:1'),
(2137,	567,	'_oembed_504b9003c42bd1fb7e4db42d12add0f9',	'{{unknown}}'),
(2138,	567,	'_oembed_57b79f80173c7114ea8b38073e3435ac',	'{{unknown}}'),
(2139,	569,	'_edit_last',	'1'),
(2143,	569,	'_oembed_a12dd9d30413f05c97e272aa5e069cb6',	'{{unknown}}'),
(2142,	569,	'_edit_lock',	'1451382715:1'),
(2144,	569,	'_oembed_8923a6b257d0e26feb32c3dbda0559b6',	'{{unknown}}'),
(2145,	569,	'_oembed_ab4f5594e3bf035bc28096b903d00bf1',	'{{unknown}}'),
(2146,	571,	'_edit_last',	'1'),
(2150,	571,	'_oembed_bd48763e612a6e148804b646084e83e1',	'{{unknown}}'),
(2152,	571,	'_oembed_238059bad27de09a12b55d802876078a',	'{{unknown}}'),
(2149,	571,	'_edit_lock',	'1451382838:1'),
(2151,	571,	'_oembed_b24d5b59e7ba38987636d9401e8f8d00',	'{{unknown}}'),
(2153,	573,	'_edit_last',	'1'),
(2157,	573,	'_oembed_823b72a332a4851602c3befc382deeeb',	'{{unknown}}'),
(2156,	573,	'_edit_lock',	'1451382961:1'),
(2158,	573,	'_oembed_d93b6f91152526d59f5f71e72b5d6cdf',	'{{unknown}}'),
(2159,	573,	'_oembed_e24a7b59691a7f062126ef35b0d2618c',	'{{unknown}}'),
(2160,	575,	'_edit_last',	'1'),
(2164,	575,	'_oembed_fc9216bc20473c1abc382c6e889bc42a',	'{{unknown}}'),
(2163,	575,	'_edit_lock',	'1451383086:1'),
(2165,	575,	'_oembed_97faee976df957796225d798f177f4e6',	'{{unknown}}'),
(2166,	575,	'_oembed_f7ff952a27e8ebc9f0fb9d1414c67deb',	'{{unknown}}'),
(2167,	577,	'_edit_last',	'1'),
(2171,	577,	'_oembed_a448244fb1217be89b8d1408ff7d29c0',	'{{unknown}}'),
(2170,	577,	'_edit_lock',	'1451383208:1'),
(2172,	577,	'_oembed_56a6647ad3bf7aa061b491ae10384605',	'{{unknown}}'),
(2173,	577,	'_oembed_fb26e37c73f30de750a4f0360a5b45f4',	'{{unknown}}'),
(2174,	579,	'_edit_last',	'1'),
(2178,	579,	'_oembed_f34c438196c53027fdc69a084a21bd00',	'{{unknown}}'),
(2177,	579,	'_edit_lock',	'1451383331:1'),
(2179,	579,	'_oembed_14eab95108ec74806114f273b2484490',	'{{unknown}}'),
(2180,	579,	'_oembed_8476e9e49dce4443909b0bb2bbde416b',	'{{unknown}}'),
(2181,	581,	'_edit_last',	'1'),
(2185,	581,	'_oembed_902709dfa9766447053576426abeccae',	'{{unknown}}'),
(2184,	581,	'_edit_lock',	'1451383454:1'),
(2186,	581,	'_oembed_538f2f025ae4b627e249d1285108b6e8',	'{{unknown}}'),
(2187,	581,	'_oembed_9eeb309fd4181a89c1dc23fc897c655c',	'{{unknown}}'),
(2188,	583,	'_edit_last',	'1'),
(2192,	583,	'_oembed_67cb7bd804d4a62a4b45ae3e8bc4f70e',	'{{unknown}}'),
(2191,	583,	'_edit_lock',	'1451383577:1'),
(2193,	583,	'_oembed_773200de5e4f80967679e4213de2a321',	'{{unknown}}'),
(2194,	583,	'_oembed_6a29ccceda55a25c9d3246857a3984cf',	'{{unknown}}'),
(2195,	585,	'_edit_last',	'1'),
(2199,	585,	'_oembed_04092c41e5bb8ebac40da4a3184e95b5',	'{{unknown}}'),
(2198,	585,	'_edit_lock',	'1451383700:1'),
(2200,	585,	'_oembed_1d35fe5e35e37751c9159cc0ac8c191e',	'{{unknown}}'),
(2201,	585,	'_oembed_ef9846dc33b6cb544da3d19f9f84a029',	'{{unknown}}'),
(2202,	587,	'_edit_last',	'1'),
(2206,	587,	'_oembed_ee5e6d49010d3ec710645f340447a8fc',	'{{unknown}}'),
(2205,	587,	'_edit_lock',	'1451383823:1'),
(2207,	587,	'_oembed_9ae7b43dd4d645feb6baaf356b667409',	'{{unknown}}'),
(2208,	587,	'_oembed_cf5383e48db12b4d50f9f3467e0c4d00',	'{{unknown}}'),
(2209,	589,	'_edit_last',	'1'),
(2213,	589,	'_oembed_3fb74b2a8e0c7e4b2a86d60fa1d10c28',	'{{unknown}}'),
(2212,	589,	'_edit_lock',	'1451383946:1'),
(2214,	589,	'_oembed_8f14b165d004273205c5f96a7c5b5a27',	'{{unknown}}'),
(2215,	589,	'_oembed_b0f9fc449faa566d9f5265597b4380fe',	'{{unknown}}'),
(2216,	591,	'_edit_last',	'1'),
(2220,	591,	'_oembed_886ae0f4c9ff1dc08c6428f3a7396082',	'{{unknown}}'),
(2219,	591,	'_edit_lock',	'1451384069:1'),
(2221,	591,	'_oembed_5f1059a304808f6c208d37d1c8e50c8d',	'{{unknown}}'),
(2222,	591,	'_oembed_e5f10eb56efdec687182eae85612bc5f',	'{{unknown}}'),
(2223,	593,	'_edit_last',	'1'),
(2227,	593,	'_oembed_2124fd2ce15fe842220d0f60e832502d',	'{{unknown}}'),
(2226,	593,	'_edit_lock',	'1451384192:1'),
(2228,	593,	'_oembed_dda05d3e7de4ed245293a29cde128cd1',	'{{unknown}}'),
(2229,	593,	'_oembed_5c21ee3f76884dcf6ce6f7fbda58266c',	'{{unknown}}'),
(2230,	595,	'_edit_last',	'1'),
(2234,	595,	'_oembed_73bcf0aa1b1bb47197c41ba22d2a9d5d',	'{{unknown}}'),
(2233,	595,	'_edit_lock',	'1451384315:1'),
(2235,	595,	'_oembed_6bb77d1410b5ba6e9e7753ae723d970d',	'{{unknown}}'),
(2236,	595,	'_oembed_f82e41b22cdc1d432397764cdfff8850',	'{{unknown}}'),
(2237,	597,	'_edit_last',	'1'),
(2241,	597,	'_oembed_84a86862504cdb403c7c243dadef46ef',	'{{unknown}}'),
(2240,	597,	'_edit_lock',	'1451384439:1'),
(2242,	597,	'_oembed_81e6a2982315f3eaf08af7031570ff73',	'{{unknown}}'),
(2243,	597,	'_oembed_dfd53c52ed0611ee116a808f82ec31f8',	'{{unknown}}'),
(2244,	599,	'_edit_last',	'1'),
(2248,	599,	'_oembed_0fa1f24c6a4805e092df8d8b54403e3c',	'{{unknown}}'),
(2247,	599,	'_edit_lock',	'1451385350:1'),
(2249,	599,	'_oembed_4373bc3c4b92c0d305acadf2c5eec014',	'{{unknown}}'),
(2250,	599,	'_oembed_a164086750370c0e69fadd0736461b96',	'{{unknown}}'),
(2251,	601,	'_edit_last',	'1'),
(2255,	601,	'_oembed_23517a1d967f0b8ea49bce25e0a1b514',	'{{unknown}}'),
(2254,	601,	'_edit_lock',	'1451385472:1'),
(2256,	601,	'_oembed_a0dd0e7f7f6bbee0c968aabc58a19800',	'{{unknown}}'),
(2257,	601,	'_oembed_ad98b9210230d5e2e9b6015559814bed',	'{{unknown}}'),
(2258,	603,	'_edit_last',	'1'),
(2262,	603,	'_oembed_156252283dd302a9a2d0270aa220c88d',	'{{unknown}}'),
(2261,	603,	'_edit_lock',	'1451385596:1'),
(2263,	603,	'_oembed_5d4518906b01e4a9e959272d3920cca0',	'{{unknown}}'),
(2264,	603,	'_oembed_064a6e144a727b2e2561fbe2c9a32df1',	'{{unknown}}'),
(2265,	605,	'_edit_last',	'1'),
(2269,	605,	'_oembed_9147df2012488c54b28fa799405cfa60',	'{{unknown}}'),
(2268,	605,	'_edit_lock',	'1451385719:1'),
(2270,	605,	'_oembed_4a03b556cf8ad382a86bfda226f9954f',	'{{unknown}}'),
(2271,	605,	'_oembed_74b5256a00ae5e1ad65f3d0e2239101d',	'{{unknown}}'),
(2272,	607,	'_edit_last',	'1'),
(2276,	607,	'_oembed_99b6b1e9006c0fee2b756ded478f35d0',	'{{unknown}}'),
(2275,	607,	'_edit_lock',	'1451385842:1'),
(2277,	607,	'_oembed_b1831f1015caad579ee1e5bf7594ef78',	'{{unknown}}'),
(2278,	607,	'_oembed_fdfe4f91a0f8a707f486154a57e6ecee',	'{{unknown}}'),
(2279,	609,	'_edit_last',	'1'),
(2283,	609,	'_oembed_e8345f8fe603a54ce088d09b18b3ffe3',	'{{unknown}}'),
(2282,	609,	'_edit_lock',	'1451385965:1'),
(2284,	609,	'_oembed_36a9e80ba398d7de4242056a87953e1d',	'{{unknown}}'),
(2285,	609,	'_oembed_97c9667a4a98745d92146f7aaf73f7a7',	'{{unknown}}'),
(2286,	611,	'_edit_last',	'1'),
(2290,	611,	'_oembed_c4606c96616da0556e63410fa47abcf2',	'{{unknown}}'),
(2291,	611,	'_oembed_05401a2581c705ed29d2b88e4bd7d2db',	'{{unknown}}'),
(2289,	611,	'_edit_lock',	'1451386088:1'),
(2292,	611,	'_oembed_fd4f8f773b8a5374e9dc31327fbedc14',	'{{unknown}}'),
(2293,	613,	'_edit_last',	'1'),
(2297,	613,	'_oembed_67a148c73ca3a0658c0deec203ad6592',	'{{unknown}}'),
(2296,	613,	'_edit_lock',	'1451386213:1'),
(2298,	613,	'_oembed_fa3ecb55e15f89a467f8e37ede51dad6',	'{{unknown}}'),
(2299,	613,	'_oembed_8a12fa6010113bd0f787cea06388365a',	'{{unknown}}'),
(2300,	615,	'_edit_last',	'1'),
(2304,	615,	'_oembed_ca74e669ee06d070b5100cce87c70ab7',	'{{unknown}}'),
(2303,	615,	'_edit_lock',	'1451386336:1'),
(2305,	615,	'_oembed_86fb5c3991bde154f8bf83786f476498',	'{{unknown}}'),
(2306,	615,	'_oembed_12d9590af70dc90186b935118dc6e915',	'{{unknown}}'),
(2307,	617,	'_edit_last',	'1'),
(2311,	617,	'_oembed_0cf40e6dbec571d666b4eb4c7583f46a',	'{{unknown}}'),
(2313,	617,	'_oembed_20186bb021ce2ca17c8ef33778a7e993',	'{{unknown}}'),
(2310,	617,	'_edit_lock',	'1451386460:1'),
(2312,	617,	'_oembed_ae1653cfafd1281fd53a50306642e50a',	'{{unknown}}'),
(2314,	619,	'_edit_last',	'1'),
(2318,	619,	'_oembed_33cbf5ec773b5989acaaa837f1d3d071',	'{{unknown}}'),
(2317,	619,	'_edit_lock',	'1451386583:1'),
(2319,	619,	'_oembed_14b3dc236e9b9208391778a7ea23d333',	'{{unknown}}'),
(2320,	619,	'_oembed_2d7c7d6a2269c3b4138121839151427c',	'{{unknown}}'),
(2321,	621,	'_edit_last',	'1'),
(2325,	621,	'_oembed_51a4f814bd648a00c003bd4c2dadffba',	'{{unknown}}'),
(2324,	621,	'_edit_lock',	'1451386706:1'),
(2326,	621,	'_oembed_dcacab502832fcce0d967902bd0a3b43',	'{{unknown}}'),
(2327,	621,	'_oembed_6c4e9e554899a8991d3e0875a607b80b',	'{{unknown}}'),
(2328,	623,	'_edit_last',	'1'),
(2332,	623,	'_oembed_af193b63f5d2a1d00ce5fb06619f8e1d',	'{{unknown}}'),
(2335,	625,	'_edit_last',	'1'),
(2331,	623,	'_edit_lock',	'1451386829:1'),
(2333,	623,	'_oembed_903b17af330aa493bc15495e1ab2c17e',	'{{unknown}}'),
(2334,	623,	'_oembed_2d48a846fd13bd6f0287835309df56cf',	'{{unknown}}'),
(2339,	625,	'_oembed_307880e883c1de276793456890cba171',	'{{unknown}}'),
(2342,	627,	'_edit_last',	'1'),
(2338,	625,	'_edit_lock',	'1451386953:1'),
(2340,	625,	'_oembed_799d337d4ed4ae6a42bf4c403ac655c3',	'{{unknown}}'),
(2341,	625,	'_oembed_4af09845647be0a518404c5963015c36',	'{{unknown}}'),
(2346,	627,	'_oembed_4f44dbbd8492d0367e630bdfd254bf95',	'{{unknown}}'),
(2345,	627,	'_edit_lock',	'1451387077:1'),
(2347,	627,	'_oembed_3ab51de876b667a4fb0f84ca36a8470f',	'{{unknown}}'),
(2348,	627,	'_oembed_b4d73b92a5d1de27518e11308b306e80',	'{{unknown}}'),
(2349,	629,	'_edit_last',	'1'),
(2353,	629,	'_oembed_45a6bc0345a2f3ad692d62b3caea26f3',	'{{unknown}}'),
(2354,	629,	'_oembed_af9f5a86927c4053d87b2644d38792b1',	'{{unknown}}'),
(2352,	629,	'_edit_lock',	'1451387200:1'),
(2355,	629,	'_oembed_71785b4d0c35ccca4ec5ab55d808dbb8',	'{{unknown}}'),
(2356,	631,	'_edit_last',	'1'),
(2360,	631,	'_oembed_67dae6ad0e988ff0a70d75ea8082abde',	'{{unknown}}'),
(2361,	631,	'_oembed_fa48d4c8d4cbb942c11f461d24bae0d4',	'{{unknown}}'),
(2359,	631,	'_edit_lock',	'1451387323:1'),
(2362,	631,	'_oembed_83cd05a456cda3f10014247bbeb1d19e',	'{{unknown}}'),
(2363,	633,	'_edit_last',	'1'),
(2367,	633,	'_oembed_39128967f2468dad02c2c42e1740883b',	'{{unknown}}'),
(2366,	633,	'_edit_lock',	'1451387446:1'),
(2368,	633,	'_oembed_cea760860ce8a7bbc6d2b57dee12b9d7',	'{{unknown}}'),
(2369,	633,	'_oembed_b64400db47e2ffc8eca731c2437b7bd0',	'{{unknown}}'),
(2370,	635,	'_edit_last',	'1'),
(2374,	635,	'_oembed_4e96fa35c503ff833944432fd84f6d42',	'{{unknown}}'),
(2373,	635,	'_edit_lock',	'1451387570:1'),
(2375,	635,	'_oembed_924fec4a7b25a9e594996f466e410ff8',	'{{unknown}}'),
(2376,	635,	'_oembed_d0974316316b30adcd6ec37c014198ca',	'{{unknown}}'),
(2377,	637,	'_edit_last',	'1'),
(2381,	637,	'_oembed_e7ccb673e4b360ee1a9aacdf7908ed05',	'{{unknown}}'),
(2382,	637,	'_oembed_ceb1b411c36bdd71c0d6b7874489e271',	'{{unknown}}'),
(2380,	637,	'_edit_lock',	'1451387693:1'),
(2383,	637,	'_oembed_6e30519213f258ce32bc05b5dbc648e7',	'{{unknown}}'),
(2384,	639,	'_edit_last',	'1'),
(2388,	639,	'_oembed_ca632307ebab31f287ebaf69f49d8b0a',	'{{unknown}}'),
(2387,	639,	'_edit_lock',	'1451387816:1'),
(2389,	639,	'_oembed_eaaff2152eea63a0845b40231c21a3eb',	'{{unknown}}'),
(2390,	639,	'_oembed_e10bfda50f51c4264870c8c26015c528',	'{{unknown}}'),
(2391,	641,	'_edit_last',	'1'),
(2395,	641,	'_oembed_f6bb07ead75e0f8026ddc9ef3f8d7c37',	'{{unknown}}'),
(2394,	641,	'_edit_lock',	'1451387939:1'),
(2396,	641,	'_oembed_842023439595717d6b4bf592bd086ccb',	'{{unknown}}'),
(2397,	641,	'_oembed_ceb3fd099022dcb3ecf3f39757871ed1',	'{{unknown}}'),
(2398,	643,	'_edit_last',	'1'),
(2402,	643,	'_oembed_a541765568d67c23f4aabd8558bcfc4b',	'{{unknown}}'),
(2401,	643,	'_edit_lock',	'1451388062:1'),
(2403,	643,	'_oembed_8832285011ea05579543193689b68d26',	'{{unknown}}'),
(2404,	643,	'_oembed_4d19f22c0a56841719968a9e802d560a',	'{{unknown}}'),
(2405,	645,	'_edit_last',	'1'),
(2409,	645,	'_oembed_d55dd6c42b39f30a146bb33ed5bb2456',	'{{unknown}}'),
(2412,	647,	'_edit_last',	'1'),
(2408,	645,	'_edit_lock',	'1451388185:1'),
(2410,	645,	'_oembed_7d6d621a43740446c2a5c23dce585fd1',	'{{unknown}}'),
(2411,	645,	'_oembed_8a369544dfe0f7d91f49d9b954f1ef9c',	'{{unknown}}'),
(2416,	647,	'_oembed_c69f2bb88f07daaba43c8779c0acbb42',	'{{unknown}}'),
(2415,	647,	'_edit_lock',	'1451388308:1'),
(2417,	647,	'_oembed_34082700c8af44ac90f19793e74b0695',	'{{unknown}}'),
(2418,	647,	'_oembed_93f0e1aed45448d89dc1f64884e00446',	'{{unknown}}'),
(2419,	649,	'_edit_last',	'1'),
(2423,	649,	'_oembed_35721bf5c9a8bbbd784d0217bc39e753',	'{{unknown}}'),
(2424,	649,	'_oembed_b0c260e59a584737e3a175fd4a8f42df',	'{{unknown}}'),
(2422,	649,	'_edit_lock',	'1451388431:1'),
(2425,	649,	'_oembed_d637b110eb7091ccfd89c415e0cd3195',	'{{unknown}}'),
(2426,	651,	'_edit_last',	'1'),
(2430,	651,	'_oembed_f2d57d5ffa9b1042be4a90e06f839815',	'{{unknown}}'),
(2429,	651,	'_edit_lock',	'1451388555:1'),
(2431,	651,	'_oembed_e80f057075ad8c476446b954caa95637',	'{{unknown}}'),
(2432,	651,	'_oembed_12714f01d650d037418a5a5ca4b95c7d',	'{{unknown}}'),
(2433,	653,	'_edit_last',	'1'),
(2437,	653,	'_oembed_34ae18104e44ab807a26263963328e3c',	'{{unknown}}'),
(2436,	653,	'_edit_lock',	'1451388678:1'),
(2438,	653,	'_oembed_b38d6c3ea03c06b3eeae8437adf68f2b',	'{{unknown}}'),
(2439,	653,	'_oembed_701440a0b3d60b00912ea1cb9d27088e',	'{{unknown}}'),
(2440,	655,	'_edit_last',	'1'),
(2444,	655,	'_oembed_111d23bca39e0cc996786ef585dab94b',	'{{unknown}}'),
(2443,	655,	'_edit_lock',	'1451388801:1'),
(2445,	655,	'_oembed_4c4cb0061d5100e0f8ea1866c8c7c8eb',	'{{unknown}}'),
(2446,	655,	'_oembed_f9993523f5babd0d272a259d4665781b',	'{{unknown}}'),
(2447,	657,	'_edit_last',	'1'),
(2451,	657,	'_oembed_ef63b7c1dc871c654c25fc3e2d0bad94',	'{{unknown}}'),
(2450,	657,	'_edit_lock',	'1451388924:1'),
(2452,	657,	'_oembed_c6da3ebaf30d46a81cdf8d29d806bec2',	'{{unknown}}'),
(2453,	657,	'_oembed_32cff359c7ddab119b837c5355129dc6',	'{{unknown}}'),
(2454,	659,	'_edit_last',	'1'),
(2458,	659,	'_oembed_92b2dc6a0500cb4a0a2e264a06843146',	'{{unknown}}'),
(2457,	659,	'_edit_lock',	'1451389047:1'),
(2459,	659,	'_oembed_f97167574a24d00945bcc44c07e3c378',	'{{unknown}}'),
(2460,	659,	'_oembed_eca4a20948c995415ded4fb476207520',	'{{unknown}}'),
(2461,	661,	'_edit_last',	'1'),
(2465,	661,	'_oembed_6800c8aaef11bc79da4ff11d3de1ecda',	'{{unknown}}'),
(2464,	661,	'_edit_lock',	'1451389170:1'),
(2466,	661,	'_oembed_84b8b5b062636b9d2cce7e7d9a2c24a6',	'{{unknown}}'),
(2467,	661,	'_oembed_be5b6dd710e9d706a720baaa27b3181f',	'{{unknown}}'),
(2468,	663,	'_edit_last',	'1'),
(2475,	665,	'_edit_last',	'1'),
(2471,	663,	'_edit_lock',	'1451389294:1'),
(2472,	663,	'_oembed_dfc854c0753a76842eb733ef4509576d',	'{{unknown}}'),
(2473,	663,	'_oembed_397eaeed0cc543fcb10835fb5660b12d',	'{{unknown}}'),
(2474,	663,	'_oembed_48c550890808db850bfb0f19c2c4828a',	'{{unknown}}'),
(2482,	667,	'_edit_last',	'1'),
(2478,	665,	'_edit_lock',	'1451389417:1'),
(2479,	665,	'_oembed_bbc9bd1abf89d85f87f42f995b30918e',	'{{unknown}}'),
(2480,	665,	'_oembed_97c3d939ca40b1980c962b1a83a9d7ff',	'{{unknown}}'),
(2481,	665,	'_oembed_96fc5812e0c37c32c9040a58f04d787b',	'{{unknown}}'),
(2486,	667,	'_oembed_cd99b8f4e00172037302997e3e88cb73',	'{{unknown}}'),
(2485,	667,	'_edit_lock',	'1451389540:1'),
(2487,	667,	'_oembed_e69bf231f446261bf2b6c111c7335bed',	'{{unknown}}'),
(2488,	667,	'_oembed_d2f7ec9c905cf75efe63e38e4e1b419a',	'{{unknown}}'),
(2489,	669,	'_edit_last',	'1'),
(2493,	669,	'_oembed_6dfaab0aab3c52a09d98819fdc6648a4',	'{{unknown}}'),
(2495,	669,	'_oembed_c58503c0a9976624baa85ca720843759',	'{{unknown}}'),
(2492,	669,	'_edit_lock',	'1451389663:1'),
(2494,	669,	'_oembed_30f188e0bb7aa3b42e2735737297d0f5',	'{{unknown}}'),
(2496,	671,	'_edit_last',	'1'),
(2500,	671,	'_oembed_3f5bb543b387ba448cc3e39875d4999e',	'{{unknown}}'),
(2502,	671,	'_oembed_eb1b48baf5b71e284beab89aedb42de6',	'{{unknown}}'),
(2499,	671,	'_edit_lock',	'1451389787:1'),
(2501,	671,	'_oembed_e88d7fbb4b594039fab0e52018ae7284',	'{{unknown}}'),
(2503,	673,	'_edit_last',	'1'),
(2507,	673,	'_oembed_55a99c34770cfc8f25cd1dad5270e1db',	'{{unknown}}'),
(2510,	675,	'_edit_last',	'1'),
(2506,	673,	'_edit_lock',	'1451389910:1'),
(2508,	673,	'_oembed_896af705c0169b37605c51e14b8d2e3b',	'{{unknown}}'),
(2509,	673,	'_oembed_1578fbea5b4c4b9084132f192e729085',	'{{unknown}}'),
(2514,	675,	'_oembed_ebff8b53e4d2706b0949474259fa80df',	'{{unknown}}'),
(2513,	675,	'_edit_lock',	'1451390033:1'),
(2515,	675,	'_oembed_16be892b7766caa474522e5e65c2cb26',	'{{unknown}}'),
(2516,	675,	'_oembed_6afa24ef868629f5ff9b611b22bba09c',	'{{unknown}}'),
(2517,	677,	'_edit_last',	'1'),
(2521,	677,	'_oembed_36331ad6c94d08385a0dafad7cfde6c1',	'{{unknown}}'),
(2524,	679,	'_edit_last',	'1'),
(2520,	677,	'_edit_lock',	'1451390158:1'),
(2522,	677,	'_oembed_05deffff2e830921938d7f50400bda0a',	'{{unknown}}'),
(2523,	677,	'_oembed_283d14d8f687b6262a9104982dc4b23d',	'{{unknown}}'),
(2528,	679,	'_oembed_c3464b59f4605fcbe0b9b1de0592ae98',	'{{unknown}}'),
(2527,	679,	'_edit_lock',	'1451390282:1'),
(2529,	679,	'_oembed_3e397c30eecc5492bbb2a33b4975309e',	'{{unknown}}'),
(2530,	679,	'_oembed_cc056344e6f8a802f3b81c9a81f940fc',	'{{unknown}}'),
(2531,	681,	'_edit_last',	'1'),
(2535,	681,	'_oembed_ad057ac156e481c9309d7a7d39c63f6e',	'{{unknown}}'),
(2534,	681,	'_edit_lock',	'1451390407:1'),
(2536,	681,	'_oembed_ab4e67d6196ac48f5515b93709918e96',	'{{unknown}}'),
(2537,	681,	'_oembed_3493c3bad03a6d5658c3a063c0298aff',	'{{unknown}}'),
(2538,	683,	'_edit_last',	'1'),
(2542,	683,	'_oembed_2da7e0c1ddf7f3ff299c454877970d52',	'{{unknown}}'),
(2545,	685,	'_edit_last',	'1'),
(2541,	683,	'_edit_lock',	'1451390533:1'),
(2543,	683,	'_oembed_10dba19cf1de9bf0525344f2d176c999',	'{{unknown}}'),
(2544,	683,	'_oembed_66274487960724dcd3212f41bc7aa238',	'{{unknown}}'),
(2549,	685,	'_oembed_05fd658e3dc88b9b564df3f9c3fa10f2',	'{{unknown}}'),
(2548,	685,	'_edit_lock',	'1451390655:1'),
(2550,	685,	'_oembed_06fc842694974815a410c26182466b7e',	'{{unknown}}'),
(2551,	685,	'_oembed_c416333309bcddb3758c49f3c7f59f78',	'{{unknown}}'),
(2552,	687,	'_edit_last',	'1'),
(2556,	687,	'_oembed_6bb86032be4ee27de9c2371d0fa639d4',	'{{unknown}}'),
(2557,	687,	'_oembed_7b8d0753b3c0fc5612c6a9bf54763a8f',	'{{unknown}}'),
(2555,	687,	'_edit_lock',	'1451390778:1'),
(2558,	687,	'_oembed_a61ba6aeb774fc5d9c822adf4507281c',	'{{unknown}}'),
(2559,	689,	'_edit_last',	'1'),
(2563,	689,	'_oembed_fa16b2a7a044520e906ba47608b9d9ba',	'{{unknown}}'),
(2562,	689,	'_edit_lock',	'1451390901:1'),
(2564,	689,	'_oembed_da299eb324ecc5711a06c76a473e8248',	'{{unknown}}'),
(2565,	689,	'_oembed_3183c3615aa16ff2e657875a2c3743ab',	'{{unknown}}'),
(2566,	691,	'_edit_last',	'1'),
(2570,	691,	'_oembed_5ee6a0d45bc881c190fa658205ffea50',	'{{unknown}}'),
(2569,	691,	'_edit_lock',	'1451391024:1'),
(2571,	691,	'_oembed_fb6b842187732a90c903f8847ba5ba80',	'{{unknown}}'),
(2572,	691,	'_oembed_aae0dad66c78cba3a18da46b153b8496',	'{{unknown}}'),
(2573,	693,	'_edit_last',	'1'),
(2577,	693,	'_oembed_bbf3d35b39a73c16a2f7fb58eba22dbc',	'{{unknown}}'),
(2580,	695,	'_edit_last',	'1'),
(2576,	693,	'_edit_lock',	'1451391147:1'),
(2578,	693,	'_oembed_4757427ea8e791d80c090927ffc7b29a',	'{{unknown}}'),
(2579,	693,	'_oembed_dfb18d2949f6b40415de808ebaa388b9',	'{{unknown}}'),
(2584,	695,	'_oembed_ddc81001ed068fcdc64548fc615dc3f8',	'{{unknown}}'),
(2583,	695,	'_edit_lock',	'1451391270:1'),
(2585,	695,	'_oembed_eec78592982f0612dd53b5b832d11b7a',	'{{unknown}}'),
(2586,	695,	'_oembed_ff4f6fdad82da22bcb38be5299217319',	'{{unknown}}'),
(2587,	697,	'_edit_last',	'1'),
(2591,	697,	'_oembed_01fc7bc01990dc42ea11c4c845b46c24',	'{{unknown}}'),
(2590,	697,	'_edit_lock',	'1451391393:1'),
(2592,	697,	'_oembed_c7cf132cf23adf0d230689fa99325eb7',	'{{unknown}}'),
(2593,	697,	'_oembed_fcac81c7371a6f436491d079aba9f437',	'{{unknown}}'),
(2594,	699,	'_edit_last',	'1'),
(2598,	699,	'_oembed_7b2ee61a7cac925f7713b4bf41f17bc9',	'{{unknown}}'),
(2597,	699,	'_edit_lock',	'1451391516:1'),
(2599,	699,	'_oembed_678dd2fc3ed8214d64ff3211a8d72070',	'{{unknown}}'),
(2600,	699,	'_oembed_4078b35f0e29f17e75876c0162f7d241',	'{{unknown}}'),
(2601,	701,	'_edit_last',	'1'),
(2605,	701,	'_oembed_6520f9cde806cc3007fc035ad1ebdbee',	'{{unknown}}'),
(2604,	701,	'_edit_lock',	'1451391638:1'),
(2606,	701,	'_oembed_91b71eb59ef1258cbd5c22bb634a99d2',	'{{unknown}}'),
(2607,	701,	'_oembed_0e591722d73ac2081b9925976da28005',	'{{unknown}}'),
(2608,	703,	'_edit_last',	'1'),
(2612,	703,	'_oembed_8d080e87e8a7ea05e14713ef24f738ea',	'{{unknown}}'),
(2611,	703,	'_edit_lock',	'1451391761:1'),
(2613,	703,	'_oembed_0e012dfe04efab71546d34af84328673',	'{{unknown}}'),
(2614,	703,	'_oembed_8a96348afe3e693ecb0039e8eb71ec7a',	'{{unknown}}'),
(2615,	705,	'_edit_last',	'1'),
(2619,	705,	'_oembed_09a376e2b9982d67fadb78507fecc928',	'{{unknown}}'),
(2618,	705,	'_edit_lock',	'1451391884:1'),
(2620,	705,	'_oembed_2c2cfa9a3a938bce2e86c121281aed99',	'{{unknown}}'),
(2621,	705,	'_oembed_5817b3991ce097ce29a644440f90ed58',	'{{unknown}}'),
(2622,	707,	'_edit_last',	'1'),
(2626,	707,	'_oembed_58113f94e6c184fff7951e8e276e7ae2',	'{{unknown}}'),
(2625,	707,	'_edit_lock',	'1451392010:1'),
(2627,	707,	'_oembed_c803c48901645786611db81f055ef6c2',	'{{unknown}}'),
(2628,	707,	'_oembed_d557776b045a0eaf78165595b123a41b',	'{{unknown}}'),
(2629,	709,	'_edit_last',	'1'),
(2633,	709,	'_oembed_cbf48aaedb9e2e23d37fec349f2de2bd',	'{{unknown}}'),
(2632,	709,	'_edit_lock',	'1451392133:1'),
(2634,	709,	'_oembed_87768b407dd209f62b4ad912b921535f',	'{{unknown}}'),
(2635,	709,	'_oembed_0c1a7c76137a724d63abd38066c0073e',	'{{unknown}}'),
(2636,	711,	'_edit_last',	'1'),
(2640,	711,	'_oembed_0e87f4931cfa01d1621f0dc326ec025c',	'{{unknown}}'),
(2639,	711,	'_edit_lock',	'1451392257:1'),
(2641,	711,	'_oembed_7819416d39d5a16eedd1c630f05dcf33',	'{{unknown}}'),
(2642,	711,	'_oembed_080ea9787933193c17e4b153846806fc',	'{{unknown}}'),
(2643,	713,	'_edit_last',	'1'),
(2647,	713,	'_oembed_6cae463b0cac6f09c0adfd0f3bb9c7ec',	'{{unknown}}'),
(2649,	713,	'_oembed_9e1af697bfc3a0c629f9f9fba5a4f99c',	'{{unknown}}'),
(2646,	713,	'_edit_lock',	'1451392381:1'),
(2648,	713,	'_oembed_020d132afb2d76edf999c2ffa9902915',	'{{unknown}}'),
(2650,	715,	'_edit_last',	'1'),
(2654,	715,	'_oembed_b5f2e6a17d8cac72d3540599b754fce6',	'{{unknown}}'),
(2657,	717,	'_edit_last',	'1'),
(2653,	715,	'_edit_lock',	'1451392504:1'),
(2655,	715,	'_oembed_e69e207fe21f6a2819b72b3a21883a5d',	'{{unknown}}'),
(2656,	715,	'_oembed_bf09b254294e197c6d8a0fbdf294c05b',	'{{unknown}}'),
(2661,	717,	'_oembed_43e7693045dc3e6ba14d3f97d3ac5997',	'{{unknown}}'),
(2660,	717,	'_edit_lock',	'1451392628:1'),
(2662,	717,	'_oembed_9074761c7014f0962aef4d7baecc4cf3',	'{{unknown}}'),
(2663,	717,	'_oembed_07b75dda29ead8514c3d4e73f114a9dd',	'{{unknown}}'),
(2664,	719,	'_edit_last',	'1'),
(2668,	719,	'_oembed_b5e624199e97e6b1b0d2bda58befcb47',	'{{unknown}}'),
(2667,	719,	'_edit_lock',	'1451392751:1'),
(2669,	719,	'_oembed_7612e9e8f82e7fd5fb2d4354dc770b4c',	'{{unknown}}'),
(2670,	719,	'_oembed_c01fc5fe01da7f67869d90cb26c55c3d',	'{{unknown}}'),
(2671,	721,	'_edit_last',	'1'),
(2675,	721,	'_oembed_1f48544193739a809716e65d7c15e8f9',	'{{unknown}}'),
(2674,	721,	'_edit_lock',	'1451392874:1'),
(2676,	721,	'_oembed_8aeff20d7e934f690b750eae32f6899d',	'{{unknown}}'),
(2677,	721,	'_oembed_75032988fe809186dd518f8b3bd068a2',	'{{unknown}}'),
(2678,	723,	'_edit_last',	'1'),
(2682,	723,	'_oembed_d81eb0db9d7e377e1586a8424c572f05',	'{{unknown}}'),
(2681,	723,	'_edit_lock',	'1451392997:1'),
(2683,	723,	'_oembed_e015b98f150fcb166fc9e573201b9069',	'{{unknown}}'),
(2684,	723,	'_oembed_27628ad5b111282206a0cb87dd99cdf7',	'{{unknown}}'),
(2685,	725,	'_edit_last',	'1'),
(2689,	725,	'_oembed_69691254d5be9eb681729851341da283',	'{{unknown}}'),
(2688,	725,	'_edit_lock',	'1451393122:1'),
(2690,	725,	'_oembed_f5a33ad63564e8972f512a9ee1ed9b37',	'{{unknown}}'),
(2691,	725,	'_oembed_56724f229715ce3c1f8420106e9aed45',	'{{unknown}}'),
(2692,	727,	'_edit_last',	'1'),
(2696,	727,	'_oembed_0c10942093c779ed17dd5af503f2a158',	'{{unknown}}'),
(2699,	729,	'_edit_last',	'1'),
(2695,	727,	'_edit_lock',	'1451393260:1'),
(2697,	727,	'_oembed_7649cff1fbc86e64fe24bb12b74cedf7',	'{{unknown}}'),
(2698,	727,	'_oembed_f1ab2c99a92eaead39dc2b48ac728cc3',	'{{unknown}}'),
(2703,	729,	'_oembed_6a1938da0e4365608410eb4face37cc2',	'{{unknown}}'),
(2702,	729,	'_edit_lock',	'1451394170:1'),
(2704,	729,	'_oembed_9c03658aff6363905c236b71dd1a73b2',	'{{unknown}}'),
(2705,	729,	'_oembed_fbc2e29cc00f6f04620404421383af03',	'{{unknown}}'),
(2706,	731,	'_edit_last',	'1'),
(2710,	731,	'_oembed_e6815b07913741ed5aaf219296ff16fb',	'{{unknown}}'),
(2711,	731,	'_oembed_9a149b3b8bd4da6201149f8d38401e66',	'{{unknown}}'),
(2709,	731,	'_edit_lock',	'1451394293:1'),
(2712,	731,	'_oembed_92cefc0d1b582561272e36dd2dd2bbe3',	'{{unknown}}'),
(2713,	733,	'_edit_last',	'1'),
(2717,	733,	'_oembed_e70df86f7af953d7ea65a6301d6b1a3b',	'{{unknown}}'),
(2716,	733,	'_edit_lock',	'1451394415:1'),
(2718,	733,	'_oembed_3d5b3d049984db3c366bf4e494d141e4',	'{{unknown}}'),
(2719,	733,	'_oembed_1e179690f1de1732e8d20065214b26fb',	'{{unknown}}'),
(2720,	735,	'_edit_last',	'1'),
(2724,	735,	'_oembed_07e5132974b5a7ab5d47ce064530cabe',	'{{unknown}}'),
(2723,	735,	'_edit_lock',	'1451394539:1'),
(2725,	735,	'_oembed_c39f02aa7b7acc1d489a42f0bce9dd87',	'{{unknown}}'),
(2726,	735,	'_oembed_3f96a0902a5b24851ba8a79ba2d975cd',	'{{unknown}}'),
(2727,	737,	'_edit_last',	'1'),
(2731,	737,	'_oembed_93ea000f067488d1015ce9b6098fc6f5',	'{{unknown}}'),
(2734,	739,	'_edit_last',	'1'),
(2730,	737,	'_edit_lock',	'1451394662:1'),
(2732,	737,	'_oembed_29de4f5f11b61cd6a223fbb1b1df9554',	'{{unknown}}'),
(2733,	737,	'_oembed_7f62013988e5d9f790f189a016df55fc',	'{{unknown}}'),
(2738,	739,	'_oembed_a665cdb3e81defcec7d3eff6bc649551',	'{{unknown}}'),
(2737,	739,	'_edit_lock',	'1451394784:1'),
(2739,	739,	'_oembed_d36f235f5f0b063d7f83dcdff14456c3',	'{{unknown}}'),
(2740,	739,	'_oembed_7bc9315e4b211230c6b10a2a5445aeb2',	'{{unknown}}'),
(2741,	741,	'_edit_last',	'1'),
(2745,	741,	'_oembed_5f1dce5d2adb8d8495e14c636caef2db',	'{{unknown}}'),
(2744,	741,	'_edit_lock',	'1451394907:1'),
(2746,	741,	'_oembed_a375e269332d21a3bca39dca68cf675e',	'{{unknown}}'),
(2747,	741,	'_oembed_3c97296d778c10c369eb1ec70abbaffb',	'{{unknown}}'),
(2748,	743,	'_edit_last',	'1'),
(2752,	743,	'_oembed_374ad8ade1e748f484755a0534465ede',	'{{unknown}}'),
(2755,	745,	'_edit_last',	'1'),
(2751,	743,	'_edit_lock',	'1451395031:1'),
(2753,	743,	'_oembed_933d8600c1825ab29fdd6bb64bf5ae63',	'{{unknown}}'),
(2754,	743,	'_oembed_0bf76e19f1e3dd4adfa76fcdbc3e4573',	'{{unknown}}'),
(2759,	745,	'_oembed_8d179bd248bdaa0124cd85679b859ff4',	'{{unknown}}'),
(2758,	745,	'_edit_lock',	'1451395156:1'),
(2760,	745,	'_oembed_011aa84df86121a49bc2f9f305b5a1aa',	'{{unknown}}'),
(2761,	745,	'_oembed_ab020d8dc0b447f32da548249cea7bd2',	'{{unknown}}'),
(2762,	747,	'_edit_last',	'1'),
(2766,	749,	'_edit_last',	'1'),
(2765,	747,	'_edit_lock',	'1451395280:1'),
(2770,	749,	'_oembed_b2bc3dff52d1d8f5d24cca851f5283eb',	'{{unknown}}'),
(2769,	749,	'_edit_lock',	'1451395404:1'),
(2771,	749,	'_oembed_45d5b3614202fa6a9b3c2e29f472a1a1',	'{{unknown}}'),
(2772,	749,	'_oembed_2143e5ca1e608a21b495b53f30c97981',	'{{unknown}}'),
(2773,	751,	'_edit_last',	'1'),
(2777,	751,	'_oembed_699abdd9213abd0d403bf7f602ac93df',	'{{unknown}}'),
(2776,	751,	'_edit_lock',	'1451395527:1'),
(2778,	751,	'_oembed_0fa479fd790a39597b2da39ddd042002',	'{{unknown}}'),
(2779,	751,	'_oembed_0d80a9ce4764e92ed316a0d9abda77dc',	'{{unknown}}'),
(2780,	753,	'_edit_last',	'1'),
(2784,	753,	'_oembed_21f7449591b4a2733e7549eb7ed002e3',	'{{unknown}}'),
(2783,	753,	'_edit_lock',	'1451395650:1'),
(2785,	753,	'_oembed_8c14e03d519f0df6de9ca1a78c980771',	'{{unknown}}'),
(2786,	753,	'_oembed_de8f1e17d5d9288e249bda88057541e3',	'{{unknown}}'),
(23725,	4087,	'_wptp_twitter_api',	'a:1:{i:0;s:159:\"WooThemes WooCommerce Cart Notices v141 http://hotfile.pw/misc/woothemes-woocommerce-cart-notices-v141.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(2794,	757,	'_edit_last',	'1'),
(2798,	757,	'_oembed_fd4ade70c3ea744be3c3e64668f0f987',	'{{unknown}}'),
(2800,	757,	'_oembed_7ab9812eae51e84a02f5a9a357d8aff3',	'{{unknown}}'),
(2797,	757,	'_edit_lock',	'1451395897:1'),
(2799,	757,	'_oembed_6acc3f1905f83ac1852942eeaf402d0d',	'{{unknown}}'),
(2801,	759,	'_edit_last',	'1'),
(2805,	759,	'_oembed_fd313697293a63ba43fe117079eff590',	'{{unknown}}'),
(2806,	759,	'_oembed_e9a0b5864dd4135cd8d45d7fc0366cc6',	'{{unknown}}'),
(2804,	759,	'_edit_lock',	'1451396020:1'),
(2807,	759,	'_oembed_59d8dc9d302a78e6bab32e4e4c1950dc',	'{{unknown}}'),
(2808,	761,	'_edit_last',	'1'),
(2812,	761,	'_oembed_27b3a0de3ab3ce1e87efb707d6d02eda',	'{{unknown}}'),
(2811,	761,	'_edit_lock',	'1451403343:1'),
(2813,	761,	'_oembed_350b2722765c104c3f6bb4422265e925',	'{{unknown}}'),
(2814,	761,	'_oembed_41ce823b283d314c52fe453b88154136',	'{{unknown}}'),
(2815,	763,	'_edit_last',	'1'),
(2819,	763,	'_oembed_226a5f6f04b78c80a3fb4e019ababe96',	'{{unknown}}'),
(2818,	763,	'_edit_lock',	'1451403467:1'),
(2820,	763,	'_oembed_61b48b8fbc2200e305b735ed4bdc3e22',	'{{unknown}}'),
(2821,	763,	'_oembed_dd1760dc7b6c95af21040530085ef2b7',	'{{unknown}}'),
(2822,	765,	'_edit_last',	'1'),
(2826,	765,	'_oembed_93d33e9088deb11556ce3a51a1a4b453',	'{{unknown}}'),
(2828,	765,	'_oembed_df19a97e7ed7c70d9abfb70762c37ddf',	'{{unknown}}'),
(2825,	765,	'_edit_lock',	'1451403590:1'),
(2827,	765,	'_oembed_f79007607ca084303ab128510d234089',	'{{unknown}}'),
(2829,	767,	'_edit_last',	'1'),
(2833,	767,	'_oembed_f490d109045682c7ac9be29cb9cb70d1',	'{{unknown}}'),
(2836,	769,	'_edit_last',	'1'),
(2832,	767,	'_edit_lock',	'1451403713:1'),
(2834,	767,	'_oembed_2d7c1c11803fd1bda8425a6a886d6295',	'{{unknown}}'),
(2835,	767,	'_oembed_a6da68cbd25ab14260e35cef530dcc07',	'{{unknown}}'),
(2840,	769,	'_oembed_677f2ab399d077e0125479ecd664c776',	'{{unknown}}'),
(2839,	769,	'_edit_lock',	'1451403837:1'),
(2841,	769,	'_oembed_03cf7241cc0f454c4dd4aded0584132a',	'{{unknown}}'),
(2842,	769,	'_oembed_2421797b2085e6239ce53d72d38795c0',	'{{unknown}}'),
(2843,	771,	'_edit_last',	'1'),
(2847,	771,	'_oembed_4c00b5207dd5218af5d3c579d51935d1',	'{{unknown}}'),
(2848,	771,	'_oembed_9906d5eeef6692dcb8d57f213db4996c',	'{{unknown}}'),
(2846,	771,	'_edit_lock',	'1451403960:1'),
(2849,	771,	'_oembed_4082ef67be96f527d36b3ff347ea74fd',	'{{unknown}}'),
(2850,	773,	'_edit_last',	'1'),
(2854,	773,	'_oembed_b896018fb7390bc0b57efe071df420d0',	'{{unknown}}'),
(2853,	773,	'_edit_lock',	'1451404083:1'),
(2855,	773,	'_oembed_5585fb66ad8e8e21f76f30cd86642737',	'{{unknown}}'),
(2856,	773,	'_oembed_42b1fb7f2ec74834189463df34b091ca',	'{{unknown}}'),
(2857,	775,	'_edit_last',	'1'),
(2861,	775,	'_oembed_674efe247c97d0710331a9d5519d3863',	'{{unknown}}'),
(2860,	775,	'_edit_lock',	'1451404205:1'),
(2862,	775,	'_oembed_b4b9d46e176b45d3da651c6907ed5208',	'{{unknown}}'),
(2863,	775,	'_oembed_65b1005c7944ba3aa226cf6f9c1be9a6',	'{{unknown}}'),
(2864,	777,	'_edit_last',	'1'),
(2868,	777,	'_oembed_ae68d25a074481766c56bddbcbc74aa0',	'{{unknown}}'),
(2869,	777,	'_oembed_7b7d961d3fa13238bd5c1e6d05282116',	'{{unknown}}'),
(2867,	777,	'_edit_lock',	'1451404329:1'),
(2870,	777,	'_oembed_c0dcd5e533f6640a15956ebd0f16f63f',	'{{unknown}}'),
(2871,	779,	'_edit_last',	'1'),
(2875,	779,	'_oembed_f518acbec34a2836f55ec525a4c328d8',	'{{unknown}}'),
(2874,	779,	'_edit_lock',	'1451404452:1'),
(2876,	779,	'_oembed_db6605e605928c35cbd93d45b3b65da8',	'{{unknown}}'),
(2877,	779,	'_oembed_642ff159c0320ab1af4ad08868745eed',	'{{unknown}}'),
(2878,	781,	'_edit_last',	'1'),
(2882,	781,	'_oembed_069452a0684ff1297bd20b378602fa00',	'{{unknown}}'),
(2884,	781,	'_oembed_29ad8e9737ff20f4380bc83ce6603e2d',	'{{unknown}}'),
(2881,	781,	'_edit_lock',	'1451404575:1'),
(2883,	781,	'_oembed_facaeed904563d6277125bb116e42665',	'{{unknown}}'),
(2885,	783,	'_edit_last',	'1'),
(2889,	783,	'_oembed_12fb41963ae8d4dc2645f3df48e044d4',	'{{unknown}}'),
(2888,	783,	'_edit_lock',	'1451404699:1'),
(2890,	783,	'_oembed_8b52156ced4cfca35772493916d2e0ea',	'{{unknown}}'),
(2891,	783,	'_oembed_c6836f15481e533bb38c393ab1ed1022',	'{{unknown}}'),
(2892,	785,	'_edit_last',	'1'),
(2896,	785,	'_oembed_332d6f1cfebacfe9448de9193fa07220',	'{{unknown}}'),
(2895,	785,	'_edit_lock',	'1451404850:1'),
(2897,	785,	'_oembed_2bc2d8119e7d6124fa1af6b97f64fd50',	'{{unknown}}'),
(2898,	785,	'_oembed_1ee80d07ea9765aa1a21435290d7aff0',	'{{unknown}}'),
(2899,	787,	'_edit_last',	'1'),
(2903,	787,	'_oembed_39fc8dfdfbdcfce021ac4118474d8619',	'{{unknown}}'),
(2906,	789,	'_edit_last',	'1'),
(2902,	787,	'_edit_lock',	'1451404973:1'),
(2904,	787,	'_oembed_da1d721e67941a41e396fdfa0efb89b9',	'{{unknown}}'),
(2905,	787,	'_oembed_18b9ee25142bea203ea1a7d583eda52f',	'{{unknown}}'),
(2910,	789,	'_oembed_2e16977986e3151b9b612d6fc9173f64',	'{{unknown}}'),
(2911,	789,	'_oembed_8682e66b5646b71bcc683cb73ad795b3',	'{{unknown}}'),
(2909,	789,	'_edit_lock',	'1451405097:1'),
(2912,	789,	'_oembed_3f621fd10d4ba576324007ad0ed924af',	'{{unknown}}'),
(2913,	791,	'_edit_last',	'1'),
(2917,	791,	'_oembed_1a9ddd2d445c756707a3ef035ccb800a',	'{{unknown}}'),
(2916,	791,	'_edit_lock',	'1451405220:1'),
(2918,	791,	'_oembed_7ca0d3f3a660867cf767da2b64e76241',	'{{unknown}}'),
(2919,	791,	'_oembed_4fa090d8ef7b8c4c50e77bcced7abc4a',	'{{unknown}}'),
(2920,	793,	'_edit_last',	'1'),
(2924,	793,	'_oembed_fccfd82068de0c7a81a44d9a93588c5f',	'{{unknown}}'),
(2923,	793,	'_edit_lock',	'1451405343:1'),
(2925,	793,	'_oembed_eeb02de28194bab14ebcb2d3533dbf7a',	'{{unknown}}'),
(2926,	795,	'_edit_last',	'1'),
(2930,	795,	'_oembed_c76c3cb818bc4ea68ac95a6a588688d5',	'{{unknown}}'),
(2929,	795,	'_edit_lock',	'1451405466:1'),
(2931,	795,	'_oembed_462b4a324b6f19ab43474c6d365c4b54',	'{{unknown}}'),
(2932,	795,	'_oembed_9d29307ab694fb42b6848227aaefbf23',	'{{unknown}}'),
(2933,	797,	'_edit_last',	'1'),
(2937,	797,	'_oembed_9f21a7a012b7549b6b7b6c2d8de932dd',	'{{unknown}}'),
(2939,	797,	'_oembed_306140876761d1329d3436cd5582d79f',	'{{unknown}}'),
(2936,	797,	'_edit_lock',	'1451405590:1'),
(2938,	797,	'_oembed_6d1b0038d3c359afc82dc69e6da978a3',	'{{unknown}}'),
(2940,	799,	'_edit_last',	'1'),
(2944,	799,	'_oembed_535cdf34ab79bf133facce18fbc77ecf',	'{{unknown}}'),
(2943,	799,	'_edit_lock',	'1451405713:1'),
(2945,	799,	'_oembed_f8aec73733fc343bf027cb966d0cec49',	'{{unknown}}'),
(2946,	799,	'_oembed_82b3f2d686172e20f235cc65295a7434',	'{{unknown}}'),
(2947,	801,	'_edit_last',	'1'),
(2951,	801,	'_oembed_5b2c9917b426025357a903d46a5fb998',	'{{unknown}}'),
(2950,	801,	'_edit_lock',	'1451405836:1'),
(2952,	801,	'_oembed_806febd72ab5edd6b2e5f2a5ba127792',	'{{unknown}}'),
(2953,	801,	'_oembed_ab4899e1ce5fc45acded7d9ef6a344db',	'{{unknown}}'),
(2954,	803,	'_edit_last',	'1'),
(2958,	803,	'_oembed_3c0c777d0df8e0c9795f382ffa1eb54c',	'{{unknown}}'),
(2957,	803,	'_edit_lock',	'1451406944:1'),
(2959,	803,	'_oembed_ccd60cf98452c3ea9fb2e0aefe104d73',	'{{unknown}}'),
(2960,	803,	'_oembed_a2007d1962c59baaac138b928417fedd',	'{{unknown}}'),
(2961,	805,	'_edit_last',	'1'),
(2965,	805,	'_oembed_96e9c1cb1d09a0a0c9f11f07ff9d4175',	'{{unknown}}'),
(2964,	805,	'_edit_lock',	'1451407067:1'),
(2966,	805,	'_oembed_afef39c01366290e2d4f4678aaf90101',	'{{unknown}}'),
(2967,	805,	'_oembed_af238276d9869bb9006da0fd724f4f7b',	'{{unknown}}'),
(2968,	807,	'_edit_last',	'1'),
(2972,	807,	'_oembed_3a3cc2f7af0892413a4a846d0b4347ab',	'{{unknown}}'),
(2973,	807,	'_oembed_13fc1cf431683af883b73e016b3dbabc',	'{{unknown}}'),
(2971,	807,	'_edit_lock',	'1451407190:1'),
(2974,	807,	'_oembed_a893042ee4f465224c4b60cecc13db38',	'{{unknown}}'),
(2975,	809,	'_edit_last',	'1'),
(2979,	809,	'_oembed_8f67772ff5a5695c2ddeb2cae8d31090',	'{{unknown}}'),
(2978,	809,	'_edit_lock',	'1451407313:1'),
(2980,	809,	'_oembed_aeaa080f7108af09156cd69edd5b0577',	'{{unknown}}'),
(2981,	809,	'_oembed_4fe0f884c52a28b218cd60d0225b015c',	'{{unknown}}'),
(2982,	811,	'_edit_last',	'1'),
(2986,	811,	'_oembed_895867ce6c33b598c315924173534906',	'{{unknown}}'),
(2985,	811,	'_edit_lock',	'1451407437:1'),
(2987,	811,	'_oembed_3bbc2e430ccb491acafaeebb2d48f318',	'{{unknown}}'),
(2988,	811,	'_oembed_a30b1f19b11941148d1f7ff7a9458312',	'{{unknown}}'),
(2989,	813,	'_edit_last',	'1'),
(2993,	813,	'_oembed_ab4bd82524a7c075ae2526b1c0f70b14',	'{{unknown}}'),
(2995,	813,	'_oembed_dd11b2e030e16f0b2a9c78089c542a45',	'{{unknown}}'),
(2992,	813,	'_edit_lock',	'1451407560:1'),
(2994,	813,	'_oembed_aadac74c86e9060289ef868a300f2a67',	'{{unknown}}'),
(2996,	815,	'_edit_last',	'1'),
(3000,	815,	'_oembed_6c5ce6e8e5c29e6b1e01abec118251f5',	'{{unknown}}'),
(3002,	815,	'_oembed_ee96e14dfc0ebc843f131bdcee8e7697',	'{{unknown}}'),
(2999,	815,	'_edit_lock',	'1451407683:1'),
(3001,	815,	'_oembed_7f2000297107ddaa5c0f7c44f9689283',	'{{unknown}}'),
(3003,	817,	'_edit_last',	'1'),
(3007,	817,	'_oembed_1178a92297d8f026ca8a26e18df1996b',	'{{unknown}}'),
(3006,	817,	'_edit_lock',	'1451407806:1'),
(3008,	817,	'_oembed_d96373fb16215c2ce2a3fb98e52f87ed',	'{{unknown}}'),
(3009,	817,	'_oembed_5ef4290c809667763f48cc2644bf5c8e',	'{{unknown}}'),
(3010,	819,	'_edit_last',	'1'),
(3014,	819,	'_oembed_36adf6367d0ed5147d6a920695a19bfb',	'{{unknown}}'),
(3013,	819,	'_edit_lock',	'1451407929:1'),
(3015,	819,	'_oembed_c58facc7233040effb00b103831fac57',	'{{unknown}}'),
(3016,	819,	'_oembed_6316cfbb0a03c9f209f4b220664b47eb',	'{{unknown}}'),
(3017,	821,	'_edit_last',	'1'),
(3021,	821,	'_oembed_14c6c099b50afe506e5f3e164a0c050f',	'{{unknown}}'),
(3020,	821,	'_edit_lock',	'1451408430:1'),
(3022,	821,	'_oembed_270935bd3a373d37046681809faab228',	'{{unknown}}'),
(3023,	821,	'_oembed_bc6d19267bd482c682d2651ea46f246e',	'{{unknown}}'),
(3024,	823,	'_edit_last',	'1'),
(3028,	823,	'_oembed_a0b78cfad9baa7c7186d1185cb2bb55b',	'{{unknown}}'),
(3031,	825,	'_edit_last',	'1'),
(3027,	823,	'_edit_lock',	'1451408553:1'),
(3029,	823,	'_oembed_d7748df5dd5f1ac20074da9dc56e9e94',	'{{unknown}}'),
(3030,	823,	'_oembed_085edf3c71153abf1636d10c84c3b2fd',	'{{unknown}}'),
(3035,	825,	'_oembed_4a72c15ea5f9929e66ae56240c0eaea1',	'{{unknown}}'),
(3034,	825,	'_edit_lock',	'1451408677:1'),
(3036,	825,	'_oembed_7de12a796235ae50a368356e3978917d',	'{{unknown}}'),
(3037,	825,	'_oembed_709e715eb7a48d3abe8764830c6ecfdf',	'{{unknown}}'),
(3038,	827,	'_edit_last',	'1'),
(3042,	827,	'_oembed_582a2e5ec65459ce8c43d40ac1062bf3',	'{{unknown}}'),
(3044,	827,	'_oembed_f28cfc09cb43f97ab4a969398f65bec3',	'{{unknown}}'),
(3041,	827,	'_edit_lock',	'1451408800:1'),
(3043,	827,	'_oembed_915cfc2c97cb76448ef04f29cb16a9d1',	'{{unknown}}'),
(3045,	829,	'_edit_last',	'1'),
(3049,	829,	'_oembed_69bca126abb801de45504eded39cc96d',	'{{unknown}}'),
(3050,	829,	'_oembed_8f27d9866ac3034e2c1b521d76e77eb1',	'{{unknown}}'),
(3048,	829,	'_edit_lock',	'1451408923:1'),
(3051,	829,	'_oembed_da23562dc55ed9059daa82875b6e2629',	'{{unknown}}'),
(3052,	831,	'_edit_last',	'1'),
(3056,	831,	'_oembed_53cdb1db9d7be4cbf308ac538c9d46f9',	'{{unknown}}'),
(3055,	831,	'_edit_lock',	'1451409046:1'),
(3057,	831,	'_oembed_29d978d9d7e5eff5f2fbb426f310b286',	'{{unknown}}'),
(3058,	831,	'_oembed_2b15b0d53fa3e6a7f1d89e8ca66ed074',	'{{unknown}}'),
(3059,	833,	'_edit_last',	'1'),
(3063,	833,	'_oembed_dcb1e71fdd6d7c3f9dd6ef7fbd852b5d',	'{{unknown}}'),
(3062,	833,	'_edit_lock',	'1451409169:1'),
(3064,	833,	'_oembed_90586b0e1b0b2da64e55e038dd8836b9',	'{{unknown}}'),
(3065,	833,	'_oembed_b6861ebf0428dcf31e5e153e1f0e7d64',	'{{unknown}}'),
(3066,	835,	'_edit_last',	'1'),
(3070,	835,	'_oembed_34deedc8806f5a5b45bdb862c3fc95b4',	'{{unknown}}'),
(3069,	835,	'_edit_lock',	'1451409293:1'),
(3071,	835,	'_oembed_d092fc14c4c60e8804a6ace8dd4a61e4',	'{{unknown}}'),
(3072,	835,	'_oembed_1f89d8ffabc077ee5369d8888a223239',	'{{unknown}}'),
(3073,	837,	'_edit_last',	'1'),
(3077,	837,	'_oembed_9bbbb23da835ef56aa33efb2c1be421f',	'{{unknown}}'),
(3080,	839,	'_edit_last',	'1'),
(3076,	837,	'_edit_lock',	'1451409416:1'),
(3078,	837,	'_oembed_814589a9ba57be0220fa6c57f5e47a40',	'{{unknown}}'),
(3079,	837,	'_oembed_51d78f5299d83248703ede32f21db8f9',	'{{unknown}}'),
(3084,	839,	'_oembed_830416401a20faffbf4b5f1d9fc3c168',	'{{unknown}}'),
(3083,	839,	'_edit_lock',	'1451409539:1'),
(3085,	839,	'_oembed_51a17c71e316ca6bb568bcb6377b96f4',	'{{unknown}}'),
(3086,	839,	'_oembed_0173b0e3b55584a4e457fb188dc9ee1e',	'{{unknown}}'),
(3087,	841,	'_edit_last',	'1'),
(3091,	841,	'_oembed_27f2fe0e99475ae6e611852887b50971',	'{{unknown}}'),
(3090,	841,	'_edit_lock',	'1451409664:1'),
(3092,	841,	'_oembed_b07ef223ec534eb919afb6c6dcf60385',	'{{unknown}}'),
(3093,	841,	'_oembed_ad998679c03ea027dbb1f52eda8c7682',	'{{unknown}}'),
(3094,	843,	'_edit_last',	'1'),
(3098,	843,	'_oembed_e84750b1e59af8c09eac2b5458388db2',	'{{unknown}}'),
(3099,	843,	'_oembed_2c60f72ffbc56077340459d857bc180b',	'{{unknown}}'),
(3097,	843,	'_edit_lock',	'1451409787:1'),
(3100,	843,	'_oembed_48530db0d1ff30925c2327e983025d9d',	'{{unknown}}'),
(3101,	845,	'_edit_last',	'1'),
(3105,	845,	'_oembed_cefcfd80f61244c19f51de2deb1d0805',	'{{unknown}}'),
(3104,	845,	'_edit_lock',	'1451410534:1'),
(3106,	845,	'_oembed_fc9281aea9e45e2c297f0cb04d4dab5f',	'{{unknown}}'),
(3107,	845,	'_oembed_f837c15cde95b233244b0d1bbd0ad776',	'{{unknown}}'),
(3108,	847,	'_edit_last',	'1'),
(3112,	847,	'_oembed_0e40697ca664157e8702c11705053bbd',	'{{unknown}}'),
(3111,	847,	'_edit_lock',	'1451410658:1'),
(3113,	847,	'_oembed_a8e701ad140f416c73b8395dcffa4b92',	'{{unknown}}'),
(3114,	847,	'_oembed_5d6d018e874412a24ecb825d004874dd',	'{{unknown}}'),
(3115,	849,	'_edit_last',	'1'),
(3119,	849,	'_oembed_ba5a23717b73ecb29e1152821d9ec730',	'{{unknown}}'),
(3118,	849,	'_edit_lock',	'1451410782:1'),
(3120,	849,	'_oembed_c0ae58e61c6d650a4ac5d97e639c1084',	'{{unknown}}'),
(3121,	849,	'_oembed_d6d642c7037a093f90762cbf2b2c6748',	'{{unknown}}'),
(3122,	851,	'_edit_last',	'1'),
(3126,	851,	'_oembed_ad88b8f744c2baf1fb3490516edea1fd',	'{{unknown}}'),
(3125,	851,	'_edit_lock',	'1451410904:1'),
(3127,	851,	'_oembed_94aaa2aa915e2c3474f7715eb3820360',	'{{unknown}}'),
(3128,	851,	'_oembed_37a873889aba1b380417b98670a9b5df',	'{{unknown}}'),
(3129,	853,	'_edit_last',	'1'),
(3133,	853,	'_oembed_9f04e9af87582dff53e5663dcd3e4d84',	'{{unknown}}'),
(3136,	855,	'_edit_last',	'1'),
(3132,	853,	'_edit_lock',	'1451411028:1'),
(3134,	853,	'_oembed_73e4b4dc60e43fcff9669326983295f9',	'{{unknown}}'),
(3135,	853,	'_oembed_bb8ad710f165ff65c1b3362457f011b7',	'{{unknown}}'),
(3140,	855,	'_oembed_d7a986703c8c35e358d08b91bcef1215',	'{{unknown}}'),
(3139,	855,	'_edit_lock',	'1451411150:1'),
(3141,	855,	'_oembed_c0f00c1f767fa2aa17309183b5d55e0e',	'{{unknown}}'),
(3142,	855,	'_oembed_b1dac533937cf753a926eb381f73d485',	'{{unknown}}'),
(3143,	857,	'_edit_last',	'1'),
(3147,	857,	'_oembed_2229641751a9e8670954bf05991a075d',	'{{unknown}}'),
(3146,	857,	'_edit_lock',	'1451411273:1'),
(3148,	857,	'_oembed_14bb60211105aef673673656e1e31a62',	'{{unknown}}'),
(3149,	859,	'_edit_last',	'1'),
(3153,	859,	'_oembed_5522eff54c978fd9657a363f4ac681c6',	'{{unknown}}'),
(3152,	859,	'_edit_lock',	'1451411396:1'),
(3154,	859,	'_oembed_5405376bdd4baca87c84f90106437dba',	'{{unknown}}'),
(3155,	859,	'_oembed_94dc2cedf8cb866987de24bfd5456c62',	'{{unknown}}'),
(3156,	861,	'_edit_last',	'1'),
(3160,	861,	'_oembed_f4ef7bb7c47ad044bc90e51e8160b70e',	'{{unknown}}'),
(3159,	861,	'_edit_lock',	'1451411519:1'),
(3161,	861,	'_oembed_01e52e9e3c070fdeaddd203e63b54b54',	'{{unknown}}'),
(3162,	861,	'_oembed_e775012ff8b9aa7b2902aabc5f57876e',	'{{unknown}}'),
(3163,	863,	'_edit_last',	'1'),
(3167,	863,	'_oembed_cc4c1869725e5636a230a325efec1591',	'{{unknown}}'),
(3170,	865,	'_edit_last',	'1'),
(3166,	863,	'_edit_lock',	'1451411642:1'),
(3168,	863,	'_oembed_0babee7027c947921af42ad0599970ba',	'{{unknown}}'),
(3169,	863,	'_oembed_6add049236196a59f7c66e3c4c44da10',	'{{unknown}}'),
(3174,	865,	'_oembed_271ef23c1b63d8bed2e0ee42e10b4a98',	'{{unknown}}'),
(3177,	867,	'_edit_last',	'1'),
(3173,	865,	'_edit_lock',	'1451411768:1'),
(3175,	865,	'_oembed_8fd29a9c6631be181082709bb7daafc3',	'{{unknown}}'),
(3176,	865,	'_oembed_fcc5d73b35c3ba33d4fca2c569a0f532',	'{{unknown}}'),
(3181,	867,	'_oembed_eb36fa350f2baed09c9f3ed0d5e53f28',	'{{unknown}}'),
(3180,	867,	'_edit_lock',	'1451411893:1'),
(3182,	867,	'_oembed_2764c2ace2305e744c819cd1f9456c0a',	'{{unknown}}'),
(3183,	867,	'_oembed_a42d9d6d41482de0c574d1d16ff6f8fe',	'{{unknown}}'),
(3184,	869,	'_edit_last',	'1'),
(3188,	869,	'_oembed_7b1e3c6ff273ad1517626f6a3d2582e7',	'{{unknown}}'),
(3187,	869,	'_edit_lock',	'1451412017:1'),
(3189,	869,	'_oembed_5d465026264850787d46bccf931a50b1',	'{{unknown}}'),
(3190,	869,	'_oembed_e3a479c3f6c7af69da9d9730fb2b9696',	'{{unknown}}'),
(3191,	871,	'_edit_last',	'1'),
(3195,	871,	'_oembed_4aa3f25896c3851e1f97078038c61253',	'{{unknown}}'),
(3198,	873,	'_edit_last',	'1'),
(3194,	871,	'_edit_lock',	'1451412140:1'),
(3196,	871,	'_oembed_01d90606737965fd5bd286917f2b3806',	'{{unknown}}'),
(3197,	871,	'_oembed_7e28ee6b93d034fa5626e6995a567c4d',	'{{unknown}}'),
(3202,	873,	'_oembed_0a70be9a87d886ee452436a400ce4566',	'{{unknown}}'),
(3201,	873,	'_edit_lock',	'1451412263:1'),
(3203,	873,	'_oembed_223da3c18ccb4f7aa0bdfbdb53d55306',	'{{unknown}}'),
(3204,	873,	'_oembed_2ecb527bc388f7a29ab72700450b56f2',	'{{unknown}}'),
(3205,	875,	'_edit_last',	'1'),
(3209,	875,	'_oembed_36c4c5f181e1e8e69a894f415e5d872b',	'{{unknown}}'),
(3208,	875,	'_edit_lock',	'1451412386:1'),
(3210,	875,	'_oembed_be29c815097c6a0710f3e55f229c0efc',	'{{unknown}}'),
(3211,	875,	'_oembed_525e77b8d2f242ad86cbe79dfa1ce69a',	'{{unknown}}'),
(3212,	877,	'_edit_last',	'1'),
(3216,	877,	'_oembed_ba0f188a01c6bf0d733cc4c79c2457c0',	'{{unknown}}'),
(3219,	879,	'_edit_last',	'1'),
(3215,	877,	'_edit_lock',	'1451412510:1'),
(3217,	877,	'_oembed_57df0efee07df8d33cba8e177fca0ef9',	'{{unknown}}'),
(3218,	877,	'_oembed_3e9c4401ff9308de3bc21003937be228',	'{{unknown}}'),
(3223,	879,	'_oembed_53d0ebea1da4b86af1cdf626da371e77',	'{{unknown}}'),
(3222,	879,	'_edit_lock',	'1451412633:1'),
(3224,	879,	'_oembed_9422b5c7c734042be23128a21c69084d',	'{{unknown}}'),
(3225,	879,	'_oembed_9199ff5de22ffe5b01cb09d7cc57588b',	'{{unknown}}'),
(3226,	881,	'_edit_last',	'1'),
(3230,	881,	'_oembed_38875ee912a22c911ba71c8fdeb3025a',	'{{unknown}}'),
(3229,	881,	'_edit_lock',	'1451412756:1'),
(3231,	881,	'_oembed_461f843c12a1d579ad9dc20d1c8e2079',	'{{unknown}}'),
(3232,	881,	'_oembed_554f60a64d272a02cd9aabc805d3e1d1',	'{{unknown}}'),
(3233,	883,	'_edit_last',	'1'),
(3237,	883,	'_oembed_a1a1f55ff5388e5d8cc87e1c8a9d2677',	'{{unknown}}'),
(3236,	883,	'_edit_lock',	'1451412879:1'),
(3238,	883,	'_oembed_18fdab73e6e4f677158c681d77a4b95b',	'{{unknown}}'),
(3239,	883,	'_oembed_4760718a7bea63a1ebfcfa003396829d',	'{{unknown}}'),
(3240,	885,	'_edit_last',	'1'),
(3244,	885,	'_oembed_bdd8a7f040e7ffe1c4a84a341dd419eb',	'{{unknown}}'),
(3243,	885,	'_edit_lock',	'1451413002:1'),
(3245,	885,	'_oembed_5cd21746184819d4ff47fd34fc164f54',	'{{unknown}}'),
(3246,	885,	'_oembed_7a6199597da25ef032f10216c91bd619',	'{{unknown}}'),
(3247,	887,	'_edit_last',	'1'),
(3251,	887,	'_oembed_2b65d8d83e73e4f6bfbfa50957d935e5',	'{{unknown}}'),
(3250,	887,	'_edit_lock',	'1451413125:1'),
(3252,	887,	'_oembed_744209a2ae904825569634312e102ce9',	'{{unknown}}'),
(3253,	887,	'_oembed_bed1f31a6d96a5be7017803a7caed412',	'{{unknown}}'),
(3254,	889,	'_edit_last',	'1'),
(3258,	889,	'_oembed_eaab1c7ee231dab08f9f40d3894f411e',	'{{unknown}}'),
(3260,	889,	'_oembed_ffa5bbfffc0984d5d5625eb5af9bc6ae',	'{{unknown}}'),
(3257,	889,	'_edit_lock',	'1451413248:1'),
(3259,	889,	'_oembed_cc73e0ba58a4413265e2e9a6148755f1',	'{{unknown}}'),
(3261,	891,	'_edit_last',	'1'),
(3265,	891,	'_oembed_8237740defdacbcbdded79a2f1d44dd3',	'{{unknown}}'),
(3267,	891,	'_oembed_64579a0f2f526d5490ad16cef7269ca4',	'{{unknown}}'),
(3264,	891,	'_edit_lock',	'1451413371:1'),
(3266,	891,	'_oembed_e5cd2f227b28527415641f2fb58fd9c7',	'{{unknown}}'),
(3268,	893,	'_edit_last',	'1'),
(3272,	893,	'_oembed_33a5498f7d795847cff47ae84be8dbac',	'{{unknown}}'),
(3275,	895,	'_edit_last',	'1'),
(3271,	893,	'_edit_lock',	'1451413494:1'),
(3273,	893,	'_oembed_0df2ada92c00e6956e019d2c45b6d15e',	'{{unknown}}'),
(3274,	893,	'_oembed_81f182846affa1b6f76e3234b98b1b87',	'{{unknown}}'),
(3279,	895,	'_oembed_4a0c3e3fd6ff43a2d687ee1fab0ebd23',	'{{unknown}}'),
(3281,	895,	'_oembed_a3640ba2c530449afddc42b8a407c528',	'{{unknown}}'),
(3278,	895,	'_edit_lock',	'1451413617:1'),
(3280,	895,	'_oembed_153ba44d18037162a7fa8d50814d093c',	'{{unknown}}'),
(3282,	897,	'_edit_last',	'1'),
(3286,	897,	'_oembed_38de92ffb100f72d1e926c2840ac48b7',	'{{unknown}}'),
(3285,	897,	'_edit_lock',	'1451413741:1'),
(3287,	897,	'_oembed_29a5f7433ecc48f79e703220dbce6f58',	'{{unknown}}'),
(3288,	897,	'_oembed_f358221a47753eda97f2dadf372fdff0',	'{{unknown}}'),
(3289,	899,	'_edit_last',	'1'),
(3293,	899,	'_oembed_acbba797be35effd3a382401c2970895',	'{{unknown}}'),
(3292,	899,	'_edit_lock',	'1451413863:1'),
(3294,	899,	'_oembed_9154d0751f40aa18c8bef4b5af12f6a0',	'{{unknown}}'),
(3295,	899,	'_oembed_e5d12c93c57cc0378d03325a5008ab43',	'{{unknown}}'),
(3296,	901,	'_edit_last',	'1'),
(3300,	901,	'_oembed_959d7b78cb29b358e41805b0e03d7705',	'{{unknown}}'),
(3299,	901,	'_edit_lock',	'1451413986:1'),
(3301,	901,	'_oembed_593528418ce633bb53b76665db0e8323',	'{{unknown}}'),
(3302,	901,	'_oembed_7e8a616f1acbf4c011abe43830e01df0',	'{{unknown}}'),
(3303,	903,	'_edit_last',	'1'),
(3307,	903,	'_oembed_b23362b223d2d8ef74d9a081c8653077',	'{{unknown}}'),
(3308,	903,	'_oembed_bd163925d31b59f14428ea9e27a399f6',	'{{unknown}}'),
(3306,	903,	'_edit_lock',	'1451414170:1'),
(3309,	903,	'_oembed_21fa5c260e1e16a749ce6ff20060e243',	'{{unknown}}'),
(3310,	905,	'_edit_last',	'1'),
(3314,	905,	'_oembed_6efd9461f9f8a609f7331048f038867e',	'{{unknown}}'),
(3317,	907,	'_edit_last',	'1'),
(3313,	905,	'_edit_lock',	'1451414293:1'),
(3315,	905,	'_oembed_500eb5875c4f4c6a1cdf1aa12f20c78e',	'{{unknown}}'),
(3316,	905,	'_oembed_c233421dff10b5034ec42294f1b968dd',	'{{unknown}}'),
(3321,	907,	'_oembed_678e4eda45983266636db45f3f9a4acd',	'{{unknown}}'),
(3324,	909,	'_edit_last',	'1'),
(3320,	907,	'_edit_lock',	'1451414416:1'),
(3322,	907,	'_oembed_27ed718034306150dc713e2b891aba6a',	'{{unknown}}'),
(3323,	907,	'_oembed_6ce24c0a658afbc109fde120b9ca308c',	'{{unknown}}'),
(3328,	909,	'_oembed_2d00a0a76e98ea72e29ea9f537921c8a',	'{{unknown}}'),
(3327,	909,	'_edit_lock',	'1451414539:1'),
(3329,	909,	'_oembed_4e75aaaca22c767767c90396397d2316',	'{{unknown}}'),
(3330,	909,	'_oembed_d0a1580bd03ac17931e96ea219a7a0c8',	'{{unknown}}'),
(3331,	911,	'_edit_last',	'1'),
(3335,	911,	'_oembed_1a38cc7bd577a209afb9091b817e59e0',	'{{unknown}}'),
(3338,	913,	'_edit_last',	'1'),
(3334,	911,	'_edit_lock',	'1451414665:1'),
(3336,	911,	'_oembed_b869d7e6b827df4d5ed87cbc87413e87',	'{{unknown}}'),
(3337,	911,	'_oembed_a8459c8e7c8fe64c9416ac12406cf38e',	'{{unknown}}'),
(3342,	913,	'_oembed_cee4ad6165e30959ad4adae03e98b052',	'{{unknown}}'),
(3345,	915,	'_edit_last',	'1'),
(3341,	913,	'_edit_lock',	'1451414788:1'),
(3343,	913,	'_oembed_1b4ef3a99ccf5fb4846300e59e6f9df5',	'{{unknown}}'),
(3344,	913,	'_oembed_0189266b18dccb1b039f6cb7b6564eeb',	'{{unknown}}'),
(3349,	915,	'_oembed_34afb0494627547c4320acc43caa7925',	'{{unknown}}'),
(3348,	915,	'_edit_lock',	'1451414911:1'),
(3350,	915,	'_oembed_66aa9f23ae7fcc75b403c163b1ad9a55',	'{{unknown}}'),
(3351,	915,	'_oembed_b1f4c613f98173e54161eb807940df29',	'{{unknown}}'),
(3352,	917,	'_edit_last',	'1'),
(3356,	917,	'_oembed_9fd5159c56ed0940dd27175e3cf9eb2c',	'{{unknown}}'),
(3359,	919,	'_edit_last',	'1'),
(3355,	917,	'_edit_lock',	'1451415034:1'),
(3357,	917,	'_oembed_274461de629840ef5972ab4fa4684903',	'{{unknown}}'),
(3358,	917,	'_oembed_fa454f041eb6d7baf547fb3e337055ce',	'{{unknown}}'),
(3363,	919,	'_oembed_1991050237654a98259c9450d7d0adb6',	'{{unknown}}'),
(3366,	921,	'_edit_last',	'1'),
(3362,	919,	'_edit_lock',	'1451415157:1'),
(3364,	919,	'_oembed_4ab42aad340d5f8eb8227b0715ceaa68',	'{{unknown}}'),
(3365,	919,	'_oembed_dc69ee505cd733fa92b4b292d2bc038f',	'{{unknown}}'),
(3370,	921,	'_oembed_efce8f1117fcfa5a0f40a52c09ddb915',	'{{unknown}}'),
(3373,	923,	'_edit_last',	'1'),
(3369,	921,	'_edit_lock',	'1451415627:1'),
(3371,	921,	'_oembed_0d3096282694229c7cdf4a4b1f31df22',	'{{unknown}}'),
(3372,	921,	'_oembed_371be1187f85e08596a7bde2f5178879',	'{{unknown}}'),
(3377,	923,	'_oembed_c285811224fd14dccf2bd6c717e3929f',	'{{unknown}}'),
(3376,	923,	'_edit_lock',	'1451415752:1'),
(3378,	923,	'_oembed_e4419f711c0d6abb257f57a16c55f7b3',	'{{unknown}}'),
(3379,	923,	'_oembed_f358a20020398387a3b199de2a3ca00f',	'{{unknown}}'),
(3380,	925,	'_edit_last',	'1'),
(3384,	925,	'_oembed_169a9ff1b116a2c381a56a38c6d6e503',	'{{unknown}}'),
(3383,	925,	'_edit_lock',	'1451415875:1'),
(3385,	925,	'_oembed_772edb96fa9121f018dab122216bd458',	'{{unknown}}'),
(3386,	925,	'_oembed_f18f5d9e8bfc7d72536d65339073e48a',	'{{unknown}}'),
(3387,	927,	'_edit_last',	'1'),
(3391,	927,	'_oembed_db7fca3b8c7f45fa2b8bc2b1599702cd',	'{{unknown}}'),
(3394,	929,	'_edit_last',	'1'),
(3390,	927,	'_edit_lock',	'1451415998:1'),
(3392,	927,	'_oembed_3b35432ebcccefb440f61664466509c2',	'{{unknown}}'),
(3393,	927,	'_oembed_b9fb04f5be8455438f05218bfdedd433',	'{{unknown}}'),
(3398,	929,	'_oembed_126201bdd278f4ef556af819053816ee',	'{{unknown}}'),
(3397,	929,	'_edit_lock',	'1451416122:1'),
(3399,	929,	'_oembed_b7dab36e7c18024f1e144a2fc5e7c6c3',	'{{unknown}}'),
(3400,	929,	'_oembed_41ab9f758645c3831f79c0099a4d7a82',	'{{unknown}}'),
(3401,	931,	'_edit_last',	'1'),
(3405,	931,	'_oembed_faeb19ee963352a4f74158612c848a92',	'{{unknown}}'),
(3404,	931,	'_edit_lock',	'1451416245:1'),
(3406,	931,	'_oembed_2313f677caa264a9d38c97cc83482709',	'{{unknown}}'),
(3407,	931,	'_oembed_5ad4e734f2e9830447a0f66288ebdcd0',	'{{unknown}}'),
(3408,	933,	'_edit_last',	'1'),
(3412,	933,	'_oembed_b319705f3fe617e0d3796fd390b7c114',	'{{unknown}}'),
(3411,	933,	'_edit_lock',	'1451416368:1'),
(3413,	933,	'_oembed_918da336d7ac08e9d5befe7987a28427',	'{{unknown}}'),
(3414,	933,	'_oembed_e2c8e411819f1dd7000e2eee511a8e34',	'{{unknown}}'),
(3415,	935,	'_edit_last',	'1'),
(3419,	935,	'_oembed_445478083c7108220022445fc10664f6',	'{{unknown}}'),
(3418,	935,	'_edit_lock',	'1451416493:1'),
(3420,	935,	'_oembed_00ed6870183e65d87d469515d51899db',	'{{unknown}}'),
(3421,	935,	'_oembed_127a26d8247e2f085a81dad0d9107426',	'{{unknown}}'),
(3422,	937,	'_edit_last',	'1'),
(3426,	937,	'_oembed_7a061b021e336c1865e46f67607e2513',	'{{unknown}}'),
(3425,	937,	'_edit_lock',	'1451416617:1'),
(3427,	937,	'_oembed_f0791c4d0679e2a16489dacf252479be',	'{{unknown}}'),
(3428,	937,	'_oembed_d81c2b6e1575b211bc008e5f17583dcb',	'{{unknown}}'),
(3429,	939,	'_edit_last',	'1'),
(3433,	939,	'_oembed_32b38a318a3b768fd590fb7b6b79ebf9',	'{{unknown}}'),
(3435,	939,	'_oembed_6627683d48ddd769e9d5e2d46f323c04',	'{{unknown}}'),
(3432,	939,	'_edit_lock',	'1451416740:1'),
(3434,	939,	'_oembed_4d4ed8a63fee1df3f16cfa97abb686a6',	'{{unknown}}'),
(3436,	941,	'_edit_last',	'1'),
(3440,	941,	'_oembed_96d728d782c88f38cf6304d6f0797184',	'{{unknown}}'),
(3439,	941,	'_edit_lock',	'1451416863:1'),
(3441,	941,	'_oembed_e0cf5f12caab73179f0010c4c01a5be3',	'{{unknown}}'),
(3442,	941,	'_oembed_e01637fad546d2f4731b4cd68ff952cb',	'{{unknown}}'),
(3443,	943,	'_edit_last',	'1'),
(3447,	943,	'_oembed_a76b44d9ad94f198069632e338493cbd',	'{{unknown}}'),
(3450,	945,	'_edit_last',	'1'),
(3446,	943,	'_edit_lock',	'1451416985:1'),
(3448,	943,	'_oembed_b8e7c78de8114682d4b59e758e1b4f21',	'{{unknown}}'),
(3449,	943,	'_oembed_2be7d3db0936565b91227e973f81aca5',	'{{unknown}}'),
(3457,	947,	'_edit_last',	'1'),
(3453,	945,	'_edit_lock',	'1451417735:1'),
(3454,	945,	'_oembed_485f6d6cb7c05efb38236c0aedee5234',	'{{unknown}}'),
(3455,	945,	'_oembed_af60fec929f14aa3ba20e3dd450cefbf',	'{{unknown}}'),
(3456,	945,	'_oembed_89ff09ca70bdb9aabcc6aa9224a3e748',	'{{unknown}}'),
(3461,	947,	'_oembed_4c3ff14216a3ffb5ab08d9cdfc31c5be',	'{{unknown}}'),
(3460,	947,	'_edit_lock',	'1451417858:1'),
(3462,	947,	'_oembed_d759ae8dd3d10209bb04113fb84885fb',	'{{unknown}}'),
(3463,	947,	'_oembed_5c0850f35f415fb85f2957e17da3a389',	'{{unknown}}'),
(3464,	949,	'_edit_last',	'1'),
(3468,	949,	'_oembed_5da1faaa96b30fff8ed2d164170b8a51',	'{{unknown}}'),
(3469,	949,	'_oembed_b76631930c3bda0370e78de0b48e1429',	'{{unknown}}'),
(3467,	949,	'_edit_lock',	'1451417983:1'),
(3470,	949,	'_oembed_69e27123d2fec53d1b8e937647a65c42',	'{{unknown}}'),
(3471,	951,	'_edit_last',	'1'),
(3475,	951,	'_oembed_f5474004e6bf84eb332bdb7946c319b6',	'{{unknown}}'),
(3478,	953,	'_edit_last',	'1'),
(3474,	951,	'_edit_lock',	'1451418106:1'),
(3476,	951,	'_oembed_6469adf9f8120b63f730406abf08e9f0',	'{{unknown}}'),
(3477,	951,	'_oembed_1808fa7caba4b4024d4641da544ad920',	'{{unknown}}'),
(3482,	953,	'_oembed_158993e48c19006c399bddc3a83804b6',	'{{unknown}}'),
(3481,	953,	'_edit_lock',	'1451418230:1'),
(3483,	953,	'_oembed_41c827c016f971683fbcde64ec9f885f',	'{{unknown}}'),
(3484,	953,	'_oembed_345646705ffebdd052e158ece161f5e3',	'{{unknown}}'),
(3485,	955,	'_edit_last',	'1'),
(3489,	955,	'_oembed_43f5066898a239d3736db2f5facc08de',	'{{unknown}}'),
(3488,	955,	'_edit_lock',	'1451418353:1'),
(3490,	955,	'_oembed_edbcb7b861e45e8ab55b6dd0c507e773',	'{{unknown}}'),
(3491,	955,	'_oembed_81f280e2d7d36bb4d428290607bdd759',	'{{unknown}}'),
(3492,	957,	'_edit_last',	'1'),
(3496,	957,	'_oembed_80898eac967f4c9b2f3b100a4bfeb379',	'{{unknown}}'),
(3495,	957,	'_edit_lock',	'1451424941:1'),
(3497,	957,	'_oembed_d44f39f7ed1f1736eefba342d0004cc3',	'{{unknown}}'),
(3498,	957,	'_oembed_30b3e26b2fd9f082e307b9f0ab85ef56',	'{{unknown}}'),
(3499,	959,	'_edit_last',	'1'),
(3503,	959,	'_oembed_b7432434e0624fed5519e8ffa2f508b9',	'{{unknown}}'),
(3504,	959,	'_oembed_74ffabf39d5edc4b386f42669787f195',	'{{unknown}}'),
(3502,	959,	'_edit_lock',	'1451425064:1'),
(3505,	959,	'_oembed_7c1b42ca8d57f4ba63912a70b29aa2bf',	'{{unknown}}'),
(3506,	961,	'_edit_last',	'1'),
(3510,	961,	'_oembed_3936328e8abb49e4f926d181ba413755',	'{{unknown}}'),
(3512,	961,	'_oembed_dfcedee878b5d60213987d5dd9031d47',	'{{unknown}}'),
(3509,	961,	'_edit_lock',	'1451425188:1'),
(3511,	961,	'_oembed_e193db357e20bc504e12fce150c005c5',	'{{unknown}}'),
(3513,	963,	'_edit_last',	'1'),
(3517,	963,	'_oembed_a034f2029f55174f24b0b1b5324499cd',	'{{unknown}}'),
(3518,	963,	'_oembed_2bf231bf86ce23f8f1bf6c753c9fc4c3',	'{{unknown}}'),
(3516,	963,	'_edit_lock',	'1451425312:1'),
(3519,	963,	'_oembed_ea663d48ee5d5dbb5c1af4c2b60e06e4',	'{{unknown}}'),
(3520,	965,	'_edit_last',	'1'),
(3524,	965,	'_oembed_a2791c1dc4d8911ca25d4a65d4f6e780',	'{{unknown}}'),
(3526,	965,	'_oembed_2e7d7575d8f753febf83b72f87c5de91',	'{{unknown}}'),
(3523,	965,	'_edit_lock',	'1451425435:1'),
(3525,	965,	'_oembed_374061815fdf9a41eb29ecc4ac0857b5',	'{{unknown}}'),
(3527,	967,	'_edit_last',	'1'),
(3531,	967,	'_oembed_126920e379723412933ee485beb944f2',	'{{unknown}}'),
(3534,	969,	'_edit_last',	'1'),
(3530,	967,	'_edit_lock',	'1451425559:1'),
(3532,	967,	'_oembed_bd7c37294645b6c6a52855fb7dde0d77',	'{{unknown}}'),
(3533,	967,	'_oembed_9387b1f311c3dfdbefc636ad6350d164',	'{{unknown}}'),
(3538,	969,	'_oembed_9aaffb0e20e59af678c430856a8cedf1',	'{{unknown}}'),
(3537,	969,	'_edit_lock',	'1451425682:1'),
(3539,	969,	'_oembed_97e2a1fee4550cd0b6e5b63a26524c9d',	'{{unknown}}'),
(3540,	969,	'_oembed_ac8c065cc1cf13f09b12ad981338b35f',	'{{unknown}}'),
(3541,	971,	'_edit_last',	'1'),
(3545,	971,	'_oembed_b19cbaef105f7b5b839651a5f64446be',	'{{unknown}}'),
(3548,	973,	'_edit_last',	'1'),
(3544,	971,	'_edit_lock',	'1451425805:1'),
(3546,	971,	'_oembed_a3a05dc1ae3c834b76ce2861a68f7786',	'{{unknown}}'),
(3547,	971,	'_oembed_4aa367bbe63e2439103f79db36477a94',	'{{unknown}}'),
(3552,	973,	'_oembed_d2cab2375d23b3e819bc2924036e6cc5',	'{{unknown}}'),
(3551,	973,	'_edit_lock',	'1451425928:1'),
(3553,	973,	'_oembed_937ed7013c61383fe70f28b73d248ef7',	'{{unknown}}'),
(3554,	973,	'_oembed_f4b2a27998ad38daf8c37f9835f28a84',	'{{unknown}}'),
(3555,	975,	'_edit_last',	'1'),
(3559,	975,	'_oembed_e56e82e24ecc1eeb86becb4d4266328e',	'{{unknown}}'),
(3558,	975,	'_edit_lock',	'1451426052:1'),
(3560,	975,	'_oembed_495391fe3f93951715a71d98624a8ece',	'{{unknown}}'),
(3561,	975,	'_oembed_6ddbd1a17873ce5e0cfdecf512d630cd',	'{{unknown}}'),
(3562,	977,	'_edit_last',	'1'),
(3566,	977,	'_oembed_84bcdcaa8b9067675c4f9717da57c116',	'{{unknown}}'),
(3565,	977,	'_edit_lock',	'1451426175:1'),
(3567,	977,	'_oembed_3de8477196aa87fb4bd451be40179bd6',	'{{unknown}}'),
(3568,	977,	'_oembed_e0b35950a8fe694fa1702e53ef5f5f1a',	'{{unknown}}'),
(3569,	979,	'_edit_last',	'1'),
(3573,	979,	'_oembed_47a888e71340f8b34d582cce0425e4e6',	'{{unknown}}'),
(3572,	979,	'_edit_lock',	'1451426298:1'),
(3574,	979,	'_oembed_d43da6bc4185e665d112248ad9f50d44',	'{{unknown}}'),
(3575,	979,	'_oembed_94cf58c6fad4cd78cc0443beaf741625',	'{{unknown}}'),
(3576,	981,	'_edit_last',	'1'),
(3580,	981,	'_oembed_5c6c503b4ee43c1ab014c72a14d15c98',	'{{unknown}}'),
(3583,	983,	'_edit_last',	'1'),
(3579,	981,	'_edit_lock',	'1451426422:1'),
(3581,	981,	'_oembed_a0c9837bbfdec72127127fc78ce3e323',	'{{unknown}}'),
(3582,	981,	'_oembed_58f95e6b8fcd8a6ace5c4a4022f5058e',	'{{unknown}}'),
(3587,	983,	'_oembed_0032958d726d12b7a82ea070f534646d',	'{{unknown}}'),
(3586,	983,	'_edit_lock',	'1451426545:1'),
(3588,	983,	'_oembed_ea36ae4c870c8aa5aafbbaefa8d005d6',	'{{unknown}}'),
(3589,	983,	'_oembed_0789f5eabb5459c35d8bb5876cc63edb',	'{{unknown}}'),
(3590,	985,	'_edit_last',	'1'),
(3594,	985,	'_oembed_5d17b75d0573ad1f25febff4861fc829',	'{{unknown}}'),
(3593,	985,	'_edit_lock',	'1451426667:1'),
(3595,	985,	'_oembed_a5442448e41250e715ab33342d9919ac',	'{{unknown}}'),
(3596,	985,	'_oembed_cff66ea50df5bd0b29248a871f5453e4',	'{{unknown}}'),
(3597,	987,	'_edit_last',	'1'),
(3601,	987,	'_oembed_9bd5e82de378708861263276b3518a10',	'{{unknown}}'),
(3600,	987,	'_edit_lock',	'1451426790:1'),
(3602,	987,	'_oembed_9c881dc56719c85459da092359cc8675',	'{{unknown}}'),
(3603,	987,	'_oembed_585bea9524c4dcd9bf0744098d4234ad',	'{{unknown}}'),
(3604,	989,	'_edit_last',	'1'),
(3608,	989,	'_oembed_0a6b0635e23f435f050bcd618110349f',	'{{unknown}}'),
(3607,	989,	'_edit_lock',	'1451426914:1'),
(3609,	989,	'_oembed_7eeef1f38abb1b09e582fc8b8a579b78',	'{{unknown}}'),
(3610,	989,	'_oembed_e72ef733f0ee74f1554f62598c0db1c2',	'{{unknown}}'),
(3611,	991,	'_edit_last',	'1'),
(3615,	991,	'_oembed_7b941f777a9f4f33cd99b6edd107d0e4',	'{{unknown}}'),
(3614,	991,	'_edit_lock',	'1451427036:1'),
(3616,	991,	'_oembed_27d92010d7ba09c1e784ff70be08f9c7',	'{{unknown}}'),
(3617,	991,	'_oembed_c1ae4f38ca250a6e4d5e8e537299d5a7',	'{{unknown}}'),
(3618,	993,	'_edit_last',	'1'),
(3622,	993,	'_oembed_0eef589f2e17bd6c07dd04cedcbba351',	'{{unknown}}'),
(3623,	993,	'_oembed_786ac6ff91863454b27f2f60e116aef7',	'{{unknown}}'),
(3621,	993,	'_edit_lock',	'1451427160:1'),
(3624,	993,	'_oembed_d54be8f4c877033dfde2a70c08fe6a47',	'{{unknown}}'),
(3625,	995,	'_edit_last',	'1'),
(3629,	995,	'_oembed_2ea932b9d6faa32b90b505aef30b1a11',	'{{unknown}}'),
(3628,	995,	'_edit_lock',	'1451427283:1'),
(3630,	995,	'_oembed_5a2f29dfb3bfa97239b104a4c8661410',	'{{unknown}}'),
(3631,	995,	'_oembed_5caddec2c4478d7013391b71063535f5',	'{{unknown}}'),
(3632,	997,	'_edit_last',	'1'),
(3636,	997,	'_oembed_402f072881d8cbb4bbe82b49f8ed32c0',	'{{unknown}}'),
(3635,	997,	'_edit_lock',	'1451427406:1'),
(3637,	997,	'_oembed_3c08ec2a61cf282c15e0b7e2fc4838e8',	'{{unknown}}'),
(3638,	997,	'_oembed_82d12408f0b94d0c7470b7635ff9648d',	'{{unknown}}'),
(3639,	999,	'_edit_last',	'1'),
(3643,	999,	'_oembed_4ec7d0ad7e6c6a6c177089a0b3036eae',	'{{unknown}}'),
(3646,	1001,	'_edit_last',	'1'),
(3642,	999,	'_edit_lock',	'1451427529:1'),
(3644,	999,	'_oembed_ba96acef0ade6c6e4f7d9f6d60bf41b4',	'{{unknown}}'),
(3645,	999,	'_oembed_3a7e82f3c60e20467408bab4e84ef29d',	'{{unknown}}'),
(3650,	1001,	'_oembed_875e42cd5ebfcaedcb07c8866973243b',	'{{unknown}}'),
(3649,	1001,	'_edit_lock',	'1451427652:1'),
(3651,	1001,	'_oembed_66dae9aec5b2b427a1c0383ab3da0353',	'{{unknown}}'),
(3652,	1001,	'_oembed_7f04821098e9b17b573da72bd931922d',	'{{unknown}}'),
(3653,	1003,	'_edit_last',	'1'),
(3657,	1003,	'_oembed_eea4cf8c1d46c6e74801a33bbf1592f9',	'{{unknown}}'),
(3656,	1003,	'_edit_lock',	'1451427776:1'),
(3658,	1003,	'_oembed_02c96b881746ac509250475c99bbf38d',	'{{unknown}}'),
(3659,	1003,	'_oembed_17d98fcec2aab951cda31738d3d23148',	'{{unknown}}'),
(3660,	1005,	'_edit_last',	'1'),
(3664,	1005,	'_oembed_c87b860c2c6c8c950ac5d3e33f060ea6',	'{{unknown}}'),
(3663,	1005,	'_edit_lock',	'1451427899:1'),
(3665,	1005,	'_oembed_cb52de3d6b84d94f84a465436d75a640',	'{{unknown}}'),
(3666,	1005,	'_oembed_4476db87141f417cfe58953896795880',	'{{unknown}}'),
(3667,	1007,	'_edit_last',	'1'),
(3671,	1007,	'_oembed_c0cb51a748ec6361099d2f0393128590',	'{{unknown}}'),
(3670,	1007,	'_edit_lock',	'1451428023:1'),
(3672,	1007,	'_oembed_60abfb27e1145fa7792d7f3304ba9a54',	'{{unknown}}'),
(3673,	1007,	'_oembed_551ed6ea68541f01a3472460866f79af',	'{{unknown}}'),
(3674,	1009,	'_edit_last',	'1'),
(3678,	1009,	'_oembed_336f4fa25d0fb18c6fd4849e856ac61d',	'{{unknown}}'),
(3677,	1009,	'_edit_lock',	'1451428146:1'),
(3679,	1009,	'_oembed_ea01a87ac93f25acd27b5f85972436fc',	'{{unknown}}'),
(3680,	1009,	'_oembed_500de1c943d7098136522162037c4cd4',	'{{unknown}}'),
(3681,	1011,	'_edit_last',	'1'),
(3685,	1011,	'_oembed_18e7e42755505bc033a4463462054245',	'{{unknown}}'),
(3687,	1011,	'_oembed_71d97f1bb78013596b2d7f386d4584b6',	'{{unknown}}'),
(3684,	1011,	'_edit_lock',	'1451428269:1'),
(3686,	1011,	'_oembed_a6c4df2599f137977385c81070ebaba5',	'{{unknown}}'),
(3688,	1013,	'_edit_last',	'1'),
(3692,	1013,	'_oembed_7cb6793c00ef2c4405b0908c674b00c3',	'{{unknown}}'),
(3691,	1013,	'_edit_lock',	'1451428392:1'),
(3693,	1013,	'_oembed_6c61f35a910b006d2ce909df296d2aa2',	'{{unknown}}'),
(3694,	1013,	'_oembed_db2e03c9d804ebe77b8a49d7551872f7',	'{{unknown}}'),
(3695,	1015,	'_edit_last',	'1'),
(3699,	1015,	'_oembed_9ef835736a8e4efab1a6aeba19221af9',	'{{unknown}}'),
(3698,	1015,	'_edit_lock',	'1451428515:1'),
(3700,	1015,	'_oembed_ee784642f98fe7c42df4237506cf2b03',	'{{unknown}}'),
(3701,	1015,	'_oembed_ea84d134f4f3b378e7a1542951107ab9',	'{{unknown}}'),
(3702,	1017,	'_edit_last',	'1'),
(3706,	1017,	'_oembed_837113f1151e3b7eb2a06d207799ef69',	'{{unknown}}'),
(3707,	1017,	'_oembed_137f69d28fb801189799fbe4ec2a46f4',	'{{unknown}}'),
(3705,	1017,	'_edit_lock',	'1451428639:1'),
(3708,	1017,	'_oembed_01d09f8354ae97f3d35b61164878d5fd',	'{{unknown}}'),
(3709,	1019,	'_edit_last',	'1'),
(3713,	1019,	'_oembed_b6ca0b4e082d45f1fa411d3474736228',	'{{unknown}}'),
(3712,	1019,	'_edit_lock',	'1451428762:1'),
(3714,	1019,	'_oembed_64b62265096f1badf00183bde5423d35',	'{{unknown}}'),
(3715,	1019,	'_oembed_b1b390d8ac806017cb119564ce467125',	'{{unknown}}'),
(3716,	1021,	'_edit_last',	'1'),
(3720,	1021,	'_oembed_8c0a31470a5a0c005b698770aec4f62f',	'{{unknown}}'),
(3719,	1021,	'_edit_lock',	'1451428886:1'),
(3721,	1021,	'_oembed_35d4b0f4c1af0c395320b8144c839876',	'{{unknown}}'),
(3722,	1021,	'_oembed_2c5bbe0de9ce81b18727d4ea7de80cd6',	'{{unknown}}'),
(3723,	1023,	'_edit_last',	'1'),
(3727,	1023,	'_oembed_bdd47d6684f25475578efbfc076d033d',	'{{unknown}}'),
(3726,	1023,	'_edit_lock',	'1451429009:1'),
(3728,	1023,	'_oembed_cce43cf1e4d8e64d26e42e1b8132d992',	'{{unknown}}'),
(3729,	1023,	'_oembed_6dde7805a83ba0749a44048be68f0504',	'{{unknown}}'),
(3730,	1025,	'_edit_last',	'1'),
(3734,	1025,	'_oembed_a3ba407e01201e2c4d58256ac72a4d2e',	'{{unknown}}'),
(3733,	1025,	'_edit_lock',	'1451429133:1'),
(3735,	1025,	'_oembed_d0843f8d9005d6d0dfe5c44939b8a51b',	'{{unknown}}'),
(3736,	1025,	'_oembed_e2c033a3ffb04e44e231bda7b9858a51',	'{{unknown}}'),
(3737,	1027,	'_edit_last',	'1'),
(3741,	1027,	'_oembed_794cb44b4859518436580c541ad6cab8',	'{{unknown}}'),
(3740,	1027,	'_edit_lock',	'1451429255:1'),
(3742,	1027,	'_oembed_a3d3ea9666f2e8cc2d91763e9a7c0b6f',	'{{unknown}}'),
(3743,	1027,	'_oembed_ff4c2ef36de5c70f74144376eaac4802',	'{{unknown}}'),
(23724,	4087,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmisc%2Fwoothemes-woocommerce-cart-notices-v141.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(3751,	1031,	'_edit_last',	'1'),
(3755,	1031,	'_oembed_554f42d05054f1f2e142fb315622d671',	'{{unknown}}'),
(3754,	1031,	'_edit_lock',	'1451429503:1'),
(3756,	1031,	'_oembed_694d6acaa0d38a27fddc69e3e62872fd',	'{{unknown}}'),
(3757,	1031,	'_oembed_af08ea86f387c068ec83a66c4c14b853',	'{{unknown}}'),
(3758,	1033,	'_edit_last',	'1'),
(3762,	1033,	'_oembed_553f84707646246e733585fabeb25c6d',	'{{unknown}}'),
(3761,	1033,	'_edit_lock',	'1451429626:1'),
(3763,	1033,	'_oembed_66b2bc9678c01c4aeba397ebfc1d9a0d',	'{{unknown}}'),
(3764,	1033,	'_oembed_0ac521ad105e3bc3d5bfc5f47858ee28',	'{{unknown}}'),
(3765,	1035,	'_edit_last',	'1'),
(3769,	1035,	'_oembed_c6bedbd6cb4564570498a797b9297c70',	'{{unknown}}'),
(3768,	1035,	'_edit_lock',	'1451429750:1'),
(3770,	1035,	'_oembed_582b6ce6a589f8491391af27a11d42f2',	'{{unknown}}'),
(3771,	1035,	'_oembed_e1cf1f1c1bb53f184cd55f48f7dfd9b7',	'{{unknown}}'),
(3772,	1037,	'_edit_last',	'1'),
(3776,	1037,	'_oembed_b1c686d090119186a3a115614fa0d244',	'{{unknown}}'),
(3775,	1037,	'_edit_lock',	'1451429872:1'),
(3777,	1037,	'_oembed_c9ae83267420cbd4e4fb466d72fe1f67',	'{{unknown}}'),
(3778,	1037,	'_oembed_fee981c81ba01dc48f7eaadcba36a6f6',	'{{unknown}}'),
(3779,	1039,	'_edit_last',	'1'),
(3783,	1039,	'_oembed_74cdce503b16b81eb7451e6ff1d82583',	'{{unknown}}'),
(3782,	1039,	'_edit_lock',	'1451429996:1'),
(3784,	1039,	'_oembed_57da2aba5c9a29d6121a2fbedbe5a128',	'{{unknown}}'),
(3785,	1039,	'_oembed_d6a4f33a93adeb645cdbc3b7170ea843',	'{{unknown}}'),
(3786,	1041,	'_edit_last',	'1'),
(3790,	1041,	'_oembed_36d67702081df8fe047a6a55fd848ac5',	'{{unknown}}'),
(3792,	1041,	'_oembed_1f653f33ff900219dbecb0af0eb6a961',	'{{unknown}}'),
(3789,	1041,	'_edit_lock',	'1451430119:1'),
(3791,	1041,	'_oembed_52ba9c4bea9db832236882952bd2d04f',	'{{unknown}}'),
(3793,	1043,	'_edit_last',	'1'),
(3797,	1043,	'_oembed_9ea1b47d5b0ecc76270a40271ff28756',	'{{unknown}}'),
(3799,	1043,	'_oembed_b9a4888f0a80a8d11fab754ed0a4917f',	'{{unknown}}'),
(3796,	1043,	'_edit_lock',	'1451430242:1'),
(3798,	1043,	'_oembed_33d0861ebbe5561ddb02c280b0951c2a',	'{{unknown}}'),
(3800,	1045,	'_edit_last',	'1'),
(3804,	1045,	'_oembed_3e1f85c0ed284e3194a8cab37939e56a',	'{{unknown}}'),
(3807,	1047,	'_edit_last',	'1'),
(3803,	1045,	'_edit_lock',	'1451430365:1'),
(3805,	1045,	'_oembed_6efd8686b3fb2b13429a6c2715832d40',	'{{unknown}}'),
(3806,	1045,	'_oembed_6f2d3dc5451d3702c500729a2fd52e2b',	'{{unknown}}'),
(3811,	1047,	'_oembed_40acc387042f7c38f35eee8205796ed7',	'{{unknown}}'),
(3810,	1047,	'_edit_lock',	'1451430488:1'),
(3812,	1047,	'_oembed_361fb3425fe8fbfd5ffbc231c6097364',	'{{unknown}}'),
(3813,	1047,	'_oembed_5b97e543372d42183fed979b195d834b',	'{{unknown}}'),
(3814,	1049,	'_edit_last',	'1'),
(3818,	1049,	'_oembed_2b3df4898e594e4854463e6ab31e5d5a',	'{{unknown}}'),
(3817,	1049,	'_edit_lock',	'1451430611:1'),
(3819,	1049,	'_oembed_012ab9e8d0e3abc99d34eed823f77f79',	'{{unknown}}'),
(3820,	1049,	'_oembed_7c3113583573a9718fd206d796fa692d',	'{{unknown}}'),
(3821,	1051,	'_edit_last',	'1'),
(3825,	1051,	'_oembed_abe0c9fdbf83280963b8da11c8442c6e',	'{{unknown}}'),
(3824,	1051,	'_edit_lock',	'1451430734:1'),
(3826,	1051,	'_oembed_5f6ed22f0b8bd459b66e08970a389af5',	'{{unknown}}'),
(3827,	1051,	'_oembed_9502eb5ef63aaebf6e5ae6e0584e5737',	'{{unknown}}'),
(3828,	1053,	'_edit_last',	'1'),
(3832,	1053,	'_oembed_cfefbbcaa5f404cbdcd328db372f8dce',	'{{unknown}}'),
(3831,	1053,	'_edit_lock',	'1451430857:1'),
(3833,	1053,	'_oembed_585fcebaef9d8233d57d6d3a2af7a373',	'{{unknown}}'),
(3834,	1053,	'_oembed_8885bb6cd4db1691fafef3d812fba9c9',	'{{unknown}}'),
(3835,	1055,	'_edit_last',	'1'),
(3839,	1055,	'_oembed_75bcbe7c28af822fdb8226af999c416a',	'{{unknown}}'),
(3840,	1055,	'_oembed_208fc58877d68e3582958e3788722be2',	'{{unknown}}'),
(3838,	1055,	'_edit_lock',	'1451430980:1'),
(3841,	1055,	'_oembed_8fb7862693e5267ceacc434627661864',	'{{unknown}}'),
(3842,	1057,	'_edit_last',	'1'),
(3846,	1057,	'_oembed_2ac4844e98994856a8153334942fd0c0',	'{{unknown}}'),
(3848,	1057,	'_oembed_6e9af0dad0d44c030a152be3caeccc23',	'{{unknown}}'),
(3845,	1057,	'_edit_lock',	'1451431103:1'),
(3847,	1057,	'_oembed_e9975f8be964cbf9017a013f7f5a2b99',	'{{unknown}}'),
(3849,	1059,	'_edit_last',	'1'),
(3853,	1059,	'_oembed_c004445a13f6105930e323193da96d5c',	'{{unknown}}'),
(3856,	1061,	'_edit_last',	'1'),
(3852,	1059,	'_edit_lock',	'1451431225:1'),
(3854,	1059,	'_oembed_481a0478ebd0fbe5a935ba1b681b9f23',	'{{unknown}}'),
(3855,	1059,	'_oembed_27af85704cfcdffe92b1c6e091df51ef',	'{{unknown}}'),
(3860,	1061,	'_oembed_83f6a904214da6c96129283352e09bc9',	'{{unknown}}'),
(3859,	1061,	'_edit_lock',	'1451431348:1'),
(3861,	1061,	'_oembed_19e889235a12f5ec84e2f35b7b16c986',	'{{unknown}}'),
(3862,	1061,	'_oembed_31e62718d52cfccfbaf3303408e96c21',	'{{unknown}}'),
(3863,	1063,	'_edit_last',	'1'),
(3867,	1063,	'_oembed_1722556d14421f8c6f49c190d235882a',	'{{unknown}}'),
(3866,	1063,	'_edit_lock',	'1451431471:1'),
(3868,	1063,	'_oembed_94009ac70785d6116e506d729a8ae1c3',	'{{unknown}}'),
(3869,	1063,	'_oembed_5b40f18b00de56f902397592c00dab52',	'{{unknown}}'),
(3870,	1065,	'_edit_last',	'1'),
(3874,	1065,	'_oembed_1558ffd8e5f1a04a94c11841ffbff14e',	'{{unknown}}'),
(3873,	1065,	'_edit_lock',	'1451431594:1'),
(3875,	1065,	'_oembed_4d297fc2780c4b2b13f0fcf98cecd47e',	'{{unknown}}'),
(3876,	1065,	'_oembed_d0c54c6702de20c3710dfb698bd02e6e',	'{{unknown}}'),
(3877,	1067,	'_edit_last',	'1'),
(3881,	1067,	'_oembed_def5cb8b74944b70ce76d7dd5fbef1f0',	'{{unknown}}'),
(3880,	1067,	'_edit_lock',	'1451431717:1'),
(3882,	1067,	'_oembed_32d77c3e55bac1839c7966baffe12fbe',	'{{unknown}}'),
(3883,	1067,	'_oembed_a070a3e4ff7cf20c0b596337d9390d78',	'{{unknown}}'),
(3884,	1069,	'_edit_last',	'1'),
(3888,	1069,	'_oembed_f989ebe60772a5b7a36788f826bfffbe',	'{{unknown}}'),
(3887,	1069,	'_edit_lock',	'1451431841:1'),
(3889,	1069,	'_oembed_2e82594d3b6dfabe147f5529bfefe426',	'{{unknown}}'),
(3890,	1069,	'_oembed_77e2217d466101a4d460e683ec0f28b7',	'{{unknown}}'),
(3891,	1071,	'_edit_last',	'1'),
(3895,	1071,	'_oembed_10ce6f84ff49019ceae1702d83bda349',	'{{unknown}}'),
(3894,	1071,	'_edit_lock',	'1451431964:1'),
(3896,	1071,	'_oembed_8e508a061c891c14dd3fa8970651af03',	'{{unknown}}'),
(3897,	1071,	'_oembed_7fe203278a26c783d39f6e8bacd0e11d',	'{{unknown}}'),
(3898,	1073,	'_edit_last',	'1'),
(3902,	1073,	'_oembed_4a963f8311e89dd1ec0c3e787fd4ceb7',	'{{unknown}}'),
(3901,	1073,	'_edit_lock',	'1451432089:1'),
(3903,	1073,	'_oembed_cd070261e38a8616592f4732b473281f',	'{{unknown}}'),
(3904,	1073,	'_oembed_0c26fa745da7ac145dd0c512c7494b5f',	'{{unknown}}'),
(3905,	1075,	'_edit_last',	'1'),
(3909,	1075,	'_oembed_9c062244443827e92d300e47bccefb3f',	'{{unknown}}'),
(3908,	1075,	'_edit_lock',	'1451432213:1'),
(3910,	1075,	'_oembed_3926e9f331a182efbd37cbcb734d4222',	'{{unknown}}'),
(3911,	1075,	'_oembed_d4d8fef888b2daa30b6f275297b6f837',	'{{unknown}}'),
(3912,	1077,	'_edit_last',	'1'),
(3916,	1077,	'_oembed_c2b3c898a337862a385a18eecf03c911',	'{{unknown}}'),
(3915,	1077,	'_edit_lock',	'1451432336:1'),
(3917,	1077,	'_oembed_0ede092488b11127ec467aa2c0d9817a',	'{{unknown}}'),
(3918,	1077,	'_oembed_c7c2653603e0998b247ba9139dd8ea71',	'{{unknown}}'),
(3919,	1079,	'_edit_last',	'1'),
(3923,	1079,	'_oembed_11094a74cc3486e85f8a7f8f0b060477',	'{{unknown}}'),
(3922,	1079,	'_edit_lock',	'1451432460:1'),
(3924,	1079,	'_oembed_b2896fd369002dd675edf10040707706',	'{{unknown}}'),
(3925,	1079,	'_oembed_eae475faad930195d2f6d3701ddf9021',	'{{unknown}}'),
(3926,	1081,	'_edit_last',	'1'),
(3930,	1081,	'_oembed_2f438c885fa18f7af51ddfef569b064b',	'{{unknown}}'),
(3931,	1081,	'_oembed_22d6dd3f541acea622325ae5e7b81ede',	'{{unknown}}'),
(3929,	1081,	'_edit_lock',	'1451432583:1'),
(3932,	1081,	'_oembed_f39f216212e7a69a6740043198cf0e37',	'{{unknown}}'),
(3933,	1083,	'_edit_last',	'1'),
(3937,	1083,	'_oembed_40a25a598c1a100ac455b49c7006fa59',	'{{unknown}}'),
(3936,	1083,	'_edit_lock',	'1451432706:1'),
(3938,	1083,	'_oembed_0181c36e7895d126895cbb520783bd06',	'{{unknown}}'),
(3939,	1083,	'_oembed_c0ad4a99f3d7ffc989f30105975f8e32',	'{{unknown}}'),
(3940,	1085,	'_edit_last',	'1'),
(3944,	1085,	'_oembed_cdb29b7147ef2b69c85a3e140d485d2a',	'{{unknown}}'),
(3946,	1085,	'_oembed_e1b3fe0838c30a01f492d9d7dca4de44',	'{{unknown}}'),
(3943,	1085,	'_edit_lock',	'1451432829:1'),
(3945,	1085,	'_oembed_15d9b36fa8f1dc7b9a828373cdb82fff',	'{{unknown}}'),
(3947,	1087,	'_edit_last',	'1'),
(3951,	1087,	'_oembed_0bc73384be5e90a21ffa84887b3be89c',	'{{unknown}}'),
(3954,	1089,	'_edit_last',	'1'),
(3950,	1087,	'_edit_lock',	'1451432967:1'),
(3952,	1087,	'_oembed_c62381dda9b299ed869c6649019872e5',	'{{unknown}}'),
(3953,	1087,	'_oembed_5314856f982f570ebba5468b01667fc2',	'{{unknown}}'),
(3958,	1089,	'_oembed_ac965e70a36287502b2f4534f1cbb437',	'{{unknown}}'),
(3959,	1089,	'_oembed_613659626c2ed5fde23ef0b15d8b087e',	'{{unknown}}'),
(3957,	1089,	'_edit_lock',	'1451433708:1'),
(3960,	1089,	'_oembed_320b04b2aff847808e5718daf622ce46',	'{{unknown}}'),
(3961,	1091,	'_edit_last',	'1'),
(3965,	1091,	'_oembed_f262b31cce5b030feed9fccd5dd82429',	'{{unknown}}'),
(3964,	1091,	'_edit_lock',	'1451433831:1'),
(3966,	1091,	'_oembed_3c3eef981280db391245b71b57d8752a',	'{{unknown}}'),
(3967,	1091,	'_oembed_e5efebbd3376114ade572da62e419f33',	'{{unknown}}'),
(3968,	1094,	'_edit_last',	'1'),
(3972,	1094,	'_oembed_0a7600bde089caf5f020aa95d1d91732',	'{{unknown}}'),
(3974,	1094,	'_oembed_2530bae6a90750c347a90c8e37cd5b15',	'{{unknown}}'),
(3971,	1094,	'_edit_lock',	'1451434245:1'),
(3973,	1094,	'_oembed_e6ae5045c042ff23e988d278014ed60f',	'{{unknown}}'),
(3975,	1096,	'_edit_last',	'1'),
(3979,	1096,	'_oembed_3d11f4774de89da36e30d2df7d7cef33',	'{{unknown}}'),
(3978,	1096,	'_edit_lock',	'1451434369:1'),
(3980,	1096,	'_oembed_4c7426acd4a9f3a479aef50d87524008',	'{{unknown}}'),
(3981,	1096,	'_oembed_d4568cd0a720743b4afeeac516234524',	'{{unknown}}'),
(3982,	1099,	'_edit_last',	'1'),
(3986,	1099,	'_oembed_68267a14737831d4ada333a5fc5c5a89',	'{{unknown}}'),
(3985,	1099,	'_edit_lock',	'1451434635:1'),
(3987,	1099,	'_oembed_54041473490a17e72474a025941c183c',	'{{unknown}}'),
(3988,	1099,	'_oembed_391861b84a5156875c25978feb1e6e6f',	'{{unknown}}'),
(3989,	1101,	'_edit_last',	'1'),
(3993,	1101,	'_oembed_ed2c42dfab17d11d2bfb840c5057926c',	'{{unknown}}'),
(3992,	1101,	'_edit_lock',	'1451434759:1'),
(3994,	1101,	'_oembed_68cdc9c6eb14b1cc451e8ec821b55afe',	'{{unknown}}'),
(3995,	1101,	'_oembed_1e69907a6f28662634c7ee2298e17b4c',	'{{unknown}}'),
(3996,	1103,	'_edit_last',	'1'),
(4000,	1103,	'_oembed_f74d655f3e9dfbd926443aab92189fe3',	'{{unknown}}'),
(4002,	1103,	'_oembed_428b40cc722440b6907063b1041d75da',	'{{unknown}}'),
(3999,	1103,	'_edit_lock',	'1451435010:1'),
(4001,	1103,	'_oembed_dda0ac6e7cb959231681daf7cb6b05f3',	'{{unknown}}'),
(4003,	1105,	'_edit_last',	'1'),
(4007,	1105,	'_oembed_2874fb5c5cef0e213628fe395152671a',	'{{unknown}}'),
(4009,	1105,	'_oembed_bdb2feb282ac2251a8848383b3782f7b',	'{{unknown}}'),
(4006,	1105,	'_edit_lock',	'1451435214:1'),
(4008,	1105,	'_oembed_3af260a2430b49cd61e6742e38f90ab2',	'{{unknown}}'),
(4013,	1107,	'_edit_last',	'1'),
(4017,	1107,	'_oembed_5cd9ea16e7ccd858175923cfcdec10c2',	'{{unknown}}'),
(4016,	1107,	'_edit_lock',	'1451435510:1'),
(4018,	1107,	'_oembed_de14f2dc2e36dd5427cc1228eed32cca',	'{{unknown}}'),
(4019,	1107,	'_oembed_19af1b7fc477c10069ae63e28e0d0d96',	'{{unknown}}'),
(4020,	1109,	'_edit_last',	'1'),
(4024,	1109,	'_oembed_c0e1adf8be66b4f16a66b925080d07f7',	'{{unknown}}'),
(4023,	1109,	'_edit_lock',	'1451435633:1'),
(4025,	1109,	'_oembed_08428f27d3194e85e3fd037ce9be1052',	'{{unknown}}'),
(4026,	1109,	'_oembed_64f01db9e5c35748de127f600dd27144',	'{{unknown}}'),
(4027,	1111,	'_edit_last',	'1'),
(4031,	1111,	'_oembed_60413e40787f75c924f82b32e75bf48d',	'{{unknown}}'),
(4034,	1113,	'_edit_last',	'1'),
(4030,	1111,	'_edit_lock',	'1451435885:1'),
(4032,	1111,	'_oembed_ba648bd06683fc085b67a7653accbf60',	'{{unknown}}'),
(4033,	1111,	'_oembed_6ffcee36aeb4a14774baf93befeefb94',	'{{unknown}}'),
(4038,	1113,	'_oembed_72ace8a786723afb206d3807a2b88dc1',	'{{unknown}}'),
(4040,	1113,	'_oembed_5c13dffafec92fe6cfe3ba5404534e44',	'{{unknown}}'),
(4037,	1113,	'_edit_lock',	'1451437054:1'),
(4039,	1113,	'_oembed_e182faf4a453c7b5ca11dd9b7b65f039',	'{{unknown}}'),
(4046,	1113,	'xyz_fbap',	'1'),
(4048,	1115,	'_edit_last',	'1'),
(4052,	1115,	'_oembed_17a730d9c1bbe045acdd415ce91007b1',	'{{unknown}}'),
(4054,	1115,	'_oembed_db3582deeed23084c05ab9f062f22026',	'{{unknown}}'),
(4051,	1115,	'xyz_fbap',	'1'),
(4053,	1115,	'_oembed_365a0f78c78551165d1daa9a8a291c0b',	'{{unknown}}'),
(4055,	1115,	'_edit_lock',	'1451439336:1'),
(4056,	1117,	'_edit_last',	'1'),
(4060,	1117,	'_oembed_66608a8275c58dd07418fd5b8f32e885',	'{{unknown}}'),
(4061,	1117,	'_oembed_8651aa5c344baf444afd883c02914ba1',	'{{unknown}}'),
(4059,	1117,	'xyz_fbap',	'1'),
(4062,	1117,	'_oembed_3ebf2308fc2dd54b55bfa5db3b958f52',	'{{unknown}}'),
(4063,	1117,	'_edit_lock',	'1451439467:1'),
(4064,	1119,	'_edit_last',	'1'),
(4068,	1119,	'_oembed_f8f4005c3ecec546d9f0f84dfe8edc26',	'{{unknown}}'),
(4069,	1119,	'_oembed_f81ccfcbd1f147617932b6dc24bb88bc',	'{{unknown}}'),
(4067,	1119,	'xyz_fbap',	'1'),
(4070,	1119,	'_oembed_2e818db7246a79ede5ea74b9021ff3f5',	'{{unknown}}'),
(4071,	1119,	'_edit_lock',	'1451439597:1'),
(4072,	1121,	'_edit_last',	'1'),
(4076,	1121,	'_oembed_c44b9c268251cc72a35499bf011432fa',	'{{unknown}}'),
(4078,	1121,	'_oembed_570b413458ffe99b1e6de6837eb51f03',	'{{unknown}}'),
(4075,	1121,	'xyz_fbap',	'1'),
(4077,	1121,	'_oembed_38a44f858a0572f361a7e9611566f758',	'{{unknown}}'),
(4079,	1121,	'_edit_lock',	'1451439728:1'),
(4080,	1123,	'_edit_last',	'1'),
(4084,	1123,	'_oembed_e05ed31b78ce7f8aef27fe27faeb3c65',	'{{unknown}}'),
(4085,	1123,	'_oembed_ab1463c68f8fb47ff0b527961e8a34ce',	'{{unknown}}'),
(4083,	1123,	'xyz_fbap',	'1'),
(4086,	1123,	'_oembed_fbfb96c1e9a01e42c5db9a8d1884961e',	'{{unknown}}'),
(4087,	1123,	'_edit_lock',	'1451439857:1'),
(4088,	1125,	'_edit_last',	'1'),
(4092,	1125,	'_oembed_7e87f897944c677f15888f716022a05f',	'{{unknown}}'),
(4093,	1125,	'_oembed_a9feb0583841dbb6bf30c040aaaddb75',	'{{unknown}}'),
(4091,	1125,	'xyz_fbap',	'1'),
(4094,	1125,	'_oembed_096bf0647ad96ff53c31905088dee7f5',	'{{unknown}}'),
(4095,	1125,	'_edit_lock',	'1451439989:1'),
(4096,	1127,	'_edit_last',	'1'),
(4100,	1127,	'_oembed_e7b49418a77c62c7ff1b77be67088881',	'{{unknown}}'),
(4103,	1127,	'_edit_lock',	'1451440119:1'),
(4099,	1127,	'xyz_fbap',	'1'),
(4101,	1127,	'_oembed_a9662deb5ab6d99345fdd97f6ed72257',	'{{unknown}}'),
(4102,	1127,	'_oembed_6834c094964bda7166235a4b19354d75',	'{{unknown}}'),
(4104,	1129,	'_edit_last',	'1'),
(4108,	1129,	'_oembed_d4cfa7292492a3174d59f2ed67b80d2d',	'{{unknown}}'),
(4111,	1129,	'_edit_lock',	'1451440248:1'),
(4107,	1129,	'xyz_fbap',	'1'),
(4109,	1129,	'_oembed_bef5f1714200845a137bb5e7da55dddf',	'{{unknown}}'),
(4110,	1129,	'_oembed_ae10c099cb1b9cefc1ea08e940c4a116',	'{{unknown}}'),
(4112,	1131,	'_edit_last',	'1'),
(4116,	1131,	'_oembed_05dc804107228ee5d51f9d35b4f86615',	'{{unknown}}'),
(4117,	1131,	'_oembed_7667f84a34c847d3c5aec95720ee3c50',	'{{unknown}}'),
(4115,	1131,	'xyz_fbap',	'1'),
(4118,	1131,	'_oembed_8e51ad15efd1b72d0759b7bf7f6ba210',	'{{unknown}}'),
(4119,	1131,	'_edit_lock',	'1451440378:1'),
(4120,	1133,	'_edit_last',	'1'),
(4124,	1133,	'_oembed_82408eab86b3e4ffdfc702dd891fd757',	'{{unknown}}'),
(4127,	1133,	'_edit_lock',	'1451440510:1'),
(4123,	1133,	'xyz_fbap',	'1'),
(4125,	1133,	'_oembed_c0c019a1b5a57ffa4abb24cac6a08824',	'{{unknown}}'),
(4126,	1133,	'_oembed_0bdfacd6cba4f87633e0bcaf44488a22',	'{{unknown}}'),
(4128,	1135,	'_edit_last',	'1'),
(4132,	1135,	'_oembed_e39140fb5af0ebb447d0e9af580316c0',	'{{unknown}}'),
(4135,	1135,	'_edit_lock',	'1451440639:1'),
(4131,	1135,	'xyz_fbap',	'1'),
(4133,	1135,	'_oembed_b727164f59dc7938fbb01d7c56c771cf',	'{{unknown}}'),
(4134,	1135,	'_oembed_b98f59d483f3b07f99ebe272000d8a3d',	'{{unknown}}'),
(4136,	1137,	'_edit_last',	'1'),
(4140,	1137,	'_oembed_aa45c9bfe2a62132f6fe9c21e597ca3f',	'{{unknown}}'),
(4142,	1137,	'_oembed_d877097d43c6fa56ec875f39dde75699',	'{{unknown}}'),
(4139,	1137,	'xyz_fbap',	'1'),
(4141,	1137,	'_oembed_e040695a9b83b772c58c775c4a8f2ca5',	'{{unknown}}'),
(4143,	1137,	'_edit_lock',	'1451440769:1'),
(4144,	1139,	'_edit_last',	'1'),
(4148,	1139,	'_oembed_87f0251159cff0787e9c8cbd66867505',	'{{unknown}}'),
(4151,	1139,	'_edit_lock',	'1451440898:1'),
(4147,	1139,	'xyz_fbap',	'1'),
(4149,	1139,	'_oembed_2a5c2b0e677481f813509ebc5baf5b38',	'{{unknown}}'),
(4150,	1139,	'_oembed_019d7d067fcad8e54ffee20136cee12e',	'{{unknown}}'),
(4152,	1141,	'_edit_last',	'1'),
(4156,	1141,	'_oembed_6d3969e9e05a8ba38ff25be74cea6146',	'{{unknown}}'),
(4159,	1141,	'_edit_lock',	'1451441029:1'),
(4155,	1141,	'xyz_fbap',	'1'),
(4157,	1141,	'_oembed_cc255e0ea0e11a6dbe06ee508caca999',	'{{unknown}}'),
(4158,	1141,	'_oembed_0fc0a896902b0785fabb666d649123b5',	'{{unknown}}'),
(4160,	1143,	'_edit_last',	'1'),
(4164,	1143,	'_oembed_9267061e38210cb39e3a37df94dde4a5',	'{{unknown}}'),
(4166,	1143,	'_oembed_e66155ba179b63d62623677f68148ab2',	'{{unknown}}'),
(4163,	1143,	'xyz_fbap',	'1'),
(4165,	1143,	'_oembed_78e16baa95e0d447161ce8a84b3e9252',	'{{unknown}}'),
(4167,	1143,	'_edit_lock',	'1451441159:1'),
(4168,	1145,	'_edit_last',	'1'),
(4172,	1145,	'_oembed_8fce1271812200fcf503223be0eb1091',	'{{unknown}}'),
(4175,	1145,	'_edit_lock',	'1451441290:1'),
(4171,	1145,	'xyz_fbap',	'1'),
(4173,	1145,	'_oembed_3909ed6f64c6c2ca93805d58a8ae22f7',	'{{unknown}}'),
(4174,	1145,	'_oembed_8b8e4c5f50ec610e359af1c994615816',	'{{unknown}}'),
(4176,	1147,	'_edit_last',	'1'),
(4180,	1147,	'_oembed_f2dd925d0d7fde57b6a44bde0649569e',	'{{unknown}}'),
(4181,	1147,	'_oembed_fec69d89d3dac04196336bd80861c411',	'{{unknown}}'),
(4179,	1147,	'xyz_fbap',	'1'),
(4182,	1147,	'_oembed_a2ebf500856803e5981f4b1babb9e248',	'{{unknown}}'),
(4183,	1147,	'_edit_lock',	'1451441422:1'),
(4184,	1149,	'_edit_last',	'1'),
(4188,	1149,	'_oembed_957ce2e68de566f935f73e35570f8bbc',	'{{unknown}}'),
(4189,	1149,	'_oembed_a0ba7edb0694cc6f4348924590e27cdc',	'{{unknown}}'),
(4187,	1149,	'xyz_fbap',	'1'),
(4190,	1149,	'_oembed_b84bc8ff2333da4fd0a9e2110197254f',	'{{unknown}}'),
(4191,	1149,	'_edit_lock',	'1451441554:1'),
(4192,	1151,	'_edit_last',	'1'),
(4196,	1151,	'_oembed_399c78642549adb3c9f5f845ac1414eb',	'{{unknown}}'),
(4199,	1151,	'_edit_lock',	'1451441684:1'),
(4195,	1151,	'xyz_fbap',	'1'),
(4197,	1151,	'_oembed_dc636a7ddfee419110d40252a17bfbe2',	'{{unknown}}'),
(4198,	1151,	'_oembed_dbb8a64da9f14db4f647abe5edef3e94',	'{{unknown}}'),
(4200,	1153,	'_edit_last',	'1'),
(4204,	1153,	'_oembed_b56fe320b7f9bbc57e933e9c27837258',	'{{unknown}}'),
(4207,	1153,	'_edit_lock',	'1451441814:1'),
(4203,	1153,	'xyz_fbap',	'1'),
(4205,	1153,	'_oembed_977d9f0e5d02a45bfd79cf6852a44d7c',	'{{unknown}}'),
(4206,	1153,	'_oembed_6fb9e45e77fe6d830094979754dc103f',	'{{unknown}}'),
(4208,	1155,	'_edit_last',	'1'),
(4212,	1155,	'_oembed_2418f3e94102d6519471740d5b4e6893',	'{{unknown}}'),
(4213,	1155,	'_oembed_8bd756a9fb7eb38246ef23263b4d920d',	'{{unknown}}'),
(4211,	1155,	'xyz_fbap',	'1'),
(4214,	1155,	'_oembed_6f417d6794a5e97779b9d0c836e6f3f7',	'{{unknown}}'),
(4215,	1155,	'_edit_lock',	'1451441944:1'),
(4216,	1157,	'_edit_last',	'1'),
(4220,	1157,	'_oembed_d1756da958ab0a35f7c18b1d938c20d0',	'{{unknown}}'),
(4221,	1157,	'_oembed_54f74d87cb9187ed49193485c750e141',	'{{unknown}}'),
(4219,	1157,	'xyz_fbap',	'1'),
(4222,	1157,	'_oembed_f2fee1a1d68733af8d7cbf0140034756',	'{{unknown}}'),
(4223,	1157,	'_edit_lock',	'1451442074:1'),
(4224,	1159,	'_edit_last',	'1'),
(4228,	1159,	'_oembed_c53458c7bb66a0e958105179050b13fd',	'{{unknown}}'),
(4229,	1159,	'_oembed_b324461c9189cfe02f3f3060309064c8',	'{{unknown}}'),
(4227,	1159,	'xyz_fbap',	'1'),
(4230,	1159,	'_oembed_8374f733cd29c0f94d20cf2693f647bb',	'{{unknown}}'),
(4231,	1159,	'_edit_lock',	'1451442205:1'),
(4232,	1161,	'_edit_last',	'1'),
(4236,	1161,	'_oembed_349efdf38d1be5bf85afbf534b439c5e',	'{{unknown}}'),
(4238,	1161,	'_oembed_0220df6e824a7dbdc2f61baf563d497b',	'{{unknown}}'),
(4235,	1161,	'xyz_fbap',	'1'),
(4237,	1161,	'_oembed_9475d8e9f005a23792853a8c9857b9a6',	'{{unknown}}'),
(4239,	1161,	'_edit_lock',	'1451442336:1'),
(4240,	1163,	'_edit_last',	'1'),
(4244,	1163,	'_oembed_87e733146d2862ce9f8a4417cd47a531',	'{{unknown}}'),
(4247,	1163,	'_edit_lock',	'1451442470:1'),
(4243,	1163,	'xyz_fbap',	'1'),
(4245,	1163,	'_oembed_9c4b0787ede3c0d064c3344b9aa2d48a',	'{{unknown}}'),
(4246,	1163,	'_oembed_10621786f0815e9eab28dd268ede086d',	'{{unknown}}'),
(4248,	1165,	'_edit_last',	'1'),
(4252,	1165,	'_oembed_5af2b1eb1918ebbca9d1d5403a502d62',	'{{unknown}}'),
(4255,	1165,	'_edit_lock',	'1451442600:1'),
(4251,	1165,	'xyz_fbap',	'1'),
(4253,	1165,	'_oembed_9a9e65dd87fbef7dbb748b4445a46826',	'{{unknown}}'),
(4254,	1165,	'_oembed_50a3e1ba5709ee2241e1bb89cea1d393',	'{{unknown}}'),
(4256,	1167,	'_edit_last',	'1'),
(4260,	1167,	'_oembed_a7683d9eebd8bcf6ccb3c035747b71b6',	'{{unknown}}'),
(4261,	1167,	'_oembed_f351e77600d7565a0a7508a1522f1484',	'{{unknown}}'),
(4259,	1167,	'xyz_fbap',	'1'),
(4262,	1167,	'_oembed_3e43086c52a233a503a43828e942646d',	'{{unknown}}'),
(4263,	1167,	'_edit_lock',	'1451442729:1'),
(4264,	1169,	'_edit_last',	'1'),
(4268,	1169,	'_oembed_b6f375618ff63b4dd6cf9986f35babed',	'{{unknown}}'),
(4270,	1169,	'_oembed_2fa0f5d435775a0468c6215b7caf0118',	'{{unknown}}'),
(4267,	1169,	'xyz_fbap',	'1'),
(4269,	1169,	'_oembed_4f4bab1f447d99fa2afb097b9ba86e1f',	'{{unknown}}'),
(4271,	1169,	'_edit_lock',	'1451442860:1'),
(4272,	1171,	'_edit_last',	'1'),
(4276,	1171,	'_oembed_805ddced546b6f2bdb2d397e758ae407',	'{{unknown}}'),
(4278,	1171,	'_oembed_daee43a896de41f9e94fa2a37cdd072c',	'{{unknown}}'),
(4275,	1171,	'xyz_fbap',	'1'),
(4277,	1171,	'_oembed_54438402bfacfb146dbdb6a89d334df7',	'{{unknown}}'),
(4279,	1171,	'_edit_lock',	'1451442990:1'),
(4280,	1173,	'_edit_last',	'1'),
(4284,	1173,	'_oembed_f5beece354ccd707f226bec518a674e2',	'{{unknown}}'),
(4286,	1173,	'_oembed_d055281eac372d956b028f199442f4f3',	'{{unknown}}'),
(4283,	1173,	'xyz_fbap',	'1'),
(4285,	1173,	'_oembed_c787306deb2c5af34921f55750a38e21',	'{{unknown}}'),
(4287,	1173,	'_edit_lock',	'1451443122:1'),
(4288,	1175,	'_edit_last',	'1'),
(4292,	1175,	'_oembed_bca4d20913254c3fe6e329ac00e7d685',	'{{unknown}}'),
(4295,	1175,	'_edit_lock',	'1451443253:1'),
(4291,	1175,	'xyz_fbap',	'1'),
(4293,	1175,	'_oembed_eb0198abb087fca3ce602c6bb1e7ca7a',	'{{unknown}}'),
(4294,	1175,	'_oembed_c40fc423a0c746311366f464013dd5a5',	'{{unknown}}'),
(4296,	1177,	'_edit_last',	'1'),
(4300,	1177,	'_oembed_c0224cccec092ad4fa3d791d77bfcb02',	'{{unknown}}'),
(4303,	1177,	'_edit_lock',	'1451443385:1'),
(4299,	1177,	'xyz_fbap',	'1'),
(4301,	1177,	'_oembed_531c4ff86bd2502b636df7e5a3d4f207',	'{{unknown}}'),
(4302,	1177,	'_oembed_13f8ba7e747788a1a578ca46263e0de6',	'{{unknown}}'),
(4304,	1179,	'_edit_last',	'1'),
(4308,	1179,	'_oembed_13d048220d37c31b8c577c47f9194c16',	'{{unknown}}'),
(4311,	1179,	'_edit_lock',	'1451443515:1'),
(4307,	1179,	'xyz_fbap',	'1'),
(4309,	1179,	'_oembed_082075f6d28f5a07aaa0917930429905',	'{{unknown}}'),
(4310,	1179,	'_oembed_01b90d33b4eb49ad0d8874754def74c3',	'{{unknown}}'),
(4312,	1181,	'_edit_last',	'1'),
(4316,	1181,	'_oembed_0c3d2f2679823b1a725baf677f25a9b4',	'{{unknown}}'),
(4318,	1181,	'_oembed_3482b1fbcf8958766cfd5ff95bd39178',	'{{unknown}}'),
(4315,	1181,	'xyz_fbap',	'1'),
(4317,	1181,	'_oembed_6e5a1403a63749d81ecffe189a30053b',	'{{unknown}}'),
(4319,	1181,	'_edit_lock',	'1451443646:1'),
(4320,	1183,	'_edit_last',	'1'),
(4324,	1183,	'_oembed_c5cff21eb2e4680b8997ed113659a2a5',	'{{unknown}}'),
(4326,	1183,	'_oembed_77771a3b9f70fdf99f634537d0c85454',	'{{unknown}}'),
(4323,	1183,	'xyz_fbap',	'1'),
(4325,	1183,	'_oembed_5686f120b4d04f3322681dd4a1ed0263',	'{{unknown}}'),
(4327,	1183,	'_edit_lock',	'1451443776:1'),
(4328,	1185,	'_edit_last',	'1'),
(4332,	1185,	'_oembed_919aef2f080c2ce53a3a06354f147008',	'{{unknown}}'),
(4334,	1185,	'_oembed_85044a73921ce5402b61bd643f9cf3a5',	'{{unknown}}'),
(4331,	1185,	'xyz_fbap',	'1'),
(4333,	1185,	'_oembed_2328e90d47327dad7b40bfd5d3a9f8cb',	'{{unknown}}'),
(4335,	1185,	'_edit_lock',	'1451443909:1'),
(4336,	1187,	'_edit_last',	'1'),
(4340,	1187,	'_oembed_d4ff740fffe396467bd7d1eca74ddde9',	'{{unknown}}'),
(4343,	1187,	'_edit_lock',	'1451444042:1'),
(4339,	1187,	'xyz_fbap',	'1'),
(4341,	1187,	'_oembed_4cee70a92da0fc1f8929fc0485c7664d',	'{{unknown}}'),
(4342,	1187,	'_oembed_ab8fd419c2dc8964e827edeb89aae7de',	'{{unknown}}'),
(4344,	1189,	'_edit_last',	'1'),
(4348,	1189,	'_oembed_9ac0fa98682813d8e6116ba172ef4b20',	'{{unknown}}'),
(4351,	1189,	'_edit_lock',	'1451444171:1'),
(4347,	1189,	'xyz_fbap',	'1'),
(4349,	1189,	'_oembed_0b7cf84d2b711eda41a4967840b7b5d1',	'{{unknown}}'),
(4350,	1189,	'_oembed_f95d4793331336c85023acf9297e482f',	'{{unknown}}'),
(4352,	1191,	'_edit_last',	'1'),
(4356,	1191,	'_oembed_348fd3b1ad62375bfc880e82911a0bcf',	'{{unknown}}'),
(4358,	1191,	'_oembed_97aab6bb7c0905cb62a446cca9661437',	'{{unknown}}'),
(4355,	1191,	'xyz_fbap',	'1'),
(4357,	1191,	'_oembed_bd600125b82552330531fd6f8fe1ad3b',	'{{unknown}}'),
(4359,	1191,	'_edit_lock',	'1451444300:1'),
(4360,	1193,	'_edit_last',	'1'),
(4364,	1193,	'_oembed_32401c1383e575284ac1fecf396d6189',	'{{unknown}}'),
(4367,	1193,	'_edit_lock',	'1451444430:1'),
(4363,	1193,	'xyz_fbap',	'1'),
(4365,	1193,	'_oembed_187bebfc164255685950b78af0ac2a42',	'{{unknown}}'),
(4366,	1193,	'_oembed_89dfee17d0a4e94da6629926b2ad5d65',	'{{unknown}}'),
(4368,	1195,	'_edit_last',	'1'),
(4372,	1195,	'_oembed_686ab620d23b004b5c90e19dbab6eaa5',	'{{unknown}}'),
(4373,	1195,	'_oembed_a3d223209fbc9eab83d6d08fcd6f4ee7',	'{{unknown}}'),
(4371,	1195,	'xyz_fbap',	'1'),
(4374,	1195,	'_oembed_932703d119eab09fdfe8f7cc0230f0f4',	'{{unknown}}'),
(4375,	1195,	'_edit_lock',	'1451444559:1'),
(4376,	1197,	'_edit_last',	'1'),
(4380,	1197,	'_oembed_49b4e48bece245f2c2d973b4eb7152d1',	'{{unknown}}'),
(4379,	1197,	'xyz_fbap',	'1'),
(4381,	1197,	'_oembed_72b4632693d5aaf4ff483136900201ca',	'{{unknown}}'),
(4382,	1197,	'_oembed_c2abcf9dd184b595de5a3102ded1f854',	'{{unknown}}'),
(4383,	1197,	'_edit_lock',	'1451444689:1'),
(4384,	1199,	'_edit_last',	'1'),
(4388,	1199,	'_oembed_a9fc62a94f4e90e1c2a0259098bf9432',	'{{unknown}}'),
(4390,	1199,	'_oembed_220c06b646737f3214998f0a10eb30c8',	'{{unknown}}'),
(4387,	1199,	'xyz_fbap',	'1'),
(4389,	1199,	'_oembed_c00744e250ce73cf377f8dbc1944f695',	'{{unknown}}'),
(4391,	1199,	'_edit_lock',	'1451444818:1'),
(4392,	1201,	'_edit_last',	'1'),
(4396,	1201,	'_oembed_e854c50f883d0014843f4a9b0bf7336d',	'{{unknown}}'),
(4398,	1201,	'_oembed_18383bcec98ce5808d3140bad708ca50',	'{{unknown}}'),
(4395,	1201,	'xyz_fbap',	'1'),
(4397,	1201,	'_oembed_6bf5b63cdb626292d8a034804de195be',	'{{unknown}}'),
(4399,	1201,	'_edit_lock',	'1451444950:1'),
(4400,	1203,	'_edit_last',	'1'),
(4404,	1203,	'_oembed_ee560c196dbef8a635c894e89ab6e95e',	'{{unknown}}'),
(4405,	1203,	'_oembed_7f6cc0ba492b1afd7784cc3cfa985834',	'{{unknown}}'),
(4403,	1203,	'xyz_fbap',	'1'),
(4406,	1203,	'_oembed_731c08c66314d1200b80a8414ad85728',	'{{unknown}}'),
(4407,	1203,	'_edit_lock',	'1451445085:1'),
(4408,	1205,	'_edit_last',	'1'),
(4412,	1205,	'_oembed_1519c9b4be7e6daa8cdc8fd9f829e863',	'{{unknown}}'),
(4415,	1205,	'_edit_lock',	'1451445215:1'),
(4411,	1205,	'xyz_fbap',	'1'),
(4413,	1205,	'_oembed_ea92f3a8039cfb1ccb6ef9635b3bced8',	'{{unknown}}'),
(4414,	1205,	'_oembed_8a1524fd9fc406ea9f79b04a550df0b5',	'{{unknown}}'),
(4416,	1207,	'_edit_last',	'1'),
(4420,	1207,	'_oembed_926926bc64a8941fe24a1cfde0888543',	'{{unknown}}'),
(4422,	1207,	'_oembed_a94c32f8740d6aec14d5ad983849ee72',	'{{unknown}}'),
(4419,	1207,	'xyz_fbap',	'1'),
(4421,	1207,	'_oembed_e507caba87bb25db7beac4ac20e49128',	'{{unknown}}'),
(4423,	1207,	'_edit_lock',	'1451445343:1'),
(4424,	1209,	'_edit_last',	'1'),
(4428,	1209,	'_oembed_49861877650122e12cd811dbe7cd363c',	'{{unknown}}'),
(4431,	1209,	'_edit_lock',	'1451445473:1'),
(4427,	1209,	'xyz_fbap',	'1'),
(4429,	1209,	'_oembed_52b1d0c58a7ef87ba4b0e98cc46cfc8c',	'{{unknown}}'),
(4430,	1209,	'_oembed_b12945a46a981f896b2a5bab4087a51c',	'{{unknown}}'),
(4432,	1211,	'_edit_last',	'1'),
(4436,	1211,	'_oembed_a684998a457325c5b30604d26adc263a',	'{{unknown}}'),
(4439,	1211,	'_edit_lock',	'1451445603:1'),
(4435,	1211,	'xyz_fbap',	'1'),
(4437,	1211,	'_oembed_6278f151c3355e7e0e074d7c68b9549a',	'{{unknown}}'),
(4438,	1211,	'_oembed_3f6961f526ee6ae50bd14010cd59f64f',	'{{unknown}}'),
(4440,	1213,	'_edit_last',	'1'),
(4444,	1213,	'_oembed_06d2783d73538a38303195d31024dc00',	'{{unknown}}'),
(4446,	1213,	'_oembed_d3c99b2a7170e2d4ffb1cb3d5e79ea71',	'{{unknown}}'),
(4443,	1213,	'xyz_fbap',	'1'),
(4445,	1213,	'_oembed_e9a248ea6329152f5d86662d293f60ec',	'{{unknown}}'),
(4447,	1213,	'_edit_lock',	'1451445734:1'),
(4448,	1215,	'_edit_last',	'1'),
(4452,	1215,	'_oembed_d6f5a1f7a7eac2739ec3d684311caecf',	'{{unknown}}'),
(4454,	1215,	'_oembed_feed2a7512e4a174224bf03db36d2d01',	'{{unknown}}'),
(4451,	1215,	'xyz_fbap',	'1'),
(4453,	1215,	'_oembed_248edc122b3ef1c1bebef42fae47eba6',	'{{unknown}}'),
(4455,	1215,	'_edit_lock',	'1451445865:1'),
(4456,	1217,	'_edit_last',	'1'),
(4460,	1217,	'_oembed_d30a5f12a9a7946a0686e0ad48ea2ee8',	'{{unknown}}'),
(4461,	1217,	'_oembed_63a40461892599b684c468dd63be9e4e',	'{{unknown}}'),
(4459,	1217,	'xyz_fbap',	'1'),
(4462,	1217,	'_oembed_f115e8c56daa972fc9d39a1a757096f9',	'{{unknown}}'),
(4463,	1217,	'_edit_lock',	'1451445995:1'),
(4464,	1219,	'_edit_last',	'1'),
(4468,	1219,	'_oembed_67fee2ea6f451d91aeb1ca84499e7cc1',	'{{unknown}}'),
(4471,	1219,	'_edit_lock',	'1451446127:1'),
(4467,	1219,	'xyz_fbap',	'1'),
(4469,	1219,	'_oembed_8b4ab65d6e29b4e57b391b79c836c55d',	'{{unknown}}'),
(4470,	1219,	'_oembed_37e16791973d35a5d7b3b41b9d663156',	'{{unknown}}'),
(4472,	1221,	'_edit_last',	'1'),
(4476,	1221,	'_oembed_93c98042ab57fb134a29a763ebced3d1',	'{{unknown}}'),
(4479,	1221,	'_edit_lock',	'1451446259:1'),
(4475,	1221,	'xyz_fbap',	'1'),
(4477,	1221,	'_oembed_ebc792ef2d7bd267702536641f25b13b',	'{{unknown}}'),
(4478,	1221,	'_oembed_7c41abcef0df4cbdf4a17d7ee5c4d871',	'{{unknown}}'),
(4480,	1223,	'_edit_last',	'1'),
(4484,	1223,	'_oembed_bc5abd7266bd0a534ad9c6595079cb78',	'{{unknown}}'),
(4486,	1223,	'_oembed_c5a55dac3ad5431fee351fcedc911de4',	'{{unknown}}'),
(4483,	1223,	'xyz_fbap',	'1'),
(4485,	1223,	'_oembed_8000a4c8cfe1135c07d7598b06f8a902',	'{{unknown}}'),
(4487,	1223,	'_edit_lock',	'1451446388:1'),
(4488,	1225,	'_edit_last',	'1'),
(4492,	1225,	'_oembed_5321858a82b7e075b8b4c8f44bcac6c2',	'{{unknown}}'),
(4493,	1225,	'_oembed_23afb7a862d84761cb9cee9c2fce9b9a',	'{{unknown}}'),
(4491,	1225,	'xyz_fbap',	'1'),
(4494,	1225,	'_oembed_21ed2afda3c099370b1e7efc8d2ca714',	'{{unknown}}'),
(4495,	1225,	'_edit_lock',	'1451446520:1'),
(4496,	1227,	'_edit_last',	'1'),
(4500,	1227,	'_oembed_c44d12de57ad493ded0ddb331e29131f',	'{{unknown}}'),
(4502,	1227,	'_oembed_891fb236b06bb5444e1d02e3b53180d6',	'{{unknown}}'),
(4499,	1227,	'xyz_fbap',	'1'),
(4501,	1227,	'_oembed_97e74d2ba9917253b1e562f38b9a5879',	'{{unknown}}'),
(4503,	1227,	'_edit_lock',	'1451446651:1'),
(4504,	1229,	'_edit_last',	'1'),
(4508,	1229,	'_oembed_107cad4f616e8e29c4730d7fe1290bdc',	'{{unknown}}'),
(4510,	1229,	'_oembed_975335cc64b0293345c313ec6bf1d899',	'{{unknown}}'),
(4507,	1229,	'xyz_fbap',	'1'),
(4509,	1229,	'_oembed_8015ecbb8df9f487cb58239770158cda',	'{{unknown}}'),
(4511,	1229,	'_edit_lock',	'1451446782:1'),
(4512,	1231,	'_edit_last',	'1'),
(4516,	1231,	'_oembed_462213a343e1e0e5c3c823f6eca3c5ec',	'{{unknown}}'),
(4517,	1231,	'_oembed_196978611ed0f087ed054fa6b785f6c4',	'{{unknown}}'),
(4515,	1231,	'xyz_fbap',	'1'),
(4518,	1231,	'_oembed_d5225b77e08f787ee42b549027196726',	'{{unknown}}'),
(4519,	1231,	'_edit_lock',	'1451446914:1'),
(4520,	1233,	'_edit_last',	'1'),
(4524,	1233,	'_oembed_7c230a62dea09fd1d661b969e54617f0',	'{{unknown}}'),
(4525,	1233,	'_oembed_c749c08832b4f18f4858ab8dbf246c8f',	'{{unknown}}'),
(4523,	1233,	'xyz_fbap',	'1'),
(4526,	1233,	'_oembed_f9fcaf214a676b64cee8a1800945cdd9',	'{{unknown}}'),
(4527,	1233,	'_edit_lock',	'1451447044:1'),
(4528,	1235,	'_edit_last',	'1'),
(4532,	1235,	'_oembed_af8597a1d01c7cf8f7c6d90c6dead178',	'{{unknown}}'),
(4534,	1235,	'_oembed_635b8ed6b0d95978511bc897302744cd',	'{{unknown}}'),
(4531,	1235,	'xyz_fbap',	'1'),
(4533,	1235,	'_oembed_760bbe4d76e634d86f6a1b542045c542',	'{{unknown}}'),
(4535,	1235,	'_edit_lock',	'1451447176:1'),
(4536,	1237,	'_edit_last',	'1'),
(4540,	1237,	'_oembed_516a9d83eafbf387efa4aa079f951c3b',	'{{unknown}}'),
(4541,	1237,	'_oembed_0bbf5f44322c8810af52bcdb8414228c',	'{{unknown}}'),
(4539,	1237,	'xyz_fbap',	'1'),
(4542,	1237,	'_oembed_37fd71525b72a2b8ef160e43451b027c',	'{{unknown}}'),
(4543,	1237,	'_edit_lock',	'1451447304:1'),
(4544,	1239,	'_edit_last',	'1'),
(4548,	1239,	'_oembed_85a04ca4b250917bd963b9795c6c68f6',	'{{unknown}}'),
(4549,	1239,	'_oembed_8245e6c51b2ea411a43ec54a119aad0e',	'{{unknown}}'),
(4547,	1239,	'xyz_fbap',	'1'),
(4550,	1239,	'_oembed_b5ff6a87eb0dd3d74f1d7c94eb5a986a',	'{{unknown}}'),
(4551,	1239,	'_edit_lock',	'1451447434:1'),
(4552,	1241,	'_edit_last',	'1'),
(4556,	1241,	'_oembed_8502fd4b209f3023701a1fb996c6c07f',	'{{unknown}}'),
(4559,	1241,	'_edit_lock',	'1451447564:1'),
(4555,	1241,	'xyz_fbap',	'1'),
(4557,	1241,	'_oembed_01ac4e1fbbc1bb68433328960fd9642e',	'{{unknown}}'),
(4558,	1241,	'_oembed_2d746e21db932ba60698672096e5cb2b',	'{{unknown}}'),
(4560,	1243,	'_edit_last',	'1'),
(4564,	1243,	'_oembed_ff449b32f58d242123fdfcb489c6ca2c',	'{{unknown}}'),
(4567,	1243,	'_edit_lock',	'1451447696:1'),
(4563,	1243,	'xyz_fbap',	'1'),
(4565,	1243,	'_oembed_8308a14ef582dd050f87adaced8d8ab5',	'{{unknown}}'),
(4566,	1243,	'_oembed_05b4ac1ad36137ebd9453ddbf0c2cf2f',	'{{unknown}}'),
(4568,	1245,	'_edit_last',	'1'),
(4572,	1245,	'_oembed_f326b1a1bfb526fd9bfaee25c6e6d9d8',	'{{unknown}}'),
(4574,	1245,	'_oembed_3fcff2635f845ce7cb438a9492d1b03d',	'{{unknown}}'),
(4571,	1245,	'xyz_fbap',	'1'),
(4573,	1245,	'_oembed_bba9a62cf52cc0372e280a531e2d0022',	'{{unknown}}'),
(4575,	1245,	'_edit_lock',	'1451447824:1'),
(4576,	1247,	'_edit_last',	'1'),
(4580,	1247,	'_oembed_59fefea613636813836d5edb1e56ac42',	'{{unknown}}'),
(4582,	1247,	'_oembed_44e2a3c965057fadcae9f186985e2a31',	'{{unknown}}'),
(4579,	1247,	'xyz_fbap',	'1'),
(4581,	1247,	'_oembed_6520e758ebdaf183c18bb3560856333d',	'{{unknown}}'),
(4583,	1247,	'_edit_lock',	'1451447954:1'),
(4584,	1249,	'_edit_last',	'1'),
(4588,	1249,	'_oembed_90467fc781dfdfb76b5fb6e99fda7ded',	'{{unknown}}'),
(4587,	1249,	'xyz_fbap',	'1'),
(4589,	1249,	'_oembed_1a2540ce9a64d5ed7f76639b3fae34e1',	'{{unknown}}'),
(4590,	1249,	'_oembed_97799c8738b98a1742775ccb749f8163',	'{{unknown}}'),
(4591,	1249,	'_edit_lock',	'1451448085:1'),
(4592,	1251,	'_edit_last',	'1'),
(4596,	1251,	'_oembed_c7a68bb1d0f951cd0ec3dd351f7a3ac5',	'{{unknown}}'),
(4599,	1251,	'_edit_lock',	'1451448214:1'),
(4595,	1251,	'xyz_fbap',	'1'),
(4597,	1251,	'_oembed_90cda232f3930a86f4d2cdcb6cf19667',	'{{unknown}}'),
(4598,	1251,	'_oembed_5d2bc627e37a8eb80fd62ac9b7ea6b49',	'{{unknown}}'),
(4600,	1253,	'_edit_last',	'1'),
(4604,	1253,	'_oembed_104cf0d336eabc4b20412eccb550f7b9',	'{{unknown}}'),
(4605,	1253,	'_oembed_85f604ebd37d1aa6b58e03849d0ca8ad',	'{{unknown}}'),
(4603,	1253,	'xyz_fbap',	'1'),
(4606,	1253,	'_oembed_be33db4065d18856c658e4bf339f78a8',	'{{unknown}}'),
(4607,	1253,	'_edit_lock',	'1451448344:1'),
(4608,	1255,	'_edit_last',	'1'),
(4612,	1255,	'_oembed_32f7ca637070c3e63ff54e6cfceca4b4',	'{{unknown}}'),
(4614,	1255,	'_oembed_e5f7fb47f14d64d841cf308071b98997',	'{{unknown}}'),
(4611,	1255,	'xyz_fbap',	'1'),
(4613,	1255,	'_oembed_f28fc77eeda5c1f716874a7d131fae97',	'{{unknown}}'),
(4615,	1255,	'_edit_lock',	'1451448478:1'),
(4616,	1257,	'_edit_last',	'1'),
(4621,	1257,	'_oembed_79ac3f43c02a9202d65380c1b5f911cb',	'{{unknown}}'),
(4619,	1257,	'xyz_fbap',	'1'),
(4620,	1257,	'_edit_lock',	'1451448601:1'),
(4622,	1257,	'_oembed_9665ee5713c449de2918c42ed79579c8',	'{{unknown}}'),
(4623,	1257,	'_oembed_92d3e06ca6a38a38cd5f349f51f10291',	'{{unknown}}'),
(4624,	1259,	'_edit_last',	'1'),
(4628,	1259,	'_oembed_dd3afc9b069c5da0aab0317ded948b42',	'{{unknown}}'),
(4629,	1259,	'_oembed_83d2ad751d1d9ab6b77a95573de01310',	'{{unknown}}'),
(4627,	1259,	'xyz_fbap',	'1'),
(4630,	1259,	'_oembed_ccb4142767b1723c16f36e1a39d1ebdf',	'{{unknown}}'),
(4631,	1259,	'_edit_lock',	'1451448733:1'),
(4632,	1261,	'_edit_last',	'1'),
(4636,	1261,	'_oembed_1665c3392c4d280de31ddac9d756e4fd',	'{{unknown}}'),
(4639,	1261,	'_edit_lock',	'1451448864:1'),
(4635,	1261,	'xyz_fbap',	'1'),
(4637,	1261,	'_oembed_7cf3eef843a1c89712cf54d137b3ea20',	'{{unknown}}'),
(4638,	1261,	'_oembed_7cafea5890c51936264190732dbf4884',	'{{unknown}}'),
(4640,	1263,	'_edit_last',	'1'),
(4644,	1263,	'_oembed_a2d5ebfd3e5fc34a399fa2129d4097bb',	'{{unknown}}'),
(4646,	1263,	'_oembed_b72ec0f668324203269558fef2fb2bd9',	'{{unknown}}'),
(4643,	1263,	'xyz_fbap',	'1'),
(4645,	1263,	'_oembed_f7eace127fbc020fa295e047e295de17',	'{{unknown}}'),
(4647,	1263,	'_edit_lock',	'1451448994:1'),
(4648,	1265,	'_edit_last',	'1'),
(4652,	1265,	'_oembed_0ef63458335050295026e388284716d0',	'{{unknown}}'),
(4655,	1265,	'_edit_lock',	'1451449125:1'),
(4651,	1265,	'xyz_fbap',	'1'),
(4653,	1265,	'_oembed_abadc46720d8ea0afea0c5efbbf3010e',	'{{unknown}}'),
(4654,	1265,	'_oembed_6889e2d2c532595635b245483ff99e14',	'{{unknown}}'),
(4656,	1267,	'_edit_last',	'1'),
(4660,	1267,	'_oembed_b6d070635f26f5345ca557cd7e134e01',	'{{unknown}}'),
(4663,	1267,	'_edit_lock',	'1451449254:1'),
(4659,	1267,	'xyz_fbap',	'1'),
(4661,	1267,	'_oembed_32412136c30516ddd0131da64fdd6b11',	'{{unknown}}'),
(4662,	1267,	'_oembed_7664d6e993d4c024ba5c103cc43c98d4',	'{{unknown}}'),
(4664,	1269,	'_edit_last',	'1'),
(4668,	1269,	'_oembed_cddbbdcc2a9787ffc4b81a7731196d42',	'{{unknown}}'),
(4669,	1269,	'_oembed_32ef5a14f2a45f0cfa3bd8aaf7571713',	'{{unknown}}'),
(4667,	1269,	'xyz_fbap',	'1'),
(4670,	1269,	'_oembed_4d51f64d7b68975997cecfec350cdafd',	'{{unknown}}'),
(4671,	1269,	'_edit_lock',	'1451449387:1'),
(4672,	1271,	'_edit_last',	'1'),
(4676,	1271,	'_oembed_95beef38cd2761fdc77620fe9ed9cd56',	'{{unknown}}'),
(4677,	1271,	'_oembed_76e9acb2414ff4f9da5e973a9385d7dc',	'{{unknown}}'),
(4675,	1271,	'xyz_fbap',	'1'),
(4678,	1271,	'_oembed_d70afdebc3d84d72481dc7ca2ce2eec8',	'{{unknown}}'),
(4679,	1271,	'xyz_twap',	'1'),
(4680,	1271,	'_edit_lock',	'1451449520:1'),
(4681,	1273,	'_edit_last',	'1'),
(4685,	1273,	'_oembed_66926d07ab751aa5e839cfb4a5890f26',	'{{unknown}}'),
(4688,	1273,	'xyz_twap',	'1'),
(4684,	1273,	'xyz_fbap',	'1'),
(4686,	1273,	'_oembed_463c56767d75c2f348690b710fb3318a',	'{{unknown}}'),
(4687,	1273,	'_oembed_0759a6dfb8be43ea9e7efd92dacfe55b',	'{{unknown}}'),
(4689,	1273,	'_edit_lock',	'1451449651:1'),
(4690,	1275,	'_edit_last',	'1'),
(4694,	1275,	'_oembed_e84d5fedd0d2678b8019f5fc0b86b821',	'{{unknown}}'),
(4696,	1275,	'_oembed_0d4887bfdafdfa198388f41dba464251',	'{{unknown}}'),
(4693,	1275,	'xyz_fbap',	'1'),
(4695,	1275,	'_oembed_0b6fe13cd79f75d52d068602e1781a13',	'{{unknown}}'),
(4697,	1275,	'xyz_twap',	'1'),
(4698,	1275,	'_edit_lock',	'1451449780:1'),
(4699,	1277,	'_edit_last',	'1'),
(4703,	1277,	'_oembed_b25c18d4055e53a3a18ed4da4b3399ef',	'{{unknown}}'),
(4705,	1277,	'_oembed_c58c5845abcf45d29c15a4884067f339',	'{{unknown}}'),
(4702,	1277,	'xyz_fbap',	'1'),
(4704,	1277,	'_oembed_635b5d304195748326998aef33b5c70c',	'{{unknown}}'),
(4706,	1277,	'xyz_twap',	'1'),
(4707,	1277,	'_edit_lock',	'1451449957:1'),
(4722,	1279,	'_edit_lock',	'1451450094:1'),
(4714,	1279,	'_edit_last',	'1'),
(4718,	1279,	'_oembed_44b2d8361573cc5470c9b63f1e9cfd81',	'{{unknown}}'),
(4717,	1279,	'xyz_fbap',	'1'),
(4719,	1279,	'_oembed_44760754e8e1e16ccb8f82b55b646ebf',	'{{unknown}}'),
(4720,	1279,	'_oembed_4b1cd795d11635247d75113188b466d5',	'{{unknown}}'),
(4721,	1279,	'xyz_twap',	'1'),
(4740,	1281,	'xyz_twap',	'1'),
(4725,	1280,	'_edit_last',	'1'),
(4733,	1281,	'_edit_last',	'1'),
(4728,	1280,	'xyz_fbap',	'1'),
(4729,	1280,	'_oembed_f38a0923abb05f7d40aa9b55f3c71312',	'{{unknown}}'),
(4730,	1280,	'_oembed_cff6d0d6b0a420daf001f891012f0508',	'{{unknown}}'),
(4731,	1280,	'_oembed_d0145d5ea280decd6df485667437d9e6',	'{{unknown}}'),
(4732,	1280,	'xyz_twap',	'1'),
(4741,	1282,	'_edit_last',	'1'),
(4736,	1281,	'xyz_fbap',	'1'),
(4737,	1281,	'_oembed_2e91764296387a6bceefd51f1b245107',	'{{unknown}}'),
(4738,	1281,	'_oembed_163796903ad4e742725ea4cefc577b56',	'{{unknown}}'),
(4739,	1281,	'_oembed_60c8122196bc34996e5f9da7a80c1441',	'{{unknown}}'),
(4745,	1282,	'_oembed_4a5df6f182e27048f204b6046899b9f7',	'{{unknown}}'),
(4747,	1282,	'_oembed_6d0186475d5b8fa98d73c6b14bbc9dee',	'{{unknown}}'),
(4744,	1282,	'xyz_fbap',	'1'),
(4746,	1282,	'_oembed_fbe4599c6ca92b3521484fa86587a617',	'{{unknown}}'),
(4748,	1282,	'xyz_twap',	'1'),
(4749,	1283,	'_edit_last',	'1'),
(4753,	1283,	'_oembed_bcdc4a46a77b3f3c41912845acb93d85',	'{{unknown}}'),
(4756,	1283,	'xyz_twap',	'1'),
(4752,	1283,	'xyz_fbap',	'1'),
(4754,	1283,	'_oembed_c4a9d64d6d35afef573fc877f69ccb93',	'{{unknown}}'),
(4755,	1283,	'_oembed_bde55c3dee93f8d658147ecdf82db661',	'{{unknown}}'),
(4757,	1283,	'_edit_lock',	'1451450564:1'),
(4764,	1284,	'_oembed_1aebd174e09c2393417bfd08bc19bde0',	'{{unknown}}'),
(4760,	1284,	'_edit_last',	'1'),
(4766,	1284,	'_oembed_5bf75023c33a8c1344bcf2423af2520f',	'{{unknown}}'),
(4763,	1284,	'xyz_fbap',	'1'),
(4765,	1284,	'_oembed_140ef4ca63308fd1d886c3f01ad230ce',	'{{unknown}}'),
(4767,	1284,	'_edit_lock',	'1451450692:1'),
(4768,	1286,	'_edit_last',	'1'),
(4772,	1286,	'_oembed_5a60352954b9ffb521d20e46957cbb9f',	'{{unknown}}'),
(4774,	1286,	'_oembed_794c21d93b9a0b740e4d8a8923ede007',	'{{unknown}}'),
(4771,	1286,	'xyz_fbap',	'1'),
(4773,	1286,	'_oembed_35d41694dbb1fd3381863bee37aa7115',	'{{unknown}}'),
(4775,	1286,	'_edit_lock',	'1451450823:1'),
(4776,	1288,	'_edit_last',	'1'),
(4780,	1288,	'_oembed_6dc00ef60e251bd8326e60e2952187b7',	'{{unknown}}'),
(4781,	1288,	'_oembed_be75499e51914d3bfff106d857e9e3db',	'{{unknown}}'),
(4779,	1288,	'xyz_fbap',	'1'),
(4782,	1288,	'_oembed_a559d149d9e6d30b119645c781021ce5',	'{{unknown}}'),
(4783,	1288,	'_edit_lock',	'1451450978:1'),
(4784,	1288,	'_wpt_short_url',	'http://hotfile.pw/mac/compose-v187-mac-osx.html'),
(4785,	1290,	'_edit_last',	'1'),
(4789,	1290,	'_oembed_89dc5f41165526049a1e81fe1ccdc89c',	'{{unknown}}'),
(4792,	1290,	'_jd_tweet_this',	'yes'),
(4788,	1290,	'xyz_fbap',	'1'),
(4790,	1290,	'_oembed_93419b8d2c09a8351ebfa39683874741',	'{{unknown}}'),
(4791,	1290,	'_oembed_31b35d3aacdc762c8486ba932e03bf91',	'{{unknown}}'),
(4793,	1290,	'_wpt_short_url',	'http://hotfile.pw/magazines/forbes-india-8-january.html'),
(4794,	1290,	'_wp_jd_target',	'http://hotfile.pw/magazines/forbes-india-8-january.html'),
(4795,	1290,	'_jd_wp_twitter',	'a:1:{i:0;s:88:\"New post: Forbes India 8 January http://hotfile.pw/magazines/forbes-india-8-january.html\";}'),
(4796,	1290,	'_wpt_status_message',	'Tweet sent successfully.'),
(4797,	1290,	'_edit_lock',	'1451451084:1'),
(4798,	1288,	'_wp_jd_target',	'http://hotfile.pw/mac/compose-v187-mac-osx.html'),
(4799,	1288,	'_jd_wp_twitter',	'a:1:{i:0;s:81:\"Post Edited: Compose v187 Mac OSX http://hotfile.pw/mac/compose-v187-mac-osx.html\";}'),
(4800,	1288,	'_wpt_status_message',	'Tweet sent successfully.'),
(4801,	1292,	'_edit_last',	'1'),
(4805,	1292,	'_oembed_6c77675bc2d057265aeff21bfdf0a207',	'{{unknown}}'),
(4808,	1292,	'_jd_tweet_this',	'yes'),
(4804,	1292,	'xyz_fbap',	'1'),
(4806,	1292,	'_oembed_420bd671d8b1a8fd2776f7ba71076a30',	'{{unknown}}'),
(4807,	1292,	'_oembed_84d93d1730be8dcd841d19633f229b19',	'{{unknown}}'),
(4809,	1292,	'_wpt_short_url',	'http://hotfile.pw/ebooks/tears-into-wine-j-s-bachs-cantata-21-in-its-musical-and-theological-contexts.html'),
(4810,	1292,	'_wp_jd_target',	'http://hotfile.pw/ebooks/tears-into-wine-j-s-bachs-cantata-21-in-its-musical-and-theological-contexts.html'),
(4811,	1292,	'_jd_wp_twitter',	'a:1:{i:0;s:193:\"New post: Tears into Wine J S Bachs Cantata 21 in its Musical and Theological Contexts http://hotfile.pw/ebooks/tears-into-wine-j-s-bachs-cantata-21-in-its-musical-and-theological-contexts.html\";}'),
(4812,	1292,	'_wpt_status_message',	'Tweet sent successfully.'),
(4813,	1292,	'_edit_lock',	'1451451214:1'),
(4814,	1294,	'_edit_last',	'1'),
(4818,	1294,	'_oembed_cdd64dbe134c65bf855ffbf87242b69a',	'{{unknown}}'),
(4820,	1294,	'_oembed_3d76c354043bb45b1115c5e37f47b093',	'{{unknown}}'),
(4817,	1294,	'xyz_fbap',	'1'),
(4819,	1294,	'_oembed_361f285b1cbd741e5523bd29360bae11',	'{{unknown}}'),
(4821,	1294,	'_jd_tweet_this',	'yes'),
(4822,	1294,	'_wpt_short_url',	'http://hotfile.pw/ebooks/logicbased-methods-for-optimization-combining-optimization-and-constant-satisfac.html'),
(4823,	1294,	'_wp_jd_target',	'http://hotfile.pw/ebooks/logicbased-methods-for-optimization-combining-optimization-and-constant-satisfac.html'),
(4824,	1294,	'_jd_wp_twitter',	'a:1:{i:0;s:204:\"New post: Logicbased Methods for Optimization Combining Optimization and Constant Satisfac… http://hotfile.pw/ebooks/logicbased-methods-for-optimization-combining-optimization-and-constant-satisfac.html\";}'),
(4825,	1294,	'_wpt_status_message',	'Tweet sent successfully.'),
(4826,	1294,	'_edit_lock',	'1451451346:1'),
(4827,	1296,	'_edit_last',	'1'),
(4831,	1296,	'_oembed_7012d2381a54e10f9ae1dfd63f7d63f1',	'{{unknown}}'),
(4834,	1296,	'_jd_tweet_this',	'yes'),
(4830,	1296,	'xyz_fbap',	'1'),
(4832,	1296,	'_oembed_f7489d5bc6cfc6163b19ac333d3b5729',	'{{unknown}}'),
(4833,	1296,	'_oembed_df202eea62b5fed25bd6a18b91219b75',	'{{unknown}}'),
(4835,	1296,	'_wpt_short_url',	'http://hotfile.pw/ebooks/using-accounting-and-financial-information.html'),
(4836,	1296,	'_wp_jd_target',	'http://hotfile.pw/ebooks/using-accounting-and-financial-information.html'),
(4837,	1296,	'_jd_wp_twitter',	'a:1:{i:0;s:125:\"New post: Using Accounting and Financial Information http://hotfile.pw/ebooks/using-accounting-and-financial-information.html\";}'),
(4838,	1296,	'_wpt_status_message',	'Tweet sent successfully.'),
(4839,	1296,	'_edit_lock',	'1451451476:1'),
(4840,	1298,	'_edit_last',	'1'),
(4844,	1298,	'_oembed_2d8ca1f156bcfd8b3ebe7db971f7e3fe',	'{{unknown}}'),
(4845,	1298,	'_oembed_a08c5c18802d04b4f07d61748dac92d8',	'{{unknown}}'),
(4843,	1298,	'xyz_fbap',	'1'),
(4846,	1298,	'_oembed_acdc5b768d520e8abd53426adceef77c',	'{{unknown}}'),
(4847,	1298,	'_jd_tweet_this',	'yes'),
(4848,	1298,	'_wpt_short_url',	'http://hotfile.pw/ebooks/nanoceramics-in-clinical-use-from-materials-to-applications-2-edition.html'),
(4849,	1298,	'_wp_jd_target',	'http://hotfile.pw/ebooks/nanoceramics-in-clinical-use-from-materials-to-applications-2-edition.html'),
(4850,	1298,	'_jd_wp_twitter',	'a:1:{i:0;s:179:\"New post: Nanoceramics in Clinical Use From Materials to Applications 2 edition http://hotfile.pw/ebooks/nanoceramics-in-clinical-use-from-materials-to-applications-2-edition.html\";}'),
(4851,	1298,	'_wpt_status_message',	'Tweet sent successfully.'),
(4852,	1298,	'_edit_lock',	'1451451607:1'),
(4853,	1300,	'_edit_last',	'1'),
(4857,	1300,	'_oembed_6b5235b488504118b1b723523b693694',	'{{unknown}}'),
(4858,	1300,	'_oembed_3d347eb7d980a14e7b326f7622b66e43',	'{{unknown}}'),
(4856,	1300,	'xyz_fbap',	'1'),
(4859,	1300,	'_oembed_7589a4e26579d6a3cc2dcb26bfe90949',	'{{unknown}}'),
(4860,	1300,	'_jd_tweet_this',	'yes'),
(4861,	1300,	'_wpt_short_url',	'http://hotfile.pw/ebooks/late-cretaceouspaleogene-west-antarctica-terrestrial-biota-and-its-intercontinen.html'),
(4862,	1300,	'_wp_jd_target',	'http://hotfile.pw/ebooks/late-cretaceouspaleogene-west-antarctica-terrestrial-biota-and-its-intercontinen.html'),
(4863,	1300,	'_jd_wp_twitter',	'a:1:{i:0;s:204:\"New post: Late CretaceousPaleogene West Antarctica Terrestrial Biota and its Intercontinen… http://hotfile.pw/ebooks/late-cretaceouspaleogene-west-antarctica-terrestrial-biota-and-its-intercontinen.html\";}'),
(4864,	1300,	'_wpt_status_message',	'Tweet sent successfully.'),
(4865,	1300,	'_edit_lock',	'1451451743:1'),
(4866,	1302,	'_edit_last',	'1'),
(4870,	1302,	'_oembed_91a7a577963703081b4dc11ac26c1140',	'{{unknown}}'),
(4873,	1302,	'_jd_tweet_this',	'yes'),
(4869,	1302,	'xyz_fbap',	'1'),
(4871,	1302,	'_oembed_151206ff2d622a0b6fb5ad130bc4da25',	'{{unknown}}'),
(4872,	1302,	'_oembed_ae458f5a0db13a8ef00f331cff6407ec',	'{{unknown}}'),
(4874,	1302,	'_wpt_short_url',	'http://hotfile.pw/ebooks/linear-integral-equations.html'),
(4875,	1302,	'_wp_jd_target',	'http://hotfile.pw/ebooks/linear-integral-equations.html'),
(4876,	1302,	'_jd_wp_twitter',	'a:1:{i:0;s:91:\"New post: Linear Integral Equations http://hotfile.pw/ebooks/linear-integral-equations.html\";}'),
(4877,	1302,	'_wpt_status_message',	'Tweet sent successfully.'),
(4878,	1302,	'_edit_lock',	'1451451875:1'),
(4879,	1304,	'_edit_last',	'1'),
(4883,	1304,	'_oembed_23b7d05cdf6e9a95cbe3e7e7246ffe50',	'{{unknown}}'),
(4884,	1304,	'_oembed_ec2dc4a40fc55404c14a4ab3d3d5eee0',	'{{unknown}}'),
(4882,	1304,	'xyz_fbap',	'1'),
(4885,	1304,	'_oembed_8bd790b265e4719f24c3a00cd671d10e',	'{{unknown}}'),
(4886,	1304,	'_jd_tweet_this',	'yes'),
(4887,	1304,	'_wpt_short_url',	'http://hotfile.pw/ebooks/urban-development-for-the-21st-century-managing-resources-and-creating-infrastru.html'),
(4888,	1304,	'_wp_jd_target',	'http://hotfile.pw/ebooks/urban-development-for-the-21st-century-managing-resources-and-creating-infrastru.html'),
(4889,	1304,	'_jd_wp_twitter',	'a:1:{i:0;s:204:\"New post: Urban Development for the 21st Century Managing Resources and Creating Infrastru… http://hotfile.pw/ebooks/urban-development-for-the-21st-century-managing-resources-and-creating-infrastru.html\";}'),
(4890,	1304,	'_wpt_status_message',	'Tweet sent successfully.'),
(4891,	1304,	'_edit_lock',	'1451452006:1'),
(4892,	1306,	'_edit_last',	'1'),
(4896,	1306,	'_oembed_fb0235998b4e8a3f3817b43d1a7d802e',	'{{unknown}}'),
(4898,	1306,	'_oembed_3a6c9ed606779013feb1e8b4718ab99f',	'{{unknown}}'),
(4895,	1306,	'xyz_fbap',	'1'),
(4897,	1306,	'_oembed_73814d73df20b8778b0a4629c1ed9890',	'{{unknown}}'),
(4899,	1306,	'_jd_tweet_this',	'yes'),
(4900,	1306,	'_wpt_short_url',	'http://hotfile.pw/ebooks/steel-heat-treatment-metallurgy-and-technologies.html'),
(4901,	1306,	'_wp_jd_target',	'http://hotfile.pw/ebooks/steel-heat-treatment-metallurgy-and-technologies.html'),
(4902,	1306,	'_jd_wp_twitter',	'a:1:{i:0;s:137:\"New post: Steel Heat Treatment Metallurgy and Technologies http://hotfile.pw/ebooks/steel-heat-treatment-metallurgy-and-technologies.html\";}'),
(4903,	1306,	'_wpt_status_message',	'Tweet sent successfully.'),
(4904,	1306,	'_edit_lock',	'1451452136:1'),
(4905,	1308,	'_edit_last',	'1'),
(4909,	1308,	'_oembed_5efb6e1f8136fb2c3c077a2d8bd794ea',	'{{unknown}}'),
(4911,	1308,	'_oembed_25d68f2969c0f45f92c0f56e4001f8d9',	'{{unknown}}'),
(4908,	1308,	'xyz_fbap',	'1'),
(4910,	1308,	'_oembed_448854ca937e769721abc6d70c4e571e',	'{{unknown}}'),
(4912,	1308,	'_jd_tweet_this',	'yes'),
(4913,	1308,	'_wpt_short_url',	'http://hotfile.pw/apps/metaproducts-offline-explorer-v704407-multilingual.html'),
(4914,	1308,	'_wp_jd_target',	'http://hotfile.pw/apps/metaproducts-offline-explorer-v704407-multilingual.html'),
(4915,	1308,	'_jd_wp_twitter',	'a:2:{i:0;s:139:\"New post: MetaProducts Offline Explorer v704407 Multilingual http://hotfile.pw/apps/metaproducts-offline-explorer-v704407-multilingual.html\";i:1;s:169:\"Post Edited: MetaProducts Offline Explorer v704407 Multilingual http://hotfile.pw/apps/metaproducts-offline-explorer-v704407-multilingual.html MetaProducts Offline Explo\";}'),
(4916,	1308,	'_wpt_status_message',	'Tweet sent successfully.'),
(4917,	1308,	'_edit_lock',	'1451452271:1'),
(4918,	1310,	'_edit_last',	'1'),
(4922,	1310,	'_oembed_7618f6ebbc8b4f272dda12a6ab6dfb20',	'{{unknown}}'),
(4925,	1310,	'_jd_tweet_this',	'yes'),
(4921,	1310,	'xyz_fbap',	'1'),
(4923,	1310,	'_oembed_b833931e9f521724e2c950472f085054',	'{{unknown}}'),
(4924,	1310,	'_oembed_5fc353b6457432ecc53bce48b99b9223',	'{{unknown}}'),
(4926,	1310,	'_wpt_short_url',	'http://hotfile.pw/apps/cockos-reaper-511-x86x64-portable.html'),
(4927,	1310,	'_wp_jd_target',	'http://hotfile.pw/apps/cockos-reaper-511-x86x64-portable.html'),
(4928,	1310,	'_jd_wp_twitter',	'a:1:{i:0;s:132:\"New post: Cockos Reaper 511 x86x64 Portable http://hotfile.pw/apps/cockos-reaper-511-x86x64-portable.html REAPER is a powerful but s\";}'),
(4929,	1310,	'_wpt_status_message',	'Tweet sent successfully.'),
(4930,	1310,	'_edit_lock',	'1451452402:1'),
(4931,	1312,	'_edit_last',	'1'),
(4935,	1312,	'_oembed_5223bb3e232c22487b4b4b23dd6b22a8',	'{{unknown}}'),
(4937,	1312,	'_oembed_dd276f3737e1d9ee4a5347c480def2e0',	'{{unknown}}'),
(4934,	1312,	'xyz_fbap',	'1'),
(4936,	1312,	'_oembed_dabf6087f5cca715eed7ea87128897b8',	'{{unknown}}'),
(4938,	1312,	'_edit_lock',	'1451452533:1'),
(4939,	1314,	'_edit_last',	'1'),
(4943,	1314,	'_oembed_a5b5a1b4d52b856799979d85f315f48f',	'{{unknown}}'),
(4945,	1314,	'_oembed_2eb7066cee29c7efe2dc45c1ee291b1b',	'{{unknown}}'),
(4942,	1314,	'xyz_fbap',	'1'),
(4944,	1314,	'_oembed_096e92a22cdd5de7d45d5bc2e88b5161',	'{{unknown}}'),
(4946,	1314,	'_edit_lock',	'1451452662:1'),
(4947,	1316,	'_edit_last',	'1'),
(4951,	1316,	'_oembed_e0f58a96add0fdff75ca5b4cc60c313b',	'{{unknown}}'),
(4950,	1316,	'xyz_fbap',	'1'),
(4952,	1316,	'_oembed_1c2fa2d6e1c59294f0a474dd074931d3',	'{{unknown}}'),
(4953,	1316,	'_oembed_379528bc29ef606efb2db91d0195d25d',	'{{unknown}}'),
(4954,	1316,	'_edit_lock',	'1451452792:1'),
(4955,	1318,	'_edit_last',	'1'),
(4959,	1318,	'_oembed_bd68f942d6df29d0850231506fac873b',	'{{unknown}}'),
(4958,	1318,	'xyz_fbap',	'1'),
(4960,	1318,	'_oembed_af5b76822230b0b8e35a3601fde63e55',	'{{unknown}}'),
(4961,	1318,	'_oembed_a4f8ed38169336fa816f277c7cd7ba94',	'{{unknown}}'),
(4962,	1318,	'_edit_lock',	'1451452924:1'),
(4963,	1320,	'_edit_last',	'1'),
(4967,	1320,	'_oembed_f9d9f5755c24899cb82c83aca9679c5b',	'{{unknown}}'),
(4966,	1320,	'xyz_fbap',	'1'),
(4968,	1320,	'_oembed_03b9b9f15979bec00835e5086de0ecd7',	'{{unknown}}'),
(4969,	1320,	'_oembed_8c8a2aaf0d7c4d59bb2703414e89a8ce',	'{{unknown}}'),
(4970,	1320,	'_edit_lock',	'1451453053:1'),
(4971,	1322,	'_edit_last',	'1'),
(4975,	1322,	'_oembed_8015b49639ca50f3df9ccf467617b226',	'{{unknown}}'),
(4978,	1322,	'_jd_tweet_this',	'yes'),
(4974,	1322,	'xyz_fbap',	'1'),
(4976,	1322,	'_oembed_cb0504e666ccafd2cea4c9e46ee3ccfd',	'{{unknown}}'),
(4977,	1322,	'_oembed_8fae7679f5c6a4382b868719122d3c37',	'{{unknown}}'),
(4979,	1322,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/heterogeneous-materials-i-linear-transport-and-optical-properties.html?utm_campaign=twitter&utm_medium=twitter&utm_source=twitter'),
(4980,	1322,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fheterogeneous-materials-i-linear-transport-and-optical-properties.html%3Futm_campaign%3Dtwitter%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(4981,	1322,	'_wptp_twitter_api',	'a:1:{i:0;s:233:\"Newly added: Heterogeneous Materials I Linear Transport and Optical Properties http://hotfile.pw/ebooks/heterogeneous-materials-i-linear-transport-and-optical-properties.html?utm_campaign=twitter&utm_medium=twitter&utm_source=twitter\";}'),
(4982,	1322,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(4983,	1322,	'_edit_lock',	'1451453733:1'),
(4984,	1324,	'_edit_last',	'1'),
(4988,	1324,	'_oembed_b95695983b8886caf3c8f6f05db9d746',	'{{unknown}}'),
(4990,	1324,	'_oembed_2f73b18c83abdeebca07dbc0442455c9',	'{{unknown}}'),
(4987,	1324,	'xyz_fbap',	'1'),
(4989,	1324,	'_oembed_47d765ca3da7f29fe77e36f2afdee32f',	'{{unknown}}'),
(4991,	1324,	'_jd_tweet_this',	'yes'),
(4992,	1324,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/higher-recursion-theory.html?utm_campaign=twitter&utm_medium=twitter&utm_source=twitter'),
(4993,	1324,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fhigher-recursion-theory.html%3Futm_campaign%3Dtwitter%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(4994,	1324,	'_wptp_twitter_api',	'a:1:{i:0;s:149:\"Newly added: Higher Recursion Theory http://hotfile.pw/ebooks/higher-recursion-theory.html?utm_campaign=twitter&utm_medium=twitter&utm_source=twitter\";}'),
(4995,	1324,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(4996,	1324,	'_edit_lock',	'1451453320:1'),
(4997,	1326,	'_edit_last',	'1'),
(5001,	1326,	'_oembed_bc53290f6ec381e4d151a548a2346470',	'{{unknown}}'),
(5002,	1326,	'_oembed_30f092e0c9cfcf48a7cbd4bba15598f4',	'{{unknown}}'),
(5000,	1326,	'xyz_fbap',	'1'),
(5003,	1326,	'_oembed_ab25880164954f9faae7b82ec20c95fc',	'{{unknown}}'),
(5004,	1326,	'atap_auto_post',	'no'),
(5005,	1326,	'_edit_lock',	'1451453449:1'),
(5006,	1328,	'_edit_last',	'1'),
(5010,	1328,	'_oembed_59664dcb2193b045e5e591392ac326b6',	'{{unknown}}'),
(5012,	1328,	'_oembed_d50b975911a42827d6748ab97f92f00d',	'{{unknown}}'),
(5009,	1328,	'xyz_fbap',	'1'),
(5011,	1328,	'_oembed_7a7e5e933e269197e07baddf58dc18be',	'{{unknown}}'),
(5013,	1328,	'atap_auto_post',	'no'),
(5014,	1328,	'_edit_lock',	'1451453578:1'),
(5015,	1330,	'_edit_last',	'1'),
(5019,	1330,	'_oembed_dd3fdf5883cea8ce174d9ae98de6fca6',	'{{unknown}}'),
(5020,	1330,	'_oembed_c1d9136f127559a0c5e5cdc59b3a705a',	'{{unknown}}'),
(5018,	1330,	'xyz_fbap',	'1'),
(5021,	1330,	'_oembed_1a2d15285d0ed4f0fd159bb50bcb5d06',	'{{unknown}}'),
(5022,	1330,	'_edit_lock',	'1451453816:1'),
(5044,	1334,	'_edit_last',	'1'),
(5026,	1332,	'_edit_last',	'1'),
(5025,	1330,	'xyz_smap',	'1'),
(5041,	1333,	'_oembed_93d3eb530defe04dd0a47a30822aa3c2',	'{{unknown}}'),
(5029,	1332,	'xyz_fbap',	'1'),
(5030,	1332,	'_oembed_792d61dc464e5498de51dc9f660aee96',	'{{unknown}}'),
(5031,	1332,	'_oembed_dfc5ee173406232b386b2adc4f3a1241',	'{{unknown}}'),
(5032,	1332,	'_oembed_5529d4a34afce9e433fae60e9b91a045',	'{{unknown}}'),
(5033,	1332,	'xyz_smap',	'1'),
(5034,	1332,	'_edit_lock',	'1451457486:1'),
(5037,	1333,	'_edit_last',	'1'),
(5040,	1333,	'xyz_smap',	'1'),
(5042,	1333,	'_oembed_73f5fc0510d397f7472081c263df8d0e',	'{{unknown}}'),
(5043,	1333,	'_oembed_2505106199db4c8c9c9763ee6699333c',	'{{unknown}}'),
(5048,	1334,	'_oembed_daada3b551da2d232781295a46d31f8c',	'{{unknown}}'),
(5049,	1334,	'_oembed_d4d4ed9009a0e086f8804118191c3b47',	'{{unknown}}'),
(5047,	1334,	'xyz_fbap',	'1'),
(5050,	1334,	'_oembed_5dc0d1bae9c769fbbc33cb19dbe6b2b3',	'{{unknown}}'),
(5051,	1334,	'xyz_smap',	'1'),
(5052,	1335,	'_edit_last',	'1'),
(5056,	1335,	'_oembed_d6830a81a56a649252e79182c63c4673',	'{{unknown}}'),
(5059,	1336,	'_edit_last',	'1'),
(5055,	1335,	'xyz_smap',	'1'),
(5057,	1335,	'_oembed_eaa6b835a1970bb64b082f93bc7f1826',	'{{unknown}}'),
(5058,	1335,	'_oembed_279d19ea16731ecffbd194effd6b1daf',	'{{unknown}}'),
(5063,	1336,	'_oembed_7d7ad9588b0551e40fc6248d2a6ceb65',	'{{unknown}}'),
(5062,	1336,	'xyz_smap',	'1'),
(5064,	1336,	'_oembed_a8f3fa9db20cda0cf5c5b4a2c81980e5',	'{{unknown}}'),
(5065,	1336,	'_oembed_e6503abc5e53c510d999605ee688faa5',	'{{unknown}}'),
(5066,	1337,	'_edit_last',	'1'),
(5070,	1337,	'_oembed_0f040506dd45a7b433410257f03b1d7e',	'{{unknown}}'),
(5069,	1337,	'xyz_smap',	'1'),
(5071,	1337,	'_oembed_ad4664dc76be0d87291b97b41012325d',	'{{unknown}}'),
(5072,	1337,	'_oembed_635fb925aab30bd91f4f5c8a54415c80',	'{{unknown}}'),
(5073,	1338,	'_edit_last',	'1'),
(5077,	1338,	'_oembed_6f74ca44c794078322db1cb6d7a1d898',	'{{unknown}}'),
(5076,	1338,	'xyz_smap',	'1'),
(5078,	1338,	'_oembed_650c66d855b28cebc7f744be7a04d997',	'{{unknown}}'),
(5079,	1338,	'_oembed_b3aba6cd6ed6a6c8ae12bdf52c508af1',	'{{unknown}}'),
(5080,	1339,	'_edit_last',	'1'),
(5084,	1339,	'_oembed_cbe1a048e2ab114c0c468c33bd4d318a',	'{{unknown}}'),
(5086,	1339,	'_oembed_2df1e09e7cf67816aae403196f08a21e',	'{{unknown}}'),
(5083,	1339,	'xyz_fbap',	'1'),
(5085,	1339,	'_oembed_740a2713f1a0b9cd583de992a28d26e1',	'{{unknown}}'),
(5087,	1339,	'_edit_lock',	'1451454714:1'),
(5088,	1341,	'_edit_last',	'1'),
(5092,	1341,	'_oembed_303c850b0a2d419f3b911d1c28063344',	'{{unknown}}'),
(5095,	1341,	'atap_auto_post',	'no'),
(5091,	1341,	'xyz_fbap',	'1'),
(5093,	1341,	'_oembed_5a4c971cded0f6c2a0d9b4eba759cdee',	'{{unknown}}'),
(5094,	1341,	'_oembed_56c2c0c83c9440f67a5e448b8e37add4',	'{{unknown}}'),
(5096,	1341,	'_edit_lock',	'1451454847:1'),
(5097,	1343,	'_edit_last',	'1'),
(5101,	1343,	'_oembed_b0a2fa1063d4b4f9301162f4ff44faa3',	'{{unknown}}'),
(5103,	1343,	'_oembed_c52188f4a76ac9cd6be069094a598a0f',	'{{unknown}}'),
(5100,	1343,	'xyz_fbap',	'1'),
(5102,	1343,	'_oembed_fc4bd31e41660c9099b28dfd4de155fd',	'{{unknown}}'),
(5104,	1343,	'_jd_tweet_this',	'yes'),
(5105,	1343,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-dynamics-of-global-sourcing-perspectives-and-practices.html?utm_campaign=twitter&utm_medium=twitter&utm_source=twitter'),
(5106,	1343,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-dynamics-of-global-sourcing-perspectives-and-practices.html%3Futm_campaign%3Dtwitter%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5107,	1343,	'_wptp_twitter_api',	'a:1:{i:0;s:219:\"Newly added: The Dynamics of Global Sourcing Perspectives and Practices http://hotfile.pw/ebooks/the-dynamics-of-global-sourcing-perspectives-and-practices.html?utm_campaign=twitter&utm_medium=twitter&utm_source=twitter\";}'),
(5108,	1343,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5109,	1343,	'_edit_lock',	'1451454976:1'),
(5110,	1345,	'_edit_last',	'1'),
(5114,	1345,	'_oembed_fb38bf688b058d6a60058b614b87f302',	'{{unknown}}'),
(5117,	1345,	'_jd_tweet_this',	'yes'),
(5113,	1345,	'xyz_fbap',	'1'),
(5115,	1345,	'_oembed_58f29cd4035ebab1469f7a385addfb3e',	'{{unknown}}'),
(5116,	1345,	'_oembed_88b54756893cbc3c26446822509026e5',	'{{unknown}}'),
(5118,	1345,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-side-dish-handbook-featuring-40-recipes-and-expert-tips-for-your-favorite-in.html?utm_campaign=twitter&utm_medium=twitter&utm_source=twitter'),
(5119,	1345,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-side-dish-handbook-featuring-40-recipes-and-expert-tips-for-your-favorite-in.html%3Futm_campaign%3Dtwitter%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5120,	1345,	'_wptp_twitter_api',	'a:1:{i:0;s:280:\"The Side Dish Handbook Featuring 40 recipes and expert tips for your favorite in... http://hotfile.pw/ebooks/the-side-dish-handbook-featuring-40-recipes-and-expert-tips-for-your-favorite-in.html?utm_campaign=twitter&utm_medium=twitter&utm_source=twitter English | Apr. 7, 2015 | I\";}'),
(5121,	1345,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5122,	1345,	'_edit_lock',	'1451455107:1'),
(5123,	1347,	'_edit_last',	'1'),
(5127,	1347,	'_oembed_fbcdd46206d6166e0a029cde4a284561',	'{{unknown}}'),
(5128,	1347,	'_oembed_6dee97bfbfe8d9da8b819d29a395080a',	'{{unknown}}'),
(5126,	1347,	'xyz_fbap',	'1'),
(5129,	1347,	'_oembed_5d81cbe397517310e773aac19639506b',	'{{unknown}}'),
(5130,	1347,	'_jd_tweet_this',	'yes'),
(5131,	1347,	'_wp_jd_wp',	'http://hotfile.pw/apps/antiporn-233121.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5132,	1347,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fapps%2Fantiporn-233121.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5133,	1347,	'_wpt_failed',	'a:5:{s:6:\"author\";b:0;s:8:\"sentence\";s:138:\"AntiPorn 233121 http://hotfile.pw/apps/antiporn-233121.html?utm_campaign=&utm_medium=twitter&utm_source=twitter The Internet turned parent\";s:5:\"error\";s:50:\"This account is not authorized to post to Twitter.\";s:4:\"code\";i:401;s:9:\"timestamp\";i:1451455234;}'),
(5134,	1347,	'_wptp_status_notifier',	'This account is not authorized to post to Twitter.'),
(5135,	1347,	'_edit_lock',	'1451455234:1'),
(5136,	1349,	'_edit_last',	'1'),
(5140,	1349,	'_oembed_1b9f7d430d5f1138c40ee72a4457201b',	'{{unknown}}'),
(5141,	1349,	'_oembed_46ac23a119540fe063102bdbab1b4f84',	'{{unknown}}'),
(5139,	1349,	'xyz_fbap',	'1'),
(5142,	1349,	'_oembed_07bce2e928ea87f648ce61accf1bc316',	'{{unknown}}'),
(5143,	1349,	'_jd_tweet_this',	'yes'),
(5144,	1349,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/nutritional-care-of-the-patient-with-gastrointestinal-disease.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5145,	1349,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fnutritional-care-of-the-patient-with-gastrointestinal-disease.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5146,	1349,	'_wpt_failed',	'a:5:{s:6:\"author\";b:0;s:8:\"sentence\";s:231:\"Nutritional Care of the Patient with Gastrointestinal Disease http://hotfile.pw/ebooks/nutritional-care-of-the-patient-with-gastrointestinal-disease.html?utm_campaign=&utm_medium=twitter&utm_source=twitter 2016 | ISBN: 1482226030 |\";s:5:\"error\";s:50:\"This account is not authorized to post to Twitter.\";s:4:\"code\";i:401;s:9:\"timestamp\";i:1451455364;}'),
(5147,	1349,	'_wptp_status_notifier',	'This account is not authorized to post to Twitter.'),
(5148,	1349,	'_edit_lock',	'1451455364:1'),
(5149,	1351,	'_edit_last',	'1'),
(5153,	1351,	'_oembed_9e712e34104b4cff4663b32005a07c41',	'{{unknown}}'),
(5156,	1351,	'_jd_tweet_this',	'yes'),
(5152,	1351,	'xyz_fbap',	'1'),
(5154,	1351,	'_oembed_29b1ffbfb93eb43590e04d3b118d39e7',	'{{unknown}}'),
(5155,	1351,	'_oembed_d4adaf14604eacac8eea18fc3abd335f',	'{{unknown}}'),
(5157,	1351,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/god-and-race-in-american-politics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5158,	1351,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fgod-and-race-in-american-politics.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5159,	1351,	'_wpt_failed',	'a:5:{s:6:\"author\";b:0;s:8:\"sentence\";s:176:\"God and Race in American Politics http://hotfile.pw/ebooks/god-and-race-in-american-politics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter English | 7 Sept. 2008 | I\";s:5:\"error\";s:50:\"This account is not authorized to post to Twitter.\";s:4:\"code\";i:401;s:9:\"timestamp\";i:1451455493;}'),
(5160,	1351,	'_wptp_status_notifier',	'This account is not authorized to post to Twitter.'),
(5161,	1351,	'_edit_lock',	'1451455493:1'),
(5162,	1353,	'_edit_last',	'1'),
(5166,	1353,	'_oembed_536f3fd414ac647e694a98e4808ad5f7',	'{{unknown}}'),
(5167,	1353,	'_oembed_d2b7c57cf89ed1e744caa6e42c63c7dd',	'{{unknown}}'),
(5165,	1353,	'xyz_fbap',	'1'),
(5168,	1353,	'_oembed_f021674c9dae0eec9a21bca97e152b90',	'{{unknown}}'),
(5169,	1353,	'_jd_tweet_this',	'yes'),
(5170,	1353,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/animal-oppression-and-human-violence-domesecration-capitalism-and-global-conflic.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5171,	1353,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fanimal-oppression-and-human-violence-domesecration-capitalism-and-global-conflic.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5172,	1353,	'_wpt_failed',	'a:5:{s:6:\"author\";b:0;s:8:\"sentence\";s:273:\"Animal Oppression and Human Violence Domesecration Capitalism and Global Conflic... http://hotfile.pw/ebooks/animal-oppression-and-human-violence-domesecration-capitalism-and-global-conflic.html?utm_campaign=&utm_medium=twitter&utm_source=twitter Publisher: Columbia Univer\";s:5:\"error\";s:50:\"This account is not authorized to post to Twitter.\";s:4:\"code\";i:401;s:9:\"timestamp\";i:1451455622;}'),
(5173,	1353,	'_wptp_status_notifier',	'This account is not authorized to post to Twitter.'),
(5174,	1353,	'_edit_lock',	'1451455622:1'),
(5175,	1355,	'_edit_last',	'1'),
(5179,	1355,	'_oembed_894dee78dc90f59596e29e122e52f897',	'{{unknown}}'),
(5182,	1355,	'_jd_tweet_this',	'yes'),
(5178,	1355,	'xyz_fbap',	'1'),
(5180,	1355,	'_oembed_7c24a856d112e2ccfc5c4716a812373e',	'{{unknown}}'),
(5181,	1355,	'_oembed_658342f7d34d58b132a8dcb98eea93fb',	'{{unknown}}'),
(5183,	1355,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-arrhythmic-patient-in-the-emergency-department.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5184,	1355,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-arrhythmic-patient-in-the-emergency-department.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5185,	1355,	'_wpt_failed',	'a:5:{s:6:\"author\";b:0;s:8:\"sentence\";s:210:\"The Arrhythmic Patient in the Emergency Department http://hotfile.pw/ebooks/the-arrhythmic-patient-in-the-emergency-department.html?utm_campaign=&utm_medium=twitter&utm_source=twitter Springer | Cardiology & An\";s:5:\"error\";s:50:\"This account is not authorized to post to Twitter.\";s:4:\"code\";i:401;s:9:\"timestamp\";i:1451455754;}'),
(5186,	1355,	'_wptp_status_notifier',	'This account is not authorized to post to Twitter.'),
(5187,	1355,	'_edit_lock',	'1451455754:1'),
(5188,	1357,	'_edit_last',	'1'),
(5192,	1357,	'_oembed_503ead4c70ac886ba0893d36878435a5',	'{{unknown}}'),
(5195,	1357,	'_jd_tweet_this',	'yes'),
(5191,	1357,	'xyz_fbap',	'1'),
(5193,	1357,	'_oembed_a802755025960d6b84d8df9650253e7f',	'{{unknown}}'),
(5194,	1357,	'_oembed_8afaad572214f7ca8e1d8e70e5f49839',	'{{unknown}}'),
(5196,	1357,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/enhancing-the-managerial-dna-of-your-small-business.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5197,	1357,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fenhancing-the-managerial-dna-of-your-small-business.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5198,	1357,	'_wpt_failed',	'a:5:{s:6:\"author\";b:0;s:8:\"sentence\";s:212:\"Enhancing the Managerial DNA of Your Small Business http://hotfile.pw/ebooks/enhancing-the-managerial-dna-of-your-small-business.html?utm_campaign=&utm_medium=twitter&utm_source=twitter English | 2014 | ISBN: 160\";s:5:\"error\";s:50:\"This account is not authorized to post to Twitter.\";s:4:\"code\";i:401;s:9:\"timestamp\";i:1451455883;}'),
(5199,	1357,	'_wptp_status_notifier',	'This account is not authorized to post to Twitter.'),
(5200,	1357,	'_edit_lock',	'1451455883:1'),
(5201,	1359,	'_edit_last',	'1'),
(5205,	1359,	'_oembed_ea460c7823341ee1ff59a26a9fb1f546',	'{{unknown}}'),
(5206,	1359,	'_oembed_f613ecd6c99c1dc8fbec7e5cb0df4171',	'{{unknown}}'),
(5204,	1359,	'xyz_fbap',	'1'),
(5207,	1359,	'_oembed_77f48fbc4e9e4b09028330d99bdcbde5',	'{{unknown}}'),
(5208,	1359,	'_jd_tweet_this',	'yes'),
(5209,	1359,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/encyclopedia-of-asylum-therapeutics-17501950s.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5210,	1359,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fencyclopedia-of-asylum-therapeutics-17501950s.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5211,	1359,	'_wpt_failed',	'a:5:{s:6:\"author\";b:0;s:8:\"sentence\";s:198:\"Encyclopedia of Asylum Therapeutics 17501950s http://hotfile.pw/ebooks/encyclopedia-of-asylum-therapeutics-17501950s.html?utm_campaign=&utm_medium=twitter&utm_source=twitter 2015 | 377 Pages | ISBN:\";s:5:\"error\";s:50:\"This account is not authorized to post to Twitter.\";s:4:\"code\";i:401;s:9:\"timestamp\";i:1451456013;}'),
(5212,	1359,	'_wptp_status_notifier',	'This account is not authorized to post to Twitter.'),
(5213,	1359,	'_edit_lock',	'1451456013:1'),
(5214,	1361,	'_edit_last',	'1'),
(5231,	1363,	'_oembed_0c24dca8194b608511a6681e56979a7a',	'{{unknown}}'),
(5227,	1363,	'_edit_last',	'1'),
(5217,	1361,	'xyz_fbap',	'1'),
(5218,	1361,	'_oembed_f45d4cb7938a9072643cd4f3c4bb8efd',	'{{unknown}}'),
(5219,	1361,	'_oembed_f4a05647ed11ba5460d9f605dd7150d9',	'{{unknown}}'),
(5220,	1361,	'_oembed_5e3a3145d387b177ce2279e080b87aa1',	'{{unknown}}'),
(5221,	1361,	'_jd_tweet_this',	'yes'),
(5222,	1361,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/chai-the-spice-tea-of-india.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5223,	1361,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fchai-the-spice-tea-of-india.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5224,	1361,	'_wpt_failed',	'a:5:{s:6:\"author\";b:0;s:8:\"sentence\";s:164:\"Chai The Spice Tea of India http://hotfile.pw/ebooks/chai-the-spice-tea-of-india.html?utm_campaign=&utm_medium=twitter&utm_source=twitter English | Jan. 5, 1999 | I\";s:5:\"error\";s:50:\"This account is not authorized to post to Twitter.\";s:4:\"code\";i:401;s:9:\"timestamp\";i:1451456143;}'),
(5225,	1361,	'_wptp_status_notifier',	'This account is not authorized to post to Twitter.'),
(5226,	1361,	'_edit_lock',	'1451456143:1'),
(5232,	1363,	'_oembed_cb6543e206da4d8367a7ffbd0f17154e',	'{{unknown}}'),
(5230,	1363,	'xyz_fbap',	'1'),
(5233,	1363,	'_oembed_ec3aad9d85e33d3c39b98f399604e0e8',	'{{unknown}}'),
(5234,	1363,	'_jd_tweet_this',	'yes'),
(5235,	1363,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/celebrity-philanthropy.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5236,	1363,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcelebrity-philanthropy.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5237,	1363,	'_wpt_failed',	'a:5:{s:6:\"author\";b:0;s:8:\"sentence\";s:154:\"Celebrity Philanthropy http://hotfile.pw/ebooks/celebrity-philanthropy.html?utm_campaign=&utm_medium=twitter&utm_source=twitter English | ISBN: 1783204826\";s:5:\"error\";s:50:\"This account is not authorized to post to Twitter.\";s:4:\"code\";i:401;s:9:\"timestamp\";i:1451456272;}'),
(5238,	1363,	'_wptp_status_notifier',	'This account is not authorized to post to Twitter.'),
(5239,	1363,	'_edit_lock',	'1451456272:1'),
(5240,	1365,	'_edit_last',	'1'),
(5244,	1365,	'_oembed_51058abf5b21590a1ba7399534e25127',	'{{unknown}}'),
(5246,	1365,	'_oembed_2f8c69ce97449bb0ffff5ebcfa7d8613',	'{{unknown}}'),
(5243,	1365,	'xyz_fbap',	'1'),
(5245,	1365,	'_oembed_ee497fa40c990b2dc388e916cf3a0b45',	'{{unknown}}'),
(5247,	1365,	'_jd_tweet_this',	'yes'),
(5248,	1365,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/monitoring-docker.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5249,	1365,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fmonitoring-docker.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5250,	1365,	'_wpt_failed',	'a:5:{s:6:\"author\";b:0;s:8:\"sentence\";s:144:\"Monitoring Docker http://hotfile.pw/ebooks/monitoring-docker.html?utm_campaign=&utm_medium=twitter&utm_source=twitter English | Jan. 6, 2016 | I\";s:5:\"error\";s:50:\"This account is not authorized to post to Twitter.\";s:4:\"code\";i:401;s:9:\"timestamp\";i:1451456401;}'),
(5251,	1365,	'_wptp_status_notifier',	'This account is not authorized to post to Twitter.'),
(5252,	1365,	'_edit_lock',	'1451456401:1'),
(5253,	1367,	'_edit_last',	'1'),
(5257,	1367,	'_oembed_c6f9d4de83576ac01e4292015ba85fb2',	'{{unknown}}'),
(5258,	1367,	'_oembed_b36da201aea013d48060d657bc90e22c',	'{{unknown}}'),
(5256,	1367,	'xyz_fbap',	'1'),
(5259,	1367,	'_oembed_7feee3860bec1e35bce908ca2915595f',	'{{unknown}}'),
(5260,	1367,	'_jd_tweet_this',	'yes'),
(5261,	1367,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/symbolic-computation-number-theory-special-functions-physics-and-combinatorics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5262,	1367,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fsymbolic-computation-number-theory-special-functions-physics-and-combinatorics.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5263,	1367,	'_wpt_failed',	'a:5:{s:6:\"author\";b:0;s:8:\"sentence\";s:267:\"Symbolic Computation Number Theory Special Functions Physics and Combinatorics http://hotfile.pw/ebooks/symbolic-computation-number-theory-special-functions-physics-and-combinatorics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter Published: 2001-11-30 | ISB\";s:5:\"error\";s:50:\"This account is not authorized to post to Twitter.\";s:4:\"code\";i:401;s:9:\"timestamp\";i:1451456533;}'),
(5264,	1367,	'_wptp_status_notifier',	'This account is not authorized to post to Twitter.'),
(5265,	1367,	'_edit_lock',	'1451456533:1'),
(5266,	1369,	'_edit_last',	'1'),
(5270,	1369,	'_oembed_a2b3236b769eb3bbca3e1723149fab58',	'{{unknown}}'),
(5271,	1369,	'_oembed_111049e6cc31b1ef0d45317da2dde415',	'{{unknown}}'),
(5269,	1369,	'xyz_fbap',	'1'),
(5272,	1369,	'_oembed_bfb331796bc608b7f322fc4bb880b945',	'{{unknown}}'),
(5273,	1369,	'_jd_tweet_this',	'yes'),
(5274,	1369,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-columbia-history-of-western-philosophy.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5275,	1369,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-columbia-history-of-western-philosophy.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5276,	1369,	'_wptp_twitter_api',	'a:1:{i:0;s:167:\"The Columbia History of Western Philosophy http://hotfile.pw/ebooks/the-columbia-history-of-western-philosophy.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5277,	1369,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5278,	1369,	'_edit_lock',	'1451456664:1'),
(23739,	4089,	'_wptp_twitter_api',	'a:1:{i:0;s:129:\"WPMudev Fundraising v262 http://hotfile.pw/misc/wpmudev-fundraising-v262.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(23737,	4089,	'_wp_jd_wp',	'http://hotfile.pw/misc/wpmudev-fundraising-v262.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(23738,	4089,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmisc%2Fwpmudev-fundraising-v262.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(23733,	4089,	'_oembed_c32e1115b09079aa4e00ed68e5dc6713',	'{{unknown}}'),
(23734,	4089,	'_oembed_b464c106e12bbd148fbd3a585898ae80',	'{{unknown}}'),
(23735,	4089,	'_oembed_accac4d1fb84dd777214e4324d8f9904',	'{{unknown}}'),
(23731,	4089,	'xyz_fbap',	'1'),
(23732,	4089,	'_oembed_7241102a8b38a49d6679e0892a8a3c58',	'{{unknown}}'),
(23736,	4089,	'_jd_tweet_this',	'yes'),
(23728,	4089,	'_edit_last',	'1'),
(5292,	1373,	'_edit_last',	'1'),
(5296,	1373,	'_oembed_e67a587405e28a7708c7f55d8d73c2dc',	'{{unknown}}'),
(5298,	1373,	'_oembed_db353e1ca7b4cc472d0c9d3efd593e37',	'{{unknown}}'),
(5295,	1373,	'xyz_fbap',	'1'),
(5297,	1373,	'_oembed_a1afad06a031244a4872f55fcf735a77',	'{{unknown}}'),
(5299,	1373,	'_jd_tweet_this',	'yes'),
(5300,	1373,	'_wp_jd_wp',	'http://hotfile.pw/magazines/girl-magazine-dezembro.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5301,	1373,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmagazines%2Fgirl-magazine-dezembro.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5302,	1373,	'_wptp_twitter_api',	'a:1:{i:0;s:130:\"Girl Magazine Dezembro http://hotfile.pw/magazines/girl-magazine-dezembro.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5303,	1373,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5304,	1373,	'_edit_lock',	'1451456931:1'),
(5305,	1375,	'_edit_last',	'1'),
(5309,	1375,	'_oembed_607fcba3925eca7d51b84ff08bd7745b',	'{{unknown}}'),
(5312,	1375,	'_jd_tweet_this',	'yes'),
(5308,	1375,	'xyz_fbap',	'1'),
(5310,	1375,	'_oembed_65fe1ef38e5d9f1ddce3b4a90b11a9f7',	'{{unknown}}'),
(5311,	1375,	'_oembed_3238d19c2f504b95c7a76b94a949b9c8',	'{{unknown}}'),
(5313,	1375,	'_wp_jd_wp',	'http://hotfile.pw/magazines/aerospace-america-january.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5314,	1375,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmagazines%2Faerospace-america-january.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5315,	1375,	'_wptp_twitter_api',	'a:1:{i:0;s:136:\"Aerospace America January http://hotfile.pw/magazines/aerospace-america-january.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5316,	1375,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5317,	1375,	'_edit_lock',	'1451457064:1'),
(5318,	1377,	'_edit_last',	'1'),
(5322,	1377,	'_oembed_c3b287f312734802f415d7ca77916b61',	'{{unknown}}'),
(5324,	1377,	'_oembed_ca4aa9482ac7eb7de8fc9bec93763808',	'{{unknown}}'),
(5321,	1377,	'xyz_fbap',	'1'),
(5323,	1377,	'_oembed_024a6facfe4d54f0d0605d546fe0ff0d',	'{{unknown}}'),
(5325,	1377,	'_jd_tweet_this',	'yes'),
(5326,	1377,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/a-students-guide-to-the-history-and-philosophy-of-yoga.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5327,	1377,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fa-students-guide-to-the-history-and-philosophy-of-yoga.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5328,	1377,	'_wptp_twitter_api',	'a:1:{i:0;s:191:\"A Students Guide to the History and Philosophy of Yoga http://hotfile.pw/ebooks/a-students-guide-to-the-history-and-philosophy-of-yoga.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5329,	1377,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5330,	1377,	'_edit_lock',	'1451457194:1'),
(5331,	1379,	'_edit_last',	'1'),
(5335,	1379,	'_oembed_354c23cb2e3136ebc35c97492e7784d3',	'{{unknown}}'),
(5338,	1379,	'_jd_tweet_this',	'yes'),
(5334,	1379,	'xyz_fbap',	'1'),
(5336,	1379,	'_oembed_8d29aeba26e790bb2c42238bbe581d6b',	'{{unknown}}'),
(5337,	1379,	'_oembed_408c86ce46458f192e4b07e833fba028',	'{{unknown}}'),
(5339,	1379,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/absence-of-arbitrage-valuation.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5340,	1379,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fabsence-of-arbitrage-valuation.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5341,	1379,	'_wptp_twitter_api',	'a:1:{i:0;s:143:\"Absence of Arbitrage Valuation http://hotfile.pw/ebooks/absence-of-arbitrage-valuation.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5342,	1379,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5343,	1379,	'_edit_lock',	'1451457323:1'),
(5344,	1381,	'_edit_last',	'1'),
(5348,	1381,	'_oembed_5aa00bef6a87ad3da788e6b53e84795c',	'{{unknown}}'),
(5350,	1381,	'_oembed_d43004638192e21044fa01df27026434',	'{{unknown}}'),
(5347,	1381,	'xyz_fbap',	'1'),
(5349,	1381,	'_oembed_b7db6c24f23a77e03429776e5f0858e8',	'{{unknown}}'),
(5351,	1381,	'_jd_tweet_this',	'yes'),
(5352,	1381,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/civil-war-wests-testing-the-limits-of-the-united-states.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5353,	1381,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcivil-war-wests-testing-the-limits-of-the-united-states.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5354,	1381,	'_wptp_twitter_api',	'a:1:{i:0;s:193:\"Civil War Wests Testing the Limits of the United States http://hotfile.pw/ebooks/civil-war-wests-testing-the-limits-of-the-united-states.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5355,	1381,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5356,	1381,	'_edit_lock',	'1451457453:1'),
(5357,	1383,	'_edit_last',	'1'),
(5361,	1383,	'_oembed_6e55223d5fb9ca93f364966e645247d6',	'{{unknown}}'),
(5363,	1383,	'_oembed_37b8a59b0d67578cfa2e4c8dba2bbfcb',	'{{unknown}}'),
(5360,	1383,	'xyz_fbap',	'1'),
(5362,	1383,	'_oembed_5d508115b2b45a5f3e0d9cd4cfa91999',	'{{unknown}}'),
(5364,	1383,	'_jd_tweet_this',	'yes'),
(5365,	1383,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/art-and-the-religious-image-in-el-grecos-italy.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5366,	1383,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fart-and-the-religious-image-in-el-grecos-italy.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5367,	1383,	'_wptp_twitter_api',	'a:1:{i:0;s:175:\"Art and the Religious Image in El Grecos Italy http://hotfile.pw/ebooks/art-and-the-religious-image-in-el-grecos-italy.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5368,	1383,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5369,	1383,	'_edit_lock',	'1451457582:1'),
(5370,	1385,	'_edit_last',	'1'),
(5374,	1385,	'_oembed_5ca118737167137b2e3c2251228da20e',	'{{unknown}}'),
(5376,	1385,	'_oembed_1d2817dba4880b4e136fa6241869e2c5',	'{{unknown}}'),
(5373,	1385,	'xyz_fbap',	'1'),
(5375,	1385,	'_oembed_1a6b60f49ac5018d7755bb941ac54f3e',	'{{unknown}}'),
(5377,	1385,	'_jd_tweet_this',	'yes'),
(5378,	1385,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/brain-brilliance-amazing-lessons-on-how-to-improve-memory-blazingly-fast-and-fin.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5379,	1385,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fbrain-brilliance-amazing-lessons-on-how-to-improve-memory-blazingly-fast-and-fin.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5380,	1385,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"Brain Brilliance Amazing Lessons on How to Improve Memory Blazingly Fast and Fin... http://hotfile.pw/ebooks/brain-brilliance-amazing-lessons-on-how-to-improve-memory-blazingly-fast-and-fin.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5381,	1385,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5382,	1385,	'_edit_lock',	'1451457713:1'),
(5383,	1387,	'_edit_last',	'1'),
(5387,	1387,	'_oembed_f7cbf2a46a6228b9f1ea4f329faa86ca',	'{{unknown}}'),
(5388,	1387,	'_oembed_e924926e8401527976751e009532ac42',	'{{unknown}}'),
(5386,	1387,	'xyz_fbap',	'1'),
(5389,	1387,	'_oembed_cd2ac2c5942bfcab751aa375181cc2d2',	'{{unknown}}'),
(5390,	1387,	'_jd_tweet_this',	'yes'),
(5391,	1387,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/stochastic-differential-equations-an-introduction-with-applications-5th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5392,	1387,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fstochastic-differential-equations-an-introduction-with-applications-5th-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5393,	1387,	'_wptp_twitter_api',	'a:1:{i:0;s:241:\"Stochastic Differential Equations An Introduction with Applications 5th edition http://hotfile.pw/ebooks/stochastic-differential-equations-an-introduction-with-applications-5th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5394,	1387,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5395,	1387,	'_edit_lock',	'1451457848:1'),
(5396,	1389,	'_edit_last',	'1'),
(5400,	1389,	'_oembed_abe3b4da70318ba5fef01bcdb996b585',	'{{unknown}}'),
(5401,	1389,	'_oembed_0e5881d5e8b5a382b69a89c66a8a1bc7',	'{{unknown}}'),
(5399,	1389,	'xyz_fbap',	'1'),
(5402,	1389,	'_oembed_5db0a9e343c86b8f67a67375688d9195',	'{{unknown}}'),
(5403,	1389,	'_jd_tweet_this',	'yes'),
(5404,	1389,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-battle-of-hastings-sources-and-interpretations-warfare-in-history.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5405,	1389,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-battle-of-hastings-sources-and-interpretations-warfare-in-history.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5406,	1389,	'_wptp_twitter_api',	'a:1:{i:0;s:221:\"The Battle of Hastings Sources and Interpretations Warfare in History http://hotfile.pw/ebooks/the-battle-of-hastings-sources-and-interpretations-warfare-in-history.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5407,	1389,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5408,	1389,	'_edit_lock',	'1451457981:1'),
(5409,	1391,	'_edit_last',	'1'),
(5413,	1391,	'_oembed_030f4076034480828d1aad278829d6e1',	'{{unknown}}'),
(5416,	1391,	'_jd_tweet_this',	'yes'),
(5412,	1391,	'xyz_fbap',	'1'),
(5414,	1391,	'_oembed_5e5941d585dbd57fbc352c348934b0c7',	'{{unknown}}'),
(5415,	1391,	'_oembed_76d4697118210259e154c59644f08de9',	'{{unknown}}'),
(5417,	1391,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/comparative-perspectives-on-judaisms-and-jewish-identities.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5418,	1391,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcomparative-perspectives-on-judaisms-and-jewish-identities.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5419,	1391,	'_wptp_twitter_api',	'a:1:{i:0;s:199:\"Comparative Perspectives on Judaisms and Jewish Identities http://hotfile.pw/ebooks/comparative-perspectives-on-judaisms-and-jewish-identities.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5420,	1391,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5421,	1391,	'_edit_lock',	'1451458112:1'),
(5422,	1393,	'_edit_last',	'1'),
(5426,	1393,	'_oembed_92a87ec0985fc9f18fd06a86d3189fbc',	'{{unknown}}'),
(5428,	1393,	'_oembed_6221082842814ef4190b8c48e9d40ce5',	'{{unknown}}'),
(5425,	1393,	'xyz_fbap',	'1'),
(5427,	1393,	'_oembed_b3cb4394ec3598850301c2db2c7903cc',	'{{unknown}}'),
(5429,	1393,	'_jd_tweet_this',	'yes'),
(5430,	1393,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/love-drugs.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5431,	1393,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Flove-drugs.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5432,	1393,	'_wptp_twitter_api',	'a:1:{i:0;s:103:\"Love Drugs http://hotfile.pw/ebooks/love-drugs.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5433,	1393,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5434,	1393,	'_edit_lock',	'1451458245:1'),
(5435,	1395,	'_edit_last',	'1'),
(5439,	1395,	'_oembed_d25403ab43b86569c30470d2efe988ce',	'{{unknown}}'),
(5441,	1395,	'_oembed_c1758d22cd18bc44c21debfb15f306ec',	'{{unknown}}'),
(5438,	1395,	'xyz_fbap',	'1'),
(5440,	1395,	'_oembed_c35dcccdfe83f5142917df0ff628d911',	'{{unknown}}'),
(5442,	1395,	'_jd_tweet_this',	'yes'),
(5443,	1395,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/fundamentals-of-fluid-mechanics-student-solutions-manual.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5444,	1395,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Ffundamentals-of-fluid-mechanics-student-solutions-manual.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5445,	1395,	'_wptp_twitter_api',	'a:1:{i:0;s:195:\"Fundamentals of Fluid Mechanics Student Solutions Manual http://hotfile.pw/ebooks/fundamentals-of-fluid-mechanics-student-solutions-manual.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5446,	1395,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5447,	1395,	'_edit_lock',	'1451458380:1'),
(5448,	1397,	'_edit_last',	'1'),
(5452,	1397,	'_oembed_0c214d656d243c5fb0f90dda04b070fe',	'{{unknown}}'),
(5454,	1397,	'_oembed_b794f516e6073f9fc194191c65f60f1a',	'{{unknown}}'),
(5451,	1397,	'xyz_fbap',	'1'),
(5453,	1397,	'_oembed_62d1312f124ecdd76286bae6a65be1a7',	'{{unknown}}'),
(5455,	1397,	'_jd_tweet_this',	'yes'),
(5456,	1397,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/imidazole-dipeptides-chemistry-analysis-function-and-effects.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5457,	1397,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fimidazole-dipeptides-chemistry-analysis-function-and-effects.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5458,	1397,	'_wptp_twitter_api',	'a:1:{i:0;s:203:\"Imidazole Dipeptides Chemistry Analysis Function and Effects http://hotfile.pw/ebooks/imidazole-dipeptides-chemistry-analysis-function-and-effects.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5459,	1397,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5460,	1397,	'_edit_lock',	'1451458512:1'),
(5461,	1399,	'_edit_last',	'1'),
(5465,	1399,	'_oembed_9c15e9f5684cacc0c48bbe7115498ae5',	'{{unknown}}'),
(5467,	1399,	'_oembed_be8ddd9dce228e3827560816d9e40ba9',	'{{unknown}}'),
(5464,	1399,	'xyz_fbap',	'1'),
(5466,	1399,	'_oembed_301062f33dd09a0ea7dc7c7214e10d2e',	'{{unknown}}'),
(5468,	1399,	'_jd_tweet_this',	'yes'),
(5469,	1399,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/introducing-baudrillard.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5470,	1399,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fintroducing-baudrillard.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5471,	1399,	'_wptp_twitter_api',	'a:1:{i:0;s:129:\"Introducing Baudrillard http://hotfile.pw/ebooks/introducing-baudrillard.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5472,	1399,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5473,	1399,	'_edit_lock',	'1451458644:1'),
(5474,	1401,	'_edit_last',	'1'),
(5478,	1401,	'_oembed_39d610e1fb52b2ca66df88fb33c9cce3',	'{{unknown}}'),
(5481,	1401,	'_jd_tweet_this',	'yes'),
(5477,	1401,	'xyz_fbap',	'1'),
(5479,	1401,	'_oembed_76709642fd58468b837c2e32a432a367',	'{{unknown}}'),
(5480,	1401,	'_oembed_5b5becb13221bfeca146571434c850fb',	'{{unknown}}'),
(5482,	1401,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/value-investing-today.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5483,	1401,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fvalue-investing-today.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5484,	1401,	'_wptp_twitter_api',	'a:1:{i:0;s:125:\"Value Investing Today http://hotfile.pw/ebooks/value-investing-today.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5485,	1401,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5486,	1401,	'_edit_lock',	'1451458774:1'),
(5487,	1403,	'_edit_last',	'1'),
(5491,	1403,	'_oembed_6d137c9add9da91d7593f8e4353be7a5',	'{{unknown}}'),
(5493,	1403,	'_oembed_e9a3a5551a859757425d1ba98adadd69',	'{{unknown}}'),
(5490,	1403,	'xyz_fbap',	'1'),
(5492,	1403,	'_oembed_24bf3a1fa4eaed42d74c64ae96513bcc',	'{{unknown}}'),
(5494,	1403,	'_jd_tweet_this',	'yes'),
(5495,	1403,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/dry-docking-and-shipboard-maintenance-a-guide-for-industry-2nd-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5496,	1403,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fdry-docking-and-shipboard-maintenance-a-guide-for-industry-2nd-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5497,	1403,	'_wptp_twitter_api',	'a:1:{i:0;s:223:\"Dry Docking and Shipboard Maintenance A Guide for Industry 2nd edition http://hotfile.pw/ebooks/dry-docking-and-shipboard-maintenance-a-guide-for-industry-2nd-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5498,	1403,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5499,	1403,	'_edit_lock',	'1451458906:1'),
(5500,	1405,	'_edit_last',	'1'),
(5504,	1405,	'_oembed_d8db837d3c72a7b6838b5727f8ec7cb7',	'{{unknown}}'),
(5506,	1405,	'_oembed_64fcfda7b2f6b40b7ef39dd33f82773b',	'{{unknown}}'),
(5503,	1405,	'xyz_fbap',	'1'),
(5505,	1405,	'_oembed_1c902aa8b713124290222e3a95956a6f',	'{{unknown}}'),
(5507,	1405,	'_jd_tweet_this',	'yes'),
(5508,	1405,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/dragon-professional-individual-for-dummies-for-dummies-computertech.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5509,	1405,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fdragon-professional-individual-for-dummies-for-dummies-computertech.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5510,	1405,	'_wptp_twitter_api',	'a:1:{i:0;s:217:\"Dragon Professional Individual For Dummies For Dummies ComputerTech http://hotfile.pw/ebooks/dragon-professional-individual-for-dummies-for-dummies-computertech.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5511,	1405,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5512,	1405,	'_edit_lock',	'1451459036:1'),
(5513,	1407,	'_edit_last',	'1'),
(5517,	1407,	'_oembed_16930d5ff5b4532a7483aae3c5d897f7',	'{{unknown}}'),
(5519,	1407,	'_oembed_56ea82e9dc8c2d1ebeec47d06b3fc29c',	'{{unknown}}'),
(5516,	1407,	'xyz_fbap',	'1'),
(5518,	1407,	'_oembed_1d4c44aa7e717de87cfbfc8545de82a4',	'{{unknown}}'),
(5520,	1407,	'_jd_tweet_this',	'yes'),
(5521,	1407,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/macroeconomics-understanding-the-wealth-of-nations.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5522,	1407,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fmacroeconomics-understanding-the-wealth-of-nations.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5523,	1407,	'_wptp_twitter_api',	'a:1:{i:0;s:183:\"Macroeconomics Understanding The Wealth Of Nations http://hotfile.pw/ebooks/macroeconomics-understanding-the-wealth-of-nations.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5524,	1407,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5525,	1407,	'_edit_lock',	'1451459167:1'),
(5526,	1409,	'_edit_last',	'1'),
(5530,	1409,	'_oembed_9d8c9aed2d354be523edac8efa725cb3',	'{{unknown}}'),
(5532,	1409,	'_oembed_19e6e7204c07dcd87339108831ed1c00',	'{{unknown}}'),
(5529,	1409,	'xyz_fbap',	'1'),
(5531,	1409,	'_oembed_83483cd403a29706e6b103c861a7fde7',	'{{unknown}}'),
(5533,	1409,	'_jd_tweet_this',	'yes'),
(5534,	1409,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/patis-mexican-table-the-secrets-of-real-mexican-home-cooking.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5535,	1409,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fpatis-mexican-table-the-secrets-of-real-mexican-home-cooking.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5536,	1409,	'_wptp_twitter_api',	'a:1:{i:0;s:203:\"Patis Mexican Table The Secrets of Real Mexican Home Cooking http://hotfile.pw/ebooks/patis-mexican-table-the-secrets-of-real-mexican-home-cooking.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5537,	1409,	'_wptp_status_notifier',	'403 Forbidden: The request is understood, but has been refused by Twitter. Possible reasons: too many Tweets, same Tweet submitted twice, Tweet longer than 140 characters.'),
(5538,	1409,	'_edit_lock',	'1451460725:1'),
(5539,	1411,	'_edit_last',	'1'),
(5543,	1411,	'_oembed_394ff1c1e2dd716aa5a681e8aa0d4a87',	'{{unknown}}'),
(5545,	1411,	'_oembed_230048be60f350a627062ea532a5a0c4',	'{{unknown}}'),
(5542,	1411,	'xyz_fbap',	'1'),
(5544,	1411,	'_oembed_f9103817bb8bc4b5f60c7fc4d27de992',	'{{unknown}}'),
(5546,	1411,	'_jd_tweet_this',	'yes'),
(5547,	1411,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/coal-production-and-processing-technology.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5548,	1411,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcoal-production-and-processing-technology.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5549,	1411,	'_wptp_twitter_api',	'a:1:{i:0;s:165:\"Coal Production and Processing Technology http://hotfile.pw/ebooks/coal-production-and-processing-technology.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5550,	1411,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5551,	1411,	'_edit_lock',	'1451459431:1'),
(5552,	1413,	'_edit_last',	'1'),
(5556,	1413,	'_oembed_d92b79be0ada01ef7aaad7628154ba13',	'{{unknown}}'),
(5557,	1413,	'_oembed_2605fb1f837abc7b6d1910becf5e37dd',	'{{unknown}}'),
(5555,	1413,	'xyz_fbap',	'1'),
(5558,	1413,	'_oembed_dee83d810b683c433d968c439566d31f',	'{{unknown}}'),
(5559,	1413,	'_jd_tweet_this',	'yes'),
(5560,	1413,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/lonely-planet-myanmar-burma-travel-guide.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5561,	1413,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Flonely-planet-myanmar-burma-travel-guide.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5562,	1413,	'_wptp_twitter_api',	'a:1:{i:0;s:163:\"Lonely Planet Myanmar Burma Travel Guide http://hotfile.pw/ebooks/lonely-planet-myanmar-burma-travel-guide.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5563,	1413,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5564,	1413,	'_edit_lock',	'1451459563:1'),
(5571,	1415,	'_edit_last',	'1'),
(5588,	1417,	'_oembed_64c6889b3aa7b7a8a6c0ebe5d9f18819',	'{{unknown}}'),
(5568,	1409,	'pin_manual',	'automatic'),
(5569,	1409,	'_wptp_twitter_data',	''),
(5570,	1409,	'_wpt_failed',	'a:5:{s:6:\"author\";b:0;s:8:\"sentence\";s:203:\"Patis Mexican Table The Secrets of Real Mexican Home Cooking http://hotfile.pw/ebooks/patis-mexican-table-the-secrets-of-real-mexican-home-cooking.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";s:5:\"error\";s:171:\"403 Forbidden: The request is understood, but has been refused by Twitter. Possible reasons: too many Tweets, same Tweet submitted twice, Tweet longer than 140 characters.\";s:4:\"code\";i:403;s:9:\"timestamp\";i:1451459648;}'),
(5584,	1417,	'_edit_last',	'1'),
(5574,	1415,	'xyz_fbap',	'1'),
(5575,	1415,	'_oembed_8f53e98ae940aafd3f77fdc0588aabfa',	'{{unknown}}'),
(5576,	1415,	'_oembed_6ff5fd95643c303d146dffb67e7b4742',	'{{unknown}}'),
(5577,	1415,	'_oembed_c226971300a6dddaa084770d1ac7bedf',	'{{unknown}}'),
(5578,	1415,	'_jd_tweet_this',	'yes'),
(5579,	1415,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/lapd-53.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5580,	1415,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Flapd-53.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5581,	1415,	'_wptp_twitter_api',	'a:1:{i:0;s:97:\"LAPD 53 http://hotfile.pw/ebooks/lapd-53.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5582,	1415,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5583,	1415,	'_edit_lock',	'1451459695:1'),
(5591,	1417,	'_jd_tweet_this',	'yes'),
(5587,	1417,	'xyz_fbap',	'1'),
(5589,	1417,	'_oembed_91fd86c9e1f16c42cf2951d3c219ce3e',	'{{unknown}}'),
(5590,	1417,	'_oembed_7484973ea6e748339c3f5b92621b944e',	'{{unknown}}'),
(5592,	1417,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/toxicology-survival-and-health-hazards-of-combustion-products.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5593,	1417,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Ftoxicology-survival-and-health-hazards-of-combustion-products.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5594,	1417,	'_wptp_twitter_api',	'a:1:{i:0;s:205:\"Toxicology Survival and Health Hazards of Combustion Products http://hotfile.pw/ebooks/toxicology-survival-and-health-hazards-of-combustion-products.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5595,	1417,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5596,	1417,	'_edit_lock',	'1451459826:1'),
(5597,	1419,	'_edit_last',	'1'),
(5601,	1419,	'_oembed_52a7332756e7b84fd3c326060b070392',	'{{unknown}}'),
(5602,	1419,	'_oembed_9c04534fac0916f882840a238c8bb72b',	'{{unknown}}'),
(5600,	1419,	'xyz_fbap',	'1'),
(5603,	1419,	'_oembed_8483f8f799c3d1b171be3638cd3b6914',	'{{unknown}}'),
(5604,	1419,	'_jd_tweet_this',	'yes'),
(5605,	1419,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/macroeconomic-methodology-a-postkeynesian-perspective.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5606,	1419,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fmacroeconomic-methodology-a-postkeynesian-perspective.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5607,	1419,	'_wptp_twitter_api',	'a:1:{i:0;s:189:\"Macroeconomic Methodology A PostKeynesian Perspective http://hotfile.pw/ebooks/macroeconomic-methodology-a-postkeynesian-perspective.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5608,	1419,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5609,	1419,	'_edit_lock',	'1451459958:1'),
(5610,	1421,	'_edit_last',	'1'),
(5614,	1421,	'_oembed_bed2d4ece773233de4b1b84dc1412f26',	'{{unknown}}'),
(5615,	1421,	'_oembed_4883b1277ca6495bf56296494651cbe9',	'{{unknown}}'),
(5613,	1421,	'xyz_fbap',	'1'),
(5616,	1421,	'_oembed_faed610f7e14df2d3be6f6a58d6a39df',	'{{unknown}}'),
(5617,	1421,	'_jd_tweet_this',	'yes'),
(5618,	1421,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/filemaker-pro-11-the-missing-manual.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5619,	1421,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Ffilemaker-pro-11-the-missing-manual.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5620,	1421,	'_wptp_twitter_api',	'a:1:{i:0;s:153:\"FileMaker Pro 11 The Missing Manual http://hotfile.pw/ebooks/filemaker-pro-11-the-missing-manual.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5621,	1421,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5622,	1421,	'_edit_lock',	'1451460088:1'),
(5623,	1423,	'_edit_last',	'1'),
(5627,	1423,	'_oembed_6f4e79cc064ea06dc08ee5dd924e8517',	'{{unknown}}'),
(5628,	1423,	'_oembed_bd3559bd705a564e6891b115897fb099',	'{{unknown}}'),
(5626,	1423,	'xyz_fbap',	'1'),
(5629,	1423,	'_oembed_7ca852ce3c749ca15aab6f0f36a9b959',	'{{unknown}}'),
(5630,	1423,	'_jd_tweet_this',	'yes'),
(5631,	1423,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/cold-war-in-psychiatry-human-factors-secret-actors.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5632,	1423,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcold-war-in-psychiatry-human-factors-secret-actors.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5633,	1423,	'_wptp_twitter_api',	'a:1:{i:0;s:183:\"Cold War in Psychiatry Human Factors Secret Actors http://hotfile.pw/ebooks/cold-war-in-psychiatry-human-factors-secret-actors.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5634,	1423,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5635,	1423,	'_edit_lock',	'1451460220:1'),
(5636,	1425,	'_edit_last',	'1'),
(5640,	1425,	'_oembed_3785d90be96a229bd255aed8262fc9de',	'{{unknown}}'),
(5642,	1425,	'_oembed_316aab28acc517b3f1b784e7b599882f',	'{{unknown}}'),
(5639,	1425,	'xyz_fbap',	'1'),
(5641,	1425,	'_oembed_17f0ec66f22dfe7f4ee4d5c811956c74',	'{{unknown}}'),
(5643,	1425,	'_jd_tweet_this',	'yes'),
(5644,	1425,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/a-history-of-the-korean-language.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5645,	1425,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fa-history-of-the-korean-language.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5646,	1425,	'_wptp_twitter_api',	'a:1:{i:0;s:147:\"A History of the Korean Language http://hotfile.pw/ebooks/a-history-of-the-korean-language.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5647,	1425,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5648,	1425,	'_edit_lock',	'1451460351:1'),
(5649,	1427,	'_edit_last',	'1'),
(5653,	1427,	'_oembed_7fbe3c5d03a0e34def377369eac62fb2',	'{{unknown}}'),
(5655,	1427,	'_oembed_8080212e6f2386177cd1cee421f4588d',	'{{unknown}}'),
(5652,	1427,	'xyz_fbap',	'1'),
(5654,	1427,	'_oembed_1acc11e6b06c2765fa2b02997ee756b6',	'{{unknown}}'),
(5656,	1427,	'_jd_tweet_this',	'yes'),
(5657,	1427,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/cold-war-radio-the-dangerous-history-of-american-broadcasting-in-europe-19501989.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5658,	1427,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcold-war-radio-the-dangerous-history-of-american-broadcasting-in-europe-19501989.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5659,	1427,	'_wptp_twitter_api',	'a:1:{i:0;s:243:\"Cold War Radio The Dangerous History of American Broadcasting in Europe 19501989 http://hotfile.pw/ebooks/cold-war-radio-the-dangerous-history-of-american-broadcasting-in-europe-19501989.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5660,	1427,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5661,	1427,	'_edit_lock',	'1451460482:1'),
(5662,	1429,	'_edit_last',	'1'),
(5666,	1429,	'_oembed_9547b744267f998eb1242ec743935346',	'{{unknown}}'),
(5669,	1429,	'_jd_tweet_this',	'yes'),
(5665,	1429,	'xyz_fbap',	'1'),
(5667,	1429,	'_oembed_918aa915d405bc2c7b258d984bee3d5b',	'{{unknown}}'),
(5668,	1429,	'_oembed_caf366bb4a3c176b7c17bc51a5b6dddc',	'{{unknown}}'),
(5670,	1429,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/discounted-life-the-price-of-global-surrogacy-in-india.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5671,	1429,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fdiscounted-life-the-price-of-global-surrogacy-in-india.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5672,	1429,	'_wptp_twitter_api',	'a:1:{i:0;s:191:\"Discounted Life The Price of Global Surrogacy in India http://hotfile.pw/ebooks/discounted-life-the-price-of-global-surrogacy-in-india.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5673,	1429,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5674,	1429,	'_edit_lock',	'1451460615:1'),
(5675,	1431,	'_edit_last',	'1'),
(5679,	1431,	'_oembed_59a626dc21e236492ad0fd8464d40068',	'{{unknown}}'),
(5682,	1431,	'_jd_tweet_this',	'yes'),
(5678,	1431,	'xyz_fbap',	'1'),
(5680,	1431,	'_oembed_355514d7fcb7c44bc9edcf205490efad',	'{{unknown}}'),
(5681,	1431,	'_oembed_ae18396c3aa0d4dab8ac0694d3f78506',	'{{unknown}}'),
(5683,	1431,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/alternative-fuels-the-future-of-hydrogen-third-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5684,	1431,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Falternative-fuels-the-future-of-hydrogen-third-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5685,	1431,	'_wptp_twitter_api',	'a:1:{i:0;s:191:\"Alternative Fuels The Future of Hydrogen Third Edition http://hotfile.pw/ebooks/alternative-fuels-the-future-of-hydrogen-third-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5686,	1431,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5687,	1431,	'_edit_lock',	'1451460744:1'),
(23747,	4091,	'_oembed_386bc07b826383ac0015dfccd0b4bc02',	'{{unknown}}'),
(23745,	4091,	'xyz_fbap',	'1'),
(23741,	4089,	'_edit_lock',	'1451695121:1'),
(23742,	4091,	'_edit_last',	'1'),
(23746,	4091,	'_oembed_9b1fc862ac3dbb18306291aabdb3b4d3',	'{{unknown}}'),
(23750,	4091,	'_jd_tweet_this',	'yes'),
(23727,	4087,	'_edit_lock',	'1451694991:1'),
(18201,	3306,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(18202,	3306,	'_edit_lock',	'1451642724:1'),
(18200,	3306,	'_wptp_twitter_api',	'a:1:{i:0;s:127:\"TechHit QuickJump 14374 http://hotfile.pw/apps/techhit-quickjump-14374.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(18199,	3306,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fapps%2Ftechhit-quickjump-14374.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5701,	1435,	'_edit_last',	'1'),
(5704,	1435,	'xyz_fbap',	'1'),
(5705,	1435,	'_oembed_c2d22dcd60ad3b70de0c95a8f652c8e5',	'{{unknown}}'),
(5706,	1435,	'_oembed_994f90d809ed9b6259aaeee7f837c64c',	'{{unknown}}'),
(5707,	1435,	'_oembed_1860ca7d9ad5f7b4fd7b49d0623665f1',	'{{unknown}}'),
(5708,	1435,	'_jd_tweet_this',	'yes'),
(5709,	1435,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/heterogeneous-photocatalysis.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5710,	1435,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fheterogeneous-photocatalysis.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5711,	1435,	'_wptp_twitter_api',	'a:1:{i:0;s:139:\"Heterogeneous Photocatalysis http://hotfile.pw/ebooks/heterogeneous-photocatalysis.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5712,	1435,	'_wptp_status_notifier',	'403 Forbidden: The request is understood, but has been refused by Twitter. Possible reasons: too many Tweets, same Tweet submitted twice, Tweet longer than 140 characters.'),
(5713,	1435,	'_edit_lock',	'1451461491:1'),
(5721,	1437,	'_edit_last',	'1'),
(5738,	1439,	'_oembed_9ba116fb6ff44a12ec3e0543bf8be560',	'{{unknown}}'),
(18198,	3306,	'_wp_jd_wp',	'http://hotfile.pw/apps/techhit-quickjump-14374.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(18188,	3304,	'_edit_lock',	'1451642592:1'),
(18189,	3306,	'_edit_last',	'1'),
(18193,	3306,	'_oembed_054beaedd7619d4e44887793d14a8376',	'{{unknown}}'),
(18196,	3306,	'_oembed_e63214c6cd2b86db9b1beafe27e40fd8',	'{{unknown}}'),
(18192,	3306,	'xyz_fbap',	'1'),
(18194,	3306,	'_oembed_594fed2587db29d932e7b1dba7395b4a',	'{{unknown}}'),
(18195,	3306,	'_oembed_0103577068c170b05f5d76ad69ef4cfe',	'{{unknown}}'),
(18197,	3306,	'_jd_tweet_this',	'yes'),
(5734,	1439,	'_edit_last',	'1'),
(5724,	1437,	'xyz_fbap',	'1'),
(5725,	1437,	'_oembed_0ae811e72023fc21b78509a403cf465a',	'{{unknown}}'),
(5726,	1437,	'_oembed_8793356eef9e6c9f78b5baf5e52ff2c2',	'{{unknown}}'),
(5727,	1437,	'_oembed_35e3dc7f87512f5d1f7dbb867b104054',	'{{unknown}}'),
(5728,	1437,	'_jd_tweet_this',	'yes'),
(5729,	1437,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/black-decker-the-complete-guide-to-plumbing-6th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5730,	1437,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fblack-decker-the-complete-guide-to-plumbing-6th-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5731,	1437,	'_wptp_twitter_api',	'a:1:{i:0;s:193:\"Black Decker The Complete Guide to Plumbing 6th edition http://hotfile.pw/ebooks/black-decker-the-complete-guide-to-plumbing-6th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5732,	1437,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5733,	1437,	'_edit_lock',	'1451460910:1'),
(5740,	1439,	'_oembed_6784a1b9a3637cce05b079b079c73c1a',	'{{unknown}}'),
(5737,	1439,	'xyz_fbap',	'1'),
(5739,	1439,	'_oembed_b53f18677f927397861be99712a14aa4',	'{{unknown}}'),
(5741,	1439,	'_jd_tweet_this',	'yes'),
(5742,	1439,	'_wp_jd_wp',	'http://hotfile.pw/magazines/model-rail-january.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5743,	1439,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmagazines%2Fmodel-rail-january.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5744,	1439,	'_wptp_twitter_api',	'a:1:{i:0;s:122:\"Model Rail January http://hotfile.pw/magazines/model-rail-january.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5745,	1439,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5746,	1439,	'_edit_lock',	'1451461138:1'),
(5747,	1441,	'_edit_last',	'1'),
(5751,	1441,	'_oembed_97cb8985b7d65369cf899063f9256e24',	'{{unknown}}'),
(5754,	1441,	'_jd_tweet_this',	'yes'),
(5750,	1441,	'xyz_fbap',	'1'),
(5752,	1441,	'_oembed_e4f045b754898b461a01a4bad06c6bb3',	'{{unknown}}'),
(5753,	1441,	'_oembed_7e40e5b2da2cf24f815d3df05e2be58a',	'{{unknown}}'),
(5755,	1441,	'_wp_jd_wp',	'http://hotfile.pw/magazines/science-vie-janvier.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5756,	1441,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmagazines%2Fscience-vie-janvier.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5757,	1441,	'_wptp_twitter_api',	'a:1:{i:0;s:124:\"Science Vie Janvier http://hotfile.pw/magazines/science-vie-janvier.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5758,	1441,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5759,	1441,	'_edit_lock',	'1451461268:1'),
(5760,	1443,	'_edit_last',	'1'),
(5764,	1443,	'_oembed_4641c17ac5840ccec0df4073453413b6',	'{{unknown}}'),
(5767,	1443,	'_jd_tweet_this',	'yes'),
(5763,	1443,	'xyz_fbap',	'1'),
(5765,	1443,	'_oembed_d522c45c440432ffde67bc5879d21c4f',	'{{unknown}}'),
(5766,	1443,	'_oembed_2a708591a404c9c9096c11f4563f707d',	'{{unknown}}'),
(5768,	1443,	'_wp_jd_wp',	'http://hotfile.pw/magazines/columbia-business-times-january.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5769,	1443,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmagazines%2Fcolumbia-business-times-january.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5770,	1443,	'_wptp_twitter_api',	'a:1:{i:0;s:148:\"Columbia Business Times January http://hotfile.pw/magazines/columbia-business-times-january.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5771,	1443,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5772,	1443,	'_edit_lock',	'1451461398:1'),
(5773,	1445,	'_edit_last',	'1'),
(5777,	1445,	'_oembed_9fa5797a83c6e6e564ec71d82822e204',	'{{unknown}}'),
(5780,	1445,	'_jd_tweet_this',	'yes'),
(5776,	1445,	'xyz_fbap',	'1'),
(5778,	1445,	'_oembed_4eaf3982067274ff15cd8bb1af5aecf9',	'{{unknown}}'),
(5779,	1445,	'_oembed_adb0dd16f7c8691ace478e265ee3a1bd',	'{{unknown}}'),
(5781,	1445,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/structural-dynamics-theory-and-computation-5th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5782,	1445,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fstructural-dynamics-theory-and-computation-5th-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5783,	1445,	'_wptp_twitter_api',	'a:1:{i:0;s:191:\"Structural Dynamics Theory and Computation 5th edition http://hotfile.pw/ebooks/structural-dynamics-theory-and-computation-5th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5784,	1445,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5785,	1445,	'_edit_lock',	'1451461529:1'),
(5792,	1447,	'_edit_last',	'1'),
(5789,	1435,	'pin_manual',	'automatic'),
(5790,	1435,	'_wptp_twitter_data',	''),
(5791,	1435,	'_wpt_failed',	'a:5:{s:6:\"author\";b:0;s:8:\"sentence\";s:139:\"Heterogeneous Photocatalysis http://hotfile.pw/ebooks/heterogeneous-photocatalysis.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";s:5:\"error\";s:171:\"403 Forbidden: The request is understood, but has been refused by Twitter. Possible reasons: too many Tweets, same Tweet submitted twice, Tweet longer than 140 characters.\";s:4:\"code\";i:403;s:9:\"timestamp\";i:1451461617;}'),
(5799,	1447,	'_edit_lock',	'1451461618:1'),
(5795,	1447,	'xyz_fbap',	'1'),
(5796,	1447,	'_oembed_ed1ba6439e3d9c19ee51a636330fce41',	'{{unknown}}'),
(5797,	1447,	'_oembed_55407177440a94cdf24ce7969235dfcd',	'{{unknown}}'),
(5798,	1447,	'_oembed_ef19c906257831e7f67c63a45ace36d9',	'{{unknown}}'),
(5825,	1449,	'xyz_fbap',	'1'),
(5829,	1449,	'_jd_tweet_this',	'yes'),
(5835,	1451,	'_edit_last',	'1'),
(5803,	1447,	'pin_manual',	'automatic'),
(5804,	1447,	'_wptp_twitter_data',	''),
(5805,	1447,	'_jd_tweet_this',	'yes'),
(5806,	1447,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/routing-protocols-and-concepts-ccna-exploration-labs-and-study-guide.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5807,	1447,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Frouting-protocols-and-concepts-ccna-exploration-labs-and-study-guide.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5808,	1447,	'_wptp_twitter_api',	'a:1:{i:0;s:219:\"Routing Protocols and Concepts CCNA Exploration Labs and Study Guide http://hotfile.pw/ebooks/routing-protocols-and-concepts-ccna-exploration-labs-and-study-guide.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5809,	1447,	'_wptp_status_notifier',	'Yo already tweeted this. Twitter requires all Tweets to be unique.'),
(5822,	1449,	'_edit_last',	'1'),
(5848,	1453,	'_edit_last',	'1'),
(5826,	1449,	'_oembed_908e4c1ba070a1d71fbd60d9e8d253b5',	'{{unknown}}'),
(5827,	1449,	'_oembed_7f62981be4f19b54008930ad23821513',	'{{unknown}}'),
(5813,	1447,	'pin_text',	'{Downloads|GET|free} [post_title]'),
(5814,	1447,	'pin_board',	'487303690869683346'),
(5815,	1447,	'pin_alt',	'a:2:{i:0;s:0:\"\";i:1;s:68:\"Routing Protocols and Concepts CCNA Exploration Labs and Study Guide\";}'),
(5816,	1447,	'pin_index',	'a:2:{i:0;s:0:\"\";i:1;s:75:\"http://i76.fastpic.ru/big/2015/1228/40/df5645c81506b9a40939e266ea92c840.jpg\";}'),
(5817,	1447,	'pin_try',	'2'),
(5818,	1447,	'images_try',	'a:1:{s:32:\"d41d8cd98f00b204e9800998ecf8427e\";i:1;}'),
(5821,	1447,	'pins',	'a:1:{i:0;s:75:\"http://i76.fastpic.ru/big/2015/1228/40/df5645c81506b9a40939e266ea92c840.jpg\";}'),
(5820,	1447,	'_wpt_failed',	'a:5:{s:6:\"author\";b:0;s:8:\"sentence\";s:219:\"Routing Protocols and Concepts CCNA Exploration Labs and Study Guide http://hotfile.pw/ebooks/routing-protocols-and-concepts-ccna-exploration-labs-and-study-guide.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";s:5:\"error\";s:66:\"Yo already tweeted this. Twitter requires all Tweets to be unique.\";s:4:\"code\";i:403;s:9:\"timestamp\";i:1451461736;}'),
(5828,	1449,	'_oembed_382623901f00014e6df2c660e8626e45',	'{{unknown}}'),
(5830,	1449,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/pediatric-orthopedic-deformities-volume-1.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5831,	1449,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fpediatric-orthopedic-deformities-volume-1.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5832,	1449,	'_wptp_twitter_api',	'a:1:{i:0;s:165:\"Pediatric Orthopedic Deformities Volume 1 http://hotfile.pw/ebooks/pediatric-orthopedic-deformities-volume-1.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5833,	1449,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5834,	1449,	'_edit_lock',	'1451461800:1'),
(5839,	1451,	'_oembed_baeb1015e576a837b70f209ba292ef94',	'{{unknown}}'),
(5842,	1451,	'_jd_tweet_this',	'yes'),
(5838,	1451,	'xyz_fbap',	'1'),
(5840,	1451,	'_oembed_2a34faae843507df394b9214e0200cb7',	'{{unknown}}'),
(5841,	1451,	'_oembed_fa1ffdc16c347ddb476ab445302a75dc',	'{{unknown}}'),
(5843,	1451,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/recommendations-for-fatigue-design-of-welded-joints-and-components.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5844,	1451,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Frecommendations-for-fatigue-design-of-welded-joints-and-components.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5845,	1451,	'_wptp_twitter_api',	'a:1:{i:0;s:215:\"Recommendations for Fatigue Design of Welded Joints and Components http://hotfile.pw/ebooks/recommendations-for-fatigue-design-of-welded-joints-and-components.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5846,	1451,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5847,	1451,	'_edit_lock',	'1451461933:1'),
(5852,	1453,	'_oembed_ddeaa53c53334c2359db8754b4022bee',	'{{unknown}}'),
(5854,	1453,	'_oembed_e18c44cc71fc60d8598c7d4f2d509a1d',	'{{unknown}}'),
(5851,	1453,	'xyz_fbap',	'1'),
(5853,	1453,	'_oembed_7e9cd07e5951497826afe56c48ebf4d3',	'{{unknown}}'),
(5855,	1453,	'_jd_tweet_this',	'yes'),
(5856,	1453,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/microsoft-excel-2016-step-by-step.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5857,	1453,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fmicrosoft-excel-2016-step-by-step.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5858,	1453,	'_wptp_twitter_api',	'a:1:{i:0;s:149:\"Microsoft Excel 2016 Step by Step http://hotfile.pw/ebooks/microsoft-excel-2016-step-by-step.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5859,	1453,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5860,	1453,	'_edit_lock',	'1451462066:1'),
(5861,	1455,	'_edit_last',	'1'),
(5865,	1455,	'_oembed_73740a03783b9f3ebc13061e94762dcb',	'{{unknown}}'),
(5868,	1455,	'_jd_tweet_this',	'yes'),
(5864,	1455,	'xyz_fbap',	'1'),
(5866,	1455,	'_oembed_923c74f8b16185bc0b28f35d71d0505d',	'{{unknown}}'),
(5867,	1455,	'_oembed_585b281a4a501e4d067739bd17a4d7c2',	'{{unknown}}'),
(5869,	1455,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/selenium-chemistry-analysis-function-and-effects.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5870,	1455,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fselenium-chemistry-analysis-function-and-effects.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5871,	1455,	'_wptp_twitter_api',	'a:1:{i:0;s:179:\"Selenium Chemistry Analysis Function and Effects http://hotfile.pw/ebooks/selenium-chemistry-analysis-function-and-effects.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5872,	1455,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5873,	1455,	'_edit_lock',	'1451462197:1'),
(5874,	1457,	'_edit_last',	'1'),
(5878,	1457,	'_oembed_e029ddcff7d32c2f7a57dce83d29a0f8',	'{{unknown}}'),
(5880,	1457,	'_oembed_6467e814ec072cee8c460b62c6516588',	'{{unknown}}'),
(5877,	1457,	'xyz_fbap',	'1'),
(5879,	1457,	'_oembed_d62b02536ab655744f345c32475eb6bb',	'{{unknown}}'),
(5881,	1457,	'_jd_tweet_this',	'yes'),
(5882,	1457,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/towards-a-postbertalanffy-systemics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5883,	1457,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Ftowards-a-postbertalanffy-systemics.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5884,	1457,	'_wptp_twitter_api',	'a:1:{i:0;s:153:\"Towards a PostBertalanffy Systemics http://hotfile.pw/ebooks/towards-a-postbertalanffy-systemics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5885,	1457,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5886,	1457,	'_edit_lock',	'1451462328:1'),
(5887,	1459,	'_edit_last',	'1'),
(5891,	1459,	'_oembed_aaef57ce9eac8df85075f98846ab5e64',	'{{unknown}}'),
(5894,	1459,	'_jd_tweet_this',	'yes'),
(5890,	1459,	'xyz_fbap',	'1'),
(5892,	1459,	'_oembed_c9fc23110bacb76d88c5769babbf742e',	'{{unknown}}'),
(5893,	1459,	'_oembed_14480974a5096787e3da567d356c6e43',	'{{unknown}}'),
(5895,	1459,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/jesus-and-his-world-the-archaeological-evidence.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5896,	1459,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fjesus-and-his-world-the-archaeological-evidence.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5897,	1459,	'_wptp_twitter_api',	'a:1:{i:0;s:177:\"Jesus and His World The Archaeological Evidence http://hotfile.pw/ebooks/jesus-and-his-world-the-archaeological-evidence.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5898,	1459,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5899,	1459,	'_edit_lock',	'1451462460:1'),
(5900,	1461,	'_edit_last',	'1'),
(5904,	1461,	'_oembed_dee5166cb442690cd2525476d3bd9281',	'{{unknown}}'),
(5907,	1461,	'_jd_tweet_this',	'yes'),
(5903,	1461,	'xyz_fbap',	'1'),
(5905,	1461,	'_oembed_0293434c21c3a6fd35e0c6748c1460cd',	'{{unknown}}'),
(5906,	1461,	'_oembed_4069149c5b97b6f27a6d5e42b10f215f',	'{{unknown}}'),
(5908,	1461,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/becoming-john-dewey-dilemmas-of-a-philosopher-and-naturalist.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5909,	1461,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fbecoming-john-dewey-dilemmas-of-a-philosopher-and-naturalist.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5910,	1461,	'_wptp_twitter_api',	'a:1:{i:0;s:203:\"Becoming John Dewey Dilemmas of a Philosopher and Naturalist http://hotfile.pw/ebooks/becoming-john-dewey-dilemmas-of-a-philosopher-and-naturalist.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5911,	1461,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5912,	1461,	'_edit_lock',	'1451462591:1'),
(5913,	1463,	'_edit_last',	'1'),
(5917,	1463,	'_oembed_a72175bbc792c701b1cf3b7e3b9e612e',	'{{unknown}}'),
(5919,	1463,	'_oembed_6f35941f571bb96389250f57c935925f',	'{{unknown}}'),
(5916,	1463,	'xyz_fbap',	'1'),
(5918,	1463,	'_oembed_bd330363b9d2fa0608a5b334c4f266f6',	'{{unknown}}'),
(5920,	1463,	'_jd_tweet_this',	'yes'),
(5921,	1463,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/managerial-economics-business-strategy-8th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5922,	1463,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fmanagerial-economics-business-strategy-8th-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5923,	1463,	'_wptp_twitter_api',	'a:1:{i:0;s:183:\"Managerial Economics Business Strategy 8th edition http://hotfile.pw/ebooks/managerial-economics-business-strategy-8th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5924,	1463,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5925,	1463,	'_edit_lock',	'1451462724:1'),
(5926,	1465,	'_edit_last',	'1'),
(5930,	1465,	'_oembed_01ae9385b14c1ed99d5cd431ee2a2ff0',	'{{unknown}}'),
(5933,	1465,	'_jd_tweet_this',	'yes'),
(5929,	1465,	'xyz_fbap',	'1'),
(5931,	1465,	'_oembed_7f59a6f5690e430164908e6586ee42e6',	'{{unknown}}'),
(5932,	1465,	'_oembed_7e1f64ae91669b848139824cd0334058',	'{{unknown}}'),
(5934,	1465,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/antitrust-consent-decrees-in-theory-and-practice.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5935,	1465,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fantitrust-consent-decrees-in-theory-and-practice.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5936,	1465,	'_wptp_twitter_api',	'a:1:{i:0;s:179:\"Antitrust Consent Decrees in Theory and Practice http://hotfile.pw/ebooks/antitrust-consent-decrees-in-theory-and-practice.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5937,	1465,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5938,	1465,	'_edit_lock',	'1451462854:1'),
(5939,	1467,	'_edit_last',	'1'),
(5943,	1467,	'_oembed_67dbcd3dbd7dd550d0d7fd8b9ad94587',	'{{unknown}}'),
(5944,	1467,	'_oembed_6705e92619e6d6e84fa9c9988b2e127a',	'{{unknown}}'),
(5942,	1467,	'xyz_fbap',	'1'),
(5945,	1467,	'_oembed_8244f9de4015b2782a77b33182cfbfe9',	'{{unknown}}'),
(5946,	1467,	'_jd_tweet_this',	'yes'),
(5947,	1467,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/standard-design-and-construction-guidelines-for-microtunneling-standard-asceci-3.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5948,	1467,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fstandard-design-and-construction-guidelines-for-microtunneling-standard-asceci-3.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5949,	1467,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"Standard Design and Construction Guidelines for Microtunneling Standard ASCECI 3... http://hotfile.pw/ebooks/standard-design-and-construction-guidelines-for-microtunneling-standard-asceci-3.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5950,	1467,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5951,	1467,	'_edit_lock',	'1451462987:1'),
(5952,	1469,	'_edit_last',	'1'),
(5956,	1469,	'_oembed_5045cfff6cf7969781ab61b625607ca0',	'{{unknown}}'),
(5959,	1469,	'_jd_tweet_this',	'yes'),
(5955,	1469,	'xyz_fbap',	'1'),
(5957,	1469,	'_oembed_1ae96d093e933af4d10f3853e43595c4',	'{{unknown}}'),
(5958,	1469,	'_oembed_445517e63bb497de4f002487d8ec5380',	'{{unknown}}'),
(5960,	1469,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/new-icons-of-fashion-illustration.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5961,	1469,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fnew-icons-of-fashion-illustration.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5962,	1469,	'_wptp_twitter_api',	'a:1:{i:0;s:149:\"New Icons of Fashion Illustration http://hotfile.pw/ebooks/new-icons-of-fashion-illustration.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5963,	1469,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5964,	1469,	'_edit_lock',	'1451463118:1'),
(5965,	1471,	'_edit_last',	'1'),
(5969,	1471,	'_oembed_f5af0bf980d14ddb79b3962a39b0b48c',	'{{unknown}}'),
(5968,	1471,	'xyz_fbap',	'1'),
(5970,	1471,	'_oembed_f6a823d1b316c74b45d50bb15ad2cc67',	'{{unknown}}'),
(5971,	1471,	'_oembed_b56406ac2312851dba0409d5bcc30e41',	'{{unknown}}'),
(5972,	1471,	'_jd_tweet_this',	'yes'),
(5973,	1471,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/hst-the-second-millennium.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5974,	1471,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fhst-the-second-millennium.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5975,	1471,	'_wptp_twitter_api',	'a:1:{i:0;s:133:\"HST The Second Millennium http://hotfile.pw/ebooks/hst-the-second-millennium.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5976,	1471,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5977,	1471,	'_edit_lock',	'1451463249:1'),
(5978,	1473,	'_edit_last',	'1'),
(5982,	1473,	'_oembed_a2c037a0c245ffdd5ddbdf3b5e07e02b',	'{{unknown}}'),
(5984,	1473,	'_oembed_f64fa75e62f8cecb240e6331df504f44',	'{{unknown}}'),
(5981,	1473,	'xyz_fbap',	'1'),
(5983,	1473,	'_oembed_229380e4999489bd00a5b23e32c7dbe0',	'{{unknown}}'),
(5985,	1473,	'_jd_tweet_this',	'yes'),
(5986,	1473,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/pile-design-and-construction-practice-6th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(5987,	1473,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fpile-design-and-construction-practice-6th-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(5988,	1473,	'_wptp_twitter_api',	'a:1:{i:0;s:181:\"Pile Design and Construction Practice 6th edition http://hotfile.pw/ebooks/pile-design-and-construction-practice-6th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(5989,	1473,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(5990,	1473,	'_edit_lock',	'1451463382:1'),
(5991,	1475,	'_edit_last',	'1'),
(5995,	1475,	'_oembed_c793737d168765aee0da4a27a64988ff',	'{{unknown}}'),
(5998,	1476,	'_edit_last',	'1'),
(5994,	1475,	'xyz_fbap',	'1'),
(5996,	1475,	'_oembed_f0ffd9b464f797591d71f5c9009e2906',	'{{unknown}}'),
(5997,	1475,	'_oembed_fbd32de4d3f00a0778aa3bc6ebc52c27',	'{{unknown}}'),
(6002,	1476,	'_oembed_7d00e44d4f3a3ae10821d209ed3d6c68',	'{{unknown}}'),
(6003,	1476,	'_oembed_8d84ae88fc4b8dbe0a9574fb1e75e8b1',	'{{unknown}}'),
(6001,	1476,	'xyz_fbap',	'1'),
(6004,	1476,	'_oembed_c4d8bcc420b400294a0a6d43eed13092',	'{{unknown}}'),
(6005,	1476,	'_jd_tweet_this',	'yes'),
(6006,	1476,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/ethical-issues-in-anesthesiology-and-surgery.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6007,	1476,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fethical-issues-in-anesthesiology-and-surgery.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6008,	1476,	'_wptp_twitter_api',	'a:1:{i:0;s:171:\"Ethical Issues in Anesthesiology and Surgery http://hotfile.pw/ebooks/ethical-issues-in-anesthesiology-and-surgery.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6009,	1476,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6010,	1476,	'_edit_lock',	'1451463654:1'),
(6011,	1478,	'_edit_last',	'1'),
(6015,	1478,	'_oembed_dd6d6a8ba395be0ad8bef6f7390816e3',	'{{unknown}}'),
(6017,	1478,	'_oembed_b412de119093a658fd64fe5256f9bc7f',	'{{unknown}}'),
(6014,	1478,	'xyz_fbap',	'1'),
(6016,	1478,	'_oembed_b3208a84092db9ef2e57967f79ad844b',	'{{unknown}}'),
(6018,	1478,	'_jd_tweet_this',	'yes'),
(6019,	1478,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/an-introduction-to-statistics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6020,	1478,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fan-introduction-to-statistics.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6021,	1478,	'_wptp_twitter_api',	'a:1:{i:0;s:141:\"An Introduction to Statistics http://hotfile.pw/ebooks/an-introduction-to-statistics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6022,	1478,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6023,	1478,	'_edit_lock',	'1451463788:1'),
(6024,	1480,	'_edit_last',	'1'),
(6028,	1480,	'_oembed_c96a7a5b6bcc58d3960970c036e83501',	'{{unknown}}'),
(6031,	1480,	'_jd_tweet_this',	'yes'),
(6027,	1480,	'xyz_fbap',	'1'),
(6029,	1480,	'_oembed_3aed2f7ace7b8b56a5d49daba4747e58',	'{{unknown}}'),
(6030,	1480,	'_oembed_be548527fe594801a45e4abc8bf75ffc',	'{{unknown}}'),
(6032,	1480,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/java-regex-crash-course-the-ultimate-beginners-course-to-learning-java-regular-e.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6033,	1480,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fjava-regex-crash-course-the-ultimate-beginners-course-to-learning-java-regular-e.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6034,	1480,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"Java Regex Crash Course The Ultimate Beginners Course to Learning Java Regular E... http://hotfile.pw/ebooks/java-regex-crash-course-the-ultimate-beginners-course-to-learning-java-regular-e.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6035,	1480,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6036,	1480,	'_edit_lock',	'1451463918:1'),
(6037,	1482,	'_edit_last',	'1'),
(6041,	1482,	'_oembed_7a1a46ec59c05e7036f325cf902ef771',	'{{unknown}}'),
(6044,	1482,	'_jd_tweet_this',	'yes'),
(6040,	1482,	'xyz_fbap',	'1'),
(6042,	1482,	'_oembed_c1983f30aded105b5e6760c3bc5bd4a1',	'{{unknown}}'),
(6043,	1482,	'_oembed_f0ce6fefb93a8ddf1ae1240d565c7f4a',	'{{unknown}}'),
(6045,	1482,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/circus-as-multimodal-discourse-performance-meaning-and-ritual.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6046,	1482,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcircus-as-multimodal-discourse-performance-meaning-and-ritual.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6047,	1482,	'_wptp_twitter_api',	'a:1:{i:0;s:205:\"Circus as Multimodal Discourse Performance Meaning and Ritual http://hotfile.pw/ebooks/circus-as-multimodal-discourse-performance-meaning-and-ritual.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6048,	1482,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6049,	1482,	'_edit_lock',	'1451464049:1'),
(6050,	1484,	'_edit_last',	'1'),
(6054,	1484,	'_oembed_4794b312fc75bdbb8fe94075a2d4588e',	'{{unknown}}'),
(6057,	1484,	'_jd_tweet_this',	'yes'),
(6053,	1484,	'xyz_fbap',	'1'),
(6055,	1484,	'_oembed_e4509cf16d780320d3e95f57d4ddca55',	'{{unknown}}'),
(6056,	1484,	'_oembed_059ef40030c77a5102da8600a1d339aa',	'{{unknown}}'),
(6058,	1484,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/mind-that-abides-panpsychism-in-the-new-millennium.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6059,	1484,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fmind-that-abides-panpsychism-in-the-new-millennium.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6060,	1484,	'_wptp_twitter_api',	'a:1:{i:0;s:183:\"Mind That Abides Panpsychism in the new millennium http://hotfile.pw/ebooks/mind-that-abides-panpsychism-in-the-new-millennium.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6061,	1484,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6062,	1484,	'_edit_lock',	'1451464181:1'),
(6063,	1486,	'_edit_last',	'1'),
(6067,	1486,	'_oembed_57a4dad0edb8acc0ad65fc4f3884598a',	'{{unknown}}'),
(6070,	1486,	'_jd_tweet_this',	'yes'),
(6066,	1486,	'xyz_fbap',	'1'),
(6068,	1486,	'_oembed_3d84f70840f4d34d9db1f077f55a3690',	'{{unknown}}'),
(6069,	1486,	'_oembed_69fffddadf2ad239862a5a7ad6f4e4b9',	'{{unknown}}'),
(6071,	1486,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/collected-studies-on-the-septuagint-from-language-to-interpretation-and-beyond.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6072,	1486,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcollected-studies-on-the-septuagint-from-language-to-interpretation-and-beyond.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6073,	1486,	'_wptp_twitter_api',	'a:1:{i:0;s:239:\"Collected Studies on the Septuagint From Language to Interpretation and Beyond http://hotfile.pw/ebooks/collected-studies-on-the-septuagint-from-language-to-interpretation-and-beyond.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6074,	1486,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6075,	1486,	'_edit_lock',	'1451464311:1'),
(6076,	1488,	'_edit_last',	'1'),
(6080,	1488,	'_oembed_7ca51b19f623941cd6de5d2c6ef51cf1',	'{{unknown}}'),
(6083,	1488,	'_jd_tweet_this',	'yes'),
(6079,	1488,	'xyz_fbap',	'1'),
(6081,	1488,	'_oembed_c94ecfa74d48797ecf24ddca5c627fc7',	'{{unknown}}'),
(6082,	1488,	'_oembed_ce140502009e66f1753a89bd18bb0b60',	'{{unknown}}'),
(6084,	1488,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/building-wireless-sensor-networks-theoretical-and-practical-perspectives.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6085,	1488,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fbuilding-wireless-sensor-networks-theoretical-and-practical-perspectives.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6086,	1488,	'_wptp_twitter_api',	'a:1:{i:0;s:227:\"Building Wireless Sensor Networks Theoretical and Practical Perspectives http://hotfile.pw/ebooks/building-wireless-sensor-networks-theoretical-and-practical-perspectives.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6087,	1488,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6088,	1488,	'_edit_lock',	'1451464442:1'),
(6089,	1490,	'_edit_last',	'1'),
(6094,	1490,	'_oembed_950a1e7e8d1cb0bf5a92ef9d4e50a210',	'{{unknown}}'),
(6096,	1490,	'_jd_tweet_this',	'yes'),
(6092,	1490,	'xyz_fbap',	'1'),
(6093,	1490,	'_oembed_83cb85313aeda0f4cad02e9307d6ca8f',	'{{unknown}}'),
(6095,	1490,	'_oembed_b86334ef9944e0267819369ef7090f95',	'{{unknown}}'),
(6097,	1490,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/chasing-the-light-the-cloud-cult-story.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6098,	1490,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fchasing-the-light-the-cloud-cult-story.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6099,	1490,	'_wptp_twitter_api',	'a:1:{i:0;s:159:\"Chasing the Light The Cloud Cult Story http://hotfile.pw/ebooks/chasing-the-light-the-cloud-cult-story.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6100,	1490,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6101,	1490,	'_edit_lock',	'1451464575:1'),
(6102,	1492,	'_edit_last',	'1'),
(6106,	1492,	'_oembed_310043f9e40803a336758fb168da1aff',	'{{unknown}}'),
(6108,	1492,	'_oembed_f76675a77d8f2e173413a4665c1128c0',	'{{unknown}}'),
(6105,	1492,	'xyz_fbap',	'1'),
(6107,	1492,	'_oembed_e00bdecc8ebe94df5ce6faadb9e2c5af',	'{{unknown}}'),
(6109,	1492,	'_jd_tweet_this',	'yes'),
(6110,	1492,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/smart-cookie-mindbending-vegan-glutenfree-cookies.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6111,	1492,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fsmart-cookie-mindbending-vegan-glutenfree-cookies.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6112,	1492,	'_wptp_twitter_api',	'a:1:{i:0;s:181:\"Smart Cookie mindbending vegan glutenfree cookies http://hotfile.pw/ebooks/smart-cookie-mindbending-vegan-glutenfree-cookies.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6113,	1492,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6114,	1492,	'_edit_lock',	'1451464706:1'),
(6115,	1494,	'_edit_last',	'1'),
(6119,	1494,	'_oembed_9d19ec9fdecd78a79bf7636fc50df292',	'{{unknown}}'),
(6118,	1494,	'xyz_fbap',	'1'),
(6120,	1494,	'_oembed_3e477957bfd2eafd3dd559e3642cb6c0',	'{{unknown}}'),
(6121,	1494,	'_oembed_152ec5dece9c56e68c9db993a31602ee',	'{{unknown}}'),
(6122,	1494,	'_jd_tweet_this',	'yes'),
(6123,	1494,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/stock-broth-bowl-recipes-for-cooking-drinking-nourishing.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6124,	1494,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fstock-broth-bowl-recipes-for-cooking-drinking-nourishing.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6125,	1494,	'_wptp_twitter_api',	'a:1:{i:0;s:195:\"Stock Broth Bowl Recipes for Cooking Drinking Nourishing http://hotfile.pw/ebooks/stock-broth-bowl-recipes-for-cooking-drinking-nourishing.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6126,	1494,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6127,	1494,	'_edit_lock',	'1451464840:1'),
(6128,	1496,	'_edit_last',	'1'),
(6132,	1496,	'_oembed_2be06858ec53b3a070c0aba2d752d047',	'{{unknown}}'),
(6134,	1496,	'_oembed_e641616310763e186686bb0816ae3f9b',	'{{unknown}}'),
(6131,	1496,	'xyz_fbap',	'1'),
(6133,	1496,	'_oembed_6d5f847acbec79cf7dc301ca7244712c',	'{{unknown}}'),
(6135,	1496,	'_jd_tweet_this',	'yes'),
(6136,	1496,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/linear-algebra-as-an-introduction-to-abstract-mathematics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6137,	1496,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Flinear-algebra-as-an-introduction-to-abstract-mathematics.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6138,	1496,	'_wptp_twitter_api',	'a:1:{i:0;s:197:\"Linear Algebra as an Introduction to Abstract Mathematics http://hotfile.pw/ebooks/linear-algebra-as-an-introduction-to-abstract-mathematics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6139,	1496,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6140,	1496,	'_edit_lock',	'1451464971:1'),
(6141,	1498,	'_edit_last',	'1'),
(6145,	1498,	'_oembed_105f91b2b447c6a5dceed9e4afdf529a',	'{{unknown}}'),
(6148,	1498,	'_jd_tweet_this',	'yes'),
(6144,	1498,	'xyz_fbap',	'1'),
(6146,	1498,	'_oembed_7a205eaf39f3e0c9e5706714c593e664',	'{{unknown}}'),
(6147,	1498,	'_oembed_beeb77410dda56214156ac551507f514',	'{{unknown}}'),
(6149,	1498,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/maple-syrup-cookbook-over-100-recipes-for-breakfast-lunch-dinner.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6150,	1498,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fmaple-syrup-cookbook-over-100-recipes-for-breakfast-lunch-dinner.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6151,	1498,	'_wptp_twitter_api',	'a:1:{i:0;s:211:\"Maple Syrup Cookbook Over 100 Recipes for Breakfast Lunch Dinner http://hotfile.pw/ebooks/maple-syrup-cookbook-over-100-recipes-for-breakfast-lunch-dinner.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6152,	1498,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6153,	1498,	'_edit_lock',	'1451465100:1'),
(6154,	1500,	'_edit_last',	'1'),
(6158,	1500,	'_oembed_fb57a4567c270bae5909890fdd34e1c7',	'{{unknown}}'),
(6159,	1500,	'_oembed_da87686ba8074afc4dc95ba1abef9ad6',	'{{unknown}}'),
(6157,	1500,	'xyz_fbap',	'1'),
(6160,	1500,	'_jd_tweet_this',	'yes'),
(6161,	1500,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/efficient-lighting-applications-and-case-studies.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6162,	1500,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fefficient-lighting-applications-and-case-studies.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6163,	1500,	'_wptp_twitter_api',	'a:1:{i:0;s:179:\"Efficient Lighting Applications and Case Studies http://hotfile.pw/ebooks/efficient-lighting-applications-and-case-studies.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6164,	1500,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6165,	1500,	'_edit_lock',	'1451465233:1'),
(6166,	1502,	'_edit_last',	'1'),
(6170,	1502,	'_oembed_de59b0b65ee9b322fc60f0bed8ee5a0d',	'{{unknown}}'),
(6173,	1503,	'_edit_last',	'1'),
(6169,	1502,	'xyz_fbap',	'1'),
(6171,	1502,	'_oembed_17fe2eeb91ca4c3636feef213b68e3fd',	'{{unknown}}'),
(6172,	1502,	'_oembed_2f4f0c42aa7a32598bfe81ceda099493',	'{{unknown}}'),
(6177,	1503,	'_oembed_16fd551e6fb4c23c4d6bfec48558de15',	'{{unknown}}'),
(6179,	1503,	'_oembed_2513a71d685349edaa43ce47579adabc',	'{{unknown}}'),
(6176,	1503,	'xyz_fbap',	'1'),
(6178,	1503,	'_oembed_4c945d8c0f4bc701fd5cfe9975bfe73e',	'{{unknown}}'),
(6180,	1503,	'_jd_tweet_this',	'yes'),
(6181,	1503,	'_wp_jd_wp',	'http://hotfile.pw/magazines/quiltmaker-januaryfebruary.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6182,	1503,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmagazines%2Fquiltmaker-januaryfebruary.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6183,	1503,	'_wptp_twitter_api',	'a:1:{i:0;s:138:\"Quiltmaker JanuaryFebruary http://hotfile.pw/magazines/quiltmaker-januaryfebruary.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6184,	1503,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6185,	1503,	'_edit_lock',	'1451465502:1'),
(6186,	1505,	'_edit_last',	'1'),
(6191,	1505,	'_oembed_6726a859afbf80e534246d9fe57fe1ec',	'{{unknown}}'),
(6193,	1505,	'_jd_tweet_this',	'yes'),
(6189,	1505,	'xyz_fbap',	'1'),
(6190,	1505,	'_oembed_d030c48f25040547bdeca9e9d9b32c40',	'{{unknown}}'),
(6192,	1505,	'_oembed_110b70d04cf7ded5f274c506446494af',	'{{unknown}}'),
(6194,	1505,	'_wp_jd_wp',	'http://hotfile.pw/magazines/palm-beach-illustrated-january.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6195,	1505,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmagazines%2Fpalm-beach-illustrated-january.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6196,	1505,	'_wptp_twitter_api',	'a:1:{i:0;s:146:\"Palm Beach Illustrated January http://hotfile.pw/magazines/palm-beach-illustrated-january.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6197,	1505,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6198,	1505,	'_edit_lock',	'1451465631:1'),
(6199,	1507,	'_edit_last',	'1'),
(6203,	1507,	'_oembed_4de1204e79e05208ec18b941760be178',	'{{unknown}}'),
(6205,	1507,	'_oembed_7fcb5dc777d30f928d16447fad504841',	'{{unknown}}'),
(6202,	1507,	'xyz_fbap',	'1'),
(6204,	1507,	'_oembed_4271be67d7ad0dde3f98fc3411dea4a0',	'{{unknown}}'),
(6206,	1507,	'_jd_tweet_this',	'yes'),
(6207,	1507,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/tuberculosis-leprosy-and-other-mycobacterial-diseases-of-man-and-animals-the-man.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6208,	1507,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Ftuberculosis-leprosy-and-other-mycobacterial-diseases-of-man-and-animals-the-man.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6209,	1507,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"Tuberculosis Leprosy and Other Mycobacterial Diseases of Man and Animals The Man... http://hotfile.pw/ebooks/tuberculosis-leprosy-and-other-mycobacterial-diseases-of-man-and-animals-the-man.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6210,	1507,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6211,	1507,	'_edit_lock',	'1451465762:1'),
(6212,	1509,	'_edit_last',	'1'),
(6216,	1509,	'_oembed_05a49c420d3ace68faa2c3268402bfab',	'{{unknown}}'),
(6219,	1509,	'_jd_tweet_this',	'yes'),
(6215,	1509,	'xyz_fbap',	'1'),
(6217,	1509,	'_oembed_ecb114063839dd608f443e6cd412d11d',	'{{unknown}}'),
(6218,	1509,	'_oembed_6031799fb0463c7fd3b5e0fd56cbfa74',	'{{unknown}}'),
(6220,	1509,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-paris-system-for-reporting-urinary-cytology.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6221,	1509,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-paris-system-for-reporting-urinary-cytology.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6222,	1509,	'_wptp_twitter_api',	'a:1:{i:0;s:177:\"The Paris System for Reporting Urinary Cytology http://hotfile.pw/ebooks/the-paris-system-for-reporting-urinary-cytology.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6223,	1509,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6224,	1509,	'_edit_lock',	'1451465893:1'),
(6225,	1511,	'_edit_last',	'1'),
(6229,	1511,	'_oembed_d6c2b9723bd0dfd8c9459fa4445289e5',	'{{unknown}}'),
(6232,	1511,	'_jd_tweet_this',	'yes'),
(6228,	1511,	'xyz_fbap',	'1'),
(6230,	1511,	'_oembed_982cf5ecb5b016bbaaefcfe933ceac8e',	'{{unknown}}'),
(6231,	1511,	'_oembed_50f9bfa3b57482351ab5b6a6af70fe5f',	'{{unknown}}'),
(6233,	1511,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-general-theory-of-relativity-a-mathematical-exposition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6234,	1511,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-general-theory-of-relativity-a-mathematical-exposition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6235,	1511,	'_wptp_twitter_api',	'a:1:{i:0;s:199:\"The General Theory of Relativity A Mathematical Exposition http://hotfile.pw/ebooks/the-general-theory-of-relativity-a-mathematical-exposition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6236,	1511,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6237,	1511,	'_edit_lock',	'1451466023:1'),
(6238,	1513,	'_edit_last',	'1'),
(6242,	1513,	'_oembed_4d106c100fdf35d72fbca648ccd69888',	'{{unknown}}'),
(6245,	1513,	'_jd_tweet_this',	'yes'),
(6241,	1513,	'xyz_fbap',	'1'),
(6243,	1513,	'_oembed_c26e97746cc309bfe9b80644a47a0d96',	'{{unknown}}'),
(6244,	1513,	'_oembed_f1c86be3203bf3126c32df1802cdefa5',	'{{unknown}}'),
(6246,	1513,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/supersymmetry-in-mathematics-and-physics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6247,	1513,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fsupersymmetry-in-mathematics-and-physics.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6248,	1513,	'_wptp_twitter_api',	'a:1:{i:0;s:163:\"Supersymmetry in Mathematics and Physics http://hotfile.pw/ebooks/supersymmetry-in-mathematics-and-physics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6249,	1513,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6250,	1513,	'_edit_lock',	'1451466153:1'),
(6251,	1515,	'_edit_last',	'1'),
(6255,	1515,	'_oembed_c16ae5b68a1ac65237c703230ad5c6a3',	'{{unknown}}'),
(6256,	1515,	'_oembed_d24ac85134ee7eb45bc602d061107037',	'{{unknown}}'),
(6254,	1515,	'xyz_fbap',	'1'),
(6257,	1515,	'_oembed_cdfb0403e0ff2b0bedd8e1c744652e5e',	'{{unknown}}'),
(6258,	1515,	'_jd_tweet_this',	'yes'),
(6259,	1515,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/clinical-study-guide-for-the-oral-boards-in-psychiatry-4th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6260,	1515,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fclinical-study-guide-for-the-oral-boards-in-psychiatry-4th-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6261,	1515,	'_wptp_twitter_api',	'a:1:{i:0;s:215:\"Clinical Study Guide for the Oral Boards in Psychiatry 4th edition http://hotfile.pw/ebooks/clinical-study-guide-for-the-oral-boards-in-psychiatry-4th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6262,	1515,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6263,	1515,	'_edit_lock',	'1451466284:1'),
(6264,	1517,	'_edit_last',	'1'),
(6268,	1517,	'_oembed_0b934cd736488e5315c3115e0772d01c',	'{{unknown}}'),
(6269,	1517,	'_oembed_77c15f4f10e328875110626c52d6e89e',	'{{unknown}}'),
(6267,	1517,	'xyz_fbap',	'1'),
(6270,	1517,	'_oembed_213c10f200aca50f8e30aa319ec15ca6',	'{{unknown}}'),
(6271,	1517,	'_jd_tweet_this',	'yes'),
(6272,	1517,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/critical-dietary-factors-in-cancer-chemoprevention.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6273,	1517,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcritical-dietary-factors-in-cancer-chemoprevention.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6274,	1517,	'_wptp_twitter_api',	'a:1:{i:0;s:183:\"Critical Dietary Factors in Cancer Chemoprevention http://hotfile.pw/ebooks/critical-dietary-factors-in-cancer-chemoprevention.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6275,	1517,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6276,	1517,	'_edit_lock',	'1451466415:1'),
(6277,	1519,	'_edit_last',	'1'),
(6281,	1519,	'_oembed_14a4d5f2e200da1e41fb2bf70056e165',	'{{unknown}}'),
(6280,	1519,	'xyz_fbap',	'1'),
(6282,	1519,	'_oembed_0f1c443ccd58a192c6a45638b973c1c8',	'{{unknown}}'),
(6283,	1519,	'_oembed_c210828702af9aad4d706e9f66a29ede',	'{{unknown}}'),
(6284,	1519,	'_jd_tweet_this',	'yes'),
(6285,	1519,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/clinical-manual-for-treatment-of-schizophrenia.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6286,	1519,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fclinical-manual-for-treatment-of-schizophrenia.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6287,	1519,	'_wptp_twitter_api',	'a:1:{i:0;s:175:\"Clinical Manual for Treatment of Schizophrenia http://hotfile.pw/ebooks/clinical-manual-for-treatment-of-schizophrenia.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6288,	1519,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6289,	1519,	'_edit_lock',	'1451466546:1'),
(6290,	1521,	'_edit_last',	'1'),
(6294,	1521,	'_oembed_eb58abff166b8ca840a08daaefd22d29',	'{{unknown}}'),
(6295,	1521,	'_oembed_b1757a97e8a6e0ff139daaa6962c29ca',	'{{unknown}}'),
(6293,	1521,	'xyz_fbap',	'1'),
(6296,	1521,	'_oembed_4cadda3b8b07b97d437aa56e399a827c',	'{{unknown}}'),
(6297,	1521,	'_jd_tweet_this',	'yes'),
(6298,	1521,	'_wp_jd_wp',	'http://hotfile.pw/mac/phpstorm-v1002-mac-osx.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6299,	1521,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmac%2Fphpstorm-v1002-mac-osx.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6300,	1521,	'_wptp_twitter_api',	'a:1:{i:0;s:124:\"PhpStorm v1002 Mac OSX http://hotfile.pw/mac/phpstorm-v1002-mac-osx.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6301,	1521,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6302,	1521,	'_edit_lock',	'1451466678:1'),
(6303,	1523,	'_edit_last',	'1'),
(6307,	1523,	'_oembed_aec910a0fd06ab1f854057348b58886a',	'{{unknown}}'),
(6310,	1523,	'_jd_tweet_this',	'yes'),
(6306,	1523,	'xyz_fbap',	'1'),
(6308,	1523,	'_oembed_6a3b8873c3d2ff36b450bcdded28aa26',	'{{unknown}}'),
(6309,	1523,	'_oembed_dffda69698d5a2335d929164a7817b61',	'{{unknown}}'),
(6311,	1523,	'_wp_jd_wp',	'http://hotfile.pw/tuts/learn-grunt-with-examples-automate-your-front-end-workflow.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6312,	1523,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Ftuts%2Flearn-grunt-with-examples-automate-your-front-end-workflow.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6313,	1523,	'_wptp_twitter_api',	'a:1:{i:0;s:197:\"Learn Grunt with Examples Automate Your Front End Workflow http://hotfile.pw/tuts/learn-grunt-with-examples-automate-your-front-end-workflow.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6314,	1523,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6315,	1523,	'_edit_lock',	'1451466810:1'),
(6316,	1525,	'_edit_last',	'1'),
(6320,	1525,	'_oembed_a6b12822b3faa7a1926d6a2a993bb310',	'{{unknown}}'),
(6323,	1525,	'_jd_tweet_this',	'yes'),
(6319,	1525,	'xyz_fbap',	'1'),
(6321,	1525,	'_oembed_92a82aa93d4432028f45427fde89793b',	'{{unknown}}'),
(6322,	1525,	'_oembed_4e50fd1f66f130a6937d76c6df506b2c',	'{{unknown}}'),
(6324,	1525,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/internet-explorer.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6325,	1525,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Finternet-explorer.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6326,	1525,	'_wptp_twitter_api',	'a:1:{i:0;s:117:\"Internet Explorer http://hotfile.pw/ebooks/internet-explorer.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6327,	1525,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6328,	1525,	'_edit_lock',	'1451466942:1'),
(6329,	1527,	'_edit_last',	'1'),
(6333,	1527,	'_oembed_8494d465554860050eb052e6f9cb8089',	'{{unknown}}'),
(6336,	1527,	'_jd_tweet_this',	'yes'),
(6332,	1527,	'xyz_fbap',	'1'),
(6334,	1527,	'_oembed_e52769645a986778a660dbbee68a782b',	'{{unknown}}'),
(6335,	1527,	'_oembed_1ab1887a5bb376bfebe3bef9c8cfe79d',	'{{unknown}}'),
(6337,	1527,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/qualitative-data-analysis-with-atlasti.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6338,	1527,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fqualitative-data-analysis-with-atlasti.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6339,	1527,	'_wptp_twitter_api',	'a:1:{i:0;s:159:\"Qualitative Data Analysis with ATLASti http://hotfile.pw/ebooks/qualitative-data-analysis-with-atlasti.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6340,	1527,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6341,	1527,	'_edit_lock',	'1451467073:1'),
(6342,	1529,	'_edit_last',	'1'),
(6346,	1529,	'_oembed_62ed089ce76264413499e64c69b30e66',	'{{unknown}}'),
(6348,	1529,	'_oembed_f1ba0005b16568c49c0dbbca1cd3d841',	'{{unknown}}'),
(6345,	1529,	'xyz_fbap',	'1'),
(6347,	1529,	'_oembed_97db1c27c73dfdca7a01bd12d2fdbae6',	'{{unknown}}'),
(6362,	1532,	'_edit_last',	'1'),
(18186,	3304,	'_wptp_twitter_api',	'a:1:{i:0;s:123:\"Help Manual 707 Build http://hotfile.pw/apps/help-manual-707-build.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(18185,	3304,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fapps%2Fhelp-manual-707-build.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(18184,	3304,	'_wp_jd_wp',	'http://hotfile.pw/apps/help-manual-707-build.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(18181,	3304,	'_oembed_0b7e03b58bf36ef0952c7cdfff5cf13d',	'{{unknown}}'),
(18182,	3304,	'_oembed_7c67e12d5429e98d1d7b957278d9d060',	'{{unknown}}'),
(18180,	3304,	'_oembed_231e1e355b94f44983d9fdd4f933c6d4',	'{{unknown}}'),
(18178,	3304,	'xyz_fbap',	'1'),
(6366,	1532,	'_oembed_ebf40950688097acdac7afd3bfa65e7a',	'{{unknown}}'),
(6365,	1532,	'xyz_fbap',	'1'),
(6367,	1532,	'_oembed_7a2b635a3f70f0beec4a535633793db8',	'{{unknown}}'),
(6368,	1532,	'_oembed_9cca3ad56f011802d0da1c4335c7766f',	'{{unknown}}'),
(6369,	1532,	'_jd_tweet_this',	'yes'),
(6370,	1532,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/reproductive-ecology-and-human-evolution.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6371,	1532,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Freproductive-ecology-and-human-evolution.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6372,	1532,	'_wptp_twitter_api',	'a:1:{i:0;s:163:\"Reproductive Ecology and Human Evolution http://hotfile.pw/ebooks/reproductive-ecology-and-human-evolution.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6373,	1532,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6374,	1532,	'_edit_lock',	'1451467366:1'),
(6375,	1534,	'_edit_last',	'1'),
(6379,	1534,	'_oembed_f17386504369f65f0cbe18916aec65f0',	'{{unknown}}'),
(6381,	1534,	'_oembed_ac60a82086af456685e97d1fd5797f68',	'{{unknown}}'),
(6378,	1534,	'xyz_fbap',	'1'),
(6380,	1534,	'_oembed_783d9fb590a0c25c885d92caf2f791dc',	'{{unknown}}'),
(6382,	1534,	'_jd_tweet_this',	'yes'),
(6383,	1534,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/presencebased-coaching-cultivating-selfgenerative-leaders-through-mind-body-and.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6384,	1534,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fpresencebased-coaching-cultivating-selfgenerative-leaders-through-mind-body-and.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6385,	1534,	'_wptp_twitter_api',	'a:1:{i:0;s:245:\"PresenceBased Coaching Cultivating SelfGenerative Leaders Through Mind Body and ... http://hotfile.pw/ebooks/presencebased-coaching-cultivating-selfgenerative-leaders-through-mind-body-and.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6386,	1534,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6387,	1534,	'_edit_lock',	'1451467497:1'),
(6388,	1536,	'_edit_last',	'1'),
(6392,	1536,	'_oembed_e4f68c3a3515490d01a460c76929d3c4',	'{{unknown}}'),
(6394,	1536,	'_oembed_fd1ecb1eda04f3542ee5cc18cd6c02b5',	'{{unknown}}'),
(6391,	1536,	'xyz_fbap',	'1'),
(6393,	1536,	'_oembed_fda111e19a0ef5ff4ad3dc928ec53e32',	'{{unknown}}'),
(6395,	1536,	'_jd_tweet_this',	'yes'),
(6396,	1536,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/fiesta-latina-fabulous-food-for-sizzling-parties.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6397,	1536,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Ffiesta-latina-fabulous-food-for-sizzling-parties.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6398,	1536,	'_wptp_twitter_api',	'a:1:{i:0;s:179:\"Fiesta Latina Fabulous Food for Sizzling Parties http://hotfile.pw/ebooks/fiesta-latina-fabulous-food-for-sizzling-parties.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6399,	1536,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6400,	1536,	'_edit_lock',	'1451467631:1'),
(6401,	1538,	'_edit_last',	'1'),
(6405,	1538,	'_oembed_4e698b5343a767ad2a34941641e075ce',	'{{unknown}}'),
(6404,	1538,	'xyz_fbap',	'1'),
(6406,	1538,	'_oembed_3f5117e9b02b7758d27a0806331fea72',	'{{unknown}}'),
(6407,	1538,	'_oembed_3e17eaa90fb5f19450baec90514f6cc7',	'{{unknown}}'),
(6408,	1538,	'_jd_tweet_this',	'yes'),
(6409,	1538,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/leading-the-internal-audit-function.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6410,	1538,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fleading-the-internal-audit-function.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6411,	1538,	'_wptp_twitter_api',	'a:1:{i:0;s:153:\"Leading the Internal Audit Function http://hotfile.pw/ebooks/leading-the-internal-audit-function.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6412,	1538,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6413,	1538,	'_edit_lock',	'1451467762:1'),
(6414,	1540,	'_edit_last',	'1'),
(6418,	1540,	'_oembed_c73b44d2be4fa0d947838abd5fb62e10',	'{{unknown}}'),
(6420,	1540,	'_oembed_ef031a3d580c6c07ff3a798d65617329',	'{{unknown}}'),
(6417,	1540,	'xyz_fbap',	'1'),
(6419,	1540,	'_oembed_9c0f81f420785187324e666e5134edd6',	'{{unknown}}'),
(6421,	1540,	'_jd_tweet_this',	'yes'),
(6422,	1540,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/new-brewing-lager-beer-the-most-comprehensive-book-for-home-and-microbrewers-2nd.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6423,	1540,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fnew-brewing-lager-beer-the-most-comprehensive-book-for-home-and-microbrewers-2nd.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6424,	1540,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"New Brewing Lager Beer The Most Comprehensive Book for Home and Microbrewers 2nd... http://hotfile.pw/ebooks/new-brewing-lager-beer-the-most-comprehensive-book-for-home-and-microbrewers-2nd.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6425,	1540,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6426,	1540,	'_edit_lock',	'1451467894:1'),
(6427,	1542,	'_edit_last',	'1'),
(6431,	1542,	'_oembed_95b0d924f0f1cbc5996c531f7c71c479',	'{{unknown}}'),
(6434,	1542,	'_jd_tweet_this',	'yes'),
(6430,	1542,	'xyz_fbap',	'1'),
(6432,	1542,	'_oembed_2c01846a88fa2077705090dacc415b6d',	'{{unknown}}'),
(6433,	1542,	'_oembed_e683ba62227f73f9df4cf6f862670c4e',	'{{unknown}}'),
(6435,	1542,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/relativistic-quantum-chemistry-the-fundamental-theory-of-molecular-science.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6436,	1542,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Frelativistic-quantum-chemistry-the-fundamental-theory-of-molecular-science.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6437,	1542,	'_wptp_twitter_api',	'a:1:{i:0;s:231:\"Relativistic Quantum Chemistry The Fundamental Theory of Molecular Science http://hotfile.pw/ebooks/relativistic-quantum-chemistry-the-fundamental-theory-of-molecular-science.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6438,	1542,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6439,	1542,	'_edit_lock',	'1451468027:1'),
(6440,	1544,	'_edit_last',	'1'),
(6444,	1544,	'_oembed_c87a8ac154283762fc9acd16685cd955',	'{{unknown}}'),
(6447,	1544,	'_jd_tweet_this',	'yes'),
(6443,	1544,	'xyz_fbap',	'1'),
(6445,	1544,	'_oembed_6e949e0793730cb607b223210aa2c98a',	'{{unknown}}'),
(6446,	1544,	'_oembed_6ea4b629f3693740ce0821c8c5863807',	'{{unknown}}'),
(6448,	1544,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/musicality-in-theatre-music-as-model-method-and-metaphor-in-theatremaking.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6449,	1544,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fmusicality-in-theatre-music-as-model-method-and-metaphor-in-theatremaking.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6450,	1544,	'_wptp_twitter_api',	'a:1:{i:0;s:229:\"Musicality in Theatre Music As Model Method and Metaphor in TheatreMaking http://hotfile.pw/ebooks/musicality-in-theatre-music-as-model-method-and-metaphor-in-theatremaking.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6451,	1544,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6452,	1544,	'_edit_lock',	'1451468160:1'),
(6453,	1546,	'_edit_last',	'1'),
(6457,	1546,	'_oembed_e67f105e60e70743fa809fd4458b5f4a',	'{{unknown}}'),
(6460,	1546,	'_jd_tweet_this',	'yes'),
(6456,	1546,	'xyz_fbap',	'1'),
(6458,	1546,	'_oembed_1824d6afb3fb9443001c9bb39c18da73',	'{{unknown}}'),
(6459,	1546,	'_oembed_d8f442112763b90563205abf6855c029',	'{{unknown}}'),
(6461,	1546,	'_wp_jd_wp',	'http://hotfile.pw/apps/pgware-gameswift-212282015.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6462,	1546,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fapps%2Fpgware-gameswift-212282015.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6463,	1546,	'_wptp_twitter_api',	'a:1:{i:0;s:133:\"PGWare GameSwift 212282015 http://hotfile.pw/apps/pgware-gameswift-212282015.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6464,	1546,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6465,	1546,	'_edit_lock',	'1451468294:1'),
(6466,	1548,	'_edit_last',	'1'),
(6470,	1548,	'_oembed_c43349aa22a3a109ebe9e0c7ccc155b6',	'{{unknown}}'),
(6472,	1548,	'_oembed_1f0aa2a2d2e4960801027cc7220a8668',	'{{unknown}}'),
(6469,	1548,	'xyz_fbap',	'1'),
(6471,	1548,	'_oembed_2bedba381c1172ca0a15ebf75c7de420',	'{{unknown}}'),
(6473,	1548,	'_jd_tweet_this',	'yes'),
(6474,	1548,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/real-analysis-theory-of-measure-and-integration-3rd-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6475,	1548,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Freal-analysis-theory-of-measure-and-integration-3rd-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6476,	1548,	'_wptp_twitter_api',	'a:1:{i:0;s:201:\"Real Analysis Theory Of Measure And Integration 3rd Edition http://hotfile.pw/ebooks/real-analysis-theory-of-measure-and-integration-3rd-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6477,	1548,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6478,	1548,	'_edit_lock',	'1451468426:1'),
(6479,	1550,	'_edit_last',	'1'),
(6483,	1550,	'_oembed_26dfbaa0eba5f8e71bbd01eedfad5738',	'{{unknown}}'),
(6486,	1550,	'_jd_tweet_this',	'yes'),
(6482,	1550,	'xyz_fbap',	'1'),
(6484,	1550,	'_oembed_1552e5363e8f77444ed5f42def9d2522',	'{{unknown}}'),
(6485,	1550,	'_oembed_e0684a744d774f85accd2be2cbf9edb3',	'{{unknown}}'),
(6487,	1550,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-mamluks-in-egyptian-and-syrian-politics-and-society-medieval-mediterranean.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6488,	1550,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-mamluks-in-egyptian-and-syrian-politics-and-society-medieval-mediterranean.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6489,	1550,	'_wptp_twitter_api',	'a:1:{i:0;s:239:\"The Mamluks in Egyptian and Syrian Politics and Society Medieval Mediterranean http://hotfile.pw/ebooks/the-mamluks-in-egyptian-and-syrian-politics-and-society-medieval-mediterranean.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6490,	1550,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6491,	1550,	'_edit_lock',	'1451468558:1'),
(6492,	1552,	'_edit_last',	'1'),
(6496,	1552,	'_oembed_c4271e10e4248b9f3bd4517d3a9d87a9',	'{{unknown}}'),
(6499,	1552,	'_jd_tweet_this',	'yes'),
(6495,	1552,	'xyz_fbap',	'1'),
(6497,	1552,	'_oembed_3be5b9df8de456ca2eccd4a42e8c1217',	'{{unknown}}'),
(6498,	1552,	'_oembed_9afba443999a8c7e69dc06e667c38588',	'{{unknown}}'),
(6500,	1552,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/cybrarian-extraordinaire-compelling-information-literacy-instruction.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6501,	1552,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcybrarian-extraordinaire-compelling-information-literacy-instruction.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6502,	1552,	'_wptp_twitter_api',	'a:1:{i:0;s:219:\"Cybrarian Extraordinaire Compelling Information Literacy Instruction http://hotfile.pw/ebooks/cybrarian-extraordinaire-compelling-information-literacy-instruction.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6503,	1552,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6504,	1552,	'_edit_lock',	'1451468690:1'),
(6505,	1554,	'_edit_last',	'1'),
(6509,	1554,	'_oembed_5adc455dc68b814190ce32f103542b87',	'{{unknown}}'),
(6508,	1554,	'xyz_fbap',	'1'),
(6510,	1554,	'_oembed_0a4e4fd9ef1802ebb7cae85028dd2f0a',	'{{unknown}}'),
(6511,	1554,	'_oembed_250237aaacaf66812899811d560c123f',	'{{unknown}}'),
(6512,	1554,	'_jd_tweet_this',	'yes'),
(6513,	1554,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-fate-of-anatomical-collections.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6514,	1554,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-fate-of-anatomical-collections.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6515,	1554,	'_wptp_twitter_api',	'a:1:{i:0;s:151:\"The Fate of Anatomical Collections http://hotfile.pw/ebooks/the-fate-of-anatomical-collections.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6516,	1554,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6517,	1554,	'_edit_lock',	'1451468820:1'),
(6518,	1556,	'_edit_last',	'1'),
(6522,	1556,	'_oembed_4e6c3607412b42860a93d485e2b134f9',	'{{unknown}}'),
(6524,	1556,	'_oembed_56bee6d65c17cc7add555af360827b19',	'{{unknown}}'),
(6521,	1556,	'xyz_fbap',	'1'),
(6523,	1556,	'_oembed_a656b5747c38f4b1dfb6a3c25821e981',	'{{unknown}}'),
(6525,	1556,	'_jd_tweet_this',	'yes'),
(6526,	1556,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/knitwear-design.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6527,	1556,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fknitwear-design.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6528,	1556,	'_wptp_twitter_api',	'a:1:{i:0;s:113:\"Knitwear Design http://hotfile.pw/ebooks/knitwear-design.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6529,	1556,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6530,	1556,	'_edit_lock',	'1451468950:1'),
(6531,	1558,	'_edit_last',	'1'),
(6535,	1558,	'_oembed_9c920a921aeac3a97a6ae39b8f0821a6',	'{{unknown}}'),
(6536,	1558,	'_oembed_c94d28c278e1c641ea25b483587fbee3',	'{{unknown}}'),
(6534,	1558,	'xyz_fbap',	'1'),
(6537,	1558,	'_oembed_74e7f6a8ef188168210872363a557f05',	'{{unknown}}'),
(6538,	1559,	'_edit_last',	'1'),
(6542,	1559,	'_oembed_09360159f5c7d78730e9498dd4392f57',	'{{unknown}}'),
(6545,	1559,	'_jd_tweet_this',	'yes'),
(6541,	1559,	'xyz_fbap',	'1'),
(6543,	1559,	'_oembed_0b3c0ff2da13017c3fff9684cb40fc81',	'{{unknown}}'),
(6544,	1559,	'_oembed_0deeaf415a72f2808f79e3ee79be5434',	'{{unknown}}'),
(6546,	1559,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/assembly-processes-finishing-packaging-and-automation.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6547,	1559,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fassembly-processes-finishing-packaging-and-automation.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6548,	1559,	'_wptp_twitter_api',	'a:1:{i:0;s:189:\"Assembly Processes Finishing Packaging and Automation http://hotfile.pw/ebooks/assembly-processes-finishing-packaging-and-automation.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6549,	1559,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6550,	1559,	'_edit_lock',	'1451469230:1'),
(6551,	1561,	'_edit_last',	'1'),
(6555,	1561,	'_oembed_3db4c030ac5910ea1377666c614aa31b',	'{{unknown}}'),
(6558,	1561,	'_jd_tweet_this',	'yes'),
(6554,	1561,	'xyz_fbap',	'1'),
(6556,	1561,	'_oembed_e8def121c9e71a36d6b5047ae7e5fdc8',	'{{unknown}}'),
(6557,	1561,	'_oembed_5c2e4d9fb14b9b1ef7988a38c9e3bc85',	'{{unknown}}'),
(6559,	1561,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/teach-yourself-visually-excel.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6560,	1561,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fteach-yourself-visually-excel.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6561,	1561,	'_wptp_twitter_api',	'a:1:{i:0;s:141:\"Teach Yourself Visually Excel http://hotfile.pw/ebooks/teach-yourself-visually-excel.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6562,	1561,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6563,	1561,	'_edit_lock',	'1451469366:1'),
(6564,	1563,	'_edit_last',	'1'),
(6568,	1563,	'_oembed_daae6edce31f10767a54e28abaf09989',	'{{unknown}}'),
(6571,	1563,	'_jd_tweet_this',	'yes'),
(6567,	1563,	'xyz_fbap',	'1'),
(6569,	1563,	'_oembed_eeccbcf87863aa7a41696b2db97cd45d',	'{{unknown}}'),
(6570,	1563,	'_oembed_896b19045990d8f5ba953d037f446e4c',	'{{unknown}}'),
(6572,	1563,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/comics-and-power-representing-and-questioning-culture-subjects-and-communities.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6573,	1563,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcomics-and-power-representing-and-questioning-culture-subjects-and-communities.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6574,	1563,	'_wptp_twitter_api',	'a:1:{i:0;s:239:\"Comics and Power Representing and Questioning Culture Subjects and Communities http://hotfile.pw/ebooks/comics-and-power-representing-and-questioning-culture-subjects-and-communities.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6575,	1563,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6576,	1563,	'_edit_lock',	'1451469499:1'),
(6577,	1565,	'_edit_last',	'1'),
(6581,	1565,	'_oembed_7e9bfff1f2f1c633edcefeaf3cc2e0ce',	'{{unknown}}'),
(6584,	1565,	'_jd_tweet_this',	'yes'),
(6580,	1565,	'xyz_fbap',	'1'),
(6582,	1565,	'_oembed_9452b732e0ef780b9b514c390aae6086',	'{{unknown}}'),
(6583,	1565,	'_oembed_cf3c2c6cf66ed354c70eee623cbb7968',	'{{unknown}}'),
(6585,	1565,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/proteotronics-development-of-proteinbased-electronics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6586,	1565,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fproteotronics-development-of-proteinbased-electronics.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6587,	1565,	'_wptp_twitter_api',	'a:1:{i:0;s:189:\"Proteotronics Development of ProteinBased Electronics http://hotfile.pw/ebooks/proteotronics-development-of-proteinbased-electronics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6588,	1565,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6589,	1565,	'_edit_lock',	'1451469631:1'),
(6590,	1567,	'_edit_last',	'1'),
(6594,	1567,	'_oembed_a548cc66f221d45b5dd75ac6e889b076',	'{{unknown}}'),
(6597,	1567,	'_jd_tweet_this',	'yes'),
(6593,	1567,	'xyz_fbap',	'1'),
(6595,	1567,	'_oembed_ff237580a03c3d4fddbb88949f970e07',	'{{unknown}}'),
(6596,	1567,	'_oembed_9a7d967618332cecac7f365abb5b5e4e',	'{{unknown}}'),
(6598,	1567,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/a-concise-history-of-nazi-germany-fourth-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6599,	1567,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fa-concise-history-of-nazi-germany-fourth-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6600,	1567,	'_wptp_twitter_api',	'a:1:{i:0;s:179:\"A Concise History of Nazi Germany Fourth Edition http://hotfile.pw/ebooks/a-concise-history-of-nazi-germany-fourth-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6601,	1567,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6602,	1567,	'_edit_lock',	'1451469764:1'),
(6603,	1569,	'_edit_last',	'1'),
(6607,	1569,	'_oembed_57cf2416c3199dcb02162c7625e339da',	'{{unknown}}'),
(6609,	1569,	'_oembed_3183aa0b8e6fff1426a414527e97600d',	'{{unknown}}'),
(6606,	1569,	'xyz_fbap',	'1'),
(6608,	1569,	'_oembed_80114d02ee2ffbfbd098a1c1456b83ac',	'{{unknown}}'),
(6610,	1569,	'_jd_tweet_this',	'yes'),
(6611,	1569,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/caterpillage-reflections-on-seventeenthcentury-dutch-still-life-painting.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6612,	1569,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcaterpillage-reflections-on-seventeenthcentury-dutch-still-life-painting.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6613,	1569,	'_wptp_twitter_api',	'a:1:{i:0;s:227:\"Caterpillage Reflections on Seventeenthcentury Dutch Still Life Painting http://hotfile.pw/ebooks/caterpillage-reflections-on-seventeenthcentury-dutch-still-life-painting.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6614,	1569,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6615,	1569,	'_edit_lock',	'1451469899:1'),
(6616,	1571,	'_edit_last',	'1'),
(6620,	1571,	'_oembed_f59958f6c0df927c7bd86c80d07041c7',	'{{unknown}}'),
(6622,	1571,	'_oembed_21fd3e4f069b418eaf916e7d3499172c',	'{{unknown}}'),
(6619,	1571,	'xyz_fbap',	'1'),
(6621,	1571,	'_oembed_9f762d5e7100f320e6b82b48e0f69064',	'{{unknown}}'),
(6623,	1571,	'_jd_tweet_this',	'yes'),
(6624,	1571,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/comptia-healthcare-it-technician-hit001-cert-guide.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6625,	1571,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcomptia-healthcare-it-technician-hit001-cert-guide.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6626,	1571,	'_wptp_twitter_api',	'a:1:{i:0;s:183:\"CompTIA Healthcare IT Technician HIT001 Cert Guide http://hotfile.pw/ebooks/comptia-healthcare-it-technician-hit001-cert-guide.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6627,	1571,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6628,	1571,	'_edit_lock',	'1451470030:1'),
(6629,	1573,	'_edit_last',	'1'),
(6633,	1573,	'_oembed_672d9fdde835dcf7015b63c60127b246',	'{{unknown}}'),
(6634,	1573,	'_oembed_c7a136697148bbf873cb11d21f635469',	'{{unknown}}'),
(6632,	1573,	'xyz_fbap',	'1'),
(6635,	1573,	'_oembed_20dea28939147242c916d7ec49b45433',	'{{unknown}}'),
(6636,	1573,	'_jd_tweet_this',	'yes'),
(6637,	1573,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/kings-lords-and-men-in-scotland-and-britain-13001625-essays-in-honour-of-jenny-w.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6638,	1573,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fkings-lords-and-men-in-scotland-and-britain-13001625-essays-in-honour-of-jenny-w.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6639,	1573,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"Kings Lords and Men in Scotland and Britain 13001625 Essays in Honour of Jenny W... http://hotfile.pw/ebooks/kings-lords-and-men-in-scotland-and-britain-13001625-essays-in-honour-of-jenny-w.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6640,	1573,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6641,	1573,	'_edit_lock',	'1451470160:1'),
(6642,	1575,	'_edit_last',	'1'),
(6646,	1575,	'_oembed_516951c5c62ac53ec8eba68b5b1f011b',	'{{unknown}}'),
(6647,	1575,	'_oembed_e9c48f2aac5adedec53aa6dec1ce4f9d',	'{{unknown}}'),
(6645,	1575,	'xyz_fbap',	'1'),
(6648,	1575,	'_oembed_8f35c34f99ec76fd0dd9539ecee56f62',	'{{unknown}}'),
(6649,	1575,	'_jd_tweet_this',	'yes'),
(6650,	1575,	'_wp_jd_wp',	'http://hotfile.pw/magazines/pirate-informatique-juilletseptembre.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6651,	1575,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmagazines%2Fpirate-informatique-juilletseptembre.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6652,	1575,	'_wptp_twitter_api',	'a:1:{i:0;s:158:\"Pirate Informatique JuilletSeptembre http://hotfile.pw/magazines/pirate-informatique-juilletseptembre.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6653,	1575,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6654,	1575,	'_edit_lock',	'1451470291:1'),
(6655,	1577,	'_edit_last',	'1'),
(6659,	1577,	'_oembed_72022fd98e3ee6d0a3b47cd3d8ee3512',	'{{unknown}}'),
(6662,	1577,	'_jd_tweet_this',	'yes'),
(6658,	1577,	'xyz_fbap',	'1'),
(6660,	1577,	'_oembed_9e08d631dd444f0e6f12cac272eb5f27',	'{{unknown}}'),
(6661,	1577,	'_oembed_742a0d45911ff97d0f6eb64cd2f3c229',	'{{unknown}}'),
(6663,	1577,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/understanding-color-an-introduction-for-designers-4th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6664,	1577,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Funderstanding-color-an-introduction-for-designers-4th-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6665,	1577,	'_wptp_twitter_api',	'a:1:{i:0;s:205:\"Understanding Color An Introduction for Designers 4th Edition http://hotfile.pw/ebooks/understanding-color-an-introduction-for-designers-4th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6666,	1577,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6667,	1577,	'_edit_lock',	'1451470423:1'),
(6668,	1579,	'_edit_last',	'1'),
(6672,	1579,	'_oembed_18d82ac4e7a2974408afd8aa84c2f5ec',	'{{unknown}}'),
(6673,	1579,	'_oembed_f94ef6077e04b948ed12b10f40caac45',	'{{unknown}}'),
(6671,	1579,	'xyz_fbap',	'1'),
(6674,	1579,	'_oembed_bd30848166ada6c0ba6aec26ee1d7988',	'{{unknown}}'),
(6675,	1579,	'_jd_tweet_this',	'yes'),
(6676,	1579,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-origins-of-the-slavic-nations-premodern-identities-in-russia-ukraine-and-bel.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6677,	1579,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-origins-of-the-slavic-nations-premodern-identities-in-russia-ukraine-and-bel.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6678,	1579,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"The Origins of the Slavic Nations Premodern Identities in Russia Ukraine and Bel... http://hotfile.pw/ebooks/the-origins-of-the-slavic-nations-premodern-identities-in-russia-ukraine-and-bel.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6679,	1579,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6680,	1579,	'_edit_lock',	'1451470557:1'),
(6681,	1581,	'_edit_last',	'1'),
(6685,	1581,	'_oembed_716bf8e31292438ce912f73b17b0cd2b',	'{{unknown}}'),
(6686,	1581,	'_oembed_7edd21df550f430967a0cdaa3eba0859',	'{{unknown}}'),
(6684,	1581,	'xyz_fbap',	'1'),
(6687,	1581,	'_oembed_7c52dbbeceb9738c44806c65451a99e6',	'{{unknown}}'),
(6688,	1581,	'_jd_tweet_this',	'yes'),
(6689,	1581,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/video-theory-online-video-aesthetics-or-the-afterlife-of-video.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6690,	1581,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fvideo-theory-online-video-aesthetics-or-the-afterlife-of-video.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6691,	1581,	'_wptp_twitter_api',	'a:1:{i:0;s:207:\"Video Theory Online Video Aesthetics or the Afterlife of Video http://hotfile.pw/ebooks/video-theory-online-video-aesthetics-or-the-afterlife-of-video.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6692,	1581,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6693,	1581,	'_edit_lock',	'1451470690:1'),
(6694,	1583,	'_edit_last',	'1'),
(6698,	1583,	'_oembed_ef0fc04986aa5599e98c9ec7b1a0a4c6',	'{{unknown}}'),
(6700,	1583,	'_oembed_8c9bc64595f9f7b15a3317b2afd41015',	'{{unknown}}'),
(6697,	1583,	'xyz_fbap',	'1'),
(6699,	1583,	'_oembed_ae655d560c7101ec31bc3f66af4f6769',	'{{unknown}}'),
(6701,	1583,	'_jd_tweet_this',	'yes'),
(6702,	1583,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-rough-guide-to-florida.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6703,	1583,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-rough-guide-to-florida.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6704,	1583,	'_wptp_twitter_api',	'a:1:{i:0;s:135:\"The Rough Guide to Florida http://hotfile.pw/ebooks/the-rough-guide-to-florida.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6705,	1583,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6706,	1583,	'_edit_lock',	'1451470822:1'),
(6707,	1585,	'_edit_last',	'1'),
(6711,	1585,	'_oembed_58650d7a78f622c27f166d6ff78e0989',	'{{unknown}}'),
(6712,	1585,	'_oembed_e8078b102e326048ab894d107b4cabba',	'{{unknown}}'),
(6710,	1585,	'xyz_fbap',	'1'),
(6713,	1585,	'_oembed_aa147bcfd94a4dbdc8ca6efbf39e9c73',	'{{unknown}}'),
(6714,	1586,	'_edit_last',	'1'),
(6718,	1586,	'_oembed_38002fd5d3bf5fa291220f9b5e3ca5b6',	'{{unknown}}'),
(6721,	1586,	'_jd_tweet_this',	'yes'),
(6717,	1586,	'xyz_fbap',	'1'),
(6719,	1586,	'_oembed_869e36001af381bd14bc1b9257a28e8d',	'{{unknown}}'),
(6720,	1586,	'_oembed_5b655fc2521c407c1f70ca833206acc5',	'{{unknown}}'),
(6722,	1586,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/air-fryer-cooking-26-super-simple-speedy-air-fryer-recipes.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6723,	1586,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fair-fryer-cooking-26-super-simple-speedy-air-fryer-recipes.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6724,	1586,	'_wptp_twitter_api',	'a:1:{i:0;s:199:\"Air fryer Cooking 26 Super Simple Speedy Air Fryer Recipes http://hotfile.pw/ebooks/air-fryer-cooking-26-super-simple-speedy-air-fryer-recipes.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6725,	1586,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6726,	1586,	'_edit_lock',	'1451471098:1'),
(6727,	1588,	'_edit_last',	'1'),
(6731,	1588,	'_oembed_f42c329c2f6cb49e631a4d866670450e',	'{{unknown}}'),
(6733,	1588,	'_oembed_a4f7a583936e3b4396373e2d8d7d7852',	'{{unknown}}'),
(6730,	1588,	'xyz_fbap',	'1'),
(6732,	1588,	'_oembed_c99d228ef1b6f6a111c4e88f53fc1c7d',	'{{unknown}}'),
(6734,	1588,	'_jd_tweet_this',	'yes'),
(6735,	1588,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/penile-cancer-diagnosis-and-treatment.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6736,	1588,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fpenile-cancer-diagnosis-and-treatment.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6737,	1588,	'_wptp_twitter_api',	'a:1:{i:0;s:157:\"Penile Cancer Diagnosis and Treatment http://hotfile.pw/ebooks/penile-cancer-diagnosis-and-treatment.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6738,	1588,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6739,	1588,	'_edit_lock',	'1451471230:1'),
(6740,	1590,	'_edit_last',	'1'),
(6744,	1590,	'_oembed_38afe3dd71669f2776ba90bcfe698c11',	'{{unknown}}'),
(6747,	1590,	'_jd_tweet_this',	'yes'),
(6743,	1590,	'xyz_fbap',	'1'),
(6745,	1590,	'_oembed_22daebced70230e85ce20e0b272947b8',	'{{unknown}}'),
(6746,	1590,	'_oembed_9fd3c73dfe60beab222f78bc7896de93',	'{{unknown}}'),
(6748,	1590,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/lost-in-space-architecture-and-dementia.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6749,	1590,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Flost-in-space-architecture-and-dementia.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6750,	1590,	'_wptp_twitter_api',	'a:1:{i:0;s:161:\"Lost in Space Architecture and Dementia http://hotfile.pw/ebooks/lost-in-space-architecture-and-dementia.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6751,	1590,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6752,	1590,	'_edit_lock',	'1451471360:1'),
(6753,	1592,	'_edit_last',	'1'),
(6758,	1592,	'_oembed_b8593dff90f9d5d6edcf1b988bf3d02c',	'{{unknown}}'),
(6760,	1592,	'_jd_tweet_this',	'yes'),
(6756,	1592,	'xyz_fbap',	'1'),
(6757,	1592,	'_oembed_270766af0bec2d9ffd6c736ad507034c',	'{{unknown}}'),
(6759,	1592,	'_oembed_2f86787f6745ced73c05bf6943283a31',	'{{unknown}}'),
(6761,	1592,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/comfortably-numb-the-inside-story-of-pink-floyd.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6762,	1592,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcomfortably-numb-the-inside-story-of-pink-floyd.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6763,	1592,	'_wptp_twitter_api',	'a:1:{i:0;s:177:\"Comfortably Numb The Inside Story of Pink Floyd http://hotfile.pw/ebooks/comfortably-numb-the-inside-story-of-pink-floyd.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6764,	1592,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6765,	1592,	'_edit_lock',	'1451471492:1'),
(6766,	1594,	'_edit_last',	'1'),
(6770,	1594,	'_oembed_4abbcab35709b2fefecea85a73186776',	'{{unknown}}'),
(6773,	1594,	'_jd_tweet_this',	'yes'),
(6769,	1594,	'xyz_fbap',	'1'),
(6771,	1594,	'_oembed_ff7d14bfc3f525b9543fee017f4afa1b',	'{{unknown}}'),
(6772,	1594,	'_oembed_57b33643f5a287eb8fd2c1015b7cd742',	'{{unknown}}'),
(6774,	1594,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/pharmacology-for-the-physical-therapist.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6775,	1594,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fpharmacology-for-the-physical-therapist.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6776,	1594,	'_wptp_twitter_api',	'a:1:{i:0;s:161:\"Pharmacology for the Physical Therapist http://hotfile.pw/ebooks/pharmacology-for-the-physical-therapist.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6777,	1594,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6778,	1594,	'_edit_lock',	'1451471624:1'),
(6779,	1596,	'_edit_last',	'1'),
(6783,	1596,	'_oembed_3c89a443aeaddb19b797c367b80bcfeb',	'{{unknown}}'),
(6785,	1596,	'_oembed_bc18e047a322ab200c96be36e0d9ebe3',	'{{unknown}}'),
(6782,	1596,	'xyz_fbap',	'1'),
(6784,	1596,	'_oembed_701514442a454e0a3f20ddeea359fffa',	'{{unknown}}'),
(6786,	1596,	'_jd_tweet_this',	'yes'),
(6787,	1596,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/albrecht-altdorfer-and-the-origins-of-landscape-revised-and-expanded-second-edit.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6788,	1596,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Falbrecht-altdorfer-and-the-origins-of-landscape-revised-and-expanded-second-edit.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6789,	1596,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"Albrecht Altdorfer and the Origins of Landscape Revised and Expanded Second Edit... http://hotfile.pw/ebooks/albrecht-altdorfer-and-the-origins-of-landscape-revised-and-expanded-second-edit.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6790,	1596,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6791,	1596,	'_edit_lock',	'1451471755:1'),
(6792,	1598,	'_edit_last',	'1'),
(6796,	1598,	'_oembed_16b2a1276e168db2f580a1f3eb08dee8',	'{{unknown}}'),
(6798,	1598,	'_oembed_fe1f5567ccb3e6bc90c9ac5d58a52e58',	'{{unknown}}'),
(6795,	1598,	'xyz_fbap',	'1'),
(6797,	1598,	'_oembed_e62626866ef3a26dce1d02c6019616c1',	'{{unknown}}'),
(6799,	1598,	'_jd_tweet_this',	'yes'),
(6800,	1598,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/automated-diagnostics-and-analytics-for-buildings.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6801,	1598,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fautomated-diagnostics-and-analytics-for-buildings.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6802,	1598,	'_wptp_twitter_api',	'a:1:{i:0;s:181:\"Automated Diagnostics and Analytics for Buildings http://hotfile.pw/ebooks/automated-diagnostics-and-analytics-for-buildings.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6803,	1598,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6804,	1598,	'_edit_lock',	'1451471887:1'),
(6805,	1600,	'_edit_last',	'1'),
(6809,	1600,	'_oembed_69a3c41ae18ec5ed576920a064cc6551',	'{{unknown}}'),
(6810,	1600,	'_oembed_760eefcdcc8e351e1a38e8e450a19c65',	'{{unknown}}'),
(6808,	1600,	'xyz_fbap',	'1'),
(6811,	1600,	'_oembed_555cf7a7c732ca0df431cb53ada84683',	'{{unknown}}'),
(6812,	1600,	'_jd_tweet_this',	'yes'),
(6813,	1600,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/opencv-android-programming-by-example.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6814,	1600,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fopencv-android-programming-by-example.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6815,	1600,	'_wptp_twitter_api',	'a:1:{i:0;s:157:\"OpenCV Android Programming By Example http://hotfile.pw/ebooks/opencv-android-programming-by-example.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6816,	1600,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6817,	1600,	'_edit_lock',	'1451472019:1'),
(6818,	1602,	'_edit_last',	'1'),
(6822,	1602,	'_oembed_c8521bffa5b51f71faccdfddac49af1e',	'{{unknown}}'),
(6825,	1602,	'_jd_tweet_this',	'yes'),
(6821,	1602,	'xyz_fbap',	'1'),
(6823,	1602,	'_oembed_b075495852bb2769cab2fa916a201e82',	'{{unknown}}'),
(6824,	1602,	'_oembed_fcf2e6a19b9272f113ebdc8b1e501b43',	'{{unknown}}'),
(6826,	1602,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/a-brief-history-of-indonesia-sultans-spices-and-tsunamis-the-incredible-story-of.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6827,	1602,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fa-brief-history-of-indonesia-sultans-spices-and-tsunamis-the-incredible-story-of.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6828,	1602,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"A Brief History of Indonesia Sultans Spices and Tsunamis The Incredible Story of... http://hotfile.pw/ebooks/a-brief-history-of-indonesia-sultans-spices-and-tsunamis-the-incredible-story-of.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6829,	1602,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6830,	1602,	'_edit_lock',	'1451472150:1'),
(6831,	1604,	'_edit_last',	'1'),
(6835,	1604,	'_oembed_483e3558c801af4a049d0008e01da120',	'{{unknown}}'),
(6836,	1604,	'_oembed_283b74ca7f2f0b903e1a95cbcce24d4b',	'{{unknown}}'),
(6834,	1604,	'xyz_fbap',	'1'),
(6837,	1604,	'_oembed_0f6764104057f82074f3573b993e6fd6',	'{{unknown}}'),
(6838,	1604,	'_jd_tweet_this',	'yes'),
(6839,	1604,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-rough-guide-to-bangkok.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6840,	1604,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-rough-guide-to-bangkok.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6841,	1604,	'_wptp_twitter_api',	'a:1:{i:0;s:135:\"The Rough Guide to Bangkok http://hotfile.pw/ebooks/the-rough-guide-to-bangkok.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6842,	1604,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6843,	1604,	'_edit_lock',	'1451472283:1'),
(6844,	1606,	'_edit_last',	'1'),
(6848,	1606,	'_oembed_d2ca5a29ecfd6d4e7d2c6a4a5fd797ea',	'{{unknown}}'),
(6851,	1606,	'_jd_tweet_this',	'yes'),
(6847,	1606,	'xyz_fbap',	'1'),
(6849,	1606,	'_oembed_0c9c0c03bb42d890a4483c63dce2068c',	'{{unknown}}'),
(6850,	1606,	'_oembed_dd41b78185d1812b39aca941a9e829d9',	'{{unknown}}'),
(6852,	1606,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/50-successful-harvard-application-essays-4th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6853,	1606,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2F50-successful-harvard-application-essays-4th-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6854,	1606,	'_wptp_twitter_api',	'a:1:{i:0;s:187:\"50 Successful Harvard Application Essays 4th Edition http://hotfile.pw/ebooks/50-successful-harvard-application-essays-4th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6855,	1606,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6856,	1606,	'_edit_lock',	'1451472412:1'),
(6857,	1608,	'_edit_last',	'1'),
(6861,	1608,	'_oembed_5c017b455e3b30bf97152425e875e36b',	'{{unknown}}'),
(6863,	1608,	'_oembed_c66aac2ad03446aecd965effe015cda3',	'{{unknown}}'),
(6860,	1608,	'xyz_fbap',	'1'),
(6862,	1608,	'_oembed_f197928c773fb302d2c696a5d2db375c',	'{{unknown}}'),
(6864,	1608,	'_jd_tweet_this',	'yes'),
(6865,	1608,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/photodermatology.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6866,	1608,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fphotodermatology.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6867,	1608,	'_wptp_twitter_api',	'a:1:{i:0;s:115:\"Photodermatology http://hotfile.pw/ebooks/photodermatology.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6868,	1608,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6869,	1608,	'_edit_lock',	'1451472542:1'),
(6870,	1610,	'_edit_last',	'1'),
(6874,	1610,	'_oembed_25121811daace4eaf588783858aa00d0',	'{{unknown}}'),
(6877,	1610,	'_jd_tweet_this',	'yes'),
(6873,	1610,	'xyz_fbap',	'1'),
(6875,	1610,	'_oembed_113e5a91d9b5087522ff9174a9f33f7b',	'{{unknown}}'),
(6876,	1610,	'_oembed_5631e2ec36121cadbfcb29daf038d3f4',	'{{unknown}}'),
(6878,	1610,	'_wp_jd_wp',	'http://hotfile.pw/magazines/mens-health-south-africa-january.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6879,	1610,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmagazines%2Fmens-health-south-africa-january.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6880,	1610,	'_wptp_twitter_api',	'a:1:{i:0;s:150:\"Mens Health South Africa January http://hotfile.pw/magazines/mens-health-south-africa-january.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6881,	1610,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6882,	1610,	'_edit_lock',	'1451472673:1'),
(6883,	1612,	'_edit_last',	'1'),
(6887,	1612,	'_oembed_8985c8f2c503db18fdf925b5ce9d8a02',	'{{unknown}}'),
(6890,	1613,	'_edit_last',	'1'),
(6886,	1612,	'xyz_fbap',	'1'),
(6888,	1612,	'_oembed_af37a1534661108e6e55da8929bbfc75',	'{{unknown}}'),
(6889,	1612,	'_oembed_f8702a075645b5611fe160682cdf8a7c',	'{{unknown}}'),
(6894,	1613,	'_oembed_1adc7e2e18e6248545eef909517c6067',	'{{unknown}}'),
(6897,	1613,	'_jd_tweet_this',	'yes'),
(6893,	1613,	'xyz_fbap',	'1'),
(6895,	1613,	'_oembed_127b5edd284a6dfd2b9c5825cb6dcc60',	'{{unknown}}'),
(6896,	1613,	'_oembed_9bcd74e8d026463a2d31e3ca35d4754d',	'{{unknown}}'),
(6898,	1613,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/132-delicious-salads-dressings-and-dips.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6899,	1613,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2F132-delicious-salads-dressings-and-dips.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6900,	1613,	'_wptp_twitter_api',	'a:1:{i:0;s:161:\"132 Delicious Salads Dressings And Dips http://hotfile.pw/ebooks/132-delicious-salads-dressings-and-dips.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6901,	1613,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6902,	1613,	'_edit_lock',	'1451472946:1'),
(6903,	1615,	'_edit_last',	'1'),
(6907,	1615,	'_oembed_c7bd1cf70b22bd3ea461c21f42abe20a',	'{{unknown}}'),
(6910,	1615,	'_jd_tweet_this',	'yes'),
(6906,	1615,	'xyz_fbap',	'1'),
(6908,	1615,	'_oembed_c8456b2f0dd5c0dbb3e1410f7f47c9fc',	'{{unknown}}'),
(6909,	1615,	'_oembed_61d3130bc8aaf73fd67dfe8ac08b7ab0',	'{{unknown}}'),
(6911,	1615,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/50-ways-to-wear-a-scarf.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6912,	1615,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2F50-ways-to-wear-a-scarf.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6913,	1615,	'_wptp_twitter_api',	'a:1:{i:0;s:129:\"50 Ways to Wear a Scarf http://hotfile.pw/ebooks/50-ways-to-wear-a-scarf.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6914,	1615,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6915,	1615,	'_edit_lock',	'1451473079:1'),
(6916,	1617,	'_edit_last',	'1'),
(6920,	1617,	'_oembed_1ed5984a0bc6edaef23f75443bdbbbab',	'{{unknown}}'),
(6923,	1617,	'_jd_tweet_this',	'yes'),
(6919,	1617,	'xyz_fbap',	'1'),
(6921,	1617,	'_oembed_41af130e52bf03c15147d031a28b9261',	'{{unknown}}'),
(6922,	1617,	'_oembed_09a9b6bb697397ca8b68483315d95736',	'{{unknown}}'),
(6924,	1617,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/complex-variables-and-applications-8th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6925,	1617,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcomplex-variables-and-applications-8th-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6926,	1617,	'_wptp_twitter_api',	'a:1:{i:0;s:175:\"Complex Variables and Applications 8th edition http://hotfile.pw/ebooks/complex-variables-and-applications-8th-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6927,	1617,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6928,	1617,	'_edit_lock',	'1451473208:1'),
(6929,	1619,	'_edit_last',	'1'),
(6933,	1619,	'_oembed_05cab65a899d868254a6a2ad7449a324',	'{{unknown}}'),
(6935,	1619,	'_oembed_18d5772e3e0338a190d2abc8987c813c',	'{{unknown}}'),
(6932,	1619,	'xyz_fbap',	'1'),
(6934,	1619,	'_oembed_d40f033c9021663be5edce97c9bab699',	'{{unknown}}'),
(6936,	1619,	'_jd_tweet_this',	'yes'),
(6937,	1619,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/a-concise-introduction-to-mathematical-logic-3rd-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6938,	1619,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fa-concise-introduction-to-mathematical-logic-3rd-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6939,	1619,	'_wptp_twitter_api',	'a:1:{i:0;s:195:\"A Concise Introduction to Mathematical Logic 3rd edition http://hotfile.pw/ebooks/a-concise-introduction-to-mathematical-logic-3rd-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6940,	1619,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6941,	1619,	'_edit_lock',	'1451473337:1'),
(6942,	1621,	'_edit_last',	'1'),
(6946,	1621,	'_oembed_e751f64a980c06447d5a07191fd523db',	'{{unknown}}'),
(6949,	1621,	'_jd_tweet_this',	'yes'),
(6945,	1621,	'xyz_fbap',	'1'),
(6947,	1621,	'_oembed_45b1695280db1f27e22216e85db14e84',	'{{unknown}}'),
(6948,	1621,	'_oembed_23ea68858b59710850ef6d49f99ccc20',	'{{unknown}}'),
(6950,	1621,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/choosing-craft-the-artists-viewpoint.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6951,	1621,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fchoosing-craft-the-artists-viewpoint.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6952,	1621,	'_wptp_twitter_api',	'a:1:{i:0;s:155:\"Choosing Craft The Artists Viewpoint http://hotfile.pw/ebooks/choosing-craft-the-artists-viewpoint.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6953,	1621,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6954,	1621,	'_edit_lock',	'1451473469:1'),
(6955,	1623,	'_edit_last',	'1'),
(6959,	1623,	'_oembed_800ede8d8f2287005ada17b0a0c3ec7d',	'{{unknown}}'),
(6962,	1623,	'_jd_tweet_this',	'yes'),
(6958,	1623,	'xyz_fbap',	'1'),
(6960,	1623,	'_oembed_1e77653642d0366ae98cc72aa7e16e07',	'{{unknown}}'),
(6961,	1623,	'_oembed_f4e3bac9c3a69199752b1dcb833e10e1',	'{{unknown}}'),
(6963,	1623,	'_wp_jd_wp',	'http://hotfile.pw/magazines/tom-tom-magazine-winter-20152016.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6964,	1623,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmagazines%2Ftom-tom-magazine-winter-20152016.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6965,	1623,	'_wptp_twitter_api',	'a:1:{i:0;s:150:\"Tom Tom Magazine Winter 20152016 http://hotfile.pw/magazines/tom-tom-magazine-winter-20152016.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6966,	1623,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6967,	1623,	'_edit_lock',	'1451473599:1'),
(6968,	1625,	'_edit_last',	'1'),
(6972,	1625,	'_oembed_fe24ddbb159f3e66e4a4263ca13e4eb3',	'{{unknown}}'),
(6975,	1625,	'_jd_tweet_this',	'yes'),
(6971,	1625,	'xyz_fbap',	'1'),
(6973,	1625,	'_oembed_6658d315df7630a9ba37a64a793f129b',	'{{unknown}}'),
(6974,	1625,	'_oembed_00c3c96ffaf583a9141b35a0bd10394a',	'{{unknown}}'),
(6976,	1625,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/modern-techniques-of-surface-science.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6977,	1625,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fmodern-techniques-of-surface-science.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6978,	1625,	'_wptp_twitter_api',	'a:1:{i:0;s:155:\"Modern Techniques of Surface Science http://hotfile.pw/ebooks/modern-techniques-of-surface-science.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6979,	1625,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6980,	1625,	'_edit_lock',	'1451473729:1'),
(6981,	1627,	'_edit_last',	'1'),
(6985,	1627,	'_oembed_877be4584a7bcbf6cbf64f11fbda650d',	'{{unknown}}'),
(6987,	1627,	'_oembed_4407500b5a7b038314b841bbd3181e31',	'{{unknown}}'),
(6984,	1627,	'xyz_fbap',	'1'),
(6986,	1627,	'_oembed_b118d6bda5816494fe2c0ca6327ef964',	'{{unknown}}'),
(6988,	1627,	'_jd_tweet_this',	'yes'),
(6989,	1627,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/unconventional-methods-for-oil-gas-exploration-in-cuba.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(6990,	1627,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Funconventional-methods-for-oil-gas-exploration-in-cuba.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(6991,	1627,	'_wptp_twitter_api',	'a:1:{i:0;s:191:\"Unconventional Methods for Oil Gas Exploration in Cuba http://hotfile.pw/ebooks/unconventional-methods-for-oil-gas-exploration-in-cuba.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(6992,	1627,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(6993,	1627,	'_edit_lock',	'1451473860:1'),
(6994,	1629,	'_edit_last',	'1'),
(6998,	1629,	'_oembed_9aeae1f1b54ef05b213fb048bd4a1b33',	'{{unknown}}'),
(6999,	1629,	'_oembed_30c6f419603cfb9c7ec64d495156abe0',	'{{unknown}}'),
(6997,	1629,	'xyz_fbap',	'1'),
(7000,	1629,	'_oembed_996bec80332c751c3debf71af3814e18',	'{{unknown}}'),
(7001,	1629,	'_jd_tweet_this',	'yes'),
(7002,	1629,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/positive-thinking-go-from-negative-to-positive-and-achieve-happiness-and-success.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7003,	1629,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fpositive-thinking-go-from-negative-to-positive-and-achieve-happiness-and-success.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7004,	1629,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"Positive Thinking Go From Negative to Positive and Achieve Happiness and Success... http://hotfile.pw/ebooks/positive-thinking-go-from-negative-to-positive-and-achieve-happiness-and-success.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7005,	1629,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7006,	1629,	'_edit_lock',	'1451473989:1'),
(7007,	1631,	'_edit_last',	'1'),
(7011,	1631,	'_oembed_93014e67cceea319e95cae669f0a8d8e',	'{{unknown}}'),
(7012,	1631,	'_oembed_1c92b4df1e0cdd4459f52e2522af3c24',	'{{unknown}}'),
(7010,	1631,	'xyz_fbap',	'1'),
(7013,	1631,	'_oembed_1388743516c102bdfae0ae597e45b850',	'{{unknown}}'),
(7014,	1631,	'_jd_tweet_this',	'yes'),
(7015,	1631,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/coordinate-metrology.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7016,	1631,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcoordinate-metrology.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7017,	1631,	'_wptp_twitter_api',	'a:1:{i:0;s:123:\"Coordinate Metrology http://hotfile.pw/ebooks/coordinate-metrology.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7018,	1631,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7019,	1631,	'_edit_lock',	'1451474123:1'),
(7020,	1633,	'_edit_last',	'1'),
(7024,	1633,	'_oembed_76ce0bf2ad127b7726232269c4732def',	'{{unknown}}'),
(7027,	1633,	'_jd_tweet_this',	'yes'),
(7023,	1633,	'xyz_fbap',	'1'),
(7025,	1633,	'_oembed_a3041fd533ec043d71a3d81dce8f2c66',	'{{unknown}}'),
(7026,	1633,	'_oembed_59e951b81d6ded1be3377efc1053e988',	'{{unknown}}'),
(7028,	1633,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/hook-to-heal.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7029,	1633,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fhook-to-heal.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7030,	1633,	'_wptp_twitter_api',	'a:1:{i:0;s:107:\"Hook to Heal http://hotfile.pw/ebooks/hook-to-heal.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7031,	1633,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7032,	1633,	'_edit_lock',	'1451474257:1'),
(7033,	1635,	'_edit_last',	'1'),
(7037,	1635,	'_oembed_9c21a91870f36f3e47d77acf3fb5cb23',	'{{unknown}}'),
(7039,	1635,	'_oembed_56e40915d50120d9a640b98be2feb594',	'{{unknown}}'),
(7036,	1635,	'xyz_fbap',	'1'),
(7038,	1635,	'_oembed_981177f933e286c07f3893a2509f91f1',	'{{unknown}}'),
(7040,	1635,	'_jd_tweet_this',	'yes'),
(7041,	1635,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/learn-java-programming-from-scratch.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7042,	1635,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Flearn-java-programming-from-scratch.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7043,	1635,	'_wptp_twitter_api',	'a:1:{i:0;s:153:\"Learn Java programming from scratch http://hotfile.pw/ebooks/learn-java-programming-from-scratch.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7044,	1635,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7045,	1635,	'_edit_lock',	'1451474392:1'),
(7046,	1637,	'_edit_last',	'1'),
(7050,	1637,	'_oembed_4a49e470ad76e9d8c08cd92f26774b09',	'{{unknown}}'),
(7053,	1637,	'_jd_tweet_this',	'yes'),
(7049,	1637,	'xyz_fbap',	'1'),
(7051,	1637,	'_oembed_ed2a55dcb9ded3202eb3b1f959788fb7',	'{{unknown}}'),
(7052,	1637,	'_oembed_f4d6f195db762c2717f6fd3e8e5c105d',	'{{unknown}}'),
(7054,	1637,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-cuban-missile-crisis.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7055,	1637,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-cuban-missile-crisis.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7056,	1637,	'_wptp_twitter_api',	'a:1:{i:0;s:131:\"The Cuban Missile Crisis http://hotfile.pw/ebooks/the-cuban-missile-crisis.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7057,	1637,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7058,	1637,	'_edit_lock',	'1451474522:1'),
(7059,	1639,	'_edit_last',	'1'),
(7063,	1639,	'_oembed_a741af286263ef99f2ecd9e3c6e4cb25',	'{{unknown}}'),
(7062,	1639,	'xyz_fbap',	'1'),
(7064,	1639,	'_oembed_992335218a05595eb7f284112c70403e',	'{{unknown}}'),
(7065,	1639,	'_oembed_acd2c9356235aa007505c292e5d14bd9',	'{{unknown}}'),
(7083,	1642,	'_oembed_0f944b7936527a4f15916e36453d71ad',	'{{unknown}}'),
(7079,	1642,	'_edit_last',	'1'),
(18175,	3304,	'_edit_last',	'1'),
(18174,	3302,	'_edit_lock',	'1451642459:1'),
(18173,	3302,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(18172,	3302,	'_wptp_twitter_api',	'a:1:{i:0;s:145:\"SolidThinking Click2Cast v304009 http://hotfile.pw/apps/solidthinking-click2cast-v304009.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(18171,	3302,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fapps%2Fsolidthinking-click2cast-v304009.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(18168,	3302,	'_oembed_0e57d65526707d1e8d447ac6b24c951a',	'{{unknown}}'),
(18170,	3302,	'_wp_jd_wp',	'http://hotfile.pw/apps/solidthinking-click2cast-v304009.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(18167,	3302,	'_oembed_1b7bc393a599b7722df7a0ceebe32943',	'{{unknown}}'),
(7084,	1642,	'_oembed_12978b5952c73ba38dff69a9ad47c34b',	'{{unknown}}'),
(7082,	1642,	'xyz_fbap',	'1'),
(7085,	1642,	'_oembed_7b9a23138bfe96820106fafa21cbcab0',	'{{unknown}}'),
(7086,	1642,	'_jd_tweet_this',	'yes'),
(7087,	1642,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/stochastic-modeling-for-medical-image-analysis.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7088,	1642,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fstochastic-modeling-for-medical-image-analysis.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7089,	1642,	'_wptp_twitter_api',	'a:1:{i:0;s:175:\"Stochastic Modeling for Medical Image Analysis http://hotfile.pw/ebooks/stochastic-modeling-for-medical-image-analysis.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7090,	1642,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7091,	1642,	'_edit_lock',	'1451474812:1'),
(7092,	1644,	'_edit_last',	'1'),
(7096,	1644,	'_oembed_a89fa15b29f3359204c8df439358bfb5',	'{{unknown}}'),
(7095,	1644,	'xyz_fbap',	'1'),
(7097,	1644,	'_oembed_2e552e574389ab371120dec44ccf1c34',	'{{unknown}}'),
(7098,	1644,	'_oembed_264b6e964d010c7a99d6db02cc489952',	'{{unknown}}'),
(7099,	1644,	'_jd_tweet_this',	'yes'),
(7100,	1644,	'_wp_jd_wp',	'http://hotfile.pw/apps/express-burn-plus-492-portable.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7101,	1644,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fapps%2Fexpress-burn-plus-492-portable.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7102,	1644,	'_wptp_twitter_api',	'a:1:{i:0;s:141:\"Express Burn Plus 492 Portable http://hotfile.pw/apps/express-burn-plus-492-portable.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7103,	1644,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7104,	1644,	'_edit_lock',	'1451474943:1'),
(7105,	1646,	'_edit_last',	'1'),
(7109,	1646,	'_oembed_1d816b530f65f0e99977272820504791',	'{{unknown}}'),
(7112,	1646,	'_jd_tweet_this',	'yes'),
(7108,	1646,	'xyz_fbap',	'1'),
(7110,	1646,	'_oembed_223051a65163481ac748b332e6cf3c95',	'{{unknown}}'),
(7111,	1646,	'_oembed_a4ab38e25cac84f2eb926653f684fd6e',	'{{unknown}}'),
(7113,	1646,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/indie-rock-poster-book.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7114,	1646,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Findie-rock-poster-book.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7115,	1646,	'_wptp_twitter_api',	'a:1:{i:0;s:127:\"Indie Rock Poster Book http://hotfile.pw/ebooks/indie-rock-poster-book.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7116,	1646,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7117,	1646,	'_edit_lock',	'1451475075:1'),
(7118,	1648,	'_edit_last',	'1'),
(7122,	1648,	'_oembed_03fab0bef69b06b45d9c796dd6e5160e',	'{{unknown}}'),
(7125,	1648,	'_jd_tweet_this',	'yes'),
(7121,	1648,	'xyz_fbap',	'1'),
(7123,	1648,	'_oembed_df61144676ac1661cbe4b40ae037c57a',	'{{unknown}}'),
(7124,	1648,	'_oembed_6bfee4f0078993cbdc064480eb835020',	'{{unknown}}'),
(7126,	1648,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/craft-distilling-making-liquor-legally-at-home.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7127,	1648,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcraft-distilling-making-liquor-legally-at-home.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7128,	1648,	'_wptp_twitter_api',	'a:1:{i:0;s:175:\"Craft Distilling Making Liquor Legally at Home http://hotfile.pw/ebooks/craft-distilling-making-liquor-legally-at-home.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7129,	1648,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7130,	1648,	'_edit_lock',	'1451475207:1'),
(7131,	1650,	'_edit_last',	'1'),
(7135,	1650,	'_oembed_4022aaf13aa43d136a2aadc526a47b4a',	'{{unknown}}'),
(7138,	1650,	'_jd_tweet_this',	'yes'),
(7134,	1650,	'xyz_fbap',	'1'),
(7136,	1650,	'_oembed_9e2372d12505e0da19570c65dd180681',	'{{unknown}}'),
(7137,	1650,	'_oembed_9d48fa9926a668d140595590f8e5f294',	'{{unknown}}'),
(7139,	1650,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/nodemcu-development-workshop.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7140,	1650,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fnodemcu-development-workshop.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7141,	1650,	'_wptp_twitter_api',	'a:1:{i:0;s:139:\"NodeMCU Development Workshop http://hotfile.pw/ebooks/nodemcu-development-workshop.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7142,	1650,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7143,	1650,	'_edit_lock',	'1451475339:1'),
(7144,	1652,	'_edit_last',	'1'),
(7148,	1652,	'_oembed_2b44eb6f686d489e1951db8829e2afa2',	'{{unknown}}'),
(7150,	1652,	'_oembed_80d8b2a90040fd3ee43d7d7ccfb5a52e',	'{{unknown}}'),
(7147,	1652,	'xyz_fbap',	'1'),
(7149,	1652,	'_oembed_5beb84d9c71a7803ae6f246cca33a687',	'{{unknown}}'),
(7151,	1652,	'_jd_tweet_this',	'yes'),
(7152,	1652,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/mechanical-behavior-of-materials.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7153,	1652,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fmechanical-behavior-of-materials.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7154,	1652,	'_wptp_twitter_api',	'a:1:{i:0;s:147:\"Mechanical Behavior of Materials http://hotfile.pw/ebooks/mechanical-behavior-of-materials.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7155,	1652,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7156,	1652,	'_edit_lock',	'1451475471:1'),
(7157,	1654,	'_edit_last',	'1'),
(7161,	1654,	'_oembed_3bcd20f59f2f35cdb8e010f19e567e92',	'{{unknown}}'),
(7164,	1654,	'_jd_tweet_this',	'yes'),
(7160,	1654,	'xyz_fbap',	'1'),
(7162,	1654,	'_oembed_e5b39fc97b94e3573999e261401b133e',	'{{unknown}}'),
(7163,	1654,	'_oembed_77f4d3aee44116f6e373f07d62573742',	'{{unknown}}'),
(7165,	1654,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/manufacturing-systems-and-technologies-for-the-new-frontier.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7166,	1654,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fmanufacturing-systems-and-technologies-for-the-new-frontier.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7167,	1654,	'_wptp_twitter_api',	'a:1:{i:0;s:201:\"Manufacturing Systems and Technologies for the New Frontier http://hotfile.pw/ebooks/manufacturing-systems-and-technologies-for-the-new-frontier.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7168,	1654,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7169,	1654,	'_edit_lock',	'1451475604:1'),
(7170,	1656,	'_edit_last',	'1'),
(7174,	1656,	'_oembed_1f0fa92fb1b76afbaea515bc74eff895',	'{{unknown}}'),
(7176,	1656,	'_oembed_a6e0dce2de8b5f0cd3dc4da69dedd81f',	'{{unknown}}'),
(7173,	1656,	'xyz_fbap',	'1'),
(7175,	1656,	'_oembed_09228a1ba821fa5b94ff8e45da34c3b6',	'{{unknown}}'),
(7177,	1656,	'_jd_tweet_this',	'yes'),
(7178,	1656,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/impulsivity-the-behavioral-and-neurological-science-of-discounting.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7179,	1656,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fimpulsivity-the-behavioral-and-neurological-science-of-discounting.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7180,	1656,	'_wptp_twitter_api',	'a:1:{i:0;s:215:\"Impulsivity The Behavioral and Neurological Science of Discounting http://hotfile.pw/ebooks/impulsivity-the-behavioral-and-neurological-science-of-discounting.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7181,	1656,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7182,	1656,	'_edit_lock',	'1451475734:1'),
(7183,	1658,	'_edit_last',	'1'),
(7187,	1658,	'_oembed_2443ab894dab341181ac5886081053dc',	'{{unknown}}'),
(7190,	1658,	'_jd_tweet_this',	'yes'),
(7186,	1658,	'xyz_fbap',	'1'),
(7188,	1658,	'_oembed_0add5482b200237d10c75d949d54f041',	'{{unknown}}'),
(7189,	1658,	'_oembed_8ce53a722daadcadc4fc382f72f35f19',	'{{unknown}}'),
(7191,	1658,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/introduction-to-statistics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7192,	1658,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fintroduction-to-statistics.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7193,	1658,	'_wptp_twitter_api',	'a:1:{i:0;s:135:\"Introduction to Statistics http://hotfile.pw/ebooks/introduction-to-statistics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7194,	1658,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7195,	1658,	'_edit_lock',	'1451475867:1'),
(7196,	1660,	'_edit_last',	'1'),
(7200,	1660,	'_oembed_f6536d77da890327934a11ed7bd58ba2',	'{{unknown}}'),
(7203,	1660,	'_jd_tweet_this',	'yes'),
(7199,	1660,	'xyz_fbap',	'1'),
(7201,	1660,	'_oembed_bfd90cd0718074be95dc715b8577aa77',	'{{unknown}}'),
(7202,	1660,	'_oembed_ce559d460059175f4181b34e4725a366',	'{{unknown}}'),
(7204,	1660,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/css-the-definitive-guide.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7205,	1660,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcss-the-definitive-guide.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7206,	1660,	'_wptp_twitter_api',	'a:1:{i:0;s:131:\"CSS The Definitive Guide http://hotfile.pw/ebooks/css-the-definitive-guide.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7207,	1660,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7208,	1660,	'_edit_lock',	'1451475998:1'),
(7209,	1662,	'_edit_last',	'1'),
(7213,	1662,	'_oembed_cacb58b62c706ab81f1caafafc24364b',	'{{unknown}}'),
(7212,	1662,	'xyz_fbap',	'1'),
(7214,	1662,	'_oembed_ce20e45c74cf157189a9ea943890fa78',	'{{unknown}}'),
(7215,	1662,	'_oembed_68a11c30adb9ad564c2be2175174ac87',	'{{unknown}}'),
(7216,	1662,	'_jd_tweet_this',	'yes'),
(7217,	1662,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/neuroscience-of-ruleguided-behavior.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7218,	1662,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fneuroscience-of-ruleguided-behavior.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7219,	1662,	'_wptp_twitter_api',	'a:1:{i:0;s:153:\"Neuroscience of RuleGuided Behavior http://hotfile.pw/ebooks/neuroscience-of-ruleguided-behavior.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7220,	1662,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7221,	1662,	'_edit_lock',	'1451476136:1'),
(7222,	1664,	'_edit_last',	'1'),
(7226,	1664,	'_oembed_afbd4a9cd50b3668c70d8cbf4bc3f120',	'{{unknown}}'),
(7229,	1664,	'_jd_tweet_this',	'yes'),
(7225,	1664,	'xyz_fbap',	'1'),
(7227,	1664,	'_oembed_77604e0443148ac06f00918f57bf5df6',	'{{unknown}}'),
(7228,	1664,	'_oembed_dc9afbc18efbd6cff56cc3536b0ccb2e',	'{{unknown}}'),
(7230,	1664,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/bayesian-evolutionary-analysis-with-beast.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7231,	1664,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fbayesian-evolutionary-analysis-with-beast.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7232,	1664,	'_wptp_twitter_api',	'a:1:{i:0;s:165:\"Bayesian Evolutionary Analysis with Beast http://hotfile.pw/ebooks/bayesian-evolutionary-analysis-with-beast.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7233,	1664,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7234,	1664,	'_edit_lock',	'1451476268:1'),
(7235,	1666,	'_edit_last',	'1'),
(7239,	1666,	'_oembed_a51351a5020a844b3ce705ce6429f58b',	'{{unknown}}'),
(7242,	1666,	'_jd_tweet_this',	'yes'),
(7238,	1666,	'xyz_fbap',	'1'),
(7240,	1666,	'_oembed_6c2110747887d6824d56242b87be2c95',	'{{unknown}}'),
(7241,	1666,	'_oembed_50177fffac81c3b1f4014573b1e65069',	'{{unknown}}'),
(7243,	1666,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/openam.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7244,	1666,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fopenam.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7245,	1666,	'_wptp_twitter_api',	'a:1:{i:0;s:95:\"OpenAM http://hotfile.pw/ebooks/openam.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7246,	1666,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7247,	1666,	'_edit_lock',	'1451476398:1'),
(7248,	1668,	'_edit_last',	'1'),
(7252,	1668,	'_oembed_92f6393b8a4f850456f8f084376c8b6d',	'{{unknown}}'),
(7255,	1669,	'_edit_last',	'1'),
(7251,	1668,	'xyz_fbap',	'1'),
(7253,	1668,	'_oembed_471755b2fed9c03a369253b620fe123e',	'{{unknown}}'),
(7254,	1668,	'_oembed_a926b9124405654d90db74c2ac20573e',	'{{unknown}}'),
(7259,	1669,	'_oembed_327694717ac7bb3eeded2707f638eb11',	'{{unknown}}'),
(7262,	1669,	'_jd_tweet_this',	'yes'),
(7258,	1669,	'xyz_fbap',	'1'),
(7260,	1669,	'_oembed_f341764e5612d2b91b327fce5d0e015a',	'{{unknown}}'),
(7261,	1669,	'_oembed_f87c3430e32a9b9316426b917cf9ce20',	'{{unknown}}'),
(7263,	1669,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-modified-keto-cookbook-quick-convenient-greattasting-recipes-for-following-a.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7264,	1669,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-modified-keto-cookbook-quick-convenient-greattasting-recipes-for-following-a.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7265,	1669,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"The Modified Keto Cookbook Quick Convenient GreatTasting Recipes for Following a... http://hotfile.pw/ebooks/the-modified-keto-cookbook-quick-convenient-greattasting-recipes-for-following-a.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7266,	1669,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7267,	1669,	'_edit_lock',	'1451476670:1'),
(7268,	1671,	'_edit_last',	'1'),
(7272,	1671,	'_oembed_e13c27836b2eeed14d54ffed94f52c6d',	'{{unknown}}'),
(7274,	1671,	'_oembed_c7e77f77e30097ee0ca3a7bb4113f4b3',	'{{unknown}}'),
(7271,	1671,	'xyz_fbap',	'1'),
(7273,	1671,	'_oembed_9c6b47ed8209ef1607ef44a9098fe53c',	'{{unknown}}'),
(7275,	1671,	'_jd_tweet_this',	'yes'),
(7276,	1671,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/sustainable-supply-chains-operations-and-marketing-the-role-of-legal-compliance.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7277,	1671,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fsustainable-supply-chains-operations-and-marketing-the-role-of-legal-compliance.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7278,	1671,	'_wptp_twitter_api',	'a:1:{i:0;s:241:\"Sustainable Supply Chains Operations and Marketing The Role of Legal Compliance http://hotfile.pw/ebooks/sustainable-supply-chains-operations-and-marketing-the-role-of-legal-compliance.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7279,	1671,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7280,	1671,	'_edit_lock',	'1451476804:1'),
(7281,	1673,	'_edit_last',	'1'),
(7285,	1673,	'_oembed_b1320c8cf78f22aa717218d7a829f743',	'{{unknown}}'),
(7286,	1673,	'_oembed_7187533bec8d998392f3fff235bf1c95',	'{{unknown}}'),
(7284,	1673,	'xyz_fbap',	'1'),
(7287,	1673,	'_oembed_c5cb1ceee2bb4143ad7b43d51d99ed49',	'{{unknown}}'),
(7288,	1673,	'_jd_tweet_this',	'yes'),
(7289,	1673,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/statistical-theory-and-modeling-for-turbulent-flows.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7290,	1673,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fstatistical-theory-and-modeling-for-turbulent-flows.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7291,	1673,	'_wptp_twitter_api',	'a:1:{i:0;s:185:\"Statistical Theory and Modeling for Turbulent Flows http://hotfile.pw/ebooks/statistical-theory-and-modeling-for-turbulent-flows.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7292,	1673,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7293,	1673,	'_edit_lock',	'1451476936:1'),
(7294,	1675,	'_edit_last',	'1'),
(7298,	1675,	'_oembed_edc89c259ebd865dbec8f31f329bcd34',	'{{unknown}}'),
(7297,	1675,	'xyz_fbap',	'1'),
(7299,	1675,	'_oembed_d66e54114c8b3c64be69a32f72a03cdd',	'{{unknown}}'),
(7300,	1675,	'_oembed_6e6876cb5752c52902f22e5c58b17af5',	'{{unknown}}'),
(7301,	1675,	'_jd_tweet_this',	'yes'),
(7302,	1675,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-sensible-guide-to-forex-safer-smarter-ways-to-survive-and-prosper-from-the-s.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7303,	1675,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-sensible-guide-to-forex-safer-smarter-ways-to-survive-and-prosper-from-the-s.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7304,	1675,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"The Sensible Guide to Forex Safer Smarter Ways to Survive and Prosper from the S... http://hotfile.pw/ebooks/the-sensible-guide-to-forex-safer-smarter-ways-to-survive-and-prosper-from-the-s.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7305,	1675,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7306,	1675,	'_edit_lock',	'1451477067:1'),
(7307,	1677,	'_edit_last',	'1'),
(7311,	1677,	'_oembed_0e3bf637104621d5a58adfa010cee89a',	'{{unknown}}'),
(7313,	1677,	'_oembed_51f95896c17f289d8d7eacacd1b541b4',	'{{unknown}}'),
(7310,	1677,	'xyz_fbap',	'1'),
(7312,	1677,	'_oembed_e2c14ab2930a5f17a21bbbbab431fe89',	'{{unknown}}'),
(7314,	1677,	'_jd_tweet_this',	'yes'),
(7315,	1677,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-book-of-forgiving-the-fourfold-path-for-healing-ourselves-and-our-world.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7316,	1677,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-book-of-forgiving-the-fourfold-path-for-healing-ourselves-and-our-world.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7317,	1677,	'_wptp_twitter_api',	'a:1:{i:0;s:233:\"The Book of Forgiving The Fourfold Path for Healing Ourselves and Our World http://hotfile.pw/ebooks/the-book-of-forgiving-the-fourfold-path-for-healing-ourselves-and-our-world.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7318,	1677,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7319,	1677,	'_edit_lock',	'1451477199:1'),
(7320,	1679,	'_edit_last',	'1'),
(7324,	1679,	'_oembed_d1225de9618f0fedd56f47a1f942195a',	'{{unknown}}'),
(7326,	1679,	'_oembed_d088e895284cf5de8e19ef13942c994f',	'{{unknown}}'),
(7323,	1679,	'xyz_fbap',	'1'),
(7325,	1679,	'_oembed_dd34a5c38eeb235b7b113cabb7fa85e4',	'{{unknown}}'),
(7327,	1679,	'_jd_tweet_this',	'yes'),
(7328,	1679,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/sexuality-magic-and-perversion.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7329,	1679,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fsexuality-magic-and-perversion.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7330,	1679,	'_wptp_twitter_api',	'a:1:{i:0;s:143:\"Sexuality Magic and Perversion http://hotfile.pw/ebooks/sexuality-magic-and-perversion.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7331,	1679,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7332,	1679,	'_edit_lock',	'1451477333:1'),
(7333,	1681,	'_edit_last',	'1'),
(7337,	1681,	'_oembed_1f62185552399079d5694e6a17db52de',	'{{unknown}}'),
(7340,	1681,	'_jd_tweet_this',	'yes'),
(7336,	1681,	'xyz_fbap',	'1'),
(7338,	1681,	'_oembed_ef8769c3c016e1ec26f00cef87002a09',	'{{unknown}}'),
(7339,	1681,	'_oembed_3a917bc432da5d0eca5647256069c353',	'{{unknown}}'),
(7341,	1681,	'_wp_jd_wp',	'http://hotfile.pw/apps/hot-mp3-downloader-v3602.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7342,	1681,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fapps%2Fhot-mp3-downloader-v3602.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7343,	1681,	'_wptp_twitter_api',	'a:1:{i:0;s:129:\"Hot MP3 Downloader v3602 http://hotfile.pw/apps/hot-mp3-downloader-v3602.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7344,	1681,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7345,	1681,	'_edit_lock',	'1451477463:1'),
(7346,	1683,	'_edit_last',	'1'),
(7350,	1683,	'_oembed_fbb9eeca35cacdecf41e7cd9ebdcfe07',	'{{unknown}}'),
(7353,	1683,	'_jd_tweet_this',	'yes'),
(7349,	1683,	'xyz_fbap',	'1'),
(7351,	1683,	'_oembed_015a0b2c4c7132f438808d3e1cf5729f',	'{{unknown}}'),
(7352,	1683,	'_oembed_4c020d7a5fa0f5d704f29b07fe66035b',	'{{unknown}}'),
(7354,	1683,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/algorithmic-life-calculative-devices-in-the-age-of-big-data.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7355,	1683,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Falgorithmic-life-calculative-devices-in-the-age-of-big-data.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7356,	1683,	'_wptp_twitter_api',	'a:1:{i:0;s:201:\"Algorithmic Life Calculative Devices in the Age of Big Data http://hotfile.pw/ebooks/algorithmic-life-calculative-devices-in-the-age-of-big-data.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7357,	1683,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7358,	1683,	'_edit_lock',	'1451477595:1'),
(7359,	1685,	'_edit_last',	'1'),
(7363,	1685,	'_oembed_ae8cb7cf9e5a0d5bc4db4eadccefe572',	'{{unknown}}'),
(7366,	1685,	'_jd_tweet_this',	'yes'),
(7362,	1685,	'xyz_fbap',	'1'),
(7364,	1685,	'_oembed_f9426be7cb23f461a76b2cd20f21f0e4',	'{{unknown}}'),
(7365,	1685,	'_oembed_ac521f425a6a6b56c594528d38a3f7eb',	'{{unknown}}'),
(7367,	1685,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/studies-in-the-way-of-words.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7368,	1685,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fstudies-in-the-way-of-words.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7369,	1685,	'_wptp_twitter_api',	'a:1:{i:0;s:137:\"Studies in the Way of Words http://hotfile.pw/ebooks/studies-in-the-way-of-words.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7370,	1685,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7371,	1685,	'_edit_lock',	'1451477728:1'),
(7372,	1687,	'_edit_last',	'1'),
(7376,	1687,	'_oembed_8fffb9dae9bbb684c6ab05cb03729d2e',	'{{unknown}}'),
(7379,	1687,	'_jd_tweet_this',	'yes'),
(7375,	1687,	'xyz_fbap',	'1'),
(7377,	1687,	'_oembed_0d07380f388e694c13916882f77cbbf6',	'{{unknown}}'),
(7378,	1687,	'_oembed_fef2d58513e721cbbe34a99cba3ae831',	'{{unknown}}'),
(7380,	1687,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-substance-abuse-handbook-ruiz-handbook-for-substance-abuse-second-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7381,	1687,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-substance-abuse-handbook-ruiz-handbook-for-substance-abuse-second-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7382,	1687,	'_wptp_twitter_api',	'a:1:{i:0;s:237:\"The Substance Abuse Handbook Ruiz Handbook for Substance Abuse Second Edition http://hotfile.pw/ebooks/the-substance-abuse-handbook-ruiz-handbook-for-substance-abuse-second-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7383,	1687,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7384,	1687,	'_edit_lock',	'1451477859:1'),
(7385,	1689,	'_edit_last',	'1'),
(7389,	1689,	'_oembed_0e0a0dcea0f0091fe9881ce532a08a83',	'{{unknown}}'),
(7391,	1689,	'_oembed_f0ec07c7c1523cd2552680739cd7f239',	'{{unknown}}'),
(7388,	1689,	'xyz_fbap',	'1'),
(7390,	1689,	'_oembed_96fbc9e5c912e3dc17f60a438ac00450',	'{{unknown}}'),
(7392,	1689,	'_jd_tweet_this',	'yes'),
(7393,	1689,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/sustainability-ethics-and-sustainability-research.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7394,	1689,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fsustainability-ethics-and-sustainability-research.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7395,	1689,	'_wptp_twitter_api',	'a:1:{i:0;s:181:\"Sustainability Ethics and Sustainability Research http://hotfile.pw/ebooks/sustainability-ethics-and-sustainability-research.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7396,	1689,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7397,	1689,	'_edit_lock',	'1451477990:1'),
(7398,	1691,	'_edit_last',	'1'),
(7402,	1691,	'_oembed_f515e91835893f1c42579ca2c1f5adca',	'{{unknown}}'),
(7404,	1691,	'_oembed_e96bb02644c7ab19ccf7e5c70d98a579',	'{{unknown}}'),
(7401,	1691,	'xyz_fbap',	'1'),
(7403,	1691,	'_oembed_55027de0d3f3afe7cb1d81dc11eaeb16',	'{{unknown}}'),
(7405,	1691,	'_jd_tweet_this',	'yes'),
(7406,	1691,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/multivariate-statistics-exercises-and-solutions.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7407,	1691,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fmultivariate-statistics-exercises-and-solutions.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7408,	1691,	'_wptp_twitter_api',	'a:1:{i:0;s:177:\"Multivariate Statistics Exercises and Solutions http://hotfile.pw/ebooks/multivariate-statistics-exercises-and-solutions.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7409,	1691,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7410,	1691,	'_edit_lock',	'1451478120:1'),
(7411,	1693,	'_edit_last',	'1'),
(7415,	1693,	'_oembed_d8ce87c3a341d9ce84b53f79ab9d211c',	'{{unknown}}'),
(7414,	1693,	'xyz_fbap',	'1'),
(7416,	1693,	'_oembed_aec29969420010fec65059ad5645c07b',	'{{unknown}}'),
(7417,	1693,	'_oembed_d3f1f03a2953bc9325f5b2dea6b04035',	'{{unknown}}'),
(7418,	1693,	'_jd_tweet_this',	'yes'),
(7419,	1693,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-future-of-the-professions-how-technology-will-transform-the-work-of-human-ex.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7420,	1693,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-future-of-the-professions-how-technology-will-transform-the-work-of-human-ex.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7421,	1693,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"The Future of the Professions How Technology Will Transform the Work of Human Ex... http://hotfile.pw/ebooks/the-future-of-the-professions-how-technology-will-transform-the-work-of-human-ex.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7422,	1693,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7423,	1693,	'_edit_lock',	'1451478250:1'),
(7424,	1695,	'_edit_last',	'1'),
(7428,	1695,	'_oembed_09095e22f57180e25facc5bf22b08c1a',	'{{unknown}}'),
(7430,	1695,	'_oembed_03e4e97192a51193a560dc8ebd464e25',	'{{unknown}}'),
(7427,	1695,	'xyz_fbap',	'1'),
(7429,	1695,	'_oembed_71bba130b5fbfd14c85c0048ad61f0c0',	'{{unknown}}'),
(18164,	3302,	'xyz_fbap',	'1'),
(7448,	1698,	'_oembed_7745f42f01b7c87ba4ebe083201fb452',	'{{unknown}}'),
(7444,	1698,	'_edit_last',	'1'),
(18169,	3302,	'_jd_tweet_this',	'yes'),
(18165,	3302,	'_oembed_68ed1d9b922fff6f7e6eb6c01dfa835b',	'{{unknown}}'),
(18161,	3302,	'_edit_last',	'1'),
(18160,	3300,	'_edit_lock',	'1451642328:1'),
(18159,	3300,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(18158,	3300,	'_wptp_twitter_api',	'a:1:{i:0;s:145:\"Yamicsoft Windows 10 Manager 106 http://hotfile.pw/apps/yamicsoft-windows-10-manager-106.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(18156,	3300,	'_wp_jd_wp',	'http://hotfile.pw/apps/yamicsoft-windows-10-manager-106.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(18157,	3300,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fapps%2Fyamicsoft-windows-10-manager-106.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(18154,	3300,	'_oembed_e1e422d247aa0e221ab9dc219be0a287',	'{{unknown}}'),
(18153,	3300,	'_oembed_bfc7d94518f772aacdc3b894d91a246c',	'{{unknown}}'),
(7451,	1698,	'_jd_tweet_this',	'yes'),
(7447,	1698,	'xyz_fbap',	'1'),
(7449,	1698,	'_oembed_4df522ae47982acef284c1fea59928f1',	'{{unknown}}'),
(7450,	1698,	'_oembed_9f16514b4c7492dc4cf2eb2f584814bf',	'{{unknown}}'),
(7452,	1698,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/transition-metal-catalyzed-carbonylative-synthesis-of-heterocycles.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7453,	1698,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Ftransition-metal-catalyzed-carbonylative-synthesis-of-heterocycles.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7454,	1698,	'_wptp_twitter_api',	'a:1:{i:0;s:215:\"Transition Metal Catalyzed Carbonylative Synthesis of Heterocycles http://hotfile.pw/ebooks/transition-metal-catalyzed-carbonylative-synthesis-of-heterocycles.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7455,	1698,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7456,	1698,	'_edit_lock',	'1451478548:1'),
(7457,	1700,	'_edit_last',	'1'),
(7461,	1700,	'_oembed_afc17c8f775470381b9430b92c39658c',	'{{unknown}}'),
(7463,	1700,	'_oembed_fecb4c3847fd8ca4d97f8c6e9777ea9a',	'{{unknown}}'),
(7460,	1700,	'xyz_fbap',	'1'),
(7462,	1700,	'_oembed_c0caf4c9c40db3345a2a304150060a09',	'{{unknown}}'),
(7464,	1700,	'_jd_tweet_this',	'yes'),
(7465,	1700,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-story-of-the-lost-child-neapolitan-novels-book-four.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7466,	1700,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-story-of-the-lost-child-neapolitan-novels-book-four.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7467,	1700,	'_wptp_twitter_api',	'a:1:{i:0;s:193:\"The Story of the Lost Child Neapolitan Novels Book Four http://hotfile.pw/ebooks/the-story-of-the-lost-child-neapolitan-novels-book-four.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7468,	1700,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7469,	1700,	'_edit_lock',	'1451478681:1'),
(7470,	1702,	'_edit_last',	'1'),
(7474,	1702,	'_oembed_05db68fd7062a1a62fd6ac708f31f2be',	'{{unknown}}'),
(7475,	1702,	'_oembed_b9ad7e4a7c9fd708b1ed3170eddd87a4',	'{{unknown}}'),
(7473,	1702,	'xyz_fbap',	'1'),
(7476,	1702,	'_oembed_d8b1f67e3524798e6cf299c17b7a2e7a',	'{{unknown}}'),
(7477,	1702,	'_jd_tweet_this',	'yes'),
(7478,	1702,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/eye-of-the-beholder-masterpieces-from-the-isabella-stewart-gardner-museum.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7479,	1702,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Feye-of-the-beholder-masterpieces-from-the-isabella-stewart-gardner-museum.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7480,	1702,	'_wptp_twitter_api',	'a:1:{i:0;s:229:\"Eye of the Beholder Masterpieces From the Isabella Stewart Gardner Museum http://hotfile.pw/ebooks/eye-of-the-beholder-masterpieces-from-the-isabella-stewart-gardner-museum.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7481,	1702,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7482,	1702,	'_edit_lock',	'1451478811:1'),
(7483,	1704,	'_edit_last',	'1'),
(7487,	1704,	'_oembed_c628bc4dd4c1731a1ac1335d9b43d044',	'{{unknown}}'),
(7489,	1704,	'_oembed_97e52a4bae15160fd3263693f44f810d',	'{{unknown}}'),
(7486,	1704,	'xyz_fbap',	'1'),
(7488,	1704,	'_oembed_a4c410ae55cd004ce4846c8527f84115',	'{{unknown}}'),
(7490,	1704,	'_jd_tweet_this',	'yes'),
(7491,	1704,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/introduction-to-theoretical-hydrodynamics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7492,	1704,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fintroduction-to-theoretical-hydrodynamics.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7493,	1704,	'_wptp_twitter_api',	'a:1:{i:0;s:165:\"Introduction to Theoretical Hydrodynamics http://hotfile.pw/ebooks/introduction-to-theoretical-hydrodynamics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7494,	1704,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7495,	1704,	'_edit_lock',	'1451478944:1'),
(7496,	1706,	'_edit_last',	'1'),
(7500,	1706,	'_oembed_589b6846ec626615244904119d3ed545',	'{{unknown}}'),
(7503,	1706,	'_jd_tweet_this',	'yes'),
(7499,	1706,	'xyz_fbap',	'1'),
(7501,	1706,	'_oembed_447edbc8ae031a8d64e793be26d339e0',	'{{unknown}}'),
(7502,	1706,	'_oembed_95a4ceeab64cce78335e7f4be8e91f39',	'{{unknown}}'),
(7504,	1706,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/saving-money-tips-best-ways-to-save-money-and-get-rich-how-to-save-money-fast.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7505,	1706,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fsaving-money-tips-best-ways-to-save-money-and-get-rich-how-to-save-money-fast.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7506,	1706,	'_wptp_twitter_api',	'a:1:{i:0;s:237:\"Saving Money Tips Best Ways to Save Money and Get Rich How to Save Money fast http://hotfile.pw/ebooks/saving-money-tips-best-ways-to-save-money-and-get-rich-how-to-save-money-fast.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7507,	1706,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7508,	1706,	'_edit_lock',	'1451479076:1'),
(7509,	1708,	'_edit_last',	'1'),
(7513,	1708,	'_oembed_2424713a237a29cc7d3e803f9e7a5f87',	'{{unknown}}'),
(7514,	1708,	'_oembed_8e788cc29fa8134f6d63c1fa3959940e',	'{{unknown}}'),
(7512,	1708,	'xyz_fbap',	'1'),
(7515,	1708,	'_oembed_45b2b4f0b174c64b023ef0e39ebcb0f8',	'{{unknown}}'),
(7516,	1708,	'_jd_tweet_this',	'yes'),
(7517,	1708,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/enterprise-risk-management-best-practices-from-assessment-to-ongoing-compliance.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7518,	1708,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fenterprise-risk-management-best-practices-from-assessment-to-ongoing-compliance.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7519,	1708,	'_wptp_twitter_api',	'a:1:{i:0;s:241:\"Enterprise Risk Management Best Practices From Assessment to Ongoing Compliance http://hotfile.pw/ebooks/enterprise-risk-management-best-practices-from-assessment-to-ongoing-compliance.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7520,	1708,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7521,	1708,	'_edit_lock',	'1451479208:1'),
(7522,	1710,	'_edit_last',	'1'),
(7526,	1710,	'_oembed_c4dc883281959fe92cae9831967b7a1d',	'{{unknown}}'),
(7529,	1710,	'_jd_tweet_this',	'yes'),
(7525,	1710,	'xyz_fbap',	'1'),
(7527,	1710,	'_oembed_9c3855ff3e941b65c7e57d70693a5703',	'{{unknown}}'),
(7528,	1710,	'_oembed_6e23def58ab074dfc02324330cf5ec03',	'{{unknown}}'),
(7530,	1710,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/encyclopedia-of-american-indian-history.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7531,	1710,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fencyclopedia-of-american-indian-history.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7532,	1710,	'_wptp_twitter_api',	'a:1:{i:0;s:161:\"Encyclopedia of American Indian History http://hotfile.pw/ebooks/encyclopedia-of-american-indian-history.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7533,	1710,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7534,	1710,	'_edit_lock',	'1451479342:1'),
(7535,	1712,	'_edit_last',	'1'),
(7539,	1712,	'_oembed_04b273cd9622621e32f418c68732fceb',	'{{unknown}}'),
(7542,	1712,	'_jd_tweet_this',	'yes'),
(7538,	1712,	'xyz_fbap',	'1'),
(7540,	1712,	'_oembed_8dca77b5c1a460553b275f352cb72b88',	'{{unknown}}'),
(7541,	1712,	'_oembed_62dcfd51de26f1018fbfba165365ecbc',	'{{unknown}}'),
(7543,	1712,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/linux-networking-cookbook.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7544,	1712,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Flinux-networking-cookbook.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7545,	1712,	'_wptp_twitter_api',	'a:1:{i:0;s:133:\"Linux Networking Cookbook http://hotfile.pw/ebooks/linux-networking-cookbook.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7546,	1712,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7547,	1712,	'_edit_lock',	'1451479477:1'),
(7548,	1714,	'_edit_last',	'1'),
(7552,	1714,	'_oembed_75edac63f3497165e34a97f5b6b15fe7',	'{{unknown}}'),
(7553,	1714,	'_oembed_a226bf986eba452c01f20c5f793d4239',	'{{unknown}}'),
(7551,	1714,	'xyz_fbap',	'1'),
(7554,	1714,	'_oembed_7f1f61498e23235f755bbf61489faad2',	'{{unknown}}'),
(7555,	1714,	'_jd_tweet_this',	'yes'),
(7556,	1714,	'_wp_jd_wp',	'http://hotfile.pw/magazines/tastecomau-januaryfebruary.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7557,	1714,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmagazines%2Ftastecomau-januaryfebruary.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7558,	1714,	'_wptp_twitter_api',	'a:1:{i:0;s:138:\"Tastecomau JanuaryFebruary http://hotfile.pw/magazines/tastecomau-januaryfebruary.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7559,	1714,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7560,	1714,	'_edit_lock',	'1451479607:1'),
(7561,	1716,	'_edit_last',	'1'),
(7565,	1716,	'_oembed_93eb8ad9ae9b9fe8c561dd2bacee6d42',	'{{unknown}}'),
(7566,	1716,	'_oembed_4f2f14e6b03fb87a0c6e626878e9ea42',	'{{unknown}}'),
(7564,	1716,	'xyz_fbap',	'1'),
(7567,	1716,	'_oembed_8966c3266a3131206a332d91ef5701cc',	'{{unknown}}'),
(7568,	1716,	'_jd_tweet_this',	'yes'),
(7569,	1716,	'_wp_jd_wp',	'http://hotfile.pw/magazines/ici-paris-23-au-29-decembre.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7570,	1716,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmagazines%2Fici-paris-23-au-29-decembre.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7571,	1716,	'_wptp_twitter_api',	'a:1:{i:0;s:140:\"Ici Paris 23 Au 29 Decembre http://hotfile.pw/magazines/ici-paris-23-au-29-decembre.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7572,	1716,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7573,	1716,	'_edit_lock',	'1451479738:1'),
(7574,	1718,	'_edit_last',	'1'),
(7578,	1718,	'_oembed_3f118aed2fccd6aa060a73d883ba7582',	'{{unknown}}'),
(7581,	1718,	'_jd_tweet_this',	'yes'),
(7577,	1718,	'xyz_fbap',	'1'),
(7579,	1718,	'_oembed_fa40b07a33255e20e5d9cee87faf441a',	'{{unknown}}'),
(7580,	1718,	'_oembed_b045371274fbd4364c84dbe907cfe545',	'{{unknown}}'),
(7582,	1718,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-public-professor-how-to-use-your-research-to-change-the-world.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7583,	1718,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-public-professor-how-to-use-your-research-to-change-the-world.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7584,	1718,	'_wptp_twitter_api',	'a:1:{i:0;s:213:\"The Public Professor How to Use Your Research to Change the World http://hotfile.pw/ebooks/the-public-professor-how-to-use-your-research-to-change-the-world.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7585,	1718,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7586,	1718,	'_edit_lock',	'1451479867:1'),
(7587,	1720,	'_edit_last',	'1'),
(7591,	1720,	'_oembed_0d1a5d21b4555dcf60de0dc7178d61d6',	'{{unknown}}'),
(7594,	1720,	'_jd_tweet_this',	'yes'),
(7590,	1720,	'xyz_fbap',	'1'),
(7592,	1720,	'_oembed_b0e0c11d54c7c9c8cd76683564869f01',	'{{unknown}}'),
(7593,	1720,	'_oembed_382f1311417d45a5175d2882286d0091',	'{{unknown}}'),
(7595,	1720,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/drink-more-whiskey-everything-you-need-to-know-about-your-new-favorite-drink.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7596,	1720,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fdrink-more-whiskey-everything-you-need-to-know-about-your-new-favorite-drink.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7597,	1720,	'_wptp_twitter_api',	'a:1:{i:0;s:235:\"Drink More Whiskey Everything You Need to Know About Your New Favorite Drink http://hotfile.pw/ebooks/drink-more-whiskey-everything-you-need-to-know-about-your-new-favorite-drink.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7598,	1720,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7599,	1720,	'_edit_lock',	'1451479999:1'),
(7600,	1722,	'_edit_last',	'1'),
(7604,	1722,	'_oembed_289cf3f079dcda172997829ddbf7ba57',	'{{unknown}}'),
(7606,	1722,	'_oembed_c9558fd93e8c3862dfa426eb115e2045',	'{{unknown}}'),
(7603,	1722,	'xyz_fbap',	'1'),
(7605,	1722,	'_oembed_bccbb7a4050f239d7442d935dff126df',	'{{unknown}}'),
(7607,	1722,	'_jd_tweet_this',	'yes'),
(7608,	1722,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-philosophy-of-conspiracy-theories.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7609,	1722,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-philosophy-of-conspiracy-theories.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7610,	1722,	'_wptp_twitter_api',	'a:1:{i:0;s:157:\"The Philosophy of Conspiracy Theories http://hotfile.pw/ebooks/the-philosophy-of-conspiracy-theories.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7611,	1722,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7612,	1722,	'_edit_lock',	'1451480135:1'),
(7613,	1724,	'_edit_last',	'1'),
(7617,	1724,	'_oembed_4457bc1d63646fd9be48e3faafebcdff',	'{{unknown}}'),
(7618,	1724,	'_oembed_1972f30e74f67ffe8471afedb437d483',	'{{unknown}}'),
(7616,	1724,	'xyz_fbap',	'1'),
(7619,	1724,	'_oembed_ad6c5f596b6ce7f2d9ea7a2adc95a04a',	'{{unknown}}'),
(7620,	1725,	'_edit_last',	'1'),
(7624,	1725,	'_oembed_dc8844a45de5dc06e70df413ac9b0782',	'{{unknown}}'),
(7627,	1725,	'_jd_tweet_this',	'yes'),
(7623,	1725,	'xyz_fbap',	'1'),
(7625,	1725,	'_oembed_cfa598f218a3d89706d06d2c77832f6d',	'{{unknown}}'),
(7626,	1725,	'_oembed_f1d920dc2972e6358a96b5b69fd4fe9e',	'{{unknown}}'),
(7628,	1725,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/returning-cycles-contexts-for-the-interpretation-of-schuberts-impromptus-and-las.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7629,	1725,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Freturning-cycles-contexts-for-the-interpretation-of-schuberts-impromptus-and-las.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7630,	1725,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"Returning Cycles Contexts for the Interpretation of Schuberts Impromptus and Las... http://hotfile.pw/ebooks/returning-cycles-contexts-for-the-interpretation-of-schuberts-impromptus-and-las.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7631,	1725,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7632,	1725,	'_edit_lock',	'1451480407:1'),
(7633,	1727,	'_edit_last',	'1'),
(7637,	1727,	'_oembed_c414a91e41b2640b3f48614da08343b1',	'{{unknown}}'),
(7636,	1727,	'xyz_fbap',	'1'),
(7638,	1727,	'_oembed_f89536fd069cb2ffccace3064fefcb23',	'{{unknown}}'),
(7639,	1727,	'_oembed_4c6de28827c1ed197726a13a0865bfc2',	'{{unknown}}'),
(7640,	1727,	'_jd_tweet_this',	'yes'),
(7641,	1727,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/what-to-sell-on-ebay-and-where-to-get-it-the-definitive-guide-to-product-sourcin.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7642,	1727,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fwhat-to-sell-on-ebay-and-where-to-get-it-the-definitive-guide-to-product-sourcin.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7643,	1727,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"What to Sell on eBay and Where to Get It The Definitive Guide to Product Sourcin... http://hotfile.pw/ebooks/what-to-sell-on-ebay-and-where-to-get-it-the-definitive-guide-to-product-sourcin.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7644,	1727,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7645,	1727,	'_edit_lock',	'1451480538:1'),
(7646,	1729,	'_edit_last',	'1'),
(7650,	1729,	'_oembed_b06cd121369b52d69d37ef0f1e899e5a',	'{{unknown}}'),
(7652,	1729,	'_oembed_309191db88d45b8a385e61dcc9319b91',	'{{unknown}}'),
(7649,	1729,	'xyz_fbap',	'1'),
(7651,	1729,	'_oembed_2de76c30bb4be8558f9cea60f5ca2fd7',	'{{unknown}}'),
(7653,	1729,	'_jd_tweet_this',	'yes'),
(7654,	1729,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/clinical-management-of-overweight-and-obesity.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7655,	1729,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fclinical-management-of-overweight-and-obesity.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7656,	1729,	'_wptp_twitter_api',	'a:1:{i:0;s:173:\"Clinical Management of Overweight and Obesity http://hotfile.pw/ebooks/clinical-management-of-overweight-and-obesity.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7657,	1729,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7658,	1729,	'_edit_lock',	'1451480670:1'),
(7659,	1731,	'_edit_last',	'1'),
(7663,	1731,	'_oembed_358bc5b0fb9b17052f75aae24e57eaa8',	'{{unknown}}'),
(7666,	1731,	'_jd_tweet_this',	'yes'),
(7662,	1731,	'xyz_fbap',	'1'),
(7664,	1731,	'_oembed_c8796faaca7efe46ec7b45be28df1cd3',	'{{unknown}}'),
(7665,	1731,	'_oembed_171d7cae90739723400ec7ef80ee3726',	'{{unknown}}'),
(7667,	1731,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/desmond-seward-eleanor-of-aquitaine-the-mother-queen.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7668,	1731,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fdesmond-seward-eleanor-of-aquitaine-the-mother-queen.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7669,	1731,	'_wptp_twitter_api',	'a:1:{i:0;s:187:\"Desmond Seward Eleanor of Aquitaine The Mother Queen http://hotfile.pw/ebooks/desmond-seward-eleanor-of-aquitaine-the-mother-queen.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7670,	1731,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7671,	1731,	'_edit_lock',	'1451480803:1'),
(7672,	1733,	'_edit_last',	'1'),
(7676,	1733,	'_oembed_880a911666eb8b4f11643492bd001875',	'{{unknown}}'),
(7677,	1733,	'_oembed_514aed3ffe87cbe8e2d243bd11498074',	'{{unknown}}'),
(7675,	1733,	'xyz_fbap',	'1'),
(7678,	1733,	'_oembed_c85bb8350d8fa0c4592dead5aa44ec88',	'{{unknown}}'),
(7679,	1733,	'_jd_tweet_this',	'yes'),
(7680,	1733,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/production-of-basic-diagnostic-laboratory-reagents.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7681,	1733,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fproduction-of-basic-diagnostic-laboratory-reagents.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7682,	1733,	'_wptp_twitter_api',	'a:1:{i:0;s:183:\"Production of Basic Diagnostic Laboratory Reagents http://hotfile.pw/ebooks/production-of-basic-diagnostic-laboratory-reagents.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7683,	1733,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7684,	1733,	'_edit_lock',	'1451480934:1'),
(7685,	1735,	'_edit_last',	'1'),
(7689,	1735,	'_oembed_35fda537bdfb3799336c0289bedd2ac2',	'{{unknown}}'),
(7692,	1735,	'_jd_tweet_this',	'yes'),
(7688,	1735,	'xyz_fbap',	'1'),
(7690,	1735,	'_oembed_9fc1c32907e402d390266c02f86852f1',	'{{unknown}}'),
(7691,	1735,	'_oembed_7f06076f1787b62b33ba5b20bab6a577',	'{{unknown}}'),
(7693,	1735,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/service-mining-framework-and-application.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7694,	1735,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fservice-mining-framework-and-application.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7695,	1735,	'_wptp_twitter_api',	'a:1:{i:0;s:163:\"Service Mining framework and application http://hotfile.pw/ebooks/service-mining-framework-and-application.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7696,	1735,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7697,	1735,	'_edit_lock',	'1451481065:1'),
(7698,	1737,	'_edit_last',	'1'),
(7702,	1737,	'_oembed_cb0115b39ca0abac84e2f7ac245cc0c3',	'{{unknown}}'),
(7705,	1737,	'_jd_tweet_this',	'yes'),
(7701,	1737,	'xyz_fbap',	'1'),
(7703,	1737,	'_oembed_e31e0f61e7fc258dd28a49ddbb6d23ea',	'{{unknown}}'),
(7704,	1737,	'_oembed_88015ba9a7c2ebdb875b7efae06d6ec6',	'{{unknown}}'),
(7706,	1737,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/fundamentals-of-machine-learning-for-predictive-data-analytics-algorithms-worked.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7707,	1737,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Ffundamentals-of-machine-learning-for-predictive-data-analytics-algorithms-worked.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7708,	1737,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"Fundamentals of Machine Learning for Predictive Data Analytics Algorithms Worked... http://hotfile.pw/ebooks/fundamentals-of-machine-learning-for-predictive-data-analytics-algorithms-worked.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7709,	1737,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7710,	1737,	'_edit_lock',	'1451481194:1'),
(7711,	1739,	'_edit_last',	'1'),
(7715,	1739,	'_oembed_bf32c4447d1730e2560244d7d8ab3331',	'{{unknown}}'),
(7718,	1739,	'_jd_tweet_this',	'yes'),
(7714,	1739,	'xyz_fbap',	'1'),
(7716,	1739,	'_oembed_9b4fe4cd25a6f7dc318c584429afb6da',	'{{unknown}}'),
(7717,	1739,	'_oembed_a22512608d437284314a132d2a29a477',	'{{unknown}}'),
(7719,	1739,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/integrated-land-use-planning-for-sustainable-agriculture-and-rural-development.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7720,	1739,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fintegrated-land-use-planning-for-sustainable-agriculture-and-rural-development.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7721,	1739,	'_wptp_twitter_api',	'a:1:{i:0;s:239:\"Integrated Land Use Planning for Sustainable Agriculture and Rural Development http://hotfile.pw/ebooks/integrated-land-use-planning-for-sustainable-agriculture-and-rural-development.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7722,	1739,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7723,	1739,	'_edit_lock',	'1451481329:1'),
(7724,	1741,	'_edit_last',	'1'),
(7728,	1741,	'_oembed_8d7a1f895bbaa0001dc37e64026ef962',	'{{unknown}}'),
(7729,	1741,	'_oembed_7e4a6cb0b99742e8885a57ecc8fd3360',	'{{unknown}}'),
(7727,	1741,	'xyz_fbap',	'1'),
(7730,	1741,	'_oembed_2ca04cf4f1d3261d3358687f4ad625ec',	'{{unknown}}'),
(7731,	1741,	'_jd_tweet_this',	'yes'),
(7732,	1741,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-rough-guide-to-nepal.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7733,	1741,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-rough-guide-to-nepal.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7734,	1741,	'_wptp_twitter_api',	'a:1:{i:0;s:131:\"The Rough Guide to Nepal http://hotfile.pw/ebooks/the-rough-guide-to-nepal.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7735,	1741,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7736,	1741,	'_edit_lock',	'1451481461:1'),
(7737,	1743,	'_edit_last',	'1'),
(7741,	1743,	'_oembed_e04cf37b3387314706741afa6a3275dc',	'{{unknown}}'),
(7744,	1743,	'_jd_tweet_this',	'yes'),
(7740,	1743,	'xyz_fbap',	'1'),
(7742,	1743,	'_oembed_a37e28f6dbc43798fe4ef75e6e21236b',	'{{unknown}}'),
(7743,	1743,	'_oembed_2deca5ef5f2c7d66b4a72129cbd2714e',	'{{unknown}}'),
(7745,	1743,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/management-of-benign-biliary-stenosis-and-injury.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7746,	1743,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fmanagement-of-benign-biliary-stenosis-and-injury.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7747,	1743,	'_wptp_twitter_api',	'a:1:{i:0;s:179:\"Management of Benign Biliary Stenosis and Injury http://hotfile.pw/ebooks/management-of-benign-biliary-stenosis-and-injury.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7748,	1743,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7749,	1743,	'_edit_lock',	'1451481596:1'),
(7750,	1745,	'_edit_last',	'1'),
(7754,	1745,	'_oembed_f266ecc338eb9e8d2aef6d2bf3c5d9d6',	'{{unknown}}'),
(7757,	1745,	'_jd_tweet_this',	'yes'),
(7753,	1745,	'xyz_fbap',	'1'),
(7755,	1745,	'_oembed_6d8b718c7d21e50ef2cb388ea6859db1',	'{{unknown}}'),
(7756,	1745,	'_oembed_95c9b9166c333fd9bc150c42ee59c19b',	'{{unknown}}'),
(7758,	1745,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/antipasti-by-joyce-goldstein.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7759,	1745,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fantipasti-by-joyce-goldstein.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7760,	1745,	'_wptp_twitter_api',	'a:1:{i:0;s:139:\"Antipasti by Joyce Goldstein http://hotfile.pw/ebooks/antipasti-by-joyce-goldstein.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7761,	1745,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7762,	1745,	'_edit_lock',	'1451481729:1'),
(7763,	1747,	'_edit_last',	'1'),
(7767,	1747,	'_oembed_350830a8c18f12ab01a9dd5d0d4e4ee9',	'{{unknown}}'),
(7770,	1747,	'_jd_tweet_this',	'yes'),
(7766,	1747,	'xyz_fbap',	'1'),
(7768,	1747,	'_oembed_b0c88d4579f2a6b036385a1eff0020db',	'{{unknown}}'),
(7769,	1747,	'_oembed_ca659fa1ec78ff986a20d9b50ab959ac',	'{{unknown}}'),
(7771,	1747,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/new-zealand-country-guide-16-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7772,	1747,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fnew-zealand-country-guide-16-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7773,	1747,	'_wptp_twitter_api',	'a:1:{i:0;s:155:\"New Zealand Country Guide 16 edition http://hotfile.pw/ebooks/new-zealand-country-guide-16-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7774,	1747,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7775,	1747,	'_edit_lock',	'1451481863:1'),
(7776,	1749,	'_edit_last',	'1'),
(7780,	1749,	'_oembed_dc7402918dece98fef4385d9de21b2b9',	'{{unknown}}'),
(7782,	1749,	'_oembed_aaa18e43fdb9cc536c09e7695949cb78',	'{{unknown}}'),
(7779,	1749,	'xyz_fbap',	'1'),
(7781,	1749,	'_oembed_5fa35ff74d2c8348a5753cecb3274881',	'{{unknown}}'),
(7783,	1749,	'_jd_tweet_this',	'yes'),
(7784,	1749,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-maillard-reaction-reconsidered-cooking-and-eating-for-health.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7785,	1749,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-maillard-reaction-reconsidered-cooking-and-eating-for-health.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7786,	1749,	'_wptp_twitter_api',	'a:1:{i:0;s:211:\"The Maillard Reaction Reconsidered Cooking and Eating for Health http://hotfile.pw/ebooks/the-maillard-reaction-reconsidered-cooking-and-eating-for-health.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7787,	1749,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7788,	1749,	'_edit_lock',	'1451481995:1'),
(7789,	1751,	'_edit_last',	'1'),
(7793,	1751,	'_oembed_5fd712ba890c65817e22045dadaadcb6',	'{{unknown}}'),
(7796,	1752,	'_edit_last',	'1'),
(7792,	1751,	'xyz_fbap',	'1'),
(7794,	1751,	'_oembed_198c69689678f08610b1dc3a2fa3d5ca',	'{{unknown}}'),
(7795,	1751,	'_oembed_a15e5609c1750a512243092a88834426',	'{{unknown}}'),
(7800,	1752,	'_oembed_0c2358a800f91ab775043b7777820282',	'{{unknown}}'),
(7802,	1752,	'_oembed_9b32c5a7db6e6411d0fdb34d53fe3dd8',	'{{unknown}}'),
(7799,	1752,	'xyz_fbap',	'1'),
(7801,	1752,	'_oembed_a12fcb27ce2817c08cebb239d154b89d',	'{{unknown}}'),
(7803,	1752,	'_jd_tweet_this',	'yes'),
(7804,	1752,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/all-you-wanted-to-know-about-sex.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7805,	1752,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fall-you-wanted-to-know-about-sex.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7806,	1752,	'_wptp_twitter_api',	'a:1:{i:0;s:147:\"All You Wanted to Know About Sex http://hotfile.pw/ebooks/all-you-wanted-to-know-about-sex.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7807,	1752,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7808,	1752,	'_edit_lock',	'1451482267:1'),
(7809,	1754,	'_edit_last',	'1'),
(7813,	1754,	'_oembed_b6272e491a540fdeb284ccc633c57b61',	'{{unknown}}'),
(7816,	1754,	'_jd_tweet_this',	'yes'),
(7812,	1754,	'xyz_fbap',	'1'),
(7814,	1754,	'_oembed_794a04d6c531cde3e82fed896d0cba38',	'{{unknown}}'),
(7815,	1754,	'_oembed_88a179da95b3f9deed5f33a513b316d3',	'{{unknown}}'),
(7817,	1754,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/probability-and-statistics-by-example-volume-2-markov-chains-a-primer-in-random.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7818,	1754,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fprobability-and-statistics-by-example-volume-2-markov-chains-a-primer-in-random.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7819,	1754,	'_wptp_twitter_api',	'a:1:{i:0;s:245:\"Probability and Statistics by Example Volume 2 Markov Chains A Primer in Random ... http://hotfile.pw/ebooks/probability-and-statistics-by-example-volume-2-markov-chains-a-primer-in-random.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7820,	1754,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7821,	1754,	'_edit_lock',	'1451482399:1'),
(7822,	1756,	'_edit_last',	'1'),
(7826,	1756,	'_oembed_8cf9230ab60708d387506be94f49db5d',	'{{unknown}}'),
(7829,	1756,	'_jd_tweet_this',	'yes'),
(7825,	1756,	'xyz_fbap',	'1'),
(7827,	1756,	'_oembed_3e80691db93b49e60390191cd535fe48',	'{{unknown}}'),
(7828,	1756,	'_oembed_d2470c20a978b3373b65667d1b8ce05b',	'{{unknown}}'),
(7830,	1756,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/photography-2nd-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7831,	1756,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fphotography-2nd-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7832,	1756,	'_wptp_twitter_api',	'a:1:{i:0;s:129:\"Photography 2nd edition http://hotfile.pw/ebooks/photography-2nd-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7833,	1756,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7834,	1756,	'_edit_lock',	'1451482531:1'),
(7835,	1758,	'_edit_last',	'1'),
(7839,	1758,	'_oembed_85f4c139f66448bdc86850dccc2f5469',	'{{unknown}}'),
(7842,	1758,	'_jd_tweet_this',	'yes'),
(7838,	1758,	'xyz_fbap',	'1'),
(7840,	1758,	'_oembed_7ce52731702cd3037a7549dbca1d95d8',	'{{unknown}}'),
(7841,	1758,	'_oembed_674ca37d5a0e1d40328159188a0bc2c7',	'{{unknown}}'),
(7843,	1758,	'_wp_jd_wp',	'http://hotfile.pw/pc-games/fear-for-sale-nightmare-cinema-collectors-edition-v10zeke.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7844,	1758,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fpc-games%2Ffear-for-sale-nightmare-cinema-collectors-edition-v10zeke.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7845,	1758,	'_wptp_twitter_api',	'a:1:{i:0;s:199:\"Fear for Sale Nightmare Cinema Collectors Edition v10ZEKE http://hotfile.pw/pc-games/fear-for-sale-nightmare-cinema-collectors-edition-v10zeke.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7846,	1758,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7847,	1758,	'_edit_lock',	'1451482664:1'),
(7848,	1760,	'_edit_last',	'1'),
(7852,	1760,	'_oembed_de08be6536067699ffc51adeb0e69ac7',	'{{unknown}}'),
(7855,	1760,	'_jd_tweet_this',	'yes'),
(7851,	1760,	'xyz_fbap',	'1'),
(7853,	1760,	'_oembed_fd0e7693d29ab8993983e8b3cdd33542',	'{{unknown}}'),
(7854,	1760,	'_oembed_98eb2aead892b175ace9ef5f66463504',	'{{unknown}}'),
(7856,	1760,	'_wp_jd_wp',	'http://hotfile.pw/magazines/la-classe-janvier.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7857,	1760,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmagazines%2Fla-classe-janvier.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7858,	1760,	'_wptp_twitter_api',	'a:1:{i:0;s:120:\"La Classe Janvier http://hotfile.pw/magazines/la-classe-janvier.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7859,	1760,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7860,	1760,	'_edit_lock',	'1451482794:1'),
(7861,	1762,	'_edit_last',	'1'),
(7865,	1762,	'_oembed_7e4ed99189f10c22f18013a2562d2e78',	'{{unknown}}'),
(7866,	1762,	'_oembed_deb8680617fd15307e35369483f0897e',	'{{unknown}}'),
(7864,	1762,	'xyz_fbap',	'1'),
(7867,	1762,	'_oembed_9a2902ddf6552741e20c38cab6ca34ce',	'{{unknown}}'),
(7868,	1762,	'_jd_tweet_this',	'yes'),
(7869,	1762,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/political-philosophy-crossexamined-perennial-challenges-to-the-philosophic-life.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7870,	1762,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fpolitical-philosophy-crossexamined-perennial-challenges-to-the-philosophic-life.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7871,	1762,	'_wptp_twitter_api',	'a:1:{i:0;s:245:\"Political Philosophy CrossExamined Perennial Challenges to the Philosophic Life ... http://hotfile.pw/ebooks/political-philosophy-crossexamined-perennial-challenges-to-the-philosophic-life.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7872,	1762,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7873,	1762,	'_edit_lock',	'1451482927:1'),
(7874,	1764,	'_edit_last',	'1'),
(7878,	1764,	'_oembed_cccfaddb4cca8bcc9dc384f348ab3521',	'{{unknown}}'),
(7881,	1764,	'_jd_tweet_this',	'yes'),
(7877,	1764,	'xyz_fbap',	'1'),
(7879,	1764,	'_oembed_a264a6d34212ea7b7425ced8e63264e6',	'{{unknown}}'),
(7880,	1764,	'_oembed_55cef2bc6c94e77e7f3be2ca2e7134e9',	'{{unknown}}'),
(7882,	1764,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/cognitive-robotics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7883,	1764,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcognitive-robotics.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7884,	1764,	'_wptp_twitter_api',	'a:1:{i:0;s:119:\"Cognitive Robotics http://hotfile.pw/ebooks/cognitive-robotics.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7885,	1764,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7886,	1764,	'_edit_lock',	'1451483059:1'),
(7887,	1766,	'_edit_last',	'1'),
(7891,	1766,	'_oembed_12152a63db054b9c69ac20b7d46270db',	'{{unknown}}'),
(7894,	1766,	'_jd_tweet_this',	'yes'),
(7890,	1766,	'xyz_fbap',	'1'),
(7892,	1766,	'_oembed_66d05724ac60bfe3d07dff55952b9f4b',	'{{unknown}}'),
(7893,	1766,	'_oembed_5122f75201638924ded784adbd82b086',	'{{unknown}}'),
(7895,	1766,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/durability-of-materials-and-structures-in-building-and-civil-engineering.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7896,	1766,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fdurability-of-materials-and-structures-in-building-and-civil-engineering.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7897,	1766,	'_wptp_twitter_api',	'a:1:{i:0;s:227:\"Durability of Materials and Structures in Building and Civil Engineering http://hotfile.pw/ebooks/durability-of-materials-and-structures-in-building-and-civil-engineering.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7898,	1766,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7899,	1766,	'_edit_lock',	'1451483193:1'),
(7900,	1768,	'_edit_last',	'1'),
(7904,	1768,	'_oembed_1a6f302848963102c479177c28a7e4d4',	'{{unknown}}'),
(7907,	1768,	'_jd_tweet_this',	'yes'),
(7903,	1768,	'xyz_fbap',	'1'),
(7905,	1768,	'_oembed_f90fe288d2e7f4307554783c14fb4adc',	'{{unknown}}'),
(7906,	1768,	'_oembed_b7b6300e695aca9ef60cbd95d09fbdc1',	'{{unknown}}'),
(7908,	1768,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/face-recognition-technique-a-literature-survey-on-face-recognition-and-insight-o.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7909,	1768,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fface-recognition-technique-a-literature-survey-on-face-recognition-and-insight-o.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7910,	1768,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"Face Recognition Technique A Literature Survey on Face Recognition and Insight o... http://hotfile.pw/ebooks/face-recognition-technique-a-literature-survey-on-face-recognition-and-insight-o.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7911,	1768,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7912,	1768,	'_edit_lock',	'1451483325:1'),
(7913,	1770,	'_edit_last',	'1'),
(7917,	1770,	'_oembed_aefc2ce39a87da661f6015147e47d321',	'{{unknown}}'),
(7926,	1772,	'_edit_last',	'1'),
(7916,	1770,	'xyz_fbap',	'1'),
(7918,	1770,	'_oembed_4c903fff779ba7d1ef0d5b413c31fa91',	'{{unknown}}'),
(7919,	1770,	'_oembed_9ea08efd0529afbc5d0d6ff8642b5790',	'{{unknown}}'),
(7920,	1770,	'_jd_tweet_this',	'yes'),
(7921,	1770,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/an-eye-for-an-eye-a-global-history-of-crime-and-punishment.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7922,	1770,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fan-eye-for-an-eye-a-global-history-of-crime-and-punishment.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7923,	1770,	'_wptp_twitter_api',	'a:1:{i:0;s:199:\"An Eye for an Eye A Global History of Crime and Punishment http://hotfile.pw/ebooks/an-eye-for-an-eye-a-global-history-of-crime-and-punishment.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7924,	1770,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7925,	1770,	'_edit_lock',	'1451483456:1'),
(7930,	1772,	'_oembed_b59d39c42fc88888fc5cd347c64f957a',	'{{unknown}}'),
(7933,	1772,	'_jd_tweet_this',	'yes'),
(7929,	1772,	'xyz_fbap',	'1'),
(7931,	1772,	'_oembed_7028918a828319a65371b13c4dfef8ed',	'{{unknown}}'),
(7932,	1772,	'_oembed_8ba99b6244f409bc1104f78c886be67d',	'{{unknown}}'),
(7934,	1772,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/child-labor-in-america-a-history.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7935,	1772,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fchild-labor-in-america-a-history.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7936,	1772,	'_wptp_twitter_api',	'a:1:{i:0;s:147:\"Child Labor in America A History http://hotfile.pw/ebooks/child-labor-in-america-a-history.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7937,	1772,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7938,	1772,	'_edit_lock',	'1451483586:1'),
(7939,	1774,	'_edit_last',	'1'),
(7943,	1774,	'_oembed_6902ecfbbf6bb24e5a3e0208c916b803',	'{{unknown}}'),
(7942,	1774,	'xyz_fbap',	'1'),
(7944,	1774,	'_oembed_0143abfe55e29f36946242646c285568',	'{{unknown}}'),
(7945,	1774,	'_oembed_05addfe0d4401f05927c4c58ed6cc104',	'{{unknown}}'),
(7946,	1774,	'_jd_tweet_this',	'yes'),
(7947,	1774,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/quickbooks-2016-allinone-for-dummies.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7948,	1774,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fquickbooks-2016-allinone-for-dummies.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7949,	1774,	'_wptp_twitter_api',	'a:1:{i:0;s:155:\"QuickBooks 2016 AllinOne For Dummies http://hotfile.pw/ebooks/quickbooks-2016-allinone-for-dummies.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7950,	1774,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7951,	1774,	'_edit_lock',	'1451483719:1'),
(7952,	1776,	'_edit_last',	'1'),
(7956,	1776,	'_oembed_6e499b1449befd1e8458c2c92de0c5f3',	'{{unknown}}'),
(7957,	1776,	'_oembed_ae6576e0418a3daf608718019ce73402',	'{{unknown}}'),
(7955,	1776,	'xyz_fbap',	'1'),
(7958,	1776,	'_oembed_6fd1e67da0eefd5e4c126a663bf1c390',	'{{unknown}}'),
(7959,	1776,	'_jd_tweet_this',	'yes'),
(7960,	1776,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/rethinking-economic-growth-theory-from-a-biophysical-perspective.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7961,	1776,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Frethinking-economic-growth-theory-from-a-biophysical-perspective.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7962,	1776,	'_wptp_twitter_api',	'a:1:{i:0;s:211:\"Rethinking Economic Growth Theory From a Biophysical Perspective http://hotfile.pw/ebooks/rethinking-economic-growth-theory-from-a-biophysical-perspective.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7963,	1776,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7964,	1776,	'_edit_lock',	'1451483852:1'),
(7965,	1778,	'_edit_last',	'1'),
(7969,	1778,	'_oembed_91bf9ca3791d1ea3031b2482ec7fa6d7',	'{{unknown}}'),
(7970,	1778,	'_oembed_042abbfc4875c1dcb6e318db8bb0463a',	'{{unknown}}'),
(7968,	1778,	'xyz_fbap',	'1'),
(7971,	1778,	'_oembed_f6af1c9cf67535c3600ba3d66e58e6c8',	'{{unknown}}'),
(7989,	1781,	'_oembed_ba63aa6c8b1fdde805883f2b1af64070',	'{{unknown}}'),
(7985,	1781,	'_edit_last',	'1'),
(18155,	3300,	'_jd_tweet_this',	'yes'),
(18150,	3300,	'xyz_fbap',	'1'),
(18151,	3300,	'_oembed_e221091ec5697f21c3fbc378aefb4826',	'{{unknown}}'),
(18147,	3300,	'_edit_last',	'1'),
(18146,	3298,	'_edit_lock',	'1451642196:1'),
(18145,	3298,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(18144,	3298,	'_wptp_twitter_api',	'a:1:{i:0;s:157:\"Axommsoft Tiff Split Merge 13 Build 10 http://hotfile.pw/apps/axommsoft-tiff-split-merge-13-build-10.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(18143,	3298,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fapps%2Faxommsoft-tiff-split-merge-13-build-10.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7992,	1781,	'_jd_tweet_this',	'yes'),
(7988,	1781,	'xyz_fbap',	'1'),
(7990,	1781,	'_oembed_c044a87b3d550a72791cce8a2f026c7b',	'{{unknown}}'),
(7991,	1781,	'_oembed_7f07cc8cae7aeaaa21fee3fd1dc0612b',	'{{unknown}}'),
(7993,	1781,	'_wp_jd_wp',	'http://hotfile.pw/mac/split-screen-v34-mac-osx.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(7994,	1781,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fmac%2Fsplit-screen-v34-mac-osx.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(7995,	1781,	'_wptp_twitter_api',	'a:1:{i:0;s:128:\"Split Screen v34 Mac OSX http://hotfile.pw/mac/split-screen-v34-mac-osx.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(7996,	1781,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(7997,	1781,	'_edit_lock',	'1451484146:1'),
(7998,	1783,	'_edit_last',	'1'),
(8002,	1783,	'_oembed_49efa7649257191e1705e9e2cf0f04a2',	'{{unknown}}'),
(8003,	1783,	'_oembed_b8d18ee82311cdd8e706d246a1c2189c',	'{{unknown}}'),
(8001,	1783,	'xyz_fbap',	'1'),
(8004,	1783,	'_oembed_305d4c6ab3957eb1ad9e5de41c846988',	'{{unknown}}'),
(8005,	1783,	'_jd_tweet_this',	'yes'),
(8006,	1783,	'_wp_jd_wp',	'http://hotfile.pw/tuts/stereo-conversion-from-a-2d-movie-to-3d-masterpiece-in-nuke.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8007,	1783,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Ftuts%2Fstereo-conversion-from-a-2d-movie-to-3d-masterpiece-in-nuke.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8008,	1783,	'_wptp_twitter_api',	'a:1:{i:0;s:199:\"Stereo Conversion from a 2D Movie to 3D Masterpiece in Nuke http://hotfile.pw/tuts/stereo-conversion-from-a-2d-movie-to-3d-masterpiece-in-nuke.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8009,	1783,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8010,	1783,	'_edit_lock',	'1451484276:1'),
(8011,	1785,	'_edit_last',	'1'),
(8015,	1785,	'_oembed_eb4808722227c89abf3acd9b455ed83a',	'{{unknown}}'),
(8017,	1785,	'_oembed_0720a510691a112beb7a73c1a15b0b3d',	'{{unknown}}'),
(8014,	1785,	'xyz_fbap',	'1'),
(8016,	1785,	'_oembed_eb7f00160dfcdd147e21a755d5600cac',	'{{unknown}}'),
(8018,	1785,	'_jd_tweet_this',	'yes'),
(8019,	1785,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/how-to-be-a-graphic-designer-without-losing-your-soul.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8020,	1785,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fhow-to-be-a-graphic-designer-without-losing-your-soul.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8021,	1785,	'_wptp_twitter_api',	'a:1:{i:0;s:189:\"How To Be a Graphic Designer Without Losing Your Soul http://hotfile.pw/ebooks/how-to-be-a-graphic-designer-without-losing-your-soul.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8022,	1785,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8023,	1785,	'_edit_lock',	'1451484407:1'),
(8024,	1787,	'_edit_last',	'1'),
(8028,	1787,	'_oembed_fb400af436507f74bf3791dcfb31367b',	'{{unknown}}'),
(8030,	1787,	'_oembed_3c0d0df5acae7fee62a29c7ea1bc8c44',	'{{unknown}}'),
(8027,	1787,	'xyz_fbap',	'1'),
(8029,	1787,	'_oembed_da23252be0dafa41d93d7666f5c04cb6',	'{{unknown}}'),
(8031,	1787,	'_jd_tweet_this',	'yes'),
(8032,	1787,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/a-perfect-pints-beer-guide-to-the-heartland.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8033,	1787,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fa-perfect-pints-beer-guide-to-the-heartland.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8034,	1787,	'_wptp_twitter_api',	'a:1:{i:0;s:169:\"A Perfect Pints Beer Guide to the Heartland http://hotfile.pw/ebooks/a-perfect-pints-beer-guide-to-the-heartland.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8035,	1787,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8036,	1787,	'_edit_lock',	'1451484537:1'),
(8037,	1789,	'_edit_last',	'1'),
(8041,	1789,	'_oembed_2b74b539d2632b9a9f6aeca0e296cb15',	'{{unknown}}'),
(8043,	1789,	'_oembed_42b958ccee90ba4689985b5c9928bbd6',	'{{unknown}}'),
(8040,	1789,	'xyz_fbap',	'1'),
(8042,	1789,	'_oembed_b0bd8b8680cd0c0331f68c0ddcaef895',	'{{unknown}}'),
(8044,	1789,	'_jd_tweet_this',	'yes'),
(8045,	1789,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/standards-for-the-assessment-of-reading-and-writing.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8046,	1789,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fstandards-for-the-assessment-of-reading-and-writing.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8047,	1789,	'_wptp_twitter_api',	'a:1:{i:0;s:185:\"Standards for the Assessment of Reading and Writing http://hotfile.pw/ebooks/standards-for-the-assessment-of-reading-and-writing.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8048,	1789,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8049,	1789,	'_edit_lock',	'1451484669:1'),
(8050,	1791,	'_edit_last',	'1'),
(8054,	1791,	'_oembed_f3d15363562caf8720e5a916b497357c',	'{{unknown}}'),
(8053,	1791,	'xyz_fbap',	'1'),
(8055,	1791,	'_oembed_f4deaf067bb296e872d51a0b5bd4f831',	'{{unknown}}'),
(8056,	1791,	'_oembed_8251f18fc0bff2ce1ac518b2450871f7',	'{{unknown}}'),
(8057,	1791,	'_jd_tweet_this',	'yes'),
(8058,	1791,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/sales-promotion-decision-making-concepts-principles-and-practice.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8059,	1791,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fsales-promotion-decision-making-concepts-principles-and-practice.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8060,	1791,	'_wptp_twitter_api',	'a:1:{i:0;s:211:\"Sales Promotion Decision Making concepts principles and practice http://hotfile.pw/ebooks/sales-promotion-decision-making-concepts-principles-and-practice.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8061,	1791,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8062,	1791,	'_edit_lock',	'1451484801:1'),
(8063,	1793,	'_edit_last',	'1'),
(8067,	1793,	'_oembed_1db6a4fd09f5d1489e97a5d29aa2d95a',	'{{unknown}}'),
(8069,	1793,	'_oembed_4283797c0aa1429a92e854550074a5a5',	'{{unknown}}'),
(8066,	1793,	'xyz_fbap',	'1'),
(8068,	1793,	'_oembed_fc34d064e2a7068c8682db0c42bc5cde',	'{{unknown}}'),
(8070,	1793,	'_jd_tweet_this',	'yes'),
(8071,	1793,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-little-coffee-knowitall-a-miscellany-for-growing-roasting-and-brewing-uncomp.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8072,	1793,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-little-coffee-knowitall-a-miscellany-for-growing-roasting-and-brewing-uncomp.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8073,	1793,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"The Little Coffee KnowItAll A Miscellany for growing roasting and brewing uncomp... http://hotfile.pw/ebooks/the-little-coffee-knowitall-a-miscellany-for-growing-roasting-and-brewing-uncomp.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8074,	1793,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8075,	1793,	'_edit_lock',	'1451484936:1'),
(8076,	1795,	'_edit_last',	'1'),
(8080,	1795,	'_oembed_639b1245d1e68bde61fd1e1e5f22e81d',	'{{unknown}}'),
(8082,	1795,	'_oembed_8be4cab9981e4f091978be5dbee76fc1',	'{{unknown}}'),
(8079,	1795,	'xyz_fbap',	'1'),
(8081,	1795,	'_oembed_f9719d50ffc28415a44488ecf5fc2411',	'{{unknown}}'),
(8083,	1795,	'_jd_tweet_this',	'yes'),
(8084,	1795,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/exploring-the-labyrinth-a-guide-for-healing-and-spiritual-growth.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8085,	1795,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fexploring-the-labyrinth-a-guide-for-healing-and-spiritual-growth.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8086,	1795,	'_wptp_twitter_api',	'a:1:{i:0;s:211:\"Exploring the Labyrinth A Guide for Healing and Spiritual Growth http://hotfile.pw/ebooks/exploring-the-labyrinth-a-guide-for-healing-and-spiritual-growth.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8087,	1795,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8088,	1795,	'_edit_lock',	'1451485068:1'),
(8089,	1797,	'_edit_last',	'1'),
(8093,	1797,	'_oembed_0ad9052a527c29a867520a3fbc2201f3',	'{{unknown}}'),
(8095,	1797,	'_oembed_36b902c5011c566333d9d79dbd945337',	'{{unknown}}'),
(8092,	1797,	'xyz_fbap',	'1'),
(8094,	1797,	'_oembed_e6d100067591ef399b2fc87738aeb784',	'{{unknown}}'),
(8096,	1797,	'_jd_tweet_this',	'yes'),
(8097,	1797,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/public-management-in-the-postmodern-era-challenges-and-prospects.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8098,	1797,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fpublic-management-in-the-postmodern-era-challenges-and-prospects.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8099,	1797,	'_wptp_twitter_api',	'a:1:{i:0;s:211:\"Public Management in the Postmodern Era Challenges and Prospects http://hotfile.pw/ebooks/public-management-in-the-postmodern-era-challenges-and-prospects.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8100,	1797,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8101,	1797,	'_edit_lock',	'1451485199:1'),
(8102,	1799,	'_edit_last',	'1'),
(8106,	1799,	'_oembed_6f1ea61a255445d8607a98a3a2783926',	'{{unknown}}'),
(8109,	1799,	'_jd_tweet_this',	'yes'),
(8105,	1799,	'xyz_fbap',	'1'),
(8107,	1799,	'_oembed_03a0016efff351dff921197874165ea2',	'{{unknown}}'),
(8108,	1799,	'_oembed_7b597467bf714ed85513ad2cfe176eb9',	'{{unknown}}'),
(8110,	1799,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/a-history-of-habit-from-aristotle-to-bourdieu.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8111,	1799,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fa-history-of-habit-from-aristotle-to-bourdieu.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8112,	1799,	'_wptp_twitter_api',	'a:1:{i:0;s:173:\"A History of Habit From Aristotle to Bourdieu http://hotfile.pw/ebooks/a-history-of-habit-from-aristotle-to-bourdieu.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8113,	1799,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8114,	1799,	'_edit_lock',	'1451485330:1'),
(8115,	1801,	'_edit_last',	'1'),
(8119,	1801,	'_oembed_37c98e10058cba59210f1442284fe38a',	'{{unknown}}'),
(8121,	1801,	'_oembed_cdab246dcab0def9ff263a7763eab9eb',	'{{unknown}}'),
(8118,	1801,	'xyz_fbap',	'1'),
(8120,	1801,	'_oembed_746039cf2aefae13744e0d1f25d1fe45',	'{{unknown}}'),
(8122,	1801,	'_jd_tweet_this',	'yes'),
(8123,	1801,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/lonely-planet-central-europe-9-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8124,	1801,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Flonely-planet-central-europe-9-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8125,	1801,	'_wptp_twitter_api',	'a:1:{i:0;s:159:\"Lonely Planet Central Europe 9 edition http://hotfile.pw/ebooks/lonely-planet-central-europe-9-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8126,	1801,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8127,	1801,	'_edit_lock',	'1451485461:1'),
(8128,	1803,	'_edit_last',	'1'),
(8132,	1803,	'_oembed_ff19858fe255d3d35084c02a7cc14d68',	'{{unknown}}'),
(8131,	1803,	'xyz_fbap',	'1'),
(8133,	1803,	'_oembed_ce4373acc9a9efebce233b7f0e952a5e',	'{{unknown}}'),
(8134,	1803,	'_jd_tweet_this',	'yes'),
(8135,	1803,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/contemporary-abstract-algebra-7-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8136,	1803,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcontemporary-abstract-algebra-7-edition.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8137,	1803,	'_wptp_twitter_api',	'a:1:{i:0;s:161:\"Contemporary Abstract Algebra 7 edition http://hotfile.pw/ebooks/contemporary-abstract-algebra-7-edition.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8138,	1803,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8139,	1803,	'_edit_lock',	'1451485591:1'),
(8140,	1805,	'_edit_last',	'1'),
(8144,	1805,	'_oembed_a95abd4a849792f5b8cbcfca1370fb30',	'{{unknown}}'),
(8147,	1805,	'_jd_tweet_this',	'yes'),
(8143,	1805,	'xyz_fbap',	'1'),
(8145,	1805,	'_oembed_e028b6c67e07df8562244c074188b8c7',	'{{unknown}}'),
(8146,	1805,	'_oembed_5d29a23d57716697e5df2cc5437b345e',	'{{unknown}}'),
(8148,	1805,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/habit-stacking-97-small-life-changes-that-take-five-minutes-or-less.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8149,	1805,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fhabit-stacking-97-small-life-changes-that-take-five-minutes-or-less.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8150,	1805,	'_wptp_twitter_api',	'a:1:{i:0;s:217:\"Habit Stacking 97 Small Life Changes That Take Five Minutes or Less http://hotfile.pw/ebooks/habit-stacking-97-small-life-changes-that-take-five-minutes-or-less.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8151,	1805,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8152,	1805,	'_edit_lock',	'1451485724:1'),
(8153,	1807,	'_edit_last',	'1'),
(8157,	1807,	'_oembed_aa2b2fc5a85e47af33d39499744661d3',	'{{unknown}}'),
(8156,	1807,	'xyz_fbap',	'1'),
(8158,	1807,	'_oembed_4d5cb5ca9ce99311440d887c8f86cb3d',	'{{unknown}}'),
(8159,	1807,	'_oembed_09a1f58239d01afce035fdbfbcaff9f3',	'{{unknown}}'),
(8177,	1810,	'_oembed_1cb232ac88f15cf6621b18dc45d0a728',	'{{unknown}}'),
(8173,	1810,	'_edit_last',	'1'),
(18141,	3298,	'_jd_tweet_this',	'yes'),
(18139,	3298,	'_oembed_9cae271ef14a6b3e8ec41d619baeee62',	'{{unknown}}'),
(18140,	3298,	'_oembed_7225858ddc799a39087679d573f0e9c4',	'{{unknown}}'),
(18136,	3298,	'xyz_fbap',	'1'),
(18138,	3298,	'_oembed_814f407ec6aa6df18fe90e46af345ce7',	'{{unknown}}'),
(18132,	3296,	'_edit_lock',	'1451642063:1'),
(18133,	3298,	'_edit_last',	'1'),
(18137,	3298,	'_oembed_b3feaffed89889386d3ad712d91da264',	'{{unknown}}'),
(18131,	3296,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(18130,	3296,	'_wptp_twitter_api',	'a:1:{i:0;s:175:\"WinMend Data Recovery 160 Multilingual Portable http://hotfile.pw/apps/winmend-data-recovery-160-multilingual-portable.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8180,	1810,	'_jd_tweet_this',	'yes'),
(8176,	1810,	'xyz_fbap',	'1'),
(8178,	1810,	'_oembed_97e27a26f6af12565cd0a05baac920a1',	'{{unknown}}'),
(8179,	1810,	'_oembed_7562c680ed5932721283de4d87ff2ca3',	'{{unknown}}'),
(8181,	1810,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-oneblock-feast-an-adventure-in-food-from-yard-to-table.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8182,	1810,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-oneblock-feast-an-adventure-in-food-from-yard-to-table.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8183,	1810,	'_wptp_twitter_api',	'a:1:{i:0;s:199:\"The OneBlock Feast An Adventure in Food from Yard to Table http://hotfile.pw/ebooks/the-oneblock-feast-an-adventure-in-food-from-yard-to-table.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8184,	1810,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8185,	1810,	'_edit_lock',	'1451486018:1'),
(8186,	1812,	'_edit_last',	'1'),
(8190,	1812,	'_oembed_9b7db13142dc9ebfb9081f782e7c07e1',	'{{unknown}}'),
(8193,	1812,	'_jd_tweet_this',	'yes'),
(8189,	1812,	'xyz_fbap',	'1'),
(8191,	1812,	'_oembed_5acf5649981da8affa0c5b440664d61f',	'{{unknown}}'),
(8192,	1812,	'_oembed_62fd42b260464a3f05731f489c132907',	'{{unknown}}'),
(8194,	1812,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/statistics-for-big-data-for-dummies.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8195,	1812,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fstatistics-for-big-data-for-dummies.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8196,	1812,	'_wptp_twitter_api',	'a:1:{i:0;s:153:\"Statistics for Big Data For Dummies http://hotfile.pw/ebooks/statistics-for-big-data-for-dummies.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8197,	1812,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8198,	1812,	'_edit_lock',	'1451486151:1'),
(8199,	1814,	'_edit_last',	'1'),
(8203,	1814,	'_oembed_9cf3fadba66a1f41570d38bbedce9dd9',	'{{unknown}}'),
(8206,	1814,	'_jd_tweet_this',	'yes'),
(8202,	1814,	'xyz_fbap',	'1'),
(8204,	1814,	'_oembed_ca70552e53f20071e537a716b6ad3aec',	'{{unknown}}'),
(8205,	1814,	'_oembed_57d43d01af9f6a32a1db4fcbe83da278',	'{{unknown}}'),
(8207,	1814,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/setting-sail-into-the-age-of-digital-local-government.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8208,	1814,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fsetting-sail-into-the-age-of-digital-local-government.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8209,	1814,	'_wptp_twitter_api',	'a:1:{i:0;s:189:\"Setting Sail into the Age of Digital Local Government http://hotfile.pw/ebooks/setting-sail-into-the-age-of-digital-local-government.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8210,	1814,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8211,	1814,	'_edit_lock',	'1451486281:1'),
(8212,	1816,	'_edit_last',	'1'),
(8216,	1816,	'_oembed_02d1fbac186da00c23081cbc656c8cc2',	'{{unknown}}'),
(8219,	1816,	'_jd_tweet_this',	'yes'),
(8215,	1816,	'xyz_fbap',	'1'),
(8217,	1816,	'_oembed_ea9b6fdc35e1a8f75d2adb293247717a',	'{{unknown}}'),
(8218,	1816,	'_oembed_d745719269a4aac59740e1289803844d',	'{{unknown}}'),
(8220,	1816,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/atuls-curries-of-the-world.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8221,	1816,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fatuls-curries-of-the-world.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8222,	1816,	'_wptp_twitter_api',	'a:1:{i:0;s:135:\"Atuls Curries of the World http://hotfile.pw/ebooks/atuls-curries-of-the-world.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8223,	1816,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8224,	1816,	'_edit_lock',	'1451486413:1'),
(8225,	1818,	'_edit_last',	'1'),
(8229,	1818,	'_oembed_3fbe0291e0f377ddf6d10a038721e433',	'{{unknown}}'),
(8231,	1818,	'_oembed_1013fa75be1d504d2b40da32673ee31b',	'{{unknown}}'),
(8228,	1818,	'xyz_fbap',	'1'),
(8230,	1818,	'_oembed_0550354121d50421962df4833a6a9006',	'{{unknown}}'),
(8232,	1818,	'_jd_tweet_this',	'yes'),
(8233,	1818,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/born-fighting-how-the-scotsirish-shaped-america.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8234,	1818,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fborn-fighting-how-the-scotsirish-shaped-america.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8235,	1818,	'_wptp_twitter_api',	'a:1:{i:0;s:177:\"Born Fighting How the ScotsIrish Shaped America http://hotfile.pw/ebooks/born-fighting-how-the-scotsirish-shaped-america.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8236,	1818,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8237,	1818,	'_edit_lock',	'1451486545:1'),
(8238,	1820,	'_edit_last',	'1'),
(8242,	1820,	'_oembed_4956a1368e392faebdb003124c82357f',	'{{unknown}}'),
(8244,	1820,	'_oembed_a09615d9034cfed029aec66aca7bef48',	'{{unknown}}'),
(8241,	1820,	'xyz_fbap',	'1'),
(8243,	1820,	'_oembed_ed95777590d9f7620d3331a86492ebb3',	'{{unknown}}'),
(8245,	1820,	'_jd_tweet_this',	'yes'),
(8246,	1820,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/jamaican-christmas-recipes-21-most-wanted-jamaican-christmas-recipes.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8247,	1820,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fjamaican-christmas-recipes-21-most-wanted-jamaican-christmas-recipes.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8248,	1820,	'_wptp_twitter_api',	'a:1:{i:0;s:219:\"Jamaican Christmas Recipes 21 Most Wanted Jamaican Christmas Recipes http://hotfile.pw/ebooks/jamaican-christmas-recipes-21-most-wanted-jamaican-christmas-recipes.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8249,	1820,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8250,	1820,	'_edit_lock',	'1451486675:1'),
(8251,	1822,	'_edit_last',	'1'),
(8255,	1822,	'_oembed_ae1d5dde40f33b9abfaf4c63c18820d0',	'{{unknown}}'),
(8257,	1822,	'_oembed_22f3c239dc49d318fb603694633cc9ae',	'{{unknown}}'),
(8254,	1822,	'xyz_fbap',	'1'),
(8256,	1822,	'_oembed_8749a6e5260887093e0a97ebcae13b9d',	'{{unknown}}'),
(8258,	1822,	'_jd_tweet_this',	'yes'),
(8259,	1822,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/acoustics-of-multiuse-performing-arts-centers.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8260,	1822,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Facoustics-of-multiuse-performing-arts-centers.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8261,	1822,	'_wptp_twitter_api',	'a:1:{i:0;s:173:\"Acoustics of MultiUse Performing Arts Centers http://hotfile.pw/ebooks/acoustics-of-multiuse-performing-arts-centers.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8262,	1822,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8263,	1822,	'_edit_lock',	'1451486808:1'),
(8264,	1824,	'_edit_last',	'1'),
(8268,	1824,	'_oembed_8dcae776000ff530dd01fea329234265',	'{{unknown}}'),
(8271,	1824,	'_jd_tweet_this',	'yes'),
(8267,	1824,	'xyz_fbap',	'1'),
(8269,	1824,	'_oembed_264d3f2bf06d4d2a658c5b2b349189a9',	'{{unknown}}'),
(8270,	1824,	'_oembed_1e04c63d2d0da8eb009d382a50306f9a',	'{{unknown}}'),
(8272,	1824,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/cats-are-weird-and-more-observations.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8273,	1824,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcats-are-weird-and-more-observations.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8274,	1824,	'_wptp_twitter_api',	'a:1:{i:0;s:155:\"Cats are Weird and More Observations http://hotfile.pw/ebooks/cats-are-weird-and-more-observations.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8275,	1824,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8276,	1824,	'_edit_lock',	'1451486941:1'),
(8277,	1826,	'_edit_last',	'1'),
(8281,	1826,	'_oembed_c8322963b57336939357aafcaec07458',	'{{unknown}}'),
(8284,	1826,	'_jd_tweet_this',	'yes'),
(8280,	1826,	'xyz_fbap',	'1'),
(8282,	1826,	'_oembed_9b9c55613068fc94cb9223a17d3d395c',	'{{unknown}}'),
(8283,	1826,	'_oembed_2c9573f1290d6b1d04beb30626b005ff',	'{{unknown}}'),
(8285,	1826,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/data-resource-guide-managing-the-data-resource-data-data-resource-simplexity-boo.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8286,	1826,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fdata-resource-guide-managing-the-data-resource-data-data-resource-simplexity-boo.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8287,	1826,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"Data Resource Guide Managing the Data Resource Data Data Resource Simplexity Boo... http://hotfile.pw/ebooks/data-resource-guide-managing-the-data-resource-data-data-resource-simplexity-boo.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8288,	1826,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8289,	1826,	'_edit_lock',	'1451487073:1'),
(8290,	1828,	'_edit_last',	'1'),
(8294,	1828,	'_oembed_a32cd7a1bbc2ff9bfbeff54731c3d76e',	'{{unknown}}'),
(8297,	1828,	'_jd_tweet_this',	'yes'),
(8293,	1828,	'xyz_fbap',	'1'),
(8295,	1828,	'_oembed_ba7d73a9d00f300b8c3c67a2c7967182',	'{{unknown}}'),
(8296,	1828,	'_oembed_e567e598dc860831e1572607c2967de8',	'{{unknown}}'),
(8298,	1828,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/lectures-on-light-nonlinear-and-quantum-optics-using-the-density-matrix.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8299,	1828,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Flectures-on-light-nonlinear-and-quantum-optics-using-the-density-matrix.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8300,	1828,	'_wptp_twitter_api',	'a:1:{i:0;s:225:\"Lectures on Light Nonlinear and Quantum Optics using the Density Matrix http://hotfile.pw/ebooks/lectures-on-light-nonlinear-and-quantum-optics-using-the-density-matrix.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8301,	1828,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8302,	1828,	'_edit_lock',	'1451487207:1'),
(8303,	1830,	'_edit_last',	'1'),
(8307,	1830,	'_oembed_66587e85e8c2e46715c32366bda2fce8',	'{{unknown}}'),
(8310,	1830,	'_jd_tweet_this',	'yes'),
(8306,	1830,	'xyz_fbap',	'1'),
(8308,	1830,	'_oembed_42d46270db34452aeed6ccc02d4b7679',	'{{unknown}}'),
(8309,	1830,	'_oembed_75b028dc3054d0d3b95f13b236b0f622',	'{{unknown}}'),
(8311,	1830,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-pathworkings-of-aleister-crowley-the-treasure-house-of-images.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8312,	1830,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-pathworkings-of-aleister-crowley-the-treasure-house-of-images.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8313,	1830,	'_wptp_twitter_api',	'a:1:{i:0;s:213:\"The Pathworkings of Aleister Crowley The Treasure House of Images http://hotfile.pw/ebooks/the-pathworkings-of-aleister-crowley-the-treasure-house-of-images.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8314,	1830,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8315,	1830,	'_edit_lock',	'1451487339:1'),
(8316,	1832,	'_edit_last',	'1'),
(8320,	1832,	'_oembed_13a7003f06c0257270595a709e7be64e',	'{{unknown}}'),
(8323,	1832,	'_jd_tweet_this',	'yes'),
(8319,	1832,	'xyz_fbap',	'1'),
(8321,	1832,	'_oembed_beae2c0637352ba6e5083663de864fee',	'{{unknown}}'),
(8322,	1832,	'_oembed_205fab58fd5888351a35893ab8041e19',	'{{unknown}}'),
(8324,	1832,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/commonsense-consequentialism-wherein-morality-meets-rationality.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8325,	1832,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fcommonsense-consequentialism-wherein-morality-meets-rationality.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8326,	1832,	'_wptp_twitter_api',	'a:1:{i:0;s:209:\"Commonsense Consequentialism Wherein Morality Meets Rationality http://hotfile.pw/ebooks/commonsense-consequentialism-wherein-morality-meets-rationality.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8327,	1832,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8328,	1832,	'_edit_lock',	'1451487471:1'),
(8329,	1834,	'_edit_last',	'1'),
(8333,	1834,	'_oembed_38942f991a5bd0117f8163992992b4ed',	'{{unknown}}'),
(8335,	1834,	'_oembed_6c2cc22454584e8e297d25aff0ea6627',	'{{unknown}}'),
(8332,	1834,	'xyz_fbap',	'1'),
(8334,	1834,	'_oembed_f51dd99969ed20a79c8cba04b65bf978',	'{{unknown}}'),
(8336,	1834,	'_jd_tweet_this',	'yes'),
(8337,	1834,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/the-manchu-way-the-eight-banners-and-ethnic-identity-in-late-imperial-china.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8338,	1834,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fthe-manchu-way-the-eight-banners-and-ethnic-identity-in-late-imperial-china.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8339,	1834,	'_wptp_twitter_api',	'a:1:{i:0;s:233:\"The Manchu Way The Eight Banners and Ethnic Identity in Late Imperial China http://hotfile.pw/ebooks/the-manchu-way-the-eight-banners-and-ethnic-identity-in-late-imperial-china.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8340,	1834,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8341,	1834,	'_edit_lock',	'1451487602:1'),
(8342,	1836,	'_edit_last',	'1'),
(8346,	1836,	'_oembed_ddec833c832c18512437d752b619d875',	'{{unknown}}'),
(8345,	1836,	'xyz_fbap',	'1'),
(8347,	1836,	'_oembed_8b392d27eeb061ea19e70bf93d1208e2',	'{{unknown}}'),
(8348,	1836,	'_oembed_9824d9e7b0f624c88ffb0f0df3e07149',	'{{unknown}}'),
(8366,	1839,	'_oembed_bc9ebcf26b0b6640cdbd52a8188ab4a7',	'{{unknown}}'),
(8362,	1839,	'_edit_last',	'1'),
(18129,	3296,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Fapps%2Fwinmend-data-recovery-160-multilingual-portable.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(18128,	3296,	'_wp_jd_wp',	'http://hotfile.pw/apps/winmend-data-recovery-160-multilingual-portable.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(18126,	3296,	'_oembed_f05687d61fd4fde8e8f1a6a70820db05',	'{{unknown}}'),
(18124,	3296,	'_oembed_3e46092f900666d9a2200220b313da65',	'{{unknown}}'),
(18125,	3296,	'_oembed_aaf1a342f59243510d546bd3d67ef921',	'{{unknown}}'),
(18119,	3296,	'_edit_last',	'1'),
(18123,	3296,	'_oembed_1ecdbf730ea155c37a2d7cec105f1557',	'{{unknown}}'),
(18127,	3296,	'_jd_tweet_this',	'yes'),
(18122,	3296,	'xyz_fbap',	'1'),
(23763,	4093,	'_oembed_9965f1563d986ab2c398f4b30907efd9',	'{{unknown}}'),
(8369,	1839,	'_jd_tweet_this',	'yes'),
(8365,	1839,	'xyz_fbap',	'1'),
(8367,	1839,	'_oembed_69886c83a52b3ed4ec22462d3ff201bd',	'{{unknown}}'),
(8368,	1839,	'_oembed_641c89e75fba4e4387aa9536e3f9e7ee',	'{{unknown}}'),
(8370,	1839,	'_wp_jd_wp',	'http://hotfile.pw/tuts/affordances-and-their-importance-to-ux-practitioners.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8371,	1839,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Ftuts%2Faffordances-and-their-importance-to-ux-practitioners.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8372,	1839,	'_wptp_twitter_api',	'a:1:{i:0;s:185:\"Affordances and Their Importance to UX Practitioners http://hotfile.pw/tuts/affordances-and-their-importance-to-ux-practitioners.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8373,	1839,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8374,	1839,	'_edit_lock',	'1451487898:1'),
(8375,	1841,	'_edit_last',	'1'),
(8379,	1841,	'_oembed_321b54015edcac9003a99d96f5c1bec8',	'{{unknown}}'),
(8382,	1841,	'_jd_tweet_this',	'yes'),
(8378,	1841,	'xyz_fbap',	'1'),
(8380,	1841,	'_oembed_23a8a975cbe882432438fd35cb83dbab',	'{{unknown}}'),
(8381,	1841,	'_oembed_cc1be7d34a1e1519780de77384e05e52',	'{{unknown}}'),
(8383,	1841,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/classical-mathematical-logic-the-semantic-foundations-of-logic.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8384,	1841,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fclassical-mathematical-logic-the-semantic-foundations-of-logic.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8385,	1841,	'_wptp_twitter_api',	'a:1:{i:0;s:207:\"Classical Mathematical Logic The Semantic Foundations of Logic http://hotfile.pw/ebooks/classical-mathematical-logic-the-semantic-foundations-of-logic.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8386,	1841,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8387,	1841,	'_edit_lock',	'1451488032:1'),
(8388,	1843,	'_edit_last',	'1'),
(8392,	1843,	'_oembed_df97a7e9159f419f4d93ca1562fc68e6',	'{{unknown}}'),
(8395,	1843,	'_jd_tweet_this',	'yes'),
(8391,	1843,	'xyz_fbap',	'1'),
(8393,	1843,	'_oembed_c6feef5dfcbb4a7ac3afd85dd6282e29',	'{{unknown}}'),
(8394,	1843,	'_oembed_33f7f87c428b00d6657b40b42ae65f8f',	'{{unknown}}'),
(8396,	1843,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/insomnia-a-clinical-guide-to-assessment-and-treatment.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8397,	1843,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Finsomnia-a-clinical-guide-to-assessment-and-treatment.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8398,	1843,	'_wptp_twitter_api',	'a:1:{i:0;s:189:\"Insomnia A Clinical Guide to Assessment and Treatment http://hotfile.pw/ebooks/insomnia-a-clinical-guide-to-assessment-and-treatment.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8399,	1843,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8400,	1843,	'_edit_lock',	'1451488165:1'),
(8401,	1845,	'_edit_last',	'1'),
(8405,	1845,	'_oembed_1cd66d1bdbdf1571d3ed9eb504e7c250',	'{{unknown}}'),
(8408,	1845,	'_jd_tweet_this',	'yes'),
(8404,	1845,	'xyz_fbap',	'1'),
(8406,	1845,	'_oembed_637f38acc70d54599702bcb504603892',	'{{unknown}}'),
(8407,	1845,	'_oembed_84144584ffc713e45b5a92cf67f15965',	'{{unknown}}'),
(8409,	1845,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/horror-show-guide.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8410,	1845,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fhorror-show-guide.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8411,	1845,	'_wptp_twitter_api',	'a:1:{i:0;s:117:\"Horror Show Guide http://hotfile.pw/ebooks/horror-show-guide.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8412,	1845,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8413,	1845,	'_edit_lock',	'1451488297:1'),
(8414,	1847,	'_edit_last',	'1'),
(8418,	1847,	'_oembed_26f95ed6db807d4b36ba4bf7f49c2c2f',	'{{unknown}}'),
(8421,	1847,	'_jd_tweet_this',	'yes'),
(8417,	1847,	'xyz_fbap',	'1'),
(8419,	1847,	'_oembed_526590bbe6cfcfbfb820c85b3ad0103b',	'{{unknown}}'),
(8420,	1847,	'_oembed_88ce8ff32064f1b1d0f46dca39a49fd3',	'{{unknown}}'),
(8422,	1847,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/climate-change-and-insect-pests.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8423,	1847,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fclimate-change-and-insect-pests.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8424,	1847,	'_wptp_twitter_api',	'a:1:{i:0;s:145:\"Climate Change and Insect Pests http://hotfile.pw/ebooks/climate-change-and-insect-pests.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8425,	1847,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8426,	1847,	'_edit_lock',	'1451488427:1'),
(8427,	1849,	'_edit_last',	'1'),
(8431,	1849,	'_oembed_d343b41b637000eac37b1f2303d2cfcd',	'{{unknown}}'),
(8434,	1849,	'_jd_tweet_this',	'yes'),
(8430,	1849,	'xyz_fbap',	'1'),
(8432,	1849,	'_oembed_41d2e3b5b067bf19208802bc41dc1156',	'{{unknown}}'),
(8433,	1849,	'_oembed_a1eb922e06cfd0180de08d9277926abf',	'{{unknown}}'),
(8435,	1849,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/digital-mayhem-3d-machine-techniques-where-inspiration-techniques-and-digital-ar.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8436,	1849,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fdigital-mayhem-3d-machine-techniques-where-inspiration-techniques-and-digital-ar.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8437,	1849,	'_wptp_twitter_api',	'a:1:{i:0;s:246:\"Digital Mayhem 3D Machine Techniques Where Inspiration Techniques and Digital Ar... http://hotfile.pw/ebooks/digital-mayhem-3d-machine-techniques-where-inspiration-techniques-and-digital-ar.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8438,	1849,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8439,	1849,	'_edit_lock',	'1451488559:1'),
(8440,	1851,	'_edit_last',	'1'),
(8444,	1851,	'_oembed_b6b7af1c7aefcbc124eddf976acf946b',	'{{unknown}}'),
(8445,	1851,	'_oembed_8c00bbc13dc8cac569d62f62f98c5b24',	'{{unknown}}'),
(8443,	1851,	'xyz_fbap',	'1'),
(8446,	1851,	'_jd_tweet_this',	'yes'),
(8447,	1851,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/plato-reader-eight-essential-dialogues.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8448,	1851,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fplato-reader-eight-essential-dialogues.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8449,	1851,	'_wptp_twitter_api',	'a:1:{i:0;s:159:\"Plato Reader Eight Essential Dialogues http://hotfile.pw/ebooks/plato-reader-eight-essential-dialogues.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8450,	1851,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8451,	1851,	'_edit_lock',	'1451488693:1'),
(8452,	1853,	'_edit_last',	'1'),
(8456,	1853,	'_oembed_68ce5104ae12199a9e58d3fe0494032c',	'{{unknown}}'),
(8459,	1853,	'_jd_tweet_this',	'yes'),
(8455,	1853,	'xyz_fbap',	'1'),
(8457,	1853,	'_oembed_bd55bf5d412dc6e69175f98fd6513fdb',	'{{unknown}}'),
(8458,	1853,	'_oembed_302d87e959bfe0a9787ffa81337aa6ec',	'{{unknown}}'),
(8460,	1853,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/measure-theory-and-functional-analysis.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8461,	1853,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fmeasure-theory-and-functional-analysis.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8462,	1853,	'_wptp_twitter_api',	'a:1:{i:0;s:159:\"Measure Theory and Functional Analysis http://hotfile.pw/ebooks/measure-theory-and-functional-analysis.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8463,	1853,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8464,	1853,	'_edit_lock',	'1451488823:1'),
(8465,	1855,	'_edit_last',	'1'),
(8469,	1855,	'_oembed_24668683b2a867b98279801b7ef2f2e0',	'{{unknown}}'),
(8471,	1855,	'_oembed_76939fed465a062647562b7fd6414e1f',	'{{unknown}}'),
(8468,	1855,	'xyz_fbap',	'1'),
(8470,	1855,	'_oembed_0d352ff138123b41b6aa64b9e6110671',	'{{unknown}}'),
(8472,	1855,	'_jd_tweet_this',	'yes'),
(8473,	1855,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/excel-2016-for-windows-pivot-tables.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8474,	1855,	'_wp_jd_target',	'http%3A%2F%2Fhotfile.pw%2Febooks%2Fexcel-2016-for-windows-pivot-tables.html%3Futm_campaign%3D%26utm_medium%3Dtwitter%26utm_source%3Dtwitter'),
(8475,	1855,	'_wptp_twitter_api',	'a:1:{i:0;s:153:\"Excel 2016 for Windows Pivot Tables http://hotfile.pw/ebooks/excel-2016-for-windows-pivot-tables.html?utm_campaign=&utm_medium=twitter&utm_source=twitter\";}'),
(8476,	1855,	'_wptp_status_notifier',	'Tweet posted successfully to your linked twitter account.'),
(8477,	1855,	'_edit_lock',	'1451488954:1'),
(8478,	1857,	'_edit_last',	'1'),
(8482,	1857,	'_oembed_06966b8e07925a36c29461868afa4705',	'{{unknown}}'),
(8484,	1857,	'_oembed_77733d9445a5600dcd05bfbd095a83af',	'{{unknown}}'),
(8481,	1857,	'xyz_fbap',	'1'),
(8483,	1857,	'_oembed_852701c2394493587bb6c1e93b4c16b9',	'{{unknown}}'),
(8485,	1857,	'_jd_tweet_this',	'yes'),
(8486,	1857,	'_wp_jd_wp',	'http://hotfile.pw/ebooks/make-the-most-of-your-time-on-earth-3.html?utm_campaign=&utm_medium=twitter&utm_source=twitter'),
(8487,	1857,	'_wp_jd_t